/* auto-generated, do not modify */
#include "config.h"

#include "fu-wistron-dock-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_wistron_dock_status_code_to_string(FuWistronDockStatusCode val)
{
    if (val == FU_WISTRON_DOCK_STATUS_CODE_ENTER)
        return "enter";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_PREPARE)
        return "prepare";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_UPDATING)
        return "updating";
    if (val == FU_WISTRON_DOCK_STATUS_CODE_COMPLETE)
        return "complete";
    return NULL;
}

const gchar *
fu_wistron_dock_component_idx_to_string(FuWistronDockComponentIdx val)
{
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_MCU)
        return "mcu";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_PD)
        return "pd";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_AUDIO)
        return "audio";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_USB)
        return "usb";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_MST)
        return "mst";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_SPI)
        return "spi";
    if (val == FU_WISTRON_DOCK_COMPONENT_IDX_DOCK)
        return "dock";
    return NULL;
}

const gchar *
fu_wistron_dock_update_phase_to_string(FuWistronDockUpdatePhase val)
{
    if (val == FU_WISTRON_DOCK_UPDATE_PHASE_DOWNLOAD)
        return "download";
    if (val == FU_WISTRON_DOCK_UPDATE_PHASE_DEPLOY)
        return "deploy";
    return NULL;
}
/* getters */
/**
 * fu_struct_wistron_dock_wdit_get_hid_id: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_hid_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wistron_dock_wdit_get_tag_id: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_tag_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_vid: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_vid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_pid: (skip):
 **/
guint16
fu_struct_wistron_dock_wdit_get_pid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_imgmode: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_imgmode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_wistron_dock_wdit_get_update_state: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_update_state(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_wistron_dock_wdit_get_status_code: (skip):
 **/
FuWistronDockStatusCode
fu_struct_wistron_dock_wdit_get_status_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_wistron_dock_wdit_get_composite_version: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_get_composite_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 10, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_get_device_cnt: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_get_device_cnt(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[14];
}

/* setters */
/**
 * fu_struct_wistron_dock_wdit_to_string: (skip):
 **/
static gchar *
fu_struct_wistron_dock_wdit_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("WistronDockWdit:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  hid_id: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_hid_id(st));
    g_string_append_printf(str, "  tag_id: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_tag_id(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_pid(st));
    g_string_append_printf(str, "  imgmode: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_imgmode(st));
    g_string_append_printf(str, "  update_state: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_update_state(st));
    {
        const gchar *tmp = fu_wistron_dock_status_code_to_string(fu_struct_wistron_dock_wdit_get_status_code(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status_code: 0x%x [%s]\n", (guint) fu_struct_wistron_dock_wdit_get_status_code(st), tmp);
        } else {
            g_string_append_printf(str, "  status_code: 0x%x\n", (guint) fu_struct_wistron_dock_wdit_get_status_code(st));
        }
    }
    g_string_append_printf(str, "  composite_version: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_composite_version(st));
    g_string_append_printf(str, "  device_cnt: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_get_device_cnt(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_wistron_dock_wdit_parse: (skip):
 **/
GByteArray *
fu_struct_wistron_dock_wdit_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct WistronDockWdit: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_wistron_dock_wdit_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_wistron_dock_wdit_img_get_comp_id: (skip):
 **/
FuWistronDockComponentIdx
fu_struct_wistron_dock_wdit_img_get_comp_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_mode: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_img_get_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_status: (skip):
 **/
guint8
fu_struct_wistron_dock_wdit_img_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version_build: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version1: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_version2: (skip):
 **/
guint32
fu_struct_wistron_dock_wdit_img_get_version2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_wistron_dock_wdit_img_get_name: (skip):
 **/
gchar *
fu_struct_wistron_dock_wdit_img_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 16, 32, NULL);
}

/* setters */
/**
 * fu_struct_wistron_dock_wdit_img_to_string: (skip):
 **/
static gchar *
fu_struct_wistron_dock_wdit_img_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("WistronDockWditImg:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wistron_dock_component_idx_to_string(fu_struct_wistron_dock_wdit_img_get_comp_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  comp_id: 0x%x [%s]\n", (guint) fu_struct_wistron_dock_wdit_img_get_comp_id(st), tmp);
        } else {
            g_string_append_printf(str, "  comp_id: 0x%x\n", (guint) fu_struct_wistron_dock_wdit_img_get_comp_id(st));
        }
    }
    g_string_append_printf(str, "  mode: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_mode(st));
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_status(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version_build(st));
    g_string_append_printf(str, "  version1: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version1(st));
    g_string_append_printf(str, "  version2: 0x%x\n",
                           (guint) fu_struct_wistron_dock_wdit_img_get_version2(st));
    {
        g_autofree gchar *tmp = fu_struct_wistron_dock_wdit_img_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_wistron_dock_wdit_img_parse: (skip):
 **/
GByteArray *
fu_struct_wistron_dock_wdit_img_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error(error, "invalid struct WistronDockWditImg: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 48);
    str = fu_struct_wistron_dock_wdit_img_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
