#!/bin/sh

exec 2>&1

CAB=fakedevice124.cab
INPUT="/usr/share/installed-tests/fwupd/fakedevice124.bin \
       /usr/share/installed-tests/fwupd/fakedevice124.jcat \
       /usr/share/installed-tests/fwupd/fakedevice124.metainfo.xml"

# ---
echo "Building ${CAB}..."
fwupdtool build-cabinet ${CAB} ${INPUT} --force
rc=$?; if [ $rc != 0 ]; then exit $rc; fi

# ---
echo "Installing ${CAB} cabinet..."
fwupdtool install ${CAB}
rc=$?; if [ $rc != 0 ]; then exit $rc; fi

# ---
echo "Cleaning ${CAB} generated cabinet ..."
rm -f ${CAB}
