/* auto-generated, do not modify */
#include "config.h"

#include "fu-cfu-firmware-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_cfu_offer_component_id_to_string(FuCfuOfferComponentId val)
{
    if (val == FU_CFU_OFFER_COMPONENT_ID_NOT_USED)
        return "not-used";
    if (val == FU_CFU_OFFER_COMPONENT_ID_OFFER_INFORMATION)
        return "offer-information";
    if (val == FU_CFU_OFFER_COMPONENT_ID_OFFER_INFORMATION2)
        return "offer-information2";
    return NULL;
}
/* getters */
/**
 * fu_struct_cfu_payload_get_addr: (skip):
 **/
guint32
fu_struct_cfu_payload_get_addr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_payload_get_size: (skip):
 **/
guint8
fu_struct_cfu_payload_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}

/* setters */
/**
 * fu_struct_cfu_payload_set_addr: (skip):
 **/
void
fu_struct_cfu_payload_set_addr(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_payload_set_size: (skip):
 **/
void
fu_struct_cfu_payload_set_size(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[4] = value;
}
/**
 * fu_struct_cfu_payload_new: (skip):
 **/
GByteArray *
fu_struct_cfu_payload_new(void)
{
    GByteArray *st = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st, 5, 0x0);
    return st;
}
/**
 * fu_struct_cfu_payload_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_payload_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuPayload:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_cfu_payload_get_addr(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_cfu_payload_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_payload_parse: (skip):
 **/
static GByteArray *
fu_struct_cfu_payload_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 5, error)) {
        g_prefix_error(error, "invalid struct CfuPayload: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 5);
    str = fu_struct_cfu_payload_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cfu_payload_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cfu_payload_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cfu_payload_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_cfu_offer_get_segment_number: (skip):
 **/
guint8
fu_struct_cfu_offer_get_segment_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_cfu_offer_get_flags1: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_cfu_offer_get_component_id: (skip):
 **/
FuCfuOfferComponentId
fu_struct_cfu_offer_get_component_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_cfu_offer_get_token: (skip):
 **/
guint8
fu_struct_cfu_offer_get_token(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_cfu_offer_get_version: (skip):
 **/
guint32
fu_struct_cfu_offer_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_get_compat_variant_mask: (skip):
 **/
guint32
fu_struct_cfu_offer_get_compat_variant_mask(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_get_flags2: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[12];
}
/**
 * fu_struct_cfu_offer_get_flags3: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags3(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[13];
}
/**
 * fu_struct_cfu_offer_get_product_id: (skip):
 **/
guint16
fu_struct_cfu_offer_get_product_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cfu_offer_set_segment_number: (skip):
 **/
void
fu_struct_cfu_offer_set_segment_number(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_cfu_offer_set_flags1: (skip):
 **/
void
fu_struct_cfu_offer_set_flags1(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_cfu_offer_set_component_id: (skip):
 **/
void
fu_struct_cfu_offer_set_component_id(GByteArray *st, FuCfuOfferComponentId value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_cfu_offer_set_token: (skip):
 **/
void
fu_struct_cfu_offer_set_token(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_cfu_offer_set_version: (skip):
 **/
void
fu_struct_cfu_offer_set_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_set_compat_variant_mask: (skip):
 **/
void
fu_struct_cfu_offer_set_compat_variant_mask(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_set_flags2: (skip):
 **/
void
fu_struct_cfu_offer_set_flags2(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[12] = value;
}
/**
 * fu_struct_cfu_offer_set_flags3: (skip):
 **/
void
fu_struct_cfu_offer_set_flags3(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[13] = value;
}
/**
 * fu_struct_cfu_offer_set_product_id: (skip):
 **/
void
fu_struct_cfu_offer_set_product_id(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_new: (skip):
 **/
GByteArray *
fu_struct_cfu_offer_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    return st;
}
/**
 * fu_struct_cfu_offer_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_offer_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuOffer:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  segment_number: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_segment_number(st));
    g_string_append_printf(str, "  flags1: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags1(st));
    {
        const gchar *tmp = fu_cfu_offer_component_id_to_string(fu_struct_cfu_offer_get_component_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  component_id: 0x%x [%s]\n", (guint) fu_struct_cfu_offer_get_component_id(st), tmp);
        } else {
            g_string_append_printf(str, "  component_id: 0x%x\n", (guint) fu_struct_cfu_offer_get_component_id(st));
        }
    }
    g_string_append_printf(str, "  token: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_token(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_version(st));
    g_string_append_printf(str, "  compat_variant_mask: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_compat_variant_mask(st));
    g_string_append_printf(str, "  flags2: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags2(st));
    g_string_append_printf(str, "  flags3: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags3(st));
    g_string_append_printf(str, "  product_id: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_product_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_offer_parse: (skip):
 **/
static GByteArray *
fu_struct_cfu_offer_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct CfuOffer: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_cfu_offer_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cfu_offer_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cfu_offer_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cfu_offer_parse(buf, bufsz, offset, error);
}
