/* auto-generated, do not modify */
#include "config.h"

#include "fu-fdt-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_fdt_get_magic: (skip):
 **/
static guint32
fu_struct_fdt_get_magic(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_totalsize: (skip):
 **/
guint32
fu_struct_fdt_get_totalsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_dt_struct: (skip):
 **/
guint32
fu_struct_fdt_get_off_dt_struct(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_dt_strings: (skip):
 **/
guint32
fu_struct_fdt_get_off_dt_strings(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_mem_rsvmap: (skip):
 **/
guint32
fu_struct_fdt_get_off_mem_rsvmap(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_version: (skip):
 **/
guint32
fu_struct_fdt_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_last_comp_version: (skip):
 **/
guint32
fu_struct_fdt_get_last_comp_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_boot_cpuid_phys: (skip):
 **/
guint32
fu_struct_fdt_get_boot_cpuid_phys(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_size_dt_strings: (skip):
 **/
guint32
fu_struct_fdt_get_size_dt_strings(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 32, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_size_dt_struct: (skip):
 **/
guint32
fu_struct_fdt_get_size_dt_struct(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 36, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_set_magic: (skip):
 **/
static void
fu_struct_fdt_set_magic(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_totalsize: (skip):
 **/
void
fu_struct_fdt_set_totalsize(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_dt_struct: (skip):
 **/
void
fu_struct_fdt_set_off_dt_struct(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_dt_strings: (skip):
 **/
void
fu_struct_fdt_set_off_dt_strings(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_mem_rsvmap: (skip):
 **/
void
fu_struct_fdt_set_off_mem_rsvmap(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_version: (skip):
 **/
void
fu_struct_fdt_set_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_last_comp_version: (skip):
 **/
void
fu_struct_fdt_set_last_comp_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_boot_cpuid_phys: (skip):
 **/
void
fu_struct_fdt_set_boot_cpuid_phys(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_size_dt_strings: (skip):
 **/
void
fu_struct_fdt_set_size_dt_strings(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 32, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_size_dt_struct: (skip):
 **/
void
fu_struct_fdt_set_size_dt_struct(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 36, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_new: (skip):
 **/
GByteArray *
fu_struct_fdt_new(void)
{
    GByteArray *st = g_byte_array_sized_new(40);
    fu_byte_array_set_size(st, 40, 0x0);
    fu_struct_fdt_set_magic(st, 0xD00DFEED);
    fu_struct_fdt_set_last_comp_version(st, 2);
    return st;
}
/**
 * fu_struct_fdt_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("Fdt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  totalsize: 0x%x\n",
                           (guint) fu_struct_fdt_get_totalsize(st));
    g_string_append_printf(str, "  off_dt_struct: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_dt_struct(st));
    g_string_append_printf(str, "  off_dt_strings: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_dt_strings(st));
    g_string_append_printf(str, "  off_mem_rsvmap: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_mem_rsvmap(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_fdt_get_version(st));
    g_string_append_printf(str, "  last_comp_version: 0x%x\n",
                           (guint) fu_struct_fdt_get_last_comp_version(st));
    g_string_append_printf(str, "  boot_cpuid_phys: 0x%x\n",
                           (guint) fu_struct_fdt_get_boot_cpuid_phys(st));
    g_string_append_printf(str, "  size_dt_strings: 0x%x\n",
                           (guint) fu_struct_fdt_get_size_dt_strings(st));
    g_string_append_printf(str, "  size_dt_struct: 0x%x\n",
                           (guint) fu_struct_fdt_get_size_dt_struct(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_fdt_parse: (skip):
 **/
static GByteArray *
fu_struct_fdt_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 40, error)) {
        g_prefix_error(error, "invalid struct Fdt: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 40);
    if (fu_struct_fdt_get_magic(st) != 0xD00DFEED) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Fdt.magic was not valid, expected 0xD00DFEED");
        return NULL;
    }
    str = fu_struct_fdt_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fdt_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_fdt_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fdt_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_fdt_validate: (skip):
 **/
static gboolean
fu_struct_fdt_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 40, error)) {
        g_prefix_error(error, "invalid struct Fdt: ");
        return FALSE;
    }
    if (fu_struct_fdt_get_magic(&st) != 0xD00DFEED) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Fdt.magic was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_fdt_validate_bytes: (skip):
 **/
gboolean
fu_struct_fdt_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fdt_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_fdt_reserve_entry_get_address: (skip):
 **/
guint64
fu_struct_fdt_reserve_entry_get_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_get_size: (skip):
 **/
guint64
fu_struct_fdt_reserve_entry_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 8, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_reserve_entry_set_address: (skip):
 **/
void
fu_struct_fdt_reserve_entry_set_address(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_set_size: (skip):
 **/
void
fu_struct_fdt_reserve_entry_set_size(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 8, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_new: (skip):
 **/
GByteArray *
fu_struct_fdt_reserve_entry_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    return st;
}
/**
 * fu_struct_fdt_reserve_entry_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_reserve_entry_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("FdtReserveEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  address: 0x%x\n",
                           (guint) fu_struct_fdt_reserve_entry_get_address(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fdt_reserve_entry_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_fdt_reserve_entry_parse: (skip):
 **/
static GByteArray *
fu_struct_fdt_reserve_entry_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct FdtReserveEntry: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_fdt_reserve_entry_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fdt_reserve_entry_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_fdt_reserve_entry_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fdt_reserve_entry_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_fdt_prop_get_len: (skip):
 **/
guint32
fu_struct_fdt_prop_get_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_get_nameoff: (skip):
 **/
guint32
fu_struct_fdt_prop_get_nameoff(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_prop_set_len: (skip):
 **/
void
fu_struct_fdt_prop_set_len(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_set_nameoff: (skip):
 **/
void
fu_struct_fdt_prop_set_nameoff(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_new: (skip):
 **/
GByteArray *
fu_struct_fdt_prop_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_fdt_prop_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_prop_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("FdtProp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  len: 0x%x\n",
                           (guint) fu_struct_fdt_prop_get_len(st));
    g_string_append_printf(str, "  nameoff: 0x%x\n",
                           (guint) fu_struct_fdt_prop_get_nameoff(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_fdt_prop_parse: (skip):
 **/
GByteArray *
fu_struct_fdt_prop_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct FdtProp: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_fdt_prop_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
