/* auto-generated, do not modify */
#include "config.h"

#include "fu-fmap-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_fmap_get_ver_major: (skip):
 **/
guint8
fu_struct_fmap_get_ver_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_fmap_get_ver_minor: (skip):
 **/
guint8
fu_struct_fmap_get_ver_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_fmap_get_base: (skip):
 **/
guint64
fu_struct_fmap_get_base(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_get_size: (skip):
 **/
guint32
fu_struct_fmap_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_get_name: (skip):
 **/
gchar *
fu_struct_fmap_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 22, 32, NULL);
}
/**
 * fu_struct_fmap_get_nareas: (skip):
 **/
guint16
fu_struct_fmap_get_nareas(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 54, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fmap_set_signature: (skip):
 **/
static gboolean
fu_struct_fmap_set_signature(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in Fmap.signature (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_set_ver_major: (skip):
 **/
void
fu_struct_fmap_set_ver_major(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[8] = value;
}
/**
 * fu_struct_fmap_set_ver_minor: (skip):
 **/
void
fu_struct_fmap_set_ver_minor(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[9] = value;
}
/**
 * fu_struct_fmap_set_base: (skip):
 **/
void
fu_struct_fmap_set_base(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_set_size: (skip):
 **/
void
fu_struct_fmap_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_set_name: (skip):
 **/
gboolean
fu_struct_fmap_set_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 22, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in Fmap.name (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 22, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_set_nareas: (skip):
 **/
void
fu_struct_fmap_set_nareas(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 54, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_new: (skip):
 **/
GByteArray *
fu_struct_fmap_new(void)
{
    GByteArray *st = g_byte_array_sized_new(56);
    fu_byte_array_set_size(st, 56, 0x0);
    fu_struct_fmap_set_signature(st, "__FMAP__", NULL);
    fu_struct_fmap_set_ver_major(st, 0x1);
    fu_struct_fmap_set_ver_minor(st, 0x1);
    return st;
}
/**
 * fu_struct_fmap_to_string: (skip):
 **/
static gchar *
fu_struct_fmap_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("Fmap:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ver_major: 0x%x\n",
                           (guint) fu_struct_fmap_get_ver_major(st));
    g_string_append_printf(str, "  ver_minor: 0x%x\n",
                           (guint) fu_struct_fmap_get_ver_minor(st));
    g_string_append_printf(str, "  base: 0x%x\n",
                           (guint) fu_struct_fmap_get_base(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fmap_get_size(st));
    {
        g_autofree gchar *tmp = fu_struct_fmap_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  nareas: 0x%x\n",
                           (guint) fu_struct_fmap_get_nareas(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_fmap_parse: (skip):
 **/
static GByteArray *
fu_struct_fmap_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 56, error)) {
        g_prefix_error(error, "invalid struct Fmap: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 56);
    if (strncmp((const gchar *) (st->data + 0), "__FMAP__", 8) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Fmap.signature was not valid, expected __FMAP__");
        return NULL;
    }
    str = fu_struct_fmap_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fmap_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_fmap_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fmap_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_fmap_validate: (skip):
 **/
static gboolean
fu_struct_fmap_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 56, error)) {
        g_prefix_error(error, "invalid struct Fmap: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "__FMAP__", 8) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Fmap.signature was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_fmap_validate_bytes: (skip):
 **/
gboolean
fu_struct_fmap_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fmap_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_fmap_area_get_offset: (skip):
 **/
guint32
fu_struct_fmap_area_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_get_size: (skip):
 **/
guint32
fu_struct_fmap_area_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_get_name: (skip):
 **/
gchar *
fu_struct_fmap_area_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 32, NULL);
}
/**
 * fu_struct_fmap_area_get_flags: (skip):
 **/
guint16
fu_struct_fmap_area_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 40, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fmap_area_set_offset: (skip):
 **/
void
fu_struct_fmap_area_set_offset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_set_size: (skip):
 **/
void
fu_struct_fmap_area_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_set_name: (skip):
 **/
gboolean
fu_struct_fmap_area_set_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 8, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FmapArea.name (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_area_set_flags: (skip):
 **/
void
fu_struct_fmap_area_set_flags(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_new: (skip):
 **/
GByteArray *
fu_struct_fmap_area_new(void)
{
    GByteArray *st = g_byte_array_sized_new(42);
    fu_byte_array_set_size(st, 42, 0x0);
    return st;
}
/**
 * fu_struct_fmap_area_to_string: (skip):
 **/
static gchar *
fu_struct_fmap_area_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("FmapArea:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_offset(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_size(st));
    {
        g_autofree gchar *tmp = fu_struct_fmap_area_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_flags(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_fmap_area_parse: (skip):
 **/
static GByteArray *
fu_struct_fmap_area_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 42, error)) {
        g_prefix_error(error, "invalid struct FmapArea: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 42);
    str = fu_struct_fmap_area_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fmap_area_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_fmap_area_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_fmap_area_parse(buf, bufsz, offset, error);
}
