/* auto-generated, do not modify */
#include "config.h"

#include "fu-oprom-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_oprom_get_signature: (skip):
 **/
static guint16
fu_struct_oprom_get_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_image_size: (skip):
 **/
guint16
fu_struct_oprom_get_image_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_init_func_entry_point: (skip):
 **/
guint32
fu_struct_oprom_get_init_func_entry_point(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_subsystem: (skip):
 **/
guint16
fu_struct_oprom_get_subsystem(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_machine_type: (skip):
 **/
guint16
fu_struct_oprom_get_machine_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_compression_type: (skip):
 **/
guint16
fu_struct_oprom_get_compression_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_efi_image_offset: (skip):
 **/
guint16
fu_struct_oprom_get_efi_image_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_pci_header_offset: (skip):
 **/
guint16
fu_struct_oprom_get_pci_header_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_expansion_header_offset: (skip):
 **/
guint16
fu_struct_oprom_get_expansion_header_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_oprom_set_signature: (skip):
 **/
static void
fu_struct_oprom_set_signature(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_image_size: (skip):
 **/
void
fu_struct_oprom_set_image_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_init_func_entry_point: (skip):
 **/
void
fu_struct_oprom_set_init_func_entry_point(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_subsystem: (skip):
 **/
void
fu_struct_oprom_set_subsystem(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_machine_type: (skip):
 **/
void
fu_struct_oprom_set_machine_type(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_compression_type: (skip):
 **/
void
fu_struct_oprom_set_compression_type(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_efi_image_offset: (skip):
 **/
void
fu_struct_oprom_set_efi_image_offset(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_pci_header_offset: (skip):
 **/
void
fu_struct_oprom_set_pci_header_offset(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_expansion_header_offset: (skip):
 **/
void
fu_struct_oprom_set_expansion_header_offset(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_new: (skip):
 **/
GByteArray *
fu_struct_oprom_new(void)
{
    GByteArray *st = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st, 28, 0x0);
    fu_struct_oprom_set_signature(st, 0xAA55);
    fu_struct_oprom_set_pci_header_offset(st, 28);
    return st;
}
/**
 * fu_struct_oprom_to_string: (skip):
 **/
static gchar *
fu_struct_oprom_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("Oprom:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_oprom_get_image_size(st));
    g_string_append_printf(str, "  init_func_entry_point: 0x%x\n",
                           (guint) fu_struct_oprom_get_init_func_entry_point(st));
    g_string_append_printf(str, "  subsystem: 0x%x\n",
                           (guint) fu_struct_oprom_get_subsystem(st));
    g_string_append_printf(str, "  machine_type: 0x%x\n",
                           (guint) fu_struct_oprom_get_machine_type(st));
    g_string_append_printf(str, "  compression_type: 0x%x\n",
                           (guint) fu_struct_oprom_get_compression_type(st));
    g_string_append_printf(str, "  efi_image_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_efi_image_offset(st));
    g_string_append_printf(str, "  pci_header_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_pci_header_offset(st));
    g_string_append_printf(str, "  expansion_header_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_expansion_header_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_oprom_parse: (skip):
 **/
static GByteArray *
fu_struct_oprom_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct Oprom: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 28);
    if (fu_struct_oprom_get_signature(st) != 0xAA55) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Oprom.signature was not valid, expected 0xAA55");
        return NULL;
    }
    str = fu_struct_oprom_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_oprom_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_oprom_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_oprom_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_oprom_validate: (skip):
 **/
static gboolean
fu_struct_oprom_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct Oprom: ");
        return FALSE;
    }
    if (fu_struct_oprom_get_signature(&st) != 0xAA55) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Oprom.signature was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_oprom_validate_bytes: (skip):
 **/
gboolean
fu_struct_oprom_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_oprom_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_oprom_pci_get_signature: (skip):
 **/
static guint32
fu_struct_oprom_pci_get_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_vendor_id: (skip):
 **/
guint16
fu_struct_oprom_pci_get_vendor_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_device_id: (skip):
 **/
guint16
fu_struct_oprom_pci_get_device_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_device_list_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_device_list_pointer(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_structure_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_structure_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_structure_revision: (skip):
 **/
guint8
fu_struct_oprom_pci_get_structure_revision(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[12];
}
/**
 * fu_struct_oprom_pci_get_class_code: (skip):
 **/
guint32
fu_struct_oprom_pci_get_class_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->data + 13, G_BYTE_ORDER);
}
/**
 * fu_struct_oprom_pci_get_image_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_image_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_image_revision: (skip):
 **/
guint16
fu_struct_oprom_pci_get_image_revision(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_code_type: (skip):
 **/
guint8
fu_struct_oprom_pci_get_code_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[20];
}
/**
 * fu_struct_oprom_pci_get_indicator: (skip):
 **/
guint8
fu_struct_oprom_pci_get_indicator(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[21];
}
/**
 * fu_struct_oprom_pci_get_max_runtime_image_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_max_runtime_image_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_conf_util_code_header_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_conf_util_code_header_pointer(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_oprom_pci_set_signature: (skip):
 **/
static void
fu_struct_oprom_pci_set_signature(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_vendor_id: (skip):
 **/
void
fu_struct_oprom_pci_set_vendor_id(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_device_id: (skip):
 **/
void
fu_struct_oprom_pci_set_device_id(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_device_list_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_device_list_pointer(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_structure_length: (skip):
 **/
void
fu_struct_oprom_pci_set_structure_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_structure_revision: (skip):
 **/
void
fu_struct_oprom_pci_set_structure_revision(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[12] = value;
}
/**
 * fu_struct_oprom_pci_set_class_code: (skip):
 **/
void
fu_struct_oprom_pci_set_class_code(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->data + 13, value, G_BYTE_ORDER);
}
/**
 * fu_struct_oprom_pci_set_image_length: (skip):
 **/
void
fu_struct_oprom_pci_set_image_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_image_revision: (skip):
 **/
void
fu_struct_oprom_pci_set_image_revision(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_code_type: (skip):
 **/
void
fu_struct_oprom_pci_set_code_type(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[20] = value;
}
/**
 * fu_struct_oprom_pci_set_indicator: (skip):
 **/
void
fu_struct_oprom_pci_set_indicator(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[21] = value;
}
/**
 * fu_struct_oprom_pci_set_max_runtime_image_length: (skip):
 **/
void
fu_struct_oprom_pci_set_max_runtime_image_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_conf_util_code_header_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_conf_util_code_header_pointer(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_dmtf_clp_entry_point_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_dmtf_clp_entry_point_pointer(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_new: (skip):
 **/
GByteArray *
fu_struct_oprom_pci_new(void)
{
    GByteArray *st = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st, 28, 0x0);
    fu_struct_oprom_pci_set_signature(st, 0x52494350);
    return st;
}
/**
 * fu_struct_oprom_pci_to_string: (skip):
 **/
static gchar *
fu_struct_oprom_pci_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("OpromPci:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_vendor_id(st));
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_device_id(st));
    g_string_append_printf(str, "  device_list_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_device_list_pointer(st));
    g_string_append_printf(str, "  structure_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_structure_length(st));
    g_string_append_printf(str, "  structure_revision: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_structure_revision(st));
    g_string_append_printf(str, "  class_code: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_class_code(st));
    g_string_append_printf(str, "  image_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_image_length(st));
    g_string_append_printf(str, "  image_revision: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_image_revision(st));
    g_string_append_printf(str, "  code_type: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_code_type(st));
    g_string_append_printf(str, "  indicator: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_indicator(st));
    g_string_append_printf(str, "  max_runtime_image_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_max_runtime_image_length(st));
    g_string_append_printf(str, "  conf_util_code_header_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_conf_util_code_header_pointer(st));
    g_string_append_printf(str, "  dmtf_clp_entry_point_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_oprom_pci_parse: (skip):
 **/
static GByteArray *
fu_struct_oprom_pci_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct OpromPci: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 28);
    if (fu_struct_oprom_pci_get_signature(st) != 0x52494350) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant OpromPci.signature was not valid, expected 0x52494350");
        return NULL;
    }
    str = fu_struct_oprom_pci_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_oprom_pci_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_oprom_pci_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_oprom_pci_parse(buf, bufsz, offset, error);
}
