/* auto-generated, do not modify */
#include "config.h"

#include "fu-pefile-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_pe_coff_machine_to_string(FuPeCoffMachine val)
{
    if (val == FU_PE_COFF_MACHINE_UNKNOWN)
        return "unknown";
    if (val == FU_PE_COFF_MACHINE_ALPHA)
        return "alpha";
    if (val == FU_PE_COFF_MACHINE_ALPHA64)
        return "alpha64";
    if (val == FU_PE_COFF_MACHINE_AM33)
        return "am33";
    if (val == FU_PE_COFF_MACHINE_AMD64)
        return "amd64";
    if (val == FU_PE_COFF_MACHINE_ARM)
        return "arm";
    if (val == FU_PE_COFF_MACHINE_ARM64)
        return "arm64";
    if (val == FU_PE_COFF_MACHINE_ARMNT)
        return "armnt";
    if (val == FU_PE_COFF_MACHINE_EBC)
        return "ebc";
    if (val == FU_PE_COFF_MACHINE_I386)
        return "i386";
    if (val == FU_PE_COFF_MACHINE_IA64)
        return "ia64";
    if (val == FU_PE_COFF_MACHINE_LOONGARCH32)
        return "loongarch32";
    if (val == FU_PE_COFF_MACHINE_LOONGARCH64)
        return "loongarch64";
    if (val == FU_PE_COFF_MACHINE_M32R)
        return "m32r";
    if (val == FU_PE_COFF_MACHINE_MIPS16)
        return "mips16";
    if (val == FU_PE_COFF_MACHINE_MIPSFPU)
        return "mipsfpu";
    if (val == FU_PE_COFF_MACHINE_MIPSFPU16)
        return "mipsfpu16";
    if (val == FU_PE_COFF_MACHINE_POWERPC)
        return "powerpc";
    if (val == FU_PE_COFF_MACHINE_POWERPCFP)
        return "powerpcfp";
    if (val == FU_PE_COFF_MACHINE_R4000)
        return "r4000";
    if (val == FU_PE_COFF_MACHINE_RISCV32)
        return "riscv32";
    if (val == FU_PE_COFF_MACHINE_RISCV64)
        return "riscv64";
    if (val == FU_PE_COFF_MACHINE_RISCV128)
        return "riscv128";
    if (val == FU_PE_COFF_MACHINE_SH3)
        return "sh3";
    if (val == FU_PE_COFF_MACHINE_SH3DSP)
        return "sh3dsp";
    if (val == FU_PE_COFF_MACHINE_SH4)
        return "sh4";
    if (val == FU_PE_COFF_MACHINE_SH5)
        return "sh5";
    if (val == FU_PE_COFF_MACHINE_THUMB)
        return "thumb";
    if (val == FU_PE_COFF_MACHINE_WCEMIPSV2)
        return "wcemipsv2";
    return NULL;
}

static const gchar *
fu_pe_coff_magic_to_string(FuPeCoffMagic val)
{
    if (val == FU_PE_COFF_MAGIC_PE32)
        return "pe32";
    if (val == FU_PE_COFF_MAGIC_PE32_PLUS)
        return "pe32-plus";
    return NULL;
}

static const gchar *
fu_fu_coff_subsystem_to_string(FuFuCoffSubsystem val)
{
    if (val == FU_FU_COFF_SUBSYSTEM_UNKNOWN)
        return "unknown";
    if (val == FU_FU_COFF_SUBSYSTEM_NATIVE)
        return "native";
    if (val == FU_FU_COFF_SUBSYSTEM_WINDOWS_GUI)
        return "windows-gui";
    if (val == FU_FU_COFF_SUBSYSTEM_WINDOWS_CUI)
        return "windows-cui";
    if (val == FU_FU_COFF_SUBSYSTEM_OS2_CUI)
        return "os2-cui";
    if (val == FU_FU_COFF_SUBSYSTEM_POSIX_CUI)
        return "posix-cui";
    if (val == FU_FU_COFF_SUBSYSTEM_NATIVE_WINDOWS)
        return "native-windows";
    if (val == FU_FU_COFF_SUBSYSTEM_WINDOWS_CE_GUI)
        return "windows-ce-gui";
    if (val == FU_FU_COFF_SUBSYSTEM_EFI_APPLICATION)
        return "efi-application";
    if (val == FU_FU_COFF_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER)
        return "efi-boot-service-driver";
    if (val == FU_FU_COFF_SUBSYSTEM_EFI_RUNTIME_DRIVER)
        return "efi-runtime-driver";
    if (val == FU_FU_COFF_SUBSYSTEM_EFI_ROM)
        return "efi-rom";
    if (val == FU_FU_COFF_SUBSYSTEM_XBOX)
        return "xbox";
    if (val == FU_FU_COFF_SUBSYSTEM_WINDOWS_BOOT_APPLICATION)
        return "windows-boot-application";
    return NULL;
}
/* getters */
/**
 * fu_struct_pe_dos_header_get_magic: (skip):
 **/
static guint16
fu_struct_pe_dos_header_get_magic(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_dos_header_get_lfanew: (skip):
 **/
guint32
fu_struct_pe_dos_header_get_lfanew(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 60, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_dos_header_to_string: (skip):
 **/
static gchar *
fu_struct_pe_dos_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("PeDosHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  lfanew: 0x%x\n",
                           (guint) fu_struct_pe_dos_header_get_lfanew(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_pe_dos_header_parse: (skip):
 **/
static GByteArray *
fu_struct_pe_dos_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct PeDosHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    if (fu_struct_pe_dos_header_get_magic(st) != 0x5A4D) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant PeDosHeader.magic was not valid, expected 0x5A4D");
        return NULL;
    }
    str = fu_struct_pe_dos_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_dos_header_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_pe_dos_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_pe_dos_header_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_pe_dos_header_validate: (skip):
 **/
static gboolean
fu_struct_pe_dos_header_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct PeDosHeader: ");
        return FALSE;
    }
    if (fu_struct_pe_dos_header_get_magic(&st) != 0x5A4D) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant PeDosHeader.magic was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_pe_dos_header_validate_bytes: (skip):
 **/
gboolean
fu_struct_pe_dos_header_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_pe_dos_header_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_pe_coff_file_header_get_signature: (skip):
 **/
static guint32
fu_struct_pe_coff_file_header_get_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_machine: (skip):
 **/
FuPeCoffMachine
fu_struct_pe_coff_file_header_get_machine(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_number_of_sections: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_number_of_sections(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_pointer_to_symbol_table: (skip):
 **/
guint32
fu_struct_pe_coff_file_header_get_pointer_to_symbol_table(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_number_of_symbols: (skip):
 **/
guint32
fu_struct_pe_coff_file_header_get_number_of_symbols(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_size_of_optional_header: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_size_of_optional_header(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_file_header_get_characteristics: (skip):
 **/
guint16
fu_struct_pe_coff_file_header_get_characteristics(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 22, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_file_header_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_file_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("PeCoffFileHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pe_coff_machine_to_string(fu_struct_pe_coff_file_header_get_machine(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  machine: 0x%x [%s]\n", (guint) fu_struct_pe_coff_file_header_get_machine(st), tmp);
        } else {
            g_string_append_printf(str, "  machine: 0x%x\n", (guint) fu_struct_pe_coff_file_header_get_machine(st));
        }
    }
    g_string_append_printf(str, "  number_of_sections: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_number_of_sections(st));
    g_string_append_printf(str, "  pointer_to_symbol_table: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_pointer_to_symbol_table(st));
    g_string_append_printf(str, "  number_of_symbols: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_number_of_symbols(st));
    g_string_append_printf(str, "  size_of_optional_header: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_size_of_optional_header(st));
    g_string_append_printf(str, "  characteristics: 0x%x\n",
                           (guint) fu_struct_pe_coff_file_header_get_characteristics(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_pe_coff_file_header_parse: (skip):
 **/
static GByteArray *
fu_struct_pe_coff_file_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error(error, "invalid struct PeCoffFileHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 24);
    if (fu_struct_pe_coff_file_header_get_signature(st) != 0x4550) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant PeCoffFileHeader.signature was not valid, expected 0x4550");
        return NULL;
    }
    str = fu_struct_pe_coff_file_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_file_header_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_pe_coff_file_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_pe_coff_file_header_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_pe_coff_optional_header64_get_magic: (skip):
 **/
FuPeCoffMagic
fu_struct_pe_coff_optional_header64_get_magic(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_code: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_initialized_data: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_initialized_data(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_addressofentrypoint: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_addressofentrypoint(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_base_of_code: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_base_of_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_image_base: (skip):
 **/
guint64
fu_struct_pe_coff_optional_header64_get_image_base(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_section_alignment: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_section_alignment(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_file_alignment: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_file_alignment(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_image: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_image(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 56, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_size_of_headers: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_size_of_headers(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 60, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_check_sum: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_check_sum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 64, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_subsystem: (skip):
 **/
FuFuCoffSubsystem
fu_struct_pe_coff_optional_header64_get_subsystem(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 68, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_loader_flags: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_loader_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 104, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes: (skip):
 **/
guint32
fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 108, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_optional_header64_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_optional_header64_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("PeCoffOptionalHeader64:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_pe_coff_magic_to_string(fu_struct_pe_coff_optional_header64_get_magic(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  magic: 0x%x [%s]\n", (guint) fu_struct_pe_coff_optional_header64_get_magic(st), tmp);
        } else {
            g_string_append_printf(str, "  magic: 0x%x\n", (guint) fu_struct_pe_coff_optional_header64_get_magic(st));
        }
    }
    g_string_append_printf(str, "  size_of_code: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_code(st));
    g_string_append_printf(str, "  size_of_initialized_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_initialized_data(st));
    g_string_append_printf(str, "  size_of_uninitialized_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_uninitialized_data(st));
    g_string_append_printf(str, "  addressofentrypoint: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_addressofentrypoint(st));
    g_string_append_printf(str, "  base_of_code: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_base_of_code(st));
    g_string_append_printf(str, "  image_base: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_image_base(st));
    g_string_append_printf(str, "  section_alignment: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_section_alignment(st));
    g_string_append_printf(str, "  file_alignment: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_file_alignment(st));
    g_string_append_printf(str, "  size_of_image: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_image(st));
    g_string_append_printf(str, "  size_of_headers: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_size_of_headers(st));
    g_string_append_printf(str, "  check_sum: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_check_sum(st));
    {
        const gchar *tmp = fu_fu_coff_subsystem_to_string(fu_struct_pe_coff_optional_header64_get_subsystem(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  subsystem: 0x%x [%s]\n", (guint) fu_struct_pe_coff_optional_header64_get_subsystem(st), tmp);
        } else {
            g_string_append_printf(str, "  subsystem: 0x%x\n", (guint) fu_struct_pe_coff_optional_header64_get_subsystem(st));
        }
    }
    g_string_append_printf(str, "  loader_flags: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_loader_flags(st));
    g_string_append_printf(str, "  number_of_rva_and_sizes: 0x%x\n",
                           (guint) fu_struct_pe_coff_optional_header64_get_number_of_rva_and_sizes(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_pe_coff_optional_header64_parse: (skip):
 **/
static GByteArray *
fu_struct_pe_coff_optional_header64_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 112, error)) {
        g_prefix_error(error, "invalid struct PeCoffOptionalHeader64: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 112);
    str = fu_struct_pe_coff_optional_header64_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_optional_header64_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_pe_coff_optional_header64_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_pe_coff_optional_header64_parse(buf, bufsz, offset, error);
}
/* getters */

/* setters */
/* getters */
/**
 * fu_struct_pe_coff_section_get_name: (skip):
 **/
gchar *
fu_struct_pe_coff_section_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 8, NULL);
}
/**
 * fu_struct_pe_coff_section_get_virtual_size: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_virtual_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_virtual_address: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_virtual_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_size_of_raw_data: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_size_of_raw_data(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_pointer_to_raw_data: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_pointer_to_raw_data(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_pe_coff_section_get_characteristics: (skip):
 **/
guint32
fu_struct_pe_coff_section_get_characteristics(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 36, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_pe_coff_section_to_string: (skip):
 **/
static gchar *
fu_struct_pe_coff_section_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("PeCoffSection:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_pe_coff_section_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  virtual_size: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_virtual_size(st));
    g_string_append_printf(str, "  virtual_address: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_virtual_address(st));
    g_string_append_printf(str, "  size_of_raw_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_size_of_raw_data(st));
    g_string_append_printf(str, "  pointer_to_raw_data: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_pointer_to_raw_data(st));
    g_string_append_printf(str, "  characteristics: 0x%x\n",
                           (guint) fu_struct_pe_coff_section_get_characteristics(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_pe_coff_section_parse: (skip):
 **/
static GByteArray *
fu_struct_pe_coff_section_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 40, error)) {
        g_prefix_error(error, "invalid struct PeCoffSection: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 40);
    str = fu_struct_pe_coff_section_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_pe_coff_section_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_pe_coff_section_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_pe_coff_section_parse(buf, bufsz, offset, error);
}
