/* auto-generated, do not modify */
#include "config.h"

#include "fu-usb-device-ds20-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_ds20_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_ds20_get_guid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 1);
}
/**
 * fu_struct_ds20_get_platform_ver: (skip):
 **/
guint32
fu_struct_ds20_get_platform_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 17, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_get_total_length: (skip):
 **/
guint16
fu_struct_ds20_get_total_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 21, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_get_vendor_code: (skip):
 **/
guint8
fu_struct_ds20_get_vendor_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[23];
}
/**
 * fu_struct_ds20_get_alt_code: (skip):
 **/
guint8
fu_struct_ds20_get_alt_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[24];
}

/* setters */
/**
 * fu_struct_ds20_set_guid: (skip):
 **/
void
fu_struct_ds20_set_guid(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 1, value, sizeof(*value));
}
/**
 * fu_struct_ds20_set_platform_ver: (skip):
 **/
void
fu_struct_ds20_set_platform_ver(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 17, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_set_total_length: (skip):
 **/
void
fu_struct_ds20_set_total_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 21, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ds20_set_vendor_code: (skip):
 **/
void
fu_struct_ds20_set_vendor_code(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[23] = value;
}
/**
 * fu_struct_ds20_set_alt_code: (skip):
 **/
void
fu_struct_ds20_set_alt_code(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[24] = value;
}
/**
 * fu_struct_ds20_new: (skip):
 **/
GByteArray *
fu_struct_ds20_new(void)
{
    GByteArray *st = g_byte_array_sized_new(25);
    fu_byte_array_set_size(st, 25, 0x0);
    return st;
}
/**
 * fu_struct_ds20_to_string: (skip):
 **/
static gchar *
fu_struct_ds20_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("Ds20:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_ds20_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    g_string_append_printf(str, "  platform_ver: 0x%x\n",
                           (guint) fu_struct_ds20_get_platform_ver(st));
    g_string_append_printf(str, "  total_length: 0x%x\n",
                           (guint) fu_struct_ds20_get_total_length(st));
    g_string_append_printf(str, "  vendor_code: 0x%x\n",
                           (guint) fu_struct_ds20_get_vendor_code(st));
    g_string_append_printf(str, "  alt_code: 0x%x\n",
                           (guint) fu_struct_ds20_get_alt_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ds20_parse: (skip):
 **/
static GByteArray *
fu_struct_ds20_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 25, error)) {
        g_prefix_error(error, "invalid struct Ds20: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 25);
    str = fu_struct_ds20_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ds20_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ds20_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ds20_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ms_ds20_get_size: (skip):
 **/
guint16
fu_struct_ms_ds20_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_get_type: (skip):
 **/
guint16
fu_struct_ms_ds20_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ms_ds20_set_size: (skip):
 **/
void
fu_struct_ms_ds20_set_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_set_type: (skip):
 **/
void
fu_struct_ms_ds20_set_type(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ms_ds20_new: (skip):
 **/
GByteArray *
fu_struct_ms_ds20_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    return st;
}
/**
 * fu_struct_ms_ds20_to_string: (skip):
 **/
static gchar *
fu_struct_ms_ds20_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("MsDs20:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_ms_ds20_get_size(st));
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_ms_ds20_get_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ms_ds20_parse: (skip):
 **/
static GByteArray *
fu_struct_ms_ds20_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct MsDs20: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_ms_ds20_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ms_ds20_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ms_ds20_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ms_ds20_parse(buf, bufsz, offset, error);
}
