/* auto-generated, do not modify */
#include "config.h"

#include "fu-uswid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_uswid_payload_compression_to_string(FuUswidPayloadCompression val)
{
    if (val == FU_USWID_PAYLOAD_COMPRESSION_NONE)
        return "none";
    if (val == FU_USWID_PAYLOAD_COMPRESSION_ZLIB)
        return "zlib";
    if (val == FU_USWID_PAYLOAD_COMPRESSION_LZMA)
        return "lzma";
    return NULL;
}
FuUswidPayloadCompression
fu_uswid_payload_compression_from_string(const gchar *val)
{
    if (g_strcmp0(val, "none") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_NONE;
    if (g_strcmp0(val, "zlib") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_ZLIB;
    if (g_strcmp0(val, "lzma") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_LZMA;
    return FU_USWID_PAYLOAD_COMPRESSION_NONE;
}
/* getters */
/**
 * fu_struct_uswid_get_magic: (skip):
 **/
static const fwupd_guid_t *
fu_struct_uswid_get_magic(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_uswid_get_hdrver: (skip):
 **/
guint8
fu_struct_uswid_get_hdrver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[16];
}
/**
 * fu_struct_uswid_get_hdrsz: (skip):
 **/
guint16
fu_struct_uswid_get_hdrsz(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 17, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_get_payloadsz: (skip):
 **/
guint32
fu_struct_uswid_get_payloadsz(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 19, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_get_flags: (skip):
 **/
guint8
fu_struct_uswid_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[23];
}
/**
 * fu_struct_uswid_get_compression: (skip):
 **/
guint8
fu_struct_uswid_get_compression(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[24];
}

/* setters */
/**
 * fu_struct_uswid_set_magic: (skip):
 **/
static void
fu_struct_uswid_set_magic(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value));
}
/**
 * fu_struct_uswid_set_hdrver: (skip):
 **/
void
fu_struct_uswid_set_hdrver(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[16] = value;
}
/**
 * fu_struct_uswid_set_hdrsz: (skip):
 **/
void
fu_struct_uswid_set_hdrsz(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 17, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_set_payloadsz: (skip):
 **/
void
fu_struct_uswid_set_payloadsz(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 19, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_set_flags: (skip):
 **/
void
fu_struct_uswid_set_flags(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[23] = value;
}
/**
 * fu_struct_uswid_set_compression: (skip):
 **/
void
fu_struct_uswid_set_compression(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[24] = value;
}
/**
 * fu_struct_uswid_new: (skip):
 **/
GByteArray *
fu_struct_uswid_new(void)
{
    GByteArray *st = g_byte_array_sized_new(25);
    fu_byte_array_set_size(st, 25, 0x0);
    fu_struct_uswid_set_magic(st, (fwupd_guid_t *) "\x53\x42\x4F\x4D\xD6\xBA\x2E\xAC\xA3\xE6\x7A\x52\xAA\xEE\x3B\xAF");
    fu_struct_uswid_set_hdrsz(st, 25);
    return st;
}
/**
 * fu_struct_uswid_to_string: (skip):
 **/
static gchar *
fu_struct_uswid_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("Uswid:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  hdrver: 0x%x\n",
                           (guint) fu_struct_uswid_get_hdrver(st));
    g_string_append_printf(str, "  hdrsz: 0x%x\n",
                           (guint) fu_struct_uswid_get_hdrsz(st));
    g_string_append_printf(str, "  payloadsz: 0x%x\n",
                           (guint) fu_struct_uswid_get_payloadsz(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_uswid_get_flags(st));
    g_string_append_printf(str, "  compression: 0x%x\n",
                           (guint) fu_struct_uswid_get_compression(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_uswid_parse: (skip):
 **/
static GByteArray *
fu_struct_uswid_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 25, error)) {
        g_prefix_error(error, "invalid struct Uswid: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 25);
    if (memcmp(st->data + 0, "\x53\x42\x4F\x4D\xD6\xBA\x2E\xAC\xA3\xE6\x7A\x52\xAA\xEE\x3B\xAF", 16) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Uswid.magic was not valid, expected \x53\x42\x4F\x4D\xD6\xBA\x2E\xAC\xA3\xE6\x7A\x52\xAA\xEE\x3B\xAF");
        return NULL;
    }
    str = fu_struct_uswid_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_uswid_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_uswid_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_uswid_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_uswid_validate: (skip):
 **/
static gboolean
fu_struct_uswid_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 25, error)) {
        g_prefix_error(error, "invalid struct Uswid: ");
        return FALSE;
    }
    if (memcmp(fu_struct_uswid_get_magic(&st), "\x53\x42\x4F\x4D\xD6\xBA\x2E\xAC\xA3\xE6\x7A\x52\xAA\xEE\x3B\xAF", 16) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Uswid.magic was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_uswid_validate_bytes: (skip):
 **/
gboolean
fu_struct_uswid_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_uswid_validate(buf, bufsz, offset, error);
}
