/* auto-generated, do not modify */
#include "config.h"

#include "fu-audio-s5gen2-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_qc_opcode_to_string(FuQcOpcode val)
{
    if (val == FU_QC_OPCODE_START_REQ)
        return "start-req";
    if (val == FU_QC_OPCODE_START_CFM)
        return "start-cfm";
    if (val == FU_QC_OPCODE_DATA_BYTES_REQ)
        return "data-bytes-req";
    if (val == FU_QC_OPCODE_DATA)
        return "data";
    if (val == FU_QC_OPCODE_ABORT_REQ)
        return "abort-req";
    if (val == FU_QC_OPCODE_ABORT_CFM)
        return "abort-cfm";
    if (val == FU_QC_OPCODE_TRANSFER_COMPLETE_IND)
        return "transfer-complete-ind";
    if (val == FU_QC_OPCODE_TRANSFER_COMPLETE_RES)
        return "transfer-complete-res";
    if (val == FU_QC_OPCODE_PROCEED_TO_COMMIT)
        return "proceed-to-commit";
    if (val == FU_QC_OPCODE_COMMIT_REQ)
        return "commit-req";
    if (val == FU_QC_OPCODE_COMMIT_CFM)
        return "commit-cfm";
    if (val == FU_QC_OPCODE_ERROR_IND)
        return "error-ind";
    if (val == FU_QC_OPCODE_COMPLETE_IND)
        return "complete-ind";
    if (val == FU_QC_OPCODE_SYNC_REQ)
        return "sync-req";
    if (val == FU_QC_OPCODE_SYNC_CFM)
        return "sync-cfm";
    if (val == FU_QC_OPCODE_START_DATA_REQ)
        return "start-data-req";
    if (val == FU_QC_OPCODE_IS_VALIDATION_DONE_REQ)
        return "is-validation-done-req";
    if (val == FU_QC_OPCODE_IS_VALIDATION_DONE_CFM)
        return "is-validation-done-cfm";
    if (val == FU_QC_OPCODE_HOST_VERSION_REQ)
        return "host-version-req";
    if (val == FU_QC_OPCODE_HOST_VERSION_CFM)
        return "host-version-cfm";
    if (val == FU_QC_OPCODE_ERROR_RES)
        return "error-res";
    return NULL;
}



const gchar *
fu_qc_status_to_string(FuQcStatus val)
{
    if (val == FU_QC_STATUS_SUCCESS)
        return "success";
    if (val == FU_QC_STATUS_UNEXPECTED_ERROR)
        return "unexpected-error";
    if (val == FU_QC_STATUS_ALREADY_CONNECTED_WARNING)
        return "already-connected-warning";
    if (val == FU_QC_STATUS_IN_PROGRESS)
        return "in-progress";
    if (val == FU_QC_STATUS_BUSY)
        return "busy";
    if (val == FU_QC_STATUS_INVALID_POWER_STATE)
        return "invalid-power-state";
    return NULL;
}

const gchar *
fu_qc_resume_point_to_string(FuQcResumePoint val)
{
    if (val == FU_QC_RESUME_POINT_START)
        return "start";
    if (val == FU_QC_RESUME_POINT_PRE_VALIDATE)
        return "pre-validate";
    if (val == FU_QC_RESUME_POINT_PRE_REBOOT)
        return "pre-reboot";
    if (val == FU_QC_RESUME_POINT_POST_REBOOT)
        return "post-reboot";
    if (val == FU_QC_RESUME_POINT_POST_COMMIT)
        return "post-commit";
    return NULL;
}

const gchar *
fu_qc_start_status_to_string(FuQcStartStatus val)
{
    if (val == FU_QC_START_STATUS_SUCCESS)
        return "success";
    if (val == FU_QC_START_STATUS_FAILURE)
        return "failure";
    return NULL;
}


/* getters */

/* setters */
/**
 * fu_struct_qc_connect_req_set_req: (skip):
 **/
static void
fu_struct_qc_connect_req_set_req(GByteArray *st, FuQcReq value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_connect_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_connect_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st, 1, 0x0);
    fu_struct_qc_connect_req_set_req(st, FU_QC_REQ_CONNECT);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_disconnect_req_set_req: (skip):
 **/
static void
fu_struct_qc_disconnect_req_set_req(GByteArray *st, FuQcReq value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_disconnect_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_disconnect_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st, 1, 0x0);
    fu_struct_qc_disconnect_req_set_req(st, FU_QC_REQ_DISCONNECT);
    return st;
}
/* getters */
/**
 * fu_struct_qc_update_status_get_status: (skip):
 **/
FuQcStatus
fu_struct_qc_update_status_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}

/* setters */
/**
 * fu_struct_qc_update_status_to_string: (skip):
 **/
static gchar *
fu_struct_qc_update_status_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcUpdateStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_status_to_string(fu_struct_qc_update_status_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_qc_update_status_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_qc_update_status_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_update_status_parse: (skip):
 **/
GByteArray *
fu_struct_qc_update_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error(error, "invalid struct QcUpdateStatus: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 1);
    str = fu_struct_qc_update_status_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_version_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_version_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_version_req_set_data_len: (skip):
 **/
static void
fu_struct_qc_version_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_version_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_version_req_set_opcode(st, FU_QC_OPCODE_HOST_VERSION_REQ);
    fu_struct_qc_version_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_version_get_status: (skip):
 **/
static FuQcOpcode
fu_struct_qc_version_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_version_get_data_len: (skip):
 **/
static guint16
fu_struct_qc_version_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_major: (skip):
 **/
guint16
fu_struct_qc_version_get_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_minor: (skip):
 **/
guint16
fu_struct_qc_version_get_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 5, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_config: (skip):
 **/
guint16
fu_struct_qc_version_get_config(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 7, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_version_to_string: (skip):
 **/
static gchar *
fu_struct_qc_version_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_qc_version_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_qc_version_get_minor(st));
    g_string_append_printf(str, "  config: 0x%x\n",
                           (guint) fu_struct_qc_version_get_config(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_version_parse: (skip):
 **/
GByteArray *
fu_struct_qc_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 9, error)) {
        g_prefix_error(error, "invalid struct QcVersion: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 9);
    if (fu_struct_qc_version_get_status(st) != FU_QC_OPCODE_HOST_VERSION_CFM) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcVersion.status was not valid, expected FU_QC_OPCODE_HOST_VERSION_CFM");
        return NULL;
    }
    if (fu_struct_qc_version_get_data_len(st) != 0x0006) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcVersion.data_len was not valid, expected 0x0006");
        return NULL;
    }
    str = fu_struct_qc_version_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_abort_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_abort_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_abort_req_set_data_len: (skip):
 **/
void
fu_struct_qc_abort_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_abort_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_abort_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_abort_req_set_opcode(st, FU_QC_OPCODE_ABORT_REQ);
    fu_struct_qc_abort_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_abort_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_abort_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_abort_get_data_len: (skip):
 **/
guint16
fu_struct_qc_abort_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_abort_to_string: (skip):
 **/
static gchar *
fu_struct_qc_abort_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcAbort:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_abort_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_abort_parse: (skip):
 **/
GByteArray *
fu_struct_qc_abort_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error(error, "invalid struct QcAbort: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (fu_struct_qc_abort_get_opcode(st) != FU_QC_OPCODE_ABORT_CFM) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcAbort.opcode was not valid, expected FU_QC_OPCODE_ABORT_CFM");
        return NULL;
    }
    str = fu_struct_qc_abort_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_sync_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_sync_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_sync_req_set_data_len: (skip):
 **/
void
fu_struct_qc_sync_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_req_set_file_id: (skip):
 **/
void
fu_struct_qc_sync_req_set_file_id(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_sync_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(7);
    fu_byte_array_set_size(st, 7, 0x0);
    fu_struct_qc_sync_req_set_opcode(st, FU_QC_OPCODE_SYNC_REQ);
    fu_struct_qc_sync_req_set_data_len(st, 0x04);
    return st;
}
/* getters */
/**
 * fu_struct_qc_sync_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_sync_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_sync_get_data_len: (skip):
 **/
guint16
fu_struct_qc_sync_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_get_resume_point: (skip):
 **/
FuQcResumePoint
fu_struct_qc_sync_get_resume_point(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_qc_sync_get_file_id: (skip):
 **/
guint32
fu_struct_qc_sync_get_file_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_get_protocol_version: (skip):
 **/
guint8
fu_struct_qc_sync_get_protocol_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}

/* setters */
/**
 * fu_struct_qc_sync_to_string: (skip):
 **/
static gchar *
fu_struct_qc_sync_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcSync:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_data_len(st));
    {
        const gchar *tmp = fu_qc_resume_point_to_string(fu_struct_qc_sync_get_resume_point(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  resume_point: 0x%x [%s]\n", (guint) fu_struct_qc_sync_get_resume_point(st), tmp);
        } else {
            g_string_append_printf(str, "  resume_point: 0x%x\n", (guint) fu_struct_qc_sync_get_resume_point(st));
        }
    }
    g_string_append_printf(str, "  file_id: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_file_id(st));
    g_string_append_printf(str, "  protocolVersion: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_protocol_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_sync_parse: (skip):
 **/
GByteArray *
fu_struct_qc_sync_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 9, error)) {
        g_prefix_error(error, "invalid struct QcSync: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 9);
    if (fu_struct_qc_sync_get_opcode(st) != FU_QC_OPCODE_SYNC_CFM) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcSync.opcode was not valid, expected FU_QC_OPCODE_SYNC_CFM");
        return NULL;
    }
    str = fu_struct_qc_sync_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_start_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_start_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_start_req_set_data_len: (skip):
 **/
void
fu_struct_qc_start_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_start_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_start_req_set_opcode(st, FU_QC_OPCODE_START_REQ);
    fu_struct_qc_start_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_start_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_start_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_start_get_data_len: (skip):
 **/
guint16
fu_struct_qc_start_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_get_status: (skip):
 **/
FuQcStartStatus
fu_struct_qc_start_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_qc_start_get_battery_level: (skip):
 **/
guint16
fu_struct_qc_start_get_battery_level(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_start_to_string: (skip):
 **/
static gchar *
fu_struct_qc_start_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcStart:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_start_get_data_len(st));
    {
        const gchar *tmp = fu_qc_start_status_to_string(fu_struct_qc_start_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_qc_start_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_qc_start_get_status(st));
        }
    }
    g_string_append_printf(str, "  battery_level: 0x%x\n",
                           (guint) fu_struct_qc_start_get_battery_level(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_start_parse: (skip):
 **/
GByteArray *
fu_struct_qc_start_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error(error, "invalid struct QcStart: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    if (fu_struct_qc_start_get_opcode(st) != FU_QC_OPCODE_START_CFM) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcStart.opcode was not valid, expected FU_QC_OPCODE_START_CFM");
        return NULL;
    }
    str = fu_struct_qc_start_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_start_data_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_start_data_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_start_data_req_set_data_len: (skip):
 **/
void
fu_struct_qc_start_data_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_data_req_set_data: (skip):
 **/
gboolean
fu_struct_qc_start_data_req_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_qc_start_data_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_start_data_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(253);
    fu_byte_array_set_size(st, 253, 0x0);
    fu_struct_qc_start_data_req_set_opcode(st, FU_QC_OPCODE_START_DATA_REQ);
    fu_struct_qc_start_data_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_data_req_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_data_req_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_data_req_get_data_len: (skip):
 **/
guint16
fu_struct_qc_data_req_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_req_get_fw_data_len: (skip):
 **/
guint32
fu_struct_qc_data_req_get_fw_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 3, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_req_get_fw_data_offset: (skip):
 **/
guint32
fu_struct_qc_data_req_get_fw_data_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 7, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_data_req_to_string: (skip):
 **/
static gchar *
fu_struct_qc_data_req_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcDataReq:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_data_len(st));
    g_string_append_printf(str, "  fw_data_len: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_fw_data_len(st));
    g_string_append_printf(str, "  fw_data_offset: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_fw_data_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_data_req_parse: (skip):
 **/
GByteArray *
fu_struct_qc_data_req_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 11, error)) {
        g_prefix_error(error, "invalid struct QcDataReq: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 11);
    if (fu_struct_qc_data_req_get_opcode(st) != FU_QC_OPCODE_DATA_BYTES_REQ) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcDataReq.opcode was not valid, expected FU_QC_OPCODE_DATA_BYTES_REQ");
        return NULL;
    }
    str = fu_struct_qc_data_req_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_data_set_opcode: (skip):
 **/
static void
fu_struct_qc_data_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_data_set_data_len: (skip):
 **/
void
fu_struct_qc_data_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_set_last_packet: (skip):
 **/
void
fu_struct_qc_data_set_last_packet(GByteArray *st, FuQcMoreData value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_data_set_data: (skip):
 **/
gboolean
fu_struct_qc_data_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 4, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_qc_data_new: (skip):
 **/
GByteArray *
fu_struct_qc_data_new(void)
{
    GByteArray *st = g_byte_array_sized_new(253);
    fu_byte_array_set_size(st, 253, 0x0);
    fu_struct_qc_data_set_opcode(st, FU_QC_OPCODE_DATA);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_validation_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_validation_req_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_validation_req_set_data_len: (skip):
 **/
void
fu_struct_qc_validation_req_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_validation_req_new: (skip):
 **/
GByteArray *
fu_struct_qc_validation_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_validation_req_set_opcode(st, FU_QC_OPCODE_IS_VALIDATION_DONE_REQ);
    fu_struct_qc_validation_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_validation_get_opcode: (skip):
 **/
FuQcOpcode
fu_struct_qc_validation_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_validation_get_data_len: (skip):
 **/
guint16
fu_struct_qc_validation_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_validation_get_delay: (skip):
 **/
guint16
fu_struct_qc_validation_get_delay(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_validation_to_string: (skip):
 **/
static gchar *
fu_struct_qc_validation_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcValidation:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_opcode_to_string(fu_struct_qc_validation_get_opcode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  opcode: 0x%x [%s]\n", (guint) fu_struct_qc_validation_get_opcode(st), tmp);
        } else {
            g_string_append_printf(str, "  opcode: 0x%x\n", (guint) fu_struct_qc_validation_get_opcode(st));
        }
    }
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_validation_get_data_len(st));
    g_string_append_printf(str, "  delay: 0x%x\n",
                           (guint) fu_struct_qc_validation_get_delay(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_validation_parse: (skip):
 **/
GByteArray *
fu_struct_qc_validation_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 5, error)) {
        g_prefix_error(error, "invalid struct QcValidation: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 5);
    str = fu_struct_qc_validation_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_transfer_complete_set_opcode: (skip):
 **/
static void
fu_struct_qc_transfer_complete_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_transfer_complete_set_data_len: (skip):
 **/
void
fu_struct_qc_transfer_complete_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_transfer_complete_set_action: (skip):
 **/
void
fu_struct_qc_transfer_complete_set_action(GByteArray *st, FuQcAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_transfer_complete_new: (skip):
 **/
GByteArray *
fu_struct_qc_transfer_complete_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_transfer_complete_set_opcode(st, FU_QC_OPCODE_TRANSFER_COMPLETE_RES);
    fu_struct_qc_transfer_complete_set_data_len(st, 0x01);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_proceed_to_commit_set_opcode: (skip):
 **/
static void
fu_struct_qc_proceed_to_commit_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_proceed_to_commit_set_data_len: (skip):
 **/
void
fu_struct_qc_proceed_to_commit_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_proceed_to_commit_set_action: (skip):
 **/
void
fu_struct_qc_proceed_to_commit_set_action(GByteArray *st, FuQcAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_proceed_to_commit_new: (skip):
 **/
GByteArray *
fu_struct_qc_proceed_to_commit_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_proceed_to_commit_set_opcode(st, FU_QC_OPCODE_PROCEED_TO_COMMIT);
    fu_struct_qc_proceed_to_commit_set_data_len(st, 0x01);
    return st;
}
/* getters */
/**
 * fu_struct_qc_commit_req_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_commit_req_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_commit_req_get_data_len: (skip):
 **/
guint16
fu_struct_qc_commit_req_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_commit_req_to_string: (skip):
 **/
static gchar *
fu_struct_qc_commit_req_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcCommitReq:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_commit_req_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_commit_req_parse: (skip):
 **/
GByteArray *
fu_struct_qc_commit_req_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error(error, "invalid struct QcCommitReq: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (fu_struct_qc_commit_req_get_opcode(st) != FU_QC_OPCODE_COMMIT_REQ) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcCommitReq.opcode was not valid, expected FU_QC_OPCODE_COMMIT_REQ");
        return NULL;
    }
    str = fu_struct_qc_commit_req_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_commit_cfm_set_opcode: (skip):
 **/
static void
fu_struct_qc_commit_cfm_set_opcode(GByteArray *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_commit_cfm_set_data_len: (skip):
 **/
void
fu_struct_qc_commit_cfm_set_data_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_commit_cfm_set_action: (skip):
 **/
void
fu_struct_qc_commit_cfm_set_action(GByteArray *st, FuQcCommitAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_commit_cfm_new: (skip):
 **/
GByteArray *
fu_struct_qc_commit_cfm_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_commit_cfm_set_opcode(st, FU_QC_OPCODE_COMMIT_CFM);
    fu_struct_qc_commit_cfm_set_data_len(st, 0x01);
    return st;
}
/* getters */
/**
 * fu_struct_qc_complete_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_complete_get_opcode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_complete_get_data_len: (skip):
 **/
guint16
fu_struct_qc_complete_get_data_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_complete_to_string: (skip):
 **/
static gchar *
fu_struct_qc_complete_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("QcComplete:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_complete_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_qc_complete_parse: (skip):
 **/
GByteArray *
fu_struct_qc_complete_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error(error, "invalid struct QcComplete: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (fu_struct_qc_complete_get_opcode(st) != FU_QC_OPCODE_COMPLETE_IND) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant QcComplete.opcode was not valid, expected FU_QC_OPCODE_COMPLETE_IND");
        return NULL;
    }
    str = fu_struct_qc_complete_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
