/* auto-generated, do not modify */
#include "config.h"

#include "fu-aver-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_aver_hid_status_to_string(FuAverHidStatus val)
{
    if (val == FU_AVER_HID_STATUS_READY)
        return "ready";
    if (val == FU_AVER_HID_STATUS_BUSY)
        return "busy";
    if (val == FU_AVER_HID_STATUS_DNLOAD)
        return "dnload";
    if (val == FU_AVER_HID_STATUS_WAITISP)
        return "waitisp";
    if (val == FU_AVER_HID_STATUS_ISPING)
        return "isping";
    if (val == FU_AVER_HID_STATUS_REBOOT)
        return "reboot";
    if (val == FU_AVER_HID_STATUS_FILEERR)
        return "fileerr";
    if (val == FU_AVER_HID_STATUS_POWERISP)
        return "powerisp";
    if (val == FU_AVER_HID_STATUS_VERSION)
        return "version";
    if (val == FU_AVER_HID_STATUS_WAITUSR)
        return "waitusr";
    if (val == FU_AVER_HID_STATUS_STOP)
        return "stop";
    return NULL;
}

const gchar *
fu_aver_hid_custom_isp_cmd_to_string(FuAverHidCustomIspCmd val)
{
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_STATUS)
        return "status";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_FILE_START)
        return "file-start";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_FILE_DNLOAD)
        return "file-dnload";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_FILE_END)
        return "file-end";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_START)
        return "start";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_STOP)
        return "stop";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_RESERVE)
        return "reserve";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_LOG_START)
        return "log-start";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_LOG_UPLOAD)
        return "log-upload";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_ISP_REBOOT)
        return "isp-reboot";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_LOG_END)
        return "log-end";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_ALL_FILE_START)
        return "all-file-start";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_ALL_FILE_DNLOAD)
        return "all-file-dnload";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_ALL_FILE_END)
        return "all-file-end";
    if (val == FU_AVER_HID_CUSTOM_ISP_CMD_ALL_START)
        return "all-start";
    return NULL;
}

const gchar *
fu_aver_safeisp_custom_cmd_to_string(FuAverSafeispCustomCmd val)
{
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_GET_VERSION)
        return "get-version";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_SUPPORT)
        return "support";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_ERASE_TEMP)
        return "erase-temp";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_PREPARE)
        return "upload-prepare";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_COMPARE_CHECKSUM)
        return "upload-compare-checksum";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_CX3)
        return "upload-to-cx3";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_M12MO)
        return "upload-to-m12mo";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_M051)
        return "upload-to-m051";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_TMPM342)
        return "upload-to-tmpm342";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_TMPM342_BOOT)
        return "upload-to-tmpm342-boot";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPDATE_START)
        return "update-start";
    return NULL;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_get_data(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 508;
    return st->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_data: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_isp_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_req_isp_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 3, 0xFF, 508);
    fu_struct_aver_hid_req_isp_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_set_custom_cmd_isp(st, 0x10);
    fu_struct_aver_hid_req_isp_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_to_string: (skip):
 **/
gchar *
fu_struct_aver_hid_req_isp_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("AverHidReqIsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  custom_isp_cmd: 0x%x\n",
                           (guint) fu_struct_aver_hid_req_isp_get_custom_isp_cmd(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_aver_hid_req_isp_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_start_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_file_start_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_file_name: (skip):
 **/
gchar *
fu_struct_aver_hid_req_isp_file_start_get_file_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 52, NULL);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_file_size: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_start_get_file_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 55, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_free_space: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_start_get_free_space(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 59, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_file_name: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_start_set_file_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 3, 0x0, 52);
        return TRUE;
    }
    len = strlen(value);
    if (len > 52) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in AverHidReqIspFileStart.file_name (0x%x bytes)",
                    value, (guint) len, (guint) 52);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 3, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_file_size: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_file_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 55, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_free_space: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_free_space(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 59, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_req_isp_file_start_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 63, 0xFF, 448);
    fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp(st, 0x10);
    fu_struct_aver_hid_req_isp_file_start_set_end(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_dnload_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_file_dnload_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_file_dnload_get_data(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 508;
    return st->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_dnload_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_data: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_dnload_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_req_isp_file_dnload_new(void)
{
    GByteArray *st = g_byte_array_sized_new(511);
    fu_byte_array_set_size(st, 511, 0x0);
    memset(st->data + 3, 0xFF, 508);
    fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp(st, 0x10);
    return st;
}
/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_end_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_file_end_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_file_name: (skip):
 **/
gchar *
fu_struct_aver_hid_req_isp_file_end_get_file_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 51, NULL);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_end_flag: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_file_end_get_end_flag(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[54];
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_file_size: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_end_get_file_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 55, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_free_space: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_end_get_free_space(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 59, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_file_name: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_end_set_file_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 3, 0x0, 51);
        return TRUE;
    }
    len = strlen(value);
    if (len > 51) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in AverHidReqIspFileEnd.file_name (0x%x bytes)",
                    value, (guint) len, (guint) 51);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 3, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_end_flag: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_end_flag(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[54] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_file_size: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_file_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 55, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_free_space: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_free_space(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 59, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_req_isp_file_end_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 63, 0xFF, 448);
    fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp(st, 0x10);
    fu_struct_aver_hid_req_isp_file_end_set_end(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_aver_hid_req_isp_start_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_start_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_start_get_isp_cmd: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_start_get_isp_cmd(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 60;
    return st->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_start_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_start_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_start_set_isp_cmd: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_start_set_isp_cmd(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/* getters */
/**
 * fu_struct_aver_hid_req_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_device_version_get_ver(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->data + 2;
}

/* setters */
/**
 * fu_struct_aver_hid_req_device_version_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_set_ver: (skip):
 **/
gboolean
fu_struct_aver_hid_req_device_version_set_ver(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_device_version_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_req_device_version_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 13, 0xFF, 498);
    fu_struct_aver_hid_req_device_version_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_device_version_set_custom_cmd_isp(st, 0x25);
    fu_struct_aver_hid_req_device_version_set_end(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_aver_hid_res_isp_status_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_report_id_custom_command(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_status_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_status: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_status_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_status_string: (skip):
 **/
gchar *
fu_struct_aver_hid_res_isp_status_get_status_string(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 58, NULL);
}
/**
 * fu_struct_aver_hid_res_isp_status_get_progress: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_status_get_progress(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[62];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_end: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_end(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[511];
}

/* setters */
/**
 * fu_struct_aver_hid_res_isp_status_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_status: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_status(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_status_string: (skip):
 **/
gboolean
fu_struct_aver_hid_res_isp_status_set_status_string(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 4, 0x0, 58);
        return TRUE;
    }
    len = strlen(value);
    if (len > 58) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in AverHidResIspStatus.status_string (0x%x bytes)",
                    value, (guint) len, (guint) 58);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 4, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_res_isp_status_set_progress: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_progress(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[62] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_end: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_res_isp_status_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 63, 0xFF, 448);
    fu_struct_aver_hid_res_isp_status_set_report_id_custom_command(st, 0x09);
    fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp(st, 0x10);
    fu_struct_aver_hid_res_isp_status_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_res_isp_status_validate: (skip):
 **/
gboolean
fu_struct_aver_hid_res_isp_status_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 512, error)) {
        g_prefix_error(error, "invalid struct AverHidResIspStatus: ");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_isp_status_get_report_id_custom_command(&st) != 0x09) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResIspStatus.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp(&st) != 0x10) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResIspStatus.custom_cmd_isp was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_isp_status_get_end(&st) != 0x00) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResIspStatus.end was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_aver_hid_res_isp_get_custom_isp_cmd: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_get_custom_isp_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}

/* setters */
/**
 * fu_struct_aver_hid_res_isp_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_res_isp_set_custom_isp_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/* getters */
/**
 * fu_struct_aver_hid_res_device_version_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_report_id_custom_command(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_aver_hid_res_device_version_get_custom_cmd_isp: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_custom_cmd_isp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_aver_hid_res_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_hid_res_device_version_get_ver(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->data + 2;
}
/**
 * fu_struct_aver_hid_res_device_version_get_end: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_end(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[511];
}

/* setters */
/**
 * fu_struct_aver_hid_res_device_version_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_custom_cmd_isp(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_set_ver: (skip):
 **/
gboolean
fu_struct_aver_hid_res_device_version_set_ver(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_res_device_version_set_end: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_end(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[511] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_new: (skip):
 **/
GByteArray *
fu_struct_aver_hid_res_device_version_new(void)
{
    GByteArray *st = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st, 512, 0x0);
    memset(st->data + 13, 0xFF, 498);
    fu_struct_aver_hid_res_device_version_set_report_id_custom_command(st, 0x09);
    fu_struct_aver_hid_res_device_version_set_custom_cmd_isp(st, 0x25);
    fu_struct_aver_hid_res_device_version_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_res_device_version_validate: (skip):
 **/
gboolean
fu_struct_aver_hid_res_device_version_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 512, error)) {
        g_prefix_error(error, "invalid struct AverHidResDeviceVersion: ");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_device_version_get_report_id_custom_command(&st) != 0x09) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResDeviceVersion.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_device_version_get_custom_cmd_isp(&st) != 0x25) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResDeviceVersion.custom_cmd_isp was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_device_version_get_end(&st) != 0x00) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverHidResDeviceVersion.end was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_aver_safeisp_req_get_custom_cmd: (skip):
 **/
guint8
fu_struct_aver_safeisp_req_get_custom_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_aver_safeisp_req_get_custom_res: (skip):
 **/
guint16
fu_struct_aver_safeisp_req_get_custom_res(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_get_custom_parm0: (skip):
 **/
guint32
fu_struct_aver_safeisp_req_get_custom_parm0(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_get_custom_parm1: (skip):
 **/
guint32
fu_struct_aver_safeisp_req_get_custom_parm1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_req_get_data(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 1012;
    return st->data + 12;
}

/* setters */
/**
 * fu_struct_aver_safeisp_req_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_safeisp_req_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_safeisp_req_set_custom_cmd: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_safeisp_req_set_custom_res: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_res(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_set_custom_parm0: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_parm0(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_set_custom_parm1: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_parm1(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_req_set_data: (skip):
 **/
gboolean
fu_struct_aver_safeisp_req_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 12, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_safeisp_req_new: (skip):
 **/
GByteArray *
fu_struct_aver_safeisp_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(1024);
    fu_byte_array_set_size(st, 1024, 0x0);
    memset(st->data + 12, 0x00, 1012);
    fu_struct_aver_safeisp_req_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_safeisp_req_set_custom_parm0(st, 0x00);
    fu_struct_aver_safeisp_req_set_custom_parm1(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_aver_safeisp_res_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_safeisp_res_get_report_id_custom_command(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_aver_safeisp_res_get_custom_cmd: (skip):
 **/
guint8
fu_struct_aver_safeisp_res_get_custom_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_aver_safeisp_res_get_custom_res: (skip):
 **/
guint16
fu_struct_aver_safeisp_res_get_custom_res(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_get_custom_parm0: (skip):
 **/
guint32
fu_struct_aver_safeisp_res_get_custom_parm0(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_get_custom_parm1: (skip):
 **/
guint32
fu_struct_aver_safeisp_res_get_custom_parm1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_res_get_data(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->data + 12;
}

/* setters */
/**
 * fu_struct_aver_safeisp_res_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_safeisp_res_set_report_id_custom_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_aver_safeisp_res_set_custom_cmd: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_cmd(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_aver_safeisp_res_set_custom_res: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_res(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_set_custom_parm0: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_parm0(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_set_custom_parm1: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_parm1(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_BYTE_ORDER);
}
/**
 * fu_struct_aver_safeisp_res_set_data: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_set_data(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 12, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_safeisp_res_new: (skip):
 **/
GByteArray *
fu_struct_aver_safeisp_res_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    memset(st->data + 12, 0x00, 4);
    fu_struct_aver_safeisp_res_set_report_id_custom_command(st, 0x09);
    return st;
}
/**
 * fu_struct_aver_safeisp_res_validate: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct AverSafeispRes: ");
        return FALSE;
    }
    if (fu_struct_aver_safeisp_res_get_report_id_custom_command(&st) != 0x09) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverSafeispRes.report_id_custom_command was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_aver_safeisp_res_device_version_get_custom_cmd: (skip):
 **/
static guint8
fu_struct_aver_safeisp_res_device_version_get_custom_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_aver_safeisp_res_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_res_device_version_get_ver(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->data + 2;
}

/* setters */
/**
 * fu_struct_aver_safeisp_res_device_version_validate: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_device_version_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct AverSafeispResDeviceVersion: ");
        return FALSE;
    }
    if (fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command(&st) != 0x09) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverSafeispResDeviceVersion.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_safeisp_res_device_version_get_custom_cmd(&st) != 0x14) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant AverSafeispResDeviceVersion.custom_cmd was not valid");
        return FALSE;
    }
    return TRUE;
}
