/* auto-generated, do not modify */
#include "config.h"

#include "fu-cfu-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_cfu_offer_info_code_to_string(FuCfuOfferInfoCode val)
{
    if (val == FU_CFU_OFFER_INFO_CODE_START_ENTIRE_TRANSACTION)
        return "start-entire-transaction";
    if (val == FU_CFU_OFFER_INFO_CODE_START_OFFER_LIST)
        return "start-offer-list";
    if (val == FU_CFU_OFFER_INFO_CODE_END_OFFER_LIST)
        return "end-offer-list";
    return NULL;
}

const gchar *
fu_cfu_rr_code_to_string(FuCfuRrCode val)
{
    if (val == FU_CFU_RR_CODE_OFFER_REJECT_OLD_FIRMWARE)
        return "offer-reject-old-firmware";
    if (val == FU_CFU_RR_CODE_OFFER_REJECT_INV_COMPONENT)
        return "offer-reject-inv-component";
    if (val == FU_CFU_RR_CODE_UPDATE_OFFER_SWAP_PENDING)
        return "update-offer-swap-pending";
    if (val == FU_CFU_RR_CODE_WRONG_BANK)
        return "wrong-bank";
    if (val == FU_CFU_RR_CODE_SIGN_RULE)
        return "sign-rule";
    if (val == FU_CFU_RR_CODE_VER_RELEASE_DEBUG)
        return "ver-release-debug";
    if (val == FU_CFU_RR_CODE_DEBUG_SAME_VERSION)
        return "debug-same-version";
    if (val == FU_CFU_RR_CODE_NONE)
        return "none";
    return NULL;
}

const gchar *
fu_cfu_offer_status_to_string(FuCfuOfferStatus val)
{
    if (val == FU_CFU_OFFER_STATUS_SKIP)
        return "skip";
    if (val == FU_CFU_OFFER_STATUS_ACCEPT)
        return "accept";
    if (val == FU_CFU_OFFER_STATUS_REJECT)
        return "reject";
    if (val == FU_CFU_OFFER_STATUS_BUSY)
        return "busy";
    if (val == FU_CFU_OFFER_STATUS_COMMAND)
        return "command";
    if (val == FU_CFU_OFFER_STATUS_CMD_NOT_SUPPORTED)
        return "cmd-not-supported";
    return NULL;
}


const gchar *
fu_cfu_content_status_to_string(FuCfuContentStatus val)
{
    if (val == FU_CFU_CONTENT_STATUS_SUCCESS)
        return "success";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_PREPARE)
        return "error-prepare";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_WRITE)
        return "error-write";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_COMPLETE)
        return "error-complete";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_VERIFY)
        return "error-verify";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_CRC)
        return "error-crc";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_SIGNATURE)
        return "error-signature";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_VERSION)
        return "error-version";
    if (val == FU_CFU_CONTENT_STATUS_SWAP_PENDING)
        return "swap-pending";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_INVALID_ADDR0X09)
        return "error-invalid-addr0x09";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_NO_OFFER)
        return "error-no-offer";
    if (val == FU_CFU_CONTENT_STATUS_ERROR_INVALID)
        return "error-invalid";
    return NULL;
}
/* getters */
/**
 * fu_struct_cfu_get_version_rsp_get_component_cnt: (skip):
 **/
guint8
fu_struct_cfu_get_version_rsp_get_component_cnt(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_cfu_get_version_rsp_get_flags: (skip):
 **/
guint8
fu_struct_cfu_get_version_rsp_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}

/* setters */
/**
 * fu_struct_cfu_get_version_rsp_set_component_cnt: (skip):
 **/
void
fu_struct_cfu_get_version_rsp_set_component_cnt(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_cfu_get_version_rsp_set_flags: (skip):
 **/
void
fu_struct_cfu_get_version_rsp_set_flags(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_cfu_get_version_rsp_new: (skip):
 **/
GByteArray *
fu_struct_cfu_get_version_rsp_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    return st;
}
/**
 * fu_struct_cfu_get_version_rsp_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_get_version_rsp_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuGetVersionRsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  component_cnt: 0x%x\n",
                           (guint) fu_struct_cfu_get_version_rsp_get_component_cnt(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_cfu_get_version_rsp_get_flags(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_get_version_rsp_parse: (skip):
 **/
GByteArray *
fu_struct_cfu_get_version_rsp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct CfuGetVersionRsp: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_cfu_get_version_rsp_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_cfu_get_version_rsp_component_get_fw_version: (skip):
 **/
guint32
fu_struct_cfu_get_version_rsp_component_get_fw_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_get_version_rsp_component_get_flags: (skip):
 **/
guint8
fu_struct_cfu_get_version_rsp_component_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}
/**
 * fu_struct_cfu_get_version_rsp_component_get_component_id: (skip):
 **/
guint8
fu_struct_cfu_get_version_rsp_component_get_component_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}

/* setters */
/**
 * fu_struct_cfu_get_version_rsp_component_set_fw_version: (skip):
 **/
void
fu_struct_cfu_get_version_rsp_component_set_fw_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_get_version_rsp_component_set_flags: (skip):
 **/
void
fu_struct_cfu_get_version_rsp_component_set_flags(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[4] = value;
}
/**
 * fu_struct_cfu_get_version_rsp_component_set_component_id: (skip):
 **/
void
fu_struct_cfu_get_version_rsp_component_set_component_id(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[5] = value;
}
/**
 * fu_struct_cfu_get_version_rsp_component_new: (skip):
 **/
GByteArray *
fu_struct_cfu_get_version_rsp_component_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_cfu_get_version_rsp_component_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_get_version_rsp_component_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuGetVersionRspComponent:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  fw_version: 0x%x\n",
                           (guint) fu_struct_cfu_get_version_rsp_component_get_fw_version(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_cfu_get_version_rsp_component_get_flags(st));
    g_string_append_printf(str, "  component_id: 0x%x\n",
                           (guint) fu_struct_cfu_get_version_rsp_component_get_component_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_get_version_rsp_component_parse: (skip):
 **/
GByteArray *
fu_struct_cfu_get_version_rsp_component_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct CfuGetVersionRspComponent: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_cfu_get_version_rsp_component_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_cfu_offer_info_req_set_code: (skip):
 **/
void
fu_struct_cfu_offer_info_req_set_code(GByteArray *st, FuCfuOfferInfoCode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_cfu_offer_info_req_set_component_id: (skip):
 **/
static void
fu_struct_cfu_offer_info_req_set_component_id(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_cfu_offer_info_req_set_token: (skip):
 **/
static void
fu_struct_cfu_offer_info_req_set_token(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_cfu_offer_info_req_new: (skip):
 **/
GByteArray *
fu_struct_cfu_offer_info_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    fu_struct_cfu_offer_info_req_set_component_id(st, 0xFF);
    fu_struct_cfu_offer_info_req_set_token(st, 0xDE);
    return st;
}
/* getters */
/**
 * fu_struct_cfu_offer_rsp_get_token: (skip):
 **/
guint8
fu_struct_cfu_offer_rsp_get_token(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_cfu_offer_rsp_get_rr_code: (skip):
 **/
FuCfuRrCode
fu_struct_cfu_offer_rsp_get_rr_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_cfu_offer_rsp_get_status: (skip):
 **/
FuCfuOfferStatus
fu_struct_cfu_offer_rsp_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[12];
}

/* setters */
/**
 * fu_struct_cfu_offer_rsp_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_offer_rsp_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuOfferRsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  token: 0x%x\n",
                           (guint) fu_struct_cfu_offer_rsp_get_token(st));
    {
        const gchar *tmp = fu_cfu_rr_code_to_string(fu_struct_cfu_offer_rsp_get_rr_code(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  rr_code: 0x%x [%s]\n", (guint) fu_struct_cfu_offer_rsp_get_rr_code(st), tmp);
        } else {
            g_string_append_printf(str, "  rr_code: 0x%x\n", (guint) fu_struct_cfu_offer_rsp_get_rr_code(st));
        }
    }
    {
        const gchar *tmp = fu_cfu_offer_status_to_string(fu_struct_cfu_offer_rsp_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_cfu_offer_rsp_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_cfu_offer_rsp_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_offer_rsp_parse: (skip):
 **/
GByteArray *
fu_struct_cfu_offer_rsp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct CfuOfferRsp: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_cfu_offer_rsp_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_cfu_content_req_get_flags: (skip):
 **/
FuCfuContentFlag
fu_struct_cfu_content_req_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_cfu_content_req_get_data_length: (skip):
 **/
guint8
fu_struct_cfu_content_req_get_data_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_cfu_content_req_get_seq_number: (skip):
 **/
guint16
fu_struct_cfu_content_req_get_seq_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_content_req_get_address: (skip):
 **/
guint32
fu_struct_cfu_content_req_get_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cfu_content_req_set_flags: (skip):
 **/
void
fu_struct_cfu_content_req_set_flags(GByteArray *st, FuCfuContentFlag value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_cfu_content_req_set_data_length: (skip):
 **/
void
fu_struct_cfu_content_req_set_data_length(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_cfu_content_req_set_seq_number: (skip):
 **/
void
fu_struct_cfu_content_req_set_seq_number(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_content_req_set_address: (skip):
 **/
void
fu_struct_cfu_content_req_set_address(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_content_req_new: (skip):
 **/
GByteArray *
fu_struct_cfu_content_req_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/* getters */
/**
 * fu_struct_cfu_content_rsp_get_seq_number: (skip):
 **/
guint16
fu_struct_cfu_content_rsp_get_seq_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_content_rsp_get_status: (skip):
 **/
FuCfuContentStatus
fu_struct_cfu_content_rsp_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}

/* setters */
/**
 * fu_struct_cfu_content_rsp_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_content_rsp_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CfuContentRsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  seq_number: 0x%x\n",
                           (guint) fu_struct_cfu_content_rsp_get_seq_number(st));
    {
        const gchar *tmp = fu_cfu_content_status_to_string(fu_struct_cfu_content_rsp_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_cfu_content_rsp_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_cfu_content_rsp_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cfu_content_rsp_parse: (skip):
 **/
GByteArray *
fu_struct_cfu_content_rsp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct CfuContentRsp: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_cfu_content_rsp_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
