/* auto-generated, do not modify */
#include "config.h"

#include "fu-genesys-usbhub-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_genesys_ts_version_to_string(FuGenesysTsVersion val)
{
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_9_BYTE)
        return "dynamic-9-byte";
    if (val == FU_GENESYS_TS_VERSION_BONDING)
        return "bonding";
    if (val == FU_GENESYS_TS_VERSION_BONDING_QC)
        return "bonding-qc";
    if (val == FU_GENESYS_TS_VERSION_VENDOR_SUPPORT)
        return "vendor-support";
    if (val == FU_GENESYS_TS_VERSION_MULTI_TOKEN)
        return "multi-token";
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_2ND)
        return "dynamic-2nd";
    if (val == FU_GENESYS_TS_VERSION_RESERVED)
        return "reserved";
    if (val == FU_GENESYS_TS_VERSION_DYNAMIC_13_BYTE)
        return "dynamic-13-byte";
    if (val == FU_GENESYS_TS_VERSION_BRAND_PROJECT)
        return "brand-project";
    return NULL;
}

const gchar *
fu_genesys_fw_status_to_string(FuGenesysFwStatus val)
{
    if (val == FU_GENESYS_FW_STATUS_MASK)
        return "mask";
    if (val == FU_GENESYS_FW_STATUS_BANK1)
        return "bank1";
    if (val == FU_GENESYS_FW_STATUS_BANK2)
        return "bank2";
    return NULL;
}

const gchar *
fu_genesys_vs_codesign_check_to_string(FuGenesysVsCodesignCheck val)
{
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_UNSUPPORTED)
        return "unsupported";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_SCALER)
        return "scaler";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_FW)
        return "fw";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_MASTER)
        return "master";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_RESERVED)
        return "reserved";
    if (val == FU_GENESYS_VS_CODESIGN_CHECK_HW)
        return "hw";
    return NULL;
}

static const gchar *
fu_genesys_vs_hid_isp_to_string(FuGenesysVsHidIsp val)
{
    if (val == FU_GENESYS_VS_HID_ISP_UNSUPPORTED)
        return "unsupported";
    if (val == FU_GENESYS_VS_HID_ISP_SUPPORT)
        return "support";
    if (val == FU_GENESYS_VS_HID_ISP_CODESIGN_N_RESET)
        return "codesign-n-reset";
    return NULL;
}

const gchar *
fu_genesys_fw_codesign_to_string(FuGenesysFwCodesign val)
{
    if (val == FU_GENESYS_FW_CODESIGN_NONE)
        return "none";
    if (val == FU_GENESYS_FW_CODESIGN_RSA)
        return "rsa";
    if (val == FU_GENESYS_FW_CODESIGN_ECDSA)
        return "ecdsa";
    return NULL;
}

const gchar *
fu_genesys_fw_type_to_string(FuGenesysFwType val)
{
    if (val == FU_GENESYS_FW_TYPE_HUB)
        return "hub";
    if (val == FU_GENESYS_FW_TYPE_DEV_BRIDGE)
        return "dev-bridge";
    if (val == FU_GENESYS_FW_TYPE_PD)
        return "pd";
    if (val == FU_GENESYS_FW_TYPE_CODESIGN)
        return "codesign";
    if (val == FU_GENESYS_FW_TYPE_INSIDE_HUB_COUNT)
        return "inside-hub-count";
    if (val == FU_GENESYS_FW_TYPE_SCALER)
        return "scaler";
    if (val == FU_GENESYS_FW_TYPE_UNKNOWN)
        return "unknown";
    return NULL;
}
/* getters */
/**
 * fu_struct_genesys_ts_static_get_tool_string_version: (skip):
 **/
FuGenesysTsVersion
fu_struct_genesys_ts_static_get_tool_string_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_code: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 1, 4, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_hardware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_hardware(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_firmware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_firmware(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 2, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_mask_project_ic_type: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_mask_project_ic_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 6, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_code: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 14, 4, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_hardware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_hardware(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 18, 1, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_firmware: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_firmware(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 19, 2, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_running_project_ic_type: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_running_project_ic_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 21, 6, NULL);
}
/**
 * fu_struct_genesys_ts_static_get_firmware_version: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_get_firmware_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 27, 4, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_static_set_tool_string_version: (skip):
 **/
void
fu_struct_genesys_ts_static_set_tool_string_version(GByteArray *st, FuGenesysTsVersion value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_code: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_code(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 1, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.mask_project_code (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 1, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_hardware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_hardware(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 5, 0x0, 1);
        return TRUE;
    }
    len = strlen(value);
    if (len > 1) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.mask_project_hardware (0x%x bytes)",
                    value, (guint) len, (guint) 1);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 5, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_firmware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_firmware(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 6, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.mask_project_firmware (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 6, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_mask_project_ic_type: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_mask_project_ic_type(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 8, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.mask_project_ic_type (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_code: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_code(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 14, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.running_project_code (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 14, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_hardware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_hardware(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 18, 0x0, 1);
        return TRUE;
    }
    len = strlen(value);
    if (len > 1) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.running_project_hardware (0x%x bytes)",
                    value, (guint) len, (guint) 1);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 18, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_firmware: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_firmware(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 19, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.running_project_firmware (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 19, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_running_project_ic_type: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_running_project_ic_type(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 21, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.running_project_ic_type (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 21, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_set_firmware_version: (skip):
 **/
gboolean
fu_struct_genesys_ts_static_set_firmware_version(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 27, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsStatic.firmware_version (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 27, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_static_new: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_static_new(void)
{
    GByteArray *st = g_byte_array_sized_new(31);
    fu_byte_array_set_size(st, 31, 0x0);
    return st;
}
/**
 * fu_struct_genesys_ts_static_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_static_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsStatic:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_genesys_ts_version_to_string(fu_struct_genesys_ts_static_get_tool_string_version(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  tool_string_version: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_static_get_tool_string_version(st), tmp);
        } else {
            g_string_append_printf(str, "  tool_string_version: 0x%x\n", (guint) fu_struct_genesys_ts_static_get_tool_string_version(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_code(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_code: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_hardware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_hardware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_firmware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_firmware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_mask_project_ic_type(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  mask_project_ic_type: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_code(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_code: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_hardware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_hardware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_firmware(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_firmware: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_running_project_ic_type(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_project_ic_type: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_static_get_firmware_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  firmware_version: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_static_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_static_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error(error, "invalid struct GenesysTsStatic: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 31);
    str = fu_struct_genesys_ts_static_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_ts_static_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_static_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_genesys_ts_static_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_running_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_charging(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_get_bonding: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_get_bonding(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 9, 1, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3523_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3523_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsDynamicGl3523:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3523_get_bonding(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  bonding: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3523_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_dynamic_gl3523_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error(error, "invalid struct GenesysTsDynamicGl3523: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 10);
    str = fu_struct_genesys_ts_dynamic_gl3523_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_running_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_charging(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl3590_get_bonding(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3590_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3590_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsDynamicGl3590:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3590_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3590_get_bonding(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3590_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_dynamic_gl3590_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error(error, "invalid struct GenesysTsDynamicGl3590: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 10);
    str = fu_struct_genesys_ts_dynamic_gl3590_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_running_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_charging(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl359030_get_bonding(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl359030_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl359030_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsDynamicGl359030:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl359030_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl359030_get_bonding(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hub_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  hub_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_hub_fw_status(st));
        }
    }
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_status(st));
        }
    }
    g_string_append_printf(str, "  dev_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl359030_get_dev_fw_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_dynamic_gl359030_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_dynamic_gl359030_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 14, error)) {
        g_prefix_error(error, "invalid struct GenesysTsDynamicGl359030: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 14);
    str = fu_struct_genesys_ts_dynamic_gl359030_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_running_mode: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_running_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 1, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 2, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 5, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_charging: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_charging(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 7, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 8, 1, NULL);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_bonding: (skip):
 **/
guint8
fu_struct_genesys_ts_dynamic_gl3525_get_bonding(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status: (skip):
 **/
FuGenesysFwStatus
fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[14];
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version: (skip):
 **/
guint16
fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 15, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_ts_dynamic_gl3525_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_dynamic_gl3525_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsDynamicGl3525:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_running_mode(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  running_mode: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ss_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_hs_port_number(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_port_number: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ss_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ss_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_hs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_fs_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fs_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_ls_connection_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  ls_connection_status: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_charging(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  charging: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_dynamic_gl3525_get_non_removable_port_status(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  non_removable_port_status: %s\n", tmp);
    }
    g_string_append_printf(str, "  bonding: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_bonding(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hub_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  hub_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_hub_fw_status(st));
        }
    }
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  pd_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  pd_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_status(st));
        }
    }
    g_string_append_printf(str, "  pd_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_pd_fw_version(st));
    {
        const gchar *tmp = fu_genesys_fw_status_to_string(fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_fw_status: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_fw_status: 0x%x\n", (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_status(st));
        }
    }
    g_string_append_printf(str, "  dev_fw_version: 0x%x\n",
                           (guint) fu_struct_genesys_ts_dynamic_gl3525_get_dev_fw_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_dynamic_gl3525_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_dynamic_gl3525_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 17, error)) {
        g_prefix_error(error, "invalid struct GenesysTsDynamicGl3525: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 17);
    str = fu_struct_genesys_ts_dynamic_gl3525_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_firmware_info_get_tool_version: (skip):
 **/
const guint8 *
fu_struct_genesys_ts_firmware_info_get_tool_version(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->data + 0;
}
/**
 * fu_struct_genesys_ts_firmware_info_get_address_mode: (skip):
 **/
guint8
fu_struct_genesys_ts_firmware_info_get_address_mode(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[6];
}
/**
 * fu_struct_genesys_ts_firmware_info_get_build_fw_time: (skip):
 **/
gchar *
fu_struct_genesys_ts_firmware_info_get_build_fw_time(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 7, 12, NULL);
}
/**
 * fu_struct_genesys_ts_firmware_info_get_update_fw_time: (skip):
 **/
gchar *
fu_struct_genesys_ts_firmware_info_get_update_fw_time(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 19, 12, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_firmware_info_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_firmware_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsFirmwareInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_ts_firmware_info_get_tool_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  tool_version: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  address_mode: 0x%x\n",
                           (guint) fu_struct_genesys_ts_firmware_info_get_address_mode(st));
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_firmware_info_get_build_fw_time(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  build_fw_time: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_firmware_info_get_update_fw_time(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  update_fw_time: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_firmware_info_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_firmware_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error(error, "invalid struct GenesysTsFirmwareInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 31);
    str = fu_struct_genesys_ts_firmware_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_vendor_support_get_version: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 2, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved1: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 2, 8, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_codesign_check: (skip):
 **/
FuGenesysVsCodesignCheck
fu_struct_genesys_ts_vendor_support_get_codesign_check(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved2: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 11, 4, NULL);
}
/**
 * fu_struct_genesys_ts_vendor_support_get_hid_isp: (skip):
 **/
FuGenesysVsHidIsp
fu_struct_genesys_ts_vendor_support_get_hid_isp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[15];
}
/**
 * fu_struct_genesys_ts_vendor_support_get_reserved3: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_get_reserved3(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 16, 15, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_vendor_support_set_version: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_version(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 2);
        return TRUE;
    }
    len = strlen(value);
    if (len > 2) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsVendorSupport.version (0x%x bytes)",
                    value, (guint) len, (guint) 2);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved1: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved1(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 2, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsVendorSupport.reserved1 (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 2, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_codesign_check: (skip):
 **/
void
fu_struct_genesys_ts_vendor_support_set_codesign_check(GByteArray *st, FuGenesysVsCodesignCheck value)
{
    g_return_if_fail(st != NULL);
    st->data[10] = value;
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved2: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved2(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 11, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsVendorSupport.reserved2 (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 11, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_set_hid_isp: (skip):
 **/
void
fu_struct_genesys_ts_vendor_support_set_hid_isp(GByteArray *st, FuGenesysVsHidIsp value)
{
    g_return_if_fail(st != NULL);
    st->data[15] = value;
}
/**
 * fu_struct_genesys_ts_vendor_support_set_reserved3: (skip):
 **/
gboolean
fu_struct_genesys_ts_vendor_support_set_reserved3(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 16, 0x0, 15);
        return TRUE;
    }
    len = strlen(value);
    if (len > 15) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in GenesysTsVendorSupport.reserved3 (0x%x bytes)",
                    value, (guint) len, (guint) 15);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_genesys_ts_vendor_support_new: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_vendor_support_new(void)
{
    GByteArray *st = g_byte_array_sized_new(31);
    fu_byte_array_set_size(st, 31, 0x0);
    return st;
}
/**
 * fu_struct_genesys_ts_vendor_support_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_vendor_support_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsVendorSupport:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved1(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved1: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_genesys_vs_codesign_check_to_string(fu_struct_genesys_ts_vendor_support_get_codesign_check(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  codesign_check: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_vendor_support_get_codesign_check(st), tmp);
        } else {
            g_string_append_printf(str, "  codesign_check: 0x%x\n", (guint) fu_struct_genesys_ts_vendor_support_get_codesign_check(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved2(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved2: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_genesys_vs_hid_isp_to_string(fu_struct_genesys_ts_vendor_support_get_hid_isp(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  hid_isp: 0x%x [%s]\n", (guint) fu_struct_genesys_ts_vendor_support_get_hid_isp(st), tmp);
        } else {
            g_string_append_printf(str, "  hid_isp: 0x%x\n", (guint) fu_struct_genesys_ts_vendor_support_get_hid_isp(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_vendor_support_get_reserved3(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  reserved3: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_vendor_support_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_vendor_support_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error(error, "invalid struct GenesysTsVendorSupport: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 31);
    str = fu_struct_genesys_ts_vendor_support_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_ts_brand_project_get_project: (skip):
 **/
gchar *
fu_struct_genesys_ts_brand_project_get_project(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 15, NULL);
}

/* setters */
/**
 * fu_struct_genesys_ts_brand_project_to_string: (skip):
 **/
gchar *
fu_struct_genesys_ts_brand_project_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysTsBrandProject:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_ts_brand_project_get_project(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  project: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_ts_brand_project_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_ts_brand_project_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 15, error)) {
        g_prefix_error(error, "invalid struct GenesysTsBrandProject: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 15);
    str = fu_struct_genesys_ts_brand_project_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_tag_n: (skip):
 **/
static guint32
fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_text_n: (skip):
 **/
gchar *
fu_struct_genesys_fw_codesign_info_rsa_get_text_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 512, NULL);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_end_n: (skip):
 **/
static guint16
fu_struct_genesys_fw_codesign_info_rsa_get_end_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 516, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_tag_e: (skip):
 **/
static guint32
fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 518, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_text_e: (skip):
 **/
gchar *
fu_struct_genesys_fw_codesign_info_rsa_get_text_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 522, 6, NULL);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_end_e: (skip):
 **/
static guint16
fu_struct_genesys_fw_codesign_info_rsa_get_end_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 528, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_get_signature: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_rsa_get_signature(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 256;
    return st->data + 530;
}

/* setters */
/**
 * fu_struct_genesys_fw_codesign_info_rsa_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_codesign_info_rsa_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysFwCodesignInfoRsa:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_codesign_info_rsa_get_text_n(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_n: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_codesign_info_rsa_get_text_e(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_e: %s\n", tmp);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_rsa_get_signature(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  signature: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_parse: (skip):
 **/
static GByteArray *
fu_struct_genesys_fw_codesign_info_rsa_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 786, error)) {
        g_prefix_error(error, "invalid struct GenesysFwCodesignInfoRsa: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 786);
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(st) != 0x4E203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.tag_n was not valid, expected 0x4E203D20");
        return NULL;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_n(st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.end_n was not valid, expected 0x0D0A");
        return NULL;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(st) != 0x45203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.tag_e was not valid, expected 0x45203D20");
        return NULL;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_e(st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.end_e was not valid, expected 0x0D0A");
        return NULL;
    }
    str = fu_struct_genesys_fw_codesign_info_rsa_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_genesys_fw_codesign_info_rsa_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_genesys_fw_codesign_info_rsa_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_validate: (skip):
 **/
static gboolean
fu_struct_genesys_fw_codesign_info_rsa_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 786, error)) {
        g_prefix_error(error, "invalid struct GenesysFwCodesignInfoRsa: ");
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_n(&st) != 0x4E203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.tag_n was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_n(&st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.end_n was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_tag_e(&st) != 0x45203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.tag_e was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_codesign_info_rsa_get_end_e(&st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwCodesignInfoRsa.end_e was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_rsa_validate_bytes: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_rsa_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_genesys_fw_codesign_info_rsa_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_tag_n: (skip):
 **/
static guint32
fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_text_n: (skip):
 **/
gchar *
fu_struct_genesys_fw_rsa_public_key_text_get_text_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 512, NULL);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_end_n: (skip):
 **/
static guint16
fu_struct_genesys_fw_rsa_public_key_text_get_end_n(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 516, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_tag_e: (skip):
 **/
static guint32
fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 518, G_BIG_ENDIAN);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_text_e: (skip):
 **/
gchar *
fu_struct_genesys_fw_rsa_public_key_text_get_text_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 522, 6, NULL);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_get_end_e: (skip):
 **/
static guint16
fu_struct_genesys_fw_rsa_public_key_text_get_end_e(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 528, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_genesys_fw_rsa_public_key_text_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_rsa_public_key_text_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysFwRsaPublicKeyText:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_rsa_public_key_text_get_text_n(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_n: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_genesys_fw_rsa_public_key_text_get_text_e(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  text_e: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_fw_rsa_public_key_text_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 530, error)) {
        g_prefix_error(error, "invalid struct GenesysFwRsaPublicKeyText: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 530);
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(st) != 0x4E203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.tag_n was not valid, expected 0x4E203D20");
        return NULL;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_n(st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.end_n was not valid, expected 0x0D0A");
        return NULL;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(st) != 0x45203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.tag_e was not valid, expected 0x45203D20");
        return NULL;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_e(st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.end_e was not valid, expected 0x0D0A");
        return NULL;
    }
    str = fu_struct_genesys_fw_rsa_public_key_text_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_rsa_public_key_text_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_rsa_public_key_text_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 530, error)) {
        g_prefix_error(error, "invalid struct GenesysFwRsaPublicKeyText: ");
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_n(&st) != 0x4E203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.tag_n was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_n(&st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.end_n was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_tag_e(&st) != 0x45203D20) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.tag_e was not valid");
        return FALSE;
    }
    if (fu_struct_genesys_fw_rsa_public_key_text_get_end_e(&st) != 0x0D0A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant GenesysFwRsaPublicKeyText.end_e was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_hash: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_hash(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 32;
    return st->data + 0;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_key: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_key(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->data + 32;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_get_signature: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_codesign_info_ecdsa_get_signature(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->data + 96;
}

/* setters */
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_codesign_info_ecdsa_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysFwCodesignInfoEcdsa:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_hash(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  hash: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_key(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  key: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_codesign_info_ecdsa_get_signature(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  signature: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_fw_codesign_info_ecdsa_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 160, error)) {
        g_prefix_error(error, "invalid struct GenesysFwCodesignInfoEcdsa: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 160);
    str = fu_struct_genesys_fw_codesign_info_ecdsa_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_genesys_fw_codesign_info_ecdsa_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_genesys_fw_codesign_info_ecdsa_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 160, error)) {
        g_prefix_error(error, "invalid struct GenesysFwCodesignInfoEcdsa: ");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_genesys_fw_codesign_info_ecdsa_validate_bytes: (skip):
 **/
gboolean
fu_struct_genesys_fw_codesign_info_ecdsa_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_genesys_fw_codesign_info_ecdsa_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_genesys_fw_ecdsa_public_key_get_key: (skip):
 **/
const guint8 *
fu_struct_genesys_fw_ecdsa_public_key_get_key(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 64;
    return st->data + 0;
}

/* setters */
/**
 * fu_struct_genesys_fw_ecdsa_public_key_to_string: (skip):
 **/
static gchar *
fu_struct_genesys_fw_ecdsa_public_key_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("GenesysFwEcdsaPublicKey:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_genesys_fw_ecdsa_public_key_get_key(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  key: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_parse: (skip):
 **/
GByteArray *
fu_struct_genesys_fw_ecdsa_public_key_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct GenesysFwEcdsaPublicKey: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    str = fu_struct_genesys_fw_ecdsa_public_key_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_genesys_fw_ecdsa_public_key_validate: (skip):
 **/
gboolean
fu_struct_genesys_fw_ecdsa_public_key_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct GenesysFwEcdsaPublicKey: ");
        return FALSE;
    }
    return TRUE;
}
