/* auto-generated, do not modify */
#include "config.h"

#include "fu-igsc-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_igsc_oprom_version_get_major: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_minor: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_hotfix: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_hotfix(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_build: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_oprom_version_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_oprom_version_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IgscOpromVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_igsc_oprom_version_parse: (skip):
 **/
GByteArray *
fu_struct_igsc_oprom_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct IgscOpromVersion: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_igsc_oprom_version_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_igsc_fw_version_get_project: (skip):
 **/
gchar *
fu_struct_igsc_fw_version_get_project(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 4, NULL);
}
/**
 * fu_struct_igsc_fw_version_get_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fw_version_get_hotfix(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_get_build: (skip):
 **/
guint16
fu_struct_igsc_fw_version_get_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fw_version_set_project: (skip):
 **/
gboolean
fu_struct_igsc_fw_version_set_project(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in IgscFwVersion.project (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_igsc_fw_version_set_hotfix: (skip):
 **/
void
fu_struct_igsc_fw_version_set_hotfix(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_set_build: (skip):
 **/
void
fu_struct_igsc_fw_version_set_build(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_new: (skip):
 **/
GByteArray *
fu_struct_igsc_fw_version_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/* getters */
/**
 * fu_struct_igsc_oprom_subsystem_device_id_get_subsys_vendor_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device_id_get_subsys_vendor_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_subsystem_device_id_get_subsys_device_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device_id_get_subsys_device_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_oprom_subsystem_device_id_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_oprom_subsystem_device_id_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IgscOpromSubsystemDeviceId:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  subsys_vendor_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device_id_get_subsys_vendor_id(st));
    g_string_append_printf(str, "  subsys_device_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device_id_get_subsys_device_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_igsc_oprom_subsystem_device_id_parse: (skip):
 **/
static GByteArray *
fu_struct_igsc_oprom_subsystem_device_id_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct IgscOpromSubsystemDeviceId: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_igsc_oprom_subsystem_device_id_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_igsc_oprom_subsystem_device_id_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_igsc_oprom_subsystem_device_id_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_igsc_oprom_subsystem_device_id_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_get_vendor_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device4_id_get_vendor_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_get_device_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device4_id_get_device_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_vendor_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_vendor_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_device_id: (skip):
 **/
guint16
fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_device_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_oprom_subsystem_device4_id_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IgscOpromSubsystemDevice4Id:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device4_id_get_vendor_id(st));
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device4_id_get_device_id(st));
    g_string_append_printf(str, "  subsys_vendor_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_vendor_id(st));
    g_string_append_printf(str, "  subsys_device_id: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_subsystem_device4_id_get_subsys_device_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_parse: (skip):
 **/
static GByteArray *
fu_struct_igsc_oprom_subsystem_device4_id_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct IgscOpromSubsystemDevice4Id: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_igsc_oprom_subsystem_device4_id_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_igsc_oprom_subsystem_device4_id_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_igsc_oprom_subsystem_device4_id_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_igsc_oprom_subsystem_device4_id_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_igsc_fwu_gws_image_info_get_format_version: (skip):
 **/
static guint32
fu_struct_igsc_fwu_gws_image_info_get_format_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_gws_image_info_get_instance_id: (skip):
 **/
guint32
fu_struct_igsc_fwu_gws_image_info_get_instance_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fwu_gws_image_info_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwu_gws_image_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IgscFwuGwsImageInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  instance_id: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_gws_image_info_get_instance_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_igsc_fwu_gws_image_info_parse: (skip):
 **/
static GByteArray *
fu_struct_igsc_fwu_gws_image_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct IgscFwuGwsImageInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    if (fu_struct_igsc_fwu_gws_image_info_get_format_version(st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IgscFwuGwsImageInfo.format_version was not valid, expected 0x1");
        return NULL;
    }
    str = fu_struct_igsc_fwu_gws_image_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_igsc_fwu_gws_image_info_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_igsc_fwu_gws_image_info_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_igsc_fwu_gws_image_info_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_major: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_minor: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_hotfix(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_build: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_flags: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_fw_type: (skip):
 **/
guint8
fu_struct_igsc_fwu_fw_image_data_get_fw_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_fw_sub_type: (skip):
 **/
guint8
fu_struct_igsc_fwu_fw_image_data_get_fw_sub_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_arb_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_arb_svn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_tcb_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_tcb_svn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_vcn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_vcn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}

/* setters */
/* getters */
/**
 * fu_struct_igsc_fwu_iup_data_get_iup_name: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_iup_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_flags: (skip):
 **/
guint16
fu_struct_igsc_fwu_iup_data_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_svn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_vcn: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_vcn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/* getters */
/**
 * fu_struct_igsc_fwu_heci_image_metadata_get_version_format: (skip):
 **/
guint32
fu_struct_igsc_fwu_heci_image_metadata_get_version_format(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/* getters */
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_format: (skip):
 **/
guint32
fu_struct_igsc_fwu_image_metadata_v1_get_version_format(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_project: (skip):
 **/
gchar *
fu_struct_igsc_fwu_image_metadata_v1_get_project(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 4, NULL);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_BYTE_ORDER);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_build: (skip):
 **/
guint16
fu_struct_igsc_fwu_image_metadata_v1_get_version_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_BYTE_ORDER);
}

/* setters */
/**
 * fu_struct_igsc_fwu_image_metadata_v1_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwu_image_metadata_v1_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IgscFwuImageMetadataV1:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_format: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_format(st));
    {
        g_autofree gchar *tmp = fu_struct_igsc_fwu_image_metadata_v1_get_project(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  project: %s\n", tmp);
    }
    g_string_append_printf(str, "  version_hotfix: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_parse: (skip):
 **/
static GByteArray *
fu_struct_igsc_fwu_image_metadata_v1_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error(error, "invalid struct IgscFwuImageMetadataV1: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    str = fu_struct_igsc_fwu_image_metadata_v1_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_igsc_fwu_image_metadata_v1_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_igsc_fwu_image_metadata_v1_parse(buf, bufsz, offset, error);
}
