/* auto-generated, do not modify */
#include "config.h"

#include "fu-kinetic-dp-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_kinetic_dp_family_to_string(FuKineticDpFamily val)
{
    if (val == FU_KINETIC_DP_FAMILY_UNKNOWN)
        return "unknown";
    if (val == FU_KINETIC_DP_FAMILY_MUSTANG)
        return "mustang";
    if (val == FU_KINETIC_DP_FAMILY_JAGUAR)
        return "jaguar";
    if (val == FU_KINETIC_DP_FAMILY_PUMA)
        return "puma";
    return NULL;
}

const gchar *
fu_kinetic_dp_chip_to_string(FuKineticDpChip val)
{
    if (val == FU_KINETIC_DP_CHIP_NONE)
        return "none";
    if (val == FU_KINETIC_DP_CHIP_BOBCAT_2800)
        return "bobcat-2800";
    if (val == FU_KINETIC_DP_CHIP_BOBCAT_2850)
        return "bobcat-2850";
    if (val == FU_KINETIC_DP_CHIP_PEGASUS)
        return "pegasus";
    if (val == FU_KINETIC_DP_CHIP_MYSTIQUE)
        return "mystique";
    if (val == FU_KINETIC_DP_CHIP_DP2VGA)
        return "dp2vga";
    if (val == FU_KINETIC_DP_CHIP_PUMA_2900)
        return "puma-2900";
    if (val == FU_KINETIC_DP_CHIP_PUMA_2920)
        return "puma-2920";
    if (val == FU_KINETIC_DP_CHIP_JAGUAR_5000)
        return "jaguar-5000";
    if (val == FU_KINETIC_DP_CHIP_MUSTANG_5200)
        return "mustang-5200";
    return NULL;
}


const gchar *
fu_kinetic_dp_bank_to_string(FuKineticDpBank val)
{
    if (val == FU_KINETIC_DP_BANK_A)
        return "a";
    if (val == FU_KINETIC_DP_BANK_B)
        return "b";
    if (val == FU_KINETIC_DP_BANK_NONE)
        return "none";
    return NULL;
}


const gchar *
fu_kinetic_dp_fw_state_to_string(FuKineticDpFwState val)
{
    if (val == FU_KINETIC_DP_FW_STATE_NONE)
        return "none";
    if (val == FU_KINETIC_DP_FW_STATE_IROM)
        return "irom";
    if (val == FU_KINETIC_DP_FW_STATE_BOOT_CODE)
        return "boot-code";
    if (val == FU_KINETIC_DP_FW_STATE_APP)
        return "app";
    return NULL;
}

const gchar *
fu_kinetic_dp_puma_mode_to_string(FuKineticDpPumaMode val)
{
    if (val == FU_KINETIC_DP_PUMA_MODE_CHUNK_PROCESSED)
        return "chunk-processed";
    if (val == FU_KINETIC_DP_PUMA_MODE_CHUNK_RECEIVED)
        return "chunk-received";
    if (val == FU_KINETIC_DP_PUMA_MODE_FLASH_INFO_READY)
        return "flash-info-ready";
    if (val == FU_KINETIC_DP_PUMA_MODE_UPDATE_ABORT)
        return "update-abort";
    return NULL;
}


const gchar *
fu_kinetic_dp_dpcd_to_string(FuKineticDpDpcd val)
{
    if (val == FU_KINETIC_DP_DPCD_CMD_STS_NONE)
        return "cmd-sts-none";
    if (val == FU_KINETIC_DP_DPCD_STS_INVALID_INFO)
        return "sts-invalid-info";
    if (val == FU_KINETIC_DP_DPCD_STS_CRC_FAILURE)
        return "sts-crc-failure";
    if (val == FU_KINETIC_DP_DPCD_STS_INVALID_IMAGE)
        return "sts-invalid-image";
    if (val == FU_KINETIC_DP_DPCD_STS_SECURE_ENABLED)
        return "sts-secure-enabled";
    if (val == FU_KINETIC_DP_DPCD_STS_SECURE_DISABLED)
        return "sts-secure-disabled";
    if (val == FU_KINETIC_DP_DPCD_STS_SPI_FLASH_FAILURE)
        return "sts-spi-flash-failure";
    if (val == FU_KINETIC_DP_DPCD_CMD_PREPARE_FOR_ISP_MODE)
        return "cmd-prepare-for-isp-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENTER_CODE_LOADING_MODE)
        return "cmd-enter-code-loading-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_EXECUTE_RAM_CODE)
        return "cmd-execute-ram-code";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENTER_FW_UPDATE_MODE)
        return "cmd-enter-fw-update-mode";
    if (val == FU_KINETIC_DP_DPCD_CMD_CHUNK_DATA_PROCESSED)
        return "cmd-chunk-data-processed";
    if (val == FU_KINETIC_DP_DPCD_CMD_INSTALL_IMAGES)
        return "cmd-install-images";
    if (val == FU_KINETIC_DP_DPCD_CMD_RESET_SYSTEM)
        return "cmd-reset-system";
    if (val == FU_KINETIC_DP_DPCD_CMD_ENABLE_AUX_FORWARD)
        return "cmd-enable-aux-forward";
    if (val == FU_KINETIC_DP_DPCD_CMD_DISABLE_AUX_FORWARD)
        return "cmd-disable-aux-forward";
    if (val == FU_KINETIC_DP_DPCD_CMD_GET_ACTIVE_FLASH_BANK)
        return "cmd-get-active-flash-bank";
    if (val == FU_KINETIC_DP_DPCD_CMD_RESERVED)
        return "cmd-reserved";
    return NULL;
}
/* getters */
/**
 * fu_struct_kinetic_dp_puma_header_get_object_count: (skip):
 **/
static guint8
fu_struct_kinetic_dp_puma_header_get_object_count(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}

/* setters */
/**
 * fu_struct_kinetic_dp_puma_header_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_puma_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("KineticDpPumaHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_kinetic_dp_puma_header_parse: (skip):
 **/
static GByteArray *
fu_struct_kinetic_dp_puma_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error(error, "invalid struct KineticDpPumaHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 2);
    if (fu_struct_kinetic_dp_puma_header_get_object_count(st) != 8) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant KineticDpPumaHeader.object_count was not valid, expected 8");
        return NULL;
    }
    str = fu_struct_kinetic_dp_puma_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_puma_header_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_kinetic_dp_puma_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_kinetic_dp_puma_header_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_kinetic_dp_puma_header_info_get_type: (skip):
 **/
guint8
fu_struct_kinetic_dp_puma_header_info_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_kinetic_dp_puma_header_info_get_subtype: (skip):
 **/
guint8
fu_struct_kinetic_dp_puma_header_info_get_subtype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_kinetic_dp_puma_header_info_get_length: (skip):
 **/
guint32
fu_struct_kinetic_dp_puma_header_info_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_kinetic_dp_puma_header_info_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_puma_header_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("KineticDpPumaHeaderInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_type(st));
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_subtype(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_puma_header_info_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_kinetic_dp_puma_header_info_parse: (skip):
 **/
static GByteArray *
fu_struct_kinetic_dp_puma_header_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error(error, "invalid struct KineticDpPumaHeaderInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    str = fu_struct_kinetic_dp_puma_header_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_puma_header_info_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_kinetic_dp_puma_header_info_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_kinetic_dp_puma_header_info_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver: (skip):
 **/
guint32
fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_id: (skip):
 **/
const guint8 *
fu_struct_kinetic_dp_jaguar_footer_get_app_id(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->data + 4;
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id: (skip):
 **/
guint32
fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_fw_ver: (skip):
 **/
guint16
fu_struct_kinetic_dp_jaguar_footer_get_fw_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_fw_rev: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_fw_rev(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[14];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[15];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver: (skip):
 **/
guint16
fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_chip_rev: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_chip_rev(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[18];
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled: (skip):
 **/
guint8
fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[19];
}

/* setters */
/**
 * fu_struct_kinetic_dp_jaguar_footer_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_jaguar_footer_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("KineticDpJaguarFooter:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  app_id_struct_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_app_id_struct_ver(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_kinetic_dp_jaguar_footer_get_app_id(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  app_id: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  app_ver_id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_app_ver_id(st));
    g_string_append_printf(str, "  fw_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_fw_ver(st));
    g_string_append_printf(str, "  fw_rev: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_fw_rev(st));
    g_string_append_printf(str, "  customer_fw_project_id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_project_id(st));
    g_string_append_printf(str, "  customer_fw_ver: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_customer_fw_ver(st));
    g_string_append_printf(str, "  chip_rev: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_chip_rev(st));
    g_string_append_printf(str, "  is_fpga_enabled: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_jaguar_footer_get_is_fpga_enabled(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_parse: (skip):
 **/
static GByteArray *
fu_struct_kinetic_dp_jaguar_footer_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct KineticDpJaguarFooter: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 32);
    str = fu_struct_kinetic_dp_jaguar_footer_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_kinetic_dp_jaguar_footer_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_kinetic_dp_jaguar_footer_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_kinetic_dp_jaguar_footer_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_kinetic_dp_flash_info_get_id: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_flash_info_get_size: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_BIG_ENDIAN);
}
/**
 * fu_struct_kinetic_dp_flash_info_get_erase_time: (skip):
 **/
guint16
fu_struct_kinetic_dp_flash_info_get_erase_time(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_kinetic_dp_flash_info_to_string: (skip):
 **/
static gchar *
fu_struct_kinetic_dp_flash_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("KineticDpFlashInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_id(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_size(st));
    g_string_append_printf(str, "  erase_time: 0x%x\n",
                           (guint) fu_struct_kinetic_dp_flash_info_get_erase_time(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_kinetic_dp_flash_info_parse: (skip):
 **/
GByteArray *
fu_struct_kinetic_dp_flash_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error(error, "invalid struct KineticDpFlashInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    str = fu_struct_kinetic_dp_flash_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
