/* auto-generated, do not modify */
#include "config.h"

#include "fu-synaptics-cxaudio-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_synaptics_cxaudio_device_kind_to_string(FuSynapticsCxaudioDeviceKind val)
{
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_UNKNOWN)
        return "unknown";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX20562)
        return "cx20562";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2070X)
        return "cx2070x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2077X)
        return "cx2077x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2076X)
        return "cx2076x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2085X)
        return "cx2085x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2089X)
        return "cx2089x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2098X)
        return "cx2098x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2198X)
        return "cx2198x";
    return NULL;
}


const gchar *
fu_synaptics_cxaudio_file_kind_to_string(FuSynapticsCxaudioFileKind val)
{
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_UNKNOWN)
        return "unknown";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2070X_FW)
        return "cx2070x-fw";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2070X_PATCH)
        return "cx2070x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2077X_PATCH)
        return "cx2077x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2076X_PATCH)
        return "cx2076x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2085X_PATCH)
        return "cx2085x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2089X_PATCH)
        return "cx2089x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2098X_PATCH)
        return "cx2098x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2198X_PATCH)
        return "cx2198x-patch";
    return NULL;
}
/* getters */
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version: (skip):
 **/
const guint8 *
fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 3;
    return st->data + 2;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version: (skip):
 **/
const guint8 *
fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->data + 5;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_layout_signature: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_layout_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_layout_version: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_layout_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_application_status: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_application_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_vendor_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_vendor_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_product_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_product_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_revision_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_revision_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_language_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_language_string_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_product_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_product_string_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_custom_info_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_custom_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapticsCxaudioCustomInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  patch_version_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  cpx_patch_version: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  spx_patch_version: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  layout_signature: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_layout_signature(st));
    g_string_append_printf(str, "  layout_version: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_layout_version(st));
    g_string_append_printf(str, "  application_status: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_application_status(st));
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_vendor_id(st));
    g_string_append_printf(str, "  product_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_product_id(st));
    g_string_append_printf(str, "  revision_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_revision_id(st));
    g_string_append_printf(str, "  language_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_language_string_address(st));
    g_string_append_printf(str, "  manufacturer_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address(st));
    g_string_append_printf(str, "  product_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_product_string_address(st));
    g_string_append_printf(str, "  serial_number_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_parse: (skip):
 **/
GByteArray *
fu_struct_synaptics_cxaudio_custom_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 26, error)) {
        g_prefix_error(error, "invalid struct SynapticsCxaudioCustomInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 26);
    str = fu_struct_synaptics_cxaudio_custom_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaptics_cxaudio_string_header_get_length: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_string_header_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_string_header_get_type: (skip):
 **/
static guint8
fu_struct_synaptics_cxaudio_string_header_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_string_header_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_string_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapticsCxaudioStringHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_string_header_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaptics_cxaudio_string_header_parse: (skip):
 **/
GByteArray *
fu_struct_synaptics_cxaudio_string_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error(error, "invalid struct SynapticsCxaudioStringHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 2);
    if (fu_struct_synaptics_cxaudio_string_header_get_type(st) != 0x03) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant SynapticsCxaudioStringHeader.type was not valid, expected 0x03");
        return NULL;
    }
    str = fu_struct_synaptics_cxaudio_string_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_validity_signature_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_validity_signature_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapticsCxaudioValiditySignature:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  magic_byte: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte(st));
    g_string_append_printf(str, "  eeprom_size_code: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaptics_cxaudio_validity_signature_parse: (skip):
 **/
GByteArray *
fu_struct_synaptics_cxaudio_validity_signature_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error(error, "invalid struct SynapticsCxaudioValiditySignature: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 2);
    str = fu_struct_synaptics_cxaudio_validity_signature_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaptics_cxaudio_patch_info_get_patch_signature: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_patch_info_get_patch_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_get_patch_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_patch_info_get_patch_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_patch_info_set_patch_signature: (skip):
 **/
void
fu_struct_synaptics_cxaudio_patch_info_set_patch_signature(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_set_patch_address: (skip):
 **/
void
fu_struct_synaptics_cxaudio_patch_info_set_patch_address(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_patch_info_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapticsCxaudioPatchInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  patch_signature: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_patch_info_get_patch_signature(st));
    g_string_append_printf(str, "  patch_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_patch_info_get_patch_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_parse: (skip):
 **/
GByteArray *
fu_struct_synaptics_cxaudio_patch_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error(error, "invalid struct SynapticsCxaudioPatchInfo: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    str = fu_struct_synaptics_cxaudio_patch_info_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
