/* auto-generated, do not modify */
#include "config.h"

#include "fu-synaptics-rmi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_rmi_partition_id_to_string(FuRmiPartitionId val)
{
    if (val == FU_RMI_PARTITION_ID_NONE)
        return "none";
    if (val == FU_RMI_PARTITION_ID_BOOTLOADER)
        return "bootloader";
    if (val == FU_RMI_PARTITION_ID_DEVICE_CONFIG)
        return "device-config";
    if (val == FU_RMI_PARTITION_ID_FLASH_CONFIG)
        return "flash-config";
    if (val == FU_RMI_PARTITION_ID_MANUFACTURING_BLOCK)
        return "manufacturing-block";
    if (val == FU_RMI_PARTITION_ID_GUEST_SERIALIZATION)
        return "guest-serialization";
    if (val == FU_RMI_PARTITION_ID_GLOBAL_PARAMETERS)
        return "global-parameters";
    if (val == FU_RMI_PARTITION_ID_CORE_CODE)
        return "core-code";
    if (val == FU_RMI_PARTITION_ID_CORE_CONFIG)
        return "core-config";
    if (val == FU_RMI_PARTITION_ID_GUEST_CODE)
        return "guest-code";
    if (val == FU_RMI_PARTITION_ID_DISPLAY_CONFIG)
        return "display-config";
    if (val == FU_RMI_PARTITION_ID_EXTERNAL_TOUCH_AFE_CONFIG)
        return "external-touch-afe-config";
    if (val == FU_RMI_PARTITION_ID_UTILITY_PARAMETER)
        return "utility-parameter";
    if (val == FU_RMI_PARTITION_ID_PUBKEY)
        return "pubkey";
    if (val == FU_RMI_PARTITION_ID_FIXED_LOCATION_DATA)
        return "fixed-location-data";
    return NULL;
}

const gchar *
fu_rmi_container_id_to_string(FuRmiContainerId val)
{
    if (val == FU_RMI_CONTAINER_ID_TOP_LEVEL)
        return "top-level";
    if (val == FU_RMI_CONTAINER_ID_UI)
        return "ui";
    if (val == FU_RMI_CONTAINER_ID_UI_CONFIG)
        return "ui-config";
    if (val == FU_RMI_CONTAINER_ID_BL)
        return "bl";
    if (val == FU_RMI_CONTAINER_ID_BL_IMAGE)
        return "bl-image";
    if (val == FU_RMI_CONTAINER_ID_BL_CONFIG)
        return "bl-config";
    if (val == FU_RMI_CONTAINER_ID_BL_LOCKDOWN_INFO)
        return "bl-lockdown-info";
    if (val == FU_RMI_CONTAINER_ID_PERMANENT_CONFIG)
        return "permanent-config";
    if (val == FU_RMI_CONTAINER_ID_GUEST_CODE)
        return "guest-code";
    if (val == FU_RMI_CONTAINER_ID_BL_PROTOCOL_DESCRIPTOR)
        return "bl-protocol-descriptor";
    if (val == FU_RMI_CONTAINER_ID_UI_PROTOCOL_DESCRIPTOR)
        return "ui-protocol-descriptor";
    if (val == FU_RMI_CONTAINER_ID_RMI_SELF_DISCOVERY)
        return "rmi-self-discovery";
    if (val == FU_RMI_CONTAINER_ID_RMI_PAGE_CONTENT)
        return "rmi-page-content";
    if (val == FU_RMI_CONTAINER_ID_GENERAL_INFORMATION)
        return "general-information";
    if (val == FU_RMI_CONTAINER_ID_DEVICE_CONFIG)
        return "device-config";
    if (val == FU_RMI_CONTAINER_ID_FLASH_CONFIG)
        return "flash-config";
    if (val == FU_RMI_CONTAINER_ID_GUEST_SERIALIZATION)
        return "guest-serialization";
    if (val == FU_RMI_CONTAINER_ID_GLOBAL_PARAMETERS)
        return "global-parameters";
    if (val == FU_RMI_CONTAINER_ID_CORE_CODE)
        return "core-code";
    if (val == FU_RMI_CONTAINER_ID_CORE_CONFIG)
        return "core-config";
    if (val == FU_RMI_CONTAINER_ID_DISPLAY_CONFIG)
        return "display-config";
    if (val == FU_RMI_CONTAINER_ID_EXTERNAL_TOUCH_AFE_CONFIG)
        return "external-touch-afe-config";
    if (val == FU_RMI_CONTAINER_ID_UTILITY)
        return "utility";
    if (val == FU_RMI_CONTAINER_ID_UTILITY_PARAMETER)
        return "utility-parameter";
    if (val == FU_RMI_CONTAINER_ID_FIXED_LOCATION_DATA)
        return "fixed-location-data";
    return NULL;
}
/* getters */
/**
 * fu_struct_rmi_partition_tbl_get_partition_id: (skip):
 **/
FuRmiPartitionId
fu_struct_rmi_partition_tbl_get_partition_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_len: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_addr: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_addr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_prop: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_prop(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_partition_tbl_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_partition_tbl_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("RmiPartitionTbl:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_rmi_partition_id_to_string(fu_struct_rmi_partition_tbl_get_partition_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  partition_id: 0x%x [%s]\n", (guint) fu_struct_rmi_partition_tbl_get_partition_id(st), tmp);
        } else {
            g_string_append_printf(str, "  partition_id: 0x%x\n", (guint) fu_struct_rmi_partition_tbl_get_partition_id(st));
        }
    }
    g_string_append_printf(str, "  partition_len: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_len(st));
    g_string_append_printf(str, "  partition_addr: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_addr(st));
    g_string_append_printf(str, "  partition_prop: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_prop(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_rmi_partition_tbl_parse: (skip):
 **/
GByteArray *
fu_struct_rmi_partition_tbl_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct RmiPartitionTbl: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_rmi_partition_tbl_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_rmi_img_get_checksum: (skip):
 **/
guint32
fu_struct_rmi_img_get_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_io_offset: (skip):
 **/
guint8
fu_struct_rmi_img_get_io_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[6];
}
/**
 * fu_struct_rmi_img_get_bootloader_version: (skip):
 **/
guint8
fu_struct_rmi_img_get_bootloader_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_rmi_img_get_image_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_image_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_config_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_config_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_product_id: (skip):
 **/
gchar *
fu_struct_rmi_img_get_product_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 16, 10, NULL);
}
/**
 * fu_struct_rmi_img_get_package_id: (skip):
 **/
guint32
fu_struct_rmi_img_get_package_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_product_info: (skip):
 **/
guint32
fu_struct_rmi_img_get_product_info(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 30, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_fw_build_id: (skip):
 **/
guint32
fu_struct_rmi_img_get_fw_build_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 80, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_signature_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_signature_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 84, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_img_set_checksum: (skip):
 **/
void
fu_struct_rmi_img_set_checksum(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_io_offset: (skip):
 **/
void
fu_struct_rmi_img_set_io_offset(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[6] = value;
}
/**
 * fu_struct_rmi_img_set_bootloader_version: (skip):
 **/
void
fu_struct_rmi_img_set_bootloader_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[7] = value;
}
/**
 * fu_struct_rmi_img_set_image_size: (skip):
 **/
void
fu_struct_rmi_img_set_image_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_config_size: (skip):
 **/
void
fu_struct_rmi_img_set_config_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_product_id: (skip):
 **/
gboolean
fu_struct_rmi_img_set_product_id(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 16, 0x0, 10);
        return TRUE;
    }
    len = strlen(value);
    if (len > 10) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in RmiImg.product_id (0x%x bytes)",
                    value, (guint) len, (guint) 10);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_rmi_img_set_package_id: (skip):
 **/
void
fu_struct_rmi_img_set_package_id(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_product_info: (skip):
 **/
void
fu_struct_rmi_img_set_product_info(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_fw_build_id: (skip):
 **/
void
fu_struct_rmi_img_set_fw_build_id(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 80, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_signature_size: (skip):
 **/
void
fu_struct_rmi_img_set_signature_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 84, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_new: (skip):
 **/
GByteArray *
fu_struct_rmi_img_new(void)
{
    GByteArray *st = g_byte_array_sized_new(88);
    fu_byte_array_set_size(st, 88, 0x0);
    return st;
}
/**
 * fu_struct_rmi_img_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_img_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("RmiImg:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_checksum(st));
    g_string_append_printf(str, "  io_offset: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_io_offset(st));
    g_string_append_printf(str, "  bootloader_version: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_bootloader_version(st));
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_image_size(st));
    g_string_append_printf(str, "  config_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_config_size(st));
    {
        g_autofree gchar *tmp = fu_struct_rmi_img_get_product_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  product_id: %s\n", tmp);
    }
    g_string_append_printf(str, "  package_id: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_package_id(st));
    g_string_append_printf(str, "  product_info: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_product_info(st));
    g_string_append_printf(str, "  fw_build_id: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_fw_build_id(st));
    g_string_append_printf(str, "  signature_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_signature_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_rmi_img_parse: (skip):
 **/
static GByteArray *
fu_struct_rmi_img_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 88, error)) {
        g_prefix_error(error, "invalid struct RmiImg: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 88);
    str = fu_struct_rmi_img_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_rmi_img_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_rmi_img_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_rmi_img_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_rmi_container_descriptor_get_content_checksum: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_container_id: (skip):
 **/
FuRmiContainerId
fu_struct_rmi_container_descriptor_get_container_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_minor_version: (skip):
 **/
guint8
fu_struct_rmi_container_descriptor_get_minor_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[6];
}
/**
 * fu_struct_rmi_container_descriptor_get_major_version: (skip):
 **/
guint8
fu_struct_rmi_container_descriptor_get_major_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_rmi_container_descriptor_get_signature_size: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_signature_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_container_option_flags: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_container_option_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_options_length: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_options_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_options_address: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_options_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_length: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_address: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_container_descriptor_set_content_checksum: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_checksum(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_container_id: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_container_id(GByteArray *st, FuRmiContainerId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_minor_version: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_minor_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[6] = value;
}
/**
 * fu_struct_rmi_container_descriptor_set_major_version: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_major_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[7] = value;
}
/**
 * fu_struct_rmi_container_descriptor_set_signature_size: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_signature_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_container_option_flags: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_container_option_flags(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_options_length: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_options_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_options_address: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_options_address(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_length: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_address: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_address(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_new: (skip):
 **/
GByteArray *
fu_struct_rmi_container_descriptor_new(void)
{
    GByteArray *st = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st, 32, 0x0);
    return st;
}
/**
 * fu_struct_rmi_container_descriptor_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_container_descriptor_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("RmiContainerDescriptor:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  content_checksum: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_checksum(st));
    {
        const gchar *tmp = fu_rmi_container_id_to_string(fu_struct_rmi_container_descriptor_get_container_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  container_id: 0x%x [%s]\n", (guint) fu_struct_rmi_container_descriptor_get_container_id(st), tmp);
        } else {
            g_string_append_printf(str, "  container_id: 0x%x\n", (guint) fu_struct_rmi_container_descriptor_get_container_id(st));
        }
    }
    g_string_append_printf(str, "  minor_version: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_minor_version(st));
    g_string_append_printf(str, "  major_version: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_major_version(st));
    g_string_append_printf(str, "  signature_size: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_signature_size(st));
    g_string_append_printf(str, "  container_option_flags: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_container_option_flags(st));
    g_string_append_printf(str, "  content_options_length: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_options_length(st));
    g_string_append_printf(str, "  content_options_address: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_options_address(st));
    g_string_append_printf(str, "  content_length: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_length(st));
    g_string_append_printf(str, "  content_address: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_rmi_container_descriptor_parse: (skip):
 **/
static GByteArray *
fu_struct_rmi_container_descriptor_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct RmiContainerDescriptor: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 32);
    str = fu_struct_rmi_container_descriptor_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_rmi_container_descriptor_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_rmi_container_descriptor_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_rmi_container_descriptor_parse(buf, bufsz, offset, error);
}
