/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * hugetlb.h - common definitions for the hugepage tests
 */

#ifndef __HUGETLB_H
#define __HUGETLB_H

#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <wait.h>
#include "test.h"

#define SHM_RD	0400
#define SHM_WR	0200
#define SHM_RW	(SHM_RD|SHM_WR)

#ifndef SHM_HUGETLB
#define SHM_HUGETLB	04000	/* segment is mapped via hugetlb */
#endif

/*
 * to get the lower nine permission bits
 * from shmid_ds.ipc_perm.mode
 */
#define MODE_MASK	0x01FF
#define PATH_HUGEPAGES	"/sys/kernel/mm/hugepages/"

key_t shmkey;			/* an IPC key generated by ftok() */

void check_hugepage(void);

int getipckey(void (*cleanup_fn) (void));
int getuserid(void (*cleanup_fn) (void), char *user);
void rm_shm(int shm_id);

char *nr_opt;
int sflag;
long orig_hugepages;

#endif /* hugetlb.h */
