/*
 * Xilinx Gamma Correction IP
 *
 * Copyright (C) 2017 Xilinx, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __XILINX_GAMMA_COEFF_H__

#define GAMMA_BPC_8		(8)
#define GAMMA_TABLE_LENGTH	BIT(GAMMA_BPC_8)
#define GAMMA_CURVE_LENGTH	(40)

static const u8 xgamma_01[GAMMA_TABLE_LENGTH] = {
	0, 147, 157, 164, 168, 172, 175, 178,
	180, 183, 184, 186, 188, 189, 191, 192,
	193, 195, 196, 197, 198, 199, 200, 200,
	201, 202, 203, 204, 204, 205, 206, 207,
	207, 208, 208, 209, 210, 210, 211, 211,
	212, 212, 213, 213, 214, 214, 215, 215,
	216, 216, 217, 217, 218, 218, 218, 219,
	219, 220, 220, 220, 221, 221, 221, 222,
	222, 222, 223, 223, 223, 224, 224, 224,
	225, 225, 225, 226, 226, 226, 227, 227,
	227, 227, 228, 228, 228, 228, 229, 229,
	229, 230, 230, 230, 230, 231, 231, 231,
	231, 232, 232, 232, 232, 232, 233, 233,
	233, 233, 234, 234, 234, 234, 234, 235,
	235, 235, 235, 235, 236, 236, 236, 236,
	236, 237, 237, 237, 237, 237, 238, 238,
	238, 238, 238, 239, 239, 239, 239, 239,
	239, 240, 240, 240, 240, 240, 240, 241,
	241, 241, 241, 241, 241, 242, 242, 242,
	242, 242, 242, 243, 243, 243, 243, 243,
	243, 244, 244, 244, 244, 244, 244, 244,
	245, 245, 245, 245, 245, 245, 245, 246,
	246, 246, 246, 246, 246, 246, 247, 247,
	247, 247, 247, 247, 247, 247, 248, 248,
	248, 248, 248, 248, 248, 249, 249, 249,
	249, 249, 249, 249, 249, 249, 250, 250,
	250, 250, 250, 250, 250, 250, 251, 251,
	251, 251, 251, 251, 251, 251, 251, 252,
	252, 252, 252, 252, 252, 252, 252, 252,
	253, 253, 253, 253, 253, 253, 253, 253,
	253, 254, 254, 254, 254, 254, 254, 254,
	254, 254, 254, 255, 255, 255, 255, 255,
};

static const u8 xgamma_02[GAMMA_TABLE_LENGTH] = {
	0, 84, 97, 105, 111, 116, 120, 124,
	128, 131, 133, 136, 138, 141, 143, 145,
	147, 148, 150, 152, 153, 155, 156, 158,
	159, 160, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 179, 180, 181, 182,
	183, 183, 184, 185, 186, 186, 187, 188,
	188, 189, 190, 190, 191, 192, 192, 193,
	193, 194, 195, 195, 196, 196, 197, 197,
	198, 199, 199, 200, 200, 201, 201, 202,
	202, 203, 203, 204, 204, 205, 205, 206,
	206, 207, 207, 208, 208, 208, 209, 209,
	210, 210, 211, 211, 211, 212, 212, 213,
	213, 214, 214, 214, 215, 215, 216, 216,
	216, 217, 217, 217, 218, 218, 219, 219,
	219, 220, 220, 220, 221, 221, 221, 222,
	222, 223, 223, 223, 224, 224, 224, 225,
	225, 225, 226, 226, 226, 227, 227, 227,
	227, 228, 228, 228, 229, 229, 229, 230,
	230, 230, 231, 231, 231, 231, 232, 232,
	232, 233, 233, 233, 233, 234, 234, 234,
	235, 235, 235, 235, 236, 236, 236, 237,
	237, 237, 237, 238, 238, 238, 238, 239,
	239, 239, 239, 240, 240, 240, 240, 241,
	241, 241, 241, 242, 242, 242, 242, 243,
	243, 243, 243, 244, 244, 244, 244, 245,
	245, 245, 245, 246, 246, 246, 246, 246,
	247, 247, 247, 247, 248, 248, 248, 248,
	248, 249, 249, 249, 249, 250, 250, 250,
	250, 250, 251, 251, 251, 251, 252, 252,
	252, 252, 252, 253, 253, 253, 253, 253,
	254, 254, 254, 254, 254, 255, 255, 255,
};

static const u8 xgamma_03[GAMMA_TABLE_LENGTH] = {
	0, 48, 60, 67, 73, 78, 83, 87,
	90, 94, 97, 99, 102, 104, 107, 109,
	111, 113, 115, 117, 119, 121, 122, 124,
	125, 127, 129, 130, 131, 133, 134, 136,
	137, 138, 139, 141, 142, 143, 144, 145,
	146, 147, 148, 149, 151, 152, 153, 154,
	155, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 164, 165, 166, 167, 168,
	168, 169, 170, 171, 172, 172, 173, 174,
	174, 175, 176, 177, 177, 178, 179, 179,
	180, 181, 181, 182, 183, 183, 184, 185,
	185, 186, 187, 187, 188, 188, 189, 190,
	190, 191, 191, 192, 193, 193, 194, 194,
	195, 195, 196, 197, 197, 198, 198, 199,
	199, 200, 200, 201, 201, 202, 202, 203,
	203, 204, 204, 205, 205, 206, 206, 207,
	207, 208, 208, 209, 209, 210, 210, 211,
	211, 212, 212, 213, 213, 213, 214, 214,
	215, 215, 216, 216, 217, 217, 217, 218,
	218, 219, 219, 220, 220, 220, 221, 221,
	222, 222, 223, 223, 223, 224, 224, 225,
	225, 225, 226, 226, 227, 227, 227, 228,
	228, 229, 229, 229, 230, 230, 230, 231,
	231, 232, 232, 232, 233, 233, 233, 234,
	234, 235, 235, 235, 236, 236, 236, 237,
	237, 237, 238, 238, 238, 239, 239, 240,
	240, 240, 241, 241, 241, 242, 242, 242,
	243, 243, 243, 244, 244, 244, 245, 245,
	245, 246, 246, 246, 247, 247, 247, 248,
	248, 248, 249, 249, 249, 249, 250, 250,
	250, 251, 251, 251, 252, 252, 252, 253,
	253, 253, 253, 254, 254, 254, 255, 255,
};

static const u8 xgamma_04[GAMMA_TABLE_LENGTH] = {
	0, 28, 37, 43, 48, 53, 57, 61,
	64, 67, 70, 73, 75, 78, 80, 82,
	84, 86, 88, 90, 92, 94, 96, 97,
	99, 101, 102, 104, 105, 107, 108, 110,
	111, 113, 114, 115, 117, 118, 119, 120,
	122, 123, 124, 125, 126, 127, 129, 130,
	131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146,
	147, 148, 149, 149, 150, 151, 152, 153,
	154, 155, 155, 156, 157, 158, 159, 160,
	160, 161, 162, 163, 164, 164, 165, 166,
	167, 167, 168, 169, 170, 170, 171, 172,
	173, 173, 174, 175, 175, 176, 177, 177,
	178, 179, 179, 180, 181, 182, 182, 183,
	183, 184, 185, 185, 186, 187, 187, 188,
	189, 189, 190, 190, 191, 192, 192, 193,
	194, 194, 195, 195, 196, 197, 197, 198,
	198, 199, 199, 200, 201, 201, 202, 202,
	203, 203, 204, 205, 205, 206, 206, 207,
	207, 208, 208, 209, 209, 210, 211, 211,
	212, 212, 213, 213, 214, 214, 215, 215,
	216, 216, 217, 217, 218, 218, 219, 219,
	220, 220, 221, 221, 222, 222, 223, 223,
	224, 224, 225, 225, 226, 226, 227, 227,
	228, 228, 229, 229, 230, 230, 230, 231,
	231, 232, 232, 233, 233, 234, 234, 235,
	235, 235, 236, 236, 237, 237, 238, 238,
	239, 239, 240, 240, 240, 241, 241, 242,
	242, 243, 243, 243, 244, 244, 245, 245,
	246, 246, 246, 247, 247, 248, 248, 248,
	249, 249, 250, 250, 251, 251, 251, 252,
	252, 253, 253, 253, 254, 254, 255, 255,
};

static const u8 xgamma_05[GAMMA_TABLE_LENGTH] = {
	0, 16, 23, 28, 32, 36, 39, 42,
	45, 48, 50, 53, 55, 58, 60, 62,
	64, 66, 68, 70, 71, 73, 75, 77,
	78, 80, 81, 83, 84, 86, 87, 89,
	90, 92, 93, 94, 96, 97, 98, 100,
	101, 102, 103, 105, 106, 107, 108, 109,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	135, 136, 137, 138, 139, 140, 141, 142,
	143, 144, 145, 145, 146, 147, 148, 149,
	150, 151, 151, 152, 153, 154, 155, 156,
	156, 157, 158, 159, 160, 160, 161, 162,
	163, 164, 164, 165, 166, 167, 167, 168,
	169, 170, 170, 171, 172, 173, 173, 174,
	175, 176, 176, 177, 178, 179, 179, 180,
	181, 181, 182, 183, 183, 184, 185, 186,
	186, 187, 188, 188, 189, 190, 190, 191,
	192, 192, 193, 194, 194, 195, 196, 196,
	197, 198, 198, 199, 199, 200, 201, 201,
	202, 203, 203, 204, 204, 205, 206, 206,
	207, 208, 208, 209, 209, 210, 211, 211,
	212, 212, 213, 214, 214, 215, 215, 216,
	217, 217, 218, 218, 219, 220, 220, 221,
	221, 222, 222, 223, 224, 224, 225, 225,
	226, 226, 227, 228, 228, 229, 229, 230,
	230, 231, 231, 232, 233, 233, 234, 234,
	235, 235, 236, 236, 237, 237, 238, 238,
	239, 240, 240, 241, 241, 242, 242, 243,
	243, 244, 244, 245, 245, 246, 246, 247,
	247, 248, 248, 249, 249, 250, 250, 251,
	251, 252, 252, 253, 253, 254, 254, 255,
};

static const u8 xgamma_06[GAMMA_TABLE_LENGTH] = {
	0, 9, 14, 18, 21, 24, 27, 29,
	32, 34, 37, 39, 41, 43, 45, 47,
	48, 50, 52, 54, 55, 57, 59, 60,
	62, 63, 65, 66, 68, 69, 71, 72,
	73, 75, 76, 77, 79, 80, 81, 83,
	84, 85, 86, 88, 89, 90, 91, 92,
	94, 95, 96, 97, 98, 99, 100, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 120, 121, 122, 123, 124, 125, 126,
	127, 128, 129, 130, 131, 132, 133, 134,
	135, 136, 137, 137, 138, 139, 140, 141,
	142, 143, 144, 145, 145, 146, 147, 148,
	149, 150, 151, 151, 152, 153, 154, 155,
	156, 156, 157, 158, 159, 160, 161, 161,
	162, 163, 164, 165, 165, 166, 167, 168,
	169, 169, 170, 171, 172, 173, 173, 174,
	175, 176, 176, 177, 178, 179, 179, 180,
	181, 182, 182, 183, 184, 185, 185, 186,
	187, 188, 188, 189, 190, 191, 191, 192,
	193, 194, 194, 195, 196, 196, 197, 198,
	199, 199, 200, 201, 201, 202, 203, 203,
	204, 205, 206, 206, 207, 208, 208, 209,
	210, 210, 211, 212, 212, 213, 214, 214,
	215, 216, 216, 217, 218, 218, 219, 220,
	220, 221, 222, 222, 223, 224, 224, 225,
	226, 226, 227, 228, 228, 229, 230, 230,
	231, 231, 232, 233, 233, 234, 235, 235,
	236, 237, 237, 238, 238, 239, 240, 240,
	241, 242, 242, 243, 243, 244, 245, 245,
	246, 247, 247, 248, 248, 249, 250, 250,
	251, 251, 252, 253, 253, 254, 254, 255,
};

static const u8 xgamma_07[GAMMA_TABLE_LENGTH] = {
	0, 5, 9, 11, 14, 16, 18, 21,
	23, 25, 26, 28, 30, 32, 33, 35,
	37, 38, 40, 41, 43, 44, 46, 47,
	49, 50, 52, 53, 54, 56, 57, 58,
	60, 61, 62, 64, 65, 66, 67, 69,
	70, 71, 72, 73, 75, 76, 77, 78,
	79, 80, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 102, 103, 104,
	105, 106, 107, 108, 109, 110, 111, 112,
	113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 142,
	143, 144, 145, 146, 147, 148, 149, 150,
	150, 151, 152, 153, 154, 155, 156, 157,
	157, 158, 159, 160, 161, 162, 163, 163,
	164, 165, 166, 167, 168, 168, 169, 170,
	171, 172, 173, 173, 174, 175, 176, 177,
	178, 178, 179, 180, 181, 182, 182, 183,
	184, 185, 186, 186, 187, 188, 189, 190,
	190, 191, 192, 193, 194, 194, 195, 196,
	197, 197, 198, 199, 200, 201, 201, 202,
	203, 204, 204, 205, 206, 207, 208, 208,
	209, 210, 211, 211, 212, 213, 214, 214,
	215, 216, 217, 217, 218, 219, 220, 220,
	221, 222, 223, 223, 224, 225, 226, 226,
	227, 228, 228, 229, 230, 231, 231, 232,
	233, 234, 234, 235, 236, 237, 237, 238,
	239, 239, 240, 241, 242, 242, 243, 244,
	244, 245, 246, 247, 247, 248, 249, 249,
	250, 251, 251, 252, 253, 254, 254, 255,
};

static const u8 xgamma_08[GAMMA_TABLE_LENGTH] = {
	0, 3, 5, 7, 9, 11, 13, 14,
	16, 18, 19, 21, 22, 24, 25, 26,
	28, 29, 31, 32, 33, 35, 36, 37,
	39, 40, 41, 42, 44, 45, 46, 47,
	48, 50, 51, 52, 53, 54, 56, 57,
	58, 59, 60, 61, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 73, 74, 75,
	76, 77, 78, 79, 80, 81, 82, 83,
	84, 85, 86, 88, 89, 90, 91, 92,
	93, 94, 95, 96, 97, 98, 99, 100,
	101, 102, 103, 104, 105, 106, 107, 108,
	109, 110, 111, 112, 113, 114, 115, 116,
	117, 118, 119, 120, 121, 122, 123, 123,
	124, 125, 126, 127, 128, 129, 130, 131,
	132, 133, 134, 135, 136, 137, 138, 139,
	140, 140, 141, 142, 143, 144, 145, 146,
	147, 148, 149, 150, 151, 151, 152, 153,
	154, 155, 156, 157, 158, 159, 160, 161,
	161, 162, 163, 164, 165, 166, 167, 168,
	169, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 177, 178, 179, 180, 181, 182,
	183, 183, 184, 185, 186, 187, 188, 189,
	190, 190, 191, 192, 193, 194, 195, 196,
	196, 197, 198, 199, 200, 201, 202, 202,
	203, 204, 205, 206, 207, 207, 208, 209,
	210, 211, 212, 212, 213, 214, 215, 216,
	217, 217, 218, 219, 220, 221, 222, 222,
	223, 224, 225, 226, 227, 227, 228, 229,
	230, 231, 232, 232, 233, 234, 235, 236,
	236, 237, 238, 239, 240, 240, 241, 242,
	243, 244, 245, 245, 246, 247, 248, 249,
	249, 250, 251, 252, 253, 253, 254, 255,
};

static const u8 xgamma_09[GAMMA_TABLE_LENGTH] = {
	0, 2, 3, 5, 6, 7, 9, 10,
	11, 13, 14, 15, 16, 18, 19, 20,
	21, 22, 23, 25, 26, 27, 28, 29,
	30, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72,
	73, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89,
	90, 91, 92, 93, 94, 95, 96, 97,
	98, 99, 100, 101, 102, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113,
	114, 115, 116, 117, 118, 119, 120, 121,
	122, 123, 124, 125, 126, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136,
	137, 138, 139, 140, 141, 142, 143, 144,
	145, 146, 147, 148, 149, 150, 151, 152,
	152, 153, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 170, 171, 172, 173, 174,
	175, 176, 177, 178, 179, 180, 181, 182,
	183, 184, 185, 185, 186, 187, 188, 189,
	190, 191, 192, 193, 194, 195, 196, 197,
	198, 198, 199, 200, 201, 202, 203, 204,
	205, 206, 207, 208, 209, 210, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 221, 222, 223, 224, 225, 226,
	227, 228, 229, 230, 231, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241,
	241, 242, 243, 244, 245, 246, 247, 248,
	249, 250, 250, 251, 252, 253, 254, 255,
};

static const u8 xgamma_10[GAMMA_TABLE_LENGTH] = {
	0, 1, 2, 3, 4, 5, 6, 7,
	8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 143,
	144, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183,
	184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209, 210, 211, 212, 213, 214, 215,
	216, 217, 218, 219, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 245, 246, 247,
	248, 249, 250, 251, 252, 253, 254, 255,
};

static const u8 xgamma_11[GAMMA_TABLE_LENGTH] = {
	0, 1, 1, 2, 3, 3, 4, 5,
	6, 6, 7, 8, 9, 10, 10, 11,
	12, 13, 14, 15, 16, 16, 17, 18,
	19, 20, 21, 22, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 90, 91, 92, 93, 94,
	95, 96, 97, 98, 99, 100, 101, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 143,
	144, 145, 146, 147, 149, 150, 151, 152,
	153, 154, 155, 156, 157, 158, 159, 160,
	161, 162, 163, 164, 165, 166, 167, 169,
	170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 181, 182, 183, 184, 186,
	187, 188, 189, 190, 191, 192, 193, 194,
	195, 196, 197, 198, 199, 201, 202, 203,
	204, 205, 206, 207, 208, 209, 210, 211,
	212, 214, 215, 216, 217, 218, 219, 220,
	221, 222, 223, 224, 225, 227, 228, 229,
	230, 231, 232, 233, 234, 235, 236, 237,
	239, 240, 241, 242, 243, 244, 245, 246,
	247, 248, 250, 251, 252, 253, 254, 255,
};

static const u8 xgamma_12[GAMMA_TABLE_LENGTH] = {
	0, 0, 1, 1, 2, 2, 3, 3,
	4, 5, 5, 6, 7, 7, 8, 9,
	9, 10, 11, 11, 12, 13, 13, 14,
	15, 16, 16, 17, 18, 19, 20, 20,
	21, 22, 23, 24, 24, 25, 26, 27,
	28, 28, 29, 30, 31, 32, 33, 34,
	34, 35, 36, 37, 38, 39, 40, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 90, 91, 92, 93, 94,
	95, 96, 97, 98, 99, 100, 101, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 123, 124, 125, 126, 127,
	128, 130, 131, 132, 133, 134, 135, 136,
	137, 138, 139, 140, 141, 142, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 153,
	155, 156, 157, 158, 159, 160, 161, 162,
	163, 165, 166, 167, 168, 169, 170, 171,
	172, 173, 175, 176, 177, 178, 179, 180,
	181, 183, 184, 185, 186, 187, 188, 189,
	191, 192, 193, 194, 195, 196, 197, 199,
	200, 201, 202, 203, 204, 205, 207, 208,
	209, 210, 211, 212, 214, 215, 216, 217,
	218, 219, 221, 222, 223, 224, 225, 226,
	228, 229, 230, 231, 232, 234, 235, 236,
	237, 238, 239, 241, 242, 243, 244, 245,
	247, 248, 249, 250, 251, 253, 254, 255,
};

static const u8 xgamma_13[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 1, 1, 2, 2, 2,
	3, 3, 4, 4, 5, 5, 6, 6,
	7, 8, 8, 9, 9, 10, 11, 11,
	12, 12, 13, 14, 14, 15, 16, 16,
	17, 18, 19, 19, 20, 21, 21, 22,
	23, 24, 24, 25, 26, 27, 28, 28,
	29, 30, 31, 31, 32, 33, 34, 35,
	36, 36, 37, 38, 39, 40, 41, 41,
	42, 43, 44, 45, 46, 47, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 112,
	113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 124, 125, 126, 127, 128, 129,
	130, 131, 132, 133, 135, 136, 137, 138,
	139, 140, 141, 143, 144, 145, 146, 147,
	148, 149, 151, 152, 153, 154, 155, 156,
	157, 159, 160, 161, 162, 163, 164, 166,
	167, 168, 169, 170, 172, 173, 174, 175,
	176, 178, 179, 180, 181, 182, 184, 185,
	186, 187, 188, 190, 191, 192, 193, 194,
	196, 197, 198, 199, 201, 202, 203, 204,
	206, 207, 208, 209, 210, 212, 213, 214,
	215, 217, 218, 219, 220, 222, 223, 224,
	226, 227, 228, 229, 231, 232, 233, 234,
	236, 237, 238, 240, 241, 242, 243, 245,
	246, 247, 249, 250, 251, 252, 254, 255,
};

static const u8 xgamma_14[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 1, 1, 1, 1, 2,
	2, 2, 3, 3, 4, 4, 4, 5,
	5, 6, 6, 7, 7, 8, 8, 9,
	9, 10, 10, 11, 12, 12, 13, 13,
	14, 15, 15, 16, 16, 17, 18, 18,
	19, 20, 20, 21, 22, 22, 23, 24,
	25, 25, 26, 27, 28, 28, 29, 30,
	31, 31, 32, 33, 34, 34, 35, 36,
	37, 38, 38, 39, 40, 41, 42, 43,
	43, 44, 45, 46, 47, 48, 49, 49,
	50, 51, 52, 53, 54, 55, 56, 57,
	57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 85, 86, 87, 88,
	89, 90, 91, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113,
	115, 116, 117, 118, 119, 120, 121, 122,
	124, 125, 126, 127, 128, 129, 130, 132,
	133, 134, 135, 136, 137, 139, 140, 141,
	142, 143, 145, 146, 147, 148, 149, 151,
	152, 153, 154, 155, 157, 158, 159, 160,
	161, 163, 164, 165, 166, 168, 169, 170,
	171, 173, 174, 175, 176, 178, 179, 180,
	181, 183, 184, 185, 187, 188, 189, 190,
	192, 193, 194, 196, 197, 198, 200, 201,
	202, 203, 205, 206, 207, 209, 210, 211,
	213, 214, 215, 217, 218, 219, 221, 222,
	223, 225, 226, 227, 229, 230, 232, 233,
	234, 236, 237, 238, 240, 241, 242, 244,
	245, 247, 248, 249, 251, 252, 254, 255,
};

static const u8 xgamma_15[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 2, 2, 2, 3, 3, 3, 4,
	4, 4, 5, 5, 6, 6, 6, 7,
	7, 8, 8, 9, 9, 10, 10, 11,
	11, 12, 12, 13, 14, 14, 15, 15,
	16, 16, 17, 18, 18, 19, 20, 20,
	21, 21, 22, 23, 23, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 31, 31,
	32, 33, 34, 34, 35, 36, 37, 37,
	38, 39, 40, 41, 41, 42, 43, 44,
	45, 46, 46, 47, 48, 49, 50, 51,
	52, 53, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 65,
	66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 88, 89, 90,
	91, 92, 93, 94, 95, 96, 97, 98,
	99, 100, 102, 103, 104, 105, 106, 107,
	108, 109, 110, 112, 113, 114, 115, 116,
	117, 119, 120, 121, 122, 123, 124, 126,
	127, 128, 129, 130, 132, 133, 134, 135,
	136, 138, 139, 140, 141, 142, 144, 145,
	146, 147, 149, 150, 151, 152, 154, 155,
	156, 158, 159, 160, 161, 163, 164, 165,
	167, 168, 169, 171, 172, 173, 174, 176,
	177, 178, 180, 181, 182, 184, 185, 187,
	188, 189, 191, 192, 193, 195, 196, 197,
	199, 200, 202, 203, 204, 206, 207, 209,
	210, 211, 213, 214, 216, 217, 218, 220,
	221, 223, 224, 226, 227, 228, 230, 231,
	233, 234, 236, 237, 239, 240, 242, 243,
	245, 246, 248, 249, 251, 252, 254, 255,
};

static const u8 xgamma_16[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 3,
	3, 3, 4, 4, 4, 5, 5, 5,
	6, 6, 7, 7, 7, 8, 8, 9,
	9, 10, 10, 11, 11, 12, 12, 13,
	13, 14, 14, 15, 15, 16, 16, 17,
	18, 18, 19, 19, 20, 21, 21, 22,
	23, 23, 24, 25, 25, 26, 27, 27,
	28, 29, 29, 30, 31, 31, 32, 33,
	34, 34, 35, 36, 37, 38, 38, 39,
	40, 41, 42, 42, 43, 44, 45, 46,
	46, 47, 48, 49, 50, 51, 52, 53,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75,
	76, 77, 78, 79, 80, 81, 83, 84,
	85, 86, 87, 88, 89, 90, 91, 92,
	93, 94, 95, 97, 98, 99, 100, 101,
	102, 103, 104, 106, 107, 108, 109, 110,
	111, 113, 114, 115, 116, 117, 119, 120,
	121, 122, 123, 125, 126, 127, 128, 130,
	131, 132, 133, 135, 136, 137, 138, 140,
	141, 142, 143, 145, 146, 147, 149, 150,
	151, 153, 154, 155, 157, 158, 159, 161,
	162, 163, 165, 166, 167, 169, 170, 171,
	173, 174, 176, 177, 178, 180, 181, 183,
	184, 185, 187, 188, 190, 191, 193, 194,
	196, 197, 198, 200, 201, 203, 204, 206,
	207, 209, 210, 212, 213, 215, 216, 218,
	219, 221, 222, 224, 225, 227, 228, 230,
	231, 233, 235, 236, 238, 239, 241, 242,
	244, 245, 247, 249, 250, 252, 253, 255,
};

static const u8 xgamma_17[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 2, 2, 2,
	2, 3, 3, 3, 3, 4, 4, 4,
	5, 5, 5, 6, 6, 6, 7, 7,
	7, 8, 8, 9, 9, 10, 10, 10,
	11, 11, 12, 12, 13, 13, 14, 14,
	15, 15, 16, 17, 17, 18, 18, 19,
	19, 20, 21, 21, 22, 22, 23, 24,
	24, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 33, 33, 34, 35,
	36, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	88, 89, 90, 91, 92, 93, 94, 95,
	97, 98, 99, 100, 101, 102, 103, 105,
	106, 107, 108, 109, 111, 112, 113, 114,
	115, 117, 118, 119, 120, 122, 123, 124,
	125, 127, 128, 129, 131, 132, 133, 134,
	136, 137, 138, 140, 141, 142, 144, 145,
	146, 148, 149, 151, 152, 153, 155, 156,
	157, 159, 160, 162, 163, 164, 166, 167,
	169, 170, 172, 173, 174, 176, 177, 179,
	180, 182, 183, 185, 186, 188, 189, 191,
	192, 194, 195, 197, 198, 200, 201, 203,
	205, 206, 208, 209, 211, 212, 214, 216,
	217, 219, 220, 222, 224, 225, 227, 228,
	230, 232, 233, 235, 237, 238, 240, 242,
	243, 245, 247, 248, 250, 252, 253, 255,
};

static const u8 xgamma_18[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	4, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 8, 8, 8, 9,
	9, 10, 10, 10, 11, 11, 12, 12,
	13, 13, 14, 14, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 21,
	21, 22, 22, 23, 24, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 30, 31,
	32, 32, 33, 34, 35, 35, 36, 37,
	38, 38, 39, 40, 41, 41, 42, 43,
	44, 45, 46, 46, 47, 48, 49, 50,
	51, 52, 53, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65,
	66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 86, 87, 88, 89, 90,
	91, 92, 93, 95, 96, 97, 98, 99,
	100, 102, 103, 104, 105, 107, 108, 109,
	110, 111, 113, 114, 115, 116, 118, 119,
	120, 122, 123, 124, 126, 127, 128, 129,
	131, 132, 134, 135, 136, 138, 139, 140,
	142, 143, 145, 146, 147, 149, 150, 152,
	153, 154, 156, 157, 159, 160, 162, 163,
	165, 166, 168, 169, 171, 172, 174, 175,
	177, 178, 180, 181, 183, 184, 186, 188,
	189, 191, 192, 194, 195, 197, 199, 200,
	202, 204, 205, 207, 208, 210, 212, 213,
	215, 217, 218, 220, 222, 224, 225, 227,
	229, 230, 232, 234, 236, 237, 239, 241,
	243, 244, 246, 248, 250, 251, 253, 255,
};

static const u8 xgamma_19[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 4, 4, 4, 4, 5,
	5, 5, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	11, 11, 12, 12, 12, 13, 13, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 20, 20, 21, 21, 22, 22,
	23, 24, 24, 25, 26, 26, 27, 28,
	28, 29, 30, 30, 31, 32, 32, 33,
	34, 35, 35, 36, 37, 38, 38, 39,
	40, 41, 41, 42, 43, 44, 45, 46,
	46, 47, 48, 49, 50, 51, 52, 53,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 81, 82, 83, 84, 85,
	86, 87, 88, 90, 91, 92, 93, 94,
	95, 97, 98, 99, 100, 101, 103, 104,
	105, 106, 108, 109, 110, 112, 113, 114,
	115, 117, 118, 119, 121, 122, 123, 125,
	126, 127, 129, 130, 132, 133, 134, 136,
	137, 139, 140, 141, 143, 144, 146, 147,
	149, 150, 152, 153, 155, 156, 158, 159,
	161, 162, 164, 165, 167, 168, 170, 172,
	173, 175, 176, 178, 180, 181, 183, 184,
	186, 188, 189, 191, 193, 194, 196, 198,
	199, 201, 203, 204, 206, 208, 210, 211,
	213, 215, 217, 218, 220, 222, 224, 225,
	227, 229, 231, 233, 235, 236, 238, 240,
	242, 244, 246, 247, 249, 251, 253, 255,
};

static const u8 xgamma_20[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 4, 4,
	4, 4, 5, 5, 5, 5, 6, 6,
	6, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	20, 21, 21, 22, 23, 23, 24, 24,
	25, 26, 26, 27, 28, 28, 29, 30,
	30, 31, 32, 32, 33, 34, 35, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	42, 43, 44, 45, 46, 47, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 84, 85, 86, 87, 88, 89,
	91, 92, 93, 94, 95, 97, 98, 99,
	100, 102, 103, 104, 105, 107, 108, 109,
	111, 112, 113, 115, 116, 117, 119, 120,
	121, 123, 124, 126, 127, 128, 130, 131,
	133, 134, 136, 137, 139, 140, 142, 143,
	145, 146, 148, 149, 151, 152, 154, 155,
	157, 158, 160, 162, 163, 165, 166, 168,
	170, 171, 173, 175, 176, 178, 180, 181,
	183, 185, 186, 188, 190, 192, 193, 195,
	197, 199, 200, 202, 204, 206, 207, 209,
	211, 213, 215, 217, 218, 220, 222, 224,
	226, 228, 230, 232, 233, 235, 237, 239,
	241, 243, 245, 247, 249, 251, 253, 255,
};

static const u8 xgamma_21[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 5, 5,
	5, 5, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	11, 11, 11, 12, 12, 13, 13, 14,
	14, 14, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 20, 20, 21, 21, 22,
	22, 23, 24, 24, 25, 25, 26, 27,
	27, 28, 29, 29, 30, 31, 31, 32,
	33, 33, 34, 35, 36, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 44,
	45, 46, 47, 48, 49, 50, 51, 51,
	52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 75, 76,
	77, 78, 79, 80, 81, 83, 84, 85,
	86, 87, 88, 90, 91, 92, 93, 95,
	96, 97, 98, 100, 101, 102, 104, 105,
	106, 107, 109, 110, 112, 113, 114, 116,
	117, 118, 120, 121, 123, 124, 126, 127,
	129, 130, 131, 133, 134, 136, 137, 139,
	141, 142, 144, 145, 147, 148, 150, 151,
	153, 155, 156, 158, 160, 161, 163, 165,
	166, 168, 170, 171, 173, 175, 176, 178,
	180, 182, 183, 185, 187, 189, 191, 192,
	194, 196, 198, 200, 202, 203, 205, 207,
	209, 211, 213, 215, 217, 219, 221, 223,
	225, 226, 228, 230, 232, 234, 236, 238,
	241, 243, 245, 247, 249, 251, 253, 255,
};

static const u8 xgamma_22[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	25, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 33, 33, 34, 35,
	35, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	49, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	73, 74, 75, 76, 77, 78, 79, 81,
	82, 83, 84, 85, 87, 88, 89, 90,
	91, 93, 94, 95, 97, 98, 99, 100,
	102, 103, 105, 106, 107, 109, 110, 111,
	113, 114, 116, 117, 119, 120, 121, 123,
	124, 126, 127, 129, 130, 132, 133, 135,
	137, 138, 140, 141, 143, 145, 146, 148,
	149, 151, 153, 154, 156, 158, 159, 161,
	163, 165, 166, 168, 170, 172, 173, 175,
	177, 179, 181, 182, 184, 186, 188, 190,
	192, 194, 196, 197, 199, 201, 203, 205,
	207, 209, 211, 213, 215, 217, 219, 221,
	223, 225, 227, 229, 231, 234, 236, 238,
	240, 242, 244, 246, 248, 251, 253, 255,
};

static const u8 xgamma_23[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 10, 10, 10,
	11, 11, 11, 12, 12, 13, 13, 13,
	14, 14, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 19, 20, 20, 21, 21,
	22, 23, 23, 24, 24, 25, 26, 26,
	27, 28, 28, 29, 30, 30, 31, 32,
	32, 33, 34, 35, 35, 36, 37, 38,
	38, 39, 40, 41, 42, 42, 43, 44,
	45, 46, 47, 48, 49, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67,
	69, 70, 71, 72, 73, 74, 75, 76,
	78, 79, 80, 81, 82, 84, 85, 86,
	87, 89, 90, 91, 92, 94, 95, 96,
	98, 99, 100, 102, 103, 104, 106, 107,
	109, 110, 112, 113, 114, 116, 117, 119,
	120, 122, 123, 125, 126, 128, 130, 131,
	133, 134, 136, 138, 139, 141, 143, 144,
	146, 148, 149, 151, 153, 154, 156, 158,
	160, 161, 163, 165, 167, 169, 170, 172,
	174, 176, 178, 180, 182, 183, 185, 187,
	189, 191, 193, 195, 197, 199, 201, 203,
	205, 207, 209, 211, 213, 215, 218, 220,
	222, 224, 226, 228, 230, 233, 235, 237,
	239, 241, 244, 246, 248, 250, 253, 255,
};

static const u8 xgamma_24[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 6, 6, 6, 6,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 14, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	24, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 32, 33, 34, 35,
	35, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 53, 54, 55,
	56, 57, 58, 59, 60, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 73,
	74, 75, 76, 77, 78, 80, 81, 82,
	83, 85, 86, 87, 88, 90, 91, 92,
	94, 95, 96, 98, 99, 100, 102, 103,
	105, 106, 108, 109, 111, 112, 114, 115,
	117, 118, 120, 121, 123, 124, 126, 127,
	129, 131, 132, 134, 136, 137, 139, 141,
	142, 144, 146, 148, 149, 151, 153, 155,
	156, 158, 160, 162, 164, 166, 167, 169,
	171, 173, 175, 177, 179, 181, 183, 185,
	187, 189, 191, 193, 195, 197, 199, 201,
	203, 205, 207, 210, 212, 214, 216, 218,
	220, 223, 225, 227, 229, 232, 234, 236,
	239, 241, 243, 246, 248, 250, 253, 255,
};

static const u8 xgamma_25[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 6,
	6, 6, 6, 7, 7, 7, 7, 8,
	8, 8, 9, 9, 9, 10, 10, 10,
	11, 11, 12, 12, 12, 13, 13, 14,
	14, 15, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 19, 20, 20, 21, 22,
	22, 23, 23, 24, 25, 25, 26, 26,
	27, 28, 28, 29, 30, 30, 31, 32,
	33, 33, 34, 35, 36, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 67, 68, 69,
	70, 71, 72, 73, 75, 76, 77, 78,
	80, 81, 82, 83, 85, 86, 87, 89,
	90, 91, 93, 94, 95, 97, 98, 99,
	101, 102, 104, 105, 107, 108, 110, 111,
	113, 114, 116, 117, 119, 121, 122, 124,
	125, 127, 129, 130, 132, 134, 135, 137,
	139, 141, 142, 144, 146, 148, 150, 151,
	153, 155, 157, 159, 161, 163, 165, 166,
	168, 170, 172, 174, 176, 178, 180, 182,
	184, 186, 189, 191, 193, 195, 197, 199,
	201, 204, 206, 208, 210, 212, 215, 217,
	219, 221, 224, 226, 228, 231, 233, 235,
	238, 240, 243, 245, 248, 250, 253, 255,
};

static const u8 xgamma_26[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 8, 8, 8, 9, 9, 9,
	10, 10, 10, 11, 11, 11, 12, 12,
	13, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	20, 21, 21, 22, 22, 23, 24, 24,
	25, 25, 26, 27, 27, 28, 29, 29,
	30, 31, 31, 32, 33, 34, 34, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65,
	66, 68, 69, 70, 71, 72, 73, 75,
	76, 77, 78, 80, 81, 82, 84, 85,
	86, 88, 89, 90, 92, 93, 94, 96,
	97, 99, 100, 102, 103, 105, 106, 108,
	109, 111, 112, 114, 115, 117, 119, 120,
	122, 124, 125, 127, 129, 130, 132, 134,
	136, 137, 139, 141, 143, 145, 146, 148,
	150, 152, 154, 156, 158, 160, 162, 164,
	166, 168, 170, 172, 174, 176, 178, 180,
	182, 184, 186, 188, 191, 193, 195, 197,
	199, 202, 204, 206, 209, 211, 213, 215,
	218, 220, 223, 225, 227, 230, 232, 235,
	237, 240, 242, 245, 247, 250, 252, 255,
};

static const u8 xgamma_27[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 6, 6,
	6, 6, 7, 7, 7, 7, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 20, 21, 21, 22,
	23, 23, 24, 24, 25, 26, 26, 27,
	28, 28, 29, 30, 30, 31, 32, 33,
	33, 34, 35, 36, 36, 37, 38, 39,
	40, 41, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 50, 51, 51, 52, 53,
	55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 68, 69, 70, 71,
	72, 74, 75, 76, 77, 79, 80, 81,
	83, 84, 85, 87, 88, 89, 91, 92,
	94, 95, 97, 98, 100, 101, 103, 104,
	106, 107, 109, 110, 112, 114, 115, 117,
	119, 120, 122, 124, 125, 127, 129, 131,
	132, 134, 136, 138, 140, 141, 143, 145,
	147, 149, 151, 153, 155, 157, 159, 161,
	163, 165, 167, 169, 171, 173, 175, 178,
	180, 182, 184, 186, 188, 191, 193, 195,
	198, 200, 202, 205, 207, 209, 212, 214,
	216, 219, 221, 224, 226, 229, 231, 234,
	237, 239, 242, 244, 247, 250, 252, 255,
};

static const u8 xgamma_28[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 6, 6, 6, 6, 7, 7, 7,
	7, 8, 8, 8, 9, 9, 9, 10,
	10, 10, 11, 11, 11, 12, 12, 13,
	13, 13, 14, 14, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 20,
	21, 21, 22, 22, 23, 24, 24, 25,
	25, 26, 27, 27, 28, 29, 29, 30,
	31, 32, 32, 33, 34, 35, 35, 36,
	37, 38, 39, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 50,
	51, 52, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 66, 67, 68,
	69, 70, 72, 73, 74, 75, 77, 78,
	79, 81, 82, 83, 85, 86, 87, 89,
	90, 92, 93, 95, 96, 98, 99, 101,
	102, 104, 105, 107, 109, 110, 112, 114,
	115, 117, 119, 120, 122, 124, 126, 127,
	129, 131, 133, 135, 137, 138, 140, 142,
	144, 146, 148, 150, 152, 154, 156, 158,
	160, 162, 164, 167, 169, 171, 173, 175,
	177, 180, 182, 184, 186, 189, 191, 193,
	196, 198, 200, 203, 205, 208, 210, 213,
	215, 218, 220, 223, 225, 228, 231, 233,
	236, 239, 241, 244, 247, 249, 252, 255,
};

static const u8 xgamma_29[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 6, 6, 6, 6,
	7, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 9, 10, 10, 11, 11, 11,
	12, 12, 12, 13, 13, 14, 14, 15,
	15, 15, 16, 16, 17, 17, 18, 18,
	19, 19, 20, 21, 21, 22, 22, 23,
	23, 24, 25, 25, 26, 27, 27, 28,
	29, 29, 30, 31, 32, 32, 33, 34,
	35, 35, 36, 37, 38, 39, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 64, 65,
	66, 67, 68, 70, 71, 72, 73, 75,
	76, 77, 79, 80, 81, 83, 84, 86,
	87, 88, 90, 91, 93, 94, 96, 97,
	99, 101, 102, 104, 105, 107, 109, 110,
	112, 114, 115, 117, 119, 121, 122, 124,
	126, 128, 130, 132, 134, 135, 137, 139,
	141, 143, 145, 147, 149, 151, 153, 155,
	158, 160, 162, 164, 166, 168, 171, 173,
	175, 177, 180, 182, 184, 187, 189, 191,
	194, 196, 199, 201, 204, 206, 209, 211,
	214, 216, 219, 222, 224, 227, 230, 232,
	235, 238, 241, 244, 246, 249, 252, 255,
};

static const u8 xgamma_30[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 6,
	6, 6, 6, 6, 7, 7, 7, 8,
	8, 8, 8, 9, 9, 9, 10, 10,
	10, 11, 11, 12, 12, 12, 13, 13,
	14, 14, 14, 15, 15, 16, 16, 17,
	17, 18, 18, 19, 19, 20, 20, 21,
	22, 22, 23, 23, 24, 25, 25, 26,
	27, 27, 28, 29, 29, 30, 31, 32,
	32, 33, 34, 35, 35, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 60, 61, 62,
	63, 64, 65, 67, 68, 69, 70, 72,
	73, 74, 76, 77, 78, 80, 81, 82,
	84, 85, 87, 88, 90, 91, 93, 94,
	96, 97, 99, 101, 102, 104, 105, 107,
	109, 111, 112, 114, 116, 118, 119, 121,
	123, 125, 127, 129, 131, 132, 134, 136,
	138, 140, 142, 144, 147, 149, 151, 153,
	155, 157, 159, 162, 164, 166, 168, 171,
	173, 175, 178, 180, 182, 185, 187, 190,
	192, 195, 197, 200, 202, 205, 207, 210,
	213, 215, 218, 221, 223, 226, 229, 232,
	235, 237, 240, 243, 246, 249, 252, 255,
};

static const u8 xgamma_31[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 7,
	7, 7, 8, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 12, 12,
	12, 13, 13, 14, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	25, 25, 26, 27, 27, 28, 29, 29,
	30, 31, 32, 32, 33, 34, 35, 36,
	36, 37, 38, 39, 40, 41, 42, 42,
	43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 56, 57, 58, 59,
	60, 61, 62, 64, 65, 66, 67, 69,
	70, 71, 73, 74, 75, 77, 78, 79,
	81, 82, 84, 85, 87, 88, 90, 91,
	93, 94, 96, 97, 99, 101, 102, 104,
	106, 108, 109, 111, 113, 115, 116, 118,
	120, 122, 124, 126, 128, 130, 132, 134,
	136, 138, 140, 142, 144, 146, 148, 150,
	152, 155, 157, 159, 161, 164, 166, 168,
	171, 173, 175, 178, 180, 183, 185, 188,
	190, 193, 195, 198, 201, 203, 206, 209,
	211, 214, 217, 220, 222, 225, 228, 231,
	234, 237, 240, 243, 246, 249, 252, 255,
};

static const u8 xgamma_32[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 7, 7, 7, 8, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 21, 21, 22, 22,
	23, 23, 24, 25, 25, 26, 27, 27,
	28, 29, 30, 30, 31, 32, 33, 33,
	34, 35, 36, 37, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 59, 60, 61, 62, 63, 65, 66,
	67, 68, 70, 71, 72, 74, 75, 76,
	78, 79, 81, 82, 84, 85, 87, 88,
	90, 91, 93, 95, 96, 98, 99, 101,
	103, 105, 106, 108, 110, 112, 113, 115,
	117, 119, 121, 123, 125, 127, 129, 131,
	133, 135, 137, 139, 141, 143, 146, 148,
	150, 152, 154, 157, 159, 161, 164, 166,
	168, 171, 173, 176, 178, 181, 183, 186,
	188, 191, 194, 196, 199, 202, 204, 207,
	210, 213, 216, 219, 221, 224, 227, 230,
	233, 236, 239, 242, 246, 249, 252, 255,
};

static const u8 xgamma_33[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5,
	6, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 9, 10,
	10, 11, 11, 11, 12, 12, 12, 13,
	13, 14, 14, 15, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 21,
	21, 22, 22, 23, 24, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 31, 31,
	32, 33, 34, 34, 35, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, 51, 53, 54,
	55, 56, 57, 58, 59, 61, 62, 63,
	64, 66, 67, 68, 70, 71, 72, 74,
	75, 76, 78, 79, 81, 82, 84, 85,
	87, 88, 90, 92, 93, 95, 97, 98,
	100, 102, 103, 105, 107, 109, 111, 113,
	114, 116, 118, 120, 122, 124, 126, 128,
	130, 132, 134, 136, 139, 141, 143, 145,
	147, 150, 152, 154, 157, 159, 161, 164,
	166, 169, 171, 174, 176, 179, 181, 184,
	187, 189, 192, 195, 198, 200, 203, 206,
	209, 212, 215, 217, 220, 223, 226, 230,
	233, 236, 239, 242, 245, 248, 252, 255,
};

static const u8 xgamma_34[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 12, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 21, 22, 23, 23, 24,
	24, 25, 26, 26, 27, 28, 29, 29,
	30, 31, 32, 32, 33, 34, 35, 36,
	37, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 55, 56, 57, 58, 59, 60,
	62, 63, 64, 66, 67, 68, 70, 71,
	72, 74, 75, 77, 78, 80, 81, 83,
	84, 86, 87, 89, 90, 92, 94, 95,
	97, 99, 101, 102, 104, 106, 108, 110,
	112, 114, 115, 117, 119, 121, 123, 125,
	128, 130, 132, 134, 136, 138, 141, 143,
	145, 147, 150, 152, 154, 157, 159, 162,
	164, 167, 169, 172, 174, 177, 180, 182,
	185, 188, 190, 193, 196, 199, 202, 205,
	208, 210, 213, 216, 219, 223, 226, 229,
	232, 235, 238, 242, 245, 248, 252, 255,
};

static const u8 xgamma_35[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 5, 6, 6,
	6, 6, 7, 7, 7, 7, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 11, 12, 12, 13, 13, 13, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 20, 21, 22, 22,
	23, 23, 24, 25, 25, 26, 27, 28,
	28, 29, 30, 30, 31, 32, 33, 34,
	35, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 56, 57, 58,
	59, 60, 62, 63, 64, 66, 67, 68,
	70, 71, 72, 74, 75, 77, 78, 80,
	81, 83, 85, 86, 88, 89, 91, 93,
	94, 96, 98, 100, 102, 103, 105, 107,
	109, 111, 113, 115, 117, 119, 121, 123,
	125, 127, 129, 131, 134, 136, 138, 140,
	143, 145, 147, 150, 152, 155, 157, 159,
	162, 165, 167, 170, 172, 175, 178, 180,
	183, 186, 189, 192, 194, 197, 200, 203,
	206, 209, 212, 215, 219, 222, 225, 228,
	231, 235, 238, 241, 245, 248, 252, 255,
};

static const u8 xgamma_36[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 8, 9, 9, 9, 10,
	10, 10, 11, 11, 12, 12, 12, 13,
	13, 14, 14, 15, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 20, 20, 21,
	21, 22, 23, 23, 24, 24, 25, 26,
	27, 27, 28, 29, 29, 30, 31, 32,
	33, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 42, 43, 44, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 56,
	57, 58, 59, 61, 62, 63, 64, 66,
	67, 69, 70, 71, 73, 74, 76, 77,
	79, 80, 82, 83, 85, 87, 88, 90,
	92, 94, 95, 97, 99, 101, 103, 104,
	106, 108, 110, 112, 114, 116, 118, 120,
	122, 125, 127, 129, 131, 133, 136, 138,
	140, 143, 145, 147, 150, 152, 155, 157,
	160, 162, 165, 168, 170, 173, 176, 179,
	181, 184, 187, 190, 193, 196, 199, 202,
	205, 208, 211, 214, 218, 221, 224, 227,
	231, 234, 237, 241, 244, 248, 251, 255,
};

static const u8 xgamma_37[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 24, 24,
	25, 26, 26, 27, 28, 28, 29, 30,
	31, 32, 32, 33, 34, 35, 36, 37,
	38, 39, 39, 40, 41, 42, 43, 44,
	45, 47, 48, 49, 50, 51, 52, 53,
	54, 56, 57, 58, 59, 61, 62, 63,
	65, 66, 67, 69, 70, 72, 73, 75,
	76, 78, 79, 81, 83, 84, 86, 88,
	89, 91, 93, 95, 96, 98, 100, 102,
	104, 106, 108, 110, 112, 114, 116, 118,
	120, 122, 124, 127, 129, 131, 133, 136,
	138, 140, 143, 145, 148, 150, 153, 155,
	158, 160, 163, 166, 169, 171, 174, 177,
	180, 183, 186, 188, 191, 194, 198, 201,
	204, 207, 210, 213, 217, 220, 223, 227,
	230, 233, 237, 241, 244, 248, 251, 255,
};

static const u8 xgamma_38[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 7, 7, 7, 8, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	15, 15, 15, 16, 16, 17, 18, 18,
	19, 19, 20, 20, 21, 21, 22, 23,
	23, 24, 25, 25, 26, 27, 28, 28,
	29, 30, 31, 31, 32, 33, 34, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	43, 44, 45, 47, 48, 49, 50, 51,
	52, 53, 55, 56, 57, 58, 60, 61,
	62, 64, 65, 66, 68, 69, 71, 72,
	74, 75, 77, 78, 80, 82, 83, 85,
	87, 88, 90, 92, 94, 96, 98, 99,
	101, 103, 105, 107, 109, 111, 113, 115,
	118, 120, 122, 124, 126, 129, 131, 133,
	136, 138, 141, 143, 146, 148, 151, 153,
	156, 158, 161, 164, 167, 169, 172, 175,
	178, 181, 184, 187, 190, 193, 196, 199,
	203, 206, 209, 212, 216, 219, 222, 226,
	229, 233, 237, 240, 244, 247, 251, 255,
};

static const u8 xgamma_39[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	10, 11, 11, 11, 12, 12, 13, 13,
	13, 14, 14, 15, 15, 16, 16, 17,
	17, 18, 18, 19, 20, 20, 21, 21,
	22, 23, 23, 24, 25, 25, 26, 27,
	27, 28, 29, 30, 31, 31, 32, 33,
	34, 35, 36, 37, 38, 38, 39, 40,
	41, 42, 43, 45, 46, 47, 48, 49,
	50, 51, 52, 54, 55, 56, 57, 59,
	60, 61, 63, 64, 66, 67, 68, 70,
	71, 73, 74, 76, 78, 79, 81, 83,
	84, 86, 88, 90, 91, 93, 95, 97,
	99, 101, 103, 105, 107, 109, 111, 113,
	115, 117, 120, 122, 124, 126, 129, 131,
	133, 136, 138, 141, 143, 146, 149, 151,
	154, 157, 159, 162, 165, 168, 171, 173,
	176, 179, 182, 185, 189, 192, 195, 198,
	201, 205, 208, 211, 215, 218, 222, 225,
	229, 232, 236, 240, 243, 247, 251, 255,
};

static const u8 xgamma_40[GAMMA_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 5, 6, 6, 6, 6, 7, 7,
	7, 7, 8, 8, 8, 9, 9, 9,
	9, 10, 10, 11, 11, 11, 12, 12,
	13, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	21, 21, 22, 23, 23, 24, 25, 25,
	26, 27, 27, 28, 29, 30, 31, 31,
	32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 52, 53, 54, 55, 57,
	58, 59, 61, 62, 63, 65, 66, 68,
	69, 71, 72, 74, 75, 77, 79, 80,
	82, 84, 85, 87, 89, 91, 93, 95,
	96, 98, 100, 102, 104, 107, 109, 111,
	113, 115, 117, 120, 122, 124, 126, 129,
	131, 134, 136, 139, 141, 144, 146, 149,
	152, 155, 157, 160, 163, 166, 169, 172,
	175, 178, 181, 184, 187, 190, 194, 197,
	200, 203, 207, 210, 214, 217, 221, 224,
	228, 232, 236, 239, 243, 247, 251, 255,
};

static const u8 *xgamma_curves[GAMMA_CURVE_LENGTH] =  {
	&xgamma_01[0],
	&xgamma_02[0],
	&xgamma_03[0],
	&xgamma_04[0],
	&xgamma_05[0],
	&xgamma_06[0],
	&xgamma_07[0],
	&xgamma_08[0],
	&xgamma_09[0],
	&xgamma_10[0],
	&xgamma_11[0],
	&xgamma_12[0],
	&xgamma_13[0],
	&xgamma_14[0],
	&xgamma_15[0],
	&xgamma_16[0],
	&xgamma_17[0],
	&xgamma_18[0],
	&xgamma_19[0],
	&xgamma_20[0],
	&xgamma_21[0],
	&xgamma_22[0],
	&xgamma_23[0],
	&xgamma_24[0],
	&xgamma_25[0],
	&xgamma_26[0],
	&xgamma_27[0],
	&xgamma_28[0],
	&xgamma_29[0],
	&xgamma_30[0],
	&xgamma_31[0],
	&xgamma_32[0],
	&xgamma_33[0],
	&xgamma_34[0],
	&xgamma_35[0],
	&xgamma_36[0],
	&xgamma_37[0],
	&xgamma_38[0],
	&xgamma_39[0],
	&xgamma_40[0],
};

#endif /* __XILINX_GAMMA_COEFF_H__ */
