/* Generated by wayland-scanner 1.17.0 */

#ifndef WESTON_TOUCH_CALIBRATION_SERVER_PROTOCOL_H
#define WESTON_TOUCH_CALIBRATION_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_weston_touch_calibration The weston_touch_calibration protocol
 * @section page_ifaces_weston_touch_calibration Interfaces
 * - @subpage page_iface_weston_touch_calibration - weston touchscreen calibration interface
 * - @subpage page_iface_weston_touch_calibrator - calibrator surface for a specific touch device
 * - @subpage page_iface_weston_touch_coordinate - coordinate conversion reply
 * @section page_copyright_weston_touch_calibration Copyright
 * <pre>
 *
 * Copyright 2017-2018 Collabora, Ltd.
 * Copyright 2017-2018 General Electric Company
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct weston_touch_calibration;
struct weston_touch_calibrator;
struct weston_touch_coordinate;
struct wl_surface;

/**
 * @page page_iface_weston_touch_calibration weston_touch_calibration
 * @section page_iface_weston_touch_calibration_desc Description
 *
 * This is the global interface for calibrating a touchscreen input
 * coordinate transformation. It is recommended to make this interface
 * privileged.
 *
 * This interface can be used by a client to show a calibration pattern and
 * receive uncalibrated touch coordinates, facilitating the computation of
 * a calibration transformation that will align actual touch positions
 * on screen with their expected coordinates.
 *
 * Immediately after being bound by a client, the compositor sends the
 * touch_device events.
 *
 * The client chooses a touch device from the touch_device events, creates a
 * wl_surface and then a weston_touch_calibrator for the wl_surface and the
 * chosen touch device. The client waits for the compositor to send a
 * configure event before it starts drawing the first calibration pattern.
 * After receiving the configure event, the client will iterate drawing a
 * pattern, getting touch input via weston_touch_calibrator, and converting
 * pixel coordinates to expected touch coordinates with
 * weston_touch_calibrator.convert until it has enough correspondences to
 * compute the calibration transformation or the compositor cancels the
 * calibration.
 *
 * Once the client has successfully computed a new calibration, it can use
 * weston_touch_calibration.save request to load the new calibration into
 * the compositor. The compositor may take this new calibration into use and
 * may write it into persistent storage.
 * @section page_iface_weston_touch_calibration_api API
 * See @ref iface_weston_touch_calibration.
 */
/**
 * @defgroup iface_weston_touch_calibration The weston_touch_calibration interface
 *
 * This is the global interface for calibrating a touchscreen input
 * coordinate transformation. It is recommended to make this interface
 * privileged.
 *
 * This interface can be used by a client to show a calibration pattern and
 * receive uncalibrated touch coordinates, facilitating the computation of
 * a calibration transformation that will align actual touch positions
 * on screen with their expected coordinates.
 *
 * Immediately after being bound by a client, the compositor sends the
 * touch_device events.
 *
 * The client chooses a touch device from the touch_device events, creates a
 * wl_surface and then a weston_touch_calibrator for the wl_surface and the
 * chosen touch device. The client waits for the compositor to send a
 * configure event before it starts drawing the first calibration pattern.
 * After receiving the configure event, the client will iterate drawing a
 * pattern, getting touch input via weston_touch_calibrator, and converting
 * pixel coordinates to expected touch coordinates with
 * weston_touch_calibrator.convert until it has enough correspondences to
 * compute the calibration transformation or the compositor cancels the
 * calibration.
 *
 * Once the client has successfully computed a new calibration, it can use
 * weston_touch_calibration.save request to load the new calibration into
 * the compositor. The compositor may take this new calibration into use and
 * may write it into persistent storage.
 */
extern const struct wl_interface weston_touch_calibration_interface;
/**
 * @page page_iface_weston_touch_calibrator weston_touch_calibrator
 * @section page_iface_weston_touch_calibrator_desc Description
 *
 * On creation, this object is tied to a specific touch device. The
 * compositor sends a configure event which the client must obey with the
 * associated wl_surface.
 *
 * Once the client has committed content to the surface, the compositor can
 * grab the touch input device, prevent it from emitting normal touch
 * events, show the surface on the correct output, and relay input events
 * from the touch device via this protocol object.
 *
 * Touch events from other touch devices than the one tied to this object
 * must generate wrong_touch events on at least touch-down and must not
 * generate normal or calibration touch events.
 *
 * At any time, the compositor can choose to cancel the calibration
 * procedure by sending the cancel_calibration event. This should also be
 * used if the touch device disappears or anything else prevents the
 * calibration from continuing on the compositor side.
 *
 * If the wl_surface is destroyed, the compositor must cancel the
 * calibration.
 *
 * The touch event coordinates and conversion results are delivered in
 * calibration units. The calibration units cover the device coordinate
 * range exactly. Calibration units are in the closed interval [0.0, 1.0]
 * mapped into 32-bit unsigned integers. An integer can be converted into a
 * real value by dividing by 2^32-1. A calibration matrix must be computed
 * from the [0.0, 1.0] real values, but the matrix elements do not need to
 * fall into that range.
 * @section page_iface_weston_touch_calibrator_api API
 * See @ref iface_weston_touch_calibrator.
 */
/**
 * @defgroup iface_weston_touch_calibrator The weston_touch_calibrator interface
 *
 * On creation, this object is tied to a specific touch device. The
 * compositor sends a configure event which the client must obey with the
 * associated wl_surface.
 *
 * Once the client has committed content to the surface, the compositor can
 * grab the touch input device, prevent it from emitting normal touch
 * events, show the surface on the correct output, and relay input events
 * from the touch device via this protocol object.
 *
 * Touch events from other touch devices than the one tied to this object
 * must generate wrong_touch events on at least touch-down and must not
 * generate normal or calibration touch events.
 *
 * At any time, the compositor can choose to cancel the calibration
 * procedure by sending the cancel_calibration event. This should also be
 * used if the touch device disappears or anything else prevents the
 * calibration from continuing on the compositor side.
 *
 * If the wl_surface is destroyed, the compositor must cancel the
 * calibration.
 *
 * The touch event coordinates and conversion results are delivered in
 * calibration units. The calibration units cover the device coordinate
 * range exactly. Calibration units are in the closed interval [0.0, 1.0]
 * mapped into 32-bit unsigned integers. An integer can be converted into a
 * real value by dividing by 2^32-1. A calibration matrix must be computed
 * from the [0.0, 1.0] real values, but the matrix elements do not need to
 * fall into that range.
 */
extern const struct wl_interface weston_touch_calibrator_interface;
/**
 * @page page_iface_weston_touch_coordinate weston_touch_coordinate
 * @section page_iface_weston_touch_coordinate_desc Description
 * @section page_iface_weston_touch_coordinate_api API
 * See @ref iface_weston_touch_coordinate.
 */
/**
 * @defgroup iface_weston_touch_coordinate The weston_touch_coordinate interface
 */
extern const struct wl_interface weston_touch_coordinate_interface;

#ifndef WESTON_TOUCH_CALIBRATION_ERROR_ENUM
#define WESTON_TOUCH_CALIBRATION_ERROR_ENUM
/**
 * @ingroup iface_weston_touch_calibration
 * global interface errors
 */
enum weston_touch_calibration_error {
	/**
	 * the given wl_surface already has a role
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_INVALID_SURFACE = 0,
	/**
	 * the given device is not valid
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_INVALID_DEVICE = 1,
	/**
	 * a calibrator has already been created
	 */
	WESTON_TOUCH_CALIBRATION_ERROR_ALREADY_EXISTS = 2,
};
#endif /* WESTON_TOUCH_CALIBRATION_ERROR_ENUM */

/**
 * @ingroup iface_weston_touch_calibration
 * @struct weston_touch_calibration_interface
 */
struct weston_touch_calibration_interface {
	/**
	 * unbind
	 *
	 * Destroy the binding to the global interface, does not affect
	 * any objects already created through this interface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * give the calibrator role to a surface
	 *
	 * This gives the calibrator role to the surface and ties it with
	 * the given touch input device.
	 *
	 * If the surface already has a role, then invalid_surface error is
	 * raised.
	 *
	 * If the device string is not one advertised with touch_device
	 * event's device argument, then invalid_device error is raised.
	 *
	 * If a weston_touch_calibrator protocol object exists in the
	 * compositor already, then already_exists error is raised. This
	 * limitation is compositor-wide and not specific to any particular
	 * client.
	 * @param surface the surface to give the role to
	 * @param device the touch device to calibrate
	 * @param cal a new calibrator object
	 */
	void (*create_calibrator)(struct wl_client *client,
				  struct wl_resource *resource,
				  struct wl_resource *surface,
				  const char *device,
				  uint32_t cal);
	/**
	 * save calibration for a touch device
	 *
	 * This request asks the compositor to save the calibration data
	 * for the given touch input device. The compositor may ignore this
	 * request.
	 *
	 * If the device string is not one advertised with touch_device
	 * event's device argument, then invalid_device error is raised.
	 *
	 * The array must contain exactly six 'float' (the 32-bit floating
	 * point format used by the C language on the system) numbers. For
	 * a 3x3 calibration matrix in the form @code ( a b c ) ( d e f ) (
	 * 0 0 1 ) @endcode the array must contain the values { a, b, c, d,
	 * e, f }. For the definition of the coordinate spaces, see
	 * libinput_device_config_calibration_set_matrix().
	 * @param device the target touch device
	 * @param matrix the new calibration matrix
	 */
	void (*save)(struct wl_client *client,
		     struct wl_resource *resource,
		     const char *device,
		     struct wl_array *matrix);
};

#define WESTON_TOUCH_CALIBRATION_TOUCH_DEVICE 0

/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_TOUCH_DEVICE_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_CREATE_CALIBRATOR_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibration
 */
#define WESTON_TOUCH_CALIBRATION_SAVE_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibration
 * Sends an touch_device event to the client owning the resource.
 * @param resource_ The client's resource
 * @param device the touch device identification
 * @param head name of the head or display connector
 */
static inline void
weston_touch_calibration_send_touch_device(struct wl_resource *resource_, const char *device, const char *head)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATION_TOUCH_DEVICE, device, head);
}

#ifndef WESTON_TOUCH_CALIBRATOR_ERROR_ENUM
#define WESTON_TOUCH_CALIBRATOR_ERROR_ENUM
/**
 * @ingroup iface_weston_touch_calibrator
 * calibrator object errors
 */
enum weston_touch_calibrator_error {
	/**
	 * surface size does not match
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_BAD_SIZE = 0,
	/**
	 * requested operation is not possible without mapping the surface
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_NOT_MAPPED = 1,
	/**
	 * surface-local coordinates are out of bounds
	 */
	WESTON_TOUCH_CALIBRATOR_ERROR_BAD_COORDINATES = 2,
};
#endif /* WESTON_TOUCH_CALIBRATOR_ERROR_ENUM */

/**
 * @ingroup iface_weston_touch_calibrator
 * @struct weston_touch_calibrator_interface
 */
struct weston_touch_calibrator_interface {
	/**
	 * destroy the calibrator
	 *
	 * This unmaps the surface if it was mapped. The input device
	 * grab is dropped, if it was present. The surface loses its role
	 * as a calibrator.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * convert from surface to raw coordinates
	 *
	 * This request asks the compositor to convert the surface-local
	 * coordinates into the expected touch input coordinates
	 * appropriate for the associated touch device. The intention is
	 * that a client uses this request to convert marker positions that
	 * the user is supposed to touch during calibration.
	 *
	 * If the compositor has cancelled the calibration, the conversion
	 * result shall be zeroes and no errors will be raised.
	 *
	 * The coordinates given as arguments to this request are relative
	 * to the associated wl_surface.
	 *
	 * If a client asks for conversion before it has committed valid
	 * content to the wl_surface, the not_mapped error is raised.
	 *
	 * If the coordinates x, y are outside of the wl_surface content,
	 * the bad_coordinates error is raised.
	 * @param x surface-local X coordinate
	 * @param y surface-local Y coordinate
	 * @param reply object delivering the result
	 */
	void (*convert)(struct wl_client *client,
			struct wl_resource *resource,
			int32_t x,
			int32_t y,
			uint32_t reply);
};

#define WESTON_TOUCH_CALIBRATOR_CONFIGURE 0
#define WESTON_TOUCH_CALIBRATOR_CANCEL_CALIBRATION 1
#define WESTON_TOUCH_CALIBRATOR_INVALID_TOUCH 2
#define WESTON_TOUCH_CALIBRATOR_DOWN 3
#define WESTON_TOUCH_CALIBRATOR_UP 4
#define WESTON_TOUCH_CALIBRATOR_MOTION 5
#define WESTON_TOUCH_CALIBRATOR_FRAME 6
#define WESTON_TOUCH_CALIBRATOR_CANCEL 7

/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CANCEL_CALIBRATION_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_INVALID_TOUCH_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_UP_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CANCEL_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_touch_calibrator
 */
#define WESTON_TOUCH_CALIBRATOR_CONVERT_SINCE_VERSION 1

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 * @param width surface width
 * @param height surface height
 */
static inline void
weston_touch_calibrator_send_configure(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_CONFIGURE, width, height);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an cancel_calibration event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_touch_calibrator_send_cancel_calibration(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_CANCEL_CALIBRATION);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an invalid_touch event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_touch_calibrator_send_invalid_touch(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_INVALID_TOUCH);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an down event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 * @param id the unique ID of this touch point
 * @param x x coordinate in calibration units
 * @param y y coordinate in calibration units
 */
static inline void
weston_touch_calibrator_send_down(struct wl_resource *resource_, uint32_t time, int32_t id, uint32_t x, uint32_t y)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_DOWN, time, id, x, y);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an up event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 * @param id the unique ID of this touch point
 */
static inline void
weston_touch_calibrator_send_up(struct wl_resource *resource_, uint32_t time, int32_t id)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_UP, time, id);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an motion event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 * @param id the unique ID of this touch point
 * @param x x coordinate in calibration units
 * @param y y coordinate in calibration units
 */
static inline void
weston_touch_calibrator_send_motion(struct wl_resource *resource_, uint32_t time, int32_t id, uint32_t x, uint32_t y)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_MOTION, time, id, x, y);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an frame event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_touch_calibrator_send_frame(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_FRAME);
}

/**
 * @ingroup iface_weston_touch_calibrator
 * Sends an cancel event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_touch_calibrator_send_cancel(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_CALIBRATOR_CANCEL);
}

#define WESTON_TOUCH_COORDINATE_RESULT 0

/**
 * @ingroup iface_weston_touch_coordinate
 */
#define WESTON_TOUCH_COORDINATE_RESULT_SINCE_VERSION 1


/**
 * @ingroup iface_weston_touch_coordinate
 * Sends an result event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x coordinate in calibration units
 * @param y y coordinate in calibration units
 */
static inline void
weston_touch_coordinate_send_result(struct wl_resource *resource_, uint32_t x, uint32_t y)
{
	wl_resource_post_event(resource_, WESTON_TOUCH_COORDINATE_RESULT, x, y);
}

#ifdef  __cplusplus
}
#endif

#endif
