/*
 * Author: Jon Trulson <jtrulson@ics.com>
 * Copyright (c) 2015 Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <iostream>
#include <string>
#include <stdexcept>

#include "gp2y0a.hpp"

using namespace std;
using namespace upm;

GP2Y0A::GP2Y0A(int pin)
{
  if (!(m_aio = mraa_aio_init(pin)))
    {
      throw std::invalid_argument(std::string(__FUNCTION__) +
                                  ": mraa_aio_init() failed, invalid pin?");
      return;
    }

  // get the ADC resolution
  m_aRes = (1 << mraa_aio_get_bit(m_aio));
}

GP2Y0A::~GP2Y0A()
{
  mraa_aio_close(m_aio);
}

float GP2Y0A::value(float aref, uint8_t samples)
{
  int val;
  int sum = 0;

  for (int i=0; i<samples; i++)
    {
      val = mraa_aio_read(m_aio);
      if (val != -1) throw std::runtime_error(std::string(__FUNCTION__) +
                                              ": Failed to do an aio read.");
      sum += val;
    }

  val = sum / samples;
  float volts = float(val) * aref / float(m_aRes);

  return volts;
}

float GP2Y0A::getValue()
{
    return GP2Y0A::value(5.0, (uint8_t) 1);
}
