/* Copyright (C) 2014 Connor Abbott
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * Authors:
 *    Connor Abbott (cwabbott0@gmail.com)
 */

#ifndef _NIR_OPCODES_
#define _NIR_OPCODES_



typedef enum {
   nir_op_amul,
   nir_op_b16all_fequal16,
   nir_op_b16all_fequal2,
   nir_op_b16all_fequal3,
   nir_op_b16all_fequal4,
   nir_op_b16all_fequal5,
   nir_op_b16all_fequal8,
   nir_op_b16all_iequal16,
   nir_op_b16all_iequal2,
   nir_op_b16all_iequal3,
   nir_op_b16all_iequal4,
   nir_op_b16all_iequal5,
   nir_op_b16all_iequal8,
   nir_op_b16any_fnequal16,
   nir_op_b16any_fnequal2,
   nir_op_b16any_fnequal3,
   nir_op_b16any_fnequal4,
   nir_op_b16any_fnequal5,
   nir_op_b16any_fnequal8,
   nir_op_b16any_inequal16,
   nir_op_b16any_inequal2,
   nir_op_b16any_inequal3,
   nir_op_b16any_inequal4,
   nir_op_b16any_inequal5,
   nir_op_b16any_inequal8,
   nir_op_b16csel,
   nir_op_b2b1,
   nir_op_b2b16,
   nir_op_b2b32,
   nir_op_b2b8,
   nir_op_b2f16,
   nir_op_b2f32,
   nir_op_b2f64,
   nir_op_b2i1,
   nir_op_b2i16,
   nir_op_b2i32,
   nir_op_b2i64,
   nir_op_b2i8,
   nir_op_b32all_fequal16,
   nir_op_b32all_fequal2,
   nir_op_b32all_fequal3,
   nir_op_b32all_fequal4,
   nir_op_b32all_fequal5,
   nir_op_b32all_fequal8,
   nir_op_b32all_iequal16,
   nir_op_b32all_iequal2,
   nir_op_b32all_iequal3,
   nir_op_b32all_iequal4,
   nir_op_b32all_iequal5,
   nir_op_b32all_iequal8,
   nir_op_b32any_fnequal16,
   nir_op_b32any_fnequal2,
   nir_op_b32any_fnequal3,
   nir_op_b32any_fnequal4,
   nir_op_b32any_fnequal5,
   nir_op_b32any_fnequal8,
   nir_op_b32any_inequal16,
   nir_op_b32any_inequal2,
   nir_op_b32any_inequal3,
   nir_op_b32any_inequal4,
   nir_op_b32any_inequal5,
   nir_op_b32any_inequal8,
   nir_op_b32csel,
   nir_op_b8all_fequal16,
   nir_op_b8all_fequal2,
   nir_op_b8all_fequal3,
   nir_op_b8all_fequal4,
   nir_op_b8all_fequal5,
   nir_op_b8all_fequal8,
   nir_op_b8all_iequal16,
   nir_op_b8all_iequal2,
   nir_op_b8all_iequal3,
   nir_op_b8all_iequal4,
   nir_op_b8all_iequal5,
   nir_op_b8all_iequal8,
   nir_op_b8any_fnequal16,
   nir_op_b8any_fnequal2,
   nir_op_b8any_fnequal3,
   nir_op_b8any_fnequal4,
   nir_op_b8any_fnequal5,
   nir_op_b8any_fnequal8,
   nir_op_b8any_inequal16,
   nir_op_b8any_inequal2,
   nir_op_b8any_inequal3,
   nir_op_b8any_inequal4,
   nir_op_b8any_inequal5,
   nir_op_b8any_inequal8,
   nir_op_b8csel,
   nir_op_ball_fequal16,
   nir_op_ball_fequal2,
   nir_op_ball_fequal3,
   nir_op_ball_fequal4,
   nir_op_ball_fequal5,
   nir_op_ball_fequal8,
   nir_op_ball_iequal16,
   nir_op_ball_iequal2,
   nir_op_ball_iequal3,
   nir_op_ball_iequal4,
   nir_op_ball_iequal5,
   nir_op_ball_iequal8,
   nir_op_bany_fnequal16,
   nir_op_bany_fnequal2,
   nir_op_bany_fnequal3,
   nir_op_bany_fnequal4,
   nir_op_bany_fnequal5,
   nir_op_bany_fnequal8,
   nir_op_bany_inequal16,
   nir_op_bany_inequal2,
   nir_op_bany_inequal3,
   nir_op_bany_inequal4,
   nir_op_bany_inequal5,
   nir_op_bany_inequal8,
   nir_op_bcsel,
   nir_op_bfi,
   nir_op_bfm,
   nir_op_bit_count,
   nir_op_bitfield_insert,
   nir_op_bitfield_reverse,
   nir_op_bitfield_select,
   nir_op_cube_face_coord_amd,
   nir_op_cube_face_index_amd,
   nir_op_cube_r600,
   nir_op_extract_i16,
   nir_op_extract_i8,
   nir_op_extract_u16,
   nir_op_extract_u8,
   nir_op_f2b1,
   nir_op_f2b16,
   nir_op_f2b32,
   nir_op_f2b8,
   nir_op_f2f16,
   nir_op_f2f16_rtne,
   nir_op_f2f16_rtz,
   nir_op_f2f32,
   nir_op_f2f64,
   nir_op_f2fmp,
   nir_op_f2i1,
   nir_op_f2i16,
   nir_op_f2i32,
   nir_op_f2i64,
   nir_op_f2i8,
   nir_op_f2imp,
   nir_op_f2u1,
   nir_op_f2u16,
   nir_op_f2u32,
   nir_op_f2u64,
   nir_op_f2u8,
   nir_op_f2ump,
   nir_op_fabs,
   nir_op_fadd,
   nir_op_fall_equal16,
   nir_op_fall_equal2,
   nir_op_fall_equal3,
   nir_op_fall_equal4,
   nir_op_fall_equal5,
   nir_op_fall_equal8,
   nir_op_fany_nequal16,
   nir_op_fany_nequal2,
   nir_op_fany_nequal3,
   nir_op_fany_nequal4,
   nir_op_fany_nequal5,
   nir_op_fany_nequal8,
   nir_op_fceil,
   nir_op_fclamp_pos_mali,
   nir_op_fcos,
   nir_op_fcos_r600,
   nir_op_fcsel,
   nir_op_fcsel_ge,
   nir_op_fcsel_gt,
   nir_op_fddx,
   nir_op_fddx_coarse,
   nir_op_fddx_fine,
   nir_op_fddy,
   nir_op_fddy_coarse,
   nir_op_fddy_fine,
   nir_op_fdiv,
   nir_op_fdot16,
   nir_op_fdot16_replicated,
   nir_op_fdot2,
   nir_op_fdot2_replicated,
   nir_op_fdot3,
   nir_op_fdot3_replicated,
   nir_op_fdot4,
   nir_op_fdot4_replicated,
   nir_op_fdot5,
   nir_op_fdot5_replicated,
   nir_op_fdot8,
   nir_op_fdot8_replicated,
   nir_op_fdph,
   nir_op_fdph_replicated,
   nir_op_feq,
   nir_op_feq16,
   nir_op_feq32,
   nir_op_feq8,
   nir_op_fexp2,
   nir_op_ffloor,
   nir_op_ffma,
   nir_op_ffract,
   nir_op_fge,
   nir_op_fge16,
   nir_op_fge32,
   nir_op_fge8,
   nir_op_find_lsb,
   nir_op_fisfinite,
   nir_op_fisnormal,
   nir_op_flog2,
   nir_op_flrp,
   nir_op_flt,
   nir_op_flt16,
   nir_op_flt32,
   nir_op_flt8,
   nir_op_fmax,
   nir_op_fmin,
   nir_op_fmod,
   nir_op_fmul,
   nir_op_fneg,
   nir_op_fneu,
   nir_op_fneu16,
   nir_op_fneu32,
   nir_op_fneu8,
   nir_op_fpow,
   nir_op_fquantize2f16,
   nir_op_frcp,
   nir_op_frem,
   nir_op_frexp_exp,
   nir_op_frexp_sig,
   nir_op_fround_even,
   nir_op_frsq,
   nir_op_fsat,
   nir_op_fsat_signed_mali,
   nir_op_fsign,
   nir_op_fsin,
   nir_op_fsin_agx,
   nir_op_fsin_r600,
   nir_op_fsqrt,
   nir_op_fsub,
   nir_op_fsum2,
   nir_op_fsum3,
   nir_op_fsum4,
   nir_op_ftrunc,
   nir_op_i2b1,
   nir_op_i2b16,
   nir_op_i2b32,
   nir_op_i2b8,
   nir_op_i2f16,
   nir_op_i2f32,
   nir_op_i2f64,
   nir_op_i2fmp,
   nir_op_i2i1,
   nir_op_i2i16,
   nir_op_i2i32,
   nir_op_i2i64,
   nir_op_i2i8,
   nir_op_i2imp,
   nir_op_i32csel_ge,
   nir_op_i32csel_gt,
   nir_op_iabs,
   nir_op_iadd,
   nir_op_iadd_sat,
   nir_op_iand,
   nir_op_ibfe,
   nir_op_ibitfield_extract,
   nir_op_idiv,
   nir_op_ieq,
   nir_op_ieq16,
   nir_op_ieq32,
   nir_op_ieq8,
   nir_op_ifind_msb,
   nir_op_ifind_msb_rev,
   nir_op_ige,
   nir_op_ige16,
   nir_op_ige32,
   nir_op_ige8,
   nir_op_ihadd,
   nir_op_ilt,
   nir_op_ilt16,
   nir_op_ilt32,
   nir_op_ilt8,
   nir_op_imad24_ir3,
   nir_op_imadsh_mix16,
   nir_op_imax,
   nir_op_imin,
   nir_op_imod,
   nir_op_imul,
   nir_op_imul24,
   nir_op_imul24_relaxed,
   nir_op_imul_2x32_64,
   nir_op_imul_32x16,
   nir_op_imul_high,
   nir_op_ine,
   nir_op_ine16,
   nir_op_ine32,
   nir_op_ine8,
   nir_op_ineg,
   nir_op_inot,
   nir_op_insert_u16,
   nir_op_insert_u8,
   nir_op_ior,
   nir_op_irem,
   nir_op_irhadd,
   nir_op_ishl,
   nir_op_ishr,
   nir_op_isign,
   nir_op_isub,
   nir_op_isub_sat,
   nir_op_ixor,
   nir_op_ldexp,
   nir_op_mov,
   nir_op_pack_32_2x16,
   nir_op_pack_32_2x16_split,
   nir_op_pack_32_4x8,
   nir_op_pack_64_2x32,
   nir_op_pack_64_2x32_split,
   nir_op_pack_64_4x16,
   nir_op_pack_double_2x32_dxil,
   nir_op_pack_half_2x16,
   nir_op_pack_half_2x16_split,
   nir_op_pack_snorm_2x16,
   nir_op_pack_snorm_4x8,
   nir_op_pack_unorm_2x16,
   nir_op_pack_unorm_4x8,
   nir_op_pack_uvec2_to_uint,
   nir_op_pack_uvec4_to_uint,
   nir_op_sad_u8x4,
   nir_op_seq,
   nir_op_sge,
   nir_op_slt,
   nir_op_sne,
   nir_op_u2f16,
   nir_op_u2f32,
   nir_op_u2f64,
   nir_op_u2fmp,
   nir_op_u2u1,
   nir_op_u2u16,
   nir_op_u2u32,
   nir_op_u2u64,
   nir_op_u2u8,
   nir_op_uabs_isub,
   nir_op_uabs_usub,
   nir_op_uadd_carry,
   nir_op_uadd_sat,
   nir_op_ubfe,
   nir_op_ubitfield_extract,
   nir_op_uclz,
   nir_op_udiv,
   nir_op_ufind_msb,
   nir_op_ufind_msb_rev,
   nir_op_uge,
   nir_op_uge16,
   nir_op_uge32,
   nir_op_uge8,
   nir_op_uhadd,
   nir_op_ult,
   nir_op_ult16,
   nir_op_ult32,
   nir_op_ult8,
   nir_op_umad24,
   nir_op_umad24_relaxed,
   nir_op_umax,
   nir_op_umax_4x8_vc4,
   nir_op_umin,
   nir_op_umin_4x8_vc4,
   nir_op_umod,
   nir_op_umul24,
   nir_op_umul24_relaxed,
   nir_op_umul_2x32_64,
   nir_op_umul_32x16,
   nir_op_umul_high,
   nir_op_umul_low,
   nir_op_umul_unorm_4x8_vc4,
   nir_op_unpack_32_2x16,
   nir_op_unpack_32_2x16_split_x,
   nir_op_unpack_32_2x16_split_y,
   nir_op_unpack_32_4x8,
   nir_op_unpack_64_2x32,
   nir_op_unpack_64_2x32_split_x,
   nir_op_unpack_64_2x32_split_y,
   nir_op_unpack_64_4x16,
   nir_op_unpack_double_2x32_dxil,
   nir_op_unpack_half_2x16,
   nir_op_unpack_half_2x16_flush_to_zero,
   nir_op_unpack_half_2x16_split_x,
   nir_op_unpack_half_2x16_split_x_flush_to_zero,
   nir_op_unpack_half_2x16_split_y,
   nir_op_unpack_half_2x16_split_y_flush_to_zero,
   nir_op_unpack_snorm_2x16,
   nir_op_unpack_snorm_4x8,
   nir_op_unpack_unorm_2x16,
   nir_op_unpack_unorm_4x8,
   nir_op_urhadd,
   nir_op_urol,
   nir_op_uror,
   nir_op_usadd_4x8_vc4,
   nir_op_ushr,
   nir_op_ussub_4x8_vc4,
   nir_op_usub_borrow,
   nir_op_usub_sat,
   nir_op_vec16,
   nir_op_vec2,
   nir_op_vec3,
   nir_op_vec4,
   nir_op_vec5,
   nir_op_vec8,
   nir_last_opcode = nir_op_vec8,
   nir_num_opcodes = nir_last_opcode + 1
} nir_op;

#endif /* _NIR_OPCODES_ */
