
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1722
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('bcsel', ('ige', 'a', 0), ('iand', 'a', ('isub', 'b', 1)), ('imod', 'a', ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ige', 'a', 0), ('iand', 'a', ('inot', 'b')), ('imod', 'a', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z'))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z'))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z'))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z'))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow@32', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('fcsel', ('slt', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('fcsel', ('slt', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('fcsel', ('sge', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('fcsel', ('sge', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('ilt', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('ilt', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('ige', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('ige', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('flt', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('flt', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('fge', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('fge', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


   static const nir_search_variable search0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace0_0 -> search0_0 in the cache */

static const nir_search_variable replace0_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search1_0 -> search0_0 in the cache */

static const nir_search_variable search1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_neg_power_of_two),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace1_0_0 -> search0_0 in the cache */

/* replace1_0_1_0_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1_0_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace1_0.value },
   NULL,
};

   static const nir_search_variable search2_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search2_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search2_1.value },
   NULL,
};

   /* replace2_0 -> search2_0 in the cache */

static const nir_search_constant replace2_1_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x1 /* 1 */ },
};

static const nir_search_variable replace2_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace2_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace2_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace2 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1.value },
   NULL,
};

   static const nir_search_variable search3_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search3_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search3_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search3_0_0.value, &replace2_1_1.value },
   (is_used_once),
};
static const nir_search_expression search3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search3_0.value },
   NULL,
};

   /* replace3_0 -> search3_0_0 in the cache */

/* replace3_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace3 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search4_0_0 -> search3_0_0 in the cache */

/* search4_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search4_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search3_0_0.value, &replace2_1_1.value },
   (is_used_once),
};
static const nir_search_expression search4 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search4_0.value },
   NULL,
};

   /* replace4_0 -> search3_0_0 in the cache */

/* replace4_1 -> replace2_1_1 in the cache */
/* replace4 -> replace3 in the cache */

   /* search5_0 -> search3_0_0 in the cache */

/* search5_1 -> replace2_1_1 in the cache */
static const nir_search_expression search5 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace5_0_0 -> search3_0_0 in the cache */

/* replace5_0_1 -> replace2_1_1 in the cache */
/* replace5_0 -> replace3 in the cache */

/* replace5_1_0 -> search3_0_0 in the cache */

/* replace5_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace5_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul_high,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace5 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace5_1.value },
   NULL,
};

   /* search6_0 -> search3_0_0 in the cache */

/* search6_1 -> replace2_1_1 in the cache */
static const nir_search_expression search6 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace6_0_0 -> search3_0_0 in the cache */

/* replace6_0_1 -> replace2_1_1 in the cache */
/* replace6_0 -> replace3 in the cache */

/* replace6_1_0 -> search3_0_0 in the cache */

/* replace6_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace6_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umul_high,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace6 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace6_1.value },
   NULL,
};

   /* search7_0 -> search2_0 in the cache */

/* search7_1 -> replace2_1_0 in the cache */
static const nir_search_expression search7 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace7 -> search2_0 in the cache */

   /* search8_0 -> search2_0 in the cache */

/* search8_1 -> replace2_1_0 in the cache */
static const nir_search_expression search8 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace8 -> search2_0 in the cache */

   /* search9_0 -> search2_0 in the cache */

/* search9_1 -> replace2_1_0 in the cache */
static const nir_search_expression search9 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   static const nir_search_constant replace9 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x0 /* 0 */ },
};

   /* search10_0 -> search2_0 in the cache */

/* search10_1 -> replace2_1_0 in the cache */
static const nir_search_expression search10 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace10 -> replace9 in the cache */

   /* search11_0 -> search2_0 in the cache */

static const nir_search_constant search11_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search11 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace11 -> replace9 in the cache */

   /* search12_0 -> search2_0 in the cache */

/* search12_1 -> replace2_1_0 in the cache */
static const nir_search_expression search12 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace12 -> replace9 in the cache */

   /* search13_0 -> search2_0 in the cache */

/* search13_1 -> search11_1 in the cache */
static const nir_search_expression search13 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace13 -> replace9 in the cache */

   /* search14_0 -> search0_0 in the cache */

/* search14_1 -> search0_1 in the cache */
static const nir_search_expression search14 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace14_0 -> search0_0 in the cache */

/* replace14_1_0 -> replace0_1_0 in the cache */
/* replace14_1 -> replace0_1 in the cache */
static const nir_search_expression replace14 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search15_0 -> search0_0 in the cache */

/* search15_1 -> search0_1 in the cache */
static const nir_search_expression search15 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace15_0_0 -> search0_0 in the cache */
static const nir_search_expression replace15_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search0_0.value },
   NULL,
};

/* replace15_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace15_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search0_0.value },
   NULL,
};

/* replace15_1_1_0 -> replace0_1_0 in the cache */
/* replace15_1_1 -> replace0_1 in the cache */
static const nir_search_expression replace15_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace15_1_0.value, &replace0_1.value },
   NULL,
};
static const nir_search_expression replace15 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace15_0.value, &replace15_1.value },
   NULL,
};

   /* search16_0 -> search0_0 in the cache */

/* search16_1 -> search1_1 in the cache */
static const nir_search_expression search16 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace16_0_0_0 -> search0_0 in the cache */
/* replace16_0_0 -> replace15_0 in the cache */

/* replace16_0_1_0_0 -> search0_0 in the cache */
/* replace16_0_1_0 -> replace15_1_0 in the cache */

/* replace16_0_1_1_0_0 -> replace0_1_0 in the cache */
/* replace16_0_1_1_0 -> replace1_0_1_0 in the cache */
/* replace16_0_1_1 -> replace1_0_1 in the cache */
static const nir_search_expression replace16_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace15_1_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace16_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace15_0.value, &replace16_0_1.value },
   NULL,
};
static const nir_search_expression replace16 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace16_0.value },
   NULL,
};

   /* search17_0 -> search0_0 in the cache */

/* search17_1 -> search0_1 in the cache */
static const nir_search_expression search17 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace17_0 -> search0_0 in the cache */

/* replace17_1_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace17_1_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace17_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace0_1_0.value, &replace17_1_1.value },
   NULL,
};
static const nir_search_expression replace17 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace17_1.value },
   NULL,
};

   /* search18_0 -> search0_0 in the cache */

/* search18_1 -> search0_1 in the cache */
static const nir_search_expression search18 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace18_0 -> search0_0 in the cache */

/* replace18_1_0 -> replace0_1_0 in the cache */

/* replace18_1_1 -> replace17_1_1 in the cache */
/* replace18_1 -> replace17_1 in the cache */
/* replace18 -> replace17 in the cache */

   /* search19_0 -> search0_0 in the cache */

/* search19_1 -> search1_1 in the cache */
static const nir_search_expression search19 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace19_0_0_0 -> search0_0 in the cache */

/* replace19_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace19_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace19_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace19_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace19_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace19_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x0 /* 0 */ },
};

/* replace19_2_0 -> search0_0 in the cache */

/* replace19_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace19_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   2, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace19 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 3,
   nir_op_bcsel,
   { &replace19_0.value, &replace19_1.value, &replace19_2.value },
   NULL,
};

   /* search20_0 -> search0_0 in the cache */

/* search20_1 -> search0_1 in the cache */
static const nir_search_expression search20 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace20_0_0 -> search0_0 in the cache */

/* replace20_0_1 -> replace19_1 in the cache */
static const nir_search_expression replace20_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace19_1.value },
   NULL,
};

/* replace20_1_0 -> search0_0 in the cache */

/* replace20_1_1_0 -> replace0_1_0 in the cache */

/* replace20_1_1_1 -> replace17_1_1 in the cache */
/* replace20_1_1 -> replace17_1 in the cache */
/* replace20_1 -> replace17 in the cache */

/* replace20_2_0 -> search0_0 in the cache */

/* replace20_2_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace20_2_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace20_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &replace20_2_1.value },
   NULL,
};
static const nir_search_expression replace20 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace20_0.value, &replace17.value, &replace20_2.value },
   NULL,
};

   /* search21_0 -> search0_0 in the cache */

/* search21_1 -> search1_1 in the cache */
static const nir_search_expression search21 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_irem,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace21_0_0 -> search0_0 in the cache */

/* replace21_0_1 -> replace19_1 in the cache */
/* replace21_0 -> replace20_0 in the cache */

/* replace21_1_0 -> search0_0 in the cache */

/* replace21_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace21_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace21_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace21_1_1.value },
   NULL,
};

/* replace21_2_0 -> search0_0 in the cache */

/* replace21_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace21_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace21 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace20_0.value, &replace21_1.value, &replace21_2.value },
   NULL,
};

   /* search22_0_0 -> search2_0 in the cache */
static const nir_search_expression search22_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search22 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fneg,
   { &search22_0.value },
   NULL,
};

   /* replace22 -> search2_0 in the cache */

   /* search23_0_0 -> search2_0 in the cache */
static const nir_search_expression search23_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search23 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search23_0.value },
   NULL,
};

   /* replace23 -> search2_0 in the cache */

   /* search24_0_0 -> search2_0 in the cache */
/* search24_0 -> search22_0 in the cache */
static const nir_search_expression search24 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search22_0.value },
   NULL,
};

   /* replace24_0 -> search2_0 in the cache */
static const nir_search_expression replace24 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search2_0.value },
   NULL,
};

   /* search25_0_0 -> search2_0 in the cache */
static const nir_search_expression search25_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search25 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search25_0.value },
   NULL,
};

   /* replace25_0 -> search2_0 in the cache */
/* replace25 -> search25_0 in the cache */

   /* search26_0_0 -> search2_0 in the cache */
static const nir_search_expression search26_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search26 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search26_0.value },
   NULL,
};

   /* replace26_0 -> search2_0 in the cache */
/* replace26 -> search26_0 in the cache */

   /* search27_0_0 -> search2_0 in the cache */
/* search27_0 -> search23_0 in the cache */
static const nir_search_expression search27 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search23_0.value },
   NULL,
};

   /* replace27_0 -> search2_0 in the cache */
/* replace27 -> search26_0 in the cache */

   /* search28_0_0 -> search2_0 in the cache */
/* search28_0 -> search22_0 in the cache */
static const nir_search_expression search28 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search22_0.value },
   NULL,
};

   /* replace28_0 -> search2_0 in the cache */
static const nir_search_expression replace28 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search2_0.value },
   NULL,
};

   /* search29_0_0 -> search2_0 in the cache */
/* search29_0 -> search23_0 in the cache */
static const nir_search_expression search29 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search23_0.value },
   NULL,
};

   /* replace29_0 -> search2_0 in the cache */
static const nir_search_expression replace29 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

   /* search30_0 -> search2_0 in the cache */

static const nir_search_constant search30_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search30 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search30_1.value },
   NULL,
};

   /* replace30 -> search2_0 in the cache */

   static const nir_search_variable search31_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_constant search31_1 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search31 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search31_0.value, &search31_1.value },
   (is_only_used_as_float),
};

   /* replace31 -> search31_0 in the cache */

   /* search32_0 -> search3_0_0 in the cache */

static const nir_search_constant search32_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search32 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search3_0_0.value, &search32_1.value },
   (is_only_used_as_float),
};

   /* replace32 -> search3_0_0 in the cache */

   /* search33_0 -> search2_0 in the cache */

/* search33_1 -> replace9 in the cache */
static const nir_search_expression search33 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace33 -> search2_0 in the cache */

   /* search34_0 -> search3_0_0 in the cache */

static const nir_search_constant search34_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search34 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8_vc4,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* replace34 -> search3_0_0 in the cache */

   /* search35_0 -> search3_0_0 in the cache */

static const nir_search_constant search35_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search35 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8_vc4,
   { &search3_0_0.value, &search35_1.value },
   NULL,
};

   /* replace35 -> search35_1 in the cache */

   static const nir_search_variable search36_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search36_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search36_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search36_1_0 -> search36_0_0 in the cache */

static const nir_search_variable search36_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search36_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search36 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search36_0.value, &search36_1.value },
   NULL,
};

   /* replace36_0 -> search36_0_0 in the cache */

/* replace36_1_0 -> search36_0_1 in the cache */

/* replace36_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace36_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace36 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search36_0_0.value, &replace36_1.value },
   NULL,
};

   /* search37_0_0 -> search36_0_0 in the cache */

/* search37_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search37_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search37_1_0 -> search36_0_0 in the cache */

/* search37_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search37_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search37 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search37_0.value, &search37_1.value },
   NULL,
};

   /* replace37_0 -> search36_0_0 in the cache */

/* replace37_1_0 -> search36_0_1 in the cache */

/* replace37_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace37_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace37 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search36_0_0.value, &replace37_1.value },
   NULL,
};

   /* search38_0_0 -> search36_0_0 in the cache */

/* search38_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search38_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search38_1_0 -> search36_0_0 in the cache */

/* search38_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search38_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_ior,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search38 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search38_0.value, &search38_1.value },
   NULL,
};

   /* replace38_0 -> search36_0_0 in the cache */

/* replace38_1_0 -> search36_0_1 in the cache */

/* replace38_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace38_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace38 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search36_0_0.value, &replace38_1.value },
   NULL,
};

   /* search39_0_0 -> search36_0_0 in the cache */

/* search39_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search39_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search39_1_0 -> search36_0_0 in the cache */

/* search39_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search39_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search39 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search39_0.value, &search39_1.value },
   NULL,
};

   /* replace39_0 -> search36_0_0 in the cache */

/* replace39_1_0 -> search36_0_1 in the cache */

/* replace39_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace39_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace39 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search36_0_0.value, &replace39_1.value },
   NULL,
};

   /* search40_0_0 -> search2_0 in the cache */
/* search40_0 -> search22_0 in the cache */

/* search40_1 -> search2_0 in the cache */
static const nir_search_expression search40 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search22_0.value, &search2_0.value },
   NULL,
};

   /* replace40 -> search30_1 in the cache */

   /* search41_0_0 -> search2_0 in the cache */
/* search41_0 -> search23_0 in the cache */

/* search41_1 -> search2_0 in the cache */
static const nir_search_expression search41 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search23_0.value, &search2_0.value },
   NULL,
};

   /* replace41 -> replace9 in the cache */

   /* search42_0_0 -> search0_0 in the cache */
static const nir_search_expression search42_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search0_0.value },
   NULL,
};

/* search42_1_0 -> search0_0 in the cache */

/* search42_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search42_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search42 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search42_0.value, &search42_1.value },
   NULL,
};

   /* replace42 -> replace0_1_0 in the cache */

   /* search43_0 -> search0_0 in the cache */

/* search43_1_0_0 -> search0_0 in the cache */
/* search43_1_0 -> search42_0 in the cache */

/* search43_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search43_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search42_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search43 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search0_0.value, &search43_1.value },
   NULL,
};

   /* replace43 -> replace0_1_0 in the cache */

   /* search44_0_0 -> search0_0 in the cache */
static const nir_search_expression search44_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search0_0.value },
   NULL,
};

/* search44_1_0 -> search0_0 in the cache */

/* search44_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search44_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search44 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search44_0.value, &search44_1.value },
   NULL,
};

   /* replace44 -> replace0_1_0 in the cache */

   /* search45_0 -> search0_0 in the cache */

/* search45_1_0_0 -> search0_0 in the cache */
/* search45_1_0 -> search44_0 in the cache */

/* search45_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search45_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search44_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search45 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search0_0.value, &search45_1.value },
   NULL,
};

   /* replace45 -> replace0_1_0 in the cache */

   /* search46_0_0 -> search2_0 in the cache */
static const nir_search_expression search46_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   NULL,
};

/* search46_1_0_0 -> search2_0 in the cache */
/* search46_1_0 -> search22_0 in the cache */
static const nir_search_expression search46_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search22_0.value },
   NULL,
};
static const nir_search_expression search46 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search46_0.value, &search46_1.value },
   NULL,
};

   /* replace46_0_0 -> search2_0 in the cache */
/* replace46_0 -> replace24 in the cache */
static const nir_search_expression replace46 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace24.value },
   NULL,
};

   /* search47_0 -> search2_0 in the cache */

/* search47_1 -> search30_1 in the cache */
static const nir_search_expression search47 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search30_1.value },
   NULL,
};

   /* replace47 -> search30_1 in the cache */

   /* search48_0 -> search31_0 in the cache */

/* search48_1 -> search31_1 in the cache */
static const nir_search_expression search48 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search31_0.value, &search31_1.value },
   NULL,
};

   /* replace48 -> search31_1 in the cache */

   /* search49_0 -> search3_0_0 in the cache */

/* search49_1 -> search32_1 in the cache */
static const nir_search_expression search49 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0_0.value, &search32_1.value },
   NULL,
};

   /* replace49 -> search32_1 in the cache */

   /* search50_0 -> search2_0 in the cache */

/* search50_1 -> replace9 in the cache */
static const nir_search_expression search50 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace50 -> replace9 in the cache */

   /* search51_0 -> search3_0_0 in the cache */

/* search51_1 -> search34_1 in the cache */
static const nir_search_expression search51 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8_vc4,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* replace51 -> search34_1 in the cache */

   /* search52_0 -> search3_0_0 in the cache */

/* search52_1 -> search35_1 in the cache */
static const nir_search_expression search52 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8_vc4,
   { &search3_0_0.value, &search35_1.value },
   NULL,
};

   /* replace52 -> search3_0_0 in the cache */

   /* search53_0 -> search2_0 in the cache */

static const nir_search_constant search53_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search53 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   /* replace53 -> search2_0 in the cache */

   /* search54_0 -> search2_0 in the cache */

/* search54_1 -> search53_1 in the cache */
static const nir_search_expression search54 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search53_1.value },
   (is_only_used_as_float),
};

   /* replace54 -> search2_0 in the cache */

   /* search55_0 -> search2_0 in the cache */

/* search55_1 -> replace2_1_0 in the cache */
static const nir_search_expression search55 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace55 -> search2_0 in the cache */

   /* search56_0 -> search2_0 in the cache */

static const nir_search_constant search56_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};
static const nir_search_expression search56 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search56_1.value },
   NULL,
};

   /* replace56_0 -> search2_0 in the cache */
/* replace56 -> search22_0 in the cache */

   /* search57_0 -> search2_0 in the cache */

/* search57_1 -> search11_1 in the cache */
static const nir_search_expression search57 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace57_0 -> search2_0 in the cache */
/* replace57 -> search23_0 in the cache */

   /* search58_0_0 -> search2_0 in the cache */
static const nir_search_expression search58_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search2_0.value },
   NULL,
};

/* search58_1_0 -> search2_0 in the cache */

/* search58_1_1 -> search2_0 in the cache */
static const nir_search_expression search58_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search2_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search58 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search58_0.value, &search58_1.value },
   NULL,
};

   /* replace58_0_0 -> search2_0 in the cache */
/* replace58_0 -> replace24 in the cache */

/* replace58_1 -> search2_0 in the cache */
static const nir_search_expression replace58 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace24.value, &search2_0.value },
   NULL,
};

   /* search59_0_0_0 -> search2_0 in the cache */
/* search59_0_0 -> search58_0 in the cache */

/* search59_0_1 -> search2_0 in the cache */
static const nir_search_expression search59_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search58_0.value, &search2_0.value },
   NULL,
};

/* search59_1 -> search2_0 in the cache */
static const nir_search_expression search59 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search59_0.value, &search2_0.value },
   NULL,
};

   /* replace59_0_0 -> search2_0 in the cache */
/* replace59_0 -> replace24 in the cache */

/* replace59_1 -> search2_0 in the cache */
/* replace59 -> replace58 in the cache */

   static const nir_search_constant search60_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search60_1 -> search0_0 in the cache */

/* search60_2 -> replace0_1_0 in the cache */
static const nir_search_expression search60 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search60_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace60 -> replace0_1_0 in the cache */

   /* search61_0 -> search31_1 in the cache */

/* search61_1 -> search31_0 in the cache */

static const nir_search_variable search61_2 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search61 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search31_1.value, &search31_0.value, &search61_2.value },
   (is_only_used_as_float),
};

   /* replace61 -> search61_2 in the cache */

   /* search62_0 -> search32_1 in the cache */

/* search62_1 -> search3_0_0 in the cache */

/* search62_2 -> replace2_1_1 in the cache */
static const nir_search_expression search62 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search32_1.value, &search3_0_0.value, &replace2_1_1.value },
   (is_only_used_as_float),
};

   /* replace62 -> replace2_1_1 in the cache */

   /* search63_0 -> search0_0 in the cache */

/* search63_1 -> replace0_1_0 in the cache */

/* search63_2 -> search60_0 in the cache */
static const nir_search_expression search63 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search0_0.value, &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* replace63_0 -> search0_0 in the cache */

/* replace63_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace63 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search64_0 -> search31_0 in the cache */

/* search64_1 -> search61_2 in the cache */

/* search64_2 -> search31_1 in the cache */
static const nir_search_expression search64 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search31_0.value, &search61_2.value, &search31_1.value },
   NULL,
};

   /* replace64_0 -> search31_0 in the cache */

/* replace64_1 -> search61_2 in the cache */
static const nir_search_expression replace64 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search31_0.value, &search61_2.value },
   NULL,
};

   /* search65_0 -> search3_0_0 in the cache */

/* search65_1 -> replace2_1_1 in the cache */

/* search65_2 -> search32_1 in the cache */
static const nir_search_expression search65 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search3_0_0.value, &replace2_1_1.value, &search32_1.value },
   NULL,
};

   /* replace65_0 -> search3_0_0 in the cache */

/* replace65_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace65 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   static const nir_search_constant search66_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search66_1 -> search0_0 in the cache */

/* search66_2 -> replace0_1_0 in the cache */
static const nir_search_expression search66 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search66_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace66_0 -> search0_0 in the cache */

/* replace66_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace66 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_constant search67_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

/* search67_1 -> search0_0 in the cache */

/* search67_2 -> replace0_1_0 in the cache */
static const nir_search_expression search67 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search67_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace67_0_0 -> search0_0 in the cache */
/* replace67_0 -> search44_0 in the cache */

/* replace67_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace67 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search44_0.value, &replace0_1_0.value },
   NULL,
};

   /* search68_0 -> search0_0 in the cache */

/* search68_1 -> replace0_1_0 in the cache */

/* search68_2 -> search60_0 in the cache */
static const nir_search_expression search68 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* replace68 -> search0_0 in the cache */

   /* search69_0 -> search0_0 in the cache */

/* search69_1 -> replace0_1_0 in the cache */

/* search69_2 -> search66_0 in the cache */
static const nir_search_expression search69 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &replace0_1_0.value, &search66_0.value },
   NULL,
};

   /* replace69 -> replace0_1_0 in the cache */

   /* search70_0 -> search0_0 in the cache */

/* search70_1 -> search0_0 in the cache */

/* search70_2 -> replace0_1_0 in the cache */
static const nir_search_expression search70 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace70 -> search0_0 in the cache */

   /* search71_0 -> search60_0 in the cache */

/* search71_1 -> search0_0 in the cache */

/* search71_2 -> replace0_1_0 in the cache */
static const nir_search_expression search71 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search60_0.value, &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace71_0 -> search0_0 in the cache */

/* replace71_1 -> replace0_1_0 in the cache */
/* replace71 -> replace63 in the cache */

   /* search72_0 -> search36_0_0 in the cache */

/* search72_1_0 -> search36_0_0 in the cache */

/* search72_1_1 -> search36_0_1 in the cache */
static const nir_search_expression search72_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search72_2 -> search36_1_1 in the cache */
static const nir_search_expression search72 = {
   { nir_search_value_expression, -3 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search36_0_0.value, &search72_1.value, &search36_1_1.value },
   NULL,
};

   /* replace72_0_0 -> search36_0_1 in the cache */

/* replace72_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace72_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};

/* replace72_1 -> search36_0_0 in the cache */
static const nir_search_expression replace72 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace72_0.value, &search36_0_0.value },
   NULL,
};

   /* search73_0 -> search31_0 in the cache */

/* search73_1 -> search61_2 in the cache */

static const nir_search_variable search73_2_0 = {
   { nir_search_value_variable, 1 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search73_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search73_2_0.value },
   NULL,
};
static const nir_search_expression search73 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search31_0.value, &search61_2.value, &search73_2.value },
   NULL,
};

   /* replace73_0 -> search73_2_0 in the cache */

/* replace73_1 -> search61_2 in the cache */

/* replace73_2 -> search31_0 in the cache */
static const nir_search_expression replace73 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search73_2_0.value, &search61_2.value, &search31_0.value },
   NULL,
};

   /* search74_0 -> search31_0 in the cache */

/* search74_1_0 -> search31_0 in the cache */

/* search74_1_1 -> search61_2 in the cache */
static const nir_search_expression search74_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search31_0.value, &search61_2.value },
   NULL,
};

static const nir_search_variable search74_2 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search74 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search31_0.value, &search74_1.value, &search74_2.value },
   NULL,
};

   /* replace74_0_0 -> search61_2 in the cache */

/* replace74_0_1 -> search74_2 in the cache */
static const nir_search_expression replace74_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search61_2.value, &search74_2.value },
   NULL,
};

/* replace74_1 -> search31_0 in the cache */
static const nir_search_expression replace74 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace74_0.value, &search31_0.value },
   NULL,
};

   /* search75_0_0 -> search31_0 in the cache */

/* search75_0_1 -> search61_2 in the cache */
/* search75_0 -> search74_1 in the cache */

/* search75_1_0 -> search31_0 in the cache */

/* search75_1_1 -> search74_2 in the cache */
static const nir_search_expression search75_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search31_0.value, &search74_2.value },
   NULL,
};

static const nir_search_variable search75_2 = {
   { nir_search_value_variable, 16 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search75 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search74_1.value, &search75_1.value, &search75_2.value },
   NULL,
};

   /* replace75_0_0 -> search61_2 in the cache */

/* replace75_0_1 -> search74_2 in the cache */

/* replace75_0_2 -> search75_2 in the cache */
static const nir_search_expression replace75_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search61_2.value, &search74_2.value, &search75_2.value },
   NULL,
};

/* replace75_1 -> search31_0 in the cache */
static const nir_search_expression replace75 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace75_0.value, &search31_0.value },
   NULL,
};

   /* search76_0 -> search31_0 in the cache */

/* search76_1_0 -> search31_0 in the cache */

/* search76_1_1 -> search61_2 in the cache */
static const nir_search_expression search76_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search31_0.value, &search61_2.value },
   (is_used_once),
};

/* search76_2 -> search74_2 in the cache */
static const nir_search_expression search76 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search31_0.value, &search76_1.value, &search74_2.value },
   NULL,
};

   static const nir_search_constant replace76_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace76_0_1 -> search61_2 in the cache */

/* replace76_0_2 -> search74_2 in the cache */
static const nir_search_expression replace76_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace76_0_0.value, &search61_2.value, &search74_2.value },
   NULL,
};

/* replace76_1 -> search31_0 in the cache */
static const nir_search_expression replace76 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace76_0.value, &search31_0.value },
   NULL,
};

   /* search77_0_0 -> search31_0 in the cache */

/* search77_0_1_0 -> replace76_0_0 in the cache */

static const nir_search_variable search77_0_1_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search77_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search77_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search77_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace76_0_0.value, &search77_0_1_1.value },
   NULL,
};
static const nir_search_expression search77_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search31_0.value, &search77_0_1.value },
   NULL,
};

static const nir_search_variable search77_1_0 = {
   { nir_search_value_variable, 16 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search77_1_1 -> search77_0_1_1_0 in the cache */
static const nir_search_expression search77_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search77_1_0.value, &search77_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search77 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search77_0.value, &search77_1.value },
   NULL,
};

   /* replace77_0 -> search31_0 in the cache */

/* replace77_1 -> search77_1_0 in the cache */

/* replace77_2 -> search77_0_1_1_0 in the cache */
static const nir_search_expression replace77 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search31_0.value, &search77_1_0.value, &search77_0_1_1_0.value },
   NULL,
};

   /* search78_0_0 -> search31_0 in the cache */

/* search78_0_1_0_0 -> replace76_0_0 in the cache */

/* search78_0_1_0_1_0 -> search77_0_1_1_0 in the cache */
/* search78_0_1_0_1 -> search77_0_1_1 in the cache */
/* search78_0_1_0 -> search77_0_1 in the cache */
static const nir_search_expression search78_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search77_0_1.value },
   NULL,
};
static const nir_search_expression search78_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search31_0.value, &search78_0_1.value },
   NULL,
};

/* search78_1_0 -> search77_1_0 in the cache */

/* search78_1_1_0 -> search77_0_1_1_0 in the cache */
static const nir_search_expression search78_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search77_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search78_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search77_1_0.value, &search78_1_1.value },
   NULL,
};
static const nir_search_expression search78 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search78_0.value, &search78_1.value },
   NULL,
};

   /* replace78_0 -> search31_0 in the cache */

/* replace78_1 -> search77_1_0 in the cache */

/* replace78_2_0 -> search77_0_1_1_0 in the cache */
/* replace78_2 -> search78_1_1 in the cache */
static const nir_search_expression replace78 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search31_0.value, &search77_1_0.value, &search78_1_1.value },
   NULL,
};

   /* search79_0 -> search31_0 in the cache */

/* search79_1_0 -> search77_0_1_1_0 in the cache */

/* search79_1_1_0 -> search77_1_0 in the cache */

/* search79_1_1_1_0 -> search31_0 in the cache */
static const nir_search_expression search79_1_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search79_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search77_1_0.value, &search79_1_1_1.value },
   NULL,
};
static const nir_search_expression search79_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search77_0_1_1_0.value, &search79_1_1.value },
   NULL,
};
static const nir_search_expression search79 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search31_0.value, &search79_1.value },
   NULL,
};

   /* replace79_0 -> search31_0 in the cache */

/* replace79_1 -> search77_1_0 in the cache */

/* replace79_2 -> search77_0_1_1_0 in the cache */
/* replace79 -> replace77 in the cache */

   /* search80_0_0 -> search31_0 in the cache */

/* search80_0_1_0 -> replace76_0_0 in the cache */

static const nir_search_variable search80_0_1_1_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search80_0_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search80_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search80_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search80_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search80_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace76_0_0.value, &search80_0_1_1.value },
   NULL,
};
static const nir_search_expression search80_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search31_0.value, &search80_0_1.value },
   NULL,
};

/* search80_1_0 -> search77_1_0 in the cache */

/* search80_1_1_0 -> search80_0_1_1_0_0 in the cache */
/* search80_1_1 -> search80_0_1_1_0 in the cache */
static const nir_search_expression search80_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search77_1_0.value, &search80_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search80 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search80_0.value, &search80_1.value },
   NULL,
};

   /* replace80_0 -> search80_0_1_1_0_0 in the cache */

/* replace80_1 -> search77_1_0 in the cache */

/* replace80_2 -> search31_0 in the cache */
static const nir_search_expression replace80 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search80_0_1_1_0_0.value, &search77_1_0.value, &search31_0.value },
   NULL,
};

   /* search81_0 -> search31_0 in the cache */

/* search81_1_0_0 -> search80_0_1_1_0_0 in the cache */
/* search81_1_0 -> search80_0_1_1_0 in the cache */

/* search81_1_1_0 -> search77_1_0 in the cache */

/* search81_1_1_1_0 -> search31_0 in the cache */
/* search81_1_1_1 -> search79_1_1_1 in the cache */
/* search81_1_1 -> search79_1_1 in the cache */
static const nir_search_expression search81_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search80_0_1_1_0.value, &search79_1_1.value },
   NULL,
};
static const nir_search_expression search81 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search31_0.value, &search81_1.value },
   NULL,
};

   /* replace81_0 -> search80_0_1_1_0_0 in the cache */

/* replace81_1 -> search77_1_0 in the cache */

/* replace81_2 -> search31_0 in the cache */
/* replace81 -> replace80 in the cache */

   /* search82_0 -> replace76_0_0 in the cache */

/* search82_1_0_0_0 -> replace76_0_0 in the cache */

/* search82_1_0_0_1_0 -> search31_0 in the cache */
/* search82_1_0_0_1 -> search79_1_1_1 in the cache */
static const nir_search_expression search82_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace76_0_0.value, &search79_1_1_1.value },
   NULL,
};

/* search82_1_0_1_0 -> replace76_0_0 in the cache */

/* search82_1_0_1_1_0 -> search61_2 in the cache */
static const nir_search_expression search82_1_0_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search61_2.value },
   NULL,
};
static const nir_search_expression search82_1_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace76_0_0.value, &search82_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search82_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search82_1_0_0.value, &search82_1_0_1.value },
   NULL,
};
static const nir_search_expression search82_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search82_1_0.value },
   NULL,
};
static const nir_search_expression search82 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace76_0_0.value, &search82_1.value },
   NULL,
};

   /* replace82_0 -> search61_2 in the cache */

/* replace82_1 -> replace76_0_0 in the cache */

/* replace82_2 -> search31_0 in the cache */
static const nir_search_expression replace82 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search61_2.value, &replace76_0_0.value, &search31_0.value },
   NULL,
};

   /* search83_0 -> search3_0_0 in the cache */

/* search83_1 -> replace2_1_1 in the cache */

/* search83_2_0 -> search73_2_0 in the cache */
static const nir_search_expression search83_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search73_2_0.value },
   NULL,
};
static const nir_search_expression search83 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0_0.value, &replace2_1_1.value, &search83_2.value },
   NULL,
};

   /* replace83_0 -> search73_2_0 in the cache */

/* replace83_1 -> replace2_1_1 in the cache */

/* replace83_2 -> search3_0_0 in the cache */
static const nir_search_expression replace83 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search73_2_0.value, &replace2_1_1.value, &search3_0_0.value },
   NULL,
};

   /* search84_0 -> search3_0_0 in the cache */

/* search84_1_0 -> search3_0_0 in the cache */

/* search84_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search84_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

static const nir_search_variable search84_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search84 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search3_0_0.value, &search84_1.value, &search84_2.value },
   NULL,
};

   /* replace84_0_0 -> replace2_1_1 in the cache */

/* replace84_0_1 -> search84_2 in the cache */
static const nir_search_expression replace84_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &replace2_1_1.value, &search84_2.value },
   NULL,
};

/* replace84_1 -> search3_0_0 in the cache */
static const nir_search_expression replace84 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace84_0.value, &search3_0_0.value },
   NULL,
};

   /* search85_0_0 -> search3_0_0 in the cache */

/* search85_0_1 -> replace2_1_1 in the cache */
/* search85_0 -> search84_1 in the cache */

/* search85_1_0 -> search3_0_0 in the cache */

/* search85_1_1 -> search84_2 in the cache */
static const nir_search_expression search85_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search3_0_0.value, &search84_2.value },
   NULL,
};

static const nir_search_variable search85_2 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search85 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search84_1.value, &search85_1.value, &search85_2.value },
   NULL,
};

   /* replace85_0_0 -> replace2_1_1 in the cache */

/* replace85_0_1 -> search84_2 in the cache */

/* replace85_0_2 -> search85_2 in the cache */
static const nir_search_expression replace85_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace2_1_1.value, &search84_2.value, &search85_2.value },
   NULL,
};

/* replace85_1 -> search3_0_0 in the cache */
static const nir_search_expression replace85 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace85_0.value, &search3_0_0.value },
   NULL,
};

   /* search86_0 -> search3_0_0 in the cache */

/* search86_1_0 -> search3_0_0 in the cache */

/* search86_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search86_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search3_0_0.value, &replace2_1_1.value },
   (is_used_once),
};

/* search86_2 -> search84_2 in the cache */
static const nir_search_expression search86 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search3_0_0.value, &search86_1.value, &search84_2.value },
   NULL,
};

   static const nir_search_constant replace86_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace86_0_1 -> replace2_1_1 in the cache */

/* replace86_0_2 -> search84_2 in the cache */
static const nir_search_expression replace86_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace86_0_0.value, &replace2_1_1.value, &search84_2.value },
   NULL,
};

/* replace86_1 -> search3_0_0 in the cache */
static const nir_search_expression replace86 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace86_0.value, &search3_0_0.value },
   NULL,
};

   /* search87_0_0 -> search3_0_0 in the cache */

/* search87_0_1_0 -> replace86_0_0 in the cache */

static const nir_search_variable search87_0_1_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search87_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search87_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search87_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace86_0_0.value, &search87_0_1_1.value },
   NULL,
};
static const nir_search_expression search87_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0_0.value, &search87_0_1.value },
   NULL,
};

static const nir_search_variable search87_1_0 = {
   { nir_search_value_variable, 32 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search87_1_1 -> search87_0_1_1_0 in the cache */
static const nir_search_expression search87_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search87_1_0.value, &search87_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search87 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search87_0.value, &search87_1.value },
   NULL,
};

   /* replace87_0 -> search3_0_0 in the cache */

/* replace87_1 -> search87_1_0 in the cache */

/* replace87_2 -> search87_0_1_1_0 in the cache */
static const nir_search_expression replace87 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0_0.value, &search87_1_0.value, &search87_0_1_1_0.value },
   NULL,
};

   /* search88_0_0 -> search3_0_0 in the cache */

/* search88_0_1_0_0 -> replace86_0_0 in the cache */

/* search88_0_1_0_1_0 -> search87_0_1_1_0 in the cache */
/* search88_0_1_0_1 -> search87_0_1_1 in the cache */
/* search88_0_1_0 -> search87_0_1 in the cache */
static const nir_search_expression search88_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search87_0_1.value },
   NULL,
};
static const nir_search_expression search88_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0_0.value, &search88_0_1.value },
   NULL,
};

/* search88_1_0 -> search87_1_0 in the cache */

/* search88_1_1_0 -> search87_0_1_1_0 in the cache */
static const nir_search_expression search88_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search87_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search88_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search87_1_0.value, &search88_1_1.value },
   NULL,
};
static const nir_search_expression search88 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search88_0.value, &search88_1.value },
   NULL,
};

   /* replace88_0 -> search3_0_0 in the cache */

/* replace88_1 -> search87_1_0 in the cache */

/* replace88_2_0 -> search87_0_1_1_0 in the cache */
/* replace88_2 -> search88_1_1 in the cache */
static const nir_search_expression replace88 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search3_0_0.value, &search87_1_0.value, &search88_1_1.value },
   NULL,
};

   /* search89_0 -> search3_0_0 in the cache */

/* search89_1_0 -> search87_0_1_1_0 in the cache */

/* search89_1_1_0 -> search87_1_0 in the cache */

/* search89_1_1_1_0 -> search3_0_0 in the cache */
static const nir_search_expression search89_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search89_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search87_1_0.value, &search89_1_1_1.value },
   NULL,
};
static const nir_search_expression search89_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search87_0_1_1_0.value, &search89_1_1.value },
   NULL,
};
static const nir_search_expression search89 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search3_0_0.value, &search89_1.value },
   NULL,
};

   /* replace89_0 -> search3_0_0 in the cache */

/* replace89_1 -> search87_1_0 in the cache */

/* replace89_2 -> search87_0_1_1_0 in the cache */
/* replace89 -> replace87 in the cache */

   /* search90_0_0 -> search3_0_0 in the cache */

/* search90_0_1_0 -> replace86_0_0 in the cache */

/* search90_0_1_1_0_0 -> search80_0_1_1_0_0 in the cache */
static const nir_search_expression search90_0_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search80_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search90_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search90_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search90_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace86_0_0.value, &search90_0_1_1.value },
   NULL,
};
static const nir_search_expression search90_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search3_0_0.value, &search90_0_1.value },
   NULL,
};

/* search90_1_0 -> search87_1_0 in the cache */

/* search90_1_1_0 -> search80_0_1_1_0_0 in the cache */
/* search90_1_1 -> search90_0_1_1_0 in the cache */
static const nir_search_expression search90_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search87_1_0.value, &search90_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search90 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search90_0.value, &search90_1.value },
   NULL,
};

   /* replace90_0 -> search80_0_1_1_0_0 in the cache */

/* replace90_1 -> search87_1_0 in the cache */

/* replace90_2 -> search3_0_0 in the cache */
static const nir_search_expression replace90 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search80_0_1_1_0_0.value, &search87_1_0.value, &search3_0_0.value },
   NULL,
};

   /* search91_0 -> search3_0_0 in the cache */

/* search91_1_0_0 -> search80_0_1_1_0_0 in the cache */
/* search91_1_0 -> search90_0_1_1_0 in the cache */

/* search91_1_1_0 -> search87_1_0 in the cache */

/* search91_1_1_1_0 -> search3_0_0 in the cache */
/* search91_1_1_1 -> search89_1_1_1 in the cache */
/* search91_1_1 -> search89_1_1 in the cache */
static const nir_search_expression search91_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search90_0_1_1_0.value, &search89_1_1.value },
   NULL,
};
static const nir_search_expression search91 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search3_0_0.value, &search91_1.value },
   NULL,
};

   /* replace91_0 -> search80_0_1_1_0_0 in the cache */

/* replace91_1 -> search87_1_0 in the cache */

/* replace91_2 -> search3_0_0 in the cache */
/* replace91 -> replace90 in the cache */

   /* search92_0 -> replace86_0_0 in the cache */

/* search92_1_0_0_0 -> replace86_0_0 in the cache */

/* search92_1_0_0_1_0 -> search3_0_0 in the cache */
/* search92_1_0_0_1 -> search89_1_1_1 in the cache */
static const nir_search_expression search92_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace86_0_0.value, &search89_1_1_1.value },
   NULL,
};

/* search92_1_0_1_0 -> replace86_0_0 in the cache */

/* search92_1_0_1_1_0 -> replace2_1_1 in the cache */
static const nir_search_expression search92_1_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search92_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace86_0_0.value, &search92_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search92_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search92_1_0_0.value, &search92_1_0_1.value },
   NULL,
};
static const nir_search_expression search92_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search92_1_0.value },
   NULL,
};
static const nir_search_expression search92 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace86_0_0.value, &search92_1.value },
   NULL,
};

   /* replace92_0 -> replace2_1_1 in the cache */

/* replace92_1 -> replace86_0_0 in the cache */

/* replace92_2 -> search3_0_0 in the cache */
static const nir_search_expression replace92 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace2_1_1.value, &replace86_0_0.value, &search3_0_0.value },
   NULL,
};

   static const nir_search_variable search93_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search93_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search93_2_0 -> search73_2_0 in the cache */
static const nir_search_expression search93_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search73_2_0.value },
   NULL,
};
static const nir_search_expression search93 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search93_0.value, &search93_1.value, &search93_2.value },
   NULL,
};

   /* replace93_0 -> search73_2_0 in the cache */

/* replace93_1 -> search93_1 in the cache */

/* replace93_2 -> search93_0 in the cache */
static const nir_search_expression replace93 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search73_2_0.value, &search93_1.value, &search93_0.value },
   NULL,
};

   /* search94_0 -> search93_0 in the cache */

/* search94_1_0 -> search93_0 in the cache */

/* search94_1_1 -> search93_1 in the cache */
static const nir_search_expression search94_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

static const nir_search_variable search94_2 = {
   { nir_search_value_variable, 64 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search94 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search93_0.value, &search94_1.value, &search94_2.value },
   NULL,
};

   /* replace94_0_0 -> search93_1 in the cache */

/* replace94_0_1 -> search94_2 in the cache */
static const nir_search_expression replace94_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search93_1.value, &search94_2.value },
   NULL,
};

/* replace94_1 -> search93_0 in the cache */
static const nir_search_expression replace94 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace94_0.value, &search93_0.value },
   NULL,
};

   /* search95_0_0 -> search93_0 in the cache */

/* search95_0_1 -> search93_1 in the cache */
/* search95_0 -> search94_1 in the cache */

/* search95_1_0 -> search93_0 in the cache */

/* search95_1_1 -> search94_2 in the cache */
static const nir_search_expression search95_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search93_0.value, &search94_2.value },
   NULL,
};

static const nir_search_variable search95_2 = {
   { nir_search_value_variable, 64 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search95 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search94_1.value, &search95_1.value, &search95_2.value },
   NULL,
};

   /* replace95_0_0 -> search93_1 in the cache */

/* replace95_0_1 -> search94_2 in the cache */

/* replace95_0_2 -> search95_2 in the cache */
static const nir_search_expression replace95_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search93_1.value, &search94_2.value, &search95_2.value },
   NULL,
};

/* replace95_1 -> search93_0 in the cache */
static const nir_search_expression replace95 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace95_0.value, &search93_0.value },
   NULL,
};

   /* search96_0 -> search93_0 in the cache */

/* search96_1_0 -> search93_0 in the cache */

/* search96_1_1 -> search93_1 in the cache */
static const nir_search_expression search96_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search93_0.value, &search93_1.value },
   (is_used_once),
};

/* search96_2 -> search94_2 in the cache */
static const nir_search_expression search96 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search93_0.value, &search96_1.value, &search94_2.value },
   NULL,
};

   static const nir_search_constant replace96_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace96_0_1 -> search93_1 in the cache */

/* replace96_0_2 -> search94_2 in the cache */
static const nir_search_expression replace96_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace96_0_0.value, &search93_1.value, &search94_2.value },
   NULL,
};

/* replace96_1 -> search93_0 in the cache */
static const nir_search_expression replace96 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace96_0.value, &search93_0.value },
   NULL,
};

   /* search97_0_0 -> search93_0 in the cache */

/* search97_0_1_0 -> replace96_0_0 in the cache */

static const nir_search_variable search97_0_1_1_0 = {
   { nir_search_value_variable, 64 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search97_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search97_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search97_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace96_0_0.value, &search97_0_1_1.value },
   NULL,
};
static const nir_search_expression search97_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search93_0.value, &search97_0_1.value },
   NULL,
};

static const nir_search_variable search97_1_0 = {
   { nir_search_value_variable, 64 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search97_1_1 -> search97_0_1_1_0 in the cache */
static const nir_search_expression search97_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search97_1_0.value, &search97_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search97 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search97_0.value, &search97_1.value },
   NULL,
};

   /* replace97_0 -> search93_0 in the cache */

/* replace97_1 -> search97_1_0 in the cache */

/* replace97_2 -> search97_0_1_1_0 in the cache */
static const nir_search_expression replace97 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search93_0.value, &search97_1_0.value, &search97_0_1_1_0.value },
   NULL,
};

   /* search98_0_0 -> search93_0 in the cache */

/* search98_0_1_0_0 -> replace96_0_0 in the cache */

/* search98_0_1_0_1_0 -> search97_0_1_1_0 in the cache */
/* search98_0_1_0_1 -> search97_0_1_1 in the cache */
/* search98_0_1_0 -> search97_0_1 in the cache */
static const nir_search_expression search98_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search97_0_1.value },
   NULL,
};
static const nir_search_expression search98_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search93_0.value, &search98_0_1.value },
   NULL,
};

/* search98_1_0 -> search97_1_0 in the cache */

/* search98_1_1_0 -> search97_0_1_1_0 in the cache */
static const nir_search_expression search98_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search97_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search98_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search97_1_0.value, &search98_1_1.value },
   NULL,
};
static const nir_search_expression search98 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search98_0.value, &search98_1.value },
   NULL,
};

   /* replace98_0 -> search93_0 in the cache */

/* replace98_1 -> search97_1_0 in the cache */

/* replace98_2_0 -> search97_0_1_1_0 in the cache */
/* replace98_2 -> search98_1_1 in the cache */
static const nir_search_expression replace98 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search93_0.value, &search97_1_0.value, &search98_1_1.value },
   NULL,
};

   /* search99_0 -> search93_0 in the cache */

/* search99_1_0 -> search97_0_1_1_0 in the cache */

/* search99_1_1_0 -> search97_1_0 in the cache */

/* search99_1_1_1_0 -> search93_0 in the cache */
static const nir_search_expression search99_1_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search99_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search97_1_0.value, &search99_1_1_1.value },
   NULL,
};
static const nir_search_expression search99_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search97_0_1_1_0.value, &search99_1_1.value },
   NULL,
};
static const nir_search_expression search99 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search93_0.value, &search99_1.value },
   NULL,
};

   /* replace99_0 -> search93_0 in the cache */

/* replace99_1 -> search97_1_0 in the cache */

/* replace99_2 -> search97_0_1_1_0 in the cache */
/* replace99 -> replace97 in the cache */

   /* search100_0_0 -> search93_0 in the cache */

/* search100_0_1_0 -> replace96_0_0 in the cache */

/* search100_0_1_1_0_0 -> search80_0_1_1_0_0 in the cache */
static const nir_search_expression search100_0_1_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search80_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search100_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search100_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search100_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace96_0_0.value, &search100_0_1_1.value },
   NULL,
};
static const nir_search_expression search100_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search93_0.value, &search100_0_1.value },
   NULL,
};

/* search100_1_0 -> search97_1_0 in the cache */

/* search100_1_1_0 -> search80_0_1_1_0_0 in the cache */
/* search100_1_1 -> search100_0_1_1_0 in the cache */
static const nir_search_expression search100_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search97_1_0.value, &search100_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search100 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search100_0.value, &search100_1.value },
   NULL,
};

   /* replace100_0 -> search80_0_1_1_0_0 in the cache */

/* replace100_1 -> search97_1_0 in the cache */

/* replace100_2 -> search93_0 in the cache */
static const nir_search_expression replace100 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search80_0_1_1_0_0.value, &search97_1_0.value, &search93_0.value },
   NULL,
};

   /* search101_0 -> search93_0 in the cache */

/* search101_1_0_0 -> search80_0_1_1_0_0 in the cache */
/* search101_1_0 -> search100_0_1_1_0 in the cache */

/* search101_1_1_0 -> search97_1_0 in the cache */

/* search101_1_1_1_0 -> search93_0 in the cache */
/* search101_1_1_1 -> search99_1_1_1 in the cache */
/* search101_1_1 -> search99_1_1 in the cache */
static const nir_search_expression search101_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search100_0_1_1_0.value, &search99_1_1.value },
   NULL,
};
static const nir_search_expression search101 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search93_0.value, &search101_1.value },
   NULL,
};

   /* replace101_0 -> search80_0_1_1_0_0 in the cache */

/* replace101_1 -> search97_1_0 in the cache */

/* replace101_2 -> search93_0 in the cache */
/* replace101 -> replace100 in the cache */

   /* search102_0 -> replace96_0_0 in the cache */

/* search102_1_0_0_0 -> replace96_0_0 in the cache */

/* search102_1_0_0_1_0 -> search93_0 in the cache */
/* search102_1_0_0_1 -> search99_1_1_1 in the cache */
static const nir_search_expression search102_1_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace96_0_0.value, &search99_1_1_1.value },
   NULL,
};

/* search102_1_0_1_0 -> replace96_0_0 in the cache */

/* search102_1_0_1_1_0 -> search93_1 in the cache */
static const nir_search_expression search102_1_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search93_1.value },
   NULL,
};
static const nir_search_expression search102_1_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace96_0_0.value, &search102_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search102_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search102_1_0_0.value, &search102_1_0_1.value },
   NULL,
};
static const nir_search_expression search102_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search102_1_0.value },
   NULL,
};
static const nir_search_expression search102 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace96_0_0.value, &search102_1.value },
   NULL,
};

   /* replace102_0 -> search93_1 in the cache */

/* replace102_1 -> replace96_0_0 in the cache */

/* replace102_2 -> search93_0 in the cache */
static const nir_search_expression replace102 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search93_1.value, &replace96_0_0.value, &search93_0.value },
   NULL,
};

   static const nir_search_variable search103_0_0 = {
   { nir_search_value_variable, -4 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search103_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search103_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search103_0_0.value, &search103_0_1.value },
   (is_used_once),
};

/* search103_1_0 -> search103_0_0 in the cache */

static const nir_search_variable search103_1_1 = {
   { nir_search_value_variable, -4 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search103_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search103_0_0.value, &search103_1_1.value },
   (is_used_once),
};

static const nir_search_variable search103_2 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search103 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search103_0.value, &search103_1.value, &search103_2.value },
   NULL,
};

   /* replace103_0_0 -> search103_0_1 in the cache */

/* replace103_0_1 -> search103_1_1 in the cache */

/* replace103_0_2 -> search103_2 in the cache */
static const nir_search_expression replace103_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search103_0_1.value, &search103_1_1.value, &search103_2.value },
   NULL,
};

/* replace103_1 -> search103_0_0 in the cache */
static const nir_search_expression replace103 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace103_0.value, &search103_0_0.value },
   NULL,
};

   /* search104_0 -> search0_0 in the cache */

/* search104_1 -> search60_0 in the cache */

static const nir_search_variable search104_2 = {
   { nir_search_value_variable, -2 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search104 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search60_0.value, &search104_2.value },
   NULL,
};

   /* replace104_0_0_0 -> search0_0 in the cache */
/* replace104_0_0 -> search44_0 in the cache */

/* replace104_0_1 -> search104_2 in the cache */
static const nir_search_expression replace104_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search44_0.value, &search104_2.value },
   NULL,
};

/* replace104_1 -> search0_0 in the cache */
static const nir_search_expression replace104 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace104_0.value, &search0_0.value },
   NULL,
};

   /* search105_0 -> search2_0 in the cache */
static const nir_search_expression search105 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search2_0.value },
   NULL,
};

   /* replace105_0_0 -> search2_0 in the cache */

/* replace105_0_1 -> search30_1 in the cache */
static const nir_search_expression replace105_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search30_1.value },
   NULL,
};

/* replace105_1_0_0_0 -> search2_0 in the cache */
/* replace105_1_0_0 -> replace24 in the cache */
static const nir_search_expression replace105_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace24.value },
   NULL,
};
static const nir_search_expression replace105_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace105_1_0.value },
   NULL,
};

/* replace105_2_0_0 -> search2_0 in the cache */
/* replace105_2_0 -> replace24 in the cache */
/* replace105_2 -> replace105_1_0 in the cache */
static const nir_search_expression replace105 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace105_0.value, &replace105_1.value, &replace105_1_0.value },
   NULL,
};

   /* search106_0 -> search2_0 in the cache */
static const nir_search_expression search106 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search2_0.value },
   NULL,
};

   /* replace106_0 -> search2_0 in the cache */

/* replace106_1_0 -> search2_0 in the cache */
static const nir_search_expression replace106_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffract,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression replace106 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &replace106_1.value },
   NULL,
};

   /* search107_0 -> search2_0 in the cache */

/* search107_1_0_0 -> search2_0 in the cache */
/* search107_1_0 -> replace106_1 in the cache */
static const nir_search_expression search107_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace106_1.value },
   NULL,
};
static const nir_search_expression search107 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search107_1.value },
   NULL,
};

   /* replace107_0 -> search2_0 in the cache */
/* replace107 -> search106 in the cache */

   /* search108_0 -> search2_0 in the cache */
/* search108 -> replace106_1 in the cache */

   /* replace108_0 -> search2_0 in the cache */

/* replace108_1_0 -> search2_0 in the cache */
/* replace108_1 -> search106 in the cache */
static const nir_search_expression replace108 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &search106.value },
   NULL,
};

   /* search109_0 -> search2_0 in the cache */
static const nir_search_expression search109 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search2_0.value },
   NULL,
};

   /* replace109_0_0_0 -> search2_0 in the cache */
/* replace109_0_0 -> search22_0 in the cache */
static const nir_search_expression replace109_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search22_0.value },
   NULL,
};
static const nir_search_expression replace109 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace109_0.value },
   NULL,
};

   /* search110_0 -> search31_0 in the cache */

/* search110_1 -> search61_2 in the cache */

/* search110_2 -> search74_2 in the cache */
static const nir_search_expression search110 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search31_0.value, &search61_2.value, &search74_2.value },
   NULL,
};

   /* replace110_0_0 -> search31_0 in the cache */

/* replace110_0_1 -> search61_2 in the cache */
static const nir_search_expression replace110_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search31_0.value, &search61_2.value },
   NULL,
};

/* replace110_1 -> search74_2 in the cache */
static const nir_search_expression replace110 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace110_0.value, &search74_2.value },
   NULL,
};

   /* search111_0 -> search3_0_0 in the cache */

/* search111_1 -> replace2_1_1 in the cache */

/* search111_2 -> search84_2 in the cache */
static const nir_search_expression search111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search3_0_0.value, &replace2_1_1.value, &search84_2.value },
   NULL,
};

   /* replace111_0_0 -> search3_0_0 in the cache */

/* replace111_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace111_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace111_1 -> search84_2 in the cache */
static const nir_search_expression replace111 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace111_0.value, &search84_2.value },
   NULL,
};

   /* search112_0 -> search93_0 in the cache */

/* search112_1 -> search93_1 in the cache */

/* search112_2 -> search94_2 in the cache */
static const nir_search_expression search112 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search93_0.value, &search93_1.value, &search94_2.value },
   NULL,
};

   /* replace112_0_0 -> search93_0 in the cache */

/* replace112_0_1 -> search93_1 in the cache */
static const nir_search_expression replace112_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace112_1 -> search94_2 in the cache */
static const nir_search_expression replace112 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace112_0.value, &search94_2.value },
   NULL,
};

   /* search113_0 -> search31_0 in the cache */

/* search113_1 -> search61_2 in the cache */

/* search113_2 -> search74_2 in the cache */
static const nir_search_expression search113 = {
   { nir_search_value_expression, 16 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search31_0.value, &search61_2.value, &search74_2.value },
   NULL,
};

   /* replace113_0_0 -> search31_0 in the cache */

/* replace113_0_1 -> search61_2 in the cache */
/* replace113_0 -> replace110_0 in the cache */

/* replace113_1 -> search74_2 in the cache */
/* replace113 -> replace110 in the cache */

   /* search114_0 -> search3_0_0 in the cache */

/* search114_1 -> replace2_1_1 in the cache */

/* search114_2 -> search84_2 in the cache */
static const nir_search_expression search114 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search3_0_0.value, &replace2_1_1.value, &search84_2.value },
   NULL,
};

   /* replace114_0_0 -> search3_0_0 in the cache */

/* replace114_0_1 -> replace2_1_1 in the cache */
/* replace114_0 -> replace111_0 in the cache */

/* replace114_1 -> search84_2 in the cache */
/* replace114 -> replace111 in the cache */

   /* search115_0 -> search93_0 in the cache */

/* search115_1 -> search93_1 in the cache */

/* search115_2 -> search94_2 in the cache */
static const nir_search_expression search115 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search93_0.value, &search93_1.value, &search94_2.value },
   NULL,
};

   /* replace115_0_0 -> search93_0 in the cache */

/* replace115_0_1 -> search93_1 in the cache */
/* replace115_0 -> replace112_0 in the cache */

/* replace115_1 -> search94_2 in the cache */
/* replace115 -> replace112 in the cache */

   static const nir_search_variable search116_0_0_0_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search116_0_0_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search116_0_0_0_0_0.value },
   NULL,
};
static const nir_search_expression search116_0_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search116_0_0_0_0.value },
   NULL,
};

static const nir_search_variable search116_0_0_1_0 = {
   { nir_search_value_variable, -5 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search116_0_0_1_1 = {
   { nir_search_value_variable, -5 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search116_0_0_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search116_0_0_1_0.value, &search116_0_0_1_1.value },
   NULL,
};
static const nir_search_expression search116_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   2, 2,
   nir_op_iand,
   { &search116_0_0_0.value, &search116_0_0_1.value },
   NULL,
};

static const nir_search_variable search116_0_1 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search116_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   1, 3,
   nir_op_fadd,
   { &search116_0_0.value, &search116_0_1.value },
   NULL,
};

static const nir_search_variable search116_1 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search116 = {
   { nir_search_value_expression, -5 },
   true, false,
   0, 4,
   nir_op_fmul,
   { &search116_0.value, &search116_1.value },
   NULL,
};

   static const nir_search_variable replace116_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* replace116_1_0_0_0 -> search116_0_0_1_0 in the cache */

/* replace116_1_0_0_1 -> search116_0_0_1_1 in the cache */
static const nir_search_expression replace116_1_0_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search116_0_0_1_0.value, &search116_0_0_1_1.value },
   NULL,
};

static const nir_search_variable replace116_1_0_1 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace116_1_0 = {
   { nir_search_value_expression, -5 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &replace116_1_0_0.value, &replace116_1_0_1.value },
   NULL,
};

static const nir_search_variable replace116_1_1 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression replace116_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   0, 3,
   nir_op_fmul,
   { &replace116_1_0.value, &replace116_1_1.value },
   NULL,
};

/* replace116_2_0 -> replace116_1_0_1 in the cache */

/* replace116_2_1 -> replace116_1_1 in the cache */
static const nir_search_expression replace116_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &replace116_1_0_1.value, &replace116_1_1.value },
   NULL,
};
static const nir_search_expression replace116 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace116_0.value, &replace116_1.value, &replace116_2.value },
   NULL,
};

   /* search117_0 -> search0_0 in the cache */

/* search117_1 -> replace0_1_0 in the cache */
static const nir_search_expression search117 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_variable replace117_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace117_0_1 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace117_0_2 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {2},
};

/* replace117_0_3 -> search66_0 in the cache */
static const nir_search_expression replace117_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace117_0_0.value, &replace117_0_1.value, &replace117_0_2.value, &search66_0.value },
   NULL,
};

/* replace117_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace117 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &replace117_0.value, &replace0_1_0.value },
   NULL,
};

   /* search118_0_0 -> search103_0_0 in the cache */

/* search118_0_1 -> search103_0_1 in the cache */

/* search118_0_2 -> search103_1_1 in the cache */

static const nir_search_constant search118_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search118_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search103_0_0.value, &search103_0_1.value, &search103_1_1.value, &search118_0_3.value },
   NULL,
};

/* search118_1 -> search103_2 in the cache */
static const nir_search_expression search118 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search118_0.value, &search103_2.value },
   NULL,
};

   /* replace118_0_0 -> search103_0_0 in the cache */

/* replace118_0_1 -> search103_0_1 in the cache */

/* replace118_0_2 -> search103_1_1 in the cache */
static const nir_search_expression replace118_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search103_0_0.value, &search103_0_1.value, &search103_1_1.value },
   NULL,
};

/* replace118_1 -> search103_2 in the cache */
static const nir_search_expression replace118 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &replace118_0.value, &search103_2.value },
   NULL,
};

   /* search119_0_0 -> search0_0 in the cache */

/* search119_0_1 -> search60_0 in the cache */

/* search119_0_2 -> search60_0 in the cache */

/* search119_0_3 -> search60_0 in the cache */
static const nir_search_expression search119_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search0_0.value, &search60_0.value, &search60_0.value, &search60_0.value },
   NULL,
};

/* search119_1 -> replace0_1_0 in the cache */
static const nir_search_expression search119 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search119_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace119_0 -> search0_0 in the cache */

/* replace119_1 -> replace0_1_0 in the cache */
/* replace119 -> replace63 in the cache */

   /* search120_0_0 -> search36_0_0 in the cache */

/* search120_0_1 -> search36_0_1 in the cache */

static const nir_search_constant search120_0_2 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search120_0_3 -> search120_0_2 in the cache */
static const nir_search_expression search120_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search36_0_0.value, &search36_0_1.value, &search120_0_2.value, &search120_0_2.value },
   NULL,
};

/* search120_1 -> search36_1_1 in the cache */
static const nir_search_expression search120 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search120_0.value, &search36_1_1.value },
   NULL,
};

   /* replace120_0_0 -> search36_0_0 in the cache */

/* replace120_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace120_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace120_1 -> search36_1_1 in the cache */
static const nir_search_expression replace120 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &replace120_0.value, &search36_1_1.value },
   NULL,
};

   /* search121_0_0 -> search103_0_0 in the cache */

/* search121_0_1 -> search103_0_1 in the cache */

/* search121_0_2 -> search103_1_1 in the cache */

static const nir_search_constant search121_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search121_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search103_0_0.value, &search103_0_1.value, &search103_1_1.value, &search121_0_3.value },
   NULL,
};

/* search121_1 -> search103_2 in the cache */
static const nir_search_expression search121 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search121_0.value, &search103_2.value },
   NULL,
};

   /* replace121_0_0 -> search103_0_0 in the cache */

/* replace121_0_1 -> search103_0_1 in the cache */

/* replace121_0_2 -> search103_1_1 in the cache */
/* replace121_0 -> replace118_0 in the cache */

/* replace121_1 -> search103_2 in the cache */
static const nir_search_expression replace121 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &replace118_0.value, &search103_2.value },
   NULL,
};

   /* search122_0_0 -> search0_0 in the cache */

/* search122_0_1 -> search60_0 in the cache */

/* search122_0_2 -> search60_0 in the cache */
static const nir_search_expression search122_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search0_0.value, &search60_0.value, &search60_0.value },
   NULL,
};

/* search122_1 -> replace0_1_0 in the cache */
static const nir_search_expression search122 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search122_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace122_0 -> search0_0 in the cache */

/* replace122_1 -> replace0_1_0 in the cache */
/* replace122 -> replace63 in the cache */

   /* search123_0_0 -> search36_0_0 in the cache */

/* search123_0_1 -> search36_0_1 in the cache */

/* search123_0_2 -> search120_0_2 in the cache */
static const nir_search_expression search123_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search36_0_0.value, &search36_0_1.value, &search120_0_2.value },
   NULL,
};

/* search123_1 -> search36_1_1 in the cache */
static const nir_search_expression search123 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search123_0.value, &search36_1_1.value },
   NULL,
};

   /* replace123_0_0 -> search36_0_0 in the cache */

/* replace123_0_1 -> search36_0_1 in the cache */
/* replace123_0 -> replace120_0 in the cache */

/* replace123_1 -> search36_1_1 in the cache */
/* replace123 -> replace120 in the cache */

   /* search124_0_0 -> search0_0 in the cache */

/* search124_0_1 -> search60_0 in the cache */
static const nir_search_expression search124_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search0_0.value, &search60_0.value },
   NULL,
};

/* search124_1 -> replace0_1_0 in the cache */
static const nir_search_expression search124 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search124_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace124_0 -> search0_0 in the cache */

/* replace124_1 -> replace0_1_0 in the cache */
/* replace124 -> replace63 in the cache */

   /* search125_0 -> search2_0 in the cache */

/* search125_1 -> search53_1 in the cache */
static const nir_search_expression search125 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   static const nir_search_variable replace125_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace125_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace125 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fadd,
   { &replace125_0.value, &replace125_1.value },
   NULL,
};

   /* search126_0 -> search0_0 in the cache */

/* search126_1 -> replace0_1_0 in the cache */
static const nir_search_expression search126 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace126_0_0 -> search0_0 in the cache */

/* replace126_0_1 -> replace0_1_0 in the cache */
/* replace126_0 -> replace63 in the cache */
static const nir_search_expression replace126 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum2,
   { &replace63.value },
   NULL,
};

   /* search127_0 -> search0_0 in the cache */

/* search127_1 -> replace0_1_0 in the cache */
static const nir_search_expression search127 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace127_0_0 -> search0_0 in the cache */

/* replace127_0_1 -> replace0_1_0 in the cache */
/* replace127_0 -> replace63 in the cache */
static const nir_search_expression replace127 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum3,
   { &replace63.value },
   NULL,
};

   /* search128_0 -> search0_0 in the cache */

/* search128_1 -> replace0_1_0 in the cache */
static const nir_search_expression search128 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace128_0_0 -> search0_0 in the cache */

/* replace128_0_1 -> replace0_1_0 in the cache */
/* replace128_0 -> replace63 in the cache */
static const nir_search_expression replace128 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum4,
   { &replace63.value },
   NULL,
};

   /* search129_0 -> search2_0 in the cache */
static const nir_search_expression search129 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsum2,
   { &search2_0.value },
   NULL,
};

   /* replace129_0 -> replace125_0 in the cache */

/* replace129_1 -> replace125_1 in the cache */
/* replace129 -> replace125 in the cache */

   static const nir_search_variable search130_0_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_fmul),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search130_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search130_0_0_0.value },
   (is_used_once),
};
static const nir_search_expression search130_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search130_0_0.value },
   (is_used_once),
};

/* search130_1 -> search53_1 in the cache */
static const nir_search_expression search130 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search130_0.value, &search53_1.value },
   NULL,
};

   /* replace130_0_0 -> search53_1 in the cache */

/* replace130_0_1_0 -> search2_0 in the cache */
/* replace130_0_1 -> search22_0 in the cache */
static const nir_search_expression replace130_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search53_1.value, &search22_0.value },
   NULL,
};
static const nir_search_expression replace130 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace130_0.value },
   NULL,
};

   /* search131_0_0_0 -> search36_0_0 in the cache */

static const nir_search_variable search131_0_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search131_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search36_0_0.value, &search131_0_0_1.value },
   NULL,
};

static const nir_search_variable search131_0_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search131_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search131_0_0.value, &search131_0_1.value },
   NULL,
};

static const nir_search_variable search131_1 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search131 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search131_0.value, &search131_1.value },
   NULL,
};

   /* replace131_0_0 -> search36_0_0 in the cache */

/* replace131_0_1_0 -> search36_0_1 in the cache */

/* replace131_0_1_1 -> search85_2 in the cache */
static const nir_search_expression replace131_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search36_0_1.value, &search85_2.value },
   NULL,
};
static const nir_search_expression replace131_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search36_0_0.value, &replace131_0_1.value },
   NULL,
};

/* replace131_1_0 -> search36_1_1 in the cache */

/* replace131_1_1 -> search85_2 in the cache */
static const nir_search_expression replace131_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search36_1_1.value, &search85_2.value },
   NULL,
};
static const nir_search_expression replace131 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace131_0.value, &replace131_1.value },
   NULL,
};

   /* search132_0_0 -> search0_0 in the cache */

static const nir_search_variable search132_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search132_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search132_0_1.value },
   NULL,
};

static const nir_search_variable search132_1 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search132 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search132_0.value, &search132_1.value },
   NULL,
};

   /* replace132_0 -> search0_0 in the cache */

/* replace132_1_0 -> replace0_1_0 in the cache */

/* replace132_1_1 -> search84_2 in the cache */
static const nir_search_expression replace132_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace0_1_0.value, &search84_2.value },
   NULL,
};
static const nir_search_expression replace132 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace132_1.value },
   NULL,
};

   static const nir_search_variable search133_0_0 = {
   { nir_search_value_variable, 8 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search133_0_1 -> search2_1 in the cache */
static const nir_search_expression search133_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search133_0_0.value, &search2_1.value },
   NULL,
};

/* search133_1 -> search132_1 in the cache */
static const nir_search_expression search133 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search133_0.value, &search132_1.value },
   NULL,
};

   /* replace133_0_0_0_0 -> replace2_1_1 in the cache */

static const nir_search_constant replace133_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression replace133_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace133_0_0_0_1.value },
   NULL,
};

/* replace133_0_0_1_0 -> search84_2 in the cache */

/* replace133_0_0_1_1 -> replace133_0_0_0_1 in the cache */
static const nir_search_expression replace133_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search84_2.value, &replace133_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace133_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace133_0_0_0.value, &replace133_0_0_1.value },
   NULL,
};

static const nir_search_constant replace133_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x8 /* 8 */ },
};
static const nir_search_expression replace133_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace133_0_0.value, &replace133_0_1.value },
   NULL,
};

/* replace133_1_0 -> search133_0_0 in the cache */

/* replace133_1_1_0 -> replace2_1_1 in the cache */

/* replace133_1_1_1 -> search84_2 in the cache */
static const nir_search_expression replace133_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &replace2_1_1.value, &search84_2.value },
   NULL,
};
static const nir_search_expression replace133_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search133_0_0.value, &replace133_1_1.value },
   NULL,
};

static const nir_search_constant replace133_2 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace133 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace133_0.value, &replace133_1.value, &replace133_2.value },
   NULL,
};

   /* search134_0_0 -> search133_0_0 in the cache */

/* search134_0_1 -> search2_1 in the cache */
static const nir_search_expression search134_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search133_0_0.value, &search2_1.value },
   NULL,
};

/* search134_1 -> search132_1 in the cache */
static const nir_search_expression search134 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search134_0.value, &search132_1.value },
   NULL,
};

   /* replace134_0_0_0_0 -> replace2_1_1 in the cache */

/* replace134_0_0_0_1 -> replace133_0_0_0_1 in the cache */
/* replace134_0_0_0 -> replace133_0_0_0 in the cache */

/* replace134_0_0_1_0 -> search84_2 in the cache */

/* replace134_0_0_1_1 -> replace133_0_0_0_1 in the cache */
/* replace134_0_0_1 -> replace133_0_0_1 in the cache */
/* replace134_0_0 -> replace133_0_0 in the cache */

/* replace134_0_1 -> replace133_0_1 in the cache */
/* replace134_0 -> replace133_0 in the cache */

/* replace134_1_0 -> search133_0_0 in the cache */

/* replace134_1_1_0 -> replace2_1_1 in the cache */

/* replace134_1_1_1 -> search84_2 in the cache */
/* replace134_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace134_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search133_0_0.value, &replace133_1_1.value },
   NULL,
};

/* replace134_2 -> replace133_2 in the cache */
static const nir_search_expression replace134 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace133_0.value, &replace134_1.value, &replace133_2.value },
   NULL,
};

   /* search135_0_0 -> search133_0_0 in the cache */

/* search135_0_1 -> search2_1 in the cache */
static const nir_search_expression search135_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search133_0_0.value, &search2_1.value },
   NULL,
};

/* search135_1 -> search132_1 in the cache */
static const nir_search_expression search135 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search135_0.value, &search132_1.value },
   NULL,
};

   /* replace135_0 -> search133_0_0 in the cache */

/* replace135_1_0_0_0 -> replace2_1_1 in the cache */

/* replace135_1_0_0_1 -> replace133_0_0_0_1 in the cache */
static const nir_search_expression replace135_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace133_0_0_0_1.value },
   NULL,
};

/* replace135_1_0_1_0 -> search84_2 in the cache */

/* replace135_1_0_1_1 -> replace133_0_0_0_1 in the cache */
static const nir_search_expression replace135_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search84_2.value, &replace133_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace135_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace135_1_0_0.value, &replace135_1_0_1.value },
   NULL,
};

static const nir_search_constant replace135_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace135_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace135_1_0.value, &replace135_1_1.value },
   NULL,
};
static const nir_search_expression replace135 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search133_0_0.value, &replace135_1.value },
   NULL,
};

   /* search136_0_0 -> search31_0 in the cache */

/* search136_0_1 -> search2_1 in the cache */
static const nir_search_expression search136_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search31_0.value, &search2_1.value },
   NULL,
};

/* search136_1 -> search132_1 in the cache */
static const nir_search_expression search136 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search136_0.value, &search132_1.value },
   NULL,
};

   /* replace136_0_0_0_0 -> replace2_1_1 in the cache */

static const nir_search_constant replace136_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff /* 65535 */ },
};
static const nir_search_expression replace136_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace136_0_0_0_1.value },
   NULL,
};

/* replace136_0_0_1_0 -> search84_2 in the cache */

/* replace136_0_0_1_1 -> replace136_0_0_0_1 in the cache */
static const nir_search_expression replace136_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search84_2.value, &replace136_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace136_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace136_0_0_0.value, &replace136_0_0_1.value },
   NULL,
};

static const nir_search_constant replace136_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x10 /* 16 */ },
};
static const nir_search_expression replace136_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace136_0_0.value, &replace136_0_1.value },
   NULL,
};

/* replace136_1_0 -> search31_0 in the cache */

/* replace136_1_1_0 -> replace2_1_1 in the cache */

/* replace136_1_1_1 -> search84_2 in the cache */
/* replace136_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace136_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search31_0.value, &replace133_1_1.value },
   NULL,
};

static const nir_search_constant replace136_2 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace136 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace136_0.value, &replace136_1.value, &replace136_2.value },
   NULL,
};

   /* search137_0_0 -> search31_0 in the cache */

/* search137_0_1 -> search2_1 in the cache */
static const nir_search_expression search137_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search31_0.value, &search2_1.value },
   NULL,
};

/* search137_1 -> search132_1 in the cache */
static const nir_search_expression search137 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search137_0.value, &search132_1.value },
   NULL,
};

   /* replace137_0_0_0_0 -> replace2_1_1 in the cache */

/* replace137_0_0_0_1 -> replace136_0_0_0_1 in the cache */
/* replace137_0_0_0 -> replace136_0_0_0 in the cache */

/* replace137_0_0_1_0 -> search84_2 in the cache */

/* replace137_0_0_1_1 -> replace136_0_0_0_1 in the cache */
/* replace137_0_0_1 -> replace136_0_0_1 in the cache */
/* replace137_0_0 -> replace136_0_0 in the cache */

/* replace137_0_1 -> replace136_0_1 in the cache */
/* replace137_0 -> replace136_0 in the cache */

/* replace137_1_0 -> search31_0 in the cache */

/* replace137_1_1_0 -> replace2_1_1 in the cache */

/* replace137_1_1_1 -> search84_2 in the cache */
/* replace137_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace137_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search31_0.value, &replace133_1_1.value },
   NULL,
};

/* replace137_2 -> replace136_2 in the cache */
static const nir_search_expression replace137 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace136_0.value, &replace137_1.value, &replace136_2.value },
   NULL,
};

   /* search138_0_0 -> search31_0 in the cache */

/* search138_0_1 -> search2_1 in the cache */
static const nir_search_expression search138_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search31_0.value, &search2_1.value },
   NULL,
};

/* search138_1 -> search132_1 in the cache */
static const nir_search_expression search138 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search138_0.value, &search132_1.value },
   NULL,
};

   /* replace138_0 -> search31_0 in the cache */

/* replace138_1_0_0_0 -> replace2_1_1 in the cache */

/* replace138_1_0_0_1 -> replace136_0_0_0_1 in the cache */
static const nir_search_expression replace138_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace136_0_0_0_1.value },
   NULL,
};

/* replace138_1_0_1_0 -> search84_2 in the cache */

/* replace138_1_0_1_1 -> replace136_0_0_0_1 in the cache */
static const nir_search_expression replace138_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search84_2.value, &replace136_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace138_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace138_1_0_0.value, &replace138_1_0_1.value },
   NULL,
};

static const nir_search_constant replace138_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xf /* 15 */ },
};
static const nir_search_expression replace138_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace138_1_0.value, &replace138_1_1.value },
   NULL,
};
static const nir_search_expression replace138 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search31_0.value, &replace138_1.value },
   NULL,
};

   /* search139_0_0 -> search3_0_0 in the cache */

/* search139_0_1 -> search2_1 in the cache */
static const nir_search_expression search139_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &search2_1.value },
   NULL,
};

/* search139_1 -> search132_1 in the cache */
static const nir_search_expression search139 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search139_0.value, &search132_1.value },
   NULL,
};

   /* replace139_0_0_0_0 -> replace2_1_1 in the cache */

static const nir_search_constant replace139_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression replace139_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace139_0_0_0_1.value },
   NULL,
};

/* replace139_0_0_1_0 -> search84_2 in the cache */

/* replace139_0_0_1_1 -> replace139_0_0_0_1 in the cache */
static const nir_search_expression replace139_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search84_2.value, &replace139_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace139_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace139_0_0_0.value, &replace139_0_0_1.value },
   NULL,
};

static const nir_search_constant replace139_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x20 /* 32 */ },
};
static const nir_search_expression replace139_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace139_0_0.value, &replace139_0_1.value },
   NULL,
};

/* replace139_1_0 -> search3_0_0 in the cache */

/* replace139_1_1_0 -> replace2_1_1 in the cache */

/* replace139_1_1_1 -> search84_2 in the cache */
/* replace139_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace139_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0_0.value, &replace133_1_1.value },
   NULL,
};

/* replace139_2 -> search34_1 in the cache */
static const nir_search_expression replace139 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace139_0.value, &replace139_1.value, &search34_1.value },
   NULL,
};

   /* search140_0_0 -> search3_0_0 in the cache */

/* search140_0_1 -> search2_1 in the cache */
static const nir_search_expression search140_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &search2_1.value },
   NULL,
};

/* search140_1 -> search132_1 in the cache */
static const nir_search_expression search140 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search140_0.value, &search132_1.value },
   NULL,
};

   /* replace140_0_0_0_0 -> replace2_1_1 in the cache */

/* replace140_0_0_0_1 -> replace139_0_0_0_1 in the cache */
/* replace140_0_0_0 -> replace139_0_0_0 in the cache */

/* replace140_0_0_1_0 -> search84_2 in the cache */

/* replace140_0_0_1_1 -> replace139_0_0_0_1 in the cache */
/* replace140_0_0_1 -> replace139_0_0_1 in the cache */
/* replace140_0_0 -> replace139_0_0 in the cache */

/* replace140_0_1 -> replace139_0_1 in the cache */
/* replace140_0 -> replace139_0 in the cache */

/* replace140_1_0 -> search3_0_0 in the cache */

/* replace140_1_1_0 -> replace2_1_1 in the cache */

/* replace140_1_1_1 -> search84_2 in the cache */
/* replace140_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace140_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0_0.value, &replace133_1_1.value },
   NULL,
};

/* replace140_2 -> search34_1 in the cache */
static const nir_search_expression replace140 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace139_0.value, &replace140_1.value, &search34_1.value },
   NULL,
};

   /* search141_0_0 -> search3_0_0 in the cache */

/* search141_0_1 -> search2_1 in the cache */
static const nir_search_expression search141_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &search2_1.value },
   NULL,
};

/* search141_1 -> search132_1 in the cache */
static const nir_search_expression search141 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search141_0.value, &search132_1.value },
   NULL,
};

   /* replace141_0 -> search3_0_0 in the cache */

/* replace141_1_0_0_0 -> replace2_1_1 in the cache */

/* replace141_1_0_0_1 -> replace139_0_0_0_1 in the cache */
static const nir_search_expression replace141_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace139_0_0_0_1.value },
   NULL,
};

/* replace141_1_0_1_0 -> search84_2 in the cache */

/* replace141_1_0_1_1 -> replace139_0_0_0_1 in the cache */
static const nir_search_expression replace141_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search84_2.value, &replace139_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace141_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace141_1_0_0.value, &replace141_1_0_1.value },
   NULL,
};

static const nir_search_constant replace141_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1f /* 31 */ },
};
static const nir_search_expression replace141_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace141_1_0.value, &replace141_1_1.value },
   NULL,
};
static const nir_search_expression replace141 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search3_0_0.value, &replace141_1.value },
   NULL,
};

   /* search142_0_0 -> search93_0 in the cache */

/* search142_0_1 -> search2_1 in the cache */
static const nir_search_expression search142_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &search2_1.value },
   NULL,
};

/* search142_1 -> search132_1 in the cache */
static const nir_search_expression search142 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search142_0.value, &search132_1.value },
   NULL,
};

   /* replace142_0_0_0_0 -> replace2_1_1 in the cache */

static const nir_search_constant replace142_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
};
static const nir_search_expression replace142_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace142_0_0_0_1.value },
   NULL,
};

/* replace142_0_0_1_0 -> search84_2 in the cache */

/* replace142_0_0_1_1 -> replace142_0_0_0_1 in the cache */
static const nir_search_expression replace142_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search84_2.value, &replace142_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace142_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace142_0_0_0.value, &replace142_0_0_1.value },
   NULL,
};

static const nir_search_constant replace142_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x40 /* 64 */ },
};
static const nir_search_expression replace142_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace142_0_0.value, &replace142_0_1.value },
   NULL,
};

/* replace142_1_0 -> search93_0 in the cache */

/* replace142_1_1_0 -> replace2_1_1 in the cache */

/* replace142_1_1_1 -> search84_2 in the cache */
/* replace142_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace142_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search93_0.value, &replace133_1_1.value },
   NULL,
};

static const nir_search_constant replace142_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace142 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace142_0.value, &replace142_1.value, &replace142_2.value },
   NULL,
};

   /* search143_0_0 -> search93_0 in the cache */

/* search143_0_1 -> search2_1 in the cache */
static const nir_search_expression search143_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &search2_1.value },
   NULL,
};

/* search143_1 -> search132_1 in the cache */
static const nir_search_expression search143 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search143_0.value, &search132_1.value },
   NULL,
};

   /* replace143_0_0_0_0 -> replace2_1_1 in the cache */

/* replace143_0_0_0_1 -> replace142_0_0_0_1 in the cache */
/* replace143_0_0_0 -> replace142_0_0_0 in the cache */

/* replace143_0_0_1_0 -> search84_2 in the cache */

/* replace143_0_0_1_1 -> replace142_0_0_0_1 in the cache */
/* replace143_0_0_1 -> replace142_0_0_1 in the cache */
/* replace143_0_0 -> replace142_0_0 in the cache */

/* replace143_0_1 -> replace142_0_1 in the cache */
/* replace143_0 -> replace142_0 in the cache */

/* replace143_1_0 -> search93_0 in the cache */

/* replace143_1_1_0 -> replace2_1_1 in the cache */

/* replace143_1_1_1 -> search84_2 in the cache */
/* replace143_1_1 -> replace133_1_1 in the cache */
static const nir_search_expression replace143_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search93_0.value, &replace133_1_1.value },
   NULL,
};

/* replace143_2 -> replace142_2 in the cache */
static const nir_search_expression replace143 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace142_0.value, &replace143_1.value, &replace142_2.value },
   NULL,
};

   /* search144_0_0 -> search93_0 in the cache */

/* search144_0_1 -> search2_1 in the cache */
static const nir_search_expression search144_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &search2_1.value },
   NULL,
};

/* search144_1 -> search132_1 in the cache */
static const nir_search_expression search144 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search144_0.value, &search132_1.value },
   NULL,
};

   /* replace144_0 -> search93_0 in the cache */

/* replace144_1_0_0_0 -> replace2_1_1 in the cache */

/* replace144_1_0_0_1 -> replace142_0_0_0_1 in the cache */
static const nir_search_expression replace144_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace2_1_1.value, &replace142_0_0_0_1.value },
   NULL,
};

/* replace144_1_0_1_0 -> search84_2 in the cache */

/* replace144_1_0_1_1 -> replace142_0_0_0_1 in the cache */
static const nir_search_expression replace144_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search84_2.value, &replace142_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace144_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace144_1_0_0.value, &replace144_1_0_1.value },
   NULL,
};

static const nir_search_constant replace144_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f /* 63 */ },
};
static const nir_search_expression replace144_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace144_1_0.value, &replace144_1_1.value },
   NULL,
};
static const nir_search_expression replace144 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search93_0.value, &replace144_1.value },
   NULL,
};

   /* search145_0_0 -> search133_0_0 in the cache */

/* search145_0_1 -> search2_1 in the cache */
/* search145_0 -> search134_0 in the cache */

/* search145_1 -> replace2_1_1 in the cache */
static const nir_search_expression search145 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search134_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace145_0 -> search133_0_0 in the cache */

static const nir_search_constant replace145_1_0 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace145_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace145_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace145_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace145 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search133_0_0.value, &replace145_1.value },
   NULL,
};

   /* search146_0_0 -> search133_0_0 in the cache */

/* search146_0_1 -> search2_1 in the cache */
/* search146_0 -> search135_0 in the cache */

/* search146_1 -> replace2_1_1 in the cache */
static const nir_search_expression search146 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search135_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace146_0 -> search133_0_0 in the cache */

/* replace146_1_0 -> replace145_1_0 in the cache */

/* replace146_1_1 -> replace2_1_1 in the cache */
/* replace146_1 -> replace145_1 in the cache */
/* replace146 -> replace145 in the cache */

   /* search147_0_0 -> search133_0_0 in the cache */

/* search147_0_1 -> search2_1 in the cache */
/* search147_0 -> search133_0 in the cache */

/* search147_1 -> replace2_1_1 in the cache */
static const nir_search_expression search147 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search133_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace147_0 -> search133_0_0 in the cache */

/* replace147_1_0 -> replace145_1_0 in the cache */

/* replace147_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace147_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace145_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace147 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search133_0_0.value, &replace147_1.value },
   NULL,
};

   /* search148_0_0 -> search31_0 in the cache */

/* search148_0_1 -> search2_1 in the cache */
/* search148_0 -> search137_0 in the cache */

/* search148_1 -> replace2_1_1 in the cache */
static const nir_search_expression search148 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search137_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace148_0 -> search31_0 in the cache */

static const nir_search_constant replace148_1_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* replace148_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace148_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace148_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace148 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search31_0.value, &replace148_1.value },
   NULL,
};

   /* search149_0_0 -> search31_0 in the cache */

/* search149_0_1 -> search2_1 in the cache */
/* search149_0 -> search138_0 in the cache */

/* search149_1 -> replace2_1_1 in the cache */
static const nir_search_expression search149 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search138_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace149_0 -> search31_0 in the cache */

/* replace149_1_0 -> replace148_1_0 in the cache */

/* replace149_1_1 -> replace2_1_1 in the cache */
/* replace149_1 -> replace148_1 in the cache */
/* replace149 -> replace148 in the cache */

   /* search150_0_0 -> search31_0 in the cache */

/* search150_0_1 -> search2_1 in the cache */
/* search150_0 -> search136_0 in the cache */

/* search150_1 -> replace2_1_1 in the cache */
static const nir_search_expression search150 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search136_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace150_0 -> search31_0 in the cache */

/* replace150_1_0 -> replace148_1_0 in the cache */

/* replace150_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace150_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace148_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace150 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search31_0.value, &replace150_1.value },
   NULL,
};

   /* search151_0_0 -> search3_0_0 in the cache */

/* search151_0_1 -> search2_1 in the cache */
/* search151_0 -> search140_0 in the cache */

/* search151_1 -> replace2_1_1 in the cache */
static const nir_search_expression search151 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search140_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace151_0 -> search3_0_0 in the cache */

/* replace151_1_0 -> replace139_0_0_0_1 in the cache */

/* replace151_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace151_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace139_0_0_0_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace151 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &replace151_1.value },
   NULL,
};

   /* search152_0_0 -> search3_0_0 in the cache */

/* search152_0_1 -> search2_1 in the cache */
/* search152_0 -> search141_0 in the cache */

/* search152_1 -> replace2_1_1 in the cache */
static const nir_search_expression search152 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search141_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace152_0 -> search3_0_0 in the cache */

/* replace152_1_0 -> replace139_0_0_0_1 in the cache */

/* replace152_1_1 -> replace2_1_1 in the cache */
/* replace152_1 -> replace151_1 in the cache */
/* replace152 -> replace151 in the cache */

   /* search153_0_0 -> search3_0_0 in the cache */

/* search153_0_1 -> search2_1 in the cache */
/* search153_0 -> search139_0 in the cache */

/* search153_1 -> replace2_1_1 in the cache */
static const nir_search_expression search153 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search139_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace153_0 -> search3_0_0 in the cache */

/* replace153_1_0 -> replace139_0_0_0_1 in the cache */

/* replace153_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace153_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace139_0_0_0_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace153 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &replace153_1.value },
   NULL,
};

   /* search154_0_0 -> search93_0 in the cache */

/* search154_0_1 -> search2_1 in the cache */
/* search154_0 -> search143_0 in the cache */

/* search154_1 -> replace2_1_1 in the cache */
static const nir_search_expression search154 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search143_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace154_0 -> search93_0 in the cache */

static const nir_search_constant replace154_1_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
};

/* replace154_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace154_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace154_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace154 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search93_0.value, &replace154_1.value },
   NULL,
};

   /* search155_0_0 -> search93_0 in the cache */

/* search155_0_1 -> search2_1 in the cache */
/* search155_0 -> search144_0 in the cache */

/* search155_1 -> replace2_1_1 in the cache */
static const nir_search_expression search155 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search144_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace155_0 -> search93_0 in the cache */

/* replace155_1_0 -> replace154_1_0 in the cache */

/* replace155_1_1 -> replace2_1_1 in the cache */
/* replace155_1 -> replace154_1 in the cache */
/* replace155 -> replace154 in the cache */

   /* search156_0_0 -> search93_0 in the cache */

/* search156_0_1 -> search2_1 in the cache */
/* search156_0 -> search142_0 in the cache */

/* search156_1 -> replace2_1_1 in the cache */
static const nir_search_expression search156 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search142_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace156_0 -> search93_0 in the cache */

/* replace156_1_0 -> replace154_1_0 in the cache */

/* replace156_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace156_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace154_1_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace156 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search93_0.value, &replace156_1.value },
   NULL,
};

   /* search157_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search157_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_2),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search157_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search157_0_1.value },
   NULL,
};

static const nir_search_constant search157_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffe /* 4294967294 */ },
};
static const nir_search_expression search157 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search157_0.value, &search157_1.value },
   NULL,
};

   /* replace157_0_0 -> search3_0_0 in the cache */

/* replace157_0_1 -> search157_1 in the cache */
static const nir_search_expression replace157_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search157_1.value },
   NULL,
};

/* replace157_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace157 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace157_0.value, &replace2_1_1.value },
   NULL,
};

   /* search158_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search158_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_4),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search158_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search158_0_1.value },
   NULL,
};

static const nir_search_constant search158_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffffc /* 4294967292 */ },
};
static const nir_search_expression search158 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search158_0.value, &search158_1.value },
   NULL,
};

   /* replace158_0_0 -> search3_0_0 in the cache */

/* replace158_0_1 -> search158_1 in the cache */
static const nir_search_expression replace158_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search158_1.value },
   NULL,
};

/* replace158_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace158 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace158_0.value, &replace2_1_1.value },
   NULL,
};

   /* search159_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search159_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_8),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search159_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search159_0_1.value },
   NULL,
};

static const nir_search_constant search159_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff8 /* 4294967288 */ },
};
static const nir_search_expression search159 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search159_0.value, &search159_1.value },
   NULL,
};

   /* replace159_0_0 -> search3_0_0 in the cache */

/* replace159_0_1 -> search159_1 in the cache */
static const nir_search_expression replace159_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search159_1.value },
   NULL,
};

/* replace159_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace159 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace159_0.value, &replace2_1_1.value },
   NULL,
};

   /* search160_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search160_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_16),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search160_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search160_0_1.value },
   NULL,
};

static const nir_search_constant search160_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xfffffff0 /* 4294967280 */ },
};
static const nir_search_expression search160 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search160_0.value, &search160_1.value },
   NULL,
};

   /* replace160_0_0 -> search3_0_0 in the cache */

/* replace160_0_1 -> search160_1 in the cache */
static const nir_search_expression replace160_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search160_1.value },
   NULL,
};

/* replace160_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace160 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace160_0.value, &replace2_1_1.value },
   NULL,
};

   /* search161_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search161_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_32),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search161_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search161_0_1.value },
   NULL,
};

static const nir_search_constant search161_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffe0 /* 4294967264 */ },
};
static const nir_search_expression search161 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search161_0.value, &search161_1.value },
   NULL,
};

   /* replace161_0_0 -> search3_0_0 in the cache */

/* replace161_0_1 -> search161_1 in the cache */
static const nir_search_expression replace161_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search161_1.value },
   NULL,
};

/* replace161_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace161 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace161_0.value, &replace2_1_1.value },
   NULL,
};

   /* search162_0_0 -> search3_0_0 in the cache */

static const nir_search_variable search162_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_unsigned_multiple_of_64),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search162_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search3_0_0.value, &search162_0_1.value },
   NULL,
};

static const nir_search_constant search162_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffc0 /* 4294967232 */ },
};
static const nir_search_expression search162 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search162_0.value, &search162_1.value },
   NULL,
};

   /* replace162_0_0 -> search3_0_0 in the cache */

/* replace162_0_1 -> search162_1 in the cache */
static const nir_search_expression replace162_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search162_1.value },
   NULL,
};

/* replace162_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace162 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace162_0.value, &replace2_1_1.value },
   NULL,
};

   /* search163_0_0 -> search3_0_0 in the cache */

static const nir_search_constant search163_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};
static const nir_search_expression search163_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &search163_0_1.value },
   NULL,
};

static const nir_search_constant search163_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search163 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search163_0.value, &search163_1.value },
   NULL,
};

   /* replace163_0 -> search3_0_0 in the cache */

/* replace163_1 -> search163_1 in the cache */
static const nir_search_expression replace163 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

   /* search164_0_0 -> search3_0_0 in the cache */

/* search164_0_1 -> search163_1 in the cache */
/* search164_0 -> replace163 in the cache */

/* search164_1 -> search157_1 in the cache */
static const nir_search_expression search164 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace163.value, &search157_1.value },
   NULL,
};

   /* replace164_0 -> search3_0_0 in the cache */

/* replace164_1 -> search163_1 in the cache */
/* replace164 -> replace163 in the cache */

   /* search165_0_0 -> search3_0_0 in the cache */

/* search165_0_1 -> search163_1 in the cache */
static const nir_search_expression search165_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

/* search165_1 -> search163_0_1 in the cache */
static const nir_search_expression search165 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search165_0.value, &search163_0_1.value },
   NULL,
};

   /* replace165_0 -> search3_0_0 in the cache */

/* replace165_1 -> search163_1 in the cache */
/* replace165 -> search165_0 in the cache */

   /* search166_0_0 -> search3_0_0 in the cache */

static const nir_search_constant search166_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3fffffff /* 1073741823 */ },
};
static const nir_search_expression search166_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &search166_0_1.value },
   NULL,
};

static const nir_search_constant search166_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search166 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search166_0.value, &search166_1.value },
   NULL,
};

   /* replace166_0 -> search3_0_0 in the cache */

/* replace166_1 -> search166_1 in the cache */
static const nir_search_expression replace166 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &search166_1.value },
   NULL,
};

   /* search167_0_0 -> search3_0_0 in the cache */

/* search167_0_1 -> search166_1 in the cache */
/* search167_0 -> replace166 in the cache */

/* search167_1 -> search158_1 in the cache */
static const nir_search_expression search167 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace166.value, &search158_1.value },
   NULL,
};

   /* replace167_0 -> search3_0_0 in the cache */

/* replace167_1 -> search166_1 in the cache */
/* replace167 -> replace166 in the cache */

   /* search168_0_0 -> search3_0_0 in the cache */

/* search168_0_1 -> search166_1 in the cache */
static const nir_search_expression search168_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &search166_1.value },
   NULL,
};

/* search168_1 -> search166_0_1 in the cache */
static const nir_search_expression search168 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search168_0.value, &search166_0_1.value },
   NULL,
};

   /* replace168_0 -> search3_0_0 in the cache */

/* replace168_1 -> search166_1 in the cache */
/* replace168 -> search168_0 in the cache */

   /* search169_0_0 -> search3_0_0 in the cache */

/* search169_0_1 -> replace136_0_0_0_1 in the cache */
static const nir_search_expression search169_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &replace136_0_0_0_1.value },
   NULL,
};

/* search169_1 -> replace136_0_1 in the cache */
static const nir_search_expression search169 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search169_0.value, &replace136_0_1.value },
   NULL,
};

   /* replace169_0 -> search3_0_0 in the cache */

/* replace169_1 -> replace136_0_1 in the cache */
static const nir_search_expression replace169 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &replace136_0_1.value },
   NULL,
};

   /* search170_0_0 -> search3_0_0 in the cache */

/* search170_0_1 -> replace136_0_1 in the cache */
/* search170_0 -> replace169 in the cache */

static const nir_search_constant search170_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff0000 /* 4294901760 */ },
};
static const nir_search_expression search170 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace169.value, &search170_1.value },
   NULL,
};

   /* replace170_0 -> search3_0_0 in the cache */

/* replace170_1 -> replace136_0_1 in the cache */
/* replace170 -> replace169 in the cache */

   /* search171_0_0 -> search3_0_0 in the cache */

/* search171_0_1 -> replace136_0_1 in the cache */
static const nir_search_expression search171_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &replace136_0_1.value },
   NULL,
};

/* search171_1 -> replace136_0_0_0_1 in the cache */
static const nir_search_expression search171 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search171_0.value, &replace136_0_0_0_1.value },
   NULL,
};

   /* replace171_0 -> search3_0_0 in the cache */

/* replace171_1 -> replace136_0_1 in the cache */
/* replace171 -> search171_0 in the cache */

   /* search172_0_0 -> search3_0_0 in the cache */

/* search172_0_1 -> replace133_0_0_0_1 in the cache */
static const nir_search_expression search172_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &replace133_0_0_0_1.value },
   NULL,
};

static const nir_search_constant search172_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x18 /* 24 */ },
};
static const nir_search_expression search172 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search172_0.value, &search172_1.value },
   NULL,
};

   /* replace172_0 -> search3_0_0 in the cache */

/* replace172_1 -> search172_1 in the cache */
static const nir_search_expression replace172 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &search172_1.value },
   NULL,
};

   /* search173_0_0 -> search3_0_0 in the cache */

/* search173_0_1 -> search172_1 in the cache */
/* search173_0 -> replace172 in the cache */

static const nir_search_constant search173_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff000000 /* 4278190080 */ },
};
static const nir_search_expression search173 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace172.value, &search173_1.value },
   NULL,
};

   /* replace173_0 -> search3_0_0 in the cache */

/* replace173_1 -> search172_1 in the cache */
/* replace173 -> replace172 in the cache */

   /* search174_0_0 -> search3_0_0 in the cache */

/* search174_0_1 -> search172_1 in the cache */
static const nir_search_expression search174_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &search172_1.value },
   NULL,
};

/* search174_1 -> replace133_0_0_0_1 in the cache */
static const nir_search_expression search174 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search174_0.value, &replace133_0_0_0_1.value },
   NULL,
};

   /* replace174_0 -> search3_0_0 in the cache */

/* replace174_1 -> search172_1 in the cache */
/* replace174 -> search174_0 in the cache */

   /* search175_0_0 -> search0_0 in the cache */

/* search175_0_1 -> search132_0_1 in the cache */
static const nir_search_expression search175_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &search132_0_1.value },
   NULL,
};

/* search175_1 -> search132_1 in the cache */
static const nir_search_expression search175 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search175_0.value, &search132_1.value },
   NULL,
};

   /* replace175_0_0 -> search0_0 in the cache */

/* replace175_0_1 -> search84_2 in the cache */
static const nir_search_expression replace175_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search84_2.value },
   NULL,
};

/* replace175_1_0 -> replace0_1_0 in the cache */

/* replace175_1_1 -> search84_2 in the cache */
/* replace175_1 -> replace132_1 in the cache */
static const nir_search_expression replace175 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace175_0.value, &replace132_1.value },
   NULL,
};

   /* search176_0_0 -> search36_0_0 in the cache */

/* search176_0_1 -> search131_0_0_1 in the cache */
static const nir_search_expression search176_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search36_0_0.value, &search131_0_0_1.value },
   (is_used_once),
};

/* search176_1 -> search131_0_1 in the cache */
static const nir_search_expression search176 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search176_0.value, &search131_0_1.value },
   NULL,
};

   /* replace176_0_0 -> search36_0_0 in the cache */

/* replace176_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace176_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace176_1_0 -> search36_0_1 in the cache */

/* replace176_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace176_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace176 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace176_0.value, &replace176_1.value },
   NULL,
};

   /* search177_0_0_0 -> search103_0_0 in the cache */

static const nir_search_variable search177_0_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search177_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search103_0_0.value, &search177_0_0_1.value },
   (is_used_once),
};

/* search177_0_1 -> search103_1_1 in the cache */
static const nir_search_expression search177_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 2,
   nir_op_iadd,
   { &search177_0_0.value, &search103_1_1.value },
   (is_used_once),
};

static const nir_search_variable search177_1 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search177 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_imul,
   { &search177_0.value, &search177_1.value },
   NULL,
};

   /* replace177_0_0_0 -> search103_0_0 in the cache */

/* replace177_0_0_1 -> search103_1_1 in the cache */
static const nir_search_expression replace177_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search103_0_0.value, &search103_1_1.value },
   NULL,
};

/* replace177_0_1 -> search103_2 in the cache */
static const nir_search_expression replace177_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 2,
   nir_op_imul,
   { &replace177_0_0.value, &search103_2.value },
   NULL,
};

/* replace177_1_0 -> search103_0_1 in the cache */

/* replace177_1_1 -> search103_2 in the cache */
static const nir_search_expression replace177_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   3, 1,
   nir_op_imul,
   { &search103_0_1.value, &search103_2.value },
   NULL,
};
static const nir_search_expression replace177 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 4,
   nir_op_iadd,
   { &replace177_0.value, &replace177_1.value },
   NULL,
};

   /* search178_0_0_0 -> search36_0_0 in the cache */

/* search178_0_0_1 -> search131_0_0_1 in the cache */
/* search178_0_0 -> search176_0 in the cache */

/* search178_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search178_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search176_0.value, &search36_1_1.value },
   (is_used_once),
};

/* search178_1 -> search131_1 in the cache */
static const nir_search_expression search178 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search178_0.value, &search131_1.value },
   NULL,
};

   /* replace178_0_0_0 -> search36_0_0 in the cache */

/* replace178_0_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace178_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace178_0_1 -> search85_2 in the cache */
static const nir_search_expression replace178_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &replace178_0_0.value, &search85_2.value },
   NULL,
};

/* replace178_1_0 -> search36_0_1 in the cache */

/* replace178_1_1 -> search85_2 in the cache */
/* replace178_1 -> replace131_0_1 in the cache */
static const nir_search_expression replace178 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace178_0.value, &replace131_0_1.value },
   NULL,
};

   static const nir_search_variable search179_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search179_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search179_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search179_0_0.value, &search179_0_1.value },
   (is_used_once),
};
static const nir_search_expression search179 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search179_0.value },
   NULL,
};

   /* replace179_0 -> search0_0 in the cache */

/* replace179_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace179 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search180_0_0 -> search179_0_0 in the cache */

/* search180_0_1 -> search179_0_1 in the cache */
static const nir_search_expression search180_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search179_0_0.value, &search179_0_1.value },
   (is_used_once),
};
static const nir_search_expression search180 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search180_0.value },
   NULL,
};

   /* replace180_0 -> search0_0 in the cache */

/* replace180_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace180 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search181_0_0 -> search0_0 in the cache */

/* search181_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search181_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search181 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search181_0.value },
   NULL,
};

   /* replace181_0 -> search0_0 in the cache */

/* replace181_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace181 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search182_0_0 -> search0_0 in the cache */

/* search182_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search182_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search182 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search182_0.value },
   NULL,
};

   /* replace182_0 -> search0_0 in the cache */

/* replace182_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace182 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search183_0_0 -> search0_0 in the cache */

/* search183_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search183_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search183 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search183_0.value },
   NULL,
};

   /* replace183_0 -> search0_0 in the cache */

/* replace183_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace183 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search184_0_0 -> search0_0 in the cache */

/* search184_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search184_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search184 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search184_0.value },
   NULL,
};

   /* replace184_0 -> search0_0 in the cache */

/* replace184_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace184 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search185_0_0 -> search0_0 in the cache */

/* search185_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search185_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search185 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search185_0.value },
   NULL,
};

   /* replace185_0 -> search0_0 in the cache */

/* replace185_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace185 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search186_0_0 -> search0_0 in the cache */

/* search186_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search186_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search186 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search186_0.value },
   NULL,
};

   /* replace186_0 -> search0_0 in the cache */

/* replace186_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace186 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search187_0_0 -> search0_0 in the cache */

/* search187_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search187_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search187 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search187_0.value },
   NULL,
};

   /* replace187_0 -> search0_0 in the cache */

/* replace187_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace187 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search188_0_0 -> search0_0 in the cache */

/* search188_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search188_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search188 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search188_0.value },
   NULL,
};

   /* replace188_0 -> search0_0 in the cache */

/* replace188_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace188 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search189_0_0 -> search0_0 in the cache */

/* search189_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search189_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search189_1_0 -> search0_0 in the cache */

/* search189_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search189_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search189 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search189_0.value, &search189_1.value },
   NULL,
};

   static const nir_search_constant replace189 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_FALSE /* False */ },
};

   /* search190_0_0 -> search0_0 in the cache */

/* search190_0_1 -> replace0_1_0 in the cache */
/* search190_0 -> replace180 in the cache */

/* search190_1_0 -> replace0_1_0 in the cache */

/* search190_1_1 -> search0_0 in the cache */
static const nir_search_expression search190_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search190 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace180.value, &search190_1.value },
   NULL,
};

   /* replace190 -> replace189 in the cache */

   /* search191_0_0 -> search0_0 in the cache */

/* search191_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search191_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search191_1_0 -> search0_0 in the cache */

/* search191_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search191_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search191 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search191_0.value, &search191_1.value },
   NULL,
};

   /* replace191 -> replace189 in the cache */

   /* search192_0_0 -> search0_0 in the cache */

/* search192_0_1 -> replace0_1_0 in the cache */
/* search192_0 -> replace185 in the cache */

/* search192_1_0 -> replace0_1_0 in the cache */

/* search192_1_1 -> search0_0 in the cache */
static const nir_search_expression search192_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search192 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace185.value, &search192_1.value },
   NULL,
};

   /* replace192 -> replace189 in the cache */

   /* search193_0_0 -> search0_0 in the cache */

/* search193_0_1 -> replace0_1_0 in the cache */
/* search193_0 -> replace186 in the cache */

/* search193_1_0 -> replace0_1_0 in the cache */

/* search193_1_1 -> search0_0 in the cache */
static const nir_search_expression search193_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression search193 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace186.value, &search193_1.value },
   NULL,
};

   /* replace193 -> replace189 in the cache */

   /* search194_0_0 -> search0_0 in the cache */
/* search194_0 -> search44_0 in the cache */

/* search194_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search194_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search194 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search44_0.value, &search194_1.value },
   NULL,
};

   /* replace194_0 -> replace0_1_0 in the cache */

/* replace194_1 -> search0_0 in the cache */
/* replace194 -> search190_1 in the cache */

   /* search195_0_0 -> search0_0 in the cache */
/* search195_0 -> search44_0 in the cache */

/* search195_1_0 -> replace0_1_0 in the cache */
/* search195_1 -> search194_1 in the cache */
static const nir_search_expression search195 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search44_0.value, &search194_1.value },
   NULL,
};

   /* replace195_0 -> replace0_1_0 in the cache */

/* replace195_1 -> search0_0 in the cache */
static const nir_search_expression replace195 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search196_0_0 -> search0_0 in the cache */
/* search196_0 -> search44_0 in the cache */

/* search196_1_0 -> replace0_1_0 in the cache */
/* search196_1 -> search194_1 in the cache */
static const nir_search_expression search196 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search44_0.value, &search194_1.value },
   NULL,
};

   /* replace196_0 -> replace0_1_0 in the cache */

/* replace196_1 -> search0_0 in the cache */
static const nir_search_expression replace196 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search197_0_0 -> search0_0 in the cache */
/* search197_0 -> search44_0 in the cache */

/* search197_1_0 -> replace0_1_0 in the cache */
/* search197_1 -> search194_1 in the cache */
static const nir_search_expression search197 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search44_0.value, &search194_1.value },
   NULL,
};

   /* replace197_0 -> replace0_1_0 in the cache */

/* replace197_1 -> search0_0 in the cache */
static const nir_search_expression replace197 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search198_0_0 -> search2_0 in the cache */
/* search198_0 -> search22_0 in the cache */

/* search198_1 -> search56_1 in the cache */
static const nir_search_expression search198 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search22_0.value, &search56_1.value },
   NULL,
};

   /* replace198_0 -> search53_1 in the cache */

/* replace198_1 -> search2_0 in the cache */
static const nir_search_expression replace198 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search53_1.value, &search2_0.value },
   NULL,
};

   /* search199_0 -> search56_1 in the cache */

/* search199_1_0 -> search2_0 in the cache */
/* search199_1 -> search22_0 in the cache */
static const nir_search_expression search199 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search56_1.value, &search22_0.value },
   NULL,
};

   /* replace199_0 -> search2_0 in the cache */

/* replace199_1 -> search53_1 in the cache */
static const nir_search_expression replace199 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   /* search200_0_0 -> search2_0 in the cache */
/* search200_0 -> search22_0 in the cache */

/* search200_1 -> search56_1 in the cache */
static const nir_search_expression search200 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search22_0.value, &search56_1.value },
   NULL,
};

   /* replace200_0 -> search53_1 in the cache */

/* replace200_1 -> search2_0 in the cache */
static const nir_search_expression replace200 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search53_1.value, &search2_0.value },
   NULL,
};

   /* search201_0 -> search56_1 in the cache */

/* search201_1_0 -> search2_0 in the cache */
/* search201_1 -> search22_0 in the cache */
static const nir_search_expression search201 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search56_1.value, &search22_0.value },
   NULL,
};

   /* replace201_0 -> search2_0 in the cache */

/* replace201_1 -> search53_1 in the cache */
static const nir_search_expression replace201 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   /* search202_0_0 -> search2_0 in the cache */
/* search202_0 -> search22_0 in the cache */

/* search202_1 -> search56_1 in the cache */
static const nir_search_expression search202 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search22_0.value, &search56_1.value },
   NULL,
};

   /* replace202_0 -> search53_1 in the cache */

/* replace202_1 -> search2_0 in the cache */
static const nir_search_expression replace202 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search53_1.value, &search2_0.value },
   NULL,
};

   /* search203_0 -> search56_1 in the cache */

/* search203_1_0 -> search2_0 in the cache */
/* search203_1 -> search22_0 in the cache */
static const nir_search_expression search203 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search56_1.value, &search22_0.value },
   NULL,
};

   /* replace203_0 -> search2_0 in the cache */

/* replace203_1 -> search53_1 in the cache */
static const nir_search_expression replace203 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   static const nir_search_variable search204_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search204_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search204_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search204_1_0.value },
   (is_used_once),
};
static const nir_search_expression search204 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search204_0.value, &search204_1.value },
   NULL,
};

   static const nir_search_variable replace204_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* replace204_1 -> search204_1_0 in the cache */
static const nir_search_expression replace204 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace204_0.value, &search204_1_0.value },
   NULL,
};

   /* search205_0_0 -> search0_0 in the cache */
static const nir_search_expression search205_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   (is_used_once),
};

static const nir_search_variable search205_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search205 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search205_0.value, &search205_1.value },
   NULL,
};

   /* replace205_0 -> search0_0 in the cache */

/* replace205_1 -> replace0_1_0 in the cache */
/* replace205 -> replace179 in the cache */

   /* search206_0_0 -> search0_0 in the cache */
/* search206_0 -> search205_0 in the cache */

/* search206_1 -> search205_1 in the cache */
static const nir_search_expression search206 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search205_0.value, &search205_1.value },
   NULL,
};

   /* replace206_0 -> search0_0 in the cache */

/* replace206_1 -> replace0_1_0 in the cache */
/* replace206 -> replace182 in the cache */

   /* search207_0_0 -> search0_0 in the cache */
/* search207_0 -> search205_0 in the cache */

/* search207_1 -> search205_1 in the cache */
static const nir_search_expression search207 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search205_0.value, &search205_1.value },
   NULL,
};

   /* replace207_0 -> search0_0 in the cache */

/* replace207_1 -> replace0_1_0 in the cache */
/* replace207 -> replace181 in the cache */

   /* search208_0_0 -> search2_0 in the cache */
static const nir_search_expression search208_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   (is_used_once),
};

/* search208_1 -> search53_1 in the cache */
static const nir_search_expression search208 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search208_0.value, &search53_1.value },
   NULL,
};

   /* replace208_0 -> search2_0 in the cache */

/* replace208_1 -> search53_1 in the cache */
/* replace208 -> replace201 in the cache */

   /* search209_0 -> search30_1 in the cache */

/* search209_1_0 -> search2_0 in the cache */
/* search209_1 -> search208_0 in the cache */
static const nir_search_expression search209 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search30_1.value, &search208_0.value },
   NULL,
};

   /* replace209_0 -> search30_1 in the cache */

/* replace209_1 -> search2_0 in the cache */
static const nir_search_expression replace209 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search30_1.value, &search2_0.value },
   NULL,
};

   static const nir_search_constant search210_0 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search210_1_0 -> replace116_0 in the cache */
static const nir_search_expression search210_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   NULL,
};
static const nir_search_expression search210 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search210_0.value, &search210_1.value },
   NULL,
};

   /* replace210_0 -> replace116_0 in the cache */
static const nir_search_expression replace210 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace116_0.value },
   NULL,
};

   /* search211_0_0_0 -> replace116_0 in the cache */
/* search211_0_0 -> search210_1 in the cache */
static const nir_search_expression search211_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search210_1.value },
   NULL,
};

/* search211_1 -> search210_0 in the cache */
static const nir_search_expression search211 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search211_0.value, &search210_0.value },
   NULL,
};

   /* replace211_0 -> replace116_0 in the cache */
/* replace211 -> replace210 in the cache */

   /* search212_0_0_0 -> replace116_0 in the cache */
/* search212_0_0 -> search210_1 in the cache */

static const nir_search_variable search212_0_1_0 = {
   { nir_search_value_variable, 1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search212_0_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search212_0_1_0.value },
   NULL,
};
static const nir_search_expression search212_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};

/* search212_1 -> search210_0 in the cache */
static const nir_search_expression search212 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search212_0.value, &search210_0.value },
   NULL,
};

   /* replace212_0 -> replace116_0 in the cache */

/* replace212_1 -> search212_0_1_0 in the cache */
static const nir_search_expression replace212 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* search213_0_0 -> replace116_0 in the cache */

static const nir_search_constant search213_0_1 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search213_0_2_0 -> search212_0_1_0 in the cache */
/* search213_0_2 -> search212_0_1 in the cache */
static const nir_search_expression search213_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search213_0_1.value, &search212_0_1.value },
   NULL,
};

/* search213_1 -> search210_0 in the cache */
static const nir_search_expression search213 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search213_0.value, &search210_0.value },
   NULL,
};

   /* replace213_0 -> replace116_0 in the cache */

/* replace213_1 -> search212_0_1_0 in the cache */
/* replace213 -> replace212 in the cache */

   /* search214_0_0 -> replace116_0 in the cache */
/* search214_0 -> search210_1 in the cache */

/* search214_1_0_0 -> search212_0_1_0 in the cache */
/* search214_1_0 -> search212_0_1 in the cache */
static const nir_search_expression search214_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search212_0_1.value },
   NULL,
};
static const nir_search_expression search214 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search210_1.value, &search214_1.value },
   NULL,
};

   /* replace214_0 -> replace116_0 in the cache */

/* replace214_1 -> search212_0_1_0 in the cache */
/* replace214 -> replace212 in the cache */

   /* search215_0_0_0 -> replace116_0 in the cache */
/* search215_0_0 -> search210_1 in the cache */

/* search215_0_1_0 -> search212_0_1_0 in the cache */
/* search215_0_1 -> search212_0_1 in the cache */
static const nir_search_expression search215_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};

/* search215_1 -> search210_0 in the cache */
static const nir_search_expression search215 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search215_0.value, &search210_0.value },
   NULL,
};

   /* replace215_0 -> replace116_0 in the cache */

/* replace215_1 -> search212_0_1_0 in the cache */
static const nir_search_expression replace215 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* search216_0_0 -> replace116_0 in the cache */

/* search216_0_1_0 -> search212_0_1_0 in the cache */
/* search216_0_1 -> search212_0_1 in the cache */

/* search216_0_2 -> search210_0 in the cache */
static const nir_search_expression search216_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search212_0_1.value, &search210_0.value },
   NULL,
};

/* search216_1 -> search210_0 in the cache */
static const nir_search_expression search216 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search216_0.value, &search210_0.value },
   NULL,
};

   /* replace216_0 -> replace116_0 in the cache */

/* replace216_1 -> search212_0_1_0 in the cache */
/* replace216 -> replace215 in the cache */

   /* search217_0_0_0 -> replace116_0 in the cache */
/* search217_0_0 -> search210_1 in the cache */

/* search217_0_1_0_0 -> search212_0_1_0 in the cache */
/* search217_0_1_0 -> search212_0_1 in the cache */
/* search217_0_1 -> search214_1 in the cache */
static const nir_search_expression search217_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search210_1.value, &search214_1.value },
   NULL,
};

/* search217_1 -> search210_0 in the cache */
static const nir_search_expression search217 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search217_0.value, &search210_0.value },
   NULL,
};

   /* replace217_0 -> replace116_0 in the cache */

/* replace217_1 -> search212_0_1_0 in the cache */
static const nir_search_expression replace217 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* search218_0_0 -> replace116_0 in the cache */
/* search218_0 -> search210_1 in the cache */

/* search218_1_0 -> search212_0_1_0 in the cache */
/* search218_1 -> search212_0_1 in the cache */
static const nir_search_expression search218 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};

   /* replace218_0 -> replace116_0 in the cache */

/* replace218_1 -> search212_0_1_0 in the cache */
/* replace218 -> replace217 in the cache */

   /* search219_0_0_0 -> replace116_0 in the cache */
/* search219_0_0 -> search210_1 in the cache */
/* search219_0 -> search211_0 in the cache */

/* search219_1_0_0 -> search212_0_1_0 in the cache */
/* search219_1_0 -> search212_0_1 in the cache */
/* search219_1 -> search214_1 in the cache */
static const nir_search_expression search219 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search211_0.value, &search214_1.value },
   NULL,
};

   /* replace219_0 -> replace116_0 in the cache */

/* replace219_1 -> search212_0_1_0 in the cache */
/* replace219 -> replace217 in the cache */

   /* search220_0_0_0 -> replace116_0 in the cache */
/* search220_0_0 -> search210_1 in the cache */

/* search220_0_1_0 -> search212_0_1_0 in the cache */
/* search220_0_1 -> search212_0_1 in the cache */
/* search220_0 -> search212_0 in the cache */

/* search220_1 -> search210_0 in the cache */
static const nir_search_expression search220 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search212_0.value, &search210_0.value },
   NULL,
};

   /* replace220_0_0 -> replace116_0 in the cache */

/* replace220_0_1 -> search212_0_1_0 in the cache */
/* replace220_0 -> replace212 in the cache */
static const nir_search_expression replace220 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace212.value },
   NULL,
};

   /* search221_0_0 -> replace116_0 in the cache */

/* search221_0_1 -> search213_0_1 in the cache */

/* search221_0_2_0 -> search212_0_1_0 in the cache */
/* search221_0_2 -> search212_0_1 in the cache */
/* search221_0 -> search213_0 in the cache */

/* search221_1 -> search210_0 in the cache */
static const nir_search_expression search221 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search213_0.value, &search210_0.value },
   NULL,
};

   /* replace221_0_0 -> replace116_0 in the cache */

/* replace221_0_1 -> search212_0_1_0 in the cache */
/* replace221_0 -> replace212 in the cache */
/* replace221 -> replace220 in the cache */

   /* search222_0_0 -> replace116_0 in the cache */
/* search222_0 -> search210_1 in the cache */

/* search222_1_0_0 -> search212_0_1_0 in the cache */
/* search222_1_0 -> search212_0_1 in the cache */
/* search222_1 -> search214_1 in the cache */
static const nir_search_expression search222 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search210_1.value, &search214_1.value },
   NULL,
};

   /* replace222_0_0 -> replace116_0 in the cache */

/* replace222_0_1 -> search212_0_1_0 in the cache */
/* replace222_0 -> replace212 in the cache */
/* replace222 -> replace220 in the cache */

   /* search223_0_0_0 -> replace116_0 in the cache */
/* search223_0_0 -> search210_1 in the cache */

/* search223_0_1_0 -> search212_0_1_0 in the cache */
/* search223_0_1 -> search212_0_1 in the cache */
/* search223_0 -> search215_0 in the cache */

/* search223_1 -> search210_0 in the cache */
static const nir_search_expression search223 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search215_0.value, &search210_0.value },
   NULL,
};

   /* replace223_0_0 -> replace116_0 in the cache */

/* replace223_0_1 -> search212_0_1_0 in the cache */
/* replace223_0 -> replace215 in the cache */
static const nir_search_expression replace223 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace215.value },
   NULL,
};

   /* search224_0_0 -> replace116_0 in the cache */

/* search224_0_1_0 -> search212_0_1_0 in the cache */
/* search224_0_1 -> search212_0_1 in the cache */

/* search224_0_2 -> search210_0 in the cache */
/* search224_0 -> search216_0 in the cache */

/* search224_1 -> search210_0 in the cache */
static const nir_search_expression search224 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search216_0.value, &search210_0.value },
   NULL,
};

   /* replace224_0_0 -> replace116_0 in the cache */

/* replace224_0_1 -> search212_0_1_0 in the cache */
/* replace224_0 -> replace215 in the cache */
/* replace224 -> replace223 in the cache */

   /* search225_0_0_0 -> replace116_0 in the cache */
/* search225_0_0 -> search210_1 in the cache */

/* search225_0_1_0_0 -> search212_0_1_0 in the cache */
/* search225_0_1_0 -> search212_0_1 in the cache */
/* search225_0_1 -> search214_1 in the cache */
/* search225_0 -> search217_0 in the cache */

/* search225_1 -> search210_0 in the cache */
static const nir_search_expression search225 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search217_0.value, &search210_0.value },
   NULL,
};

   /* replace225_0 -> replace116_0 in the cache */

/* replace225_1 -> search212_0_1_0 in the cache */
static const nir_search_expression replace225 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* search226_0_0 -> replace116_0 in the cache */
/* search226_0 -> search210_1 in the cache */

/* search226_1_0 -> search212_0_1_0 in the cache */
/* search226_1 -> search212_0_1 in the cache */
static const nir_search_expression search226 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};

   /* replace226_0 -> replace116_0 in the cache */

/* replace226_1 -> search212_0_1_0 in the cache */
/* replace226 -> replace225 in the cache */

   /* search227_0_0_0 -> replace116_0 in the cache */
/* search227_0_0 -> search210_1 in the cache */
/* search227_0 -> search211_0 in the cache */

/* search227_1_0_0 -> search212_0_1_0 in the cache */
/* search227_1_0 -> search212_0_1 in the cache */
/* search227_1 -> search214_1 in the cache */
static const nir_search_expression search227 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search211_0.value, &search214_1.value },
   NULL,
};

   /* replace227_0 -> replace116_0 in the cache */

/* replace227_1 -> search212_0_1_0 in the cache */
/* replace227 -> replace225 in the cache */

   /* search228_0_0_0_0 -> replace116_0 in the cache */
/* search228_0_0_0 -> search210_1 in the cache */

/* search228_0_0_1_0 -> search212_0_1_0 in the cache */
/* search228_0_0_1 -> search212_0_1 in the cache */
static const nir_search_expression search228_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};
static const nir_search_expression search228_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search228_0_0.value },
   NULL,
};

/* search228_1 -> search210_0 in the cache */
static const nir_search_expression search228 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search228_0.value, &search210_0.value },
   NULL,
};

   /* replace228_0 -> replace116_0 in the cache */

/* replace228_1 -> search212_0_1_0 in the cache */
/* replace228 -> replace212 in the cache */

   /* search229_0 -> search210_0 in the cache */

/* search229_1_0_0 -> replace116_0 in the cache */
/* search229_1_0 -> search210_1 in the cache */

/* search229_1_1_0 -> search212_0_1_0 in the cache */
/* search229_1_1 -> search212_0_1 in the cache */
/* search229_1 -> search228_0_0 in the cache */
static const nir_search_expression search229 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search210_0.value, &search228_0_0.value },
   NULL,
};

   /* replace229_0 -> replace116_0 in the cache */

/* replace229_1 -> search212_0_1_0 in the cache */
/* replace229 -> replace212 in the cache */

   /* search230_0_0_0_0 -> replace116_0 in the cache */
/* search230_0_0_0 -> search210_1 in the cache */

/* search230_0_0_1_0 -> search212_0_1_0 in the cache */
/* search230_0_0_1 -> search212_0_1 in the cache */
/* search230_0_0 -> search228_0_0 in the cache */
/* search230_0 -> search228_0 in the cache */

/* search230_1 -> search210_0 in the cache */
static const nir_search_expression search230 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search228_0.value, &search210_0.value },
   NULL,
};

   /* replace230_0_0 -> replace116_0 in the cache */

/* replace230_0_1 -> search212_0_1_0 in the cache */
/* replace230_0 -> replace212 in the cache */
/* replace230 -> replace220 in the cache */

   /* search231_0 -> search210_0 in the cache */

/* search231_1_0_0 -> replace116_0 in the cache */
/* search231_1_0 -> search210_1 in the cache */

/* search231_1_1_0 -> search212_0_1_0 in the cache */
/* search231_1_1 -> search212_0_1 in the cache */
/* search231_1 -> search228_0_0 in the cache */
static const nir_search_expression search231 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search210_0.value, &search228_0_0.value },
   NULL,
};

   /* replace231_0_0 -> replace116_0 in the cache */

/* replace231_0_1 -> search212_0_1_0 in the cache */
/* replace231_0 -> replace212 in the cache */
/* replace231 -> replace220 in the cache */

   /* search232_0 -> search2_0 in the cache */

/* search232_1_0 -> search2_0 in the cache */
/* search232_1 -> search22_0 in the cache */
static const nir_search_expression search232 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search22_0.value },
   NULL,
};

   /* replace232_0 -> search2_0 in the cache */

/* replace232_1 -> search30_1 in the cache */
/* replace232 -> replace105_0 in the cache */

   /* search233_0 -> search2_0 in the cache */

/* search233_1_0 -> search2_0 in the cache */
/* search233_1 -> search22_0 in the cache */
static const nir_search_expression search233 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search22_0.value },
   NULL,
};

   /* replace233_0 -> search2_0 in the cache */

/* replace233_1 -> search30_1 in the cache */
static const nir_search_expression replace233 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search30_1.value },
   NULL,
};

   static const nir_search_variable search234_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search234_0_1_0_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search234_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search234_0_1_0_0_0.value },
   NULL,
};

static const nir_search_variable search234_0_1_0_1_0 = {
   { nir_search_value_variable, 1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search234_0_1_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search234_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression search234_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search234_0_1_0_0.value, &search234_0_1_0_1.value },
   NULL,
};
static const nir_search_expression search234_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search234_0_1_0.value },
   NULL,
};
static const nir_search_expression search234_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search234_0_0.value, &search234_0_1.value },
   NULL,
};

/* search234_1 -> search30_1 in the cache */
static const nir_search_expression search234 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search234_0.value, &search30_1.value },
   NULL,
};

   /* replace234_0_0 -> search234_0_0 in the cache */

/* replace234_0_1 -> search30_1 in the cache */
static const nir_search_expression replace234_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search234_0_0.value, &search30_1.value },
   NULL,
};

/* replace234_1_0 -> search234_0_1_0_0_0 in the cache */

/* replace234_1_1 -> search234_0_1_0_1_0 in the cache */
static const nir_search_expression replace234_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search234_0_1_0_0_0.value, &search234_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace234 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace234_0.value, &replace234_1.value },
   NULL,
};

   /* search235_0_0 -> search0_0 in the cache */

/* search235_0_1 -> replace0_1_0 in the cache */
/* search235_0 -> replace66 in the cache */

/* search235_1 -> search0_0 in the cache */
static const nir_search_expression search235 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &replace66.value, &search0_0.value },
   NULL,
};

   /* replace235_0 -> replace0_1_0 in the cache */

/* replace235_1 -> search60_0 in the cache */
static const nir_search_expression replace235 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* search236_0_0 -> search0_0 in the cache */

/* search236_0_1 -> replace0_1_0 in the cache */
/* search236_0 -> replace66 in the cache */

/* search236_1 -> search0_0 in the cache */
static const nir_search_expression search236 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace66.value, &search0_0.value },
   NULL,
};

   /* replace236_0 -> replace0_1_0 in the cache */

/* replace236_1 -> search60_0 in the cache */
static const nir_search_expression replace236 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* search237_0_0 -> search0_0 in the cache */

/* search237_0_1 -> replace0_1_0 in the cache */
/* search237_0 -> search44_1 in the cache */

/* search237_1 -> search0_0 in the cache */
static const nir_search_expression search237 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search44_1.value, &search0_0.value },
   NULL,
};

   /* replace237_0 -> replace0_1_0 in the cache */

/* replace237_1 -> search60_0 in the cache */
static const nir_search_expression replace237 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* search238_0_0 -> search0_0 in the cache */

/* search238_0_1 -> replace0_1_0 in the cache */
/* search238_0 -> search44_1 in the cache */

/* search238_1 -> search0_0 in the cache */
static const nir_search_expression search238 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search44_1.value, &search0_0.value },
   NULL,
};

   /* replace238_0 -> replace0_1_0 in the cache */

/* replace238_1 -> search60_0 in the cache */
static const nir_search_expression replace238 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace0_1_0.value, &search60_0.value },
   NULL,
};

   /* search239_0_0 -> search36_0_0 in the cache */

/* search239_0_1 -> search131_0_0_1 in the cache */
static const nir_search_expression search239_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_0_0.value, &search131_0_0_1.value },
   (is_used_once),
};

/* search239_1 -> search131_0_1 in the cache */
static const nir_search_expression search239 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search239_0.value, &search131_0_1.value },
   NULL,
};

   /* replace239_0 -> search36_0_0 in the cache */

/* replace239_1_0 -> search36_1_1 in the cache */

/* replace239_1_1_0 -> search36_0_1 in the cache */
static const nir_search_expression replace239_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_0_1.value },
   NULL,
};
static const nir_search_expression replace239_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_1_1.value, &replace239_1_1.value },
   NULL,
};
static const nir_search_expression replace239 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search36_0_0.value, &replace239_1.value },
   NULL,
};

   /* search240_0_0_0 -> search36_0_0 in the cache */

/* search240_0_0_1 -> search131_0_0_1 in the cache */
/* search240_0_0 -> search239_0 in the cache */
static const nir_search_expression search240_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search239_0.value },
   (is_used_once),
};

/* search240_1 -> search131_0_1 in the cache */
static const nir_search_expression search240 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search240_0.value, &search131_0_1.value },
   NULL,
};

   /* replace240_0_0_0 -> search36_1_1 in the cache */

/* replace240_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace240_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_1_1.value, &search36_0_1.value },
   NULL,
};
static const nir_search_expression replace240_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace240_0_0.value },
   NULL,
};

/* replace240_1 -> search36_0_0 in the cache */
static const nir_search_expression replace240 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace240_0.value, &search36_0_0.value },
   NULL,
};

   /* search241_0_0 -> search36_0_0 in the cache */

/* search241_0_1 -> search131_0_0_1 in the cache */
/* search241_0 -> search239_0 in the cache */

/* search241_1 -> search131_0_1 in the cache */
static const nir_search_expression search241 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search239_0.value, &search131_0_1.value },
   NULL,
};

   /* replace241_0 -> search36_0_0 in the cache */

/* replace241_1_0 -> search36_1_1 in the cache */

/* replace241_1_1_0 -> search36_0_1 in the cache */
/* replace241_1_1 -> replace239_1_1 in the cache */
/* replace241_1 -> replace239_1 in the cache */
static const nir_search_expression replace241 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search36_0_0.value, &replace239_1.value },
   NULL,
};

   /* search242_0_0_0 -> search36_0_0 in the cache */

/* search242_0_0_1 -> search131_0_0_1 in the cache */
/* search242_0_0 -> search239_0 in the cache */
/* search242_0 -> search240_0 in the cache */

/* search242_1 -> search131_0_1 in the cache */
static const nir_search_expression search242 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search240_0.value, &search131_0_1.value },
   NULL,
};

   /* replace242_0_0_0 -> search36_1_1 in the cache */

/* replace242_0_0_1 -> search36_0_1 in the cache */
/* replace242_0_0 -> replace240_0_0 in the cache */
/* replace242_0 -> replace240_0 in the cache */

/* replace242_1 -> search36_0_0 in the cache */
static const nir_search_expression replace242 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace240_0.value, &search36_0_0.value },
   NULL,
};

   /* search243_0_0 -> search36_0_0 in the cache */

/* search243_0_1 -> search131_0_0_1 in the cache */
static const nir_search_expression search243_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_0_0.value, &search131_0_0_1.value },
   (is_used_once),
};

/* search243_1 -> search131_0_1 in the cache */
static const nir_search_expression search243 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search243_0.value, &search131_0_1.value },
   NULL,
};

   /* replace243_0 -> search36_0_0 in the cache */

/* replace243_1_0 -> search36_1_1 in the cache */

/* replace243_1_1_0 -> search36_0_1 in the cache */
/* replace243_1_1 -> replace239_1_1 in the cache */
static const nir_search_expression replace243_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_1_1.value, &replace239_1_1.value },
   NULL,
};
static const nir_search_expression replace243 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search36_0_0.value, &replace243_1.value },
   NULL,
};

   /* search244_0_0_0 -> search36_0_0 in the cache */

/* search244_0_0_1 -> search131_0_0_1 in the cache */
/* search244_0_0 -> search243_0 in the cache */
static const nir_search_expression search244_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search243_0.value },
   (is_used_once),
};

/* search244_1 -> search131_0_1 in the cache */
static const nir_search_expression search244 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search244_0.value, &search131_0_1.value },
   NULL,
};

   /* replace244_0_0_0 -> search36_1_1 in the cache */

/* replace244_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace244_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_1_1.value, &search36_0_1.value },
   NULL,
};
static const nir_search_expression replace244_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace244_0_0.value },
   NULL,
};

/* replace244_1 -> search36_0_0 in the cache */
static const nir_search_expression replace244 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &replace244_0.value, &search36_0_0.value },
   NULL,
};

   /* search245_0_0 -> search36_0_0 in the cache */

/* search245_0_1 -> search131_0_0_1 in the cache */
/* search245_0 -> search243_0 in the cache */

/* search245_1 -> search131_0_1 in the cache */
static const nir_search_expression search245 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search243_0.value, &search131_0_1.value },
   NULL,
};

   /* replace245_0 -> search36_0_0 in the cache */

/* replace245_1_0 -> search36_1_1 in the cache */

/* replace245_1_1_0 -> search36_0_1 in the cache */
/* replace245_1_1 -> replace239_1_1 in the cache */
/* replace245_1 -> replace243_1 in the cache */
static const nir_search_expression replace245 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &search36_0_0.value, &replace243_1.value },
   NULL,
};

   /* search246_0_0_0 -> search36_0_0 in the cache */

/* search246_0_0_1 -> search131_0_0_1 in the cache */
/* search246_0_0 -> search243_0 in the cache */
/* search246_0 -> search244_0 in the cache */

/* search246_1 -> search131_0_1 in the cache */
static const nir_search_expression search246 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fneu,
   { &search244_0.value, &search131_0_1.value },
   NULL,
};

   /* replace246_0_0_0 -> search36_1_1 in the cache */

/* replace246_0_0_1 -> search36_0_1 in the cache */
/* replace246_0_0 -> replace244_0_0 in the cache */
/* replace246_0 -> replace244_0 in the cache */

/* replace246_1 -> search36_0_0 in the cache */
static const nir_search_expression replace246 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fneu,
   { &replace244_0.value, &search36_0_0.value },
   NULL,
};

   /* search247_0_0 -> search0_0 in the cache */

/* search247_0_1 -> replace0_1_0 in the cache */
/* search247_0 -> search42_1 in the cache */

/* search247_1 -> search0_0 in the cache */
static const nir_search_expression search247 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search42_1.value, &search0_0.value },
   NULL,
};

   /* replace247_0 -> replace0_1_0 in the cache */

/* replace247_1 -> replace19_1 in the cache */
static const nir_search_expression replace247 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &replace19_1.value },
   NULL,
};

   /* search248_0_0 -> search0_0 in the cache */

/* search248_0_1 -> replace0_1_0 in the cache */
/* search248_0 -> search42_1 in the cache */

/* search248_1 -> search0_0 in the cache */
static const nir_search_expression search248 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search42_1.value, &search0_0.value },
   NULL,
};

   /* replace248_0 -> replace0_1_0 in the cache */

/* replace248_1 -> replace19_1 in the cache */
static const nir_search_expression replace248 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace0_1_0.value, &replace19_1.value },
   NULL,
};

   /* search249_0_0 -> replace116_0 in the cache */
/* search249_0 -> search210_1 in the cache */

/* search249_1 -> search210_0 in the cache */
static const nir_search_expression search249 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search210_1.value, &search210_0.value },
   NULL,
};

   /* replace249_0 -> replace116_0 in the cache */
/* replace249 -> replace210 in the cache */

   /* search250_0_0 -> replace116_0 in the cache */
/* search250_0 -> search210_1 in the cache */

/* search250_1 -> search210_0 in the cache */
static const nir_search_expression search250 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search210_1.value, &search210_0.value },
   NULL,
};

   /* replace250 -> replace116_0 in the cache */

   /* search251_0_0 -> replace116_0 in the cache */
static const nir_search_expression search251_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace116_0.value },
   NULL,
};

static const nir_search_constant search251_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search251 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search251_0.value, &search251_1.value },
   NULL,
};

   /* replace251_0 -> replace116_0 in the cache */
/* replace251 -> replace210 in the cache */

   /* search252_0_0 -> replace116_0 in the cache */
/* search252_0 -> search251_0 in the cache */

/* search252_1 -> search251_1 in the cache */
static const nir_search_expression search252 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search251_0.value, &search251_1.value },
   NULL,
};

   /* replace252 -> replace116_0 in the cache */

   /* search253_0_0 -> search2_0 in the cache */
/* search253_0 -> search25_0 in the cache */

/* search253_1 -> search210_0 in the cache */
static const nir_search_expression search253 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search25_0.value, &search210_0.value },
   NULL,
};

   /* replace253_0 -> search2_0 in the cache */

/* replace253_1 -> replace9 in the cache */
static const nir_search_expression replace253 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search254_0_0 -> search2_0 in the cache */
/* search254_0 -> search25_0 in the cache */

/* search254_1 -> search210_0 in the cache */
static const nir_search_expression search254 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search25_0.value, &search210_0.value },
   NULL,
};

   /* replace254_0 -> search2_0 in the cache */

/* replace254_1 -> replace9 in the cache */
static const nir_search_expression replace254 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search255_0_0 -> search2_0 in the cache */
/* search255_0 -> search25_0 in the cache */

/* search255_1 -> search210_0 in the cache */
static const nir_search_expression search255 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search25_0.value, &search210_0.value },
   NULL,
};

   static const nir_search_constant replace255 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_TRUE /* True */ },
};

   /* search256_0 -> search210_0 in the cache */

/* search256_1_0 -> search2_0 in the cache */
/* search256_1 -> search25_0 in the cache */
static const nir_search_expression search256 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search210_0.value, &search25_0.value },
   NULL,
};

   /* replace256_0 -> replace9 in the cache */

/* replace256_1 -> search2_0 in the cache */
static const nir_search_expression replace256 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search257_0_0 -> search2_0 in the cache */
/* search257_0 -> search25_0 in the cache */

/* search257_1 -> search210_0 in the cache */
static const nir_search_expression search257 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search25_0.value, &search210_0.value },
   NULL,
};

   /* replace257 -> replace189 in the cache */

   /* search258_0 -> search210_0 in the cache */

/* search258_1_0 -> search2_0 in the cache */
/* search258_1 -> search25_0 in the cache */
static const nir_search_expression search258 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search210_0.value, &search25_0.value },
   NULL,
};

   /* replace258_0 -> replace9 in the cache */

/* replace258_1 -> search2_0 in the cache */
static const nir_search_expression replace258 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search259_0_0 -> search2_0 in the cache */
static const nir_search_expression search259_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search2_0.value },
   NULL,
};

/* search259_1 -> search210_0 in the cache */
static const nir_search_expression search259 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search259_0.value, &search210_0.value },
   NULL,
};

   /* replace259_0 -> search2_0 in the cache */

/* replace259_1 -> replace9 in the cache */
/* replace259 -> replace253 in the cache */

   /* search260_0_0 -> search2_0 in the cache */
/* search260_0 -> search259_0 in the cache */

/* search260_1 -> search210_0 in the cache */
static const nir_search_expression search260 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search259_0.value, &search210_0.value },
   NULL,
};

   /* replace260_0 -> search2_0 in the cache */

/* replace260_1 -> replace9 in the cache */
/* replace260 -> replace254 in the cache */

   /* search261_0_0 -> search2_0 in the cache */
/* search261_0 -> search259_0 in the cache */

/* search261_1 -> search210_0 in the cache */
static const nir_search_expression search261 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search259_0.value, &search210_0.value },
   NULL,
};

   /* replace261_0 -> search2_0 in the cache */

/* replace261_1 -> replace9 in the cache */
static const nir_search_expression replace261 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search262_0 -> search210_0 in the cache */

/* search262_1_0 -> search2_0 in the cache */
/* search262_1 -> search259_0 in the cache */
static const nir_search_expression search262 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search210_0.value, &search259_0.value },
   NULL,
};

   /* replace262_0 -> replace9 in the cache */

/* replace262_1 -> search2_0 in the cache */
static const nir_search_expression replace262 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search263_0_0 -> search2_0 in the cache */
/* search263_0 -> search259_0 in the cache */

/* search263_1 -> search210_0 in the cache */
static const nir_search_expression search263 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search259_0.value, &search210_0.value },
   NULL,
};

   /* replace263_0 -> search2_0 in the cache */

/* replace263_1 -> replace9 in the cache */
static const nir_search_expression replace263 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search264_0 -> search210_0 in the cache */

/* search264_1_0 -> search2_0 in the cache */
/* search264_1 -> search259_0 in the cache */
static const nir_search_expression search264 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search210_0.value, &search259_0.value },
   NULL,
};

   /* replace264_0 -> replace9 in the cache */

/* replace264_1 -> search2_0 in the cache */
static const nir_search_expression replace264 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search265_0 -> search30_1 in the cache */

/* search265_1_0 -> search2_0 in the cache */
/* search265_1 -> replace24 in the cache */
static const nir_search_expression search265 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search30_1.value, &replace24.value },
   NULL,
};

   /* replace265_0 -> search2_0 in the cache */

/* replace265_1 -> search30_1 in the cache */
static const nir_search_expression replace265 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search2_0.value, &search30_1.value },
   NULL,
};

   /* search266_0_0_0 -> search2_0 in the cache */
/* search266_0_0 -> replace24 in the cache */
static const nir_search_expression search266_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace24.value },
   NULL,
};

/* search266_1 -> search30_1 in the cache */
static const nir_search_expression search266 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search266_0.value, &search30_1.value },
   NULL,
};

   /* replace266_0 -> search2_0 in the cache */

/* replace266_1 -> search30_1 in the cache */
/* replace266 -> replace265 in the cache */

   /* search267_0 -> search30_1 in the cache */

/* search267_1_0 -> search2_0 in the cache */
/* search267_1 -> replace24 in the cache */
static const nir_search_expression search267 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search30_1.value, &replace24.value },
   NULL,
};

   /* replace267_0 -> search2_0 in the cache */

/* replace267_1 -> search30_1 in the cache */
static const nir_search_expression replace267 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search30_1.value },
   NULL,
};

   /* search268_0_0_0 -> search2_0 in the cache */
/* search268_0_0 -> replace24 in the cache */
/* search268_0 -> search266_0 in the cache */

/* search268_1 -> search30_1 in the cache */
static const nir_search_expression search268 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search266_0.value, &search30_1.value },
   NULL,
};

   /* replace268_0 -> search2_0 in the cache */

/* replace268_1 -> search30_1 in the cache */
/* replace268 -> replace267 in the cache */

   /* search269_0_0 -> search2_0 in the cache */

/* search269_0_1 -> search30_1 in the cache */
/* search269_0 -> replace233 in the cache */

/* search269_1_0 -> search53_1 in the cache */

/* search269_1_1 -> search2_0 in the cache */
/* search269_1 -> replace200 in the cache */
static const nir_search_expression search269 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace233.value, &replace200.value },
   NULL,
};

   /* replace269_0 -> search2_0 in the cache */

/* replace269_1_0 -> search2_0 in the cache */
/* replace269_1 -> search46_0 in the cache */
static const nir_search_expression replace269 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search46_0.value },
   NULL,
};

   /* search270_0_0 -> replace116_0 in the cache */
static const nir_search_expression search270_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   (is_used_once),
};

/* search270_1_0 -> search212_0_1_0 in the cache */
/* search270_1 -> search212_0_1 in the cache */
static const nir_search_expression search270 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search270_0.value, &search212_0_1.value },
   NULL,
};

   /* replace270_0_0 -> replace116_0 in the cache */

/* replace270_0_1 -> search212_0_1_0 in the cache */
/* replace270_0 -> replace212 in the cache */
static const nir_search_expression replace270 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace212.value },
   NULL,
};

   /* search271_0_0_0 -> replace116_0 in the cache */
/* search271_0_0 -> search270_0 in the cache */
static const nir_search_expression search271_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search270_0.value },
   (is_used_once),
};

/* search271_1_0_0 -> search212_0_1_0 in the cache */
/* search271_1_0 -> search212_0_1 in the cache */
/* search271_1 -> search214_1 in the cache */
static const nir_search_expression search271 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search271_0.value, &search214_1.value },
   NULL,
};

   /* replace271_0_0_0 -> replace116_0 in the cache */

/* replace271_0_0_1 -> search212_0_1_0 in the cache */
/* replace271_0_0 -> replace215 in the cache */
static const nir_search_expression replace271_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace215.value },
   NULL,
};
static const nir_search_expression replace271 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace271_0.value },
   NULL,
};

   /* search272_0_0 -> replace116_0 in the cache */
/* search272_0 -> search270_0 in the cache */

/* search272_1_0 -> search212_0_1_0 in the cache */
/* search272_1 -> search212_0_1 in the cache */
static const nir_search_expression search272 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search270_0.value, &search212_0_1.value },
   NULL,
};

   /* replace272_0_0 -> replace116_0 in the cache */

/* replace272_0_1 -> search212_0_1_0 in the cache */
/* replace272_0 -> replace215 in the cache */
/* replace272 -> replace271_0 in the cache */

   /* search273_0_0_0 -> replace116_0 in the cache */
/* search273_0_0 -> search270_0 in the cache */
/* search273_0 -> search271_0 in the cache */

/* search273_1_0_0 -> search212_0_1_0 in the cache */
/* search273_1_0 -> search212_0_1 in the cache */
/* search273_1 -> search214_1 in the cache */
static const nir_search_expression search273 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search271_0.value, &search214_1.value },
   NULL,
};

   /* replace273_0_0_0 -> replace116_0 in the cache */

/* replace273_0_0_1 -> search212_0_1_0 in the cache */
/* replace273_0_0 -> replace212 in the cache */
/* replace273_0 -> replace270 in the cache */
static const nir_search_expression replace273 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace270.value },
   NULL,
};

   /* search274_0_0 -> replace116_0 in the cache */
static const nir_search_expression search274_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   NULL,
};

/* search274_1 -> search132_0_1 in the cache */
static const nir_search_expression search274 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search274_0.value, &search132_0_1.value },
   NULL,
};

   /* replace274_0 -> replace116_0 in the cache */

/* replace274_1_0 -> replace0_1_0 in the cache */

/* replace274_1_1 -> search66_0 in the cache */
static const nir_search_expression replace274_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &replace0_1_0.value, &search66_0.value },
   NULL,
};

/* replace274_2_0 -> replace0_1_0 in the cache */

/* replace274_2_1 -> search60_0 in the cache */
static const nir_search_expression replace274_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &replace0_1_0.value, &search60_0.value },
   NULL,
};
static const nir_search_expression replace274 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace116_0.value, &replace274_1.value, &replace274_2.value },
   NULL,
};

   /* search275_0_0 -> search0_0 in the cache */

/* search275_0_1_0 -> replace0_1_0 in the cache */
/* search275_0_1 -> search194_1 in the cache */
static const nir_search_expression search275_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &search194_1.value },
   (is_used_once),
};

/* search275_1 -> search60_0 in the cache */
static const nir_search_expression search275 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search275_0.value, &search60_0.value },
   NULL,
};

   /* replace275_0 -> search0_0 in the cache */

/* replace275_1 -> replace0_1_0 in the cache */
/* replace275 -> replace180 in the cache */

   /* search276_0_0_0 -> search2_0 in the cache */
/* search276_0_0 -> replace24 in the cache */
/* search276_0 -> search266_0 in the cache */

/* search276_1 -> search30_1 in the cache */
/* search276 -> search268 in the cache */

   /* replace276_0 -> search2_0 in the cache */

/* replace276_1 -> search30_1 in the cache */
/* replace276 -> replace267 in the cache */

   /* search277_0_0 -> replace204_0 in the cache */

/* search277_0_1 -> search204_1_0 in the cache */
/* search277_0 -> replace204 in the cache */

/* search277_1 -> replace204_0 in the cache */

/* search277_2 -> search204_1_0 in the cache */
static const nir_search_expression search277 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace204.value, &replace204_0.value, &search204_1_0.value },
   NULL,
};

   /* replace277_0 -> search204_1_0 in the cache */

/* replace277_1 -> replace204_0 in the cache */
static const nir_search_expression replace277 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search204_1_0.value, &replace204_0.value },
   NULL,
};

   /* search278_0_0 -> search0_0 in the cache */

/* search278_0_1 -> replace0_1_0 in the cache */
/* search278_0 -> replace180 in the cache */

/* search278_1 -> replace0_1_0 in the cache */

/* search278_2 -> search0_0 in the cache */
static const nir_search_expression search278 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace180.value, &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* replace278_0 -> search0_0 in the cache */

/* replace278_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace278 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search279_0_0 -> search0_0 in the cache */

/* search279_0_1 -> replace0_1_0 in the cache */
/* search279_0 -> replace179 in the cache */

/* search279_1 -> replace0_1_0 in the cache */

/* search279_2 -> search0_0 in the cache */
static const nir_search_expression search279 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace179.value, &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* replace279_0 -> search0_0 in the cache */

/* replace279_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace279 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search280_0_0 -> replace204_0 in the cache */

/* search280_0_1 -> search204_1_0 in the cache */
static const nir_search_expression search280_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace204_0.value, &search204_1_0.value },
   NULL,
};

/* search280_1 -> replace204_0 in the cache */

/* search280_2 -> search204_1_0 in the cache */
static const nir_search_expression search280 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &search280_0.value, &replace204_0.value, &search204_1_0.value },
   NULL,
};

   /* replace280_0 -> search204_1_0 in the cache */

/* replace280_1 -> replace204_0 in the cache */
static const nir_search_expression replace280 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search204_1_0.value, &replace204_0.value },
   NULL,
};

   /* search281_0_0 -> search2_0 in the cache */
static const nir_search_expression search281_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

/* search281_1 -> search36_0_1 in the cache */

/* search281_2 -> search36_1_1 in the cache */
static const nir_search_expression search281 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search281_0.value, &search36_0_1.value, &search36_1_1.value },
   NULL,
};

   /* replace281_0_0 -> search2_0 in the cache */

/* replace281_0_1 -> replace9 in the cache */
/* replace281_0 -> replace253 in the cache */

/* replace281_1 -> search36_0_1 in the cache */

/* replace281_2 -> search36_1_1 in the cache */
static const nir_search_expression replace281 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace253.value, &search36_0_1.value, &search36_1_1.value },
   NULL,
};

   /* search282_0_0 -> replace116_0 in the cache */
/* search282_0 -> replace210 in the cache */

/* search282_1 -> search36_0_1 in the cache */

/* search282_2 -> search36_1_1 in the cache */
static const nir_search_expression search282 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace210.value, &search36_0_1.value, &search36_1_1.value },
   NULL,
};

   /* replace282_0 -> replace116_0 in the cache */

/* replace282_1 -> search36_1_1 in the cache */

/* replace282_2 -> search36_0_1 in the cache */
static const nir_search_expression replace282 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search36_1_1.value, &search36_0_1.value },
   NULL,
};

   /* search283_0 -> replace116_0 in the cache */

/* search283_1_0 -> replace116_0 in the cache */

/* search283_1_1 -> search103_0_1 in the cache */

/* search283_1_2 -> search103_1_1 in the cache */
static const nir_search_expression search283_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_0_1.value, &search103_1_1.value },
   NULL,
};

/* search283_2 -> search103_2 in the cache */
static const nir_search_expression search283 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search283_1.value, &search103_2.value },
   NULL,
};

   /* replace283_0 -> replace116_0 in the cache */

/* replace283_1 -> search103_0_1 in the cache */

/* replace283_2 -> search103_2 in the cache */
static const nir_search_expression replace283 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_0_1.value, &search103_2.value },
   NULL,
};

   /* search284_0 -> replace116_0 in the cache */

/* search284_1 -> search103_0_1 in the cache */

/* search284_2_0 -> replace116_0 in the cache */

/* search284_2_1 -> search103_1_1 in the cache */

/* search284_2_2 -> search103_2 in the cache */
static const nir_search_expression search284_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_1_1.value, &search103_2.value },
   NULL,
};
static const nir_search_expression search284 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_0_1.value, &search284_2.value },
   NULL,
};

   /* replace284_0 -> replace116_0 in the cache */

/* replace284_1 -> search103_0_1 in the cache */

/* replace284_2 -> search103_2 in the cache */
/* replace284 -> replace283 in the cache */

   /* search285_0 -> replace116_0 in the cache */

/* search285_1_0 -> search212_0_1_0 in the cache */

/* search285_1_1 -> search116_0_0_1_1 in the cache */

/* search285_1_2 -> replace116_1_0_1 in the cache */
static const nir_search_expression search285_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search116_0_0_1_1.value, &replace116_1_0_1.value },
   NULL,
};

/* search285_2_0 -> search212_0_1_0 in the cache */

/* search285_2_1 -> search116_0_0_1_1 in the cache */

/* search285_2_2 -> replace116_1_1 in the cache */
static const nir_search_expression search285_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search116_0_0_1_1.value, &replace116_1_1.value },
   (is_used_once),
};
static const nir_search_expression search285 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search285_1.value, &search285_2.value },
   NULL,
};

   /* replace285_0 -> search212_0_1_0 in the cache */

/* replace285_1 -> search116_0_0_1_1 in the cache */

/* replace285_2_0 -> replace116_0 in the cache */

/* replace285_2_1 -> replace116_1_0_1 in the cache */

/* replace285_2_2 -> replace116_1_1 in the cache */
static const nir_search_expression replace285_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace116_1_0_1.value, &replace116_1_1.value },
   NULL,
};
static const nir_search_expression replace285 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search116_0_0_1_1.value, &replace285_2.value },
   NULL,
};

   /* search286_0 -> replace116_0 in the cache */

/* search286_1_0 -> search212_0_1_0 in the cache */

/* search286_1_1 -> search116_0_0_1_1 in the cache */

/* search286_1_2 -> replace116_1_0_1 in the cache */
static const nir_search_expression search286_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search116_0_0_1_1.value, &replace116_1_0_1.value },
   (is_used_once),
};

/* search286_2_0 -> search212_0_1_0 in the cache */

/* search286_2_1 -> search116_0_0_1_1 in the cache */

/* search286_2_2 -> replace116_1_1 in the cache */
static const nir_search_expression search286_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search116_0_0_1_1.value, &replace116_1_1.value },
   NULL,
};
static const nir_search_expression search286 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search286_1.value, &search286_2.value },
   NULL,
};

   /* replace286_0 -> search212_0_1_0 in the cache */

/* replace286_1 -> search116_0_0_1_1 in the cache */

/* replace286_2_0 -> replace116_0 in the cache */

/* replace286_2_1 -> replace116_1_0_1 in the cache */

/* replace286_2_2 -> replace116_1_1 in the cache */
/* replace286_2 -> replace285_2 in the cache */
/* replace286 -> replace285 in the cache */

   /* search287_0 -> replace116_0 in the cache */

/* search287_1_0 -> search212_0_1_0 in the cache */

/* search287_1_1 -> search103_1_1 in the cache */

/* search287_1_2 -> search103_2 in the cache */
static const nir_search_expression search287_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search103_1_1.value, &search103_2.value },
   NULL,
};

/* search287_2_0 -> search212_0_1_0 in the cache */

static const nir_search_variable search287_2_1 = {
   { nir_search_value_variable, -4 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search287_2_2 -> search103_2 in the cache */
static const nir_search_expression search287_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search287_2_1.value, &search103_2.value },
   (is_used_once),
};
static const nir_search_expression search287 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search287_1.value, &search287_2.value },
   NULL,
};

   /* replace287_0 -> search212_0_1_0 in the cache */

/* replace287_1_0 -> replace116_0 in the cache */

/* replace287_1_1 -> search103_1_1 in the cache */

/* replace287_1_2 -> search287_2_1 in the cache */
static const nir_search_expression replace287_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_1_1.value, &search287_2_1.value },
   NULL,
};

/* replace287_2 -> search103_2 in the cache */
static const nir_search_expression replace287 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &replace287_1.value, &search103_2.value },
   NULL,
};

   /* search288_0 -> replace116_0 in the cache */

/* search288_1_0 -> search212_0_1_0 in the cache */

/* search288_1_1 -> search103_1_1 in the cache */

/* search288_1_2 -> search103_2 in the cache */
static const nir_search_expression search288_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search103_1_1.value, &search103_2.value },
   (is_used_once),
};

/* search288_2_0 -> search212_0_1_0 in the cache */

/* search288_2_1 -> search287_2_1 in the cache */

/* search288_2_2 -> search103_2 in the cache */
static const nir_search_expression search288_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search212_0_1_0.value, &search287_2_1.value, &search103_2.value },
   NULL,
};
static const nir_search_expression search288 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search288_1.value, &search288_2.value },
   NULL,
};

   /* replace288_0 -> search212_0_1_0 in the cache */

/* replace288_1_0 -> replace116_0 in the cache */

/* replace288_1_1 -> search103_1_1 in the cache */

/* replace288_1_2 -> search287_2_1 in the cache */
/* replace288_1 -> replace287_1 in the cache */

/* replace288_2 -> search103_2 in the cache */
/* replace288 -> replace287 in the cache */

   /* search289_0 -> replace116_0 in the cache */

/* search289_1 -> replace255 in the cache */

/* search289_2 -> search212_0_1_0 in the cache */
static const nir_search_expression search289 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace255.value, &search212_0_1_0.value },
   NULL,
};

   /* replace289_0 -> replace116_0 in the cache */

/* replace289_1 -> search212_0_1_0 in the cache */
/* replace289 -> replace212 in the cache */

   /* search290_0 -> replace116_0 in the cache */

/* search290_1 -> replace116_0 in the cache */

/* search290_2 -> search212_0_1_0 in the cache */
static const nir_search_expression search290 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* replace290_0 -> replace116_0 in the cache */

/* replace290_1 -> search212_0_1_0 in the cache */
/* replace290 -> replace212 in the cache */

   /* search291_0 -> replace116_0 in the cache */

/* search291_1 -> search212_0_1_0 in the cache */

/* search291_2 -> replace189 in the cache */
static const nir_search_expression search291 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search212_0_1_0.value, &replace189.value },
   NULL,
};

   /* replace291_0 -> replace116_0 in the cache */

/* replace291_1 -> search212_0_1_0 in the cache */
/* replace291 -> replace215 in the cache */

   /* search292_0 -> replace116_0 in the cache */

/* search292_1 -> search212_0_1_0 in the cache */

/* search292_2 -> replace116_0 in the cache */
static const nir_search_expression search292 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search212_0_1_0.value, &replace116_0.value },
   NULL,
};

   /* replace292_0 -> replace116_0 in the cache */

/* replace292_1 -> search212_0_1_0 in the cache */
/* replace292 -> replace215 in the cache */

   /* search293_0 -> search2_0 in the cache */

/* search293_1 -> search2_0 in the cache */
static const nir_search_expression search293 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace293 -> search2_0 in the cache */

   /* search294_0 -> search2_0 in the cache */

/* search294_1 -> search2_0 in the cache */
static const nir_search_expression search294 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace294 -> search2_0 in the cache */

   /* search295_0 -> search2_0 in the cache */

/* search295_1 -> search2_0 in the cache */
static const nir_search_expression search295 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace295 -> search2_0 in the cache */

   /* search296_0 -> search2_0 in the cache */

/* search296_1 -> search2_0 in the cache */
static const nir_search_expression search296 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace296 -> search2_0 in the cache */

   /* search297_0 -> search2_0 in the cache */

/* search297_1 -> search2_0 in the cache */
static const nir_search_expression search297 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace297 -> search2_0 in the cache */

   /* search298_0 -> search2_0 in the cache */

/* search298_1 -> replace9 in the cache */
static const nir_search_expression search298 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace298 -> replace9 in the cache */

   /* search299_0 -> search2_0 in the cache */

/* search299_1 -> search11_1 in the cache */
static const nir_search_expression search299 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace299 -> search2_0 in the cache */

   /* search300_0 -> search2_0 in the cache */

/* search300_1 -> search2_0 in the cache */
static const nir_search_expression search300 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace300 -> search2_0 in the cache */

   /* search301_0 -> search2_0 in the cache */

/* search301_1 -> replace9 in the cache */
static const nir_search_expression search301 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace301 -> search2_0 in the cache */

   /* search302_0 -> search2_0 in the cache */

/* search302_1 -> search11_1 in the cache */
static const nir_search_expression search302 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace302 -> search11_1 in the cache */

   /* search303_0_0 -> search0_0 in the cache */

/* search303_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search303_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search303_1 -> replace0_1_0 in the cache */
static const nir_search_expression search303 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search303_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace303_0 -> search0_0 in the cache */

/* replace303_1 -> replace0_1_0 in the cache */
/* replace303 -> replace278 in the cache */

   /* search304_0_0 -> search0_0 in the cache */

/* search304_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search304_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search304_1 -> replace0_1_0 in the cache */
static const nir_search_expression search304 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umax,
   { &search304_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace304_0 -> search0_0 in the cache */

/* replace304_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace304 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search305_0_0 -> search0_0 in the cache */

/* search305_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search305_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search305_1 -> replace0_1_0 in the cache */
static const nir_search_expression search305 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imax,
   { &search305_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace305_0 -> search0_0 in the cache */

/* replace305_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace305 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search306_0_0 -> search0_0 in the cache */

/* search306_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search306_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search306_1 -> replace0_1_0 in the cache */
static const nir_search_expression search306 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search306_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace306_0 -> search0_0 in the cache */

/* replace306_1 -> replace0_1_0 in the cache */
/* replace306 -> replace279 in the cache */

   /* search307_0_0 -> search0_0 in the cache */

/* search307_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search307_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search307_1 -> replace0_1_0 in the cache */
static const nir_search_expression search307 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umin,
   { &search307_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace307_0 -> search0_0 in the cache */

/* replace307_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace307 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search308_0_0 -> search0_0 in the cache */

/* search308_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search308_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search308_1 -> replace0_1_0 in the cache */
static const nir_search_expression search308 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search308_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace308_0 -> search0_0 in the cache */

/* replace308_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace308 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search309_0_0_0 -> search36_0_0 in the cache */

/* search309_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search309_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search309_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search309_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmax,
   { &search309_0_0.value, &search36_1_1.value },
   NULL,
};

/* search309_1 -> search36_0_0 in the cache */
static const nir_search_expression search309 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_fmax,
   { &search309_0.value, &search36_0_0.value },
   NULL,
};

   /* replace309_0_0 -> search36_0_0 in the cache */

/* replace309_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace309_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace309_1 -> search36_1_1 in the cache */
static const nir_search_expression replace309 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &replace309_0.value, &search36_1_1.value },
   NULL,
};

   /* search310_0_0_0 -> search36_0_0 in the cache */

/* search310_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search310_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_umax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search310_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search310_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_umax,
   { &search310_0_0.value, &search36_1_1.value },
   NULL,
};

/* search310_1 -> search36_0_0 in the cache */
static const nir_search_expression search310 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_umax,
   { &search310_0.value, &search36_0_0.value },
   NULL,
};

   /* replace310_0_0 -> search36_0_0 in the cache */

/* replace310_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace310_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace310_1 -> search36_1_1 in the cache */
static const nir_search_expression replace310 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umax,
   { &replace310_0.value, &search36_1_1.value },
   NULL,
};

   /* search311_0_0_0 -> search36_0_0 in the cache */

/* search311_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search311_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search311_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search311_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_imax,
   { &search311_0_0.value, &search36_1_1.value },
   NULL,
};

/* search311_1 -> search36_0_0 in the cache */
static const nir_search_expression search311 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_imax,
   { &search311_0.value, &search36_0_0.value },
   NULL,
};

   /* replace311_0_0 -> search36_0_0 in the cache */

/* replace311_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace311_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace311_1 -> search36_1_1 in the cache */
static const nir_search_expression replace311 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imax,
   { &replace311_0.value, &search36_1_1.value },
   NULL,
};

   /* search312_0_0_0 -> search36_0_0 in the cache */

/* search312_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search312_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search312_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search312_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmin,
   { &search312_0_0.value, &search36_1_1.value },
   NULL,
};

/* search312_1 -> search36_0_0 in the cache */
static const nir_search_expression search312 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_fmin,
   { &search312_0.value, &search36_0_0.value },
   NULL,
};

   /* replace312_0_0 -> search36_0_0 in the cache */

/* replace312_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace312_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace312_1 -> search36_1_1 in the cache */
static const nir_search_expression replace312 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &replace312_0.value, &search36_1_1.value },
   NULL,
};

   /* search313_0_0_0 -> search36_0_0 in the cache */

/* search313_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search313_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_umin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search313_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search313_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_umin,
   { &search313_0_0.value, &search36_1_1.value },
   NULL,
};

/* search313_1 -> search36_0_0 in the cache */
static const nir_search_expression search313 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_umin,
   { &search313_0.value, &search36_0_0.value },
   NULL,
};

   /* replace313_0_0 -> search36_0_0 in the cache */

/* replace313_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace313_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace313_1 -> search36_1_1 in the cache */
static const nir_search_expression replace313 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace313_0.value, &search36_1_1.value },
   NULL,
};

   /* search314_0_0_0 -> search36_0_0 in the cache */

/* search314_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search314_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search314_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search314_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_imin,
   { &search314_0_0.value, &search36_1_1.value },
   NULL,
};

/* search314_1 -> search36_0_0 in the cache */
static const nir_search_expression search314 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_imin,
   { &search314_0.value, &search36_0_0.value },
   NULL,
};

   /* replace314_0_0 -> search36_0_0 in the cache */

/* replace314_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace314_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace314_1 -> search36_1_1 in the cache */
static const nir_search_expression replace314 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace314_0.value, &search36_1_1.value },
   NULL,
};

   /* search315_0 -> search133_0_0 in the cache */

/* search315_1_0_0 -> search133_0_0 in the cache */

/* search315_1_0_1 -> replace135_1_1 in the cache */
static const nir_search_expression search315_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search133_0_0.value, &replace135_1_1.value },
   NULL,
};
static const nir_search_expression search315_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search315_1_0.value },
   NULL,
};
static const nir_search_expression search315 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search133_0_0.value, &search315_1.value },
   NULL,
};

   /* replace315_0 -> search133_0_0 in the cache */

/* replace315_1 -> replace133_2 in the cache */
static const nir_search_expression replace315 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search133_0_0.value, &replace133_2.value },
   NULL,
};

   /* search316_0_0 -> search133_0_0 in the cache */

static const nir_search_constant search316_0_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x80 /* 128 */ },
};
static const nir_search_expression search316_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search133_0_0.value, &search316_0_1.value },
   NULL,
};

/* search316_1 -> replace133_2 in the cache */
static const nir_search_expression search316 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search316_0.value, &replace133_2.value },
   NULL,
};

   /* replace316_0 -> search133_0_0 in the cache */

/* replace316_1 -> replace133_2 in the cache */
static const nir_search_expression replace316 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search133_0_0.value, &replace133_2.value },
   NULL,
};

   /* search317_0_0 -> search133_0_0 in the cache */

/* search317_0_1 -> search316_0_1 in the cache */
/* search317_0 -> search316_0 in the cache */

/* search317_1 -> search316_0_1 in the cache */
static const nir_search_expression search317 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search316_0.value, &search316_0_1.value },
   NULL,
};

   /* replace317_0 -> search133_0_0 in the cache */

/* replace317_1 -> replace133_2 in the cache */
/* replace317 -> replace316 in the cache */

   /* search318_0_0 -> search133_0_0 in the cache */

/* search318_0_1 -> search316_0_1 in the cache */
/* search318_0 -> search316_0 in the cache */

/* search318_1 -> replace133_2 in the cache */
static const nir_search_expression search318 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search316_0.value, &replace133_2.value },
   NULL,
};

   /* replace318_0 -> search133_0_0 in the cache */

/* replace318_1 -> replace133_2 in the cache */
static const nir_search_expression replace318 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search133_0_0.value, &replace133_2.value },
   NULL,
};

   /* search319_0_0 -> search133_0_0 in the cache */

/* search319_0_1 -> search316_0_1 in the cache */
/* search319_0 -> search316_0 in the cache */

/* search319_1 -> search316_0_1 in the cache */
static const nir_search_expression search319 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search316_0.value, &search316_0_1.value },
   NULL,
};

   /* replace319_0 -> search133_0_0 in the cache */

/* replace319_1 -> replace133_2 in the cache */
/* replace319 -> replace318 in the cache */

   /* search320_0_0 -> search133_0_0 in the cache */

/* search320_0_1 -> replace135_1_1 in the cache */
static const nir_search_expression search320_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search133_0_0.value, &replace135_1_1.value },
   NULL,
};

/* search320_1 -> replace133_2 in the cache */
static const nir_search_expression search320 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search320_0.value, &replace133_2.value },
   NULL,
};

   /* replace320_0 -> search133_0_0 in the cache */

/* replace320_1 -> replace133_2 in the cache */
/* replace320 -> replace318 in the cache */

   /* search321_0_0 -> search133_0_0 in the cache */

/* search321_0_1 -> replace135_1_1 in the cache */
/* search321_0 -> search320_0 in the cache */

/* search321_1 -> replace133_2 in the cache */
static const nir_search_expression search321 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search320_0.value, &replace133_2.value },
   NULL,
};

   /* replace321_0 -> search133_0_0 in the cache */

/* replace321_1 -> replace133_2 in the cache */
/* replace321 -> replace316 in the cache */

   /* search322_0_0 -> search133_0_0 in the cache */

/* search322_0_1 -> replace135_1_1 in the cache */
/* search322_0 -> search320_0 in the cache */

static const nir_search_constant search322_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search322 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search320_0.value, &search322_1.value },
   NULL,
};

   /* replace322_0 -> search133_0_0 in the cache */

/* replace322_1 -> replace133_2 in the cache */
/* replace322 -> replace318 in the cache */

   /* search323_0_0 -> search133_0_0 in the cache */

/* search323_0_1 -> replace135_1_1 in the cache */
/* search323_0 -> search320_0 in the cache */

/* search323_1 -> search322_1 in the cache */
static const nir_search_expression search323 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search320_0.value, &search322_1.value },
   NULL,
};

   /* replace323_0 -> search133_0_0 in the cache */

/* replace323_1 -> replace133_2 in the cache */
/* replace323 -> replace316 in the cache */

   /* search324_0_0 -> search133_0_0 in the cache */

/* search324_0_1 -> replace135_1_1 in the cache */
/* search324_0 -> search315_1_0 in the cache */

/* search324_1 -> replace133_2 in the cache */
static const nir_search_expression search324 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search315_1_0.value, &replace133_2.value },
   NULL,
};

   /* replace324_0 -> search133_0_0 in the cache */

/* replace324_1 -> replace133_2 in the cache */
/* replace324 -> replace318 in the cache */

   /* search325_0_0 -> search133_0_0 in the cache */

/* search325_0_1 -> replace135_1_1 in the cache */
/* search325_0 -> search315_1_0 in the cache */

/* search325_1 -> replace133_2 in the cache */
static const nir_search_expression search325 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search315_1_0.value, &replace133_2.value },
   NULL,
};

   /* replace325_0 -> search133_0_0 in the cache */

/* replace325_1 -> replace133_2 in the cache */
/* replace325 -> replace316 in the cache */

   /* search326_0_0 -> search133_0_0 in the cache */

/* search326_0_1 -> replace135_1_1 in the cache */
/* search326_0 -> search315_1_0 in the cache */

static const nir_search_constant search326_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search326 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search315_1_0.value, &search326_1.value },
   NULL,
};

   /* replace326_0 -> search133_0_0 in the cache */

/* replace326_1 -> replace133_2 in the cache */
/* replace326 -> replace318 in the cache */

   /* search327_0_0 -> search133_0_0 in the cache */

/* search327_0_1 -> replace135_1_1 in the cache */
/* search327_0 -> search315_1_0 in the cache */

/* search327_1 -> search326_1 in the cache */
static const nir_search_expression search327 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search315_1_0.value, &search326_1.value },
   NULL,
};

   /* replace327_0 -> search133_0_0 in the cache */

/* replace327_1 -> replace133_2 in the cache */
/* replace327 -> replace316 in the cache */

   /* search328_0 -> search31_0 in the cache */

/* search328_1_0_0 -> search31_0 in the cache */

/* search328_1_0_1 -> replace138_1_1 in the cache */
static const nir_search_expression search328_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search31_0.value, &replace138_1_1.value },
   NULL,
};
static const nir_search_expression search328_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search328_1_0.value },
   NULL,
};
static const nir_search_expression search328 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search31_0.value, &search328_1.value },
   NULL,
};

   /* replace328_0 -> search31_0 in the cache */

/* replace328_1 -> replace136_2 in the cache */
static const nir_search_expression replace328 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

   /* search329_0_0 -> search31_0 in the cache */

static const nir_search_constant search329_0_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x8000 /* 32768 */ },
};
static const nir_search_expression search329_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search31_0.value, &search329_0_1.value },
   NULL,
};

/* search329_1 -> replace136_2 in the cache */
static const nir_search_expression search329 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search329_0.value, &replace136_2.value },
   NULL,
};

   /* replace329_0 -> search31_0 in the cache */

/* replace329_1 -> replace136_2 in the cache */
static const nir_search_expression replace329 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

   /* search330_0_0 -> search31_0 in the cache */

/* search330_0_1 -> search329_0_1 in the cache */
/* search330_0 -> search329_0 in the cache */

/* search330_1 -> search329_0_1 in the cache */
static const nir_search_expression search330 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search329_0.value, &search329_0_1.value },
   NULL,
};

   /* replace330_0 -> search31_0 in the cache */

/* replace330_1 -> replace136_2 in the cache */
/* replace330 -> replace329 in the cache */

   /* search331_0_0 -> search31_0 in the cache */

/* search331_0_1 -> search329_0_1 in the cache */
/* search331_0 -> search329_0 in the cache */

/* search331_1 -> replace136_2 in the cache */
static const nir_search_expression search331 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search329_0.value, &replace136_2.value },
   NULL,
};

   /* replace331_0 -> search31_0 in the cache */

/* replace331_1 -> replace136_2 in the cache */
static const nir_search_expression replace331 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

   /* search332_0_0 -> search31_0 in the cache */

/* search332_0_1 -> search329_0_1 in the cache */
/* search332_0 -> search329_0 in the cache */

/* search332_1 -> search329_0_1 in the cache */
static const nir_search_expression search332 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search329_0.value, &search329_0_1.value },
   NULL,
};

   /* replace332_0 -> search31_0 in the cache */

/* replace332_1 -> replace136_2 in the cache */
/* replace332 -> replace331 in the cache */

   /* search333_0_0 -> search31_0 in the cache */

/* search333_0_1 -> replace138_1_1 in the cache */
static const nir_search_expression search333_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search31_0.value, &replace138_1_1.value },
   NULL,
};

/* search333_1 -> replace136_2 in the cache */
static const nir_search_expression search333 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search333_0.value, &replace136_2.value },
   NULL,
};

   /* replace333_0 -> search31_0 in the cache */

/* replace333_1 -> replace136_2 in the cache */
/* replace333 -> replace331 in the cache */

   /* search334_0_0 -> search31_0 in the cache */

/* search334_0_1 -> replace138_1_1 in the cache */
/* search334_0 -> search333_0 in the cache */

/* search334_1 -> replace136_2 in the cache */
static const nir_search_expression search334 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search333_0.value, &replace136_2.value },
   NULL,
};

   /* replace334_0 -> search31_0 in the cache */

/* replace334_1 -> replace136_2 in the cache */
/* replace334 -> replace329 in the cache */

   /* search335_0_0 -> search31_0 in the cache */

/* search335_0_1 -> replace138_1_1 in the cache */
/* search335_0 -> search333_0 in the cache */

static const nir_search_constant search335_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search335 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search333_0.value, &search335_1.value },
   NULL,
};

   /* replace335_0 -> search31_0 in the cache */

/* replace335_1 -> replace136_2 in the cache */
/* replace335 -> replace331 in the cache */

   /* search336_0_0 -> search31_0 in the cache */

/* search336_0_1 -> replace138_1_1 in the cache */
/* search336_0 -> search333_0 in the cache */

/* search336_1 -> search335_1 in the cache */
static const nir_search_expression search336 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search333_0.value, &search335_1.value },
   NULL,
};

   /* replace336_0 -> search31_0 in the cache */

/* replace336_1 -> replace136_2 in the cache */
/* replace336 -> replace329 in the cache */

   /* search337_0_0 -> search31_0 in the cache */

/* search337_0_1 -> replace138_1_1 in the cache */
/* search337_0 -> search328_1_0 in the cache */

/* search337_1 -> replace136_2 in the cache */
static const nir_search_expression search337 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search328_1_0.value, &replace136_2.value },
   NULL,
};

   /* replace337_0 -> search31_0 in the cache */

/* replace337_1 -> replace136_2 in the cache */
/* replace337 -> replace331 in the cache */

   /* search338_0_0 -> search31_0 in the cache */

/* search338_0_1 -> replace138_1_1 in the cache */
/* search338_0 -> search328_1_0 in the cache */

/* search338_1 -> replace136_2 in the cache */
static const nir_search_expression search338 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search328_1_0.value, &replace136_2.value },
   NULL,
};

   /* replace338_0 -> search31_0 in the cache */

/* replace338_1 -> replace136_2 in the cache */
/* replace338 -> replace329 in the cache */

   /* search339_0_0 -> search31_0 in the cache */

/* search339_0_1 -> replace138_1_1 in the cache */
/* search339_0 -> search328_1_0 in the cache */

static const nir_search_constant search339_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search339 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search328_1_0.value, &search339_1.value },
   NULL,
};

   /* replace339_0 -> search31_0 in the cache */

/* replace339_1 -> replace136_2 in the cache */
/* replace339 -> replace331 in the cache */

   /* search340_0_0 -> search31_0 in the cache */

/* search340_0_1 -> replace138_1_1 in the cache */
/* search340_0 -> search328_1_0 in the cache */

/* search340_1 -> search339_1 in the cache */
static const nir_search_expression search340 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search328_1_0.value, &search339_1.value },
   NULL,
};

   /* replace340_0 -> search31_0 in the cache */

/* replace340_1 -> replace136_2 in the cache */
/* replace340 -> replace329 in the cache */

   /* search341_0 -> search3_0_0 in the cache */

/* search341_1_0_0 -> search3_0_0 in the cache */

/* search341_1_0_1 -> replace141_1_1 in the cache */
static const nir_search_expression search341_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &replace141_1_1.value },
   NULL,
};
static const nir_search_expression search341_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search341_1_0.value },
   NULL,
};
static const nir_search_expression search341 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &search341_1.value },
   NULL,
};

   /* replace341_0 -> search3_0_0 in the cache */

/* replace341_1 -> search34_1 in the cache */
static const nir_search_expression replace341 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search342_0_0 -> search3_0_0 in the cache */

static const nir_search_constant search342_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x80000000 /* 2147483648 */ },
};
static const nir_search_expression search342_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search3_0_0.value, &search342_0_1.value },
   NULL,
};

/* search342_1 -> search34_1 in the cache */
static const nir_search_expression search342 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search342_0.value, &search34_1.value },
   NULL,
};

   /* replace342_0 -> search3_0_0 in the cache */

/* replace342_1 -> search34_1 in the cache */
static const nir_search_expression replace342 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search343_0_0 -> search3_0_0 in the cache */

/* search343_0_1 -> search342_0_1 in the cache */
/* search343_0 -> search342_0 in the cache */

/* search343_1 -> search342_0_1 in the cache */
static const nir_search_expression search343 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search342_0.value, &search342_0_1.value },
   NULL,
};

   /* replace343_0 -> search3_0_0 in the cache */

/* replace343_1 -> search34_1 in the cache */
/* replace343 -> replace342 in the cache */

   /* search344_0_0 -> search3_0_0 in the cache */

/* search344_0_1 -> search342_0_1 in the cache */
/* search344_0 -> search342_0 in the cache */

/* search344_1 -> search34_1 in the cache */
static const nir_search_expression search344 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search342_0.value, &search34_1.value },
   NULL,
};

   /* replace344_0 -> search3_0_0 in the cache */

/* replace344_1 -> search34_1 in the cache */
static const nir_search_expression replace344 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search345_0_0 -> search3_0_0 in the cache */

/* search345_0_1 -> search342_0_1 in the cache */
/* search345_0 -> search342_0 in the cache */

/* search345_1 -> search342_0_1 in the cache */
static const nir_search_expression search345 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search342_0.value, &search342_0_1.value },
   NULL,
};

   /* replace345_0 -> search3_0_0 in the cache */

/* replace345_1 -> search34_1 in the cache */
/* replace345 -> replace344 in the cache */

   /* search346_0_0 -> search3_0_0 in the cache */

/* search346_0_1 -> replace141_1_1 in the cache */
static const nir_search_expression search346_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &replace141_1_1.value },
   NULL,
};

/* search346_1 -> search34_1 in the cache */
static const nir_search_expression search346 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search346_0.value, &search34_1.value },
   NULL,
};

   /* replace346_0 -> search3_0_0 in the cache */

/* replace346_1 -> search34_1 in the cache */
/* replace346 -> replace344 in the cache */

   /* search347_0_0 -> search3_0_0 in the cache */

/* search347_0_1 -> replace141_1_1 in the cache */
/* search347_0 -> search346_0 in the cache */

/* search347_1 -> search34_1 in the cache */
static const nir_search_expression search347 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search346_0.value, &search34_1.value },
   NULL,
};

   /* replace347_0 -> search3_0_0 in the cache */

/* replace347_1 -> search34_1 in the cache */
/* replace347 -> replace342 in the cache */

   /* search348_0_0 -> search3_0_0 in the cache */

/* search348_0_1 -> replace141_1_1 in the cache */
/* search348_0 -> search346_0 in the cache */

/* search348_1 -> search163_1 in the cache */
static const nir_search_expression search348 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search346_0.value, &search163_1.value },
   NULL,
};

   /* replace348_0 -> search3_0_0 in the cache */

/* replace348_1 -> search34_1 in the cache */
/* replace348 -> replace344 in the cache */

   /* search349_0_0 -> search3_0_0 in the cache */

/* search349_0_1 -> replace141_1_1 in the cache */
/* search349_0 -> search346_0 in the cache */

/* search349_1 -> search163_1 in the cache */
static const nir_search_expression search349 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search346_0.value, &search163_1.value },
   NULL,
};

   /* replace349_0 -> search3_0_0 in the cache */

/* replace349_1 -> search34_1 in the cache */
/* replace349 -> replace342 in the cache */

   /* search350_0_0 -> search3_0_0 in the cache */

/* search350_0_1 -> replace141_1_1 in the cache */
/* search350_0 -> search341_1_0 in the cache */

/* search350_1 -> search34_1 in the cache */
static const nir_search_expression search350 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search341_1_0.value, &search34_1.value },
   NULL,
};

   /* replace350_0 -> search3_0_0 in the cache */

/* replace350_1 -> search34_1 in the cache */
/* replace350 -> replace344 in the cache */

   /* search351_0_0 -> search3_0_0 in the cache */

/* search351_0_1 -> replace141_1_1 in the cache */
/* search351_0 -> search341_1_0 in the cache */

/* search351_1 -> search34_1 in the cache */
static const nir_search_expression search351 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search341_1_0.value, &search34_1.value },
   NULL,
};

   /* replace351_0 -> search3_0_0 in the cache */

/* replace351_1 -> search34_1 in the cache */
/* replace351 -> replace342 in the cache */

   /* search352_0_0 -> search3_0_0 in the cache */

/* search352_0_1 -> replace141_1_1 in the cache */
/* search352_0 -> search341_1_0 in the cache */

/* search352_1 -> search35_1 in the cache */
static const nir_search_expression search352 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search341_1_0.value, &search35_1.value },
   NULL,
};

   /* replace352_0 -> search3_0_0 in the cache */

/* replace352_1 -> search34_1 in the cache */
/* replace352 -> replace344 in the cache */

   /* search353_0_0 -> search3_0_0 in the cache */

/* search353_0_1 -> replace141_1_1 in the cache */
/* search353_0 -> search341_1_0 in the cache */

/* search353_1 -> search35_1 in the cache */
static const nir_search_expression search353 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search341_1_0.value, &search35_1.value },
   NULL,
};

   /* replace353_0 -> search3_0_0 in the cache */

/* replace353_1 -> search34_1 in the cache */
/* replace353 -> replace342 in the cache */

   /* search354_0 -> search93_0 in the cache */

/* search354_1_0_0 -> search93_0 in the cache */

/* search354_1_0_1 -> replace144_1_1 in the cache */
static const nir_search_expression search354_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &replace144_1_1.value },
   NULL,
};
static const nir_search_expression search354_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search354_1_0.value },
   NULL,
};
static const nir_search_expression search354 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search93_0.value, &search354_1.value },
   NULL,
};

   /* replace354_0 -> search93_0 in the cache */

/* replace354_1 -> replace142_2 in the cache */
static const nir_search_expression replace354 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* search355_0_0 -> search93_0 in the cache */

static const nir_search_constant search355_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
};
static const nir_search_expression search355_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search93_0.value, &search355_0_1.value },
   NULL,
};

/* search355_1 -> replace142_2 in the cache */
static const nir_search_expression search355 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search355_0.value, &replace142_2.value },
   NULL,
};

   /* replace355_0 -> search93_0 in the cache */

/* replace355_1 -> replace142_2 in the cache */
static const nir_search_expression replace355 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* search356_0_0 -> search93_0 in the cache */

/* search356_0_1 -> search355_0_1 in the cache */
/* search356_0 -> search355_0 in the cache */

/* search356_1 -> search355_0_1 in the cache */
static const nir_search_expression search356 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search355_0.value, &search355_0_1.value },
   NULL,
};

   /* replace356_0 -> search93_0 in the cache */

/* replace356_1 -> replace142_2 in the cache */
/* replace356 -> replace355 in the cache */

   /* search357_0_0 -> search93_0 in the cache */

/* search357_0_1 -> search355_0_1 in the cache */
/* search357_0 -> search355_0 in the cache */

/* search357_1 -> replace142_2 in the cache */
static const nir_search_expression search357 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search355_0.value, &replace142_2.value },
   NULL,
};

   /* replace357_0 -> search93_0 in the cache */

/* replace357_1 -> replace142_2 in the cache */
static const nir_search_expression replace357 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* search358_0_0 -> search93_0 in the cache */

/* search358_0_1 -> search355_0_1 in the cache */
/* search358_0 -> search355_0 in the cache */

/* search358_1 -> search355_0_1 in the cache */
static const nir_search_expression search358 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search355_0.value, &search355_0_1.value },
   NULL,
};

   /* replace358_0 -> search93_0 in the cache */

/* replace358_1 -> replace142_2 in the cache */
/* replace358 -> replace357 in the cache */

   /* search359_0_0 -> search93_0 in the cache */

/* search359_0_1 -> replace144_1_1 in the cache */
static const nir_search_expression search359_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &replace144_1_1.value },
   NULL,
};

/* search359_1 -> replace142_2 in the cache */
static const nir_search_expression search359 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search359_0.value, &replace142_2.value },
   NULL,
};

   /* replace359_0 -> search93_0 in the cache */

/* replace359_1 -> replace142_2 in the cache */
/* replace359 -> replace357 in the cache */

   /* search360_0_0 -> search93_0 in the cache */

/* search360_0_1 -> replace144_1_1 in the cache */
/* search360_0 -> search359_0 in the cache */

/* search360_1 -> replace142_2 in the cache */
static const nir_search_expression search360 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search359_0.value, &replace142_2.value },
   NULL,
};

   /* replace360_0 -> search93_0 in the cache */

/* replace360_1 -> replace142_2 in the cache */
/* replace360 -> replace355 in the cache */

   /* search361_0_0 -> search93_0 in the cache */

/* search361_0_1 -> replace144_1_1 in the cache */
/* search361_0 -> search359_0 in the cache */

static const nir_search_constant search361_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression search361 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search359_0.value, &search361_1.value },
   NULL,
};

   /* replace361_0 -> search93_0 in the cache */

/* replace361_1 -> replace142_2 in the cache */
/* replace361 -> replace357 in the cache */

   /* search362_0_0 -> search93_0 in the cache */

/* search362_0_1 -> replace144_1_1 in the cache */
/* search362_0 -> search359_0 in the cache */

/* search362_1 -> search361_1 in the cache */
static const nir_search_expression search362 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search359_0.value, &search361_1.value },
   NULL,
};

   /* replace362_0 -> search93_0 in the cache */

/* replace362_1 -> replace142_2 in the cache */
/* replace362 -> replace355 in the cache */

   /* search363_0_0 -> search93_0 in the cache */

/* search363_0_1 -> replace144_1_1 in the cache */
/* search363_0 -> search354_1_0 in the cache */

/* search363_1 -> replace142_2 in the cache */
static const nir_search_expression search363 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search354_1_0.value, &replace142_2.value },
   NULL,
};

   /* replace363_0 -> search93_0 in the cache */

/* replace363_1 -> replace142_2 in the cache */
/* replace363 -> replace357 in the cache */

   /* search364_0_0 -> search93_0 in the cache */

/* search364_0_1 -> replace144_1_1 in the cache */
/* search364_0 -> search354_1_0 in the cache */

/* search364_1 -> replace142_2 in the cache */
static const nir_search_expression search364 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search354_1_0.value, &replace142_2.value },
   NULL,
};

   /* replace364_0 -> search93_0 in the cache */

/* replace364_1 -> replace142_2 in the cache */
/* replace364 -> replace355 in the cache */

   /* search365_0_0 -> search93_0 in the cache */

/* search365_0_1 -> replace144_1_1 in the cache */
/* search365_0 -> search354_1_0 in the cache */

static const nir_search_constant search365_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search365 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search354_1_0.value, &search365_1.value },
   NULL,
};

   /* replace365_0 -> search93_0 in the cache */

/* replace365_1 -> replace142_2 in the cache */
/* replace365 -> replace357 in the cache */

   /* search366_0_0 -> search93_0 in the cache */

/* search366_0_1 -> replace144_1_1 in the cache */
/* search366_0 -> search354_1_0 in the cache */

/* search366_1 -> search365_1 in the cache */
static const nir_search_expression search366 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search354_1_0.value, &search365_1.value },
   NULL,
};

   /* replace366_0 -> search93_0 in the cache */

/* replace366_1 -> replace142_2 in the cache */
/* replace366 -> replace355 in the cache */

   /* search367_0 -> search2_0 in the cache */

/* search367_1_0 -> search2_0 in the cache */
/* search367_1 -> search22_0 in the cache */
static const nir_search_expression search367 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search2_0.value, &search22_0.value },
   NULL,
};

   /* replace367_0_0 -> search2_0 in the cache */
/* replace367_0 -> replace24 in the cache */
/* replace367 -> search266_0 in the cache */

   /* search368_0 -> search2_0 in the cache */

/* search368_1_0 -> search2_0 in the cache */
/* search368_1 -> search23_0 in the cache */
static const nir_search_expression search368 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search23_0.value },
   NULL,
};

   /* replace368_0_0 -> search2_0 in the cache */
/* replace368_0 -> search26_0 in the cache */
static const nir_search_expression replace368 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search26_0.value },
   NULL,
};

   /* search369_0 -> search2_0 in the cache */

/* search369_1_0_0 -> search2_0 in the cache */
/* search369_1_0 -> replace24 in the cache */
/* search369_1 -> search266_0 in the cache */
static const nir_search_expression search369 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search2_0.value, &search266_0.value },
   NULL,
};

   /* replace369_0_0 -> search2_0 in the cache */
/* replace369_0 -> replace24 in the cache */
/* replace369 -> search266_0 in the cache */

   /* search370_0 -> search2_0 in the cache */

/* search370_1_0_0 -> search2_0 in the cache */
/* search370_1_0 -> search26_0 in the cache */
/* search370_1 -> replace368 in the cache */
static const nir_search_expression search370 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &replace368.value },
   NULL,
};

   /* replace370_0_0 -> search2_0 in the cache */
/* replace370_0 -> search26_0 in the cache */
/* replace370 -> replace368 in the cache */

   /* search371_0 -> search2_0 in the cache */

/* search371_1_0 -> search2_0 in the cache */
/* search371_1 -> replace24 in the cache */
static const nir_search_expression search371 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search2_0.value, &replace24.value },
   NULL,
};

   /* replace371 -> search2_0 in the cache */

   /* search372_0 -> search2_0 in the cache */

/* search372_1_0 -> search2_0 in the cache */
/* search372_1 -> search26_0 in the cache */
static const nir_search_expression search372 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search26_0.value },
   NULL,
};

   /* replace372 -> search2_0 in the cache */

   /* search373_0 -> search2_0 in the cache */

/* search373_1_0_0 -> search2_0 in the cache */
/* search373_1_0 -> replace24 in the cache */
/* search373_1 -> search266_0 in the cache */
static const nir_search_expression search373 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmax,
   { &search2_0.value, &search266_0.value },
   NULL,
};

   /* replace373 -> search2_0 in the cache */

   /* search374_0 -> search2_0 in the cache */

/* search374_1_0_0 -> search2_0 in the cache */
/* search374_1_0 -> search26_0 in the cache */
/* search374_1 -> replace368 in the cache */
static const nir_search_expression search374 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &replace368.value },
   NULL,
};

   /* replace374 -> search2_0 in the cache */

   /* search375_0 -> search2_0 in the cache */

/* search375_1_0 -> search2_0 in the cache */
/* search375_1 -> replace24 in the cache */
static const nir_search_expression search375 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search2_0.value, &replace24.value },
   NULL,
};

   /* replace375_0 -> search2_0 in the cache */
/* replace375 -> replace24 in the cache */

   /* search376_0 -> search2_0 in the cache */

/* search376_1_0 -> search2_0 in the cache */
/* search376_1 -> search26_0 in the cache */
static const nir_search_expression search376 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search26_0.value },
   NULL,
};

   /* replace376_0 -> search2_0 in the cache */
/* replace376 -> search26_0 in the cache */

   /* search377_0 -> search2_0 in the cache */

/* search377_1_0 -> search2_0 in the cache */
/* search377_1 -> search22_0 in the cache */
static const nir_search_expression search377 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search2_0.value, &search22_0.value },
   NULL,
};

   /* replace377_0 -> search2_0 in the cache */
/* replace377 -> replace24 in the cache */

   /* search378_0 -> search2_0 in the cache */

/* search378_1_0 -> search2_0 in the cache */
/* search378_1 -> search23_0 in the cache */
static const nir_search_expression search378 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search23_0.value },
   NULL,
};

   /* replace378_0 -> search2_0 in the cache */
/* replace378 -> search26_0 in the cache */

   /* search379_0_0 -> search2_0 in the cache */
/* search379_0 -> replace24 in the cache */

/* search379_1 -> search30_1 in the cache */
static const nir_search_expression search379 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmax,
   { &replace24.value, &search30_1.value },
   NULL,
};

   /* replace379_0 -> search2_0 in the cache */
/* replace379 -> replace24 in the cache */

   /* search380_0_0 -> search2_0 in the cache */

/* search380_0_1 -> search30_1 in the cache */
static const nir_search_expression search380_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search2_0.value, &search30_1.value },
   NULL,
};

/* search380_1 -> search53_1 in the cache */
static const nir_search_expression search380 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &search380_0.value, &search53_1.value },
   NULL,
};

   /* replace380_0 -> search2_0 in the cache */
/* replace380 -> search46_0 in the cache */

   /* search381_0_0 -> search2_0 in the cache */

/* search381_0_1 -> search53_1 in the cache */
static const nir_search_expression search381_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search2_0.value, &search53_1.value },
   NULL,
};

/* search381_1 -> search30_1 in the cache */
static const nir_search_expression search381 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmax,
   { &search381_0.value, &search30_1.value },
   NULL,
};

   /* replace381_0 -> search2_0 in the cache */
/* replace381 -> search46_0 in the cache */

   /* search382_0_0 -> search2_0 in the cache */

/* search382_0_1 -> search56_1 in the cache */
static const nir_search_expression search382_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmax,
   { &search2_0.value, &search56_1.value },
   NULL,
};

/* search382_1 -> search30_1 in the cache */
static const nir_search_expression search382 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmin,
   { &search382_0.value, &search30_1.value },
   NULL,
};

   /* replace382_0_0_0 -> search2_0 in the cache */
/* replace382_0_0 -> search22_0 in the cache */
/* replace382_0 -> search46_1 in the cache */
static const nir_search_expression replace382 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search46_1.value },
   NULL,
};

   /* search383_0_0 -> search2_0 in the cache */

/* search383_0_1 -> search30_1 in the cache */
static const nir_search_expression search383_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmin,
   { &search2_0.value, &search30_1.value },
   NULL,
};

/* search383_1 -> search56_1 in the cache */
static const nir_search_expression search383 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 2,
   nir_op_fmax,
   { &search383_0.value, &search56_1.value },
   NULL,
};

   /* replace383_0_0_0 -> search2_0 in the cache */
/* replace383_0_0 -> search22_0 in the cache */
/* replace383_0 -> search46_1 in the cache */
/* replace383 -> replace382 in the cache */

   /* search384_0_0 -> search2_0 in the cache */
/* search384_0 -> search58_0 in the cache */
static const nir_search_expression search384 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search58_0.value },
   NULL,
};

   /* replace384_0_0 -> search30_1 in the cache */

/* replace384_0_1 -> search2_0 in the cache */
static const nir_search_expression replace384_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search30_1.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace384 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace384_0.value },
   NULL,
};

   /* search385_0_0 -> search2_0 in the cache */
static const nir_search_expression search385_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search385 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search385_0.value },
   NULL,
};

   /* replace385_0 -> search2_0 in the cache */
/* replace385 -> search385_0 in the cache */

   /* search386_0 -> search2_0 in the cache */
/* search386 -> search46_0 in the cache */

   /* replace386_0_0 -> search2_0 in the cache */

/* replace386_0_1 -> search30_1 in the cache */
/* replace386_0 -> search380_0 in the cache */

/* replace386_1 -> search53_1 in the cache */
/* replace386 -> search380 in the cache */

   /* search387_0_0 -> search2_0 in the cache */
/* search387_0 -> search46_0 in the cache */
static const nir_search_expression search387 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search46_0.value },
   NULL,
};

   /* replace387_0 -> search2_0 in the cache */
/* replace387 -> search46_0 in the cache */

   /* search388_0_0_0 -> search0_0 in the cache */

/* search388_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search388_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search388_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search388_0_0.value },
   (is_used_once),
};
static const nir_search_expression search388 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search388_0.value },
   NULL,
};

   /* replace388_0_0_0 -> search0_0 in the cache */
/* replace388_0_0 -> search44_0 in the cache */

/* replace388_0_1_0 -> replace0_1_0 in the cache */
/* replace388_0_1 -> search194_1 in the cache */
static const nir_search_expression replace388_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search44_0.value, &search194_1.value },
   NULL,
};
static const nir_search_expression replace388 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace388_0.value },
   NULL,
};

   /* search389_0_0_0 -> search0_0 in the cache */

/* search389_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search389_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search389_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search389_0_0.value },
   (is_used_once),
};
static const nir_search_expression search389 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search389_0.value },
   NULL,
};

   /* replace389_0_0_0 -> search0_0 in the cache */
/* replace389_0_0 -> search44_0 in the cache */

/* replace389_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace389_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search44_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace389 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace389_0.value },
   NULL,
};

   /* search390_0_0_0 -> search0_0 in the cache */

/* search390_0_0_1 -> replace0_1_0 in the cache */
/* search390_0_0 -> search389_0_0 in the cache */
static const nir_search_expression search390_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search389_0_0.value },
   (is_used_once),
};
static const nir_search_expression search390 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search390_0.value },
   NULL,
};

   /* replace390_0_0_0 -> search0_0 in the cache */
static const nir_search_expression replace390_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search0_0.value },
   NULL,
};

/* replace390_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace390_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace390_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace390_0_0.value, &replace390_0_1.value },
   NULL,
};
static const nir_search_expression replace390 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace390_0.value },
   NULL,
};

   /* search391_0_0_0_0 -> search36_0_0 in the cache */

/* search391_0_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search391_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_fmax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search391_0_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search391_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_fmin,
   { &search391_0_0_0.value, &search36_1_1.value },
   NULL,
};

/* search391_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search391_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_fmax,
   { &search391_0_0.value, &search36_0_1.value },
   NULL,
};

/* search391_1 -> search36_1_1 in the cache */
static const nir_search_expression search391 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_fmin,
   { &search391_0.value, &search36_1_1.value },
   NULL,
};

   /* replace391_0_0 -> search36_0_0 in the cache */

/* replace391_0_1 -> search36_0_1 in the cache */
/* replace391_0 -> replace309_0 in the cache */

/* replace391_1 -> search36_1_1 in the cache */
static const nir_search_expression replace391 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmin,
   { &replace309_0.value, &search36_1_1.value },
   NULL,
};

   /* search392_0_0_0_0 -> search36_0_0 in the cache */

/* search392_0_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search392_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_imax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search392_0_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search392_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_imin,
   { &search392_0_0_0.value, &search36_1_1.value },
   NULL,
};

/* search392_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search392_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_imax,
   { &search392_0_0.value, &search36_0_1.value },
   NULL,
};

/* search392_1 -> search36_1_1 in the cache */
static const nir_search_expression search392 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_imin,
   { &search392_0.value, &search36_1_1.value },
   NULL,
};

   /* replace392_0_0 -> search36_0_0 in the cache */

/* replace392_0_1 -> search36_0_1 in the cache */
/* replace392_0 -> replace311_0 in the cache */

/* replace392_1 -> search36_1_1 in the cache */
static const nir_search_expression replace392 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace311_0.value, &search36_1_1.value },
   NULL,
};

   /* search393_0_0_0_0 -> search36_0_0 in the cache */

/* search393_0_0_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search393_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_umax,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* search393_0_0_1 -> search36_1_1 in the cache */
static const nir_search_expression search393_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_umin,
   { &search393_0_0_0.value, &search36_1_1.value },
   NULL,
};

/* search393_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search393_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_umax,
   { &search393_0_0.value, &search36_0_1.value },
   NULL,
};

/* search393_1 -> search36_1_1 in the cache */
static const nir_search_expression search393 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_umin,
   { &search393_0.value, &search36_1_1.value },
   NULL,
};

   /* replace393_0_0 -> search36_0_0 in the cache */

/* replace393_0_1 -> search36_0_1 in the cache */
/* replace393_0 -> replace310_0 in the cache */

/* replace393_1 -> search36_1_1 in the cache */
static const nir_search_expression replace393 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace310_0.value, &search36_1_1.value },
   NULL,
};

   /* search394_0_0 -> search0_0 in the cache */
static const nir_search_expression search394_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search394_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_zero_to_one),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search394 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search394_0.value, &search394_1.value },
   NULL,
};

   /* replace394_0_0 -> search0_0 in the cache */

/* replace394_0_1 -> replace0_1_0 in the cache */
/* replace394_0 -> replace278 in the cache */
static const nir_search_expression replace394 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace278.value },
   NULL,
};

   /* search395_0_0 -> search0_0 in the cache */
/* search395_0 -> search394_0 in the cache */

/* search395_1 -> search394_1 in the cache */
static const nir_search_expression search395 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search394_0.value, &search394_1.value },
   NULL,
};

   /* replace395_0_0 -> search0_0 in the cache */

/* replace395_0_1 -> replace0_1_0 in the cache */
/* replace395_0 -> replace279 in the cache */
static const nir_search_expression replace395 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace279.value },
   NULL,
};

   static const nir_search_variable search396_0_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search396_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search396_0_0_0.value },
   NULL,
};

/* search396_0_1 -> search394_1 in the cache */
static const nir_search_expression search396_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search396_0_0.value, &search394_1.value },
   (is_used_once),
};

/* search396_1 -> search60_0 in the cache */
static const nir_search_expression search396 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search396_0.value, &search60_0.value },
   NULL,
};

   /* replace396_0_0_0 -> search0_0 in the cache */
/* replace396_0_0 -> search44_0 in the cache */

/* replace396_0_1 -> replace0_1_0 in the cache */
/* replace396_0 -> replace67 in the cache */
static const nir_search_expression replace396 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace67.value },
   NULL,
};

   /* search397_0_0_0 -> search2_0 in the cache */

/* search397_0_0_1 -> replace9 in the cache */
static const nir_search_expression search397_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search2_0.value, &replace9.value },
   NULL,
};

static const nir_search_constant search397_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression search397_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search397_0_0.value, &search397_0_1.value },
   NULL,
};

/* search397_1 -> replace9 in the cache */
static const nir_search_expression search397 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_extract_u8,
   { &search397_0.value, &replace9.value },
   NULL,
};

   /* replace397_0_0 -> search2_0 in the cache */

/* replace397_0_1 -> replace9 in the cache */
/* replace397_0 -> search397_0_0 in the cache */

/* replace397_1 -> search397_0_1 in the cache */
/* replace397 -> search397_0 in the cache */

   /* search398_0_0 -> search36_0_0 in the cache */

/* search398_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search398_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search398_1_0 -> search36_0_0 in the cache */

/* search398_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search398_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search398 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search398_0.value, &search398_1.value },
   NULL,
};

   /* replace398_0 -> search36_0_0 in the cache */

/* replace398_1_0 -> search36_0_1 in the cache */

/* replace398_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace398_1 = {
   { nir_search_value_expression, -3 },
   false, true,
   0, 1,
   nir_op_fmax,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace398 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search36_0_0.value, &replace398_1.value },
   NULL,
};

   /* search399_0_0 -> search0_0 in the cache */

/* search399_0_1 -> search104_2 in the cache */
static const nir_search_expression search399_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

static const nir_search_variable search399_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search399_1_1 -> search104_2 in the cache */
static const nir_search_expression search399_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search399 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search399_0.value, &search399_1.value },
   NULL,
};

   /* replace399_0_0 -> search0_0 in the cache */

/* replace399_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace399_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace399_1 -> search104_2 in the cache */
static const nir_search_expression replace399 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace399_0.value, &search104_2.value },
   NULL,
};

   /* search400_0_0 -> search36_0_0 in the cache */

/* search400_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search400_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search400_1_0 -> search36_0_0 in the cache */

/* search400_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search400_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search400 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search400_0.value, &search400_1.value },
   NULL,
};

   /* replace400_0 -> search36_0_0 in the cache */

/* replace400_1_0 -> search36_0_1 in the cache */

/* replace400_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace400_1 = {
   { nir_search_value_expression, -3 },
   false, true,
   0, 1,
   nir_op_fmin,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace400 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search36_0_0.value, &replace400_1.value },
   NULL,
};

   /* search401_0_0 -> search0_0 in the cache */

/* search401_0_1 -> search104_2 in the cache */
static const nir_search_expression search401_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

/* search401_1_0 -> search399_1_0 in the cache */

/* search401_1_1 -> search104_2 in the cache */
static const nir_search_expression search401_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search401 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search401_0.value, &search401_1.value },
   NULL,
};

   /* replace401_0_0 -> search0_0 in the cache */

/* replace401_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace401_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace401_1 -> search104_2 in the cache */
static const nir_search_expression replace401 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace401_0.value, &search104_2.value },
   NULL,
};

   /* search402_0_0 -> search36_0_0 in the cache */

/* search402_0_1 -> search131_0_0_1 in the cache */
static const nir_search_expression search402_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search131_0_0_1.value },
   NULL,
};

/* search402_1_0 -> search36_0_0 in the cache */

/* search402_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search402_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search402 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search402_0.value, &search402_1.value },
   NULL,
};

   /* replace402_0 -> search36_0_0 in the cache */

/* replace402_1_0 -> search36_0_1 in the cache */

/* replace402_1_1 -> search36_1_1 in the cache */
/* replace402_1 -> replace398_1 in the cache */
/* replace402 -> replace398 in the cache */

   static const nir_search_variable search403_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search403_0_1 -> search104_2 in the cache */
static const nir_search_expression search403_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search403_0_0.value, &search104_2.value },
   NULL,
};

static const nir_search_variable search403_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search403_1_1 -> search104_2 in the cache */
static const nir_search_expression search403_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search403_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search403 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search403_0.value, &search403_1.value },
   NULL,
};

   /* replace403_0_0 -> search0_0 in the cache */

/* replace403_0_1 -> search399_1_0 in the cache */
/* replace403_0 -> replace399_0 in the cache */

/* replace403_1 -> search104_2 in the cache */
/* replace403 -> replace399 in the cache */

   /* search404_0_0 -> search36_0_0 in the cache */

/* search404_0_1 -> search131_0_0_1 in the cache */
static const nir_search_expression search404_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search131_0_0_1.value },
   NULL,
};

/* search404_1_0 -> search36_0_0 in the cache */

/* search404_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search404_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search404 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search404_0.value, &search404_1.value },
   NULL,
};

   /* replace404_0 -> search36_0_0 in the cache */

/* replace404_1_0 -> search36_0_1 in the cache */

/* replace404_1_1 -> search36_1_1 in the cache */
/* replace404_1 -> replace400_1 in the cache */
/* replace404 -> replace400 in the cache */

   /* search405_0_0 -> search403_0_0 in the cache */

/* search405_0_1 -> search104_2 in the cache */
static const nir_search_expression search405_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search403_0_0.value, &search104_2.value },
   NULL,
};

/* search405_1_0 -> search403_1_0 in the cache */

/* search405_1_1 -> search104_2 in the cache */
static const nir_search_expression search405_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search403_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search405 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search405_0.value, &search405_1.value },
   NULL,
};

   /* replace405_0_0 -> search0_0 in the cache */

/* replace405_0_1 -> search399_1_0 in the cache */
/* replace405_0 -> replace401_0 in the cache */

/* replace405_1 -> search104_2 in the cache */
/* replace405 -> replace401 in the cache */

   /* search406_0_0 -> search36_0_0 in the cache */

/* search406_0_1 -> search36_0_1 in the cache */
/* search406_0 -> search398_0 in the cache */

/* search406_1_0 -> search36_0_0 in the cache */

/* search406_1_1 -> search36_1_1 in the cache */
/* search406_1 -> search398_1 in the cache */
static const nir_search_expression search406 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search398_0.value, &search398_1.value },
   NULL,
};

   /* replace406_0 -> search36_0_0 in the cache */

/* replace406_1_0 -> search36_0_1 in the cache */

/* replace406_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace406_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace406 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search36_0_0.value, &replace406_1.value },
   NULL,
};

   /* search407_0_0 -> search0_0 in the cache */

/* search407_0_1 -> search104_2 in the cache */
/* search407_0 -> search399_0 in the cache */

/* search407_1_0 -> search399_1_0 in the cache */

/* search407_1_1 -> search104_2 in the cache */
/* search407_1 -> search399_1 in the cache */
static const nir_search_expression search407 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search399_0.value, &search399_1.value },
   NULL,
};

   /* replace407_0_0 -> search0_0 in the cache */

/* replace407_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace407_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace407_1 -> search104_2 in the cache */
static const nir_search_expression replace407 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace407_0.value, &search104_2.value },
   NULL,
};

   /* search408_0_0 -> search36_0_0 in the cache */

/* search408_0_1 -> search36_0_1 in the cache */
/* search408_0 -> search400_0 in the cache */

/* search408_1_0 -> search36_0_0 in the cache */

/* search408_1_1 -> search36_1_1 in the cache */
/* search408_1 -> search400_1 in the cache */
static const nir_search_expression search408 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search400_0.value, &search400_1.value },
   NULL,
};

   /* replace408_0 -> search36_0_0 in the cache */

/* replace408_1_0 -> search36_0_1 in the cache */

/* replace408_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace408_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace408 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search36_0_0.value, &replace408_1.value },
   NULL,
};

   /* search409_0_0 -> search0_0 in the cache */

/* search409_0_1 -> search104_2 in the cache */
/* search409_0 -> search401_0 in the cache */

/* search409_1_0 -> search399_1_0 in the cache */

/* search409_1_1 -> search104_2 in the cache */
/* search409_1 -> search401_1 in the cache */
static const nir_search_expression search409 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search401_0.value, &search401_1.value },
   NULL,
};

   /* replace409_0_0 -> search0_0 in the cache */

/* replace409_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace409_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace409_1 -> search104_2 in the cache */
static const nir_search_expression replace409 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace409_0.value, &search104_2.value },
   NULL,
};

   /* search410_0_0 -> search36_0_0 in the cache */

static const nir_search_variable search410_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search410_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search410_0_1.value },
   NULL,
};

/* search410_1_0 -> search36_0_0 in the cache */

static const nir_search_variable search410_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search410_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search36_0_0.value, &search410_1_1.value },
   NULL,
};
static const nir_search_expression search410 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search410_0.value, &search410_1.value },
   NULL,
};

   /* replace410_0 -> search36_0_0 in the cache */

/* replace410_1_0 -> search36_0_1 in the cache */

/* replace410_1_1 -> search36_1_1 in the cache */
/* replace410_1 -> replace406_1 in the cache */
/* replace410 -> replace406 in the cache */

   static const nir_search_variable search411_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search411_0_1 -> search104_2 in the cache */
static const nir_search_expression search411_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search411_0_0.value, &search104_2.value },
   NULL,
};

static const nir_search_variable search411_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search411_1_1 -> search104_2 in the cache */
static const nir_search_expression search411_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search411_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search411 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search411_0.value, &search411_1.value },
   NULL,
};

   /* replace411_0_0 -> search0_0 in the cache */

/* replace411_0_1 -> search399_1_0 in the cache */
/* replace411_0 -> replace407_0 in the cache */

/* replace411_1 -> search104_2 in the cache */
/* replace411 -> replace407 in the cache */

   /* search412_0_0 -> search36_0_0 in the cache */

/* search412_0_1 -> search410_0_1 in the cache */
static const nir_search_expression search412_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search410_0_1.value },
   NULL,
};

/* search412_1_0 -> search36_0_0 in the cache */

/* search412_1_1 -> search410_1_1 in the cache */
static const nir_search_expression search412_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search36_0_0.value, &search410_1_1.value },
   NULL,
};
static const nir_search_expression search412 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search412_0.value, &search412_1.value },
   NULL,
};

   /* replace412_0 -> search36_0_0 in the cache */

/* replace412_1_0 -> search36_0_1 in the cache */

/* replace412_1_1 -> search36_1_1 in the cache */
/* replace412_1 -> replace408_1 in the cache */
/* replace412 -> replace408 in the cache */

   /* search413_0_0 -> search411_0_0 in the cache */

/* search413_0_1 -> search104_2 in the cache */
static const nir_search_expression search413_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search411_0_0.value, &search104_2.value },
   NULL,
};

/* search413_1_0 -> search411_1_0 in the cache */

/* search413_1_1 -> search104_2 in the cache */
static const nir_search_expression search413_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search411_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search413 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search413_0.value, &search413_1.value },
   NULL,
};

   /* replace413_0_0 -> search0_0 in the cache */

/* replace413_0_1 -> search399_1_0 in the cache */
/* replace413_0 -> replace409_0 in the cache */

/* replace413_1 -> search104_2 in the cache */
/* replace413 -> replace409 in the cache */

   /* search414_0_0 -> search36_0_0 in the cache */

/* search414_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search414_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search414_1_0 -> search36_0_0 in the cache */

/* search414_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search414_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search414 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search414_0.value, &search414_1.value },
   NULL,
};

   /* replace414_0 -> search36_0_0 in the cache */

/* replace414_1_0 -> search36_0_1 in the cache */

/* replace414_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace414_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace414 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search36_0_0.value, &replace414_1.value },
   NULL,
};

   /* search415_0_0 -> search0_0 in the cache */

/* search415_0_1 -> search104_2 in the cache */
static const nir_search_expression search415_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

/* search415_1_0 -> search399_1_0 in the cache */

/* search415_1_1 -> search104_2 in the cache */
static const nir_search_expression search415_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search415 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search415_0.value, &search415_1.value },
   NULL,
};

   /* replace415_0_0 -> search0_0 in the cache */

/* replace415_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace415_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace415_1 -> search104_2 in the cache */
static const nir_search_expression replace415 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace415_0.value, &search104_2.value },
   NULL,
};

   /* search416_0_0 -> search36_0_0 in the cache */

/* search416_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search416_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search416_1_0 -> search36_0_0 in the cache */

/* search416_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search416_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search416 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search416_0.value, &search416_1.value },
   NULL,
};

   /* replace416_0 -> search36_0_0 in the cache */

/* replace416_1_0 -> search36_0_1 in the cache */

/* replace416_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace416_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace416 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search36_0_0.value, &replace416_1.value },
   NULL,
};

   /* search417_0_0 -> search0_0 in the cache */

/* search417_0_1 -> search104_2 in the cache */
static const nir_search_expression search417_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

/* search417_1_0 -> search399_1_0 in the cache */

/* search417_1_1 -> search104_2 in the cache */
static const nir_search_expression search417_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search417 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search417_0.value, &search417_1.value },
   NULL,
};

   /* replace417_0_0 -> search0_0 in the cache */

/* replace417_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace417_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace417_1 -> search104_2 in the cache */
static const nir_search_expression replace417 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace417_0.value, &search104_2.value },
   NULL,
};

   /* search418_0_0 -> search36_0_0 in the cache */

/* search418_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search418_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search418_1_0 -> search36_0_0 in the cache */

/* search418_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search418_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search418 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search418_0.value, &search418_1.value },
   NULL,
};

   /* replace418_0 -> search36_0_0 in the cache */

/* replace418_1_0 -> search36_0_1 in the cache */

/* replace418_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace418_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace418 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search36_0_0.value, &replace418_1.value },
   NULL,
};

   /* search419_0_0 -> search0_0 in the cache */

/* search419_0_1 -> search104_2 in the cache */
static const nir_search_expression search419_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

/* search419_1_0 -> search399_1_0 in the cache */

/* search419_1_1 -> search104_2 in the cache */
static const nir_search_expression search419_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search419 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search419_0.value, &search419_1.value },
   NULL,
};

   /* replace419_0_0 -> search0_0 in the cache */

/* replace419_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace419_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace419_1 -> search104_2 in the cache */
static const nir_search_expression replace419 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace419_0.value, &search104_2.value },
   NULL,
};

   /* search420_0_0 -> search36_0_0 in the cache */

/* search420_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search420_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search36_0_0.value, &search36_0_1.value },
   (is_used_once),
};

/* search420_1_0 -> search36_0_0 in the cache */

/* search420_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search420_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search420 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search420_0.value, &search420_1.value },
   NULL,
};

   /* replace420_0 -> search36_0_0 in the cache */

/* replace420_1_0 -> search36_0_1 in the cache */

/* replace420_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace420_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace420 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search36_0_0.value, &replace420_1.value },
   NULL,
};

   /* search421_0_0 -> search0_0 in the cache */

/* search421_0_1 -> search104_2 in the cache */
static const nir_search_expression search421_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search104_2.value },
   (is_used_once),
};

/* search421_1_0 -> search399_1_0 in the cache */

/* search421_1_1 -> search104_2 in the cache */
static const nir_search_expression search421_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search399_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search421 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search421_0.value, &search421_1.value },
   NULL,
};

   /* replace421_0_0 -> search0_0 in the cache */

/* replace421_0_1 -> search399_1_0 in the cache */
static const nir_search_expression replace421_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search0_0.value, &search399_1_0.value },
   NULL,
};

/* replace421_1 -> search104_2 in the cache */
static const nir_search_expression replace421 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace421_0.value, &search104_2.value },
   NULL,
};

   /* search422_0_0 -> search36_0_0 in the cache */

/* search422_0_1 -> search36_0_1 in the cache */
/* search422_0 -> search414_0 in the cache */

/* search422_1_0 -> search36_0_0 in the cache */

/* search422_1_1 -> search36_1_1 in the cache */
/* search422_1 -> search414_1 in the cache */
static const nir_search_expression search422 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search414_0.value, &search414_1.value },
   NULL,
};

   /* replace422_0 -> search36_0_0 in the cache */

/* replace422_1_0 -> search36_0_1 in the cache */

/* replace422_1_1 -> search36_1_1 in the cache */
/* replace422_1 -> replace416_1 in the cache */
static const nir_search_expression replace422 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search36_0_0.value, &replace416_1.value },
   NULL,
};

   /* search423_0_0 -> search0_0 in the cache */

/* search423_0_1 -> search104_2 in the cache */
/* search423_0 -> search415_0 in the cache */

/* search423_1_0 -> search399_1_0 in the cache */

/* search423_1_1 -> search104_2 in the cache */
/* search423_1 -> search415_1 in the cache */
static const nir_search_expression search423 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search415_0.value, &search415_1.value },
   NULL,
};

   /* replace423_0_0 -> search0_0 in the cache */

/* replace423_0_1 -> search399_1_0 in the cache */
/* replace423_0 -> replace417_0 in the cache */

/* replace423_1 -> search104_2 in the cache */
static const nir_search_expression replace423 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace417_0.value, &search104_2.value },
   NULL,
};

   /* search424_0_0 -> search36_0_0 in the cache */

/* search424_0_1 -> search36_0_1 in the cache */
/* search424_0 -> search416_0 in the cache */

/* search424_1_0 -> search36_0_0 in the cache */

/* search424_1_1 -> search36_1_1 in the cache */
/* search424_1 -> search416_1 in the cache */
static const nir_search_expression search424 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search416_0.value, &search416_1.value },
   NULL,
};

   /* replace424_0 -> search36_0_0 in the cache */

/* replace424_1_0 -> search36_0_1 in the cache */

/* replace424_1_1 -> search36_1_1 in the cache */
/* replace424_1 -> replace414_1 in the cache */
static const nir_search_expression replace424 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search36_0_0.value, &replace414_1.value },
   NULL,
};

   /* search425_0_0 -> search0_0 in the cache */

/* search425_0_1 -> search104_2 in the cache */
/* search425_0 -> search417_0 in the cache */

/* search425_1_0 -> search399_1_0 in the cache */

/* search425_1_1 -> search104_2 in the cache */
/* search425_1 -> search417_1 in the cache */
static const nir_search_expression search425 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search417_0.value, &search417_1.value },
   NULL,
};

   /* replace425_0_0 -> search0_0 in the cache */

/* replace425_0_1 -> search399_1_0 in the cache */
/* replace425_0 -> replace415_0 in the cache */

/* replace425_1 -> search104_2 in the cache */
static const nir_search_expression replace425 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace415_0.value, &search104_2.value },
   NULL,
};

   /* search426_0_0 -> search36_0_0 in the cache */

/* search426_0_1 -> search36_0_1 in the cache */
/* search426_0 -> search418_0 in the cache */

/* search426_1_0 -> search36_0_0 in the cache */

/* search426_1_1 -> search36_1_1 in the cache */
/* search426_1 -> search418_1 in the cache */
static const nir_search_expression search426 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search418_0.value, &search418_1.value },
   NULL,
};

   /* replace426_0 -> search36_0_0 in the cache */

/* replace426_1_0 -> search36_0_1 in the cache */

/* replace426_1_1 -> search36_1_1 in the cache */
/* replace426_1 -> replace420_1 in the cache */
static const nir_search_expression replace426 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search36_0_0.value, &replace420_1.value },
   NULL,
};

   /* search427_0_0 -> search0_0 in the cache */

/* search427_0_1 -> search104_2 in the cache */
/* search427_0 -> search419_0 in the cache */

/* search427_1_0 -> search399_1_0 in the cache */

/* search427_1_1 -> search104_2 in the cache */
/* search427_1 -> search419_1 in the cache */
static const nir_search_expression search427 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search419_0.value, &search419_1.value },
   NULL,
};

   /* replace427_0_0 -> search0_0 in the cache */

/* replace427_0_1 -> search399_1_0 in the cache */
/* replace427_0 -> replace421_0 in the cache */

/* replace427_1 -> search104_2 in the cache */
static const nir_search_expression replace427 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace421_0.value, &search104_2.value },
   NULL,
};

   /* search428_0_0 -> search36_0_0 in the cache */

/* search428_0_1 -> search36_0_1 in the cache */
/* search428_0 -> search420_0 in the cache */

/* search428_1_0 -> search36_0_0 in the cache */

/* search428_1_1 -> search36_1_1 in the cache */
/* search428_1 -> search420_1 in the cache */
static const nir_search_expression search428 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search420_0.value, &search420_1.value },
   NULL,
};

   /* replace428_0 -> search36_0_0 in the cache */

/* replace428_1_0 -> search36_0_1 in the cache */

/* replace428_1_1 -> search36_1_1 in the cache */
/* replace428_1 -> replace418_1 in the cache */
static const nir_search_expression replace428 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search36_0_0.value, &replace418_1.value },
   NULL,
};

   /* search429_0_0 -> search0_0 in the cache */

/* search429_0_1 -> search104_2 in the cache */
/* search429_0 -> search421_0 in the cache */

/* search429_1_0 -> search399_1_0 in the cache */

/* search429_1_1 -> search104_2 in the cache */
/* search429_1 -> search421_1 in the cache */
static const nir_search_expression search429 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search421_0.value, &search421_1.value },
   NULL,
};

   /* replace429_0_0 -> search0_0 in the cache */

/* replace429_0_1 -> search399_1_0 in the cache */
/* replace429_0 -> replace419_0 in the cache */

/* replace429_1 -> search104_2 in the cache */
static const nir_search_expression replace429 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace419_0.value, &search104_2.value },
   NULL,
};

   /* search430_0_0_0 -> search0_0 in the cache */

/* search430_0_0_1 -> search104_2 in the cache */
/* search430_0_0 -> search399_0 in the cache */

static const nir_search_variable search430_0_1 = {
   { nir_search_value_variable, 1 },
   2, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search430_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search399_0.value, &search430_0_1.value },
   (is_used_once),
};

static const nir_search_variable search430_1_0 = {
   { nir_search_value_variable, -2 },
   3, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search430_1_1 -> search104_2 in the cache */
static const nir_search_expression search430_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search430_1_0.value, &search104_2.value },
   NULL,
};
static const nir_search_expression search430 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search430_0.value, &search430_1.value },
   NULL,
};

   /* replace430_0_0_0 -> search0_0 in the cache */

/* replace430_0_0_1 -> search430_1_0 in the cache */
static const nir_search_expression replace430_0_0 = {
   { nir_search_value_expression, -2 },
   false, true,
   1, 1,
   nir_op_fmin,
   { &search0_0.value, &search430_1_0.value },
   NULL,
};

/* replace430_0_1 -> search104_2 in the cache */
static const nir_search_expression replace430_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace430_0_0.value, &search104_2.value },
   NULL,
};

/* replace430_1 -> search430_0_1 in the cache */
static const nir_search_expression replace430 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace430_0.value, &search430_0_1.value },
   NULL,
};

   /* search431_0_0_0 -> search0_0 in the cache */

/* search431_0_0_1 -> search104_2 in the cache */
static const nir_search_expression search431_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search104_2.value },
   NULL,
};

/* search431_0_1 -> search430_0_1 in the cache */
static const nir_search_expression search431_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search431_0_0.value, &search430_0_1.value },
   (is_used_once),
};

/* search431_1_0 -> search430_1_0 in the cache */

/* search431_1_1 -> search104_2 in the cache */
static const nir_search_expression search431_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search430_1_0.value, &search104_2.value },
   (is_used_once),
};
static const nir_search_expression search431 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search431_0.value, &search431_1.value },
   NULL,
};

   /* replace431_0_0_0 -> search0_0 in the cache */

/* replace431_0_0_1 -> search430_1_0 in the cache */
/* replace431_0_0 -> replace430_0_0 in the cache */

/* replace431_0_1 -> search104_2 in the cache */
/* replace431_0 -> replace430_0 in the cache */

/* replace431_1 -> search430_0_1 in the cache */
/* replace431 -> replace430 in the cache */

   /* search432_0_0_0 -> search103_0_0 in the cache */

/* search432_0_0_1 -> search103_0_1 in the cache */
static const nir_search_expression search432_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search103_0_0.value, &search103_0_1.value },
   (is_used_once),
};

/* search432_0_1 -> search430_0_1 in the cache */
static const nir_search_expression search432_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search432_0_0.value, &search430_0_1.value },
   (is_used_once),
};

/* search432_1_0 -> search103_0_0 in the cache */

static const nir_search_variable search432_1_1 = {
   { nir_search_value_variable, -4 },
   3, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search432_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search103_0_0.value, &search432_1_1.value },
   NULL,
};
static const nir_search_expression search432 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search432_0.value, &search432_1.value },
   NULL,
};

   /* replace432_0_0 -> search103_0_0 in the cache */

/* replace432_0_1_0 -> search103_0_1 in the cache */

/* replace432_0_1_1 -> search432_1_1 in the cache */
static const nir_search_expression replace432_0_1 = {
   { nir_search_value_expression, -4 },
   false, true,
   1, 1,
   nir_op_fmax,
   { &search103_0_1.value, &search432_1_1.value },
   NULL,
};
static const nir_search_expression replace432_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search103_0_0.value, &replace432_0_1.value },
   NULL,
};

/* replace432_1 -> search430_0_1 in the cache */
static const nir_search_expression replace432 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace432_0.value, &search430_0_1.value },
   NULL,
};

   /* search433_0_0_0 -> search103_0_0 in the cache */

/* search433_0_0_1 -> search103_0_1 in the cache */
static const nir_search_expression search433_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search103_0_0.value, &search103_0_1.value },
   NULL,
};

/* search433_0_1 -> search430_0_1 in the cache */
static const nir_search_expression search433_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search433_0_0.value, &search430_0_1.value },
   (is_used_once),
};

/* search433_1_0 -> search103_0_0 in the cache */

/* search433_1_1 -> search432_1_1 in the cache */
static const nir_search_expression search433_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search103_0_0.value, &search432_1_1.value },
   (is_used_once),
};
static const nir_search_expression search433 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search433_0.value, &search433_1.value },
   NULL,
};

   /* replace433_0_0 -> search103_0_0 in the cache */

/* replace433_0_1_0 -> search103_0_1 in the cache */

/* replace433_0_1_1 -> search432_1_1 in the cache */
/* replace433_0_1 -> replace432_0_1 in the cache */
/* replace433_0 -> replace432_0 in the cache */

/* replace433_1 -> search430_0_1 in the cache */
/* replace433 -> replace432 in the cache */

   /* search434_0_0 -> search31_1 in the cache */

/* search434_0_1 -> search31_0 in the cache */
static const nir_search_expression search434_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search31_1.value, &search31_0.value },
   (is_used_once),
};

/* search434_1_0 -> search61_2 in the cache */

/* search434_1_1 -> search31_1 in the cache */
static const nir_search_expression search434_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search61_2.value, &search31_1.value },
   NULL,
};
static const nir_search_expression search434 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search434_0.value, &search434_1.value },
   NULL,
};

   /* replace434_0 -> search31_1 in the cache */

/* replace434_1_0 -> search31_0 in the cache */

/* replace434_1_1_0 -> search61_2 in the cache */
/* replace434_1_1 -> search82_1_0_1_1 in the cache */
static const nir_search_expression replace434_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search31_0.value, &search82_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace434 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search31_1.value, &replace434_1.value },
   NULL,
};

   /* search435_0_0 -> search31_1 in the cache */

/* search435_0_1 -> search31_0 in the cache */
static const nir_search_expression search435_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search31_1.value, &search31_0.value },
   NULL,
};

/* search435_1_0 -> search61_2 in the cache */

/* search435_1_1 -> search31_1 in the cache */
static const nir_search_expression search435_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search61_2.value, &search31_1.value },
   (is_used_once),
};
static const nir_search_expression search435 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search435_0.value, &search435_1.value },
   NULL,
};

   /* replace435_0 -> search31_1 in the cache */

/* replace435_1_0 -> search31_0 in the cache */

/* replace435_1_1_0 -> search61_2 in the cache */
/* replace435_1_1 -> search82_1_0_1_1 in the cache */
/* replace435_1 -> replace434_1 in the cache */
/* replace435 -> replace434 in the cache */

   /* search436_0_0 -> search31_1 in the cache */

/* search436_0_1 -> search31_0 in the cache */
static const nir_search_expression search436_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search31_1.value, &search31_0.value },
   (is_used_once),
};

/* search436_1_0 -> search61_2 in the cache */

/* search436_1_1 -> search31_1 in the cache */
static const nir_search_expression search436_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search61_2.value, &search31_1.value },
   NULL,
};
static const nir_search_expression search436 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search436_0.value, &search436_1.value },
   NULL,
};

   /* replace436_0 -> search31_1 in the cache */

/* replace436_1_0 -> search31_0 in the cache */

/* replace436_1_1_0 -> search61_2 in the cache */
/* replace436_1_1 -> search82_1_0_1_1 in the cache */
static const nir_search_expression replace436_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search31_0.value, &search82_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace436 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search31_1.value, &replace436_1.value },
   NULL,
};

   /* search437_0_0 -> search31_1 in the cache */

/* search437_0_1 -> search31_0 in the cache */
static const nir_search_expression search437_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search31_1.value, &search31_0.value },
   NULL,
};

/* search437_1_0 -> search61_2 in the cache */

/* search437_1_1 -> search31_1 in the cache */
static const nir_search_expression search437_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search61_2.value, &search31_1.value },
   (is_used_once),
};
static const nir_search_expression search437 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search437_0.value, &search437_1.value },
   NULL,
};

   /* replace437_0 -> search31_1 in the cache */

/* replace437_1_0 -> search31_0 in the cache */

/* replace437_1_1_0 -> search61_2 in the cache */
/* replace437_1_1 -> search82_1_0_1_1 in the cache */
/* replace437_1 -> replace436_1 in the cache */
/* replace437 -> replace436 in the cache */

   /* search438_0_0 -> search31_1 in the cache */

/* search438_0_1 -> search31_0 in the cache */
/* search438_0 -> search434_0 in the cache */

/* search438_1_0 -> search61_2 in the cache */

/* search438_1_1 -> search31_1 in the cache */
/* search438_1 -> search434_1 in the cache */
static const nir_search_expression search438 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search434_0.value, &search434_1.value },
   NULL,
};

   /* replace438_0 -> search31_1 in the cache */

/* replace438_1_0 -> search31_0 in the cache */

/* replace438_1_1_0 -> search61_2 in the cache */
/* replace438_1_1 -> search82_1_0_1_1 in the cache */
/* replace438_1 -> replace436_1 in the cache */
static const nir_search_expression replace438 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search31_1.value, &replace436_1.value },
   NULL,
};

   /* search439_0_0 -> search31_1 in the cache */

/* search439_0_1 -> search31_0 in the cache */
/* search439_0 -> search435_0 in the cache */

/* search439_1_0 -> search61_2 in the cache */

/* search439_1_1 -> search31_1 in the cache */
/* search439_1 -> search435_1 in the cache */
static const nir_search_expression search439 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search435_0.value, &search435_1.value },
   NULL,
};

   /* replace439_0 -> search31_1 in the cache */

/* replace439_1_0 -> search31_0 in the cache */

/* replace439_1_1_0 -> search61_2 in the cache */
/* replace439_1_1 -> search82_1_0_1_1 in the cache */
/* replace439_1 -> replace436_1 in the cache */
/* replace439 -> replace438 in the cache */

   /* search440_0_0 -> search31_1 in the cache */

/* search440_0_1 -> search31_0 in the cache */
/* search440_0 -> search436_0 in the cache */

/* search440_1_0 -> search61_2 in the cache */

/* search440_1_1 -> search31_1 in the cache */
/* search440_1 -> search436_1 in the cache */
static const nir_search_expression search440 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search436_0.value, &search436_1.value },
   NULL,
};

   /* replace440_0 -> search31_1 in the cache */

/* replace440_1_0 -> search31_0 in the cache */

/* replace440_1_1_0 -> search61_2 in the cache */
/* replace440_1_1 -> search82_1_0_1_1 in the cache */
/* replace440_1 -> replace434_1 in the cache */
static const nir_search_expression replace440 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search31_1.value, &replace434_1.value },
   NULL,
};

   /* search441_0_0 -> search31_1 in the cache */

/* search441_0_1 -> search31_0 in the cache */
/* search441_0 -> search437_0 in the cache */

/* search441_1_0 -> search61_2 in the cache */

/* search441_1_1 -> search31_1 in the cache */
/* search441_1 -> search437_1 in the cache */
static const nir_search_expression search441 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search437_0.value, &search437_1.value },
   NULL,
};

   /* replace441_0 -> search31_1 in the cache */

/* replace441_1_0 -> search31_0 in the cache */

/* replace441_1_1_0 -> search61_2 in the cache */
/* replace441_1_1 -> search82_1_0_1_1 in the cache */
/* replace441_1 -> replace434_1 in the cache */
/* replace441 -> replace440 in the cache */

   /* search442_0_0 -> search31_0 in the cache */

/* search442_0_1 -> search31_1 in the cache */
static const nir_search_expression search442_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search31_0.value, &search31_1.value },
   NULL,
};

/* search442_1 -> replace76_0_0 in the cache */

/* search442_2_0_0_0_0 -> search31_1 in the cache */

/* search442_2_0_0_0_1 -> search31_0 in the cache */
/* search442_2_0_0_0 -> search435_0 in the cache */
static const nir_search_expression search442_2_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search435_0.value },
   NULL,
};

/* search442_2_0_1_0_0_0 -> search31_0 in the cache */

/* search442_2_0_1_0_0_1 -> search31_1 in the cache */
static const nir_search_expression search442_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search31_0.value, &search31_1.value },
   NULL,
};
static const nir_search_expression search442_2_0_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search442_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search442_2_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search442_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search442_2_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search442_2_0_0.value, &search442_2_0_1.value },
   NULL,
};
static const nir_search_expression search442_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_i2f16,
   { &search442_2_0.value },
   NULL,
};
static const nir_search_expression search442 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search442_0.value, &replace76_0_0.value, &search442_2.value },
   NULL,
};

   /* replace442_0_0_0_0 -> search31_0 in the cache */

/* replace442_0_0_0_1 -> search31_1 in the cache */
static const nir_search_expression replace442_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search31_0.value, &search31_1.value },
   NULL,
};
static const nir_search_expression replace442_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace442_0_0_0.value },
   NULL,
};

/* replace442_0_1_0_0_0 -> search31_0 in the cache */

/* replace442_0_1_0_0_1 -> search31_1 in the cache */
static const nir_search_expression replace442_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search31_0.value, &search31_1.value },
   NULL,
};
static const nir_search_expression replace442_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace442_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace442_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace442_0_1_0.value },
   NULL,
};
static const nir_search_expression replace442_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace442_0_0.value, &replace442_0_1.value },
   NULL,
};
static const nir_search_expression replace442 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_i2f16,
   { &replace442_0.value },
   NULL,
};

   /* search443_0 -> replace116_0 in the cache */

/* search443_1_0 -> search61_2 in the cache */
static const nir_search_expression search443_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search61_2.value },
   (is_used_once),
};

/* search443_2_0 -> search74_2 in the cache */
static const nir_search_expression search443_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search74_2.value },
   NULL,
};
static const nir_search_expression search443 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search443_1.value, &search443_2.value },
   NULL,
};

   /* replace443_0_0 -> replace116_0 in the cache */

/* replace443_0_1 -> search61_2 in the cache */

/* replace443_0_2 -> search74_2 in the cache */
static const nir_search_expression replace443_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search61_2.value, &search74_2.value },
   NULL,
};
static const nir_search_expression replace443 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace443_0.value },
   NULL,
};

   /* search444_0_0 -> search31_0 in the cache */
static const nir_search_expression search444_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search444 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_i2f16,
   { &search444_0.value },
   NULL,
};

   /* replace444_0 -> search31_0 in the cache */
static const nir_search_expression replace444 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search31_0.value },
   NULL,
};

   /* search445_0_0 -> search31_0 in the cache */
static const nir_search_expression search445_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search445 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2i16,
   { &search445_0.value },
   NULL,
};

   /* replace445 -> search31_0 in the cache */

   /* search446_0_0 -> search31_0 in the cache */
static const nir_search_expression search446_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search446 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2i16,
   { &search446_0.value },
   NULL,
};

   /* replace446 -> search31_0 in the cache */

   /* search447_0_0 -> search31_0 in the cache */
/* search447_0 -> search445_0 in the cache */
static const nir_search_expression search447 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2u16,
   { &search445_0.value },
   NULL,
};

   /* replace447 -> search31_0 in the cache */

   /* search448_0_0 -> search31_0 in the cache */
/* search448_0 -> search446_0 in the cache */
static const nir_search_expression search448 = {
   { nir_search_value_expression, 16 },
   true, false,
   -1, 0,
   nir_op_f2u16,
   { &search446_0.value },
   NULL,
};

   /* replace448 -> search31_0 in the cache */

   /* search449_0_0_0 -> search31_1 in the cache */

/* search449_0_0_1 -> search31_0 in the cache */
/* search449_0_0 -> search435_0 in the cache */
static const nir_search_expression search449_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &search435_0.value },
   NULL,
};

/* search449_1_0_0_0 -> search31_0 in the cache */

/* search449_1_0_0_1 -> search31_1 in the cache */
/* search449_1_0_0 -> search442_2_0_1_0_0 in the cache */
static const nir_search_expression search449_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &search442_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search449_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search449_1_0.value },
   NULL,
};
static const nir_search_expression search449 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search449_0.value, &search449_1.value },
   NULL,
};

   /* replace449_0 -> search31_0 in the cache */
static const nir_search_expression replace449 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search31_0.value },
   NULL,
};

   /* search450_0_0_0 -> replace136_2 in the cache */

/* search450_0_0_1 -> search31_0 in the cache */
static const nir_search_expression search450_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace136_2.value, &search31_0.value },
   NULL,
};
static const nir_search_expression search450_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search450_0_0.value },
   NULL,
};

/* search450_1_0_0_0 -> search31_0 in the cache */

/* search450_1_0_0_1 -> replace136_2 in the cache */
static const nir_search_expression search450_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search31_0.value, &replace136_2.value },
   NULL,
};
static const nir_search_expression search450_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search450_1_0_0.value },
   NULL,
};
static const nir_search_expression search450_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search450_1_0.value },
   NULL,
};
static const nir_search_expression search450 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search450_0.value, &search450_1.value },
   NULL,
};

   /* replace450_0_0 -> search31_0 in the cache */
/* replace450_0 -> replace449 in the cache */
static const nir_search_expression replace450 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &replace449.value },
   NULL,
};

   /* search451_0_0 -> search31_0 in the cache */
static const nir_search_expression search451_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search451 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search451_0.value },
   NULL,
};

   /* replace451 -> search31_0 in the cache */

   /* search452_0_0 -> search31_0 in the cache */
static const nir_search_expression search452_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search452 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search452_0.value },
   NULL,
};

   /* replace452 -> search31_0 in the cache */

   /* search453_0_0 -> search31_0 in the cache */
static const nir_search_expression search453_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search453 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search453_0.value },
   NULL,
};

   /* replace453 -> search31_0 in the cache */

   /* search454_0_0 -> replace116_0 in the cache */
static const nir_search_expression search454_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &replace116_0.value },
   NULL,
};
static const nir_search_expression search454 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search454_0.value },
   NULL,
};

   /* replace454_0 -> replace116_0 in the cache */
static const nir_search_expression replace454 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2f16,
   { &replace116_0.value },
   NULL,
};

   /* search455_0_0 -> replace116_0 in the cache */
static const nir_search_expression search455_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace116_0.value },
   NULL,
};
static const nir_search_expression search455 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search455_0.value },
   NULL,
};

   /* replace455_0 -> replace116_0 in the cache */
static const nir_search_expression replace455 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &replace116_0.value },
   NULL,
};

   /* search456_0_0 -> replace116_0 in the cache */
/* search456_0 -> search455_0 in the cache */
static const nir_search_expression search456 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search455_0.value },
   NULL,
};

   /* replace456_0 -> replace116_0 in the cache */
/* replace456 -> replace455 in the cache */

   /* search457_0_0 -> search31_0 in the cache */
/* search457_0 -> search451_0 in the cache */
static const nir_search_expression search457 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search451_0.value },
   NULL,
};

   /* replace457_0 -> search31_0 in the cache */
static const nir_search_expression replace457 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search31_0.value },
   NULL,
};

   /* search458_0_0 -> search31_0 in the cache */
/* search458_0 -> search451_0 in the cache */
static const nir_search_expression search458 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search451_0.value },
   NULL,
};

   /* replace458_0 -> search31_0 in the cache */
static const nir_search_expression replace458 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search31_0.value },
   NULL,
};

   /* search459_0_0 -> search2_0 in the cache */
static const nir_search_expression search459_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search459 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search459_0.value },
   NULL,
};

   /* replace459_0 -> search2_0 in the cache */
static const nir_search_expression replace459 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search2_0.value },
   NULL,
};

   /* search460_0_0 -> search2_0 in the cache */
static const nir_search_expression search460_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search460 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search460_0.value },
   NULL,
};

   /* replace460_0 -> search2_0 in the cache */
static const nir_search_expression replace460 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search2_0.value },
   NULL,
};

   /* search461_0_0 -> search31_0 in the cache */
/* search461_0 -> search453_0 in the cache */
static const nir_search_expression search461 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search453_0.value },
   NULL,
};

   /* replace461_0 -> search31_0 in the cache */
static const nir_search_expression replace461 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search31_0.value },
   NULL,
};

   /* search462_0_0 -> search31_0 in the cache */
/* search462_0 -> search452_0 in the cache */
static const nir_search_expression search462 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search452_0.value },
   NULL,
};

   /* replace462_0 -> search31_0 in the cache */
static const nir_search_expression replace462 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search31_0.value },
   NULL,
};

   /* search463_0_0 -> search31_0 in the cache */
static const nir_search_expression search463_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search463 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search463_0.value },
   NULL,
};

   /* replace463 -> search31_0 in the cache */

   /* search464_0_0 -> search31_0 in the cache */
static const nir_search_expression search464_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search464 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search464_0.value },
   NULL,
};

   /* replace464 -> search31_0 in the cache */

   /* search465_0_0 -> search31_0 in the cache */
static const nir_search_expression search465_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search465 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search465_0.value },
   NULL,
};

   /* replace465 -> search31_0 in the cache */

   /* search466_0_0 -> replace116_0 in the cache */
static const nir_search_expression search466_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &replace116_0.value },
   NULL,
};
static const nir_search_expression search466 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search466_0.value },
   NULL,
};

   /* replace466_0 -> replace116_0 in the cache */
/* replace466 -> replace454 in the cache */

   /* search467_0_0 -> replace116_0 in the cache */
static const nir_search_expression search467_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &replace116_0.value },
   NULL,
};
static const nir_search_expression search467 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search467_0.value },
   NULL,
};

   /* replace467_0 -> replace116_0 in the cache */
/* replace467 -> replace455 in the cache */

   /* search468_0_0 -> replace116_0 in the cache */
/* search468_0 -> search467_0 in the cache */
static const nir_search_expression search468 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search467_0.value },
   NULL,
};

   /* replace468_0 -> replace116_0 in the cache */
/* replace468 -> replace455 in the cache */

   /* search469_0_0 -> search31_0 in the cache */
/* search469_0 -> search463_0 in the cache */
static const nir_search_expression search469 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search463_0.value },
   NULL,
};

   /* replace469_0 -> search31_0 in the cache */
static const nir_search_expression replace469 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search31_0.value },
   NULL,
};

   /* search470_0_0 -> search31_0 in the cache */
/* search470_0 -> search463_0 in the cache */
static const nir_search_expression search470 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search463_0.value },
   NULL,
};

   /* replace470_0 -> search31_0 in the cache */
static const nir_search_expression replace470 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search31_0.value },
   NULL,
};

   /* search471_0_0 -> search2_0 in the cache */
static const nir_search_expression search471_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search471 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search471_0.value },
   NULL,
};

   /* replace471_0 -> search2_0 in the cache */
/* replace471 -> replace459 in the cache */

   /* search472_0_0 -> search2_0 in the cache */
static const nir_search_expression search472_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search472 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search472_0.value },
   NULL,
};

   /* replace472_0 -> search2_0 in the cache */
/* replace472 -> replace460 in the cache */

   /* search473_0_0 -> search31_0 in the cache */
/* search473_0 -> search465_0 in the cache */
static const nir_search_expression search473 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search465_0.value },
   NULL,
};

   /* replace473_0 -> search31_0 in the cache */
static const nir_search_expression replace473 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search31_0.value },
   NULL,
};

   /* search474_0_0 -> search31_0 in the cache */
/* search474_0 -> search464_0 in the cache */
static const nir_search_expression search474 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search464_0.value },
   NULL,
};

   /* replace474_0 -> search31_0 in the cache */
static const nir_search_expression replace474 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search31_0.value },
   NULL,
};

   /* search475_0_0 -> search32_1 in the cache */

/* search475_0_1 -> search3_0_0 in the cache */
static const nir_search_expression search475_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search32_1.value, &search3_0_0.value },
   (is_used_once),
};

/* search475_1_0 -> replace2_1_1 in the cache */

/* search475_1_1 -> search32_1 in the cache */
static const nir_search_expression search475_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace2_1_1.value, &search32_1.value },
   NULL,
};
static const nir_search_expression search475 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search475_0.value, &search475_1.value },
   NULL,
};

   /* replace475_0 -> search32_1 in the cache */

/* replace475_1_0 -> search3_0_0 in the cache */

/* replace475_1_1_0 -> replace2_1_1 in the cache */
/* replace475_1_1 -> search92_1_0_1_1 in the cache */
static const nir_search_expression replace475_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search3_0_0.value, &search92_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace475 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search32_1.value, &replace475_1.value },
   NULL,
};

   /* search476_0_0 -> search32_1 in the cache */

/* search476_0_1 -> search3_0_0 in the cache */
static const nir_search_expression search476_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search32_1.value, &search3_0_0.value },
   NULL,
};

/* search476_1_0 -> replace2_1_1 in the cache */

/* search476_1_1 -> search32_1 in the cache */
static const nir_search_expression search476_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace2_1_1.value, &search32_1.value },
   (is_used_once),
};
static const nir_search_expression search476 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search476_0.value, &search476_1.value },
   NULL,
};

   /* replace476_0 -> search32_1 in the cache */

/* replace476_1_0 -> search3_0_0 in the cache */

/* replace476_1_1_0 -> replace2_1_1 in the cache */
/* replace476_1_1 -> search92_1_0_1_1 in the cache */
/* replace476_1 -> replace475_1 in the cache */
/* replace476 -> replace475 in the cache */

   /* search477_0_0 -> search32_1 in the cache */

/* search477_0_1 -> search3_0_0 in the cache */
static const nir_search_expression search477_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search32_1.value, &search3_0_0.value },
   (is_used_once),
};

/* search477_1_0 -> replace2_1_1 in the cache */

/* search477_1_1 -> search32_1 in the cache */
static const nir_search_expression search477_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace2_1_1.value, &search32_1.value },
   NULL,
};
static const nir_search_expression search477 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search477_0.value, &search477_1.value },
   NULL,
};

   /* replace477_0 -> search32_1 in the cache */

/* replace477_1_0 -> search3_0_0 in the cache */

/* replace477_1_1_0 -> replace2_1_1 in the cache */
/* replace477_1_1 -> search92_1_0_1_1 in the cache */
static const nir_search_expression replace477_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search3_0_0.value, &search92_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace477 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search32_1.value, &replace477_1.value },
   NULL,
};

   /* search478_0_0 -> search32_1 in the cache */

/* search478_0_1 -> search3_0_0 in the cache */
static const nir_search_expression search478_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search32_1.value, &search3_0_0.value },
   NULL,
};

/* search478_1_0 -> replace2_1_1 in the cache */

/* search478_1_1 -> search32_1 in the cache */
static const nir_search_expression search478_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace2_1_1.value, &search32_1.value },
   (is_used_once),
};
static const nir_search_expression search478 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search478_0.value, &search478_1.value },
   NULL,
};

   /* replace478_0 -> search32_1 in the cache */

/* replace478_1_0 -> search3_0_0 in the cache */

/* replace478_1_1_0 -> replace2_1_1 in the cache */
/* replace478_1_1 -> search92_1_0_1_1 in the cache */
/* replace478_1 -> replace477_1 in the cache */
/* replace478 -> replace477 in the cache */

   /* search479_0_0 -> search32_1 in the cache */

/* search479_0_1 -> search3_0_0 in the cache */
/* search479_0 -> search475_0 in the cache */

/* search479_1_0 -> replace2_1_1 in the cache */

/* search479_1_1 -> search32_1 in the cache */
/* search479_1 -> search475_1 in the cache */
static const nir_search_expression search479 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search475_0.value, &search475_1.value },
   NULL,
};

   /* replace479_0 -> search32_1 in the cache */

/* replace479_1_0 -> search3_0_0 in the cache */

/* replace479_1_1_0 -> replace2_1_1 in the cache */
/* replace479_1_1 -> search92_1_0_1_1 in the cache */
/* replace479_1 -> replace477_1 in the cache */
static const nir_search_expression replace479 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search32_1.value, &replace477_1.value },
   NULL,
};

   /* search480_0_0 -> search32_1 in the cache */

/* search480_0_1 -> search3_0_0 in the cache */
/* search480_0 -> search476_0 in the cache */

/* search480_1_0 -> replace2_1_1 in the cache */

/* search480_1_1 -> search32_1 in the cache */
/* search480_1 -> search476_1 in the cache */
static const nir_search_expression search480 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search476_0.value, &search476_1.value },
   NULL,
};

   /* replace480_0 -> search32_1 in the cache */

/* replace480_1_0 -> search3_0_0 in the cache */

/* replace480_1_1_0 -> replace2_1_1 in the cache */
/* replace480_1_1 -> search92_1_0_1_1 in the cache */
/* replace480_1 -> replace477_1 in the cache */
/* replace480 -> replace479 in the cache */

   /* search481_0_0 -> search32_1 in the cache */

/* search481_0_1 -> search3_0_0 in the cache */
/* search481_0 -> search477_0 in the cache */

/* search481_1_0 -> replace2_1_1 in the cache */

/* search481_1_1 -> search32_1 in the cache */
/* search481_1 -> search477_1 in the cache */
static const nir_search_expression search481 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search477_0.value, &search477_1.value },
   NULL,
};

   /* replace481_0 -> search32_1 in the cache */

/* replace481_1_0 -> search3_0_0 in the cache */

/* replace481_1_1_0 -> replace2_1_1 in the cache */
/* replace481_1_1 -> search92_1_0_1_1 in the cache */
/* replace481_1 -> replace475_1 in the cache */
static const nir_search_expression replace481 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search32_1.value, &replace475_1.value },
   NULL,
};

   /* search482_0_0 -> search32_1 in the cache */

/* search482_0_1 -> search3_0_0 in the cache */
/* search482_0 -> search478_0 in the cache */

/* search482_1_0 -> replace2_1_1 in the cache */

/* search482_1_1 -> search32_1 in the cache */
/* search482_1 -> search478_1 in the cache */
static const nir_search_expression search482 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search478_0.value, &search478_1.value },
   NULL,
};

   /* replace482_0 -> search32_1 in the cache */

/* replace482_1_0 -> search3_0_0 in the cache */

/* replace482_1_1_0 -> replace2_1_1 in the cache */
/* replace482_1_1 -> search92_1_0_1_1 in the cache */
/* replace482_1 -> replace475_1 in the cache */
/* replace482 -> replace481 in the cache */

   /* search483_0_0 -> search3_0_0 in the cache */

/* search483_0_1 -> search32_1 in the cache */
static const nir_search_expression search483_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search3_0_0.value, &search32_1.value },
   NULL,
};

/* search483_1 -> replace86_0_0 in the cache */

/* search483_2_0_0_0_0 -> search32_1 in the cache */

/* search483_2_0_0_0_1 -> search3_0_0 in the cache */
/* search483_2_0_0_0 -> search476_0 in the cache */
static const nir_search_expression search483_2_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search476_0.value },
   NULL,
};

/* search483_2_0_1_0_0_0 -> search3_0_0 in the cache */

/* search483_2_0_1_0_0_1 -> search32_1 in the cache */
static const nir_search_expression search483_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search3_0_0.value, &search32_1.value },
   NULL,
};
static const nir_search_expression search483_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search483_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search483_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search483_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search483_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search483_2_0_0.value, &search483_2_0_1.value },
   NULL,
};
static const nir_search_expression search483_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &search483_2_0.value },
   NULL,
};
static const nir_search_expression search483 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search483_0.value, &replace86_0_0.value, &search483_2.value },
   NULL,
};

   /* replace483_0_0_0_0 -> search3_0_0 in the cache */

/* replace483_0_0_0_1 -> search32_1 in the cache */
static const nir_search_expression replace483_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search3_0_0.value, &search32_1.value },
   NULL,
};
static const nir_search_expression replace483_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace483_0_0_0.value },
   NULL,
};

/* replace483_0_1_0_0_0 -> search3_0_0 in the cache */

/* replace483_0_1_0_0_1 -> search32_1 in the cache */
static const nir_search_expression replace483_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search3_0_0.value, &search32_1.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace483_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace483_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace483_0_0.value, &replace483_0_1.value },
   NULL,
};
static const nir_search_expression replace483 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &replace483_0.value },
   NULL,
};

   /* search484_0 -> replace116_0 in the cache */

/* search484_1_0 -> replace2_1_1 in the cache */
static const nir_search_expression search484_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace2_1_1.value },
   (is_used_once),
};

/* search484_2_0 -> search84_2 in the cache */
static const nir_search_expression search484_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search84_2.value },
   NULL,
};
static const nir_search_expression search484 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search484_1.value, &search484_2.value },
   NULL,
};

   /* replace484_0_0 -> replace116_0 in the cache */

/* replace484_0_1 -> replace2_1_1 in the cache */

/* replace484_0_2 -> search84_2 in the cache */
static const nir_search_expression replace484_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace2_1_1.value, &search84_2.value },
   NULL,
};
static const nir_search_expression replace484 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace484_0.value },
   NULL,
};

   /* search485_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search485_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search485 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_i2f32,
   { &search485_0.value },
   NULL,
};

   /* replace485_0 -> search3_0_0 in the cache */
static const nir_search_expression replace485 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search3_0_0.value },
   NULL,
};

   /* search486_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search486_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search486 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search486_0.value },
   NULL,
};

   /* replace486 -> search3_0_0 in the cache */

   /* search487_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search487_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search487 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search487_0.value },
   NULL,
};

   /* replace487 -> search3_0_0 in the cache */

   /* search488_0_0 -> search3_0_0 in the cache */
/* search488_0 -> search486_0 in the cache */
static const nir_search_expression search488 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search486_0.value },
   NULL,
};

   /* replace488 -> search3_0_0 in the cache */

   /* search489_0_0 -> search3_0_0 in the cache */
/* search489_0 -> search487_0 in the cache */
static const nir_search_expression search489 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search487_0.value },
   NULL,
};

   /* replace489 -> search3_0_0 in the cache */

   /* search490_0_0_0 -> search32_1 in the cache */

/* search490_0_0_1 -> search3_0_0 in the cache */
/* search490_0_0 -> search476_0 in the cache */
static const nir_search_expression search490_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &search476_0.value },
   NULL,
};

/* search490_1_0_0_0 -> search3_0_0 in the cache */

/* search490_1_0_0_1 -> search32_1 in the cache */
/* search490_1_0_0 -> search483_2_0_1_0_0 in the cache */
static const nir_search_expression search490_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2f32,
   { &search483_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search490_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search490_1_0.value },
   NULL,
};
static const nir_search_expression search490 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search490_0.value, &search490_1.value },
   NULL,
};

   /* replace490_0 -> search3_0_0 in the cache */
static const nir_search_expression replace490 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search3_0_0.value },
   NULL,
};

   /* search491_0_0_0 -> search34_1 in the cache */

/* search491_0_0_1 -> search3_0_0 in the cache */
static const nir_search_expression search491_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search34_1.value, &search3_0_0.value },
   NULL,
};
static const nir_search_expression search491_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search491_0_0.value },
   NULL,
};

/* search491_1_0_0_0 -> search3_0_0 in the cache */

/* search491_1_0_0_1 -> search34_1 in the cache */
static const nir_search_expression search491_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};
static const nir_search_expression search491_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search491_1_0_0.value },
   NULL,
};
static const nir_search_expression search491_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search491_1_0.value },
   NULL,
};
static const nir_search_expression search491 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search491_0.value, &search491_1.value },
   NULL,
};

   /* replace491_0_0 -> search3_0_0 in the cache */
/* replace491_0 -> replace490 in the cache */
static const nir_search_expression replace491 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &replace490.value },
   NULL,
};

   /* search492_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search492_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search492 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search492_0.value },
   NULL,
};

   /* replace492 -> search3_0_0 in the cache */

   /* search493_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search493_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search493 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search493_0.value },
   NULL,
};

   /* replace493 -> search3_0_0 in the cache */

   /* search494_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search494_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search494 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search494_0.value },
   NULL,
};

   /* replace494 -> search3_0_0 in the cache */

   /* search495_0_0 -> replace116_0 in the cache */
/* search495_0 -> search466_0 in the cache */
static const nir_search_expression search495 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search466_0.value },
   NULL,
};

   /* replace495_0 -> replace116_0 in the cache */
/* replace495 -> search454_0 in the cache */

   /* search496_0_0 -> replace116_0 in the cache */
/* search496_0 -> search467_0 in the cache */
static const nir_search_expression search496 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search467_0.value },
   NULL,
};

   /* replace496_0 -> replace116_0 in the cache */
/* replace496 -> search455_0 in the cache */

   /* search497_0_0 -> replace116_0 in the cache */
/* search497_0 -> search467_0 in the cache */
static const nir_search_expression search497 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search467_0.value },
   NULL,
};

   /* replace497_0 -> replace116_0 in the cache */
/* replace497 -> search455_0 in the cache */

   /* search498_0_0 -> search3_0_0 in the cache */
/* search498_0 -> search492_0 in the cache */
static const nir_search_expression search498 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search492_0.value },
   NULL,
};

   /* replace498_0 -> search3_0_0 in the cache */
static const nir_search_expression replace498 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2u64,
   { &search3_0_0.value },
   NULL,
};

   /* search499_0_0 -> search3_0_0 in the cache */
/* search499_0 -> search492_0 in the cache */
static const nir_search_expression search499 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search492_0.value },
   NULL,
};

   /* replace499_0 -> search3_0_0 in the cache */
static const nir_search_expression replace499 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &search3_0_0.value },
   NULL,
};

   /* search500_0_0 -> search2_0 in the cache */
/* search500_0 -> search471_0 in the cache */
static const nir_search_expression search500 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search471_0.value },
   NULL,
};

   /* replace500_0 -> search2_0 in the cache */
/* replace500 -> search459_0 in the cache */

   /* search501_0_0 -> search2_0 in the cache */
/* search501_0 -> search472_0 in the cache */
static const nir_search_expression search501 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search472_0.value },
   NULL,
};

   /* replace501_0 -> search2_0 in the cache */
/* replace501 -> search460_0 in the cache */

   /* search502_0_0 -> search3_0_0 in the cache */
/* search502_0 -> search494_0 in the cache */
static const nir_search_expression search502 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search494_0.value },
   NULL,
};

   /* replace502_0 -> search3_0_0 in the cache */
static const nir_search_expression replace502 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2f64,
   { &search3_0_0.value },
   NULL,
};

   /* search503_0_0 -> search3_0_0 in the cache */
/* search503_0 -> search493_0 in the cache */
static const nir_search_expression search503 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search493_0.value },
   NULL,
};

   /* replace503_0 -> search3_0_0 in the cache */
static const nir_search_expression replace503 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2f64,
   { &search3_0_0.value },
   NULL,
};

   static const nir_search_constant search504_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search504_0_1 -> search93_0 in the cache */
static const nir_search_expression search504_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search504_0_0.value, &search93_0.value },
   (is_used_once),
};

/* search504_1_0 -> search93_1 in the cache */

/* search504_1_1 -> search504_0_0 in the cache */
static const nir_search_expression search504_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search93_1.value, &search504_0_0.value },
   NULL,
};
static const nir_search_expression search504 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search504_0.value, &search504_1.value },
   NULL,
};

   /* replace504_0 -> search504_0_0 in the cache */

/* replace504_1_0 -> search93_0 in the cache */

/* replace504_1_1_0 -> search93_1 in the cache */
/* replace504_1_1 -> search102_1_0_1_1 in the cache */
static const nir_search_expression replace504_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search93_0.value, &search102_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace504 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search504_0_0.value, &replace504_1.value },
   NULL,
};

   /* search505_0_0 -> search504_0_0 in the cache */

/* search505_0_1 -> search93_0 in the cache */
static const nir_search_expression search505_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search504_0_0.value, &search93_0.value },
   NULL,
};

/* search505_1_0 -> search93_1 in the cache */

/* search505_1_1 -> search504_0_0 in the cache */
static const nir_search_expression search505_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search93_1.value, &search504_0_0.value },
   (is_used_once),
};
static const nir_search_expression search505 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search505_0.value, &search505_1.value },
   NULL,
};

   /* replace505_0 -> search504_0_0 in the cache */

/* replace505_1_0 -> search93_0 in the cache */

/* replace505_1_1_0 -> search93_1 in the cache */
/* replace505_1_1 -> search102_1_0_1_1 in the cache */
/* replace505_1 -> replace504_1 in the cache */
/* replace505 -> replace504 in the cache */

   /* search506_0_0 -> search504_0_0 in the cache */

/* search506_0_1 -> search93_0 in the cache */
static const nir_search_expression search506_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search504_0_0.value, &search93_0.value },
   (is_used_once),
};

/* search506_1_0 -> search93_1 in the cache */

/* search506_1_1 -> search504_0_0 in the cache */
static const nir_search_expression search506_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search93_1.value, &search504_0_0.value },
   NULL,
};
static const nir_search_expression search506 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search506_0.value, &search506_1.value },
   NULL,
};

   /* replace506_0 -> search504_0_0 in the cache */

/* replace506_1_0 -> search93_0 in the cache */

/* replace506_1_1_0 -> search93_1 in the cache */
/* replace506_1_1 -> search102_1_0_1_1 in the cache */
static const nir_search_expression replace506_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search93_0.value, &search102_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace506 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search504_0_0.value, &replace506_1.value },
   NULL,
};

   /* search507_0_0 -> search504_0_0 in the cache */

/* search507_0_1 -> search93_0 in the cache */
static const nir_search_expression search507_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search504_0_0.value, &search93_0.value },
   NULL,
};

/* search507_1_0 -> search93_1 in the cache */

/* search507_1_1 -> search504_0_0 in the cache */
static const nir_search_expression search507_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search93_1.value, &search504_0_0.value },
   (is_used_once),
};
static const nir_search_expression search507 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search507_0.value, &search507_1.value },
   NULL,
};

   /* replace507_0 -> search504_0_0 in the cache */

/* replace507_1_0 -> search93_0 in the cache */

/* replace507_1_1_0 -> search93_1 in the cache */
/* replace507_1_1 -> search102_1_0_1_1 in the cache */
/* replace507_1 -> replace506_1 in the cache */
/* replace507 -> replace506 in the cache */

   /* search508_0_0 -> search504_0_0 in the cache */

/* search508_0_1 -> search93_0 in the cache */
/* search508_0 -> search504_0 in the cache */

/* search508_1_0 -> search93_1 in the cache */

/* search508_1_1 -> search504_0_0 in the cache */
/* search508_1 -> search504_1 in the cache */
static const nir_search_expression search508 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search504_0.value, &search504_1.value },
   NULL,
};

   /* replace508_0 -> search504_0_0 in the cache */

/* replace508_1_0 -> search93_0 in the cache */

/* replace508_1_1_0 -> search93_1 in the cache */
/* replace508_1_1 -> search102_1_0_1_1 in the cache */
/* replace508_1 -> replace506_1 in the cache */
static const nir_search_expression replace508 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search504_0_0.value, &replace506_1.value },
   NULL,
};

   /* search509_0_0 -> search504_0_0 in the cache */

/* search509_0_1 -> search93_0 in the cache */
/* search509_0 -> search505_0 in the cache */

/* search509_1_0 -> search93_1 in the cache */

/* search509_1_1 -> search504_0_0 in the cache */
/* search509_1 -> search505_1 in the cache */
static const nir_search_expression search509 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search505_0.value, &search505_1.value },
   NULL,
};

   /* replace509_0 -> search504_0_0 in the cache */

/* replace509_1_0 -> search93_0 in the cache */

/* replace509_1_1_0 -> search93_1 in the cache */
/* replace509_1_1 -> search102_1_0_1_1 in the cache */
/* replace509_1 -> replace506_1 in the cache */
/* replace509 -> replace508 in the cache */

   /* search510_0_0 -> search504_0_0 in the cache */

/* search510_0_1 -> search93_0 in the cache */
/* search510_0 -> search506_0 in the cache */

/* search510_1_0 -> search93_1 in the cache */

/* search510_1_1 -> search504_0_0 in the cache */
/* search510_1 -> search506_1 in the cache */
static const nir_search_expression search510 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search506_0.value, &search506_1.value },
   NULL,
};

   /* replace510_0 -> search504_0_0 in the cache */

/* replace510_1_0 -> search93_0 in the cache */

/* replace510_1_1_0 -> search93_1 in the cache */
/* replace510_1_1 -> search102_1_0_1_1 in the cache */
/* replace510_1 -> replace504_1 in the cache */
static const nir_search_expression replace510 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search504_0_0.value, &replace504_1.value },
   NULL,
};

   /* search511_0_0 -> search504_0_0 in the cache */

/* search511_0_1 -> search93_0 in the cache */
/* search511_0 -> search507_0 in the cache */

/* search511_1_0 -> search93_1 in the cache */

/* search511_1_1 -> search504_0_0 in the cache */
/* search511_1 -> search507_1 in the cache */
static const nir_search_expression search511 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search507_0.value, &search507_1.value },
   NULL,
};

   /* replace511_0 -> search504_0_0 in the cache */

/* replace511_1_0 -> search93_0 in the cache */

/* replace511_1_1_0 -> search93_1 in the cache */
/* replace511_1_1 -> search102_1_0_1_1 in the cache */
/* replace511_1 -> replace504_1 in the cache */
/* replace511 -> replace510 in the cache */

   /* search512_0_0 -> search93_0 in the cache */

/* search512_0_1 -> search504_0_0 in the cache */
static const nir_search_expression search512_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search93_0.value, &search504_0_0.value },
   NULL,
};

/* search512_1 -> replace96_0_0 in the cache */

/* search512_2_0_0_0_0 -> search504_0_0 in the cache */

/* search512_2_0_0_0_1 -> search93_0 in the cache */
/* search512_2_0_0_0 -> search505_0 in the cache */
static const nir_search_expression search512_2_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search505_0.value },
   NULL,
};

/* search512_2_0_1_0_0_0 -> search93_0 in the cache */

/* search512_2_0_1_0_0_1 -> search504_0_0 in the cache */
static const nir_search_expression search512_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search93_0.value, &search504_0_0.value },
   NULL,
};
static const nir_search_expression search512_2_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search512_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search512_2_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search512_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search512_2_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search512_2_0_0.value, &search512_2_0_1.value },
   NULL,
};
static const nir_search_expression search512_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_i2f64,
   { &search512_2_0.value },
   NULL,
};
static const nir_search_expression search512 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search512_0.value, &replace96_0_0.value, &search512_2.value },
   NULL,
};

   /* replace512_0_0_0_0 -> search93_0 in the cache */

/* replace512_0_0_0_1 -> search504_0_0 in the cache */
static const nir_search_expression replace512_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_fge,
   { &search93_0.value, &search504_0_0.value },
   NULL,
};
static const nir_search_expression replace512_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace512_0_0_0.value },
   NULL,
};

/* replace512_0_1_0_0_0 -> search93_0 in the cache */

/* replace512_0_1_0_0_1 -> search504_0_0 in the cache */
static const nir_search_expression replace512_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, true,
   -1, 0,
   nir_op_flt,
   { &search93_0.value, &search504_0_0.value },
   NULL,
};
static const nir_search_expression replace512_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace512_0_1_0_0.value },
   NULL,
};
static const nir_search_expression replace512_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace512_0_1_0.value },
   NULL,
};
static const nir_search_expression replace512_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace512_0_0.value, &replace512_0_1.value },
   NULL,
};
static const nir_search_expression replace512 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_i2f64,
   { &replace512_0.value },
   NULL,
};

   /* search513_0 -> replace116_0 in the cache */

/* search513_1_0 -> search93_1 in the cache */
static const nir_search_expression search513_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search93_1.value },
   (is_used_once),
};

/* search513_2_0 -> search94_2 in the cache */
static const nir_search_expression search513_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search94_2.value },
   NULL,
};
static const nir_search_expression search513 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search513_1.value, &search513_2.value },
   NULL,
};

   /* replace513_0_0 -> replace116_0 in the cache */

/* replace513_0_1 -> search93_1 in the cache */

/* replace513_0_2 -> search94_2 in the cache */
static const nir_search_expression replace513_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search93_1.value, &search94_2.value },
   NULL,
};
static const nir_search_expression replace513 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace513_0.value },
   NULL,
};

   /* search514_0_0 -> search93_0 in the cache */
static const nir_search_expression search514_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search514 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_i2f64,
   { &search514_0.value },
   NULL,
};

   /* replace514_0 -> search93_0 in the cache */
static const nir_search_expression replace514 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search93_0.value },
   NULL,
};

   /* search515_0_0 -> search93_0 in the cache */
static const nir_search_expression search515_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search515 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2i64,
   { &search515_0.value },
   NULL,
};

   /* replace515 -> search93_0 in the cache */

   /* search516_0_0 -> search93_0 in the cache */
static const nir_search_expression search516_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search516 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2i64,
   { &search516_0.value },
   NULL,
};

   /* replace516 -> search93_0 in the cache */

   /* search517_0_0 -> search93_0 in the cache */
/* search517_0 -> search515_0 in the cache */
static const nir_search_expression search517 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2u64,
   { &search515_0.value },
   NULL,
};

   /* replace517 -> search93_0 in the cache */

   /* search518_0_0 -> search93_0 in the cache */
/* search518_0 -> search516_0 in the cache */
static const nir_search_expression search518 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 0,
   nir_op_f2u64,
   { &search516_0.value },
   NULL,
};

   /* replace518 -> search93_0 in the cache */

   /* search519_0_0_0 -> search504_0_0 in the cache */

/* search519_0_0_1 -> search93_0 in the cache */
/* search519_0_0 -> search505_0 in the cache */
static const nir_search_expression search519_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &search505_0.value },
   NULL,
};

/* search519_1_0_0_0 -> search93_0 in the cache */

/* search519_1_0_0_1 -> search504_0_0 in the cache */
/* search519_1_0_0 -> search512_2_0_1_0_0 in the cache */
static const nir_search_expression search519_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2f64,
   { &search512_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search519_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search519_1_0.value },
   NULL,
};
static const nir_search_expression search519 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search519_0.value, &search519_1.value },
   NULL,
};

   /* replace519_0 -> search93_0 in the cache */
static const nir_search_expression replace519 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search93_0.value },
   NULL,
};

   /* search520_0_0_0 -> replace142_2 in the cache */

/* search520_0_0_1 -> search93_0 in the cache */
static const nir_search_expression search520_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace142_2.value, &search93_0.value },
   NULL,
};
static const nir_search_expression search520_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search520_0_0.value },
   NULL,
};

/* search520_1_0_0_0 -> search93_0 in the cache */

/* search520_1_0_0_1 -> replace142_2 in the cache */
static const nir_search_expression search520_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search93_0.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression search520_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search520_1_0_0.value },
   NULL,
};
static const nir_search_expression search520_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search520_1_0.value },
   NULL,
};
static const nir_search_expression search520 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search520_0.value, &search520_1.value },
   NULL,
};

   /* replace520_0_0 -> search93_0 in the cache */
/* replace520_0 -> replace519 in the cache */
static const nir_search_expression replace520 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2i64,
   { &replace519.value },
   NULL,
};

   /* search521_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search521_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search521 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search521_0.value },
   NULL,
};

   /* replace521_0 -> search3_0_0 in the cache */
static const nir_search_expression replace521 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search3_0_0.value },
   NULL,
};

   /* search522_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search522_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2f32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search522 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search522_0.value },
   NULL,
};

   /* replace522_0 -> search3_0_0 in the cache */
static const nir_search_expression replace522 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search3_0_0.value },
   NULL,
};

   /* search523_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search523_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search523 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search523_0.value },
   NULL,
};

   /* replace523_0 -> search3_0_0 in the cache */
static const nir_search_expression replace523 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search3_0_0.value },
   NULL,
};

   /* search524_0_0 -> search3_0_0 in the cache */
/* search524_0 -> search523_0 in the cache */
static const nir_search_expression search524 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search523_0.value },
   NULL,
};

   /* replace524_0 -> search3_0_0 in the cache */
static const nir_search_expression replace524 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search3_0_0.value },
   NULL,
};

   /* search525_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search525_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2u32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search525 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search525_0.value },
   NULL,
};

   /* replace525_0 -> search3_0_0 in the cache */
static const nir_search_expression replace525 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search3_0_0.value },
   NULL,
};

   /* search526_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search526_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2i32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search526 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search526_0.value },
   NULL,
};

   /* replace526_0 -> search3_0_0 in the cache */
static const nir_search_expression replace526 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search3_0_0.value },
   NULL,
};

   /* search527_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search527_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search527 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search527_0.value },
   NULL,
};

   /* replace527_0 -> search3_0_0 in the cache */
static const nir_search_expression replace527 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search3_0_0.value },
   NULL,
};

   /* search528_0_0 -> search3_0_0 in the cache */
/* search528_0 -> search527_0 in the cache */
static const nir_search_expression search528 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search527_0.value },
   NULL,
};

   /* replace528_0 -> search3_0_0 in the cache */
static const nir_search_expression replace528 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search3_0_0.value },
   NULL,
};

   /* search529_0_0 -> search133_0_0 in the cache */

/* search529_0_1 -> replace133_2 in the cache */
static const nir_search_expression search529_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search133_0_0.value, &replace133_2.value },
   NULL,
};

static const nir_search_variable search529_1_0 = {
   { nir_search_value_variable, 8 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search529_1_1 -> replace133_2 in the cache */
static const nir_search_expression search529_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search529_1_0.value, &replace133_2.value },
   NULL,
};
static const nir_search_expression search529 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search529_0.value, &search529_1.value },
   NULL,
};

   /* replace529_0_0 -> search133_0_0 in the cache */

/* replace529_0_1 -> search529_1_0 in the cache */
static const nir_search_expression replace529_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search133_0_0.value, &search529_1_0.value },
   NULL,
};

/* replace529_1 -> replace133_2 in the cache */
static const nir_search_expression replace529 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace529_0.value, &replace133_2.value },
   NULL,
};

   /* search530_0_0 -> search133_0_0 in the cache */

/* search530_0_1 -> replace133_2 in the cache */
static const nir_search_expression search530_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search133_0_0.value, &replace133_2.value },
   NULL,
};

/* search530_1_0 -> search529_1_0 in the cache */

/* search530_1_1 -> replace133_2 in the cache */
static const nir_search_expression search530_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search529_1_0.value, &replace133_2.value },
   NULL,
};
static const nir_search_expression search530 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search530_0.value, &search530_1.value },
   NULL,
};

   /* replace530_0_0 -> search133_0_0 in the cache */

/* replace530_0_1 -> search529_1_0 in the cache */
/* replace530_0 -> replace529_0 in the cache */

/* replace530_1 -> replace133_2 in the cache */
static const nir_search_expression replace530 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace529_0.value, &replace133_2.value },
   NULL,
};

   /* search531_0_0 -> search133_0_0 in the cache */

/* search531_0_1 -> replace133_2 in the cache */
/* search531_0 -> search529_0 in the cache */

/* search531_1_0 -> search529_1_0 in the cache */

/* search531_1_1 -> replace133_2 in the cache */
/* search531_1 -> search529_1 in the cache */
/* search531 -> search529 in the cache */

   /* replace531_0_0 -> search133_0_0 in the cache */

/* replace531_0_1 -> search529_1_0 in the cache */
static const nir_search_expression replace531_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search133_0_0.value, &search529_1_0.value },
   NULL,
};

/* replace531_1 -> replace133_2 in the cache */
static const nir_search_expression replace531 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace531_0.value, &replace133_2.value },
   NULL,
};

   /* search532_0_0 -> search133_0_0 in the cache */

/* search532_0_1 -> replace133_2 in the cache */
/* search532_0 -> search529_0 in the cache */

/* search532_1_0 -> search529_1_0 in the cache */

/* search532_1_1 -> replace133_2 in the cache */
/* search532_1 -> search529_1 in the cache */
static const nir_search_expression search532 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search529_0.value, &search529_1.value },
   NULL,
};

   /* replace532_0_0 -> search133_0_0 in the cache */

/* replace532_0_1 -> search529_1_0 in the cache */
static const nir_search_expression replace532_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search133_0_0.value, &search529_1_0.value },
   NULL,
};

/* replace532_1 -> replace133_2 in the cache */
static const nir_search_expression replace532 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace532_0.value, &replace133_2.value },
   NULL,
};

   /* search533_0_0 -> search133_0_0 in the cache */

/* search533_0_1 -> replace133_2 in the cache */
/* search533_0 -> search530_0 in the cache */

/* search533_1_0 -> search529_1_0 in the cache */

/* search533_1_1 -> replace133_2 in the cache */
/* search533_1 -> search530_1 in the cache */
static const nir_search_expression search533 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search530_0.value, &search530_1.value },
   NULL,
};

   /* replace533_0_0 -> search133_0_0 in the cache */

/* replace533_0_1 -> search529_1_0 in the cache */
/* replace533_0 -> replace532_0 in the cache */

/* replace533_1 -> replace133_2 in the cache */
static const nir_search_expression replace533 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace532_0.value, &replace133_2.value },
   NULL,
};

   /* search534_0_0 -> search133_0_0 in the cache */

/* search534_0_1 -> replace133_2 in the cache */
/* search534_0 -> search530_0 in the cache */

/* search534_1_0 -> search529_1_0 in the cache */

/* search534_1_1 -> replace133_2 in the cache */
/* search534_1 -> search530_1 in the cache */
/* search534 -> search530 in the cache */

   /* replace534_0_0 -> search133_0_0 in the cache */

/* replace534_0_1 -> search529_1_0 in the cache */
/* replace534_0 -> replace531_0 in the cache */

/* replace534_1 -> replace133_2 in the cache */
static const nir_search_expression replace534 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace531_0.value, &replace133_2.value },
   NULL,
};

   /* search535_0_0 -> search133_0_0 in the cache */
static const nir_search_expression search535_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_b2i8,
   { &search133_0_0.value },
   NULL,
};
static const nir_search_expression search535 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search535_0.value },
   NULL,
};

   /* replace535 -> search133_0_0 in the cache */

   /* search536_0 -> search133_0_0 in the cache */

/* search536_1_0 -> replace135_1_1 in the cache */

/* search536_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search536_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace135_1_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search536 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search133_0_0.value, &search536_1.value },
   NULL,
};

   /* replace536_0 -> search133_0_0 in the cache */

/* replace536_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace536 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search133_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search537_0 -> search133_0_0 in the cache */

/* search537_1_0 -> replace135_1_1 in the cache */

/* search537_1_1 -> replace2_1_1 in the cache */
/* search537_1 -> search536_1 in the cache */
static const nir_search_expression search537 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search133_0_0.value, &search536_1.value },
   NULL,
};

   /* replace537_0 -> search133_0_0 in the cache */

/* replace537_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace537 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search133_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search538_0 -> search133_0_0 in the cache */

/* search538_1_0 -> replace135_1_1 in the cache */

/* search538_1_1 -> replace2_1_1 in the cache */
/* search538_1 -> search536_1 in the cache */
static const nir_search_expression search538 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search133_0_0.value, &search536_1.value },
   NULL,
};

   /* replace538_0 -> search133_0_0 in the cache */

/* replace538_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace538 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search133_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search539_0_0 -> search31_0 in the cache */

/* search539_0_1 -> replace136_2 in the cache */
static const nir_search_expression search539_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

/* search539_1_0 -> search61_2 in the cache */

/* search539_1_1 -> replace136_2 in the cache */
static const nir_search_expression search539_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search61_2.value, &replace136_2.value },
   NULL,
};
static const nir_search_expression search539 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search539_0.value, &search539_1.value },
   NULL,
};

   /* replace539_0_0 -> search31_0 in the cache */

/* replace539_0_1 -> search61_2 in the cache */
static const nir_search_expression replace539_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search31_0.value, &search61_2.value },
   NULL,
};

/* replace539_1 -> replace136_2 in the cache */
static const nir_search_expression replace539 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace539_0.value, &replace136_2.value },
   NULL,
};

   /* search540_0_0 -> search31_0 in the cache */

/* search540_0_1 -> replace136_2 in the cache */
static const nir_search_expression search540_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

/* search540_1_0 -> search61_2 in the cache */

/* search540_1_1 -> replace136_2 in the cache */
static const nir_search_expression search540_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search61_2.value, &replace136_2.value },
   NULL,
};
static const nir_search_expression search540 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search540_0.value, &search540_1.value },
   NULL,
};

   /* replace540_0_0 -> search31_0 in the cache */

/* replace540_0_1 -> search61_2 in the cache */
/* replace540_0 -> replace539_0 in the cache */

/* replace540_1 -> replace136_2 in the cache */
static const nir_search_expression replace540 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace539_0.value, &replace136_2.value },
   NULL,
};

   /* search541_0_0 -> search31_0 in the cache */

/* search541_0_1 -> replace136_2 in the cache */
/* search541_0 -> search539_0 in the cache */

/* search541_1_0 -> search61_2 in the cache */

/* search541_1_1 -> replace136_2 in the cache */
/* search541_1 -> search539_1 in the cache */
/* search541 -> search539 in the cache */

   /* replace541_0_0 -> search31_0 in the cache */

/* replace541_0_1 -> search61_2 in the cache */
static const nir_search_expression replace541_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search31_0.value, &search61_2.value },
   NULL,
};

/* replace541_1 -> replace136_2 in the cache */
static const nir_search_expression replace541 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace541_0.value, &replace136_2.value },
   NULL,
};

   /* search542_0_0 -> search31_0 in the cache */

/* search542_0_1 -> replace136_2 in the cache */
/* search542_0 -> search539_0 in the cache */

/* search542_1_0 -> search61_2 in the cache */

/* search542_1_1 -> replace136_2 in the cache */
/* search542_1 -> search539_1 in the cache */
static const nir_search_expression search542 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search539_0.value, &search539_1.value },
   NULL,
};

   /* replace542_0_0 -> search31_0 in the cache */

/* replace542_0_1 -> search61_2 in the cache */
static const nir_search_expression replace542_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search31_0.value, &search61_2.value },
   NULL,
};

/* replace542_1 -> replace136_2 in the cache */
static const nir_search_expression replace542 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace542_0.value, &replace136_2.value },
   NULL,
};

   /* search543_0_0 -> search31_0 in the cache */

/* search543_0_1 -> replace136_2 in the cache */
/* search543_0 -> search540_0 in the cache */

/* search543_1_0 -> search61_2 in the cache */

/* search543_1_1 -> replace136_2 in the cache */
/* search543_1 -> search540_1 in the cache */
static const nir_search_expression search543 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search540_0.value, &search540_1.value },
   NULL,
};

   /* replace543_0_0 -> search31_0 in the cache */

/* replace543_0_1 -> search61_2 in the cache */
/* replace543_0 -> replace542_0 in the cache */

/* replace543_1 -> replace136_2 in the cache */
static const nir_search_expression replace543 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace542_0.value, &replace136_2.value },
   NULL,
};

   /* search544_0_0 -> search31_0 in the cache */

/* search544_0_1 -> replace136_2 in the cache */
/* search544_0 -> search540_0 in the cache */

/* search544_1_0 -> search61_2 in the cache */

/* search544_1_1 -> replace136_2 in the cache */
/* search544_1 -> search540_1 in the cache */
/* search544 -> search540 in the cache */

   /* replace544_0_0 -> search31_0 in the cache */

/* replace544_0_1 -> search61_2 in the cache */
/* replace544_0 -> replace541_0 in the cache */

/* replace544_1 -> replace136_2 in the cache */
static const nir_search_expression replace544 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace541_0.value, &replace136_2.value },
   NULL,
};

   /* search545_0_0 -> search31_0 in the cache */
static const nir_search_expression search545_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_b2i16,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search545 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search545_0.value },
   NULL,
};

   /* replace545 -> search31_0 in the cache */

   /* search546_0 -> search31_0 in the cache */

/* search546_1_0 -> replace138_1_1 in the cache */

/* search546_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search546_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace138_1_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search546 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search31_0.value, &search546_1.value },
   NULL,
};

   /* replace546_0 -> search31_0 in the cache */

/* replace546_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace546 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search31_0.value, &replace2_1_1.value },
   NULL,
};

   /* search547_0 -> search31_0 in the cache */

/* search547_1_0 -> replace138_1_1 in the cache */

/* search547_1_1 -> replace2_1_1 in the cache */
/* search547_1 -> search546_1 in the cache */
static const nir_search_expression search547 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search31_0.value, &search546_1.value },
   NULL,
};

   /* replace547_0 -> search31_0 in the cache */

/* replace547_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace547 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search31_0.value, &replace2_1_1.value },
   NULL,
};

   /* search548_0 -> search31_0 in the cache */

/* search548_1_0 -> replace138_1_1 in the cache */

/* search548_1_1 -> replace2_1_1 in the cache */
/* search548_1 -> search546_1 in the cache */
static const nir_search_expression search548 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search31_0.value, &search546_1.value },
   NULL,
};

   /* replace548_0 -> search31_0 in the cache */

/* replace548_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace548 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search31_0.value, &replace2_1_1.value },
   NULL,
};

   /* search549_0_0 -> search3_0_0 in the cache */

/* search549_0_1 -> search34_1 in the cache */
static const nir_search_expression search549_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

/* search549_1_0 -> replace2_1_1 in the cache */

/* search549_1_1 -> search34_1 in the cache */
static const nir_search_expression search549_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace2_1_1.value, &search34_1.value },
   NULL,
};
static const nir_search_expression search549 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search549_0.value, &search549_1.value },
   NULL,
};

   /* replace549_0_0 -> search3_0_0 in the cache */

/* replace549_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace549_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace549_1 -> search34_1 in the cache */
static const nir_search_expression replace549 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace549_0.value, &search34_1.value },
   NULL,
};

   /* search550_0_0 -> search3_0_0 in the cache */

/* search550_0_1 -> search34_1 in the cache */
static const nir_search_expression search550_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

/* search550_1_0 -> replace2_1_1 in the cache */

/* search550_1_1 -> search34_1 in the cache */
static const nir_search_expression search550_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace2_1_1.value, &search34_1.value },
   NULL,
};
static const nir_search_expression search550 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search550_0.value, &search550_1.value },
   NULL,
};

   /* replace550_0_0 -> search3_0_0 in the cache */

/* replace550_0_1 -> replace2_1_1 in the cache */
/* replace550_0 -> replace549_0 in the cache */

/* replace550_1 -> search34_1 in the cache */
static const nir_search_expression replace550 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace549_0.value, &search34_1.value },
   NULL,
};

   /* search551_0_0 -> search3_0_0 in the cache */

/* search551_0_1 -> search34_1 in the cache */
/* search551_0 -> search549_0 in the cache */

/* search551_1_0 -> replace2_1_1 in the cache */

/* search551_1_1 -> search34_1 in the cache */
/* search551_1 -> search549_1 in the cache */
/* search551 -> search549 in the cache */

   /* replace551_0_0 -> search3_0_0 in the cache */

/* replace551_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace551_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace551_1 -> search34_1 in the cache */
static const nir_search_expression replace551 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace551_0.value, &search34_1.value },
   NULL,
};

   /* search552_0_0 -> search3_0_0 in the cache */

/* search552_0_1 -> search34_1 in the cache */
/* search552_0 -> search549_0 in the cache */

/* search552_1_0 -> replace2_1_1 in the cache */

/* search552_1_1 -> search34_1 in the cache */
/* search552_1 -> search549_1 in the cache */
static const nir_search_expression search552 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search549_0.value, &search549_1.value },
   NULL,
};

   /* replace552_0_0 -> search3_0_0 in the cache */

/* replace552_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace552_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace552_1 -> search34_1 in the cache */
static const nir_search_expression replace552 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace552_0.value, &search34_1.value },
   NULL,
};

   /* search553_0_0 -> search3_0_0 in the cache */

/* search553_0_1 -> search34_1 in the cache */
/* search553_0 -> search550_0 in the cache */

/* search553_1_0 -> replace2_1_1 in the cache */

/* search553_1_1 -> search34_1 in the cache */
/* search553_1 -> search550_1 in the cache */
static const nir_search_expression search553 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search550_0.value, &search550_1.value },
   NULL,
};

   /* replace553_0_0 -> search3_0_0 in the cache */

/* replace553_0_1 -> replace2_1_1 in the cache */
/* replace553_0 -> replace552_0 in the cache */

/* replace553_1 -> search34_1 in the cache */
static const nir_search_expression replace553 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace552_0.value, &search34_1.value },
   NULL,
};

   /* search554_0_0 -> search3_0_0 in the cache */

/* search554_0_1 -> search34_1 in the cache */
/* search554_0 -> search550_0 in the cache */

/* search554_1_0 -> replace2_1_1 in the cache */

/* search554_1_1 -> search34_1 in the cache */
/* search554_1 -> search550_1 in the cache */
/* search554 -> search550 in the cache */

   /* replace554_0_0 -> search3_0_0 in the cache */

/* replace554_0_1 -> replace2_1_1 in the cache */
/* replace554_0 -> replace551_0 in the cache */

/* replace554_1 -> search34_1 in the cache */
static const nir_search_expression replace554 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace551_0.value, &search34_1.value },
   NULL,
};

   /* search555_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search555_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search555 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search555_0.value },
   NULL,
};

   /* replace555 -> search3_0_0 in the cache */

   /* search556_0 -> search3_0_0 in the cache */

/* search556_1_0 -> replace141_1_1 in the cache */

/* search556_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search556_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace141_1_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search556 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0_0.value, &search556_1.value },
   NULL,
};

   /* replace556_0 -> search3_0_0 in the cache */

/* replace556_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace556 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search557_0 -> search3_0_0 in the cache */

/* search557_1_0 -> replace141_1_1 in the cache */

/* search557_1_1 -> replace2_1_1 in the cache */
/* search557_1 -> search556_1 in the cache */
static const nir_search_expression search557 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search3_0_0.value, &search556_1.value },
   NULL,
};

   /* replace557_0 -> search3_0_0 in the cache */

/* replace557_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace557 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search558_0 -> search3_0_0 in the cache */

/* search558_1_0 -> replace141_1_1 in the cache */

/* search558_1_1 -> replace2_1_1 in the cache */
/* search558_1 -> search556_1 in the cache */
static const nir_search_expression search558 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0_0.value, &search556_1.value },
   NULL,
};

   /* replace558_0 -> search3_0_0 in the cache */

/* replace558_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace558 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search559_0_0 -> search93_0 in the cache */

/* search559_0_1 -> replace142_2 in the cache */
static const nir_search_expression search559_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

/* search559_1_0 -> search93_1 in the cache */

/* search559_1_1 -> replace142_2 in the cache */
static const nir_search_expression search559_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search93_1.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression search559 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search559_0.value, &search559_1.value },
   NULL,
};

   /* replace559_0_0 -> search93_0 in the cache */

/* replace559_0_1 -> search93_1 in the cache */
static const nir_search_expression replace559_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace559_1 -> replace142_2 in the cache */
static const nir_search_expression replace559 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace559_0.value, &replace142_2.value },
   NULL,
};

   /* search560_0_0 -> search93_0 in the cache */

/* search560_0_1 -> replace142_2 in the cache */
static const nir_search_expression search560_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

/* search560_1_0 -> search93_1 in the cache */

/* search560_1_1 -> replace142_2 in the cache */
static const nir_search_expression search560_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search93_1.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression search560 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search560_0.value, &search560_1.value },
   NULL,
};

   /* replace560_0_0 -> search93_0 in the cache */

/* replace560_0_1 -> search93_1 in the cache */
/* replace560_0 -> replace559_0 in the cache */

/* replace560_1 -> replace142_2 in the cache */
static const nir_search_expression replace560 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace559_0.value, &replace142_2.value },
   NULL,
};

   /* search561_0_0 -> search93_0 in the cache */

/* search561_0_1 -> replace142_2 in the cache */
/* search561_0 -> search559_0 in the cache */

/* search561_1_0 -> search93_1 in the cache */

/* search561_1_1 -> replace142_2 in the cache */
/* search561_1 -> search559_1 in the cache */
/* search561 -> search559 in the cache */

   /* replace561_0_0 -> search93_0 in the cache */

/* replace561_0_1 -> search93_1 in the cache */
static const nir_search_expression replace561_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace561_1 -> replace142_2 in the cache */
static const nir_search_expression replace561 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace561_0.value, &replace142_2.value },
   NULL,
};

   /* search562_0_0 -> search93_0 in the cache */

/* search562_0_1 -> replace142_2 in the cache */
/* search562_0 -> search559_0 in the cache */

/* search562_1_0 -> search93_1 in the cache */

/* search562_1_1 -> replace142_2 in the cache */
/* search562_1 -> search559_1 in the cache */
static const nir_search_expression search562 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search559_0.value, &search559_1.value },
   NULL,
};

   /* replace562_0_0 -> search93_0 in the cache */

/* replace562_0_1 -> search93_1 in the cache */
static const nir_search_expression replace562_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace562_1 -> replace142_2 in the cache */
static const nir_search_expression replace562 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace562_0.value, &replace142_2.value },
   NULL,
};

   /* search563_0_0 -> search93_0 in the cache */

/* search563_0_1 -> replace142_2 in the cache */
/* search563_0 -> search560_0 in the cache */

/* search563_1_0 -> search93_1 in the cache */

/* search563_1_1 -> replace142_2 in the cache */
/* search563_1 -> search560_1 in the cache */
static const nir_search_expression search563 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search560_0.value, &search560_1.value },
   NULL,
};

   /* replace563_0_0 -> search93_0 in the cache */

/* replace563_0_1 -> search93_1 in the cache */
/* replace563_0 -> replace562_0 in the cache */

/* replace563_1 -> replace142_2 in the cache */
static const nir_search_expression replace563 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace562_0.value, &replace142_2.value },
   NULL,
};

   /* search564_0_0 -> search93_0 in the cache */

/* search564_0_1 -> replace142_2 in the cache */
/* search564_0 -> search560_0 in the cache */

/* search564_1_0 -> search93_1 in the cache */

/* search564_1_1 -> replace142_2 in the cache */
/* search564_1 -> search560_1 in the cache */
/* search564 -> search560 in the cache */

   /* replace564_0_0 -> search93_0 in the cache */

/* replace564_0_1 -> search93_1 in the cache */
/* replace564_0 -> replace561_0 in the cache */

/* replace564_1 -> replace142_2 in the cache */
static const nir_search_expression replace564 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace561_0.value, &replace142_2.value },
   NULL,
};

   /* search565_0_0 -> search93_0 in the cache */
static const nir_search_expression search565_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_b2i64,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search565 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search565_0.value },
   NULL,
};

   /* replace565 -> search93_0 in the cache */

   /* search566_0 -> search93_0 in the cache */

/* search566_1_0 -> replace144_1_1 in the cache */

/* search566_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search566_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace144_1_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search566 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search93_0.value, &search566_1.value },
   NULL,
};

   /* replace566_0 -> search93_0 in the cache */

/* replace566_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace566 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &replace2_1_1.value },
   NULL,
};

   /* search567_0 -> search93_0 in the cache */

/* search567_1_0 -> replace144_1_1 in the cache */

/* search567_1_1 -> replace2_1_1 in the cache */
/* search567_1 -> search566_1 in the cache */
static const nir_search_expression search567 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search93_0.value, &search566_1.value },
   NULL,
};

   /* replace567_0 -> search93_0 in the cache */

/* replace567_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace567 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &replace2_1_1.value },
   NULL,
};

   /* search568_0 -> search93_0 in the cache */

/* search568_1_0 -> replace144_1_1 in the cache */

/* search568_1_1 -> replace2_1_1 in the cache */
/* search568_1 -> search566_1 in the cache */
static const nir_search_expression search568 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search93_0.value, &search566_1.value },
   NULL,
};

   /* replace568_0 -> search93_0 in the cache */

/* replace568_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace568 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &replace2_1_1.value },
   NULL,
};

   /* search569_0_0 -> search2_0 in the cache */

/* search569_0_1 -> replace9 in the cache */
static const nir_search_expression search569_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

/* search569_1_0 -> search2_0 in the cache */

/* search569_1_1 -> replace2_1_0 in the cache */
static const nir_search_expression search569_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};
static const nir_search_expression search569 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search569_0.value, &search569_1.value },
   NULL,
};

   /* replace569_0 -> replace2_1_0 in the cache */

/* replace569_1 -> search2_0 in the cache */
static const nir_search_expression replace569 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace2_1_0.value, &search2_0.value },
   NULL,
};

   /* search570_0_0 -> replace2_1_0 in the cache */

/* search570_0_1 -> search2_0 in the cache */
/* search570_0 -> replace569 in the cache */

/* search570_1_0 -> search2_0 in the cache */

static const nir_search_constant search570_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search570_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search570_1_1.value },
   NULL,
};
static const nir_search_expression search570 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace569.value, &search570_1.value },
   NULL,
};

   /* replace570_0 -> search570_1_1 in the cache */

/* replace570_1 -> search2_0 in the cache */
static const nir_search_expression replace570 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search570_1_1.value, &search2_0.value },
   NULL,
};

   /* search571_0_0 -> search570_1_1 in the cache */

/* search571_0_1 -> search2_0 in the cache */
/* search571_0 -> replace570 in the cache */

/* search571_1_0 -> search2_0 in the cache */

static const nir_search_constant search571_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression search571_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search571_1_1.value },
   NULL,
};
static const nir_search_expression search571 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace570.value, &search571_1.value },
   NULL,
};

   /* replace571_0 -> search571_1_1 in the cache */

/* replace571_1 -> search2_0 in the cache */
static const nir_search_expression replace571 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search571_1_1.value, &search2_0.value },
   NULL,
};

   /* search572_0 -> replace116_0 in the cache */

/* search572_1_0 -> replace116_0 in the cache */

/* search572_1_1 -> replace189 in the cache */
static const nir_search_expression search572_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace116_0.value, &replace189.value },
   NULL,
};
static const nir_search_expression search572 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace116_0.value, &search572_1.value },
   NULL,
};

   /* replace572 -> replace255 in the cache */

   /* search573_0 -> search2_0 in the cache */

/* search573_1_0 -> search2_0 in the cache */
static const nir_search_expression search573_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search573 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &search573_1.value },
   NULL,
};

   /* replace573 -> search11_1 in the cache */

   /* search574_0_0_0 -> replace116_0 in the cache */
/* search574_0_0 -> search251_0 in the cache */
static const nir_search_expression search574_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search251_0.value },
   NULL,
};

/* search574_1_0_0 -> search212_0_1_0 in the cache */
static const nir_search_expression search574_1_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search212_0_1_0.value },
   NULL,
};
static const nir_search_expression search574_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search574_1_0.value },
   NULL,
};
static const nir_search_expression search574 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search574_0.value, &search574_1.value },
   NULL,
};

   /* replace574_0 -> replace116_0 in the cache */

/* replace574_1 -> search212_0_1_0 in the cache */
static const nir_search_expression replace574 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace116_0.value, &search212_0_1_0.value },
   NULL,
};

   /* search575_0_0 -> replace116_0 in the cache */

/* search575_0_1 -> search212_0_1_0 in the cache */
/* search575_0 -> replace574 in the cache */
static const nir_search_expression search575 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace574.value },
   NULL,
};

   /* replace575_0_0 -> replace116_0 in the cache */

/* replace575_0_1 -> search212_0_1_0 in the cache */
/* replace575_0 -> replace217 in the cache */
static const nir_search_expression replace575 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace217.value },
   NULL,
};

   /* search576_0_0_0_0_0 -> search2_0 in the cache */

/* search576_0_0_0_0_1 -> replace9 in the cache */
static const nir_search_expression search576_0_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

/* search576_0_0_0_1 -> search212_0_1_0 in the cache */
static const nir_search_expression search576_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ior,
   { &search576_0_0_0_0.value, &search212_0_1_0.value },
   NULL,
};

/* search576_0_0_1 -> search73_2_0 in the cache */
static const nir_search_expression search576_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 3,
   nir_op_iand,
   { &search576_0_0_0.value, &search73_2_0.value },
   NULL,
};
static const nir_search_expression search576_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search576_0_0.value },
   NULL,
};

/* search576_1_0 -> search2_0 in the cache */

/* search576_1_1 -> replace9 in the cache */
/* search576_1 -> replace263 in the cache */
static const nir_search_expression search576 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &search576_0.value, &replace263.value },
   NULL,
};

   /* replace576_0_0_0 -> search212_0_1_0 in the cache */

/* replace576_0_0_1 -> search73_2_0 in the cache */
static const nir_search_expression replace576_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search212_0_1_0.value, &search73_2_0.value },
   NULL,
};
static const nir_search_expression replace576_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace576_0_0.value },
   NULL,
};

/* replace576_1_0 -> search2_0 in the cache */

/* replace576_1_1 -> replace9 in the cache */
/* replace576_1 -> replace263 in the cache */
static const nir_search_expression replace576 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace576_0.value, &replace263.value },
   NULL,
};

   /* search577_0_0_0_0_0 -> search0_0 in the cache */

/* search577_0_0_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search577_0_0_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   3, 1,
   nir_op_umin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search577_0_0_0_1 -> replace19_1 in the cache */
static const nir_search_expression search577_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ieq,
   { &search577_0_0_0_0.value, &replace19_1.value },
   NULL,
};

/* search577_0_0_1 -> search73_2_0 in the cache */
static const nir_search_expression search577_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 3,
   nir_op_iand,
   { &search577_0_0_0.value, &search73_2_0.value },
   NULL,
};
static const nir_search_expression search577_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search577_0_0.value },
   NULL,
};

/* search577_1_0 -> search0_0 in the cache */

/* search577_1_1 -> replace19_1 in the cache */
static const nir_search_expression search577_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace19_1.value },
   NULL,
};
static const nir_search_expression search577 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &search577_0.value, &search577_1.value },
   NULL,
};

   /* replace577_0_0_0_0 -> replace0_1_0 in the cache */

/* replace577_0_0_0_1 -> replace19_1 in the cache */
static const nir_search_expression replace577_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &replace19_1.value },
   NULL,
};

/* replace577_0_0_1 -> search73_2_0 in the cache */
static const nir_search_expression replace577_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 2,
   nir_op_iand,
   { &replace577_0_0_0.value, &search73_2_0.value },
   NULL,
};
static const nir_search_expression replace577_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &replace577_0_0.value },
   NULL,
};

/* replace577_1_0 -> search0_0 in the cache */

/* replace577_1_1 -> replace19_1 in the cache */
/* replace577_1 -> search577_1 in the cache */
static const nir_search_expression replace577 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace577_0.value, &search577_1.value },
   NULL,
};

   /* search578_0 -> search2_0 in the cache */

static const nir_search_variable search578_1_0 = {
   { nir_search_value_variable, -1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search578_1_1 -> search2_0 in the cache */
static const nir_search_expression search578_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search578 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search2_0.value, &search578_1.value },
   NULL,
};

   /* replace578_0 -> search2_0 in the cache */

/* replace578_1 -> search578_1_0 in the cache */
static const nir_search_expression replace578 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search579_0_0 -> search0_0 in the cache */

/* search579_0_1 -> replace0_1_0 in the cache */
/* search579_0 -> replace279 in the cache */

/* search579_1 -> search0_0 in the cache */
static const nir_search_expression search579 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace279.value, &search0_0.value },
   NULL,
};

   /* replace579_0 -> replace0_1_0 in the cache */

/* replace579_1 -> search0_0 in the cache */
/* replace579 -> search190_1 in the cache */

   /* search580_0 -> search2_0 in the cache */

/* search580_1_0 -> search578_1_0 in the cache */

/* search580_1_1 -> search2_0 in the cache */
static const nir_search_expression search580_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmin,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search580 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search2_0.value, &search580_1.value },
   NULL,
};

   /* replace580 -> replace255 in the cache */

   /* search581_0_0 -> search0_0 in the cache */

/* search581_0_1 -> replace0_1_0 in the cache */
/* search581_0 -> replace278 in the cache */

/* search581_1 -> search0_0 in the cache */
static const nir_search_expression search581 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace278.value, &search0_0.value },
   NULL,
};

   /* replace581 -> replace255 in the cache */

   /* search582_0 -> search2_0 in the cache */

/* search582_1_0 -> search578_1_0 in the cache */

/* search582_1_1 -> search2_0 in the cache */
/* search582_1 -> search580_1 in the cache */
static const nir_search_expression search582 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search2_0.value, &search580_1.value },
   NULL,
};

   /* replace582 -> replace189 in the cache */

   /* search583_0_0 -> search0_0 in the cache */

/* search583_0_1 -> replace0_1_0 in the cache */
/* search583_0 -> replace278 in the cache */

/* search583_1 -> search0_0 in the cache */
static const nir_search_expression search583 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace278.value, &search0_0.value },
   NULL,
};

   /* replace583 -> replace189 in the cache */

   /* search584_0 -> search2_0 in the cache */

/* search584_1_0 -> search578_1_0 in the cache */

/* search584_1_1 -> search2_0 in the cache */
/* search584_1 -> search578_1 in the cache */
static const nir_search_expression search584 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search2_0.value, &search578_1.value },
   NULL,
};

   /* replace584_0 -> search2_0 in the cache */

/* replace584_1 -> search578_1_0 in the cache */
static const nir_search_expression replace584 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search585_0_0 -> search0_0 in the cache */

/* search585_0_1 -> replace0_1_0 in the cache */
/* search585_0 -> replace279 in the cache */

/* search585_1 -> search0_0 in the cache */
static const nir_search_expression search585 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace279.value, &search0_0.value },
   NULL,
};

   /* replace585_0 -> replace0_1_0 in the cache */

/* replace585_1 -> search0_0 in the cache */
/* replace585 -> replace195 in the cache */

   /* search586_0 -> search2_0 in the cache */

/* search586_1_0 -> search578_1_0 in the cache */

/* search586_1_1 -> search2_0 in the cache */
static const nir_search_expression search586_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search586 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search586_1.value },
   NULL,
};

   /* replace586_0 -> search2_0 in the cache */

/* replace586_1 -> search578_1_0 in the cache */
static const nir_search_expression replace586 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search587_0_0 -> search0_0 in the cache */

/* search587_0_1 -> replace0_1_0 in the cache */
/* search587_0 -> replace308 in the cache */

/* search587_1 -> search0_0 in the cache */
static const nir_search_expression search587 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace308.value, &search0_0.value },
   NULL,
};

   /* replace587_0 -> replace0_1_0 in the cache */

/* replace587_1 -> search0_0 in the cache */
/* replace587 -> search192_1 in the cache */

   /* search588_0 -> search2_0 in the cache */

/* search588_1_0 -> search578_1_0 in the cache */

/* search588_1_1 -> search2_0 in the cache */
static const nir_search_expression search588_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search588 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search588_1.value },
   NULL,
};

   /* replace588 -> replace255 in the cache */

   /* search589_0_0 -> search0_0 in the cache */

/* search589_0_1 -> replace0_1_0 in the cache */
/* search589_0 -> replace305 in the cache */

/* search589_1 -> search0_0 in the cache */
static const nir_search_expression search589 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace305.value, &search0_0.value },
   NULL,
};

   /* replace589 -> replace255 in the cache */

   /* search590_0 -> search2_0 in the cache */

/* search590_1_0 -> search578_1_0 in the cache */

/* search590_1_1 -> search2_0 in the cache */
static const nir_search_expression search590_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search590 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search590_1.value },
   NULL,
};

   /* replace590_0 -> search2_0 in the cache */

/* replace590_1 -> search578_1_0 in the cache */
static const nir_search_expression replace590 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search591_0_0 -> search0_0 in the cache */

/* search591_0_1 -> replace0_1_0 in the cache */
/* search591_0 -> replace307 in the cache */

/* search591_1 -> search0_0 in the cache */
static const nir_search_expression search591 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace307.value, &search0_0.value },
   NULL,
};

   /* replace591_0 -> replace0_1_0 in the cache */

/* replace591_1 -> search0_0 in the cache */
/* replace591 -> search193_1 in the cache */

   /* search592_0 -> search2_0 in the cache */

/* search592_1_0 -> search578_1_0 in the cache */

/* search592_1_1 -> search2_0 in the cache */
static const nir_search_expression search592_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search592 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search592_1.value },
   NULL,
};

   /* replace592 -> replace255 in the cache */

   /* search593_0_0 -> search0_0 in the cache */

/* search593_0_1 -> replace0_1_0 in the cache */
/* search593_0 -> replace304 in the cache */

/* search593_1 -> search0_0 in the cache */
static const nir_search_expression search593 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace304.value, &search0_0.value },
   NULL,
};

   /* replace593 -> replace255 in the cache */

   /* search594_0 -> search2_0 in the cache */

/* search594_1_0 -> search578_1_0 in the cache */

/* search594_1_1 -> search2_0 in the cache */
/* search594_1 -> search588_1 in the cache */
static const nir_search_expression search594 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search588_1.value },
   NULL,
};

   /* replace594 -> replace189 in the cache */

   /* search595_0_0 -> search0_0 in the cache */

/* search595_0_1 -> replace0_1_0 in the cache */
/* search595_0 -> replace305 in the cache */

/* search595_1 -> search0_0 in the cache */
static const nir_search_expression search595 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace305.value, &search0_0.value },
   NULL,
};

   /* replace595 -> replace189 in the cache */

   /* search596_0 -> search2_0 in the cache */

/* search596_1_0 -> search578_1_0 in the cache */

/* search596_1_1 -> search2_0 in the cache */
/* search596_1 -> search586_1 in the cache */
static const nir_search_expression search596 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search586_1.value },
   NULL,
};

   /* replace596_0 -> search2_0 in the cache */

/* replace596_1 -> search578_1_0 in the cache */
static const nir_search_expression replace596 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search597_0_0 -> search0_0 in the cache */

/* search597_0_1 -> replace0_1_0 in the cache */
/* search597_0 -> replace308 in the cache */

/* search597_1 -> search0_0 in the cache */
static const nir_search_expression search597 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace308.value, &search0_0.value },
   NULL,
};

   /* replace597_0 -> replace0_1_0 in the cache */

/* replace597_1 -> search0_0 in the cache */
static const nir_search_expression replace597 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search598_0 -> search2_0 in the cache */

/* search598_1_0 -> search578_1_0 in the cache */

/* search598_1_1 -> search2_0 in the cache */
/* search598_1 -> search592_1 in the cache */
static const nir_search_expression search598 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search592_1.value },
   NULL,
};

   /* replace598 -> replace189 in the cache */

   /* search599_0_0 -> search0_0 in the cache */

/* search599_0_1 -> replace0_1_0 in the cache */
/* search599_0 -> replace304 in the cache */

/* search599_1 -> search0_0 in the cache */
static const nir_search_expression search599 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace304.value, &search0_0.value },
   NULL,
};

   /* replace599 -> replace189 in the cache */

   /* search600_0 -> search2_0 in the cache */

/* search600_1_0 -> search578_1_0 in the cache */

/* search600_1_1 -> search2_0 in the cache */
/* search600_1 -> search590_1 in the cache */
static const nir_search_expression search600 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search590_1.value },
   NULL,
};

   /* replace600_0 -> search2_0 in the cache */

/* replace600_1 -> search578_1_0 in the cache */
static const nir_search_expression replace600 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search578_1_0.value },
   NULL,
};

   /* search601_0_0 -> search0_0 in the cache */

/* search601_0_1 -> replace0_1_0 in the cache */
/* search601_0 -> replace307 in the cache */

/* search601_1 -> search0_0 in the cache */
static const nir_search_expression search601 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace307.value, &search0_0.value },
   NULL,
};

   /* replace601_0 -> replace0_1_0 in the cache */

/* replace601_1 -> search0_0 in the cache */
static const nir_search_expression replace601 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace0_1_0.value, &search0_0.value },
   NULL,
};

   /* search602_0 -> search2_0 in the cache */

/* search602_1_0 -> search578_1_0 in the cache */

/* search602_1_1 -> search2_0 in the cache */
static const nir_search_expression search602_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search578_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search602 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search602_1.value },
   NULL,
};

   /* replace602 -> replace189 in the cache */

   /* search603_0_0 -> search0_0 in the cache */

/* search603_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search603_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search603_1 -> search0_0 in the cache */
static const nir_search_expression search603 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search603_0.value, &search0_0.value },
   NULL,
};

   /* replace603 -> replace189 in the cache */

   /* search604_0 -> search2_0 in the cache */

/* search604_1_0 -> search578_1_0 in the cache */

/* search604_1_1 -> search2_0 in the cache */
/* search604_1 -> search602_1 in the cache */
static const nir_search_expression search604 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search602_1.value },
   NULL,
};

   /* replace604 -> replace255 in the cache */

   /* search605_0_0 -> search0_0 in the cache */

/* search605_0_1 -> replace0_1_0 in the cache */
/* search605_0 -> search603_0 in the cache */

/* search605_1 -> search0_0 in the cache */
static const nir_search_expression search605 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search603_0.value, &search0_0.value },
   NULL,
};

   /* replace605 -> replace255 in the cache */

   static const nir_search_variable search606_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search606_1_0 -> search131_0_0_1 in the cache */

/* search606_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search606_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search131_0_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search606 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search606_0.value, &search606_1.value },
   NULL,
};

   /* replace606_0_0 -> search36_0_0 in the cache */

/* replace606_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace606_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace606_1_0 -> search36_0_0 in the cache */

/* replace606_1_1 -> search36_1_1 in the cache */
/* replace606_1 -> search414_1 in the cache */
static const nir_search_expression replace606 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace606_0.value, &search414_1.value },
   NULL,
};

   /* search607_0_0 -> search606_0 in the cache */

/* search607_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search607_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search606_0.value, &search36_0_1.value },
   NULL,
};

/* search607_1 -> search131_0_1 in the cache */
static const nir_search_expression search607 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search607_0.value, &search131_0_1.value },
   NULL,
};

   /* replace607_0_0 -> search36_0_0 in the cache */

/* replace607_0_1 -> search36_1_1 in the cache */
/* replace607_0 -> search414_1 in the cache */

/* replace607_1_0 -> search36_0_1 in the cache */

/* replace607_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace607_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace607 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search414_1.value, &replace607_1.value },
   NULL,
};

   /* search608_0 -> search606_0 in the cache */

/* search608_1_0 -> search131_0_0_1 in the cache */

/* search608_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search608_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search131_0_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search608 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search606_0.value, &search608_1.value },
   NULL,
};

   /* replace608_0_0 -> search36_0_0 in the cache */

/* replace608_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace608_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace608_1_0 -> search36_0_0 in the cache */

/* replace608_1_1 -> search36_1_1 in the cache */
/* replace608_1 -> search416_1 in the cache */
static const nir_search_expression replace608 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace608_0.value, &search416_1.value },
   NULL,
};

   /* search609_0_0 -> search606_0 in the cache */

/* search609_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search609_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search606_0.value, &search36_0_1.value },
   NULL,
};

/* search609_1 -> search131_0_1 in the cache */
static const nir_search_expression search609 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search609_0.value, &search131_0_1.value },
   NULL,
};

   /* replace609_0_0 -> search36_0_0 in the cache */

/* replace609_0_1 -> search36_1_1 in the cache */
/* replace609_0 -> search416_1 in the cache */

/* replace609_1_0 -> search36_0_1 in the cache */

/* replace609_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace609_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace609 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search416_1.value, &replace609_1.value },
   NULL,
};

   /* search610_0 -> search606_0 in the cache */

/* search610_1_0 -> search131_0_0_1 in the cache */

/* search610_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search610_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search131_0_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search610 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search606_0.value, &search610_1.value },
   NULL,
};

   /* replace610_0_0 -> search36_0_0 in the cache */

/* replace610_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace610_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace610_1_0 -> search36_0_0 in the cache */

/* replace610_1_1 -> search36_1_1 in the cache */
/* replace610_1 -> search418_1 in the cache */
static const nir_search_expression replace610 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace610_0.value, &search418_1.value },
   NULL,
};

   /* search611_0_0 -> search606_0 in the cache */

/* search611_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search611_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search606_0.value, &search36_0_1.value },
   NULL,
};

/* search611_1 -> search131_0_1 in the cache */
static const nir_search_expression search611 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search611_0.value, &search131_0_1.value },
   NULL,
};

   /* replace611_0_0 -> search36_0_0 in the cache */

/* replace611_0_1 -> search36_1_1 in the cache */
/* replace611_0 -> search418_1 in the cache */

/* replace611_1_0 -> search36_0_1 in the cache */

/* replace611_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace611_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace611 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search418_1.value, &replace611_1.value },
   NULL,
};

   /* search612_0 -> search606_0 in the cache */

/* search612_1_0 -> search131_0_0_1 in the cache */

/* search612_1_1 -> search36_1_1 in the cache */
static const nir_search_expression search612_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search131_0_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression search612 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search606_0.value, &search612_1.value },
   NULL,
};

   /* replace612_0_0 -> search36_0_0 in the cache */

/* replace612_0_1 -> search36_0_1 in the cache */
static const nir_search_expression replace612_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search36_0_0.value, &search36_0_1.value },
   NULL,
};

/* replace612_1_0 -> search36_0_0 in the cache */

/* replace612_1_1 -> search36_1_1 in the cache */
/* replace612_1 -> search420_1 in the cache */
static const nir_search_expression replace612 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace612_0.value, &search420_1.value },
   NULL,
};

   /* search613_0_0 -> search606_0 in the cache */

/* search613_0_1 -> search36_0_1 in the cache */
static const nir_search_expression search613_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search606_0.value, &search36_0_1.value },
   NULL,
};

/* search613_1 -> search131_0_1 in the cache */
static const nir_search_expression search613 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search613_0.value, &search131_0_1.value },
   NULL,
};

   /* replace613_0_0 -> search36_0_0 in the cache */

/* replace613_0_1 -> search36_1_1 in the cache */
/* replace613_0 -> search420_1 in the cache */

/* replace613_1_0 -> search36_0_1 in the cache */

/* replace613_1_1 -> search36_1_1 in the cache */
static const nir_search_expression replace613_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search36_0_1.value, &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace613 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search420_1.value, &replace613_1.value },
   NULL,
};

   /* search614_0 -> search606_0 in the cache */

/* search614_1_0 -> search131_0_0_1 in the cache */

/* search614_1_1 -> search36_1_1 in the cache */
/* search614_1 -> search608_1 in the cache */
static const nir_search_expression search614 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search606_0.value, &search608_1.value },
   NULL,
};

   /* replace614_0_0 -> search36_0_0 in the cache */

/* replace614_0_1 -> search36_0_1 in the cache */
/* replace614_0 -> replace606_0 in the cache */

/* replace614_1_0 -> search36_0_0 in the cache */

/* replace614_1_1 -> search36_1_1 in the cache */
/* replace614_1 -> search414_1 in the cache */
static const nir_search_expression replace614 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace606_0.value, &search414_1.value },
   NULL,
};

   /* search615_0_0 -> search606_0 in the cache */

/* search615_0_1 -> search36_0_1 in the cache */
/* search615_0 -> search609_0 in the cache */

/* search615_1 -> search131_0_1 in the cache */
static const nir_search_expression search615 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search609_0.value, &search131_0_1.value },
   NULL,
};

   /* replace615_0_0 -> search36_0_0 in the cache */

/* replace615_0_1 -> search36_1_1 in the cache */
/* replace615_0 -> search414_1 in the cache */

/* replace615_1_0 -> search36_0_1 in the cache */

/* replace615_1_1 -> search36_1_1 in the cache */
/* replace615_1 -> replace607_1 in the cache */
static const nir_search_expression replace615 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search414_1.value, &replace607_1.value },
   NULL,
};

   /* search616_0 -> search606_0 in the cache */

/* search616_1_0 -> search131_0_0_1 in the cache */

/* search616_1_1 -> search36_1_1 in the cache */
/* search616_1 -> search606_1 in the cache */
static const nir_search_expression search616 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search606_0.value, &search606_1.value },
   NULL,
};

   /* replace616_0_0 -> search36_0_0 in the cache */

/* replace616_0_1 -> search36_0_1 in the cache */
/* replace616_0 -> replace608_0 in the cache */

/* replace616_1_0 -> search36_0_0 in the cache */

/* replace616_1_1 -> search36_1_1 in the cache */
/* replace616_1 -> search416_1 in the cache */
static const nir_search_expression replace616 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace608_0.value, &search416_1.value },
   NULL,
};

   /* search617_0_0 -> search606_0 in the cache */

/* search617_0_1 -> search36_0_1 in the cache */
/* search617_0 -> search607_0 in the cache */

/* search617_1 -> search131_0_1 in the cache */
static const nir_search_expression search617 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search607_0.value, &search131_0_1.value },
   NULL,
};

   /* replace617_0_0 -> search36_0_0 in the cache */

/* replace617_0_1 -> search36_1_1 in the cache */
/* replace617_0 -> search416_1 in the cache */

/* replace617_1_0 -> search36_0_1 in the cache */

/* replace617_1_1 -> search36_1_1 in the cache */
/* replace617_1 -> replace609_1 in the cache */
static const nir_search_expression replace617 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search416_1.value, &replace609_1.value },
   NULL,
};

   /* search618_0 -> search606_0 in the cache */

/* search618_1_0 -> search131_0_0_1 in the cache */

/* search618_1_1 -> search36_1_1 in the cache */
/* search618_1 -> search612_1 in the cache */
static const nir_search_expression search618 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search606_0.value, &search612_1.value },
   NULL,
};

   /* replace618_0_0 -> search36_0_0 in the cache */

/* replace618_0_1 -> search36_0_1 in the cache */
/* replace618_0 -> replace610_0 in the cache */

/* replace618_1_0 -> search36_0_0 in the cache */

/* replace618_1_1 -> search36_1_1 in the cache */
/* replace618_1 -> search418_1 in the cache */
static const nir_search_expression replace618 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace610_0.value, &search418_1.value },
   NULL,
};

   /* search619_0_0 -> search606_0 in the cache */

/* search619_0_1 -> search36_0_1 in the cache */
/* search619_0 -> search613_0 in the cache */

/* search619_1 -> search131_0_1 in the cache */
static const nir_search_expression search619 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search613_0.value, &search131_0_1.value },
   NULL,
};

   /* replace619_0_0 -> search36_0_0 in the cache */

/* replace619_0_1 -> search36_1_1 in the cache */
/* replace619_0 -> search418_1 in the cache */

/* replace619_1_0 -> search36_0_1 in the cache */

/* replace619_1_1 -> search36_1_1 in the cache */
/* replace619_1 -> replace611_1 in the cache */
static const nir_search_expression replace619 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search418_1.value, &replace611_1.value },
   NULL,
};

   /* search620_0 -> search606_0 in the cache */

/* search620_1_0 -> search131_0_0_1 in the cache */

/* search620_1_1 -> search36_1_1 in the cache */
/* search620_1 -> search610_1 in the cache */
static const nir_search_expression search620 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search606_0.value, &search610_1.value },
   NULL,
};

   /* replace620_0_0 -> search36_0_0 in the cache */

/* replace620_0_1 -> search36_0_1 in the cache */
/* replace620_0 -> replace612_0 in the cache */

/* replace620_1_0 -> search36_0_0 in the cache */

/* replace620_1_1 -> search36_1_1 in the cache */
/* replace620_1 -> search420_1 in the cache */
static const nir_search_expression replace620 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace612_0.value, &search420_1.value },
   NULL,
};

   /* search621_0_0 -> search606_0 in the cache */

/* search621_0_1 -> search36_0_1 in the cache */
/* search621_0 -> search611_0 in the cache */

/* search621_1 -> search131_0_1 in the cache */
static const nir_search_expression search621 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search611_0.value, &search131_0_1.value },
   NULL,
};

   /* replace621_0_0 -> search36_0_0 in the cache */

/* replace621_0_1 -> search36_1_1 in the cache */
/* replace621_0 -> search420_1 in the cache */

/* replace621_1_0 -> search36_0_1 in the cache */

/* replace621_1_1 -> search36_1_1 in the cache */
/* replace621_1 -> replace613_1 in the cache */
static const nir_search_expression replace621 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search420_1.value, &replace613_1.value },
   NULL,
};

   /* search622_0_0 -> search2_0 in the cache */

/* search622_0_1 -> replace9 in the cache */
/* search622_0 -> replace263 in the cache */

/* search622_1_0_0 -> search2_0 in the cache */

/* search622_1_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search622_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search622_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search622_1_0.value },
   NULL,
};

/* search622_2_0 -> search2_0 in the cache */

/* search622_2_1 -> replace2_1_1 in the cache */
/* search622_2 -> search622_1_0 in the cache */
static const nir_search_expression search622 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace263.value, &search622_1.value, &search622_1_0.value },
   NULL,
};

   /* replace622_0_0 -> search2_0 in the cache */

/* replace622_0_1 -> replace2_1_1 in the cache */
/* replace622_0 -> search622_1_0 in the cache */
static const nir_search_expression replace622 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search622_1_0.value },
   NULL,
};

   /* search623_0_0_0 -> search2_0 in the cache */
/* search623_0_0 -> search26_0 in the cache */

/* search623_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search623_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search26_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search623 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search623_0.value },
   NULL,
};

   /* replace623_0_0 -> search2_0 in the cache */
/* replace623_0 -> search26_0 in the cache */

/* replace623_1 -> replace2_1_1 in the cache */
/* replace623 -> search623_0 in the cache */

   /* search624_0_0 -> search3_0_0 in the cache */

/* search624_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search624_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_slt,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search624 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search624_0.value },
   NULL,
};

   /* replace624_0 -> search3_0_0 in the cache */

/* replace624_1 -> replace2_1_1 in the cache */
/* replace624 -> search624_0 in the cache */

   /* search625_0_0 -> search0_0 in the cache */

/* search625_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search625_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search625 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search625_0.value },
   NULL,
};

   /* replace625_0 -> search0_0 in the cache */

/* replace625_1 -> replace0_1_0 in the cache */
/* replace625 -> search625_0 in the cache */

   /* search626_0_0 -> search3_0_0 in the cache */

/* search626_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search626_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search626 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search626_0.value },
   NULL,
};

   /* replace626_0 -> search3_0_0 in the cache */

/* replace626_1 -> replace2_1_1 in the cache */
/* replace626 -> search626_0 in the cache */

   /* search627_0_0 -> search3_0_0 in the cache */

/* search627_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search627_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search627 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search627_0.value },
   NULL,
};

   /* replace627_0 -> search3_0_0 in the cache */

/* replace627_1 -> replace2_1_1 in the cache */
/* replace627 -> search627_0 in the cache */

   /* search628_0 -> search3_0_0 in the cache */

/* search628_1 -> replace2_1_1 in the cache */
/* search628 -> search624_0 in the cache */

   /* replace628_0_0 -> search3_0_0 in the cache */

/* replace628_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace628_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace628 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace628_0.value },
   NULL,
};

   /* search629_0 -> search0_0 in the cache */

/* search629_1 -> replace0_1_0 in the cache */
/* search629 -> search625_0 in the cache */

   /* replace629_0_0 -> search0_0 in the cache */

/* replace629_0_1 -> replace0_1_0 in the cache */
/* replace629_0 -> replace179 in the cache */
static const nir_search_expression replace629 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace179.value },
   NULL,
};

   /* search630_0 -> search3_0_0 in the cache */

/* search630_1 -> replace2_1_1 in the cache */
/* search630 -> search626_0 in the cache */

   /* replace630_0_0 -> search3_0_0 in the cache */

/* replace630_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace630_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace630 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace630_0.value },
   NULL,
};

   /* search631_0 -> search3_0_0 in the cache */

/* search631_1 -> replace2_1_1 in the cache */
/* search631 -> search627_0 in the cache */

   /* replace631_0_0 -> search3_0_0 in the cache */

/* replace631_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace631_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace631 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace631_0.value },
   NULL,
};

   /* search632_0_0 -> search3_0_0 in the cache */

/* search632_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search632_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* search632_1 -> replace86_0_0 in the cache */
static const nir_search_expression search632 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search632_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace632_0 -> search3_0_0 in the cache */

/* replace632_1 -> replace2_1_1 in the cache */
/* replace632 -> search626_0 in the cache */

   /* search633_0_0 -> search3_0_0 in the cache */

/* search633_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search633_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* search633_1 -> replace86_0_0 in the cache */
static const nir_search_expression search633 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search633_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace633_0 -> search3_0_0 in the cache */

/* replace633_1 -> replace2_1_1 in the cache */
/* replace633 -> search627_0 in the cache */

   /* search634_0_0 -> search3_0_0 in the cache */

/* search634_0_1 -> replace2_1_1 in the cache */
/* search634_0 -> search624_0 in the cache */

/* search634_1 -> replace86_0_0 in the cache */
static const nir_search_expression search634 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search624_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace634_0 -> search3_0_0 in the cache */

/* replace634_1 -> replace2_1_1 in the cache */
/* replace634 -> search624_0 in the cache */

   /* search635_0_0 -> search3_0_0 in the cache */

/* search635_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search635_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* search635_1 -> replace86_0_0 in the cache */
static const nir_search_expression search635 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search635_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace635_0 -> search3_0_0 in the cache */

/* replace635_1 -> replace2_1_1 in the cache */
/* replace635 -> search635_0 in the cache */

   /* search636_0_0 -> search3_0_0 in the cache */

/* search636_0_1 -> replace2_1_1 in the cache */
/* search636_0 -> search632_0 in the cache */

/* search636_1 -> search32_1 in the cache */
static const nir_search_expression search636 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search632_0.value, &search32_1.value },
   NULL,
};

   /* replace636_0 -> search3_0_0 in the cache */

/* replace636_1 -> replace2_1_1 in the cache */
/* replace636 -> search626_0 in the cache */

   /* search637_0_0 -> search3_0_0 in the cache */

/* search637_0_1 -> replace2_1_1 in the cache */
/* search637_0 -> search633_0 in the cache */

/* search637_1 -> search32_1 in the cache */
static const nir_search_expression search637 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search633_0.value, &search32_1.value },
   NULL,
};

   /* replace637_0 -> search3_0_0 in the cache */

/* replace637_1 -> replace2_1_1 in the cache */
/* replace637 -> search627_0 in the cache */

   /* search638_0_0 -> search3_0_0 in the cache */

/* search638_0_1 -> replace2_1_1 in the cache */
/* search638_0 -> search624_0 in the cache */

/* search638_1 -> search32_1 in the cache */
static const nir_search_expression search638 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search624_0.value, &search32_1.value },
   NULL,
};

   /* replace638_0 -> search3_0_0 in the cache */

/* replace638_1 -> replace2_1_1 in the cache */
/* replace638 -> search624_0 in the cache */

   /* search639_0_0 -> search3_0_0 in the cache */

/* search639_0_1 -> replace2_1_1 in the cache */
/* search639_0 -> search635_0 in the cache */

/* search639_1 -> search32_1 in the cache */
static const nir_search_expression search639 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search635_0.value, &search32_1.value },
   NULL,
};

   /* replace639_0 -> search3_0_0 in the cache */

/* replace639_1 -> replace2_1_1 in the cache */
/* replace639 -> search635_0 in the cache */

   /* search640_0_0 -> search3_0_0 in the cache */

/* search640_0_1 -> replace2_1_1 in the cache */
/* search640_0 -> search632_0 in the cache */

/* search640_1 -> search32_1 in the cache */
static const nir_search_expression search640 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search632_0.value, &search32_1.value },
   NULL,
};

   /* replace640_0 -> search3_0_0 in the cache */

/* replace640_1 -> replace2_1_1 in the cache */
/* replace640 -> search627_0 in the cache */

   /* search641_0_0 -> search3_0_0 in the cache */

/* search641_0_1 -> replace2_1_1 in the cache */
/* search641_0 -> search633_0 in the cache */

/* search641_1 -> search32_1 in the cache */
static const nir_search_expression search641 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search633_0.value, &search32_1.value },
   NULL,
};

   /* replace641_0 -> search3_0_0 in the cache */

/* replace641_1 -> replace2_1_1 in the cache */
/* replace641 -> search626_0 in the cache */

   /* search642_0_0 -> search3_0_0 in the cache */

/* search642_0_1 -> replace2_1_1 in the cache */
/* search642_0 -> search624_0 in the cache */

/* search642_1 -> search32_1 in the cache */
static const nir_search_expression search642 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search624_0.value, &search32_1.value },
   NULL,
};

   /* replace642_0 -> search3_0_0 in the cache */

/* replace642_1 -> replace2_1_1 in the cache */
/* replace642 -> search635_0 in the cache */

   /* search643_0_0 -> search3_0_0 in the cache */

/* search643_0_1 -> replace2_1_1 in the cache */
/* search643_0 -> search635_0 in the cache */

/* search643_1 -> search32_1 in the cache */
static const nir_search_expression search643 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search635_0.value, &search32_1.value },
   NULL,
};

   /* replace643_0 -> search3_0_0 in the cache */

/* replace643_1 -> replace2_1_1 in the cache */
/* replace643 -> search624_0 in the cache */

   /* search644_0_0 -> search3_0_0 in the cache */

/* search644_0_1 -> replace2_1_1 in the cache */
/* search644_0 -> search632_0 in the cache */

/* search644_1 -> replace86_0_0 in the cache */
static const nir_search_expression search644 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search632_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace644_0 -> search3_0_0 in the cache */

/* replace644_1 -> replace2_1_1 in the cache */
/* replace644 -> search627_0 in the cache */

   /* search645_0_0 -> search3_0_0 in the cache */

/* search645_0_1 -> replace2_1_1 in the cache */
/* search645_0 -> search633_0 in the cache */

/* search645_1 -> replace86_0_0 in the cache */
static const nir_search_expression search645 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search633_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace645_0 -> search3_0_0 in the cache */

/* replace645_1 -> replace2_1_1 in the cache */
/* replace645 -> search626_0 in the cache */

   /* search646_0_0 -> search3_0_0 in the cache */

/* search646_0_1 -> replace2_1_1 in the cache */
/* search646_0 -> search624_0 in the cache */

/* search646_1 -> replace86_0_0 in the cache */
static const nir_search_expression search646 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search624_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace646_0 -> search3_0_0 in the cache */

/* replace646_1 -> replace2_1_1 in the cache */
/* replace646 -> search635_0 in the cache */

   /* search647_0_0 -> search3_0_0 in the cache */

/* search647_0_1 -> replace2_1_1 in the cache */
/* search647_0 -> search635_0 in the cache */

/* search647_1 -> replace86_0_0 in the cache */
static const nir_search_expression search647 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search635_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace647_0 -> search3_0_0 in the cache */

/* replace647_1 -> replace2_1_1 in the cache */
/* replace647 -> search624_0 in the cache */

   /* search648_0 -> search3_0_0 in the cache */

/* search648_1 -> replace2_1_1 in the cache */
static const nir_search_expression search648 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal2,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   static const nir_search_variable replace648_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace648_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace648_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &replace648_0_0.value, &replace648_0_1.value },
   NULL,
};

static const nir_search_variable replace648_1_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace648_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace648_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &replace648_1_0.value, &replace648_1_1.value },
   NULL,
};
static const nir_search_expression replace648 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmin,
   { &replace648_0.value, &replace648_1.value },
   NULL,
};

   /* search649_0 -> search3_0_0 in the cache */

/* search649_1 -> replace2_1_1 in the cache */
static const nir_search_expression search649 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal3,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace649_0_0 -> search3_0_0 in the cache */

/* replace649_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace649_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal3,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace649_1 -> search32_1 in the cache */
static const nir_search_expression replace649 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace649_0.value, &search32_1.value },
   NULL,
};

   /* search650_0 -> search3_0_0 in the cache */

/* search650_1 -> replace2_1_1 in the cache */
static const nir_search_expression search650 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal4,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace650_0_0 -> search3_0_0 in the cache */

/* replace650_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace650_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal4,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

/* replace650_1 -> search32_1 in the cache */
static const nir_search_expression replace650 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace650_0.value, &search32_1.value },
   NULL,
};

   /* search651_0 -> search3_0_0 in the cache */

/* search651_1 -> replace2_1_1 in the cache */
static const nir_search_expression search651 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal2,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace651_0_0 -> replace648_0_0 in the cache */

/* replace651_0_1 -> replace648_0_1 in the cache */
static const nir_search_expression replace651_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &replace648_0_0.value, &replace648_0_1.value },
   NULL,
};

/* replace651_1_0 -> replace648_1_0 in the cache */

/* replace651_1_1 -> replace648_1_1 in the cache */
static const nir_search_expression replace651_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &replace648_1_0.value, &replace648_1_1.value },
   NULL,
};
static const nir_search_expression replace651 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &replace651_0.value, &replace651_1.value },
   NULL,
};

   /* search652_0 -> search3_0_0 in the cache */

/* search652_1 -> replace2_1_1 in the cache */
static const nir_search_expression search652 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal3,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace652_0_0_0 -> search3_0_0 in the cache */

/* replace652_0_0_1 -> replace2_1_1 in the cache */
/* replace652_0_0 -> search627_0 in the cache */

/* replace652_0_1_0 -> search3_0_0 in the cache */

/* replace652_0_1_1 -> replace2_1_1 in the cache */
/* replace652_0_1 -> search633_0 in the cache */
static const nir_search_expression replace652_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot3,
   { &search627_0.value, &search633_0.value },
   NULL,
};
static const nir_search_expression replace652 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace652_0.value },
   NULL,
};

   /* search653_0 -> search3_0_0 in the cache */

/* search653_1 -> replace2_1_1 in the cache */
static const nir_search_expression search653 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal4,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace653_0_0_0 -> search3_0_0 in the cache */

/* replace653_0_0_1 -> replace2_1_1 in the cache */
/* replace653_0_0 -> search627_0 in the cache */

/* replace653_0_1_0 -> search3_0_0 in the cache */

/* replace653_0_1_1 -> replace2_1_1 in the cache */
/* replace653_0_1 -> search633_0 in the cache */
static const nir_search_expression replace653_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot4,
   { &search627_0.value, &search633_0.value },
   NULL,
};
static const nir_search_expression replace653 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace653_0.value },
   NULL,
};

   /* search654_0 -> search0_0 in the cache */

/* search654_1 -> replace0_1_0 in the cache */
static const nir_search_expression search654 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace654_0_0 -> replace117_0_0 in the cache */

static const nir_search_variable replace654_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace654_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace654_1_0 -> replace117_0_1 in the cache */

static const nir_search_variable replace654_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace654_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace654 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace654_0.value, &replace654_1.value },
   NULL,
};

   /* search655_0 -> search0_0 in the cache */

/* search655_1 -> replace0_1_0 in the cache */
static const nir_search_expression search655 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace655_0_0_0 -> replace117_0_0 in the cache */

/* replace655_0_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace655_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace655_0_1_0 -> replace117_0_1 in the cache */

/* replace655_0_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace655_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace655_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace655_0_0.value, &replace655_0_1.value },
   NULL,
};

/* replace655_1_0 -> replace117_0_2 in the cache */

static const nir_search_variable replace655_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {2},
};
static const nir_search_expression replace655_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};
static const nir_search_expression replace655 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &replace655_0.value, &replace655_1.value },
   NULL,
};

   /* search656_0 -> search0_0 in the cache */

/* search656_1 -> replace0_1_0 in the cache */
static const nir_search_expression search656 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_iequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace656_0_0_0 -> replace117_0_0 in the cache */

/* replace656_0_0_1 -> replace654_0_1 in the cache */
/* replace656_0_0 -> replace654_0 in the cache */

/* replace656_0_1_0 -> replace117_0_1 in the cache */

/* replace656_0_1_1 -> replace654_1_1 in the cache */
/* replace656_0_1 -> replace654_1 in the cache */
/* replace656_0 -> replace654 in the cache */

/* replace656_1_0_0 -> replace117_0_2 in the cache */

/* replace656_1_0_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace656_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};

static const nir_search_variable replace656_1_1_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {3},
};

static const nir_search_variable replace656_1_1_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {3},
};
static const nir_search_expression replace656_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ieq,
   { &replace656_1_1_0.value, &replace656_1_1_1.value },
   NULL,
};
static const nir_search_expression replace656_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace656_1_0.value, &replace656_1_1.value },
   NULL,
};
static const nir_search_expression replace656 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_iand,
   { &replace654.value, &replace656_1.value },
   NULL,
};

   /* search657_0 -> search0_0 in the cache */

/* search657_1 -> replace0_1_0 in the cache */
static const nir_search_expression search657 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace657_0_0 -> replace117_0_0 in the cache */

/* replace657_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace657_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace657_1_0 -> replace117_0_1 in the cache */

/* replace657_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace657_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace657 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace657_0.value, &replace657_1.value },
   NULL,
};

   /* search658_0 -> search0_0 in the cache */

/* search658_1 -> replace0_1_0 in the cache */
static const nir_search_expression search658 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace658_0_0_0 -> replace117_0_0 in the cache */

/* replace658_0_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace658_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace658_0_1_0 -> replace117_0_1 in the cache */

/* replace658_0_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace658_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace658_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace658_0_0.value, &replace658_0_1.value },
   NULL,
};

/* replace658_1_0 -> replace117_0_2 in the cache */

/* replace658_1_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace658_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ine,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};
static const nir_search_expression replace658 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_ior,
   { &replace658_0.value, &replace658_1.value },
   NULL,
};

   /* search659_0 -> search0_0 in the cache */

/* search659_1 -> replace0_1_0 in the cache */
static const nir_search_expression search659 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_inequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace659_0_0_0 -> replace117_0_0 in the cache */

/* replace659_0_0_1 -> replace654_0_1 in the cache */
/* replace659_0_0 -> replace657_0 in the cache */

/* replace659_0_1_0 -> replace117_0_1 in the cache */

/* replace659_0_1_1 -> replace654_1_1 in the cache */
/* replace659_0_1 -> replace657_1 in the cache */
/* replace659_0 -> replace657 in the cache */

/* replace659_1_0_0 -> replace117_0_2 in the cache */

/* replace659_1_0_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace659_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};

/* replace659_1_1_0 -> replace656_1_1_0 in the cache */

/* replace659_1_1_1 -> replace656_1_1_1 in the cache */
static const nir_search_expression replace659_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ine,
   { &replace656_1_1_0.value, &replace656_1_1_1.value },
   NULL,
};
static const nir_search_expression replace659_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace659_1_0.value, &replace659_1_1.value },
   NULL,
};
static const nir_search_expression replace659 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_ior,
   { &replace657.value, &replace659_1.value },
   NULL,
};

   /* search660_0 -> search0_0 in the cache */

/* search660_1 -> replace0_1_0 in the cache */
static const nir_search_expression search660 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace660_0_0 -> replace117_0_0 in the cache */

/* replace660_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace660_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace660_1_0 -> replace117_0_1 in the cache */

/* replace660_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace660_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace660 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace660_0.value, &replace660_1.value },
   NULL,
};

   /* search661_0 -> search0_0 in the cache */

/* search661_1 -> replace0_1_0 in the cache */
static const nir_search_expression search661 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace661_0_0_0 -> replace117_0_0 in the cache */

/* replace661_0_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace661_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace661_0_1_0 -> replace117_0_1 in the cache */

/* replace661_0_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace661_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace661_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace661_0_0.value, &replace661_0_1.value },
   NULL,
};

/* replace661_1_0 -> replace117_0_2 in the cache */

/* replace661_1_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace661_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_feq,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};
static const nir_search_expression replace661 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_iand,
   { &replace661_0.value, &replace661_1.value },
   NULL,
};

   /* search662_0 -> search0_0 in the cache */

/* search662_1 -> replace0_1_0 in the cache */
static const nir_search_expression search662 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ball_fequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace662_0_0_0 -> replace117_0_0 in the cache */

/* replace662_0_0_1 -> replace654_0_1 in the cache */
/* replace662_0_0 -> replace660_0 in the cache */

/* replace662_0_1_0 -> replace117_0_1 in the cache */

/* replace662_0_1_1 -> replace654_1_1 in the cache */
/* replace662_0_1 -> replace660_1 in the cache */
/* replace662_0 -> replace660 in the cache */

/* replace662_1_0_0 -> replace117_0_2 in the cache */

/* replace662_1_0_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace662_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};

/* replace662_1_1_0 -> replace656_1_1_0 in the cache */

/* replace662_1_1_1 -> replace656_1_1_1 in the cache */
static const nir_search_expression replace662_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_feq,
   { &replace656_1_1_0.value, &replace656_1_1_1.value },
   NULL,
};
static const nir_search_expression replace662_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_iand,
   { &replace662_1_0.value, &replace662_1_1.value },
   NULL,
};
static const nir_search_expression replace662 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_iand,
   { &replace660.value, &replace662_1.value },
   NULL,
};

   /* search663_0 -> search0_0 in the cache */

/* search663_1 -> replace0_1_0 in the cache */
static const nir_search_expression search663 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace663_0_0 -> replace117_0_0 in the cache */

/* replace663_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace663_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace663_1_0 -> replace117_0_1 in the cache */

/* replace663_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace663_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fneu,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace663 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace663_0.value, &replace663_1.value },
   NULL,
};

   /* search664_0 -> search0_0 in the cache */

/* search664_1 -> replace0_1_0 in the cache */
static const nir_search_expression search664 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace664_0_0_0 -> replace117_0_0 in the cache */

/* replace664_0_0_1 -> replace654_0_1 in the cache */
static const nir_search_expression replace664_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fneu,
   { &replace117_0_0.value, &replace654_0_1.value },
   NULL,
};

/* replace664_0_1_0 -> replace117_0_1 in the cache */

/* replace664_0_1_1 -> replace654_1_1 in the cache */
static const nir_search_expression replace664_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &replace117_0_1.value, &replace654_1_1.value },
   NULL,
};
static const nir_search_expression replace664_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace664_0_0.value, &replace664_0_1.value },
   NULL,
};

/* replace664_1_0 -> replace117_0_2 in the cache */

/* replace664_1_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace664_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_fneu,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};
static const nir_search_expression replace664 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 4,
   nir_op_ior,
   { &replace664_0.value, &replace664_1.value },
   NULL,
};

   /* search665_0 -> search0_0 in the cache */

/* search665_1 -> replace0_1_0 in the cache */
static const nir_search_expression search665 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_bany_fnequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace665_0_0_0 -> replace117_0_0 in the cache */

/* replace665_0_0_1 -> replace654_0_1 in the cache */
/* replace665_0_0 -> replace663_0 in the cache */

/* replace665_0_1_0 -> replace117_0_1 in the cache */

/* replace665_0_1_1 -> replace654_1_1 in the cache */
/* replace665_0_1 -> replace663_1 in the cache */
/* replace665_0 -> replace663 in the cache */

/* replace665_1_0_0 -> replace117_0_2 in the cache */

/* replace665_1_0_1 -> replace655_1_1 in the cache */
static const nir_search_expression replace665_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fneu,
   { &replace117_0_2.value, &replace655_1_1.value },
   NULL,
};

/* replace665_1_1_0 -> replace656_1_1_0 in the cache */

/* replace665_1_1_1 -> replace656_1_1_1 in the cache */
static const nir_search_expression replace665_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_fneu,
   { &replace656_1_1_0.value, &replace656_1_1_1.value },
   NULL,
};
static const nir_search_expression replace665_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_ior,
   { &replace665_1_0.value, &replace665_1_1.value },
   NULL,
};
static const nir_search_expression replace665 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 4,
   nir_op_ior,
   { &replace663.value, &replace665_1.value },
   NULL,
};

   /* search666_0_0 -> search2_0 in the cache */
/* search666_0 -> search22_0 in the cache */

/* search666_1 -> search2_0 in the cache */
static const nir_search_expression search666 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search22_0.value, &search2_0.value },
   NULL,
};

   /* replace666_0 -> search2_0 in the cache */

/* replace666_1 -> search30_1 in the cache */
/* replace666 -> replace265 in the cache */

   /* search667_0_0 -> search2_0 in the cache */
/* search667_0 -> search22_0 in the cache */

/* search667_1 -> search2_0 in the cache */
static const nir_search_expression search667 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search22_0.value, &search2_0.value },
   NULL,
};

   /* replace667_0 -> search2_0 in the cache */

/* replace667_1 -> search30_1 in the cache */
/* replace667 -> replace267 in the cache */

   /* search668_0_0 -> replace116_0 in the cache */
/* search668_0 -> search251_0 in the cache */

/* search668_1_0 -> search212_0_1_0 in the cache */
/* search668_1 -> search574_1_0 in the cache */
static const nir_search_expression search668 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search251_0.value, &search574_1_0.value },
   NULL,
};

   /* replace668_0_0 -> replace116_0 in the cache */

/* replace668_0_1 -> search212_0_1_0 in the cache */
/* replace668_0 -> replace215 in the cache */
static const nir_search_expression replace668 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace215.value },
   NULL,
};

   /* search669_0_0 -> replace116_0 in the cache */
/* search669_0 -> search251_0 in the cache */

/* search669_1_0 -> search212_0_1_0 in the cache */
/* search669_1 -> search574_1_0 in the cache */
static const nir_search_expression search669 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search251_0.value, &search574_1_0.value },
   NULL,
};

   /* replace669_0_0 -> replace116_0 in the cache */

/* replace669_0_1 -> search212_0_1_0 in the cache */
/* replace669_0 -> replace215 in the cache */
/* replace669 -> replace668 in the cache */

   /* search670_0_0 -> replace116_0 in the cache */
/* search670_0 -> search251_0 in the cache */

/* search670_1_0 -> search212_0_1_0 in the cache */
/* search670_1 -> search574_1_0 in the cache */
static const nir_search_expression search670 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search251_0.value, &search574_1_0.value },
   NULL,
};

   /* replace670_0_0 -> replace116_0 in the cache */

/* replace670_0_1 -> search212_0_1_0 in the cache */
/* replace670_0 -> replace212 in the cache */
static const nir_search_expression replace670 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace212.value },
   NULL,
};

   /* search671_0_0 -> replace116_0 in the cache */
/* search671_0 -> search210_1 in the cache */

/* search671_1_0 -> search212_0_1_0 in the cache */
/* search671_1 -> search212_0_1 in the cache */
static const nir_search_expression search671 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search210_1.value, &search212_0_1.value },
   NULL,
};

   /* replace671_0_0 -> replace116_0 in the cache */

/* replace671_0_1 -> search212_0_1_0 in the cache */
/* replace671_0 -> replace215 in the cache */
/* replace671 -> replace271_0 in the cache */

   /* search672_0_0_0 -> replace116_0 in the cache */
/* search672_0_0 -> search210_1 in the cache */

/* search672_0_1_0 -> search212_0_1_0 in the cache */
/* search672_0_1 -> search212_0_1 in the cache */
/* search672_0 -> search228_0_0 in the cache */
static const nir_search_expression search672 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search228_0_0.value },
   NULL,
};

   /* replace672_0_0 -> replace116_0 in the cache */

/* replace672_0_1 -> search212_0_1_0 in the cache */
/* replace672_0 -> replace212 in the cache */
/* replace672 -> replace270 in the cache */

   static const nir_search_variable search673_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search673_1 -> replace76_0_0 in the cache */
static const nir_search_expression search673 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search673_0.value, &replace76_0_0.value },
   NULL,
};

   /* replace673_0 -> search31_0 in the cache */
static const nir_search_expression replace673 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search31_0.value },
   NULL,
};

   static const nir_search_variable search674_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search674_1 -> replace86_0_0 in the cache */
static const nir_search_expression search674 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search674_0.value, &replace86_0_0.value },
   NULL,
};

   /* replace674_0 -> search3_0_0 in the cache */
static const nir_search_expression replace674 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search3_0_0.value },
   NULL,
};

   /* search675_0_0_0 -> replace116_0 in the cache */
/* search675_0_0 -> search210_1 in the cache */
/* search675_0 -> search211_0 in the cache */

/* search675_1 -> search251_1 in the cache */
static const nir_search_expression search675 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search211_0.value, &search251_1.value },
   NULL,
};

   /* replace675 -> replace116_0 in the cache */

   /* search676_0 -> search2_0 in the cache */

/* search676_1 -> search2_0 in the cache */
static const nir_search_expression search676 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace676 -> replace189 in the cache */

   /* search677_0 -> search2_0 in the cache */

/* search677_1 -> search2_0 in the cache */
static const nir_search_expression search677 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace677 -> replace255 in the cache */

   /* search678_0 -> search2_0 in the cache */

/* search678_1 -> search2_0 in the cache */
static const nir_search_expression search678 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ieq,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace678 -> replace255 in the cache */

   /* search679_0 -> search2_0 in the cache */

/* search679_1 -> search2_0 in the cache */
static const nir_search_expression search679 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ine,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace679 -> replace189 in the cache */

   /* search680_0 -> search2_0 in the cache */

/* search680_1 -> search2_0 in the cache */
static const nir_search_expression search680 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace680 -> replace189 in the cache */

   /* search681_0 -> search2_0 in the cache */

/* search681_1 -> search2_0 in the cache */
static const nir_search_expression search681 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace681 -> replace255 in the cache */

   /* search682_0 -> search2_0 in the cache */

/* search682_1 -> search2_0 in the cache */
static const nir_search_expression search682 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace682 -> replace189 in the cache */

   static const nir_search_variable search683_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search683_1 -> search2_0 in the cache */
static const nir_search_expression search683 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search683_0.value, &search2_0.value },
   NULL,
};

   /* replace683 -> replace255 in the cache */

   /* search684_0 -> search683_0 in the cache */

/* search684_1 -> search2_0 in the cache */
static const nir_search_expression search684 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_feq,
   { &search683_0.value, &search2_0.value },
   NULL,
};

   /* replace684 -> replace255 in the cache */

   /* search685_0 -> search683_0 in the cache */

/* search685_1 -> search2_0 in the cache */
static const nir_search_expression search685 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fneu,
   { &search683_0.value, &search2_0.value },
   NULL,
};

   /* replace685 -> replace189 in the cache */

   /* search686_0 -> search2_0 in the cache */

/* search686_1 -> search2_0 in the cache */
static const nir_search_expression search686 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iand,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace686 -> search2_0 in the cache */

   /* search687_0 -> search2_0 in the cache */

/* search687_1 -> search11_1 in the cache */
static const nir_search_expression search687 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search11_1.value },
   NULL,
};

   /* replace687 -> search2_0 in the cache */

   /* search688_0 -> search2_0 in the cache */

/* search688_1 -> replace9 in the cache */
static const nir_search_expression search688 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace688 -> replace9 in the cache */

   /* search689_0 -> search2_0 in the cache */

/* search689_1 -> search2_0 in the cache */
static const nir_search_expression search689 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ior,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace689 -> search2_0 in the cache */

   /* search690_0 -> search2_0 in the cache */

/* search690_1 -> replace9 in the cache */
static const nir_search_expression search690 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace690 -> search2_0 in the cache */

   /* search691_0 -> replace116_0 in the cache */

/* search691_1 -> replace255 in the cache */
static const nir_search_expression search691 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace116_0.value, &replace255.value },
   NULL,
};

   /* replace691 -> replace255 in the cache */

   /* search692_0 -> search2_0 in the cache */

/* search692_1 -> search2_0 in the cache */
static const nir_search_expression search692 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ixor,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace692 -> replace9 in the cache */

   /* search693_0 -> search2_0 in the cache */

/* search693_1 -> replace9 in the cache */
static const nir_search_expression search693 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace693 -> search2_0 in the cache */

   /* search694_0_0 -> search2_0 in the cache */
/* search694_0 -> search573_1 in the cache */
static const nir_search_expression search694 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search573_1.value },
   NULL,
};

   /* replace694 -> search2_0 in the cache */

   /* search695_0_0 -> search0_0 in the cache */

/* search695_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search695_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search695_1 -> replace0_1_0 in the cache */
static const nir_search_expression search695 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search695_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace695 -> replace0_1_0 in the cache */

   /* search696_0_0 -> search0_0 in the cache */

/* search696_0_1 -> replace0_1_0 in the cache */
/* search696_0 -> replace19_0_0 in the cache */

/* search696_1 -> replace0_1_0 in the cache */
static const nir_search_expression search696 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace19_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace696_0 -> search0_0 in the cache */

/* replace696_1 -> replace0_1_0 in the cache */
/* replace696 -> search603_0 in the cache */

   /* search697_0_0 -> search0_0 in the cache */

/* search697_0_1 -> replace0_1_0 in the cache */
/* search697_0 -> replace19_0_0 in the cache */

/* search697_1 -> replace0_1_0 in the cache */
static const nir_search_expression search697 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace19_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace697 -> replace0_1_0 in the cache */

   /* search698_0_0 -> search0_0 in the cache */

/* search698_0_1 -> replace0_1_0 in the cache */
/* search698_0 -> search695_0 in the cache */

/* search698_1 -> replace0_1_0 in the cache */
static const nir_search_expression search698 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search695_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace698_0 -> search0_0 in the cache */

/* replace698_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace698 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search699_0_0 -> search0_0 in the cache */
static const nir_search_expression search699_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search0_0.value },
   NULL,
};

/* search699_1_0 -> replace0_1_0 in the cache */
/* search699_1 -> replace21_1_1 in the cache */
static const nir_search_expression search699 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search699_0.value, &replace21_1_1.value },
   NULL,
};

   /* replace699_0_0 -> search0_0 in the cache */

/* replace699_0_1 -> replace0_1_0 in the cache */
/* replace699_0 -> search603_0 in the cache */
static const nir_search_expression replace699 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search603_0.value },
   NULL,
};

   /* search700_0_0 -> search0_0 in the cache */
/* search700_0 -> search699_0 in the cache */

/* search700_1_0 -> replace0_1_0 in the cache */
/* search700_1 -> replace21_1_1 in the cache */
static const nir_search_expression search700 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search699_0.value, &replace21_1_1.value },
   NULL,
};

   /* replace700_0_0 -> search0_0 in the cache */

/* replace700_0_1 -> replace0_1_0 in the cache */
/* replace700_0 -> replace698 in the cache */
static const nir_search_expression replace700 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace698.value },
   NULL,
};

   /* search701_0 -> search251_1 in the cache */

/* search701_1 -> search3_0_0 in the cache */
static const nir_search_expression search701 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search251_1.value, &search3_0_0.value },
   NULL,
};

   /* replace701 -> search251_1 in the cache */

   /* search702_0 -> search2_0 in the cache */

/* search702_1 -> search34_1 in the cache */
static const nir_search_expression search702 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search34_1.value },
   NULL,
};

   /* replace702 -> search2_0 in the cache */

   /* search703_0 -> search251_1 in the cache */

/* search703_1 -> search3_0_0 in the cache */
static const nir_search_expression search703 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search251_1.value, &search3_0_0.value },
   NULL,
};

   /* replace703 -> search251_1 in the cache */

   /* search704_0 -> search2_0 in the cache */

/* search704_1 -> search34_1 in the cache */
static const nir_search_expression search704 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &search34_1.value },
   NULL,
};

   /* replace704 -> search2_0 in the cache */

   /* search705_0 -> search251_1 in the cache */

/* search705_1 -> search3_0_0 in the cache */
static const nir_search_expression search705 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search251_1.value, &search3_0_0.value },
   NULL,
};

   /* replace705 -> search251_1 in the cache */

   /* search706_0 -> search2_0 in the cache */

/* search706_1 -> search34_1 in the cache */
static const nir_search_expression search706 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &search34_1.value },
   NULL,
};

   /* replace706 -> search2_0 in the cache */

   /* search707_0_0 -> search31_0 in the cache */

/* search707_0_1 -> replace2_1_1 in the cache */
/* search707_0 -> replace546 in the cache */

/* search707_1_0 -> search31_0 in the cache */

/* search707_1_1_0 -> replace136_0_1 in the cache */

/* search707_1_1_1_0 -> replace2_1_1 in the cache */
static const nir_search_expression search707_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search707_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace136_0_1.value, &search707_1_1_1.value },
   NULL,
};
static const nir_search_expression search707_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search31_0.value, &search707_1_1.value },
   NULL,
};
static const nir_search_expression search707 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace546.value, &search707_1.value },
   NULL,
};

   /* replace707_0 -> search31_0 in the cache */

/* replace707_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace707 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search31_0.value, &replace2_1_1.value },
   NULL,
};

   /* search708_0_0 -> search31_0 in the cache */

/* search708_0_1 -> replace2_1_1 in the cache */
/* search708_0 -> replace546 in the cache */

/* search708_1_0 -> search31_0 in the cache */

/* search708_1_1_0 -> replace136_0_1 in the cache */

/* search708_1_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search708_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace136_0_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search708_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search31_0.value, &search708_1_1.value },
   NULL,
};
static const nir_search_expression search708 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace546.value, &search708_1.value },
   NULL,
};

   /* replace708_0 -> search31_0 in the cache */

/* replace708_1 -> replace2_1_1 in the cache */
/* replace708 -> replace707 in the cache */

   /* search709_0_0 -> search3_0_0 in the cache */

/* search709_0_1 -> replace2_1_1 in the cache */
/* search709_0 -> replace556 in the cache */

/* search709_1_0 -> search3_0_0 in the cache */

/* search709_1_1_0 -> replace139_0_1 in the cache */

/* search709_1_1_1_0 -> replace2_1_1 in the cache */
/* search709_1_1_1 -> search707_1_1_1 in the cache */
static const nir_search_expression search709_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace139_0_1.value, &search707_1_1_1.value },
   NULL,
};
static const nir_search_expression search709_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search3_0_0.value, &search709_1_1.value },
   NULL,
};
static const nir_search_expression search709 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace556.value, &search709_1.value },
   NULL,
};

   /* replace709_0 -> search3_0_0 in the cache */

/* replace709_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace709 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search710_0_0 -> search3_0_0 in the cache */

/* search710_0_1 -> replace2_1_1 in the cache */
/* search710_0 -> replace556 in the cache */

/* search710_1_0 -> search3_0_0 in the cache */

/* search710_1_1_0 -> replace139_0_1 in the cache */

/* search710_1_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search710_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace139_0_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search710_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &search710_1_1.value },
   NULL,
};
static const nir_search_expression search710 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace556.value, &search710_1.value },
   NULL,
};

   /* replace710_0 -> search3_0_0 in the cache */

/* replace710_1 -> replace2_1_1 in the cache */
/* replace710 -> replace709 in the cache */

   /* search711_0_0 -> search31_0 in the cache */

/* search711_0_1 -> replace2_1_1 in the cache */
/* search711_0 -> replace548 in the cache */

/* search711_1_0 -> search31_0 in the cache */

/* search711_1_1_0 -> replace136_0_1 in the cache */

/* search711_1_1_1_0 -> replace2_1_1 in the cache */
/* search711_1_1_1 -> search707_1_1_1 in the cache */
/* search711_1_1 -> search707_1_1 in the cache */
static const nir_search_expression search711_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search31_0.value, &search707_1_1.value },
   NULL,
};
static const nir_search_expression search711 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace548.value, &search711_1.value },
   NULL,
};

   /* replace711_0 -> search31_0 in the cache */

/* replace711_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace711 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search31_0.value, &replace2_1_1.value },
   NULL,
};

   /* search712_0_0 -> search31_0 in the cache */

/* search712_0_1 -> replace2_1_1 in the cache */
/* search712_0 -> replace548 in the cache */

/* search712_1_0 -> search31_0 in the cache */

/* search712_1_1_0 -> replace136_0_1 in the cache */

/* search712_1_1_1 -> replace2_1_1 in the cache */
/* search712_1_1 -> search708_1_1 in the cache */
static const nir_search_expression search712_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search31_0.value, &search708_1_1.value },
   NULL,
};
static const nir_search_expression search712 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace548.value, &search712_1.value },
   NULL,
};

   /* replace712_0 -> search31_0 in the cache */

/* replace712_1 -> replace2_1_1 in the cache */
/* replace712 -> replace711 in the cache */

   /* search713_0_0 -> search3_0_0 in the cache */

/* search713_0_1 -> replace2_1_1 in the cache */
/* search713_0 -> replace558 in the cache */

/* search713_1_0 -> search3_0_0 in the cache */

/* search713_1_1_0 -> replace139_0_1 in the cache */

/* search713_1_1_1_0 -> replace2_1_1 in the cache */
/* search713_1_1_1 -> search707_1_1_1 in the cache */
/* search713_1_1 -> search709_1_1 in the cache */
static const nir_search_expression search713_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search3_0_0.value, &search709_1_1.value },
   NULL,
};
static const nir_search_expression search713 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace558.value, &search713_1.value },
   NULL,
};

   /* replace713_0 -> search3_0_0 in the cache */

/* replace713_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace713 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search714_0_0 -> search3_0_0 in the cache */

/* search714_0_1 -> replace2_1_1 in the cache */
/* search714_0 -> replace558 in the cache */

/* search714_1_0 -> search3_0_0 in the cache */

/* search714_1_1_0 -> replace139_0_1 in the cache */

/* search714_1_1_1 -> replace2_1_1 in the cache */
/* search714_1_1 -> search710_1_1 in the cache */
static const nir_search_expression search714_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &search710_1_1.value },
   NULL,
};
static const nir_search_expression search714 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace558.value, &search714_1.value },
   NULL,
};

   /* replace714_0 -> search3_0_0 in the cache */

/* replace714_1 -> replace2_1_1 in the cache */
/* replace714 -> replace713 in the cache */

   /* search715_0 -> search31_0 in the cache */

/* search715_1 -> replace2_1_1 in the cache */
/* search715 -> replace707 in the cache */

   /* replace715_0_0 -> search31_0 in the cache */

/* replace715_0_1 -> replace2_1_1 in the cache */
/* replace715_0 -> replace546 in the cache */

/* replace715_1_0 -> search31_0 in the cache */

/* replace715_1_1_0 -> replace136_0_1 in the cache */

/* replace715_1_1_1 -> replace2_1_1 in the cache */
/* replace715_1_1 -> search708_1_1 in the cache */
/* replace715_1 -> search708_1 in the cache */
/* replace715 -> search708 in the cache */

   /* search716_0 -> search3_0_0 in the cache */

/* search716_1 -> replace2_1_1 in the cache */
/* search716 -> replace709 in the cache */

   /* replace716_0_0 -> search3_0_0 in the cache */

/* replace716_0_1 -> replace2_1_1 in the cache */
/* replace716_0 -> replace556 in the cache */

/* replace716_1_0 -> search3_0_0 in the cache */

/* replace716_1_1_0 -> replace139_0_1 in the cache */

/* replace716_1_1_1 -> replace2_1_1 in the cache */
/* replace716_1_1 -> search710_1_1 in the cache */
/* replace716_1 -> search710_1 in the cache */
/* replace716 -> search710 in the cache */

   /* search717_0 -> search31_0 in the cache */

/* search717_1 -> replace2_1_1 in the cache */
/* search717 -> replace711 in the cache */

   /* replace717_0_0 -> search31_0 in the cache */

/* replace717_0_1 -> replace2_1_1 in the cache */
/* replace717_0 -> replace548 in the cache */

/* replace717_1_0 -> search31_0 in the cache */

/* replace717_1_1_0 -> replace136_0_1 in the cache */

/* replace717_1_1_1 -> replace2_1_1 in the cache */
/* replace717_1_1 -> search708_1_1 in the cache */
/* replace717_1 -> search712_1 in the cache */
/* replace717 -> search712 in the cache */

   /* search718_0 -> search3_0_0 in the cache */

/* search718_1 -> replace2_1_1 in the cache */
/* search718 -> replace713 in the cache */

   /* replace718_0_0 -> search3_0_0 in the cache */

/* replace718_0_1 -> replace2_1_1 in the cache */
/* replace718_0 -> replace558 in the cache */

/* replace718_1_0 -> search3_0_0 in the cache */

/* replace718_1_1_0 -> replace139_0_1 in the cache */

/* replace718_1_1_1 -> replace2_1_1 in the cache */
/* replace718_1_1 -> search710_1_1 in the cache */
/* replace718_1 -> search714_1 in the cache */
/* replace718 -> search714 in the cache */

   /* search719_0_0 -> search2_0 in the cache */
static const nir_search_expression search719_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search719 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fexp2,
   { &search719_0.value },
   NULL,
};

   /* replace719 -> search2_0 in the cache */

   /* search720_0_0 -> search2_0 in the cache */
static const nir_search_expression search720_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search720 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search720_0.value },
   NULL,
};

   /* replace720 -> search2_0 in the cache */

   /* search721_0 -> search0_0 in the cache */

/* search721_1 -> replace0_1_0 in the cache */
static const nir_search_expression search721 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace721_0_0_0 -> search0_0 in the cache */
static const nir_search_expression replace721_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search0_0.value },
   NULL,
};

/* replace721_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace721_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace721_0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace721 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace721_0.value },
   NULL,
};

   /* search722_0_0_0 -> search0_0 in the cache */
/* search722_0_0 -> replace721_0_0 in the cache */

/* search722_0_1 -> replace0_1_0 in the cache */
/* search722_0 -> replace721_0 in the cache */
static const nir_search_expression search722 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &replace721_0.value },
   NULL,
};

   /* replace722_0 -> search0_0 in the cache */

/* replace722_1 -> replace0_1_0 in the cache */
/* replace722 -> search721 in the cache */

   /* search723_0_0_0_0 -> search103_0_0 in the cache */
static const nir_search_expression search723_0_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search103_0_0.value },
   NULL,
};

/* search723_0_0_1 -> search103_0_1 in the cache */
static const nir_search_expression search723_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search723_0_0_0.value, &search103_0_1.value },
   NULL,
};

/* search723_0_1_0_0 -> search103_1_1 in the cache */
static const nir_search_expression search723_0_1_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search103_1_1.value },
   NULL,
};

/* search723_0_1_1 -> search103_2 in the cache */
static const nir_search_expression search723_0_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search723_0_1_0.value, &search103_2.value },
   NULL,
};
static const nir_search_expression search723_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_fadd,
   { &search723_0_0.value, &search723_0_1.value },
   NULL,
};
static const nir_search_expression search723 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 3,
   nir_op_fexp2,
   { &search723_0.value },
   NULL,
};

   /* replace723_0_0 -> search103_0_0 in the cache */

/* replace723_0_1 -> search103_0_1 in the cache */
static const nir_search_expression replace723_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search103_0_0.value, &search103_0_1.value },
   NULL,
};

/* replace723_1_0 -> search103_1_1 in the cache */

/* replace723_1_1 -> search103_2 in the cache */
static const nir_search_expression replace723_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search103_1_1.value, &search103_2.value },
   NULL,
};
static const nir_search_expression replace723 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &replace723_0.value, &replace723_1.value },
   NULL,
};

   /* search724_0_0_0 -> search2_0 in the cache */
/* search724_0_0 -> search719_0 in the cache */

static const nir_search_constant search724_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
};
static const nir_search_expression search724_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search719_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression search724 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search724_0.value },
   NULL,
};

   /* replace724_0 -> search2_0 in the cache */
static const nir_search_expression replace724 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search2_0.value },
   NULL,
};

   /* search725_0_0_0 -> search2_0 in the cache */
/* search725_0_0 -> search719_0 in the cache */

static const nir_search_constant search725_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4000000000000000 /* 2.0 */ },
};
static const nir_search_expression search725_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search719_0.value, &search725_0_1.value },
   NULL,
};
static const nir_search_expression search725 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search725_0.value },
   NULL,
};

   /* replace725_0 -> search2_0 in the cache */

/* replace725_1 -> search2_0 in the cache */
/* replace725 -> search58_1 in the cache */

   /* search726_0_0_0 -> search2_0 in the cache */
/* search726_0_0 -> search719_0 in the cache */

static const nir_search_constant search726_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4010000000000000 /* 4.0 */ },
};
static const nir_search_expression search726_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search719_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression search726 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search726_0.value },
   NULL,
};

   /* replace726_0_0 -> search2_0 in the cache */

/* replace726_0_1 -> search2_0 in the cache */
/* replace726_0 -> search58_1 in the cache */

/* replace726_1_0 -> search2_0 in the cache */

/* replace726_1_1 -> search2_0 in the cache */
/* replace726_1 -> search58_1 in the cache */
static const nir_search_expression replace726 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search58_1.value, &search58_1.value },
   NULL,
};

   /* search727_0 -> search2_0 in the cache */

/* search727_1 -> search53_1 in the cache */
static const nir_search_expression search727 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search53_1.value },
   NULL,
};

   /* replace727 -> search2_0 in the cache */

   /* search728_0 -> search2_0 in the cache */

/* search728_1 -> search725_0_1 in the cache */
static const nir_search_expression search728 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search725_0_1.value },
   NULL,
};

   /* replace728_0 -> search2_0 in the cache */

/* replace728_1 -> search2_0 in the cache */
/* replace728 -> search58_1 in the cache */

   /* search729_0 -> search2_0 in the cache */

/* search729_1 -> search726_0_1 in the cache */
static const nir_search_expression search729 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search726_0_1.value },
   NULL,
};

   /* replace729_0_0 -> search2_0 in the cache */

/* replace729_0_1 -> search2_0 in the cache */
/* replace729_0 -> search58_1 in the cache */

/* replace729_1_0 -> search2_0 in the cache */

/* replace729_1_1 -> search2_0 in the cache */
/* replace729_1 -> search58_1 in the cache */
/* replace729 -> replace726 in the cache */

   /* search730_0 -> search725_0_1 in the cache */

/* search730_1 -> search2_0 in the cache */
static const nir_search_expression search730 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search725_0_1.value, &search2_0.value },
   NULL,
};

   /* replace730_0 -> search2_0 in the cache */
/* replace730 -> search720_0 in the cache */

   /* search731_0_0 -> search2_0 in the cache */

static const nir_search_constant search731_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x400199999999999a /* 2.2 */ },
};
static const nir_search_expression search731_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search731_0_1.value },
   NULL,
};

static const nir_search_constant search731_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
};
static const nir_search_expression search731 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search731_0.value, &search731_1.value },
   NULL,
};

   /* replace731 -> search2_0 in the cache */

   /* search732_0_0_0 -> search2_0 in the cache */

/* search732_0_0_1 -> search731_0_1 in the cache */
/* search732_0_0 -> search731_0 in the cache */
static const nir_search_expression search732_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search731_0.value },
   NULL,
};

/* search732_1 -> search731_1 in the cache */
static const nir_search_expression search732 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search732_0.value, &search731_1.value },
   NULL,
};

   /* replace732_0 -> search2_0 in the cache */
/* replace732 -> replace24 in the cache */

   /* search733_0_0 -> search2_0 in the cache */
/* search733_0 -> search720_0 in the cache */
static const nir_search_expression search733 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fsqrt,
   { &search720_0.value },
   NULL,
};

   /* replace733_0_0 -> search724_0_1 in the cache */

/* replace733_0_1 -> search2_0 in the cache */
static const nir_search_expression replace733_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search724_0_1.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace733 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace733_0.value },
   NULL,
};

   /* search734_0_0 -> search2_0 in the cache */
/* search734_0 -> search720_0 in the cache */
static const nir_search_expression search734 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search720_0.value },
   NULL,
};

   /* replace734_0_0 -> search2_0 in the cache */
/* replace734_0 -> search22_0 in the cache */
static const nir_search_expression replace734 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search22_0.value },
   NULL,
};

   /* search735_0_0 -> search2_0 in the cache */
/* search735_0 -> search720_0 in the cache */
static const nir_search_expression search735 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frsq,
   { &search720_0.value },
   NULL,
};

   static const nir_search_constant replace735_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbfe0000000000000 /* -0.5 */ },
};

/* replace735_0_1 -> search2_0 in the cache */
static const nir_search_expression replace735_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace735_0_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace735 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace735_0.value },
   NULL,
};

   /* search736_0_0 -> search2_0 in the cache */
/* search736_0 -> replace724 in the cache */
static const nir_search_expression search736 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &replace724.value },
   NULL,
};

   /* replace736_0 -> search724_0_1 in the cache */

/* replace736_1_0 -> search2_0 in the cache */
/* replace736_1 -> search719_0 in the cache */
static const nir_search_expression replace736 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search724_0_1.value, &search719_0.value },
   NULL,
};

   /* search737_0_0 -> search2_0 in the cache */
static const nir_search_expression search737_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search737 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search737_0.value },
   NULL,
};

   /* replace737_0_0 -> search2_0 in the cache */
/* replace737_0 -> search719_0 in the cache */
static const nir_search_expression replace737 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search719_0.value },
   NULL,
};

   /* search738_0_0 -> search2_0 in the cache */
static const nir_search_expression search738_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frsq,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search738 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search738_0.value },
   NULL,
};

   /* replace738_0 -> replace735_0_0 in the cache */

/* replace738_1_0 -> search2_0 in the cache */
/* replace738_1 -> search719_0 in the cache */
static const nir_search_expression replace738 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace735_0_0.value, &search719_0.value },
   NULL,
};

   /* search739_0_0 -> search0_0 in the cache */

/* search739_0_1 -> replace0_1_0 in the cache */
/* search739_0 -> search721 in the cache */
static const nir_search_expression search739 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search721.value },
   NULL,
};

   /* replace739_0 -> replace0_1_0 in the cache */

/* replace739_1_0 -> search0_0 in the cache */
/* replace739_1 -> replace721_0_0 in the cache */
static const nir_search_expression replace739 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace721_0_0.value },
   NULL,
};

   /* search740_0_0 -> search0_0 in the cache */
static const nir_search_expression search740_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search0_0.value },
   (is_used_once),
};

/* search740_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search740_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search740 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search740_0.value, &search740_1.value },
   NULL,
};

   /* replace740_0_0 -> search0_0 in the cache */

/* replace740_0_1 -> replace0_1_0 in the cache */
/* replace740_0 -> replace66 in the cache */
static const nir_search_expression replace740 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace66.value },
   NULL,
};

   /* search741_0_0 -> search2_0 in the cache */

/* search741_0_1 -> search30_1 in the cache */
/* search741_0 -> replace105_0 in the cache */

/* search741_1 -> search30_1 in the cache */

/* search741_2_0 -> search2_0 in the cache */
/* search741_2 -> replace724 in the cache */
static const nir_search_expression search741 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace105_0.value, &search30_1.value, &replace724.value },
   NULL,
};

   /* replace741_0_0 -> search2_0 in the cache */

/* replace741_0_1 -> search30_1 in the cache */
static const nir_search_expression replace741_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmax,
   { &search2_0.value, &search30_1.value },
   NULL,
};
static const nir_search_expression replace741 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsqrt,
   { &replace741_0.value },
   NULL,
};

   /* search742_0_0 -> search2_0 in the cache */
/* search742_0 -> replace724 in the cache */

/* search742_1_0 -> search2_0 in the cache */
/* search742_1 -> replace724 in the cache */
static const nir_search_expression search742 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmul,
   { &replace724.value, &replace724.value },
   NULL,
};

   /* replace742_0 -> search2_0 in the cache */
/* replace742 -> replace24 in the cache */

   /* search743_0 -> search53_1 in the cache */

/* search743_1 -> search2_0 in the cache */
static const nir_search_expression search743 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fdiv,
   { &search53_1.value, &search2_0.value },
   NULL,
};

   /* replace743_0 -> search2_0 in the cache */
/* replace743 -> search737_0 in the cache */

   /* search744_0 -> search0_0 in the cache */

/* search744_1 -> replace0_1_0 in the cache */
static const nir_search_expression search744 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace744_0 -> search0_0 in the cache */

/* replace744_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace744_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace744 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace744_1.value },
   NULL,
};

   /* search745_0_0 -> search2_0 in the cache */
/* search745_0 -> search737_0 in the cache */
static const nir_search_expression search745 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search737_0.value },
   NULL,
};

   /* replace745 -> search2_0 in the cache */

   /* search746_0_0 -> search2_0 in the cache */
/* search746_0 -> replace724 in the cache */
static const nir_search_expression search746 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &replace724.value },
   NULL,
};

   /* replace746_0 -> search2_0 in the cache */
/* replace746 -> search738_0 in the cache */

   /* search747_0 -> search2_0 in the cache */
/* search747 -> replace724 in the cache */

   /* replace747_0_0 -> search2_0 in the cache */
/* replace747_0 -> search738_0 in the cache */
static const nir_search_expression replace747 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search738_0.value },
   NULL,
};

   /* search748_0_0 -> search2_0 in the cache */
/* search748_0 -> search738_0 in the cache */
static const nir_search_expression search748 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search738_0.value },
   NULL,
};

   /* replace748_0 -> search2_0 in the cache */
/* replace748 -> replace724 in the cache */

   /* search749_0 -> search2_0 in the cache */
static const nir_search_expression search749 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsin,
   { &search2_0.value },
   NULL,
};

   /* replace749_0_0_0_0_0_0 -> search725_0_1 in the cache */

static const nir_search_constant replace749_0_0_0_0_0_1_0_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
};

/* replace749_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   5, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_0_0_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace749_0_0_0_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_0_0_0_0_1.value },
   NULL,
};

/* replace749_0_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   9, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_0_0_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace749_0_0_0_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace749_0_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   12, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_0_0_1_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace749_0_0_0_1_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace749_0_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace749_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace749_0_0_0_1_0.value, &replace749_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace749_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace749_0_0_0_0.value, &replace749_0_0_0_1.value },
   NULL,
};

/* replace749_0_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace749_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace749_0_0_0.value, &search726_0_1.value },
   NULL,
};

/* replace749_0_1_0_0_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_1_0_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_1_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   16, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_1_0_0_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace749_0_1_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_1_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_1_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_1_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   20, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_1_0_0_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace749_0_1_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_1_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_1_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_1_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   23, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_1_0_0_1_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_1_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace749_0_1_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_1_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace749_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace749_0_1_0_0_1_0.value, &replace749_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace749_0_1_0_0_0.value, &replace749_0_1_0_0_1.value },
   NULL,
};

/* replace749_0_1_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace749_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace749_0_1_0_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace749_0_1_0.value },
   NULL,
};

/* replace749_0_2_0_0_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_2_0_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_2_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   27, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_2_0_0_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace749_0_2_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_2_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_2_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_2_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   31, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_2_0_0_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace749_0_2_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_2_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_0_2_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_0_2_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   34, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_0_2_0_0_1_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_1_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace749_0_2_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_0_2_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace749_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace749_0_2_0_0_1_0.value, &replace749_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace749_0_2_0_0_0.value, &replace749_0_2_0_0_1.value },
   NULL,
};

/* replace749_0_2_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace749_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace749_0_2_0_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace749_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace749_0_2_0.value },
   NULL,
};
static const nir_search_expression replace749_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace749_0_0.value, &replace749_0_1.value, &replace749_0_2.value },
   NULL,
};

static const nir_search_constant replace749_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
};

/* replace749_2_0_0_0_0 -> search725_0_1 in the cache */

/* replace749_2_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_2_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   38, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_2_0_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace749_2_0_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_2_0_0_0_1.value },
   NULL,
};

/* replace749_2_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_2_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_2_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_2_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_2_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   42, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_2_0_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace749_2_0_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_2_0_1_0_0_1.value },
   NULL,
};

/* replace749_2_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_2_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace749_2_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace749_2_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace749_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace749_2_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   45, 1,
   nir_op_fmul,
   { &replace749_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace749_2_0_1_1_0_0_1_0_1 -> search724_0_1 in the cache */
static const nir_search_expression replace749_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace749_2_0_1_1_0_0_1_0_0.value, &search724_0_1.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace749_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace749_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace749_2_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace749_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace749_2_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace749_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace749_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace749_2_0_1_0.value, &replace749_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace749_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace749_2_0_0.value, &replace749_2_0_1.value },
   NULL,
};

/* replace749_2_1 -> search726_0_1 in the cache */
static const nir_search_expression replace749_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace749_2_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace749 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace749_0.value, &replace749_1.value, &replace749_2.value },
   NULL,
};

   /* search750_0 -> search2_0 in the cache */
static const nir_search_expression search750 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fcos,
   { &search2_0.value },
   NULL,
};

   /* replace750_0_0_0_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_0_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_0_0_0_0_1_0_0 -> replace749_0_0_0_0_0_1_0_0 in the cache */

static const nir_search_constant replace750_0_0_0_0_0_1_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
};
static const nir_search_expression replace750_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace749_0_0_0_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_0_0_0_0_1.value },
   NULL,
};

/* replace750_0_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_0_0_1_0_0_1_0_0 -> replace749_0_0_0_1_0_0_1_0_0 in the cache */

/* replace750_0_0_0_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace749_0_0_0_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace750_0_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_0_0_1_1_0_0_1_0_0 -> replace749_0_0_0_1_1_0_0_1_0_0 in the cache */

/* replace750_0_0_0_1_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace749_0_0_0_1_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace750_0_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace750_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace750_0_0_0_1_0.value, &replace750_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace750_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace750_0_0_0_0.value, &replace750_0_0_0_1.value },
   NULL,
};

/* replace750_0_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace750_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace750_0_0_0.value, &search726_0_1.value },
   NULL,
};

/* replace750_0_1_0_0_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_1_0_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_1_0_0_0_0_1_0_0 -> replace749_0_1_0_0_0_0_1_0_0 in the cache */

/* replace750_0_1_0_0_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace750_0_1_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_1_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_1_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_1_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_1_0_0_1_0_0_1_0_0 -> replace749_0_1_0_0_1_0_0_1_0_0 in the cache */

/* replace750_0_1_0_0_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace750_0_1_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_1_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_1_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_1_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_1_0_0_1_1_0_0_1_0_0 -> replace749_0_1_0_0_1_1_0_0_1_0_0 in the cache */

/* replace750_0_1_0_0_1_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace749_0_1_0_0_1_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace750_0_1_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_1_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace750_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace750_0_1_0_0_1_0.value, &replace750_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace750_0_1_0_0_0.value, &replace750_0_1_0_0_1.value },
   NULL,
};

/* replace750_0_1_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace750_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace750_0_1_0_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace750_0_1_0.value },
   NULL,
};

/* replace750_0_2_0_0_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_2_0_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_2_0_0_0_0_1_0_0 -> replace749_0_2_0_0_0_0_1_0_0 in the cache */

/* replace750_0_2_0_0_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace750_0_2_0_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_2_0_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_2_0_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_2_0_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_2_0_0_1_0_0_1_0_0 -> replace749_0_2_0_0_1_0_0_1_0_0 in the cache */

/* replace750_0_2_0_0_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace750_0_2_0_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_2_0_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_0_2_0_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_0_2_0_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_0_2_0_0_1_1_0_0_1_0_0 -> replace749_0_2_0_0_1_1_0_0_1_0_0 in the cache */

/* replace750_0_2_0_0_1_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace749_0_2_0_0_1_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace750_0_2_0_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_0_2_0_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace750_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace750_0_2_0_0_1_0.value, &replace750_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace750_0_2_0_0_0.value, &replace750_0_2_0_0_1.value },
   NULL,
};

/* replace750_0_2_0_1 -> search726_0_1 in the cache */
static const nir_search_expression replace750_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace750_0_2_0_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace750_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace750_0_2_0.value },
   NULL,
};
static const nir_search_expression replace750_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace750_0_0.value, &replace750_0_1.value, &replace750_0_2.value },
   NULL,
};

/* replace750_1 -> replace749_1 in the cache */

/* replace750_2_0_0_0_0 -> search725_0_1 in the cache */

/* replace750_2_0_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_2_0_0_0_1_0_0 -> replace749_2_0_0_0_1_0_0 in the cache */

/* replace750_2_0_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace749_2_0_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_2_0_0_0_1.value },
   NULL,
};

/* replace750_2_0_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_2_0_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_2_0_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_2_0_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_2_0_1_0_0_1_0_0 -> replace749_2_0_1_0_0_1_0_0 in the cache */

/* replace750_2_0_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace749_2_0_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_2_0_1_0_0_1.value },
   NULL,
};

/* replace750_2_0_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_2_0_1_0_0.value, &search53_1.value },
   NULL,
};

/* replace750_2_0_1_1_0_0_0 -> search725_0_1 in the cache */

/* replace750_2_0_1_1_0_0_1_0_0_0 -> replace749_0_0_0_0_0_1_0_0_0 in the cache */

/* replace750_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace750_2_0_1_1_0_0_1_0_0 -> replace749_2_0_1_1_0_0_1_0_0 in the cache */

/* replace750_2_0_1_1_0_0_1_0_1 -> replace750_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace750_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace749_2_0_1_1_0_0_1_0_0.value, &replace750_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace750_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search725_0_1.value, &replace750_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace750_2_0_1_1_0_1 -> search53_1 in the cache */
static const nir_search_expression replace750_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace750_2_0_1_1_0_0.value, &search53_1.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace750_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace750_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace750_2_0_1_0.value, &replace750_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace750_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace750_2_0_0.value, &replace750_2_0_1.value },
   NULL,
};

/* replace750_2_1 -> search726_0_1 in the cache */
static const nir_search_expression replace750_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace750_2_0.value, &search726_0_1.value },
   NULL,
};
static const nir_search_expression replace750 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace750_0.value, &replace749_1.value, &replace750_2.value },
   NULL,
};

   /* search751_0 -> search2_0 in the cache */
static const nir_search_expression search751 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2b16,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace751_0 -> search2_0 in the cache */

/* replace751_1 -> replace9 in the cache */
static const nir_search_expression replace751 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ine16,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search752_0 -> search2_0 in the cache */
static const nir_search_expression search752 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace752_0 -> search2_0 in the cache */

/* replace752_1 -> replace9 in the cache */
static const nir_search_expression replace752 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ine32,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search753_0 -> search2_0 in the cache */
static const nir_search_expression search753 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace753_0 -> search2_0 in the cache */

/* replace753_1 -> replace9 in the cache */
/* replace753 -> replace253 in the cache */

   /* search754_0 -> replace116_0 in the cache */

/* search754_1 -> replace255 in the cache */
static const nir_search_expression search754 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace116_0.value, &replace255.value },
   NULL,
};

   /* replace754 -> replace116_0 in the cache */

   /* search755_0 -> replace116_0 in the cache */

/* search755_1 -> replace255 in the cache */
static const nir_search_expression search755 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace116_0.value, &replace255.value },
   (is_not_used_by_if),
};

   /* replace755_0 -> replace116_0 in the cache */
/* replace755 -> replace210 in the cache */

   /* search756_0 -> replace116_0 in the cache */

/* search756_1 -> replace189 in the cache */
static const nir_search_expression search756 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace116_0.value, &replace189.value },
   NULL,
};

   /* replace756 -> replace116_0 in the cache */

   /* search757_0 -> replace116_0 in the cache */

/* search757_1 -> replace189 in the cache */
static const nir_search_expression search757 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace116_0.value, &replace189.value },
   (is_not_used_by_if),
};

   /* replace757_0 -> replace116_0 in the cache */
/* replace757 -> replace210 in the cache */

   /* search758_0 -> replace116_0 in the cache */

/* search758_1 -> replace255 in the cache */

/* search758_2 -> replace189 in the cache */
static const nir_search_expression search758 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace255.value, &replace189.value },
   NULL,
};

   /* replace758 -> replace116_0 in the cache */

   /* search759_0 -> replace116_0 in the cache */

/* search759_1 -> replace189 in the cache */

/* search759_2 -> replace255 in the cache */
static const nir_search_expression search759 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace189.value, &replace255.value },
   NULL,
};

   /* replace759_0 -> replace116_0 in the cache */
/* replace759 -> replace210 in the cache */

   /* search760_0 -> replace255 in the cache */

/* search760_1 -> replace204_0 in the cache */

/* search760_2 -> search104_2 in the cache */
static const nir_search_expression search760 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace255.value, &replace204_0.value, &search104_2.value },
   NULL,
};

   /* replace760 -> replace204_0 in the cache */

   /* search761_0 -> replace189 in the cache */

/* search761_1 -> replace204_0 in the cache */

/* search761_2 -> search104_2 in the cache */
static const nir_search_expression search761 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace189.value, &replace204_0.value, &search104_2.value },
   NULL,
};

   /* replace761 -> search104_2 in the cache */

   /* search762_0 -> replace116_0 in the cache */

/* search762_1 -> replace76_0_0 in the cache */

/* search762_2 -> search31_1 in the cache */
static const nir_search_expression search762 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace76_0_0.value, &search31_1.value },
   NULL,
};

   /* replace762_0 -> replace116_0 in the cache */
static const nir_search_expression replace762 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   NULL,
};

   /* search763_0 -> replace116_0 in the cache */

/* search763_1 -> search31_1 in the cache */

/* search763_2 -> replace76_0_0 in the cache */
static const nir_search_expression search763 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search31_1.value, &replace76_0_0.value },
   NULL,
};

   /* replace763_0_0 -> replace116_0 in the cache */
/* replace763_0 -> replace210 in the cache */
static const nir_search_expression replace763 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace210.value },
   NULL,
};

   /* search764_0 -> replace116_0 in the cache */

static const nir_search_constant search764_1 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search764_2 = {
   { nir_search_value_constant, 16 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search764 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search764_1.value, &search764_2.value },
   NULL,
};

   /* replace764_0_0 -> replace116_0 in the cache */
/* replace764_0 -> replace762 in the cache */
static const nir_search_expression replace764 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace762.value },
   NULL,
};

   /* search765_0 -> replace116_0 in the cache */

/* search765_1 -> search764_2 in the cache */

/* search765_2 -> search764_1 in the cache */
static const nir_search_expression search765 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search764_2.value, &search764_1.value },
   NULL,
};

   /* replace765_0_0_0 -> replace116_0 in the cache */
/* replace765_0_0 -> replace210 in the cache */
/* replace765_0 -> replace763 in the cache */
static const nir_search_expression replace765 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace763.value },
   NULL,
};

   /* search766_0 -> replace116_0 in the cache */

/* search766_1 -> replace86_0_0 in the cache */

/* search766_2 -> search32_1 in the cache */
static const nir_search_expression search766 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace86_0_0.value, &search32_1.value },
   NULL,
};

   /* replace766_0 -> replace116_0 in the cache */
static const nir_search_expression replace766 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   NULL,
};

   /* search767_0 -> replace116_0 in the cache */

/* search767_1 -> search32_1 in the cache */

/* search767_2 -> replace86_0_0 in the cache */
static const nir_search_expression search767 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search32_1.value, &replace86_0_0.value },
   NULL,
};

   /* replace767_0_0 -> replace116_0 in the cache */
/* replace767_0 -> replace210 in the cache */
static const nir_search_expression replace767 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace210.value },
   NULL,
};

   /* search768_0 -> replace116_0 in the cache */

static const nir_search_constant search768_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search768_2 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search768 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search768_1.value, &search768_2.value },
   NULL,
};

   /* replace768_0_0 -> replace116_0 in the cache */
/* replace768_0 -> replace766 in the cache */
static const nir_search_expression replace768 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace766.value },
   NULL,
};

   /* search769_0 -> replace116_0 in the cache */

/* search769_1 -> search768_2 in the cache */

/* search769_2 -> search768_1 in the cache */
static const nir_search_expression search769 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search768_2.value, &search768_1.value },
   NULL,
};

   /* replace769_0_0_0 -> replace116_0 in the cache */
/* replace769_0_0 -> replace210 in the cache */
/* replace769_0 -> replace767 in the cache */
static const nir_search_expression replace769 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace767.value },
   NULL,
};

   /* search770_0 -> replace116_0 in the cache */

/* search770_1 -> replace96_0_0 in the cache */

/* search770_2 -> search504_0_0 in the cache */
static const nir_search_expression search770 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace96_0_0.value, &search504_0_0.value },
   NULL,
};

   /* replace770_0 -> replace116_0 in the cache */
static const nir_search_expression replace770 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace116_0.value },
   NULL,
};

   /* search771_0 -> replace116_0 in the cache */

/* search771_1 -> search504_0_0 in the cache */

/* search771_2 -> replace96_0_0 in the cache */
static const nir_search_expression search771 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search504_0_0.value, &replace96_0_0.value },
   NULL,
};

   /* replace771_0_0 -> replace116_0 in the cache */
/* replace771_0 -> replace210 in the cache */
static const nir_search_expression replace771 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace210.value },
   NULL,
};

   /* search772_0 -> replace116_0 in the cache */

static const nir_search_constant search772_1 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
};

static const nir_search_constant search772_2 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x8000000000000000 /* -0.0 */ },
};
static const nir_search_expression search772 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search772_1.value, &search772_2.value },
   NULL,
};

   /* replace772_0_0 -> replace116_0 in the cache */
/* replace772_0 -> replace770 in the cache */
static const nir_search_expression replace772 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace770.value },
   NULL,
};

   /* search773_0 -> replace116_0 in the cache */

/* search773_1 -> search772_2 in the cache */

/* search773_2 -> search772_1 in the cache */
static const nir_search_expression search773 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search772_2.value, &search772_1.value },
   NULL,
};

   /* replace773_0_0_0 -> replace116_0 in the cache */
/* replace773_0_0 -> replace210 in the cache */
/* replace773_0 -> replace771 in the cache */
static const nir_search_expression replace773 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace771.value },
   NULL,
};

   /* search774_0 -> replace116_0 in the cache */

/* search774_1 -> replace0_1_0 in the cache */

/* search774_2 -> replace0_1_0 in the cache */
static const nir_search_expression search774 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &replace0_1_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace774 -> replace0_1_0 in the cache */

   /* search775_0 -> search3_0_0 in the cache */

/* search775_1 -> replace2_1_1 in the cache */

/* search775_2 -> replace2_1_1 in the cache */
static const nir_search_expression search775 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_fcsel,
   { &search3_0_0.value, &replace2_1_1.value, &replace2_1_1.value },
   NULL,
};

   /* replace775 -> replace2_1_1 in the cache */

   /* search776_0 -> replace116_0 in the cache */

static const nir_search_constant search776_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* search776_2 -> search251_1 in the cache */
static const nir_search_expression search776 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search776_1.value, &search251_1.value },
   NULL,
};

   /* replace776_0_0 -> replace116_0 in the cache */
/* replace776_0 -> search251_0 in the cache */
/* replace776 -> search574_0 in the cache */

   /* search777_0 -> replace116_0 in the cache */

/* search777_1 -> search251_1 in the cache */

/* search777_2 -> search776_1 in the cache */
static const nir_search_expression search777 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search251_1.value, &search776_1.value },
   NULL,
};

   /* replace777_0_0_0 -> replace116_0 in the cache */
/* replace777_0_0 -> replace210 in the cache */
static const nir_search_expression replace777_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace210.value },
   NULL,
};
static const nir_search_expression replace777 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace777_0.value },
   NULL,
};

   /* search778_0 -> replace116_0 in the cache */

static const nir_search_constant search778_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x1 /* 1 */ },
};

/* search778_2 -> search251_1 in the cache */
static const nir_search_expression search778 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search778_1.value, &search251_1.value },
   NULL,
};

   /* replace778_0 -> replace116_0 in the cache */
/* replace778 -> search251_0 in the cache */

   /* search779_0 -> replace116_0 in the cache */

/* search779_1 -> search251_1 in the cache */

/* search779_2 -> search778_1 in the cache */
static const nir_search_expression search779 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search251_1.value, &search778_1.value },
   NULL,
};

   /* replace779_0_0 -> replace116_0 in the cache */
/* replace779_0 -> replace210 in the cache */
/* replace779 -> replace777_0 in the cache */

   /* search780_0_0_0 -> replace116_0 in the cache */
/* search780_0_0 -> search251_0 in the cache */
/* search780_0 -> search574_0 in the cache */

/* search780_1_0_0 -> search212_0_1_0 in the cache */
/* search780_1_0 -> search574_1_0 in the cache */
/* search780_1 -> search574_1 in the cache */
static const nir_search_expression search780 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search574_0.value, &search574_1.value },
   NULL,
};

   /* replace780_0_0_0 -> replace116_0 in the cache */

/* replace780_0_0_1 -> search212_0_1_0 in the cache */
/* replace780_0_0 -> replace215 in the cache */
/* replace780_0 -> replace668 in the cache */
static const nir_search_expression replace780 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace668.value },
   NULL,
};

   /* search781_0_0_0 -> replace116_0 in the cache */
/* search781_0_0 -> search251_0 in the cache */
/* search781_0 -> search574_0 in the cache */

/* search781_1_0_0 -> search212_0_1_0 in the cache */
/* search781_1_0 -> search574_1_0 in the cache */
/* search781_1 -> search574_1 in the cache */
static const nir_search_expression search781 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search574_0.value, &search574_1.value },
   NULL,
};

   /* replace781_0_0_0 -> replace116_0 in the cache */

/* replace781_0_0_1 -> search212_0_1_0 in the cache */
/* replace781_0_0 -> replace212 in the cache */
/* replace781_0 -> replace670 in the cache */
static const nir_search_expression replace781 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace670.value },
   NULL,
};

   /* search782_0_0_0 -> replace116_0 in the cache */
/* search782_0_0 -> search251_0 in the cache */
/* search782_0 -> search574_0 in the cache */

/* search782_1 -> search251_1 in the cache */
static const nir_search_expression search782 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search574_0.value, &search251_1.value },
   NULL,
};

   /* replace782_0 -> replace116_0 in the cache */
/* replace782 -> replace210 in the cache */

   /* search783_0_0_0 -> replace116_0 in the cache */
/* search783_0_0 -> search251_0 in the cache */
/* search783_0 -> search574_0 in the cache */

/* search783_1 -> search776_1 in the cache */
static const nir_search_expression search783 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search574_0.value, &search776_1.value },
   NULL,
};

   /* replace783 -> replace116_0 in the cache */

   /* search784_0_0_0 -> replace116_0 in the cache */
/* search784_0_0 -> search251_0 in the cache */
/* search784_0 -> search574_0 in the cache */

/* search784_1 -> search251_1 in the cache */
static const nir_search_expression search784 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search574_0.value, &search251_1.value },
   NULL,
};

   /* replace784 -> replace116_0 in the cache */

   /* search785_0_0_0 -> replace116_0 in the cache */
/* search785_0_0 -> search251_0 in the cache */
/* search785_0 -> search574_0 in the cache */

/* search785_1 -> search776_1 in the cache */
static const nir_search_expression search785 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search574_0.value, &search776_1.value },
   NULL,
};

   /* replace785_0 -> replace116_0 in the cache */
/* replace785 -> replace210 in the cache */

   /* search786_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search786_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search786_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search786_0_0.value },
   NULL,
};

/* search786_1 -> search213_0_1 in the cache */
static const nir_search_expression search786 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search786_0.value, &search213_0_1.value },
   NULL,
};

   /* replace786_0 -> search2_0 in the cache */
/* replace786 -> search385_0 in the cache */

   /* search787_0_0_0 -> search2_0 in the cache */
/* search787_0_0 -> search786_0_0 in the cache */
/* search787_0 -> search786_0 in the cache */

/* search787_1 -> search778_1 in the cache */
static const nir_search_expression search787 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search786_0.value, &search778_1.value },
   NULL,
};

   /* replace787_0 -> search2_0 in the cache */
/* replace787 -> search786_0_0 in the cache */

   /* search788_0_0 -> search31_0 in the cache */
static const nir_search_expression search788_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search31_0.value },
   NULL,
};
static const nir_search_expression search788 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2b16,
   { &search788_0.value },
   NULL,
};

   /* replace788 -> search31_0 in the cache */

   /* search789_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search789_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search789 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search789_0.value },
   NULL,
};

   /* replace789 -> search3_0_0 in the cache */

   /* search790_0_0 -> search2_0 in the cache */
/* search790_0 -> search105 in the cache */
static const nir_search_expression search790 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search105.value },
   NULL,
};

   /* replace790_0 -> search2_0 in the cache */
static const nir_search_expression replace790 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};

   /* search791_0_0 -> search2_0 in the cache */
/* search791_0 -> search105 in the cache */
static const nir_search_expression search791 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search105.value },
   NULL,
};

   /* replace791_0 -> search2_0 in the cache */
static const nir_search_expression replace791 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search2_0.value },
   NULL,
};

   /* search792_0_0 -> search2_0 in the cache */
/* search792_0 -> search23_0 in the cache */
/* search792 -> search29 in the cache */

   /* replace792_0 -> search2_0 in the cache */
/* replace792 -> replace29 in the cache */

   /* search793_0_0 -> search2_0 in the cache */
/* search793_0 -> search26_0 in the cache */
static const nir_search_expression search793 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search26_0.value },
   NULL,
};

   /* replace793_0 -> search2_0 in the cache */
/* replace793 -> replace29 in the cache */

   /* search794_0_0 -> search2_0 in the cache */
static const nir_search_expression search794_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search794 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search794_0.value },
   NULL,
};

   /* replace794_0 -> search2_0 in the cache */

/* replace794_1 -> search30_1 in the cache */
/* replace794 -> replace267 in the cache */

   /* search795_0_0 -> search31_0 in the cache */
/* search795_0 -> search451_0 in the cache */
static const nir_search_expression search795 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search451_0.value },
   NULL,
};

   /* replace795 -> search31_0 in the cache */

   /* search796_0_0 -> search31_0 in the cache */
/* search796_0 -> search452_0 in the cache */
static const nir_search_expression search796 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search452_0.value },
   NULL,
};

   /* replace796 -> search31_0 in the cache */

   /* search797_0_0 -> search31_0 in the cache */
/* search797_0 -> search453_0 in the cache */
static const nir_search_expression search797 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search453_0.value },
   NULL,
};

   /* replace797 -> search31_0 in the cache */

   /* search798_0_0 -> search31_0 in the cache */
/* search798_0 -> search451_0 in the cache */
static const nir_search_expression search798 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search451_0.value },
   NULL,
};

   /* replace798_0 -> search31_0 in the cache */
static const nir_search_expression replace798 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2i16,
   { &search31_0.value },
   NULL,
};

   /* search799_0_0 -> search31_0 in the cache */
/* search799_0 -> search451_0 in the cache */
static const nir_search_expression search799 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search451_0.value },
   NULL,
};

   /* replace799_0 -> search31_0 in the cache */
static const nir_search_expression replace799 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2u16,
   { &search31_0.value },
   NULL,
};

   /* search800_0_0 -> search31_0 in the cache */
/* search800_0 -> search452_0 in the cache */
static const nir_search_expression search800 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search452_0.value },
   NULL,
};

   /* replace800_0 -> search31_0 in the cache */
static const nir_search_expression replace800 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2f16,
   { &search31_0.value },
   NULL,
};

   /* search801_0_0 -> search31_0 in the cache */
/* search801_0 -> search453_0 in the cache */
static const nir_search_expression search801 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search453_0.value },
   NULL,
};

   /* replace801_0 -> search31_0 in the cache */
static const nir_search_expression replace801 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2f16,
   { &search31_0.value },
   NULL,
};

   /* search802_0_0 -> replace116_0 in the cache */
/* search802_0 -> search454_0 in the cache */
static const nir_search_expression search802 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2fmp,
   { &search454_0.value },
   NULL,
};

   /* replace802_0 -> replace116_0 in the cache */
/* replace802 -> replace454 in the cache */

   /* search803_0_0 -> replace116_0 in the cache */
/* search803_0 -> search455_0 in the cache */
static const nir_search_expression search803 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2imp,
   { &search455_0.value },
   NULL,
};

   /* replace803_0 -> replace116_0 in the cache */
/* replace803 -> replace455 in the cache */

   /* search804_0_0 -> replace116_0 in the cache */
/* search804_0 -> search455_0 in the cache */
/* search804 -> search803 in the cache */

   /* replace804_0 -> replace116_0 in the cache */
/* replace804 -> replace455 in the cache */

   /* search805_0_0 -> replace116_0 in the cache */
/* search805_0 -> search454_0 in the cache */
static const nir_search_expression search805 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2imp,
   { &search454_0.value },
   NULL,
};

   /* replace805_0 -> replace116_0 in the cache */
/* replace805 -> replace455 in the cache */

   /* search806_0_0 -> replace116_0 in the cache */
/* search806_0 -> search454_0 in the cache */
static const nir_search_expression search806 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2ump,
   { &search454_0.value },
   NULL,
};

   /* replace806_0 -> replace116_0 in the cache */
/* replace806 -> replace455 in the cache */

   /* search807_0_0 -> replace116_0 in the cache */
/* search807_0 -> search455_0 in the cache */
static const nir_search_expression search807 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2fmp,
   { &search455_0.value },
   NULL,
};

   /* replace807_0 -> replace116_0 in the cache */
/* replace807 -> replace454 in the cache */

   /* search808_0_0 -> replace116_0 in the cache */
/* search808_0 -> search455_0 in the cache */
static const nir_search_expression search808 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2fmp,
   { &search455_0.value },
   NULL,
};

   /* replace808_0 -> replace116_0 in the cache */
/* replace808 -> replace454 in the cache */

   /* search809_0_0 -> search3_0_0 in the cache */
/* search809_0 -> search523_0 in the cache */
static const nir_search_expression search809 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search523_0.value },
   NULL,
};

   /* replace809 -> search3_0_0 in the cache */

   /* search810_0_0 -> search3_0_0 in the cache */
/* search810_0 -> search527_0 in the cache */
static const nir_search_expression search810 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search527_0.value },
   NULL,
};

   /* replace810 -> search3_0_0 in the cache */

   /* search811_0_0 -> search3_0_0 in the cache */
/* search811_0 -> search527_0 in the cache */
static const nir_search_expression search811 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search527_0.value },
   NULL,
};

   /* replace811 -> search3_0_0 in the cache */

   /* search812_0_0 -> search3_0_0 in the cache */
/* search812_0 -> replace526 in the cache */
static const nir_search_expression search812 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace526.value },
   NULL,
};

   /* replace812_0 -> search3_0_0 in the cache */
/* replace812 -> search526_0 in the cache */

   /* search813_0_0 -> search3_0_0 in the cache */
/* search813_0 -> replace525 in the cache */
static const nir_search_expression search813 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace525.value },
   NULL,
};

   /* replace813_0 -> search3_0_0 in the cache */
/* replace813 -> search525_0 in the cache */

   /* search814_0_0 -> search3_0_0 in the cache */
/* search814_0 -> replace522 in the cache */
static const nir_search_expression search814 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace522.value },
   NULL,
};

   /* replace814_0 -> search3_0_0 in the cache */
/* replace814 -> search522_0 in the cache */

   /* search815_0_0 -> search3_0_0 in the cache */
/* search815_0 -> replace521 in the cache */
static const nir_search_expression search815 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace521.value },
   NULL,
};

   /* replace815_0 -> search3_0_0 in the cache */
/* replace815 -> search521_0 in the cache */

   /* search816_0_0 -> search3_0_0 in the cache */
/* search816_0 -> search492_0 in the cache */
static const nir_search_expression search816 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2f32,
   { &search492_0.value },
   NULL,
};

   /* replace816 -> search3_0_0 in the cache */

   static const nir_search_variable search817_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_integral),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search817 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search817_0.value },
   NULL,
};

   /* replace817 -> search2_0 in the cache */

   /* search818_0 -> search817_0 in the cache */
static const nir_search_expression search818 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search817_0.value },
   NULL,
};

   /* replace818 -> search2_0 in the cache */

   /* search819_0 -> search817_0 in the cache */
static const nir_search_expression search819 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search817_0.value },
   NULL,
};

   /* replace819 -> search2_0 in the cache */

   /* search820_0 -> search817_0 in the cache */
static const nir_search_expression search820 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_ffract,
   { &search817_0.value },
   NULL,
};

   /* replace820 -> search30_1 in the cache */

   static const nir_search_variable search821_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search821 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search821_0.value },
   NULL,
};

   /* replace821 -> search2_0 in the cache */

   /* search822_0 -> search821_0 in the cache */
static const nir_search_expression search822 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search821_0.value },
   NULL,
};

   /* replace822 -> search2_0 in the cache */

   static const nir_search_variable search823_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search823 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search823_0.value },
   NULL,
};

   /* replace823 -> search30_1 in the cache */

   /* search824_0 -> search821_0 in the cache */

/* search824_1 -> search53_1 in the cache */
static const nir_search_expression search824 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmin,
   { &search821_0.value, &search53_1.value },
   NULL,
};

   /* replace824_0 -> search2_0 in the cache */
/* replace824 -> search46_0 in the cache */

   /* search825_0_0_0_0 -> search2_0 in the cache */
/* search825_0_0_0 -> search46_0 in the cache */

/* search825_0_0_1_0_0 -> search2_0 in the cache */
/* search825_0_0_1_0 -> search46_0 in the cache */
static const nir_search_expression search825_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search46_0.value },
   NULL,
};
static const nir_search_expression search825_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search46_0.value, &search825_0_0_1.value },
   NULL,
};

/* search825_0_1 -> search53_1 in the cache */
static const nir_search_expression search825_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search825_0_0.value, &search53_1.value },
   NULL,
};

/* search825_1 -> search30_1 in the cache */
static const nir_search_expression search825 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search825_0.value, &search30_1.value },
   NULL,
};

   /* replace825 -> replace189 in the cache */

   /* search826_0_0_0_0_0 -> search2_0 in the cache */
/* search826_0_0_0_0 -> search46_0 in the cache */

/* search826_0_0_0_1_0 -> search2_0 in the cache */
/* search826_0_0_0_1 -> search46_0 in the cache */
static const nir_search_expression search826_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search46_0.value, &search46_0.value },
   NULL,
};
static const nir_search_expression search826_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search826_0_0_0.value },
   NULL,
};

/* search826_0_1 -> search53_1 in the cache */
static const nir_search_expression search826_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search826_0_0.value, &search53_1.value },
   NULL,
};

/* search826_1 -> search30_1 in the cache */
static const nir_search_expression search826 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search826_0.value, &search30_1.value },
   NULL,
};

   /* replace826 -> replace189 in the cache */

   /* search827_0_0_0_0 -> search2_0 in the cache */
/* search827_0_0_0 -> search46_0 in the cache */

/* search827_0_0_1_0_0 -> search2_0 in the cache */
/* search827_0_0_1_0 -> search46_0 in the cache */
/* search827_0_0_1 -> search825_0_0_1 in the cache */
static const nir_search_expression search827_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search46_0.value, &search825_0_0_1.value },
   NULL,
};

/* search827_0_1 -> search53_1 in the cache */
static const nir_search_expression search827_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &search827_0_0.value, &search53_1.value },
   NULL,
};

/* search827_1 -> search30_1 in the cache */
static const nir_search_expression search827 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 3,
   nir_op_fmax,
   { &search827_0.value, &search30_1.value },
   NULL,
};

   /* replace827_0_0_0 -> search2_0 in the cache */
/* replace827_0_0 -> search46_0 in the cache */

/* replace827_0_1_0_0 -> search2_0 in the cache */
/* replace827_0_1_0 -> search46_0 in the cache */
/* replace827_0_1 -> search825_0_0_1 in the cache */
/* replace827_0 -> search825_0_0 in the cache */

/* replace827_1 -> search53_1 in the cache */
/* replace827 -> search825_0 in the cache */

   /* search828_0_0_0_0_0 -> search2_0 in the cache */
/* search828_0_0_0_0 -> search46_0 in the cache */

/* search828_0_0_0_1_0 -> search2_0 in the cache */
/* search828_0_0_0_1 -> search46_0 in the cache */
/* search828_0_0_0 -> search826_0_0_0 in the cache */
/* search828_0_0 -> search826_0_0 in the cache */

/* search828_0_1 -> search53_1 in the cache */
static const nir_search_expression search828_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search826_0_0.value, &search53_1.value },
   NULL,
};

/* search828_1 -> search30_1 in the cache */
static const nir_search_expression search828 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmax,
   { &search828_0.value, &search30_1.value },
   NULL,
};

   /* replace828_0_0_0_0 -> search2_0 in the cache */
/* replace828_0_0_0 -> search46_0 in the cache */

/* replace828_0_0_1_0 -> search2_0 in the cache */
/* replace828_0_0_1 -> search46_0 in the cache */
/* replace828_0_0 -> search826_0_0_0 in the cache */
/* replace828_0 -> search826_0_0 in the cache */

/* replace828_1 -> search53_1 in the cache */
/* replace828 -> search826_0 in the cache */

   static const nir_search_variable search829_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search829_1 -> search30_1 in the cache */
static const nir_search_expression search829 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fneu,
   { &search829_0.value, &search30_1.value },
   NULL,
};

   /* replace829 -> replace255 in the cache */

   /* search830_0 -> search829_0 in the cache */

/* search830_1 -> search30_1 in the cache */
static const nir_search_expression search830 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search829_0.value, &search30_1.value },
   NULL,
};

   /* replace830 -> replace189 in the cache */

   static const nir_search_variable search831_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search831_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search831 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search831_0.value, &search831_1.value },
   NULL,
};

   /* replace831 -> replace255 in the cache */

   static const nir_search_variable search832_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search832_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search832 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search832_0.value, &search832_1.value },
   NULL,
};

   /* replace832 -> replace189 in the cache */

   static const nir_search_variable search833_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_lt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search833_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search833 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search833_0.value, &search833_1.value },
   NULL,
};

   /* replace833 -> replace189 in the cache */

   /* search834_0 -> search396_0_0_0 in the cache */

static const nir_search_variable search834_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search834 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search396_0_0_0.value, &search834_1.value },
   NULL,
};

   /* replace834 -> replace189 in the cache */

   static const nir_search_variable search835_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number_not_positive),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search835_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number_gt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search835 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search835_0.value, &search835_1.value },
   NULL,
};

   /* replace835 -> replace255 in the cache */

   static const nir_search_variable search836_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_a_number_lt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search836_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_a_number_not_negative),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search836 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search836_0.value, &search836_1.value },
   NULL,
};

   /* replace836 -> replace255 in the cache */

   /* search837_0 -> search829_0 in the cache */

/* search837_1 -> replace9 in the cache */
static const nir_search_expression search837 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search829_0.value, &replace9.value },
   NULL,
};

   /* replace837 -> replace255 in the cache */

   /* search838_0 -> search829_0 in the cache */

/* search838_1 -> replace9 in the cache */
static const nir_search_expression search838 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search829_0.value, &replace9.value },
   NULL,
};

   /* replace838 -> replace189 in the cache */

   /* search839_0 -> search396_0_0_0 in the cache */

/* search839_1 -> search834_1 in the cache */
static const nir_search_expression search839 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search396_0_0_0.value, &search834_1.value },
   NULL,
};

   /* replace839 -> replace255 in the cache */

   /* search840_0 -> search832_0 in the cache */

/* search840_1 -> search832_1 in the cache */
static const nir_search_expression search840 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search832_0.value, &search832_1.value },
   NULL,
};

   /* replace840 -> replace189 in the cache */

   /* search841_0 -> search833_0 in the cache */

/* search841_1 -> search833_1 in the cache */
static const nir_search_expression search841 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search833_0.value, &search833_1.value },
   NULL,
};

   /* replace841 -> replace189 in the cache */

   /* search842_0 -> search396_0_0_0 in the cache */

/* search842_1 -> search834_1 in the cache */
static const nir_search_expression search842 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search396_0_0_0.value, &search834_1.value },
   NULL,
};

   /* replace842 -> replace189 in the cache */

   /* search843_0 -> search832_0 in the cache */

/* search843_1 -> search832_1 in the cache */
static const nir_search_expression search843 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search832_0.value, &search832_1.value },
   NULL,
};

   /* replace843 -> replace255 in the cache */

   /* search844_0 -> search833_0 in the cache */

/* search844_1 -> search833_1 in the cache */
static const nir_search_expression search844 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search833_0.value, &search833_1.value },
   NULL,
};

   /* replace844 -> replace255 in the cache */

   /* search845_0 -> replace9 in the cache */

static const nir_search_variable search845_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search845 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search845_1.value },
   NULL,
};

   /* replace845 -> replace255 in the cache */

   /* search846_0 -> search2_0 in the cache */

/* search846_1 -> replace9 in the cache */
static const nir_search_expression search846 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace846 -> replace189 in the cache */

   /* search847_0_0 -> search3_0_0 in the cache */

/* search847_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search847_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search847 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search847_0.value },
   NULL,
};

   /* replace847 -> search3_0_0 in the cache */

   /* search848_0_0 -> search3_0_0 in the cache */

/* search848_0_1 -> replace2_1_1 in the cache */
/* search848_0 -> search847_0 in the cache */
static const nir_search_expression search848 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search847_0.value },
   NULL,
};

   /* replace848 -> replace2_1_1 in the cache */

   /* search849_0_0 -> search3_0_0 in the cache */

/* search849_0_1 -> replace2_1_1 in the cache */
/* search849_0 -> search847_0 in the cache */
static const nir_search_expression search849 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32,
   { &search847_0.value },
   NULL,
};

   /* replace849_0 -> search3_0_0 in the cache */

/* replace849_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace849 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search850_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search850_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search850 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32,
   { &search850_0.value },
   NULL,
};

   /* replace850 -> search3_0_0 in the cache */

   /* search851_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search851_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_double_2x32_dxil,
   { &search3_0_0.value },
   NULL,
};
static const nir_search_expression search851 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_double_2x32_dxil,
   { &search851_0.value },
   NULL,
};

   /* replace851 -> search3_0_0 in the cache */

   /* search852_0_0 -> search93_0 in the cache */
static const nir_search_expression search852_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search93_0.value },
   NULL,
};

/* search852_1_0 -> search93_0 in the cache */
static const nir_search_expression search852_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search852 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search852_0.value, &search852_1.value },
   NULL,
};

   /* replace852 -> search93_0 in the cache */

   /* search853_0_0_0 -> search93_0 in the cache */
/* search853_0_0 -> search852_0 in the cache */

/* search853_0_1_0 -> search93_0 in the cache */
/* search853_0_1 -> search852_1 in the cache */
static const nir_search_expression search853_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search852_0.value, &search852_1.value },
   NULL,
};
static const nir_search_expression search853 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32,
   { &search853_0.value },
   NULL,
};

   /* replace853 -> search93_0 in the cache */

   /* search854_0_0 -> search93_0 in the cache */
static const nir_search_expression search854_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search854 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32,
   { &search854_0.value },
   NULL,
};

   /* replace854 -> search93_0 in the cache */

   /* search855_0_0 -> search93_0 in the cache */
static const nir_search_expression search855_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_double_2x32_dxil,
   { &search93_0.value },
   NULL,
};
static const nir_search_expression search855 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_double_2x32_dxil,
   { &search855_0.value },
   NULL,
};

   /* replace855 -> search93_0 in the cache */

   /* search856_0_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search856_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_x,
   { &search3_0_0.value },
   NULL,
};

static const nir_search_variable search856_0_1 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search856_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search856_0_0.value, &search856_0_1.value },
   NULL,
};

/* search856_1_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search856_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_y,
   { &search3_0_0.value },
   NULL,
};

static const nir_search_variable search856_1_1 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search856_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search856_1_0.value, &search856_1_1.value },
   NULL,
};
static const nir_search_expression search856 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search856_0.value, &search856_1.value },
   NULL,
};

   /* replace856_0 -> search3_0_0 in the cache */

/* replace856_1_0 -> search61_2 in the cache */

/* replace856_1_1 -> search74_2 in the cache */
static const nir_search_expression replace856_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_32_2x16_split,
   { &search61_2.value, &search74_2.value },
   NULL,
};
static const nir_search_expression replace856 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search3_0_0.value, &replace856_1.value },
   NULL,
};

   /* search857_0 -> search31_0 in the cache */

/* search857_1 -> replace133_0_1 in the cache */
static const nir_search_expression search857 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search31_0.value, &replace133_0_1.value },
   NULL,
};

   /* replace857_0 -> search31_0 in the cache */

/* replace857_1 -> search335_1 in the cache */
static const nir_search_expression replace857 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search31_0.value, &search335_1.value },
   NULL,
};

   /* search858_0 -> search3_0_0 in the cache */

/* search858_1 -> search172_1 in the cache */
/* search858 -> search174_0 in the cache */

   /* replace858_0 -> search3_0_0 in the cache */

static const nir_search_constant replace858_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace858 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0_0.value, &replace858_1.value },
   NULL,
};

   /* search859_0 -> search93_0 in the cache */

static const nir_search_constant search859_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x38 /* 56 */ },
};
static const nir_search_expression search859 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &search859_1.value },
   NULL,
};

   /* replace859_0 -> search93_0 in the cache */

static const nir_search_constant replace859_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace859 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace859_1.value },
   NULL,
};

   /* search860_0 -> search31_0 in the cache */

/* search860_1 -> replace133_0_1 in the cache */
static const nir_search_expression search860 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search31_0.value, &replace133_0_1.value },
   NULL,
};

   /* replace860_0 -> search31_0 in the cache */

/* replace860_1 -> search335_1 in the cache */
static const nir_search_expression replace860 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search31_0.value, &search335_1.value },
   NULL,
};

   /* search861_0 -> search3_0_0 in the cache */

/* search861_1 -> search172_1 in the cache */
static const nir_search_expression search861 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &search172_1.value },
   NULL,
};

   /* replace861_0 -> search3_0_0 in the cache */

/* replace861_1 -> replace858_1 in the cache */
static const nir_search_expression replace861 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0_0.value, &replace858_1.value },
   NULL,
};

   /* search862_0 -> search93_0 in the cache */

/* search862_1 -> search859_1 in the cache */
static const nir_search_expression search862 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &search859_1.value },
   NULL,
};

   /* replace862_0 -> search93_0 in the cache */

/* replace862_1 -> replace859_1 in the cache */
static const nir_search_expression replace862 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace859_1.value },
   NULL,
};

   /* search863_0 -> search397_0_1 in the cache */

/* search863_1 -> search2_0 in the cache */
static const nir_search_expression search863 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search397_0_1.value, &search2_0.value },
   NULL,
};

   /* replace863_0 -> search2_0 in the cache */

/* replace863_1 -> replace9 in the cache */
static const nir_search_expression replace863 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search864_0 -> search3_0_0 in the cache */

/* search864_1 -> search34_1 in the cache */

/* search864_2 -> replace133_0_1 in the cache */
static const nir_search_expression search864 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &search34_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace864_0 -> search3_0_0 in the cache */

/* replace864_1 -> search34_1 in the cache */
static const nir_search_expression replace864 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search865_0 -> search3_0_0 in the cache */

/* search865_1 -> replace133_0_1 in the cache */

/* search865_2 -> replace133_0_1 in the cache */
static const nir_search_expression search865 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &replace133_0_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace865_0 -> search3_0_0 in the cache */

/* replace865_1 -> search163_1 in the cache */
static const nir_search_expression replace865 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

   /* search866_0 -> search3_0_0 in the cache */

/* search866_1 -> replace136_0_1 in the cache */

/* search866_2 -> replace133_0_1 in the cache */
static const nir_search_expression search866 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &replace136_0_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace866_0 -> search3_0_0 in the cache */

/* replace866_1 -> search166_1 in the cache */
static const nir_search_expression replace866 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search3_0_0.value, &search166_1.value },
   NULL,
};

   /* search867_0 -> search3_0_0 in the cache */

/* search867_1 -> search172_1 in the cache */

/* search867_2 -> replace133_0_1 in the cache */
static const nir_search_expression search867 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &search172_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace867_0 -> search3_0_0 in the cache */

/* replace867_1 -> replace858_1 in the cache */
/* replace867 -> replace858 in the cache */

   /* search868_0 -> search3_0_0 in the cache */

/* search868_1 -> search34_1 in the cache */

/* search868_2 -> replace133_0_1 in the cache */
static const nir_search_expression search868 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &search34_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace868_0 -> search3_0_0 in the cache */

/* replace868_1 -> search34_1 in the cache */
static const nir_search_expression replace868 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search869_0 -> search3_0_0 in the cache */

/* search869_1 -> replace133_0_1 in the cache */

/* search869_2 -> replace133_0_1 in the cache */
static const nir_search_expression search869 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &replace133_0_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace869_0 -> search3_0_0 in the cache */

/* replace869_1 -> search163_1 in the cache */
static const nir_search_expression replace869 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

   /* search870_0 -> search3_0_0 in the cache */

/* search870_1 -> replace136_0_1 in the cache */

/* search870_2 -> replace133_0_1 in the cache */
static const nir_search_expression search870 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &replace136_0_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace870_0 -> search3_0_0 in the cache */

/* replace870_1 -> search166_1 in the cache */
static const nir_search_expression replace870 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search3_0_0.value, &search166_1.value },
   NULL,
};

   /* search871_0 -> search3_0_0 in the cache */

/* search871_1 -> search172_1 in the cache */

/* search871_2 -> replace133_0_1 in the cache */
static const nir_search_expression search871 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &search172_1.value, &replace133_0_1.value },
   NULL,
};

   /* replace871_0 -> search3_0_0 in the cache */

/* replace871_1 -> replace858_1 in the cache */
/* replace871 -> replace861 in the cache */

   /* search872_0_0 -> search0_0 in the cache */

/* search872_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search872_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search872_1 -> replace19_1 in the cache */
static const nir_search_expression search872 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search872_0.value, &replace19_1.value },
   NULL,
};

   /* replace872_0 -> search0_0 in the cache */

/* replace872_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace872 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search873_0_0 -> search0_0 in the cache */

/* search873_0_1 -> replace0_1_0 in the cache */
/* search873_0 -> replace872 in the cache */

/* search873_1 -> replace19_1 in the cache */
static const nir_search_expression search873 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace872.value, &replace19_1.value },
   NULL,
};

   /* replace873_0 -> search0_0 in the cache */

/* replace873_1 -> replace0_1_0 in the cache */
/* replace873 -> replace872 in the cache */

   /* search874_0_0 -> search3_0_0 in the cache */

/* search874_0_1 -> replace136_0_1 in the cache */
/* search874_0 -> replace169 in the cache */

/* search874_1 -> replace136_0_1 in the cache */
static const nir_search_expression search874 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace169.value, &replace136_0_1.value },
   NULL,
};

   /* replace874_0 -> search3_0_0 in the cache */

/* replace874_1 -> search34_1 in the cache */
static const nir_search_expression replace874 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search875_0 -> search3_0_0 in the cache */

/* search875_1 -> replace136_0_1 in the cache */
/* search875 -> search171_0 in the cache */

   /* replace875_0 -> search3_0_0 in the cache */

/* replace875_1 -> search163_1 in the cache */
static const nir_search_expression replace875 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

   /* search876_0_0 -> search3_0_0 in the cache */

/* search876_0_1 -> replace136_0_1 in the cache */
/* search876_0 -> replace169 in the cache */

/* search876_1 -> replace136_0_1 in the cache */
static const nir_search_expression search876 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &replace169.value, &replace136_0_1.value },
   NULL,
};

   /* replace876_0 -> search3_0_0 in the cache */

/* replace876_1 -> search34_1 in the cache */
static const nir_search_expression replace876 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* search877_0 -> search3_0_0 in the cache */

/* search877_1 -> replace136_0_1 in the cache */
static const nir_search_expression search877 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &replace136_0_1.value },
   NULL,
};

   /* replace877_0 -> search3_0_0 in the cache */

/* replace877_1 -> search163_1 in the cache */
static const nir_search_expression replace877 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search3_0_0.value, &search163_1.value },
   NULL,
};

   static const nir_search_constant search878_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* search878_1 -> search2_0 in the cache */
static const nir_search_expression search878 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search878_0.value, &search2_0.value },
   NULL,
};

   /* replace878_0 -> search2_0 in the cache */

/* replace878_1 -> replace9 in the cache */
static const nir_search_expression replace878 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search879_0 -> search3_0_0 in the cache */

/* search879_1 -> search34_1 in the cache */

/* search879_2 -> replace136_0_1 in the cache */
static const nir_search_expression search879 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &search34_1.value, &replace136_0_1.value },
   NULL,
};

   /* replace879_0 -> search3_0_0 in the cache */

/* replace879_1 -> search34_1 in the cache */
/* replace879 -> replace874 in the cache */

   /* search880_0 -> search3_0_0 in the cache */

/* search880_1 -> replace136_0_1 in the cache */

/* search880_2 -> replace136_0_1 in the cache */
static const nir_search_expression search880 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search3_0_0.value, &replace136_0_1.value, &replace136_0_1.value },
   NULL,
};

   /* replace880_0 -> search3_0_0 in the cache */

/* replace880_1 -> search163_1 in the cache */
/* replace880 -> replace875 in the cache */

   /* search881_0 -> search3_0_0 in the cache */

/* search881_1 -> search34_1 in the cache */

/* search881_2 -> replace136_0_1 in the cache */
static const nir_search_expression search881 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &search34_1.value, &replace136_0_1.value },
   NULL,
};

   /* replace881_0 -> search3_0_0 in the cache */

/* replace881_1 -> search34_1 in the cache */
/* replace881 -> replace876 in the cache */

   /* search882_0 -> search3_0_0 in the cache */

/* search882_1 -> replace136_0_1 in the cache */

/* search882_2 -> replace136_0_1 in the cache */
static const nir_search_expression search882 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search3_0_0.value, &replace136_0_1.value, &replace136_0_1.value },
   NULL,
};

   /* replace882_0 -> search3_0_0 in the cache */

/* replace882_1 -> search163_1 in the cache */
/* replace882 -> replace877 in the cache */

   /* search883_0_0 -> search0_0 in the cache */

/* search883_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search883_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search883_1 -> replace19_1 in the cache */
static const nir_search_expression search883 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search883_0.value, &replace19_1.value },
   NULL,
};

   /* replace883_0 -> search0_0 in the cache */

/* replace883_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace883 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search884_0_0 -> search0_0 in the cache */

/* search884_0_1 -> replace0_1_0 in the cache */
/* search884_0 -> replace883 in the cache */

/* search884_1 -> replace19_1 in the cache */
static const nir_search_expression search884 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &replace883.value, &replace19_1.value },
   NULL,
};

   /* replace884_0 -> search0_0 in the cache */

/* replace884_1 -> replace0_1_0 in the cache */
/* replace884 -> replace883 in the cache */

   /* search885_0 -> search3_0_0 in the cache */

/* search885_1 -> replace2_1_1 in the cache */
/* search885 -> search847_0 in the cache */

   /* replace885_0_0 -> search3_0_0 in the cache */
/* replace885_0 -> search494_0 in the cache */

/* replace885_1_0_0 -> replace2_1_1 in the cache */
static const nir_search_expression replace885_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace2_1_1.value },
   NULL,
};

/* replace885_1_1 -> replace139_0_1 in the cache */
static const nir_search_expression replace885_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace885_1_0.value, &replace139_0_1.value },
   NULL,
};
static const nir_search_expression replace885 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search494_0.value, &replace885_1.value },
   NULL,
};

   /* search886_0 -> search31_0 in the cache */

/* search886_1 -> search61_2 in the cache */
static const nir_search_expression search886 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_32_2x16_split,
   { &search31_0.value, &search61_2.value },
   NULL,
};

   /* replace886_0_0 -> search31_0 in the cache */
/* replace886_0 -> search453_0 in the cache */

/* replace886_1_0_0 -> search61_2 in the cache */
static const nir_search_expression replace886_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search61_2.value },
   NULL,
};

/* replace886_1_1 -> replace136_0_1 in the cache */
static const nir_search_expression replace886_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace886_1_0.value, &replace136_0_1.value },
   NULL,
};
static const nir_search_expression replace886 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search453_0.value, &replace886_1.value },
   NULL,
};

   /* search887_0 -> search93_0 in the cache */
/* search887 -> search852_0 in the cache */

   /* replace887_0 -> search93_0 in the cache */
static const nir_search_expression replace887 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search93_0.value },
   NULL,
};

   /* search888_0 -> search93_0 in the cache */
/* search888 -> search852_1 in the cache */

   /* replace888_0_0 -> search93_0 in the cache */

/* replace888_0_1 -> replace139_0_1 in the cache */
static const nir_search_expression replace888_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &replace139_0_1.value },
   NULL,
};
static const nir_search_expression replace888 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace888_0.value },
   NULL,
};

   /* search889_0 -> search3_0_0 in the cache */
/* search889 -> search856_0_0 in the cache */

   /* replace889_0 -> search3_0_0 in the cache */
static const nir_search_expression replace889 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search3_0_0.value },
   NULL,
};

   /* search890_0 -> search3_0_0 in the cache */
/* search890 -> search856_1_0 in the cache */

   /* replace890_0_0 -> search3_0_0 in the cache */

/* replace890_0_1 -> replace136_0_1 in the cache */
/* replace890_0 -> search171_0 in the cache */
static const nir_search_expression replace890 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search171_0.value },
   NULL,
};

   /* search891_0_0 -> search3_0_0 in the cache */

/* search891_0_1 -> replace136_0_0_0_1 in the cache */
/* search891_0 -> search169_0 in the cache */
static const nir_search_expression search891 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_x,
   { &search169_0.value },
   NULL,
};

   /* replace891_0 -> search3_0_0 in the cache */
static const nir_search_expression replace891 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &search3_0_0.value },
   NULL,
};

   /* search892_0_0 -> search3_0_0 in the cache */

/* search892_0_1 -> replace136_0_0_0_1 in the cache */
/* search892_0 -> search169_0 in the cache */
static const nir_search_expression search892 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_x,
   { &search169_0.value },
   NULL,
};

   /* replace892_0 -> search3_0_0 in the cache */
/* replace892 -> search856_0_0 in the cache */

   /* search893_0_0 -> search93_0 in the cache */

static const nir_search_constant search893_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression search893_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search93_0.value, &search893_0_1.value },
   NULL,
};
static const nir_search_expression search893 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search893_0.value },
   NULL,
};

   /* replace893_0 -> search93_0 in the cache */
/* replace893 -> search852_0 in the cache */

   /* search894_0_0 -> search3_0_0 in the cache */

/* search894_0_1 -> search170_1 in the cache */
static const nir_search_expression search894_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search3_0_0.value, &search170_1.value },
   NULL,
};
static const nir_search_expression search894 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_y,
   { &search894_0.value },
   NULL,
};

   /* replace894_0 -> search3_0_0 in the cache */
static const nir_search_expression replace894 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_y,
   { &search3_0_0.value },
   NULL,
};

   /* search895_0_0 -> search3_0_0 in the cache */

/* search895_0_1 -> search170_1 in the cache */
/* search895_0 -> search894_0 in the cache */
static const nir_search_expression search895 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_y,
   { &search894_0.value },
   NULL,
};

   /* replace895_0 -> search3_0_0 in the cache */
/* replace895 -> search856_1_0 in the cache */

   /* search896_0_0 -> search93_0 in the cache */

static const nir_search_constant search896_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff00000000 /* 18446744069414584320 */ },
};
static const nir_search_expression search896_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search93_0.value, &search896_0_1.value },
   NULL,
};
static const nir_search_expression search896 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_y,
   { &search896_0.value },
   NULL,
};

   /* replace896_0 -> search93_0 in the cache */
/* replace896 -> search852_1 in the cache */

   /* search897_0_0 -> search3_0_0 in the cache */

/* search897_0_1 -> search34_1 in the cache */
/* search897_0 -> replace874 in the cache */
static const nir_search_expression search897 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &replace874.value },
   NULL,
};

   /* replace897_0 -> search3_0_0 in the cache */
/* replace897 -> replace891 in the cache */

   /* search898_0_0 -> search3_0_0 in the cache */

/* search898_0_1 -> search163_1 in the cache */
/* search898_0 -> replace875 in the cache */
static const nir_search_expression search898 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &replace875.value },
   NULL,
};

   /* replace898_0 -> search3_0_0 in the cache */
/* replace898 -> replace894 in the cache */

   /* search899_0_0 -> search3_0_0 in the cache */

/* search899_0_1 -> replace136_0_1 in the cache */
/* search899_0 -> search171_0 in the cache */
static const nir_search_expression search899 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &search171_0.value },
   NULL,
};

   /* replace899_0 -> search3_0_0 in the cache */
/* replace899 -> replace894 in the cache */

   /* search900_0_0 -> search3_0_0 in the cache */

/* search900_0_1 -> search34_1 in the cache */
/* search900_0 -> replace874 in the cache */
static const nir_search_expression search900 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_x,
   { &replace874.value },
   NULL,
};

   /* replace900_0 -> search3_0_0 in the cache */
/* replace900 -> search856_0_0 in the cache */

   /* search901_0_0 -> search3_0_0 in the cache */

/* search901_0_1 -> search163_1 in the cache */
/* search901_0 -> replace875 in the cache */
static const nir_search_expression search901 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_x,
   { &replace875.value },
   NULL,
};

   /* replace901_0 -> search3_0_0 in the cache */
/* replace901 -> search856_1_0 in the cache */

   /* search902_0_0_0 -> search3_0_0 in the cache */

/* search902_0_0_1 -> search34_1 in the cache */
static const nir_search_expression search902_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};
static const nir_search_expression search902_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &search902_0_0.value },
   NULL,
};

/* search902_1 -> replace136_0_1 in the cache */
static const nir_search_expression search902 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search902_0.value, &replace136_0_1.value },
   NULL,
};

   /* replace902_0_0 -> search34_1 in the cache */

/* replace902_0_1 -> search3_0_0 in the cache */
static const nir_search_expression replace902_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search34_1.value, &search3_0_0.value },
   NULL,
};
static const nir_search_expression replace902 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &replace902_0.value },
   NULL,
};

   /* search903_0_0_0 -> search34_1 in the cache */

/* search903_0_0_1 -> search3_0_0 in the cache */
/* search903_0_0 -> replace902_0 in the cache */
/* search903_0 -> replace902 in the cache */

/* search903_1 -> replace136_0_1 in the cache */
static const nir_search_expression search903 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace902.value, &replace136_0_1.value },
   NULL,
};

   /* replace903_0_0 -> search3_0_0 in the cache */

/* replace903_0_1 -> search34_1 in the cache */
/* replace903_0 -> search902_0_0 in the cache */
/* replace903 -> search902_0 in the cache */

   /* search904_0_0_0 -> search3_0_0 in the cache */

/* search904_0_0_1 -> search34_1 in the cache */
/* search904_0_0 -> search902_0_0 in the cache */
/* search904_0 -> search902_0 in the cache */

/* search904_1_0_0 -> search34_1 in the cache */

/* search904_1_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression search904_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search34_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search904_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &search904_1_0.value },
   NULL,
};
static const nir_search_expression search904 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search902_0.value, &search904_1.value },
   NULL,
};

   /* replace904_0_0 -> search3_0_0 in the cache */

/* replace904_0_1 -> replace2_1_1 in the cache */
/* replace904_0 -> replace849 in the cache */
static const nir_search_expression replace904 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16,
   { &replace849.value },
   NULL,
};

   /* search905_0_0_0 -> search3_0_0 in the cache */

/* search905_0_0_1 -> search34_1 in the cache */
/* search905_0_0 -> search902_0_0 in the cache */
/* search905_0 -> search902_0 in the cache */

/* search905_1_0_0 -> search34_1 in the cache */

/* search905_1_0_1 -> replace2_1_1 in the cache */
/* search905_1_0 -> search904_1_0 in the cache */
/* search905_1 -> search904_1 in the cache */
static const nir_search_expression search905 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search902_0.value, &search904_1.value },
   NULL,
};

   /* replace905_0_0 -> search3_0_0 in the cache */

/* replace905_0_1 -> replace2_1_1 in the cache */
/* replace905_0 -> replace849 in the cache */
/* replace905 -> replace904 in the cache */

   /* search906_0_0 -> search3_0_0 in the cache */

/* search906_0_1 -> search34_1 in the cache */
static const nir_search_expression search906_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16_split,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

/* search906_1 -> replace136_0_1 in the cache */
static const nir_search_expression search906 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search906_0.value, &replace136_0_1.value },
   NULL,
};

   /* replace906_0 -> search34_1 in the cache */

/* replace906_1 -> search3_0_0 in the cache */
static const nir_search_expression replace906 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16_split,
   { &search34_1.value, &search3_0_0.value },
   NULL,
};

   /* search907_0_0 -> search34_1 in the cache */

/* search907_0_1 -> search3_0_0 in the cache */
/* search907_0 -> replace906 in the cache */

/* search907_1 -> replace136_0_1 in the cache */
static const nir_search_expression search907 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace906.value, &replace136_0_1.value },
   NULL,
};

   /* replace907_0 -> search3_0_0 in the cache */

/* replace907_1 -> search34_1 in the cache */
/* replace907 -> search906_0 in the cache */

   /* search908_0_0 -> search34_1 in the cache */

/* search908_0_1 -> search3_0_0 in the cache */
/* search908_0 -> replace906 in the cache */

/* search908_1 -> search163_1 in the cache */
static const nir_search_expression search908 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &replace906.value, &search163_1.value },
   NULL,
};

   /* replace908_0 -> search3_0_0 in the cache */

/* replace908_1 -> search34_1 in the cache */
/* replace908 -> search906_0 in the cache */

   /* search909_0_0 -> search3_0_0 in the cache */

/* search909_0_1 -> search34_1 in the cache */
/* search909_0 -> search906_0 in the cache */

/* search909_1_0 -> search34_1 in the cache */

/* search909_1_1 -> replace2_1_1 in the cache */
static const nir_search_expression search909_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16_split,
   { &search34_1.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression search909 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search906_0.value, &search909_1.value },
   NULL,
};

   /* replace909_0 -> search3_0_0 in the cache */

/* replace909_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace909 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_half_2x16_split,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* search910_0_0 -> search3_0_0 in the cache */

/* search910_0_1 -> search34_1 in the cache */
/* search910_0 -> search906_0 in the cache */

/* search910_1_0 -> search34_1 in the cache */

/* search910_1_1 -> replace2_1_1 in the cache */
/* search910_1 -> search909_1 in the cache */
static const nir_search_expression search910 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search906_0.value, &search909_1.value },
   NULL,
};

   /* replace910_0 -> search3_0_0 in the cache */

/* replace910_1 -> replace2_1_1 in the cache */
/* replace910 -> replace909 in the cache */

   /* search911_0_0 -> search31_0 in the cache */

/* search911_0_1 -> replace133_0_1 in the cache */
/* search911_0 -> search857 in the cache */

/* search911_1 -> replace136_2 in the cache */
static const nir_search_expression search911 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search857.value, &replace136_2.value },
   NULL,
};

   /* replace911_0 -> search31_0 in the cache */

/* replace911_1 -> search335_1 in the cache */
/* replace911 -> replace857 in the cache */

   /* search912_0_0 -> search3_0_0 in the cache */

/* search912_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search912_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search3_0_0.value, &replace133_0_1.value },
   NULL,
};

/* search912_1 -> search34_1 in the cache */
static const nir_search_expression search912 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search912_0.value, &search34_1.value },
   NULL,
};

   /* replace912_0 -> search3_0_0 in the cache */

/* replace912_1 -> search163_1 in the cache */
/* replace912 -> replace865 in the cache */

   /* search913_0_0 -> search3_0_0 in the cache */

/* search913_0_1 -> replace136_0_1 in the cache */
/* search913_0 -> search171_0 in the cache */

/* search913_1 -> search34_1 in the cache */
static const nir_search_expression search913 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search171_0.value, &search34_1.value },
   NULL,
};

   /* replace913_0 -> search3_0_0 in the cache */

/* replace913_1 -> search166_1 in the cache */
/* replace913 -> replace866 in the cache */

   /* search914_0_0 -> search3_0_0 in the cache */

/* search914_0_1 -> search172_1 in the cache */
/* search914_0 -> search174_0 in the cache */

/* search914_1 -> search34_1 in the cache */
static const nir_search_expression search914 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search174_0.value, &search34_1.value },
   NULL,
};

   /* replace914_0 -> search3_0_0 in the cache */

/* replace914_1 -> replace858_1 in the cache */
/* replace914 -> replace858 in the cache */

   /* search915_0_0 -> search93_0 in the cache */

/* search915_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search915_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &replace133_0_1.value },
   NULL,
};

/* search915_1 -> replace142_2 in the cache */
static const nir_search_expression search915 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search915_0.value, &replace142_2.value },
   NULL,
};

   /* replace915_0 -> search93_0 in the cache */

/* replace915_1 -> search361_1 in the cache */
static const nir_search_expression replace915 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &search361_1.value },
   NULL,
};

   /* search916_0_0 -> search93_0 in the cache */

/* search916_0_1 -> replace136_0_1 in the cache */
static const nir_search_expression search916_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &replace136_0_1.value },
   NULL,
};

/* search916_1 -> replace142_2 in the cache */
static const nir_search_expression search916 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search916_0.value, &replace142_2.value },
   NULL,
};

   /* replace916_0 -> search93_0 in the cache */

static const nir_search_constant replace916_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression replace916 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace916_1.value },
   NULL,
};

   /* search917_0_0 -> search93_0 in the cache */

/* search917_0_1 -> search172_1 in the cache */
static const nir_search_expression search917_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &search172_1.value },
   NULL,
};

/* search917_1 -> replace142_2 in the cache */
static const nir_search_expression search917 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search917_0.value, &replace142_2.value },
   NULL,
};

   /* replace917_0 -> search93_0 in the cache */

static const nir_search_constant replace917_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace917 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace917_1.value },
   NULL,
};

   /* search918_0_0 -> search93_0 in the cache */

/* search918_0_1 -> replace139_0_1 in the cache */
/* search918_0 -> replace888_0 in the cache */

/* search918_1 -> replace142_2 in the cache */
static const nir_search_expression search918 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace888_0.value, &replace142_2.value },
   NULL,
};

   /* replace918_0 -> search93_0 in the cache */

static const nir_search_constant replace918_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x4 /* 4 */ },
};
static const nir_search_expression replace918 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace918_1.value },
   NULL,
};

   /* search919_0_0 -> search93_0 in the cache */

static const nir_search_constant search919_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x28 /* 40 */ },
};
static const nir_search_expression search919_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &search919_0_1.value },
   NULL,
};

/* search919_1 -> replace142_2 in the cache */
static const nir_search_expression search919 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search919_0.value, &replace142_2.value },
   NULL,
};

   /* replace919_0 -> search93_0 in the cache */

static const nir_search_constant replace919_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x5 /* 5 */ },
};
static const nir_search_expression replace919 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace919_1.value },
   NULL,
};

   /* search920_0_0 -> search93_0 in the cache */

static const nir_search_constant search920_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x30 /* 48 */ },
};
static const nir_search_expression search920_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search93_0.value, &search920_0_1.value },
   NULL,
};

/* search920_1 -> replace142_2 in the cache */
static const nir_search_expression search920 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search920_0.value, &replace142_2.value },
   NULL,
};

   /* replace920_0 -> search93_0 in the cache */

static const nir_search_constant replace920_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x6 /* 6 */ },
};
static const nir_search_expression replace920 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace920_1.value },
   NULL,
};

   /* search921_0_0 -> search93_0 in the cache */

/* search921_0_1 -> search859_1 in the cache */
/* search921_0 -> search859 in the cache */

/* search921_1 -> replace142_2 in the cache */
static const nir_search_expression search921 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search859.value, &replace142_2.value },
   NULL,
};

   /* replace921_0 -> search93_0 in the cache */

/* replace921_1 -> replace859_1 in the cache */
/* replace921 -> replace859 in the cache */

   /* search922_0_0 -> search31_0 in the cache */

/* search922_0_1 -> replace133_0_1 in the cache */
/* search922_0 -> search860 in the cache */

/* search922_1 -> replace136_2 in the cache */
static const nir_search_expression search922 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search860.value, &replace136_2.value },
   NULL,
};

   /* replace922_0 -> search31_0 in the cache */

/* replace922_1 -> search335_1 in the cache */
/* replace922 -> replace857 in the cache */

   /* search923_0_0 -> search3_0_0 in the cache */

/* search923_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search923_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search3_0_0.value, &replace133_0_1.value },
   NULL,
};

/* search923_1 -> search34_1 in the cache */
static const nir_search_expression search923 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search923_0.value, &search34_1.value },
   NULL,
};

   /* replace923_0 -> search3_0_0 in the cache */

/* replace923_1 -> search163_1 in the cache */
/* replace923 -> replace865 in the cache */

   /* search924_0_0 -> search3_0_0 in the cache */

/* search924_0_1 -> replace136_0_1 in the cache */
/* search924_0 -> search877 in the cache */

/* search924_1 -> search34_1 in the cache */
static const nir_search_expression search924 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search877.value, &search34_1.value },
   NULL,
};

   /* replace924_0 -> search3_0_0 in the cache */

/* replace924_1 -> search166_1 in the cache */
/* replace924 -> replace866 in the cache */

   /* search925_0_0 -> search3_0_0 in the cache */

/* search925_0_1 -> search172_1 in the cache */
/* search925_0 -> search861 in the cache */

/* search925_1 -> search34_1 in the cache */
static const nir_search_expression search925 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search861.value, &search34_1.value },
   NULL,
};

   /* replace925_0 -> search3_0_0 in the cache */

/* replace925_1 -> replace858_1 in the cache */
/* replace925 -> replace858 in the cache */

   /* search926_0_0 -> search93_0 in the cache */

/* search926_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search926_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &replace133_0_1.value },
   NULL,
};

/* search926_1 -> replace142_2 in the cache */
static const nir_search_expression search926 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search926_0.value, &replace142_2.value },
   NULL,
};

   /* replace926_0 -> search93_0 in the cache */

/* replace926_1 -> search361_1 in the cache */
/* replace926 -> replace915 in the cache */

   /* search927_0_0 -> search93_0 in the cache */

/* search927_0_1 -> replace136_0_1 in the cache */
static const nir_search_expression search927_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &replace136_0_1.value },
   NULL,
};

/* search927_1 -> replace142_2 in the cache */
static const nir_search_expression search927 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search927_0.value, &replace142_2.value },
   NULL,
};

   /* replace927_0 -> search93_0 in the cache */

/* replace927_1 -> replace916_1 in the cache */
/* replace927 -> replace916 in the cache */

   /* search928_0_0 -> search93_0 in the cache */

/* search928_0_1 -> search172_1 in the cache */
static const nir_search_expression search928_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &search172_1.value },
   NULL,
};

/* search928_1 -> replace142_2 in the cache */
static const nir_search_expression search928 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search928_0.value, &replace142_2.value },
   NULL,
};

   /* replace928_0 -> search93_0 in the cache */

/* replace928_1 -> replace917_1 in the cache */
/* replace928 -> replace917 in the cache */

   /* search929_0_0 -> search93_0 in the cache */

/* search929_0_1 -> replace139_0_1 in the cache */
static const nir_search_expression search929_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &replace139_0_1.value },
   NULL,
};

/* search929_1 -> replace142_2 in the cache */
static const nir_search_expression search929 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search929_0.value, &replace142_2.value },
   NULL,
};

   /* replace929_0 -> search93_0 in the cache */

/* replace929_1 -> replace918_1 in the cache */
/* replace929 -> replace918 in the cache */

   /* search930_0_0 -> search93_0 in the cache */

/* search930_0_1 -> search919_0_1 in the cache */
static const nir_search_expression search930_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &search919_0_1.value },
   NULL,
};

/* search930_1 -> replace142_2 in the cache */
static const nir_search_expression search930 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search930_0.value, &replace142_2.value },
   NULL,
};

   /* replace930_0 -> search93_0 in the cache */

/* replace930_1 -> replace919_1 in the cache */
/* replace930 -> replace919 in the cache */

   /* search931_0_0 -> search93_0 in the cache */

/* search931_0_1 -> search920_0_1 in the cache */
static const nir_search_expression search931_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search93_0.value, &search920_0_1.value },
   NULL,
};

/* search931_1 -> replace142_2 in the cache */
static const nir_search_expression search931 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search931_0.value, &replace142_2.value },
   NULL,
};

   /* replace931_0 -> search93_0 in the cache */

/* replace931_1 -> replace920_1 in the cache */
/* replace931 -> replace920 in the cache */

   /* search932_0_0 -> search93_0 in the cache */

/* search932_0_1 -> search859_1 in the cache */
/* search932_0 -> search862 in the cache */

/* search932_1 -> replace142_2 in the cache */
static const nir_search_expression search932 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search862.value, &replace142_2.value },
   NULL,
};

   /* replace932_0 -> search93_0 in the cache */

/* replace932_1 -> replace859_1 in the cache */
/* replace932 -> replace859 in the cache */

   /* search933_0_0 -> search2_0 in the cache */

/* search933_0_1 -> replace2_1_0 in the cache */
static const nir_search_expression search933_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

/* search933_1 -> replace9 in the cache */
static const nir_search_expression search933 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search933_0.value, &replace9.value },
   NULL,
};

   /* replace933_0 -> search2_0 in the cache */

/* replace933_1 -> search570_1_1 in the cache */
static const nir_search_expression replace933 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &search570_1_1.value },
   NULL,
};

   /* search934_0_0 -> search31_0 in the cache */

/* search934_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search934_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search31_0.value, &replace133_0_1.value },
   NULL,
};

/* search934_1 -> search335_1 in the cache */
static const nir_search_expression search934 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search934_0.value, &search335_1.value },
   NULL,
};

   /* replace934_0 -> search31_0 in the cache */

/* replace934_1 -> replace136_2 in the cache */
static const nir_search_expression replace934 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

   /* search935_0_0 -> search3_0_0 in the cache */

/* search935_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search935_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search3_0_0.value, &replace133_0_1.value },
   NULL,
};

/* search935_1 -> replace858_1 in the cache */
static const nir_search_expression search935 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search935_0.value, &replace858_1.value },
   NULL,
};

   /* replace935_0 -> search3_0_0 in the cache */

/* replace935_1 -> search166_1 in the cache */
/* replace935 -> replace866 in the cache */

   /* search936_0_0 -> search3_0_0 in the cache */

/* search936_0_1 -> replace136_0_1 in the cache */
/* search936_0 -> replace169 in the cache */

/* search936_1 -> replace858_1 in the cache */
static const nir_search_expression search936 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace169.value, &replace858_1.value },
   NULL,
};

   /* replace936_0 -> search3_0_0 in the cache */

/* replace936_1 -> search163_1 in the cache */
/* replace936 -> replace865 in the cache */

   /* search937_0_0 -> search3_0_0 in the cache */

/* search937_0_1 -> search172_1 in the cache */
/* search937_0 -> replace172 in the cache */

/* search937_1 -> replace858_1 in the cache */
static const nir_search_expression search937 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &replace172.value, &replace858_1.value },
   NULL,
};

   /* replace937_0 -> search3_0_0 in the cache */

/* replace937_1 -> search34_1 in the cache */
/* replace937 -> replace864 in the cache */

   /* search938_0_0 -> search93_0 in the cache */

/* search938_0_1 -> replace133_0_1 in the cache */
static const nir_search_expression search938_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &replace133_0_1.value },
   NULL,
};

/* search938_1 -> replace859_1 in the cache */
static const nir_search_expression search938 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search938_0.value, &replace859_1.value },
   NULL,
};

   /* replace938_0 -> search93_0 in the cache */

/* replace938_1 -> replace920_1 in the cache */
/* replace938 -> replace920 in the cache */

   /* search939_0_0 -> search93_0 in the cache */

/* search939_0_1 -> replace136_0_1 in the cache */
static const nir_search_expression search939_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &replace136_0_1.value },
   NULL,
};

/* search939_1 -> replace859_1 in the cache */
static const nir_search_expression search939 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search939_0.value, &replace859_1.value },
   NULL,
};

   /* replace939_0 -> search93_0 in the cache */

/* replace939_1 -> replace919_1 in the cache */
/* replace939 -> replace919 in the cache */

   /* search940_0_0 -> search93_0 in the cache */

/* search940_0_1 -> search172_1 in the cache */
static const nir_search_expression search940_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &search172_1.value },
   NULL,
};

/* search940_1 -> replace859_1 in the cache */
static const nir_search_expression search940 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search940_0.value, &replace859_1.value },
   NULL,
};

   /* replace940_0 -> search93_0 in the cache */

/* replace940_1 -> replace918_1 in the cache */
/* replace940 -> replace918 in the cache */

   /* search941_0_0 -> search93_0 in the cache */

/* search941_0_1 -> replace139_0_1 in the cache */
static const nir_search_expression search941_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &replace139_0_1.value },
   NULL,
};

/* search941_1 -> replace859_1 in the cache */
static const nir_search_expression search941 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search941_0.value, &replace859_1.value },
   NULL,
};

   /* replace941_0 -> search93_0 in the cache */

/* replace941_1 -> replace917_1 in the cache */
/* replace941 -> replace917 in the cache */

   /* search942_0_0 -> search93_0 in the cache */

/* search942_0_1 -> search919_0_1 in the cache */
static const nir_search_expression search942_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &search919_0_1.value },
   NULL,
};

/* search942_1 -> replace859_1 in the cache */
static const nir_search_expression search942 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search942_0.value, &replace859_1.value },
   NULL,
};

   /* replace942_0 -> search93_0 in the cache */

/* replace942_1 -> replace916_1 in the cache */
/* replace942 -> replace916 in the cache */

   /* search943_0_0 -> search93_0 in the cache */

/* search943_0_1 -> search920_0_1 in the cache */
static const nir_search_expression search943_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &search920_0_1.value },
   NULL,
};

/* search943_1 -> replace859_1 in the cache */
static const nir_search_expression search943 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search943_0.value, &replace859_1.value },
   NULL,
};

   /* replace943_0 -> search93_0 in the cache */

/* replace943_1 -> search361_1 in the cache */
/* replace943 -> replace915 in the cache */

   /* search944_0_0 -> search93_0 in the cache */

/* search944_0_1 -> search859_1 in the cache */
static const nir_search_expression search944_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search93_0.value, &search859_1.value },
   NULL,
};

/* search944_1 -> replace859_1 in the cache */
static const nir_search_expression search944 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search944_0.value, &replace859_1.value },
   NULL,
};

   /* replace944_0 -> search93_0 in the cache */

/* replace944_1 -> replace142_2 in the cache */
static const nir_search_expression replace944 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* search945_0_0 -> search31_0 in the cache */

/* search945_0_1 -> replace133_0_1 in the cache */
/* search945_0 -> search934_0 in the cache */

/* search945_1 -> search335_1 in the cache */
static const nir_search_expression search945 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search934_0.value, &search335_1.value },
   NULL,
};

   /* replace945_0 -> search31_0 in the cache */

/* replace945_1 -> replace136_2 in the cache */
static const nir_search_expression replace945 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search31_0.value, &replace136_2.value },
   NULL,
};

   /* search946_0_0 -> search3_0_0 in the cache */

/* search946_0_1 -> replace133_0_1 in the cache */
/* search946_0 -> search935_0 in the cache */

/* search946_1 -> replace858_1 in the cache */
static const nir_search_expression search946 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search935_0.value, &replace858_1.value },
   NULL,
};

   /* replace946_0 -> search3_0_0 in the cache */

/* replace946_1 -> search166_1 in the cache */
/* replace946 -> replace870 in the cache */

   /* search947_0_0 -> search3_0_0 in the cache */

/* search947_0_1 -> replace136_0_1 in the cache */
/* search947_0 -> replace169 in the cache */

/* search947_1 -> replace858_1 in the cache */
static const nir_search_expression search947 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace169.value, &replace858_1.value },
   NULL,
};

   /* replace947_0 -> search3_0_0 in the cache */

/* replace947_1 -> search163_1 in the cache */
/* replace947 -> replace869 in the cache */

   /* search948_0_0 -> search3_0_0 in the cache */

/* search948_0_1 -> search172_1 in the cache */
/* search948_0 -> replace172 in the cache */

/* search948_1 -> replace858_1 in the cache */
static const nir_search_expression search948 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &replace172.value, &replace858_1.value },
   NULL,
};

   /* replace948_0 -> search3_0_0 in the cache */

/* replace948_1 -> search34_1 in the cache */
/* replace948 -> replace868 in the cache */

   /* search949_0_0 -> search93_0 in the cache */

/* search949_0_1 -> replace133_0_1 in the cache */
/* search949_0 -> search938_0 in the cache */

/* search949_1 -> replace859_1 in the cache */
static const nir_search_expression search949 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search938_0.value, &replace859_1.value },
   NULL,
};

   /* replace949_0 -> search93_0 in the cache */

/* replace949_1 -> replace920_1 in the cache */
static const nir_search_expression replace949 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace920_1.value },
   NULL,
};

   /* search950_0_0 -> search93_0 in the cache */

/* search950_0_1 -> replace136_0_1 in the cache */
/* search950_0 -> search939_0 in the cache */

/* search950_1 -> replace859_1 in the cache */
static const nir_search_expression search950 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search939_0.value, &replace859_1.value },
   NULL,
};

   /* replace950_0 -> search93_0 in the cache */

/* replace950_1 -> replace919_1 in the cache */
static const nir_search_expression replace950 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace919_1.value },
   NULL,
};

   /* search951_0_0 -> search93_0 in the cache */

/* search951_0_1 -> search172_1 in the cache */
/* search951_0 -> search940_0 in the cache */

/* search951_1 -> replace859_1 in the cache */
static const nir_search_expression search951 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search940_0.value, &replace859_1.value },
   NULL,
};

   /* replace951_0 -> search93_0 in the cache */

/* replace951_1 -> replace918_1 in the cache */
static const nir_search_expression replace951 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace918_1.value },
   NULL,
};

   /* search952_0_0 -> search93_0 in the cache */

/* search952_0_1 -> replace139_0_1 in the cache */
/* search952_0 -> search941_0 in the cache */

/* search952_1 -> replace859_1 in the cache */
static const nir_search_expression search952 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search941_0.value, &replace859_1.value },
   NULL,
};

   /* replace952_0 -> search93_0 in the cache */

/* replace952_1 -> replace917_1 in the cache */
static const nir_search_expression replace952 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace917_1.value },
   NULL,
};

   /* search953_0_0 -> search93_0 in the cache */

/* search953_0_1 -> search919_0_1 in the cache */
/* search953_0 -> search942_0 in the cache */

/* search953_1 -> replace859_1 in the cache */
static const nir_search_expression search953 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search942_0.value, &replace859_1.value },
   NULL,
};

   /* replace953_0 -> search93_0 in the cache */

/* replace953_1 -> replace916_1 in the cache */
static const nir_search_expression replace953 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace916_1.value },
   NULL,
};

   /* search954_0_0 -> search93_0 in the cache */

/* search954_0_1 -> search920_0_1 in the cache */
/* search954_0 -> search943_0 in the cache */

/* search954_1 -> replace859_1 in the cache */
static const nir_search_expression search954 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search943_0.value, &replace859_1.value },
   NULL,
};

   /* replace954_0 -> search93_0 in the cache */

/* replace954_1 -> search361_1 in the cache */
static const nir_search_expression replace954 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &search361_1.value },
   NULL,
};

   /* search955_0_0 -> search93_0 in the cache */

/* search955_0_1 -> search859_1 in the cache */
/* search955_0 -> search944_0 in the cache */

/* search955_1 -> replace859_1 in the cache */
static const nir_search_expression search955 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search944_0.value, &replace859_1.value },
   NULL,
};

   /* replace955_0 -> search93_0 in the cache */

/* replace955_1 -> replace142_2 in the cache */
static const nir_search_expression replace955 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* search956_0 -> search3_0_0 in the cache */

/* search956_1 -> search34_1 in the cache */
static const nir_search_expression search956 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8_vc4,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

   /* replace956 -> search3_0_0 in the cache */

   /* search957_0 -> search3_0_0 in the cache */

/* search957_1 -> search35_1 in the cache */
static const nir_search_expression search957 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8_vc4,
   { &search3_0_0.value, &search35_1.value },
   NULL,
};

   /* replace957 -> search34_1 in the cache */

   /* search958_0 -> search0_0 in the cache */

/* search958_1 -> replace0_1_0 in the cache */
static const nir_search_expression search958 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace958_0 -> search0_0 in the cache */

/* replace958_1_0 -> replace0_1_0 in the cache */
/* replace958_1 -> search194_1 in the cache */
static const nir_search_expression replace958 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &search194_1.value },
   NULL,
};

   /* search959_0 -> search0_0 in the cache */

/* search959_1 -> replace0_1_0 in the cache */
static const nir_search_expression search959 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace959_0 -> search0_0 in the cache */

/* replace959_1_0 -> replace0_1_0 in the cache */
/* replace959_1 -> replace20_2_1 in the cache */
static const nir_search_expression replace959 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &replace20_2_1.value },
   NULL,
};

   /* search960_0 -> search0_0 in the cache */

/* search960_1 -> replace0_1_0 in the cache */
static const nir_search_expression search960 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_uabs_usub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace960_0_0 -> search0_0 in the cache */

/* replace960_0_1 -> replace0_1_0 in the cache */
/* replace960_0 -> replace186 in the cache */

/* replace960_1_0_0 -> search0_0 in the cache */

/* replace960_1_0_1 -> replace0_1_0 in the cache */
/* replace960_1_0 -> search959 in the cache */
static const nir_search_expression replace960_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search959.value },
   NULL,
};

/* replace960_2_0 -> search0_0 in the cache */

/* replace960_2_1 -> replace0_1_0 in the cache */
/* replace960_2 -> search959 in the cache */
static const nir_search_expression replace960 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace186.value, &replace960_1.value, &search959.value },
   NULL,
};

   /* search961_0 -> search0_0 in the cache */

/* search961_1 -> replace0_1_0 in the cache */
static const nir_search_expression search961 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_uabs_isub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace961_0_0 -> search0_0 in the cache */

/* replace961_0_1 -> replace0_1_0 in the cache */
/* replace961_0 -> replace185 in the cache */

/* replace961_1_0_0 -> search0_0 in the cache */

/* replace961_1_0_1 -> replace0_1_0 in the cache */
/* replace961_1_0 -> search959 in the cache */
/* replace961_1 -> replace960_1 in the cache */

/* replace961_2_0 -> search0_0 in the cache */

/* replace961_2_1 -> replace0_1_0 in the cache */
/* replace961_2 -> search959 in the cache */
static const nir_search_expression replace961 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace185.value, &replace960_1.value, &search959.value },
   NULL,
};

   /* search962_0_0 -> search0_0 in the cache */
/* search962_0 -> search44_0 in the cache */

/* search962_1 -> replace0_1_0 in the cache */
static const nir_search_expression search962 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search44_0.value, &replace0_1_0.value },
   (is_used_by_non_fsat),
};

   /* replace962_0_0 -> search0_0 in the cache */

/* replace962_0_1 -> replace0_1_0 in the cache */
/* replace962_0 -> replace63 in the cache */
static const nir_search_expression replace962 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace63.value },
   NULL,
};

   /* search963_0_0 -> search0_0 in the cache */
/* search963_0 -> search42_0 in the cache */

/* search963_1 -> replace0_1_0 in the cache */
static const nir_search_expression search963 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search42_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace963_0_0 -> search0_0 in the cache */

/* replace963_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace963_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace963 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace963_0.value },
   NULL,
};

   static const nir_search_variable search964_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search964_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search964_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search964_0_0.value, &search964_0_1.value },
   (is_used_once),
};

/* search964_1 -> search131_0_1 in the cache */
static const nir_search_expression search964 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search964_0.value, &search131_0_1.value },
   (is_used_once),
};

   /* replace964_0_0 -> search36_0_0 in the cache */

/* replace964_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace964_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace964_1 -> search36_0_1 in the cache */
static const nir_search_expression replace964 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &replace964_0.value, &search36_0_1.value },
   NULL,
};

   /* search965_0_0 -> search964_0_0 in the cache */

/* search965_0_1 -> search964_0_1 in the cache */
static const nir_search_expression search965_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search964_0_0.value, &search964_0_1.value },
   (is_used_once),
};

/* search965_1 -> search131_0_1 in the cache */
static const nir_search_expression search965 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search965_0.value, &search131_0_1.value },
   (is_used_once),
};

   /* replace965_0_0 -> search36_0_0 in the cache */

/* replace965_0_1 -> search36_1_1 in the cache */
/* replace965_0 -> replace176_0 in the cache */

/* replace965_1 -> search36_0_1 in the cache */
static const nir_search_expression replace965 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &replace176_0.value, &search36_0_1.value },
   NULL,
};

   /* search966_0_0 -> search964_0_0 in the cache */

static const nir_search_variable search966_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_fmul),
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search966_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search964_0_0.value, &search966_0_1.value },
   (is_used_once),
};

/* search966_1 -> search131_0_1 in the cache */
static const nir_search_expression search966 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search966_0.value, &search131_0_1.value },
   (is_used_once),
};

   /* replace966_0_0 -> search36_0_0 in the cache */

/* replace966_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace966_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace966_1 -> search36_0_1 in the cache */
static const nir_search_expression replace966 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace966_0.value, &search36_0_1.value },
   NULL,
};

   /* search967_0_0 -> search964_0_0 in the cache */

/* search967_0_1 -> search964_0_1 in the cache */
static const nir_search_expression search967_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search964_0_0.value, &search964_0_1.value },
   (is_used_once),
};

/* search967_1 -> search131_0_1 in the cache */
static const nir_search_expression search967 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search967_0.value, &search131_0_1.value },
   (is_used_once),
};

   /* replace967_0_0 -> search36_0_0 in the cache */

/* replace967_0_1 -> search36_1_1 in the cache */
/* replace967_0 -> replace966_0 in the cache */

/* replace967_1 -> search36_0_1 in the cache */
/* replace967 -> replace966 in the cache */

   /* search968_0_0 -> search964_0_0 in the cache */

/* search968_0_1 -> search964_0_1 in the cache */
static const nir_search_expression search968_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search964_0_0.value, &search964_0_1.value },
   (is_used_once),
};

/* search968_1 -> search131_0_1 in the cache */
static const nir_search_expression search968 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search968_0.value, &search131_0_1.value },
   (is_used_once),
};

   /* replace968_0_0 -> search36_0_0 in the cache */

/* replace968_0_1 -> search36_1_1 in the cache */
/* replace968_0 -> replace178_0_0 in the cache */

/* replace968_1 -> search36_0_1 in the cache */
static const nir_search_expression replace968 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace178_0_0.value, &search36_0_1.value },
   NULL,
};

   /* search969_0 -> search606_0 in the cache */

/* search969_1_0 -> search964_0_1 in the cache */

/* search969_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search969_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search969 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search606_0.value, &search969_1.value },
   NULL,
};

   /* replace969_0_0 -> search36_0_0 in the cache */

/* replace969_0_1 -> search36_1_1 in the cache */
/* replace969_0 -> replace964_0 in the cache */

/* replace969_1 -> search36_0_1 in the cache */
/* replace969 -> replace964 in the cache */

   /* search970_0 -> search606_0 in the cache */

/* search970_1_0 -> search964_0_1 in the cache */

/* search970_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search970_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search970 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search606_0.value, &search970_1.value },
   NULL,
};

   /* replace970_0_0 -> search36_0_0 in the cache */

/* replace970_0_1 -> search36_1_1 in the cache */
/* replace970_0 -> replace176_0 in the cache */

/* replace970_1 -> search36_0_1 in the cache */
/* replace970 -> replace965 in the cache */

   /* search971_0 -> search606_0 in the cache */

/* search971_1_0 -> search964_0_1 in the cache */

/* search971_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search971_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search971 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search606_0.value, &search971_1.value },
   NULL,
};

   /* replace971_0_0 -> search36_0_0 in the cache */

/* replace971_0_1 -> search36_1_1 in the cache */
/* replace971_0 -> replace966_0 in the cache */

/* replace971_1 -> search36_0_1 in the cache */
/* replace971 -> replace966 in the cache */

   /* search972_0 -> search606_0 in the cache */

/* search972_1_0_0 -> search964_0_1 in the cache */

/* search972_1_0_1 -> search131_0_1 in the cache */
/* search972_1_0 -> search971_1 in the cache */
static const nir_search_expression search972_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search971_1.value },
   NULL,
};
static const nir_search_expression search972 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search606_0.value, &search972_1.value },
   NULL,
};

   /* replace972_0_0 -> search36_0_0 in the cache */

/* replace972_0_1_0 -> search36_1_1 in the cache */
static const nir_search_expression replace972_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_1_1.value },
   NULL,
};
static const nir_search_expression replace972_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search36_0_0.value, &replace972_0_1.value },
   NULL,
};

/* replace972_1_0 -> search36_0_1 in the cache */
/* replace972_1 -> replace239_1_1 in the cache */
static const nir_search_expression replace972 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace972_0.value, &replace239_1_1.value },
   NULL,
};

   /* search973_0 -> search606_0 in the cache */

/* search973_1_0 -> search964_0_1 in the cache */

/* search973_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search973_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search973 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search606_0.value, &search973_1.value },
   NULL,
};

   /* replace973_0_0 -> search36_0_0 in the cache */

/* replace973_0_1 -> search36_1_1 in the cache */
/* replace973_0 -> replace178_0_0 in the cache */

/* replace973_1 -> search36_0_1 in the cache */
/* replace973 -> replace968 in the cache */

   /* search974_0 -> search606_0 in the cache */

/* search974_1_0 -> search964_0_1 in the cache */

/* search974_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search974_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search974 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search606_0.value, &search974_1.value },
   NULL,
};

   /* replace974_0_0 -> search36_0_0 in the cache */

/* replace974_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace974_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace974_1 -> search36_0_1 in the cache */
static const nir_search_expression replace974 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace974_0.value, &search36_0_1.value },
   NULL,
};

   /* search975_0 -> search606_0 in the cache */

/* search975_1_0 -> search964_0_1 in the cache */

/* search975_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search975_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search975 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search606_0.value, &search975_1.value },
   NULL,
};

   /* replace975_0_0 -> search36_0_0 in the cache */

/* replace975_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace975_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace975_1 -> search36_0_1 in the cache */
static const nir_search_expression replace975 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace975_0.value, &search36_0_1.value },
   NULL,
};

   /* search976_0 -> search606_0 in the cache */

/* search976_1_0 -> search964_0_1 in the cache */

/* search976_1_1 -> search131_0_1 in the cache */
static const nir_search_expression search976_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search964_0_1.value, &search131_0_1.value },
   NULL,
};
static const nir_search_expression search976 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ixor,
   { &search606_0.value, &search976_1.value },
   NULL,
};

   /* replace976_0_0 -> search36_0_0 in the cache */

/* replace976_0_1 -> search36_1_1 in the cache */
static const nir_search_expression replace976_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search36_0_0.value, &search36_1_1.value },
   NULL,
};

/* replace976_1 -> search36_0_1 in the cache */
static const nir_search_expression replace976 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_ixor,
   { &replace976_0.value, &search36_0_1.value },
   NULL,
};

   /* search977_0_0 -> search0_0 in the cache */

/* search977_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search977_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace0_1_0.value },
   (no_signed_wrap),
};

/* search977_1 -> replace0_1_0 in the cache */
static const nir_search_expression search977 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_idiv,
   { &search977_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace977 -> search0_0 in the cache */

   /* search978_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search978_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &search2_0.value },
   NULL,
};

/* search978_0_1 -> search34_1 in the cache */
static const nir_search_expression search978_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search978_0_0.value, &search34_1.value },
   NULL,
};

/* search978_1_0 -> search2_0 in the cache */
/* search978_1 -> search978_0_0 in the cache */

/* search978_2 -> search35_1 in the cache */
static const nir_search_expression search978 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search978_0.value, &search978_0_0.value, &search35_1.value },
   NULL,
};

   /* replace978_0 -> search2_0 in the cache */
/* replace978 -> search978_0_0 in the cache */

   /* search979_0_0_0 -> search3_0_0 in the cache */
static const nir_search_expression search979_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ifind_msb,
   { &search3_0_0.value },
   NULL,
};

/* search979_0_1 -> search34_1 in the cache */
static const nir_search_expression search979_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search979_0_0.value, &search34_1.value },
   NULL,
};

/* search979_1_0 -> search3_0_0 in the cache */
/* search979_1 -> search979_0_0 in the cache */

/* search979_2 -> search35_1 in the cache */
static const nir_search_expression search979 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search979_0.value, &search979_0_0.value, &search35_1.value },
   NULL,
};

   /* replace979_0 -> search3_0_0 in the cache */
/* replace979 -> search979_0_0 in the cache */

   /* search980_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search980_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ufind_msb,
   { &search2_0.value },
   NULL,
};

/* search980_0_1 -> search34_1 in the cache */
static const nir_search_expression search980_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search980_0_0.value, &search34_1.value },
   NULL,
};

/* search980_1_0 -> search2_0 in the cache */
/* search980_1 -> search980_0_0 in the cache */

/* search980_2 -> search35_1 in the cache */
static const nir_search_expression search980 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search980_0.value, &search980_0_0.value, &search35_1.value },
   NULL,
};

   /* replace980_0 -> search2_0 in the cache */
/* replace980 -> search980_0_0 in the cache */

   /* search981_0_0 -> search2_0 in the cache */

/* search981_0_1 -> replace9 in the cache */
/* search981_0 -> replace253 in the cache */

/* search981_1_0 -> search2_0 in the cache */
/* search981_1 -> search978_0_0 in the cache */

/* search981_2 -> search35_1 in the cache */
static const nir_search_expression search981 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace253.value, &search978_0_0.value, &search35_1.value },
   NULL,
};

   /* replace981_0 -> search2_0 in the cache */
/* replace981 -> search978_0_0 in the cache */

   /* search982_0_0 -> search3_0_0 in the cache */

/* search982_0_1 -> search34_1 in the cache */
static const nir_search_expression search982_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search3_0_0.value, &search34_1.value },
   NULL,
};

/* search982_1_0 -> search3_0_0 in the cache */
/* search982_1 -> search979_0_0 in the cache */

/* search982_2 -> search35_1 in the cache */
static const nir_search_expression search982 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search982_0.value, &search979_0_0.value, &search35_1.value },
   NULL,
};

   /* replace982_0 -> search3_0_0 in the cache */
/* replace982 -> search979_0_0 in the cache */

   /* search983_0_0 -> search2_0 in the cache */

/* search983_0_1 -> replace9 in the cache */
/* search983_0 -> replace253 in the cache */

/* search983_1_0 -> search2_0 in the cache */
/* search983_1 -> search980_0_0 in the cache */

/* search983_2 -> search35_1 in the cache */
static const nir_search_expression search983 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace253.value, &search980_0_0.value, &search35_1.value },
   NULL,
};

   /* replace983_0 -> search2_0 in the cache */
/* replace983 -> search980_0_0 in the cache */

   /* search984_0_0 -> search3_0_0 in the cache */

/* search984_0_1 -> search35_1 in the cache */
static const nir_search_expression search984_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search3_0_0.value, &search35_1.value },
   NULL,
};

/* search984_1_0 -> search3_0_0 in the cache */
/* search984_1 -> search979_0_0 in the cache */

/* search984_2 -> search35_1 in the cache */
static const nir_search_expression search984 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search984_0.value, &search979_0_0.value, &search35_1.value },
   NULL,
};

   /* replace984_0 -> search3_0_0 in the cache */
/* replace984 -> search979_0_0 in the cache */

   static const nir_search_variable search985_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

/* search985_0_1 -> search67_0 in the cache */

/* search985_0_2 -> search66_0 in the cache */
static const nir_search_expression search985_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search985_0_0.value, &search67_0.value, &search66_0.value },
   (is_used_once),
};

/* search985_1 -> replace0_1_0 in the cache */
static const nir_search_expression search985 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search985_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace985_0 -> search985_0_0 in the cache */

/* replace985_1_0 -> replace0_1_0 in the cache */
/* replace985_1 -> search194_1 in the cache */

/* replace985_2 -> replace0_1_0 in the cache */
static const nir_search_expression replace985 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search985_0_0.value, &search194_1.value, &replace0_1_0.value },
   NULL,
};

   /* search986_0_0 -> search985_0_0 in the cache */

/* search986_0_1 -> search66_0 in the cache */

/* search986_0_2 -> search67_0 in the cache */
static const nir_search_expression search986_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search985_0_0.value, &search66_0.value, &search67_0.value },
   (is_used_once),
};

/* search986_1 -> replace0_1_0 in the cache */
static const nir_search_expression search986 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search986_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace986_0 -> search985_0_0 in the cache */

/* replace986_1 -> replace0_1_0 in the cache */

/* replace986_2_0 -> replace0_1_0 in the cache */
/* replace986_2 -> search194_1 in the cache */
static const nir_search_expression replace986 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search985_0_0.value, &replace0_1_0.value, &search194_1.value },
   NULL,
};

   /* search987_0_0 -> search2_0 in the cache */

/* search987_0_1 -> search30_1 in the cache */
/* search987_0 -> replace105_0 in the cache */

/* search987_1_0 -> search2_0 in the cache */
/* search987_1 -> search22_0 in the cache */

/* search987_2 -> search2_0 in the cache */
static const nir_search_expression search987 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace105_0.value, &search22_0.value, &search2_0.value },
   NULL,
};

   /* replace987_0 -> search2_0 in the cache */
/* replace987 -> replace24 in the cache */

   /* search988_0 -> replace116_0 in the cache */

/* search988_1_0 -> search212_0_1_0 in the cache */

/* search988_1_1 -> search103_1_1 in the cache */

/* search988_1_2 -> search103_2 in the cache */
/* search988_1 -> search287_1 in the cache */

/* search988_2 -> search103_2 in the cache */
static const nir_search_expression search988 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search287_1.value, &search103_2.value },
   NULL,
};

   /* replace988_0_0 -> replace116_0 in the cache */

/* replace988_0_1 -> search212_0_1_0 in the cache */
/* replace988_0 -> replace215 in the cache */

/* replace988_1 -> search103_1_1 in the cache */

/* replace988_2 -> search103_2 in the cache */
static const nir_search_expression replace988 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace215.value, &search103_1_1.value, &search103_2.value },
   NULL,
};

   /* search989_0 -> replace116_0 in the cache */

/* search989_1 -> search103_0_1 in the cache */

/* search989_2_0 -> search73_2_0 in the cache */

/* search989_2_1 -> search103_0_1 in the cache */

/* search989_2_2 -> search103_2 in the cache */
static const nir_search_expression search989_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search73_2_0.value, &search103_0_1.value, &search103_2.value },
   NULL,
};
static const nir_search_expression search989 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace116_0.value, &search103_0_1.value, &search989_2.value },
   NULL,
};

   /* replace989_0_0 -> replace116_0 in the cache */

/* replace989_0_1 -> search73_2_0 in the cache */
static const nir_search_expression replace989_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace116_0.value, &search73_2_0.value },
   NULL,
};

/* replace989_1 -> search103_0_1 in the cache */

/* replace989_2 -> search103_2 in the cache */
static const nir_search_expression replace989 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace989_0.value, &search103_0_1.value, &search103_2.value },
   NULL,
};

   /* search990_0 -> search0_0 in the cache */

/* search990_1 -> replace0_1_0 in the cache */
static const nir_search_expression search990 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmod,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace990_0 -> search0_0 in the cache */

/* replace990_1_0 -> replace0_1_0 in the cache */

/* replace990_1_1_0_0 -> search0_0 in the cache */

/* replace990_1_1_0_1 -> replace0_1_0 in the cache */
/* replace990_1_1_0 -> search744 in the cache */
static const nir_search_expression replace990_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search744.value },
   NULL,
};
static const nir_search_expression replace990_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace990_1_1.value },
   NULL,
};
static const nir_search_expression replace990 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search0_0.value, &replace990_1.value },
   NULL,
};

   /* search991_0 -> search0_0 in the cache */

/* search991_1 -> replace0_1_0 in the cache */
static const nir_search_expression search991 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frem,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace991_0 -> search0_0 in the cache */

/* replace991_1_0 -> replace0_1_0 in the cache */

/* replace991_1_1_0_0 -> search0_0 in the cache */

/* replace991_1_1_0_1 -> replace0_1_0 in the cache */
/* replace991_1_1_0 -> search744 in the cache */
static const nir_search_expression replace991_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search744.value },
   NULL,
};
static const nir_search_expression replace991_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace991_1_1.value },
   NULL,
};
static const nir_search_expression replace991 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search0_0.value, &replace991_1.value },
   NULL,
};

   /* search992_0 -> search0_0 in the cache */

/* search992_1 -> replace0_1_0 in the cache */
static const nir_search_expression search992 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uadd_carry,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace992_0_0_0 -> search0_0 in the cache */

/* replace992_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace992_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace992_0_1 -> search0_0 in the cache */
static const nir_search_expression replace992_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace992_0_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression replace992 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace992_0.value },
   NULL,
};

   /* search993_0 -> search3_0_0 in the cache */

/* search993_1 -> replace2_1_1 in the cache */
static const nir_search_expression search993 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_usub_borrow,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};

   /* replace993_0_0 -> search3_0_0 in the cache */

/* replace993_0_1 -> replace2_1_1 in the cache */
static const nir_search_expression replace993_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search3_0_0.value, &replace2_1_1.value },
   NULL,
};
static const nir_search_expression replace993 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace993_0.value },
   NULL,
};

   static const nir_search_variable search994_0 = {
   { nir_search_value_variable, 32 },
   0, /* base */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search994_1 = {
   { nir_search_value_variable, 32 },
   1, /* insert */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search994_2 = {
   { nir_search_value_variable, 32 },
   2, /* offset */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};

static const nir_search_variable search994_3 = {
   { nir_search_value_variable, 32 },
   3, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
};
static const nir_search_expression search994 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bitfield_insert,
   { &search994_0.value, &search994_1.value, &search994_2.value, &search994_3.value },
   NULL,
};

   /* replace994_0_0 -> replace141_1_1 in the cache */

/* replace994_0_1 -> search994_3 in the cache */
static const nir_search_expression replace994_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace141_1_1.value, &search994_3.value },
   NULL,
};

/* replace994_1 -> search994_1 in the cache */

/* replace994_2_0_0 -> search994_3 in the cache */

/* replace994_2_0_1 -> search994_2 in the cache */
static const nir_search_expression replace994_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfm,
   { &search994_3.value, &search994_2.value },
   NULL,
};

/* replace994_2_1 -> search994_1 in the cache */

/* replace994_2_2 -> search994_0 in the cache */
static const nir_search_expression replace994_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfi,
   { &replace994_2_0.value, &search994_1.value, &search994_0.value },
   NULL,
};
static const nir_search_expression replace994 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace994_0.value, &search994_1.value, &replace994_2.value },
   NULL,
};

   /* search995_0 -> search0_0 in the cache */

/* search995_1 -> replace0_1_0 in the cache */
static const nir_search_expression search995 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ihadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace995_0_0 -> search0_0 in the cache */

/* replace995_0_1 -> replace0_1_0 in the cache */
/* replace995_0 -> search695_0 in the cache */

/* replace995_1_0_0 -> search0_0 in the cache */

/* replace995_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace995_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   2, 1,
   nir_op_ixor,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace995_1_1 -> search163_1 in the cache */
static const nir_search_expression replace995_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace995_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace995 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search695_0.value, &replace995_1.value },
   NULL,
};

   /* search996_0 -> search0_0 in the cache */

/* search996_1 -> replace0_1_0 in the cache */
static const nir_search_expression search996 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uhadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace996_0_0 -> search0_0 in the cache */

/* replace996_0_1 -> replace0_1_0 in the cache */
/* replace996_0 -> search695_0 in the cache */

/* replace996_1_0_0 -> search0_0 in the cache */

/* replace996_1_0_1 -> replace0_1_0 in the cache */
/* replace996_1_0 -> replace995_1_0 in the cache */

/* replace996_1_1 -> search163_1 in the cache */
static const nir_search_expression replace996_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace995_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace996 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search695_0.value, &replace996_1.value },
   NULL,
};

   /* search997_0 -> search0_0 in the cache */

/* search997_1 -> replace0_1_0 in the cache */
static const nir_search_expression search997 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_irhadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace997_0_0 -> search0_0 in the cache */

/* replace997_0_1 -> replace0_1_0 in the cache */
/* replace997_0 -> search603_0 in the cache */

/* replace997_1_0_0 -> search0_0 in the cache */

/* replace997_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace997_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace997_1_1 -> search163_1 in the cache */
static const nir_search_expression replace997_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace997_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace997 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search603_0.value, &replace997_1.value },
   NULL,
};

   /* search998_0 -> search0_0 in the cache */

/* search998_1 -> replace0_1_0 in the cache */
static const nir_search_expression search998 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_urhadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace998_0_0 -> search0_0 in the cache */

/* replace998_0_1 -> replace0_1_0 in the cache */
/* replace998_0 -> search603_0 in the cache */

/* replace998_1_0_0 -> search0_0 in the cache */

/* replace998_1_0_1 -> replace0_1_0 in the cache */
/* replace998_1_0 -> replace997_1_0 in the cache */

/* replace998_1_1 -> search163_1 in the cache */
static const nir_search_expression replace998_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace997_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace998 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search603_0.value, &replace998_1.value },
   NULL,
};

   /* search999_0 -> search93_0 in the cache */

/* search999_1 -> search93_1 in the cache */
static const nir_search_expression search999 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ihadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace999_0_0 -> search93_0 in the cache */

/* replace999_0_1 -> search93_1 in the cache */
static const nir_search_expression replace999_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace999_1_0_0 -> search93_0 in the cache */

/* replace999_1_0_1 -> search93_1 in the cache */
static const nir_search_expression replace999_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_ixor,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace999_1_1 -> search163_1 in the cache */
static const nir_search_expression replace999_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace999_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace999 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace999_0.value, &replace999_1.value },
   NULL,
};

   /* search1000_0 -> search93_0 in the cache */

/* search1000_1 -> search93_1 in the cache */
static const nir_search_expression search1000 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_uhadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1000_0_0 -> search93_0 in the cache */

/* replace1000_0_1 -> search93_1 in the cache */
/* replace1000_0 -> replace999_0 in the cache */

/* replace1000_1_0_0 -> search93_0 in the cache */

/* replace1000_1_0_1 -> search93_1 in the cache */
/* replace1000_1_0 -> replace999_1_0 in the cache */

/* replace1000_1_1 -> search163_1 in the cache */
static const nir_search_expression replace1000_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace999_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace1000 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace999_0.value, &replace1000_1.value },
   NULL,
};

   /* search1001_0 -> search93_0 in the cache */

/* search1001_1 -> search93_1 in the cache */
static const nir_search_expression search1001 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_irhadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1001_0_0 -> search93_0 in the cache */

/* replace1001_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1001_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1001_1_0_0 -> search93_0 in the cache */

/* replace1001_1_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1001_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1001_1_1 -> search163_1 in the cache */
static const nir_search_expression replace1001_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace1001_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace1001 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &replace1001_0.value, &replace1001_1.value },
   NULL,
};

   /* search1002_0 -> search93_0 in the cache */

/* search1002_1 -> search93_1 in the cache */
static const nir_search_expression search1002 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_urhadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1002_0_0 -> search93_0 in the cache */

/* replace1002_0_1 -> search93_1 in the cache */
/* replace1002_0 -> replace1001_0 in the cache */

/* replace1002_1_0_0 -> search93_0 in the cache */

/* replace1002_1_0_1 -> search93_1 in the cache */
/* replace1002_1_0 -> replace1001_1_0 in the cache */

/* replace1002_1_1 -> search163_1 in the cache */
static const nir_search_expression replace1002_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace1001_1_0.value, &search163_1.value },
   NULL,
};
static const nir_search_expression replace1002 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &replace1001_0.value, &replace1002_1.value },
   NULL,
};

   /* search1003_0 -> search93_0 in the cache */

/* search1003_1 -> search93_1 in the cache */
static const nir_search_expression search1003 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_uadd_sat,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1003_0_0_0 -> search93_0 in the cache */

/* replace1003_0_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1003_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1003_0_1 -> search93_0 in the cache */
static const nir_search_expression replace1003_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace1003_0_0.value, &search93_0.value },
   NULL,
};

/* replace1003_1 -> search365_1 in the cache */

/* replace1003_2_0 -> search93_0 in the cache */

/* replace1003_2_1 -> search93_1 in the cache */
static const nir_search_expression replace1003_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};
static const nir_search_expression replace1003 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace1003_0.value, &search365_1.value, &replace1003_2.value },
   NULL,
};

   /* search1004_0 -> search0_0 in the cache */

/* search1004_1 -> replace0_1_0 in the cache */
static const nir_search_expression search1004 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uadd_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace1004_0_0_0 -> search0_0 in the cache */

/* replace1004_0_0_1 -> replace0_1_0 in the cache */
/* replace1004_0_0 -> replace992_0_0 in the cache */

/* replace1004_0_1 -> search0_0 in the cache */
/* replace1004_0 -> replace992_0 in the cache */

static const nir_search_constant replace1004_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* replace1004_2_0 -> search0_0 in the cache */

/* replace1004_2_1 -> replace0_1_0 in the cache */
/* replace1004_2 -> search42_1 in the cache */
static const nir_search_expression replace1004 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace992_0.value, &replace1004_1.value, &search42_1.value },
   NULL,
};

   /* search1005_0 -> search0_0 in the cache */

/* search1005_1 -> replace0_1_0 in the cache */
static const nir_search_expression search1005 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_usub_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace1005_0_0 -> search0_0 in the cache */

/* replace1005_0_1 -> replace0_1_0 in the cache */
/* replace1005_0 -> replace186 in the cache */

/* replace1005_1 -> replace19_1 in the cache */

/* replace1005_2_0 -> search0_0 in the cache */

/* replace1005_2_1 -> replace0_1_0 in the cache */
/* replace1005_2 -> search959 in the cache */
static const nir_search_expression replace1005 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace186.value, &replace19_1.value, &search959.value },
   NULL,
};

   /* search1006_0 -> search93_0 in the cache */

/* search1006_1 -> search93_1 in the cache */
static const nir_search_expression search1006 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_usub_sat,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1006_0_0 -> search93_0 in the cache */

/* replace1006_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1006_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1006_1 -> replace142_2 in the cache */

/* replace1006_2_0 -> search93_0 in the cache */

/* replace1006_2_1 -> search93_1 in the cache */
static const nir_search_expression replace1006_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search93_0.value, &search93_1.value },
   NULL,
};
static const nir_search_expression replace1006 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace1006_0.value, &replace142_2.value, &replace1006_2.value },
   NULL,
};

   /* search1007_0 -> search93_0 in the cache */

/* search1007_1 -> search93_1 in the cache */
static const nir_search_expression search1007 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1007_0_0_0_0 -> search93_0 in the cache */

/* replace1007_0_0_0_1 -> replace142_2 in the cache */
/* replace1007_0_0_0 -> replace357 in the cache */

/* replace1007_0_0_1_0 -> search93_1 in the cache */

/* replace1007_0_0_1_1 -> replace142_2 in the cache */
static const nir_search_expression replace1007_0_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search93_1.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression replace1007_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace357.value, &replace1007_0_0_1.value },
   NULL,
};

/* replace1007_0_1_0_0 -> search93_0 in the cache */

/* replace1007_0_1_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1007_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1007_0_1_1 -> replace142_2 in the cache */
static const nir_search_expression replace1007_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace1007_0_1_0.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression replace1007_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace1007_0_0.value, &replace1007_0_1.value },
   NULL,
};

/* replace1007_1 -> search355_0_1 in the cache */

/* replace1007_2_0_0_0_0 -> search93_0 in the cache */

/* replace1007_2_0_0_0_1 -> replace142_2 in the cache */
/* replace1007_2_0_0_0 -> replace357 in the cache */

/* replace1007_2_0_0_1_0 -> search93_1 in the cache */

/* replace1007_2_0_0_1_1 -> replace142_2 in the cache */
/* replace1007_2_0_0_1 -> replace1007_0_0_1 in the cache */
static const nir_search_expression replace1007_2_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   4, 1,
   nir_op_ior,
   { &replace357.value, &replace1007_0_0_1.value },
   NULL,
};

/* replace1007_2_0_1_0_0 -> search93_0 in the cache */

/* replace1007_2_0_1_0_1 -> search93_1 in the cache */
static const nir_search_expression replace1007_2_0_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   5, 1,
   nir_op_iadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

/* replace1007_2_0_1_1 -> replace142_2 in the cache */
static const nir_search_expression replace1007_2_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace1007_2_0_1_0.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression replace1007_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 3,
   nir_op_ior,
   { &replace1007_2_0_0.value, &replace1007_2_0_1.value },
   NULL,
};

/* replace1007_2_1_0 -> search93_0 in the cache */

/* replace1007_2_1_1 -> search93_1 in the cache */
static const nir_search_expression replace1007_2_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   6, 1,
   nir_op_iadd,
   { &search93_0.value, &search93_1.value },
   NULL,
};

static const nir_search_constant replace1007_2_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fffffffffffffff /* 9223372036854775807 */ },
};
static const nir_search_expression replace1007_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace1007_2_0.value, &replace1007_2_1.value, &replace1007_2_2.value },
   NULL,
};
static const nir_search_expression replace1007 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 7,
   nir_op_bcsel,
   { &replace1007_0.value, &search355_0_1.value, &replace1007_2.value },
   NULL,
};

   /* search1008_0 -> search93_0 in the cache */

/* search1008_1 -> search93_1 in the cache */
static const nir_search_expression search1008 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search93_0.value, &search93_1.value },
   NULL,
};

   /* replace1008_0_0_0_0 -> search93_0 in the cache */

/* replace1008_0_0_0_1 -> replace142_2 in the cache */
/* replace1008_0_0_0 -> replace357 in the cache */

/* replace1008_0_0_1_0 -> search93_1 in the cache */

/* replace1008_0_0_1_1 -> replace142_2 in the cache */
static const nir_search_expression replace1008_0_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search93_1.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression replace1008_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace357.value, &replace1008_0_0_1.value },
   NULL,
};

/* replace1008_0_1_0_0 -> search93_0 in the cache */

/* replace1008_0_1_0_1 -> search93_1 in the cache */
/* replace1008_0_1_0 -> replace1006_2 in the cache */

/* replace1008_0_1_1 -> replace142_2 in the cache */
static const nir_search_expression replace1008_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace1006_2.value, &replace142_2.value },
   NULL,
};
static const nir_search_expression replace1008_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1008_0_0.value, &replace1008_0_1.value },
   NULL,
};

/* replace1008_1 -> search355_0_1 in the cache */

/* replace1008_2_0_0_0_0 -> search93_0 in the cache */

/* replace1008_2_0_0_0_1 -> replace142_2 in the cache */
/* replace1008_2_0_0_0 -> replace357 in the cache */

/* replace1008_2_0_0_1_0 -> search93_1 in the cache */

/* replace1008_2_0_0_1_1 -> replace142_2 in the cache */
/* replace1008_2_0_0_1 -> replace1008_0_0_1 in the cache */
static const nir_search_expression replace1008_2_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   3, 1,
   nir_op_ior,
   { &replace357.value, &replace1008_0_0_1.value },
   NULL,
};

/* replace1008_2_0_1_0_0 -> search93_0 in the cache */

/* replace1008_2_0_1_0_1 -> search93_1 in the cache */
/* replace1008_2_0_1_0 -> replace1006_2 in the cache */

/* replace1008_2_0_1_1 -> replace142_2 in the cache */
/* replace1008_2_0_1 -> replace1008_0_1 in the cache */
static const nir_search_expression replace1008_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 2,
   nir_op_ior,
   { &replace1008_2_0_0.value, &replace1008_0_1.value },
   NULL,
};

/* replace1008_2_1_0 -> search93_0 in the cache */

/* replace1008_2_1_1 -> search93_1 in the cache */
/* replace1008_2_1 -> replace1006_2 in the cache */

/* replace1008_2_2 -> replace1007_2_2 in the cache */
static const nir_search_expression replace1008_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace1008_2_0.value, &replace1006_2.value, &replace1007_2_2.value },
   NULL,
};
static const nir_search_expression replace1008 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace1008_0.value, &search355_0_1.value, &replace1008_2.value },
   NULL,
};

   /* search1009_0_0 -> search93_0 in the cache */

/* search1009_0_1 -> search93_1 in the cache */
static const nir_search_expression search1009_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search93_0.value, &search93_1.value },
   (is_used_once),
};

/* search1009_1 -> replace142_2 in the cache */
static const nir_search_expression search1009 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search1009_0.value, &replace142_2.value },
   NULL,
};

   /* replace1009_0_0_0 -> search93_0 in the cache */
/* replace1009_0_0 -> search852_1 in the cache */

/* replace1009_0_1_0 -> search93_1 in the cache */
static const nir_search_expression replace1009_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search93_1.value },
   NULL,
};
static const nir_search_expression replace1009_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search852_1.value, &replace1009_0_1.value },
   NULL,
};

/* replace1009_1 -> search34_1 in the cache */
static const nir_search_expression replace1009 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace1009_0.value, &search34_1.value },
   NULL,
};

   /* search1010_0_0 -> search93_0 in the cache */

/* search1010_0_1 -> search93_1 in the cache */
static const nir_search_expression search1010_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search93_0.value, &search93_1.value },
   (is_used_once),
};

/* search1010_1 -> replace142_2 in the cache */
static const nir_search_expression search1010 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search1010_0.value, &replace142_2.value },
   NULL,
};

   /* replace1010_0_0_0 -> search93_0 in the cache */
/* replace1010_0_0 -> search852_1 in the cache */

/* replace1010_0_1_0 -> search93_1 in the cache */
/* replace1010_0_1 -> replace1009_0_1 in the cache */
static const nir_search_expression replace1010_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search852_1.value, &replace1009_0_1.value },
   NULL,
};

/* replace1010_1 -> search34_1 in the cache */
static const nir_search_expression replace1010 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace1010_0.value, &search34_1.value },
   NULL,
};

   /* search1011_0_0 -> search93_0 in the cache */

/* search1011_0_1 -> search93_1 in the cache */
/* search1011_0 -> search1009_0 in the cache */

/* search1011_1 -> replace142_2 in the cache */
static const nir_search_expression search1011 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search1009_0.value, &replace142_2.value },
   NULL,
};

   /* replace1011_0_0_0 -> search93_0 in the cache */
/* replace1011_0_0 -> search852_1 in the cache */

/* replace1011_0_1_0 -> search93_1 in the cache */
/* replace1011_0_1 -> replace1009_0_1 in the cache */
/* replace1011_0 -> replace1009_0 in the cache */

/* replace1011_1 -> search34_1 in the cache */
static const nir_search_expression replace1011 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace1009_0.value, &search34_1.value },
   NULL,
};

   /* search1012_0_0 -> search93_0 in the cache */

/* search1012_0_1 -> search93_1 in the cache */
/* search1012_0 -> search1010_0 in the cache */

/* search1012_1 -> replace142_2 in the cache */
static const nir_search_expression search1012 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search1010_0.value, &replace142_2.value },
   NULL,
};

   /* replace1012_0_0_0 -> search93_0 in the cache */
/* replace1012_0_0 -> search852_1 in the cache */

/* replace1012_0_1_0 -> search93_1 in the cache */
/* replace1012_0_1 -> replace1009_0_1 in the cache */
/* replace1012_0 -> replace1010_0 in the cache */

/* replace1012_1 -> search34_1 in the cache */
static const nir_search_expression replace1012 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace1010_0.value, &search34_1.value },
   NULL,
};

   /* search1013_0 -> search93_0 in the cache */

/* search1013_1 -> replace142_2 in the cache */
/* search1013 -> replace357 in the cache */

   /* replace1013_0_0 -> search93_0 in the cache */
/* replace1013_0 -> search852_1 in the cache */

/* replace1013_1 -> search34_1 in the cache */
static const nir_search_expression replace1013 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search852_1.value, &search34_1.value },
   NULL,
};

   /* search1014_0 -> search93_0 in the cache */

/* search1014_1 -> replace142_2 in the cache */
/* search1014 -> replace355 in the cache */

   /* replace1014_0_0 -> search93_0 in the cache */
/* replace1014_0 -> search852_1 in the cache */

/* replace1014_1 -> search34_1 in the cache */
static const nir_search_expression replace1014 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search852_1.value, &search34_1.value },
   NULL,
};

   /* search1015_0 -> search93_0 in the cache */

/* search1015_1 -> replace142_2 in the cache */
static const nir_search_expression search1015 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* replace1015_0_0_0 -> search93_0 in the cache */
/* replace1015_0_0 -> search852_0 in the cache */

/* replace1015_0_1_0 -> search93_0 in the cache */
/* replace1015_0_1 -> search852_1 in the cache */
static const nir_search_expression replace1015_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search852_0.value, &search852_1.value },
   NULL,
};

/* replace1015_1 -> search34_1 in the cache */
static const nir_search_expression replace1015 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &replace1015_0.value, &search34_1.value },
   NULL,
};

   /* search1016_0 -> search93_0 in the cache */

/* search1016_1 -> replace142_2 in the cache */
static const nir_search_expression search1016 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search93_0.value, &replace142_2.value },
   NULL,
};

   /* replace1016_0_0_0 -> search93_0 in the cache */
/* replace1016_0_0 -> search852_0 in the cache */

/* replace1016_0_1_0 -> search93_0 in the cache */
/* replace1016_0_1 -> search852_1 in the cache */
/* replace1016_0 -> replace1015_0 in the cache */

/* replace1016_1 -> search34_1 in the cache */
static const nir_search_expression replace1016 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace1015_0.value, &search34_1.value },
   NULL,
};

   /* search1017_0 -> replace142_2 in the cache */

/* search1017_1 -> search93_0 in the cache */
static const nir_search_expression search1017 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace142_2.value, &search93_0.value },
   NULL,
};

   /* replace1017_0_0_0 -> search93_0 in the cache */
/* replace1017_0_0 -> search852_0 in the cache */

/* replace1017_0_1_0 -> search93_0 in the cache */
/* replace1017_0_1 -> search852_1 in the cache */
/* replace1017_0 -> replace1015_0 in the cache */

/* replace1017_1 -> search34_1 in the cache */
/* replace1017 -> replace1015 in the cache */

   /* search1018_0 -> search994_0 in the cache */

/* search1018_1 -> search994_1 in the cache */

/* search1018_2 -> search994_2 in the cache */

/* search1018_3 -> search994_3 in the cache */
/* search1018 -> search994 in the cache */

   /* replace1018_0_0 -> replace141_1_1 in the cache */

/* replace1018_0_1 -> search994_3 in the cache */
/* replace1018_0 -> replace994_0 in the cache */

/* replace1018_1 -> search994_1 in the cache */

/* replace1018_2_0_0 -> search994_0 in the cache */

/* replace1018_2_0_1_0_0_0_0 -> search163_1 in the cache */

/* replace1018_2_0_1_0_0_0_1 -> search994_3 in the cache */
static const nir_search_expression replace1018_2_0_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search163_1.value, &search994_3.value },
   NULL,
};

/* replace1018_2_0_1_0_0_1 -> search163_1 in the cache */
static const nir_search_expression replace1018_2_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace1018_2_0_1_0_0_0.value, &search163_1.value },
   NULL,
};

/* replace1018_2_0_1_0_1 -> search994_2 in the cache */
static const nir_search_expression replace1018_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace1018_2_0_1_0_0.value, &search994_2.value },
   NULL,
};
static const nir_search_expression replace1018_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace1018_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace1018_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search994_0.value, &replace1018_2_0_1.value },
   NULL,
};

/* replace1018_2_1_0_0 -> search994_1 in the cache */

/* replace1018_2_1_0_1 -> search994_2 in the cache */
static const nir_search_expression replace1018_2_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search994_1.value, &search994_2.value },
   NULL,
};

/* replace1018_2_1_1_0_0_0 -> search163_1 in the cache */

/* replace1018_2_1_1_0_0_1 -> search994_3 in the cache */
/* replace1018_2_1_1_0_0 -> replace1018_2_0_1_0_0_0 in the cache */

/* replace1018_2_1_1_0_1 -> search163_1 in the cache */
/* replace1018_2_1_1_0 -> replace1018_2_0_1_0_0 in the cache */

/* replace1018_2_1_1_1 -> search994_2 in the cache */
/* replace1018_2_1_1 -> repl