.\" Automatically generated by Pod::Man 4.14 (Pod::Simple 3.43)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  \*(C+ will
.\" give a nicer C++.  Capital omega is used to do unbreakable dashes and
.\" therefore won't be available.  \*(C` and \*(C' expand to `' in nroff,
.\" nothing in troff, for use with C<>.
.tr \(*W-
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "Thread 3"
.TH Thread 3 "2022-05-26" "perl v5.36.0" "Perl Programmers Reference Guide"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH "NAME"
Thread \- Manipulate threads in Perl (for old code only)
.SH "DEPRECATED"
.IX Header "DEPRECATED"
The \f(CW\*(C`Thread\*(C'\fR module served as the frontend to the old-style thread model,
called \fI5005threads\fR, that was introduced in release 5.005.  That model was
deprecated, and has been removed in version 5.10.
.PP
For old code and interim backwards compatibility, the \f(CW\*(C`Thread\*(C'\fR module has
been reworked to function as a frontend for the new interpreter threads
(\fIithreads\fR) model.  However, some previous functionality is not available.
Further, the data sharing models between the two thread models are completely
different, and anything to do with data sharing has to be thought differently.
With \fIithreads\fR, you must explicitly \f(CW\*(C`share()\*(C'\fR variables between the
threads.
.PP
You are strongly encouraged to migrate any existing threaded code to the new
model (i.e., use the \f(CW\*(C`threads\*(C'\fR and \f(CW\*(C`threads::shared\*(C'\fR modules) as soon as
possible.
.SH "HISTORY"
.IX Header "HISTORY"
In Perl 5.005, the thread model was that all data is implicitly shared, and
shared access to data has to be explicitly synchronized.  This model is called
\&\fI5005threads\fR.
.PP
In Perl 5.6, a new model was introduced in which all is was thread local and
shared access to data has to be explicitly declared.  This model is called
\&\fIithreads\fR, for \*(L"interpreter threads\*(R".
.PP
In Perl 5.6, the \fIithreads\fR model was not available as a public \s-1API\s0; only as
an internal \s-1API\s0 that was available for extension writers, and to implement
\&\fBfork()\fR emulation on Win32 platforms.
.PP
In Perl 5.8, the \fIithreads\fR model became available through the \f(CW\*(C`threads\*(C'\fR
module, and the \fI5005threads\fR model was deprecated.
.PP
In Perl 5.10, the \fI5005threads\fR model was removed from the Perl interpreter.
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.Vb 1
\&    use Thread qw(:DEFAULT async yield);
\&
\&    my $t = Thread\->new(\e&start_sub, @start_args);
\&
\&    $result = $t\->join;
\&    $t\->detach;
\&
\&    if ($t\->done) {
\&        $t\->join;
\&    }
\&
\&    if($t\->equal($another_thread)) {
\&        # ...
\&    }
\&
\&    yield();
\&
\&    my $tid = Thread\->self\->tid;
\&
\&    lock($scalar);
\&    lock(@array);
\&    lock(%hash);
\&
\&    my @list = Thread\->list;
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The \f(CW\*(C`Thread\*(C'\fR module provides multithreading support for Perl.
.SH "FUNCTIONS"
.IX Header "FUNCTIONS"
.ie n .IP "$thread = Thread\->new(\e&start_sub)" 8
.el .IP "\f(CW$thread\fR = Thread\->new(\e&start_sub)" 8
.IX Item "$thread = Thread->new(&start_sub)"
.PD 0
.ie n .IP "$thread = Thread\->new(\e&start_sub, \s-1LIST\s0)" 8
.el .IP "\f(CW$thread\fR = Thread\->new(\e&start_sub, \s-1LIST\s0)" 8
.IX Item "$thread = Thread->new(&start_sub, LIST)"
.PD
\&\f(CW\*(C`new\*(C'\fR starts a new thread of execution in the referenced subroutine. The
optional list is passed as parameters to the subroutine. Execution
continues in both the subroutine and the code after the \f(CW\*(C`new\*(C'\fR call.
.Sp
\&\f(CW\*(C`Thread\->new\*(C'\fR returns a thread object representing the newly created
thread.
.IP "lock \s-1VARIABLE\s0" 8
.IX Item "lock VARIABLE"
\&\f(CW\*(C`lock\*(C'\fR places a lock on a variable until the lock goes out of scope.
.Sp
If the variable is locked by another thread, the \f(CW\*(C`lock\*(C'\fR call will
block until it's available.  \f(CW\*(C`lock\*(C'\fR is recursive, so multiple calls
to \f(CW\*(C`lock\*(C'\fR are safe\*(--the variable will remain locked until the
outermost lock on the variable goes out of scope.
.Sp
Locks on variables only affect \f(CW\*(C`lock\*(C'\fR calls\*(--they do \fInot\fR affect normal
access to a variable. (Locks on subs are different, and covered in a bit.)
If you really, \fIreally\fR want locks to block access, then go ahead and tie
them to something and manage this yourself.  This is done on purpose.
While managing access to variables is a good thing, Perl doesn't force
you out of its living room...
.Sp
If a container object, such as a hash or array, is locked, all the
elements of that container are not locked. For example, if a thread
does a \f(CW\*(C`lock @a\*(C'\fR, any other thread doing a \f(CW\*(C`lock($a[12])\*(C'\fR won't
block.
.Sp
Finally, \f(CW\*(C`lock\*(C'\fR will traverse up references exactly \fIone\fR level.
\&\f(CW\*(C`lock(\e$a)\*(C'\fR is equivalent to \f(CW\*(C`lock($a)\*(C'\fR, while \f(CW\*(C`lock(\e\e$a)\*(C'\fR is not.
.IP "async \s-1BLOCK\s0;" 8
.IX Item "async BLOCK;"
\&\f(CW\*(C`async\*(C'\fR creates a thread to execute the block immediately following
it.  This block is treated as an anonymous sub, and so must have a
semi-colon after the closing brace. Like \f(CW\*(C`Thread\->new\*(C'\fR, \f(CW\*(C`async\*(C'\fR
returns a thread object.
.IP "Thread\->self" 8
.IX Item "Thread->self"
The \f(CW\*(C`Thread\->self\*(C'\fR function returns a thread object that represents
the thread making the \f(CW\*(C`Thread\->self\*(C'\fR call.
.IP "Thread\->list" 8
.IX Item "Thread->list"
Returns a list of all non-joined, non-detached Thread objects.
.IP "cond_wait \s-1VARIABLE\s0" 8
.IX Item "cond_wait VARIABLE"
The \f(CW\*(C`cond_wait\*(C'\fR function takes a \fBlocked\fR variable as
a parameter, unlocks the variable, and blocks until another thread
does a \f(CW\*(C`cond_signal\*(C'\fR or \f(CW\*(C`cond_broadcast\*(C'\fR for that same locked
variable. The variable that \f(CW\*(C`cond_wait\*(C'\fR blocked on is relocked
after the \f(CW\*(C`cond_wait\*(C'\fR is satisfied.  If there are multiple threads
\&\f(CW\*(C`cond_wait\*(C'\fRing on the same variable, all but one will reblock waiting
to re-acquire the lock on the variable.  (So if you're only using
\&\f(CW\*(C`cond_wait\*(C'\fR for synchronization, give up the lock as soon as
possible.)
.IP "cond_signal \s-1VARIABLE\s0" 8
.IX Item "cond_signal VARIABLE"
The \f(CW\*(C`cond_signal\*(C'\fR function takes a locked variable as a parameter and
unblocks one thread that's \f(CW\*(C`cond_wait\*(C'\fRing on that variable. If more than
one thread is blocked in a \f(CW\*(C`cond_wait\*(C'\fR on that variable, only one (and
which one is indeterminate) will be unblocked.
.Sp
If there are no threads blocked in a \f(CW\*(C`cond_wait\*(C'\fR on the variable,
the signal is discarded.
.IP "cond_broadcast \s-1VARIABLE\s0" 8
.IX Item "cond_broadcast VARIABLE"
The \f(CW\*(C`cond_broadcast\*(C'\fR function works similarly to \f(CW\*(C`cond_signal\*(C'\fR.
\&\f(CW\*(C`cond_broadcast\*(C'\fR, though, will unblock \fBall\fR the threads that are
blocked in a \f(CW\*(C`cond_wait\*(C'\fR on the locked variable, rather than only
one.
.IP "yield" 8
.IX Item "yield"
The \f(CW\*(C`yield\*(C'\fR function allows another thread to take control of the
\&\s-1CPU.\s0 The exact results are implementation-dependent.
.SH "METHODS"
.IX Header "METHODS"
.IP "join" 8
.IX Item "join"
\&\f(CW\*(C`join\*(C'\fR waits for a thread to end and returns any values the thread
exited with.  \f(CW\*(C`join\*(C'\fR will block until the thread has ended, though
it won't block if the thread has already terminated.
.Sp
If the thread being \f(CW\*(C`join\*(C'\fRed \f(CW\*(C`die\*(C'\fRd, the error it died with will
be returned at this time. If you don't want the thread performing
the \f(CW\*(C`join\*(C'\fR to die as well, you should either wrap the \f(CW\*(C`join\*(C'\fR in
an \f(CW\*(C`eval\*(C'\fR or use the \f(CW\*(C`eval\*(C'\fR thread method instead of \f(CW\*(C`join\*(C'\fR.
.IP "detach" 8
.IX Item "detach"
\&\f(CW\*(C`detach\*(C'\fR tells a thread that it is never going to be joined i.e.
that all traces of its existence can be removed once it stops running.
Errors in detached threads will not be visible anywhere \- if you want
to catch them, you should use \f(CW$SIG\fR{_\|_DIE_\|_} or something like that.
.IP "equal" 8
.IX Item "equal"
\&\f(CW\*(C`equal\*(C'\fR tests whether two thread objects represent the same thread and
returns true if they do.
.IP "tid" 8
.IX Item "tid"
The \f(CW\*(C`tid\*(C'\fR method returns the tid of a thread. The tid is
a monotonically increasing integer assigned when a thread is
created. The main thread of a program will have a tid of zero,
while subsequent threads will have tids assigned starting with one.
.IP "done" 8
.IX Item "done"
The \f(CW\*(C`done\*(C'\fR method returns true if the thread you're checking has
finished, and false otherwise.
.SH "DEFUNCT"
.IX Header "DEFUNCT"
The following were implemented with \fI5005threads\fR, but are no longer
available with \fIithreads\fR.
.IP "lock(\e&sub)" 8
.IX Item "lock(&sub)"
With 5005threads, you could also \f(CW\*(C`lock\*(C'\fR a sub such that any calls to that sub
from another thread would block until the lock was released.
.Sp
Also, subroutines could be declared with the \f(CW\*(C`:locked\*(C'\fR attribute which would
serialize access to the subroutine, but allowed different threads
non-simultaneous access.
.IP "eval" 8
.IX Item "eval"
The \f(CW\*(C`eval\*(C'\fR method wrapped an \f(CW\*(C`eval\*(C'\fR around a \f(CW\*(C`join\*(C'\fR, and so waited for a
thread to exit, passing along any values the thread might have returned and
placing any errors into \f(CW$@\fR.
.IP "flags" 8
.IX Item "flags"
The \f(CW\*(C`flags\*(C'\fR method returned the flags for the thread \- an integer value
corresponding to the internal flags for the thread.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
threads, threads::shared, Thread::Queue, Thread::Semaphore
