/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.45 from the
 * contents of APItest.xs. Do not edit this file, edit APItest.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "APItest.xs"
#define PERL_IN_XS_APITEST

/* We want to be able to test things that aren't API yet. */
#define PERL_EXT

/* Do *not* define PERL_NO_GET_CONTEXT.  This is the one place where we get
   to test implicit Perl_get_context().  */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

typedef FILE NativeFile;

#include "fakesdio.h"   /* Causes us to use PerlIO below */

typedef SV *SVREF;
typedef PTR_TBL_t *XS__APItest__PtrTable;
typedef PerlIO * InputStream;
typedef PerlIO * OutputStream;

#define croak_fail() croak("fail at " __FILE__ " line %d", __LINE__)
#define croak_fail_nep(h, w) croak("fail %p!=%p at " __FILE__ " line %d", (h), (w), __LINE__)
#define croak_fail_nei(h, w) croak("fail %d!=%d at " __FILE__ " line %d", (int)(h), (int)(w), __LINE__)

#if IVSIZE == 8
#  define TEST_64BIT 1
#else
#  define TEST_64BIT 0
#endif

#ifdef EBCDIC

void
cat_utf8a2n(SV* sv, const char * const ascii_utf8, STRLEN len)
{
    /* Converts variant UTF-8 text pointed to by 'ascii_utf8' of length 'len',
     * to UTF-EBCDIC, appending that text to the text already in 'sv'.
     * Currently doesn't work on invariants, as that is unneeded here, and we
     * could get double translations if we did.
     *
     * It has the algorithm for strict UTF-8 hard-coded in to find the code
     * point it represents, then calls uvchr_to_utf8() to convert to
     * UTF-EBCDIC).
     *
     * Note that this uses code points, not characters.  Thus if the input is
     * the UTF-8 for the code point 0xFF, the output will be the UTF-EBCDIC for
     * 0xFF, even though that code point represents different characters on
     * ASCII vs EBCDIC platforms. */

    dTHX;
    char * p = (char *) ascii_utf8;
    const char * const e = p + len;

    while (p < e) {
        UV code_point;
        U8 native_utf8[UTF8_MAXBYTES + 1];
        U8 * char_end;
        U8 start = (U8) *p;

        /* Start bytes are the same in both UTF-8 and I8, therefore we can
         * treat this ASCII UTF-8 byte as an I8 byte.  But PL_utf8skip[] is
         * indexed by NATIVE_UTF8 bytes, so transform to that */
        STRLEN char_bytes_len = PL_utf8skip[I8_TO_NATIVE_UTF8(start)];

        if (start < 0xc2) {
            croak("fail: Expecting start byte, instead got 0x%X at %s line %d",
                                                  (U8) *p, __FILE__, __LINE__);
        }
        code_point = (start & (((char_bytes_len) >= 7)
                                ? 0x00
                                : (0x1F >> ((char_bytes_len)-2))));
        p++;
        while (p < e && ((( (U8) *p) & 0xC0) == 0x80)) {

            code_point = (code_point << 6) | (( (U8) *p) & 0x3F);
            p++;
        }

        char_end = uvchr_to_utf8(native_utf8, code_point);
        sv_catpvn(sv, (char *) native_utf8, char_end - native_utf8);
    }
}

#endif

/* for my_cxt tests */

#define MY_CXT_KEY "XS::APItest::_guts" XS_VERSION

typedef struct {
    int i;
    SV *sv;
    GV *cscgv;
    AV *cscav;
    AV *bhkav;
    bool bhk_record;
    peep_t orig_peep;
    peep_t orig_rpeep;
    int peep_recording;
    AV *peep_recorder;
    AV *rpeep_recorder;
    AV *xop_record;
} my_cxt_t;

START_MY_CXT

static int
S_myset_set(pTHX_ SV* sv, MAGIC* mg)
{
    SV *isv = (SV*)mg->mg_ptr;

    PERL_UNUSED_ARG(sv);
    SvIVX(isv)++;
    return 0;
}

static MGVTBL vtbl_foo, vtbl_bar;
static MGVTBL vtbl_myset = { 0, S_myset_set, 0, 0, 0, 0, 0, 0 };

static int
S_mycopy_copy(pTHX_ SV *sv, MAGIC* mg, SV *nsv, const char *name, I32 namlen) {
    PERL_UNUSED_ARG(sv);
    PERL_UNUSED_ARG(nsv);
    PERL_UNUSED_ARG(name);
    PERL_UNUSED_ARG(namlen);

    /* Count that we were called to "copy".
       There's actually no point in copying *this* magic onto nsv, as it's a
       SCALAR, whereas mg_copy is only triggered for ARRAYs and HASHes.
       It's not *exactly* generic. :-( */
    ++mg->mg_private;
    return 0;
}

STATIC MGVTBL vtbl_mycopy = { 0, 0, 0, 0, 0, S_mycopy_copy, 0, 0 };

/* indirect functions to test the [pa]MY_CXT macros */

int
my_cxt_getint_p(pMY_CXT)
{
    return MY_CXT.i;
}

void
my_cxt_setint_p(pMY_CXT_ int i)
{
    MY_CXT.i = i;
}

SV*
my_cxt_getsv_interp_context(void)
{
    dTHX;
    dMY_CXT_INTERP(my_perl);
    return MY_CXT.sv;
}

SV*
my_cxt_getsv_interp(void)
{
    dMY_CXT;
    return MY_CXT.sv;
}

void
my_cxt_setsv_p(SV* sv _pMY_CXT)
{
    MY_CXT.sv = sv;
}


/* from exception.c */
int apitest_exception(int);

/* from core_or_not.inc */
bool sv_setsv_cow_hashkey_core(void);
bool sv_setsv_cow_hashkey_notcore(void);

/* A routine to test hv_delayfree_ent
   (which itself is tested by testing on hv_free_ent  */

typedef void (freeent_function)(pTHX_ HV *, HE *);

void
test_freeent(freeent_function *f) {
    dSP;
    HV *test_hash = newHV();
    HE *victim;
    SV *test_scalar;
    U32 results[4];
    int i;

#ifdef PURIFY
    victim = (HE*)safemalloc(sizeof(HE));
#else
    /* Storing then deleting something should ensure that a hash entry is
       available.  */
    (void) hv_stores(test_hash, "", &PL_sv_yes);
    (void) hv_deletes(test_hash, "", 0);

    /* We need to "inline" new_he here as it's static, and the functions we
       test expect to be able to call del_HE on the HE  */
    if (!PL_body_roots[HE_ARENA_ROOT_IX])
        croak("PL_he_root is 0");
    victim = (HE*) PL_body_roots[HE_ARENA_ROOT_IX];
    PL_body_roots[HE_ARENA_ROOT_IX] = HeNEXT(victim);
#endif

#ifdef NODEFAULT_SHAREKEYS
    HvSHAREKEYS_on(test_hash);
#endif

    victim->hent_hek = Perl_share_hek(aTHX_ "", 0, 0);

    test_scalar = newSV(0);
    SvREFCNT_inc(test_scalar);
    HeVAL(victim) = test_scalar;

    /* Need this little game else we free the temps on the return stack.  */
    results[0] = SvREFCNT(test_scalar);
    SAVETMPS;
    results[1] = SvREFCNT(test_scalar);
    f(aTHX_ test_hash, victim);
    results[2] = SvREFCNT(test_scalar);
    FREETMPS;
    results[3] = SvREFCNT(test_scalar);

    i = 0;
    do {
        mXPUSHu(results[i]);
    } while (++i < (int)(sizeof(results)/sizeof(results[0])));

    /* Goodbye to our extra reference.  */
    SvREFCNT_dec(test_scalar);
}

/* Not that it matters much, but it's handy for the flipped character to just
 * be the opposite case (at least for ASCII-range and most Latin1 as well). */
#define FLIP_BIT ('A' ^ 'a')

static I32
bitflip_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
        STRLEN len;
        const char *p = SvPV(keysv, len);

        if (len) {
            /* Allow for the flipped val to be longer than the original.  This
             * is just for testing, so can afford to have some slop */
            const STRLEN newlen = len * 2;

            SV *newkey = newSV(newlen);
            const char * const new_p_orig = SvPVX(newkey);
            char *new_p = (char *) new_p_orig;

            if (SvUTF8(keysv)) {
                const char *const end = p + len;
                while (p < end) {
                    STRLEN curlen;
                    UV chr = utf8_to_uvchr_buf((U8 *)p, (U8 *) end, &curlen);

                    /* Make sure don't exceed bounds */
                    assert(new_p - new_p_orig + curlen < newlen);

                    new_p = (char *)uvchr_to_utf8((U8 *)new_p, chr ^ FLIP_BIT);
                    p += curlen;
                }
                SvUTF8_on(newkey);
            } else {
                while (len--)
                    *new_p++ = *p++ ^ FLIP_BIT;
            }
            *new_p = '\0';
            SvCUR_set(newkey, new_p - new_p_orig);
            SvPOK_on(newkey);

            mg->mg_obj = newkey;
        }
    }
    return 0;
}

static I32
rot13_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
        STRLEN len;
        const char *p = SvPV(keysv, len);

        if (len) {
            SV *newkey = newSV(len);
            char *new_p = SvPVX(newkey);

            /* There's a deliberate fencepost error here to loop len + 1 times
               to copy the trailing \0  */
            do {
                char new_c = *p++;
                /* Try doing this cleanly and clearly in EBCDIC another way: */
                switch (new_c) {
                case 'A': new_c = 'N'; break;
                case 'B': new_c = 'O'; break;
                case 'C': new_c = 'P'; break;
                case 'D': new_c = 'Q'; break;
                case 'E': new_c = 'R'; break;
                case 'F': new_c = 'S'; break;
                case 'G': new_c = 'T'; break;
                case 'H': new_c = 'U'; break;
                case 'I': new_c = 'V'; break;
                case 'J': new_c = 'W'; break;
                case 'K': new_c = 'X'; break;
                case 'L': new_c = 'Y'; break;
                case 'M': new_c = 'Z'; break;
                case 'N': new_c = 'A'; break;
                case 'O': new_c = 'B'; break;
                case 'P': new_c = 'C'; break;
                case 'Q': new_c = 'D'; break;
                case 'R': new_c = 'E'; break;
                case 'S': new_c = 'F'; break;
                case 'T': new_c = 'G'; break;
                case 'U': new_c = 'H'; break;
                case 'V': new_c = 'I'; break;
                case 'W': new_c = 'J'; break;
                case 'X': new_c = 'K'; break;
                case 'Y': new_c = 'L'; break;
                case 'Z': new_c = 'M'; break;
                case 'a': new_c = 'n'; break;
                case 'b': new_c = 'o'; break;
                case 'c': new_c = 'p'; break;
                case 'd': new_c = 'q'; break;
                case 'e': new_c = 'r'; break;
                case 'f': new_c = 's'; break;
                case 'g': new_c = 't'; break;
                case 'h': new_c = 'u'; break;
                case 'i': new_c = 'v'; break;
                case 'j': new_c = 'w'; break;
                case 'k': new_c = 'x'; break;
                case 'l': new_c = 'y'; break;
                case 'm': new_c = 'z'; break;
                case 'n': new_c = 'a'; break;
                case 'o': new_c = 'b'; break;
                case 'p': new_c = 'c'; break;
                case 'q': new_c = 'd'; break;
                case 'r': new_c = 'e'; break;
                case 's': new_c = 'f'; break;
                case 't': new_c = 'g'; break;
                case 'u': new_c = 'h'; break;
                case 'v': new_c = 'i'; break;
                case 'w': new_c = 'j'; break;
                case 'x': new_c = 'k'; break;
                case 'y': new_c = 'l'; break;
                case 'z': new_c = 'm'; break;
                }
                *new_p++ = new_c;
            } while (len--);
            SvCUR_set(newkey, SvCUR(keysv));
            SvPOK_on(newkey);
            if (SvUTF8(keysv))
                SvUTF8_on(newkey);

            mg->mg_obj = newkey;
        }
    }
    return 0;
}

STATIC I32
rmagical_a_dummy(pTHX_ IV idx, SV *sv) {
    PERL_UNUSED_ARG(idx);
    PERL_UNUSED_ARG(sv);
    return 0;
}

/* We could do "= { 0 };" but some versions of gcc do warn
 * (with -Wextra) about missing initializer, this is probably gcc
 * being a bit too paranoid.  But since this is file-static, we can
 * just have it without initializer, since it should get
 * zero-initialized. */
STATIC MGVTBL rmagical_b;

STATIC void
blockhook_csc_start(pTHX_ int full)
{
    dMY_CXT;
    AV *const cur = GvAV(MY_CXT.cscgv);

    PERL_UNUSED_ARG(full);
    SAVEGENERICSV(GvAV(MY_CXT.cscgv));

    if (cur) {
        Size_t i;
        AV *const new_av = newAV();

        for (i = 0; i < av_count(cur); i++) {
            av_store(new_av, i, newSVsv(*av_fetch(cur, i, 0)));
        }

        GvAV(MY_CXT.cscgv) = new_av;
    }
}

STATIC void
blockhook_csc_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    /* if we hit the end of a scope we missed the start of, we need to
     * unconditionally clear @CSC */
    if (GvAV(MY_CXT.cscgv) == MY_CXT.cscav && MY_CXT.cscav) {
        av_clear(MY_CXT.cscav);
    }

}

STATIC void
blockhook_test_start(pTHX_ int full)
{
    dMY_CXT;
    AV *av;

    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("start"));
        av_push(av, newSViv(full));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC void
blockhook_test_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("pre_end"));
}

STATIC void
blockhook_test_post_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("post_end"));
}

STATIC void
blockhook_test_eval(pTHX_ OP *const o)
{
    dMY_CXT;
    AV *av;

    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("eval"));
        av_push(av, newSVpv(OP_NAME(o), 0));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC BHK bhk_csc, bhk_test;

STATIC void
my_peep (pTHX_ OP *o)
{
    dMY_CXT;

    if (!o)
        return;

    MY_CXT.orig_peep(aTHX_ o);

    if (!MY_CXT.peep_recording)
        return;

    for (; o; o = o->op_next) {
        if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
            av_push(MY_CXT.peep_recorder, newSVsv(cSVOPx_sv(o)));
        }
    }
}

STATIC void
my_rpeep (pTHX_ OP *first)
{
    dMY_CXT;
    OP *o, *t;

    if (!first)
        return;

    MY_CXT.orig_rpeep(aTHX_ first);

    if (!MY_CXT.peep_recording)
        return;

    for (o = first, t = first; o; o = o->op_next, t = t->op_next) {
        if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
            av_push(MY_CXT.rpeep_recorder, newSVsv(cSVOPx_sv(o)));
        }
        o = o->op_next;
        if (!o || o == t) break;
        if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
            av_push(MY_CXT.rpeep_recorder, newSVsv(cSVOPx_sv(o)));
        }
    }
}

STATIC OP *
THX_ck_entersub_args_lists(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    return ck_entersub_args_list(entersubop);
}

STATIC OP *
THX_ck_entersub_args_scalars(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *aop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(aop))
        aop = cUNOPx(aop)->op_first;
    for (aop = OpSIBLING(aop); OpHAS_SIBLING(aop); aop = OpSIBLING(aop)) {
        op_contextualize(aop, G_SCALAR);
    }
    return entersubop;
}

STATIC OP *
THX_ck_entersub_multi_sum(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *sumop = NULL;
    OP *parent = entersubop;
    OP *pushop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    while (1) {
        OP *aop = OpSIBLING(pushop);
        if (!OpHAS_SIBLING(aop))
            break;
        /* cut out first arg */
        op_sibling_splice(parent, pushop, 1, NULL);
        op_contextualize(aop, G_SCALAR);
        if (sumop) {
            sumop = newBINOP(OP_ADD, 0, sumop, aop);
        } else {
            sumop = aop;
        }
    }
    if (!sumop)
        sumop = newSVOP(OP_CONST, 0, newSViv(0));
    op_free(entersubop);
    return sumop;
}

STATIC void test_op_list_describe_part(SV *res, OP *o);
STATIC void
test_op_list_describe_part(SV *res, OP *o)
{
    sv_catpv(res, PL_op_name[o->op_type]);
    switch (o->op_type) {
        case OP_CONST: {
            sv_catpvf(res, "(%d)", (int)SvIV(cSVOPx(o)->op_sv));
        } break;
    }
    if (o->op_flags & OPf_KIDS) {
        OP *k;
        sv_catpvs(res, "[");
        for (k = cUNOPx(o)->op_first; k; k = OpSIBLING(k))
            test_op_list_describe_part(res, k);
        sv_catpvs(res, "]");
    } else {
        sv_catpvs(res, ".");
    }
}

STATIC char *
test_op_list_describe(OP *o)
{
    SV *res = sv_2mortal(newSVpvs(""));
    if (o)
        test_op_list_describe_part(res, o);
    return SvPVX(res);
}

/* the real new*OP functions have a tendency to call fold_constants, and
 * other such unhelpful things, so we need our own versions for testing */

#define mkUNOP(t, f) THX_mkUNOP(aTHX_ (t), (f))
static OP *
THX_mkUNOP(pTHX_ U32 type, OP *first)
{
    UNOP *unop;
    NewOp(1103, unop, 1, UNOP);
    unop->op_type   = (OPCODE)type;
    op_sibling_splice((OP*)unop, NULL, 0, first);
    return (OP *)unop;
}

#define mkBINOP(t, f, l) THX_mkBINOP(aTHX_ (t), (f), (l))
static OP *
THX_mkBINOP(pTHX_ U32 type, OP *first, OP *last)
{
    BINOP *binop;
    NewOp(1103, binop, 1, BINOP);
    binop->op_type      = (OPCODE)type;
    op_sibling_splice((OP*)binop, NULL, 0, last);
    op_sibling_splice((OP*)binop, NULL, 0, first);
    return (OP *)binop;
}

#define mkLISTOP(t, f, s, l) THX_mkLISTOP(aTHX_ (t), (f), (s), (l))
static OP *
THX_mkLISTOP(pTHX_ U32 type, OP *first, OP *sib, OP *last)
{
    LISTOP *listop;
    NewOp(1103, listop, 1, LISTOP);
    listop->op_type     = (OPCODE)type;
    op_sibling_splice((OP*)listop, NULL, 0, last);
    op_sibling_splice((OP*)listop, NULL, 0, sib);
    op_sibling_splice((OP*)listop, NULL, 0, first);
    return (OP *)listop;
}

static char *
test_op_linklist_describe(OP *start)
{
    SV *rv = sv_2mortal(newSVpvs(""));
    OP *o;
    o = start = LINKLIST(start);
    do {
        sv_catpvs(rv, ".");
        sv_catpv(rv, OP_NAME(o));
        if (o->op_type == OP_CONST)
            sv_catsv(rv, cSVOPo->op_sv);
        o = o->op_next;
    } while (o && o != start);
    return SvPVX(rv);
}

/** establish_cleanup operator, ripped off from Scope::Cleanup **/

STATIC void
THX_run_cleanup(pTHX_ void *cleanup_code_ref)
{
    dSP;
    PUSHSTACK;
    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    call_sv((SV*)cleanup_code_ref, G_VOID|G_DISCARD);
    FREETMPS;
    LEAVE;
    POPSTACK;
}

STATIC OP *
THX_pp_establish_cleanup(pTHX)
{
    dSP;
    SV *cleanup_code_ref;
    cleanup_code_ref = newSVsv(POPs);
    SAVEFREESV(cleanup_code_ref);
    SAVEDESTRUCTOR_X(THX_run_cleanup, cleanup_code_ref);
    if(GIMME_V != G_VOID) PUSHs(&PL_sv_undef);
    RETURN;
}

STATIC OP *
THX_ck_entersub_establish_cleanup(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop, *estop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    /* extract out first arg, then delete the rest of the tree */
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);

    estop = mkUNOP(OP_RAND, argop);
    estop->op_ppaddr = THX_pp_establish_cleanup;
    PL_hints |= HINT_BLOCK_SCOPE;
    return estop;
}

STATIC OP *
THX_ck_entersub_postinc(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);
    return newUNOP(OP_POSTINC, 0,
        op_lvalue(op_contextualize(argop, G_SCALAR), OP_POSTINC));
}

STATIC OP *
THX_ck_entersub_pad_scalar(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *pushop, *argop;
    PADOFFSET padoff = NOT_IN_PAD;
    SV *a0, *a1;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop))
        pushop = cUNOPx(pushop)->op_first;
    argop = OpSIBLING(pushop);
    if(argop->op_type != OP_CONST || OpSIBLING(argop)->op_type != OP_CONST)
        croak("bad argument expression type for pad_scalar()");
    a0 = cSVOPx_sv(argop);
    a1 = cSVOPx_sv(OpSIBLING(argop));
    switch(SvIV(a0)) {
        case 1: {
            SV *namesv = sv_2mortal(newSVpvs("$"));
            sv_catsv(namesv, a1);
            padoff = pad_findmy_sv(namesv, 0);
        } break;
        case 2: {
            char *namepv;
            STRLEN namelen;
            SV *namesv = sv_2mortal(newSVpvs("$"));
            sv_catsv(namesv, a1);
            namepv = SvPV(namesv, namelen);
            padoff = pad_findmy_pvn(namepv, namelen, SvUTF8(namesv));
        } break;
        case 3: {
            char *namepv;
            SV *namesv = sv_2mortal(newSVpvs("$"));
            sv_catsv(namesv, a1);
            namepv = SvPV_nolen(namesv);
            padoff = pad_findmy_pv(namepv, SvUTF8(namesv));
        } break;
        case 4: {
            padoff = pad_findmy_pvs("$foo", 0);
        } break;
        default: croak("bad type value for pad_scalar()");
    }
    op_free(entersubop);
    if(padoff == NOT_IN_PAD) {
        return newSVOP(OP_CONST, 0, newSVpvs("NOT_IN_PAD"));
    } else if(PAD_COMPNAME_FLAGS_isOUR(padoff)) {
        return newSVOP(OP_CONST, 0, newSVpvs("NOT_MY"));
    } else {
        OP *padop = newOP(OP_PADSV, 0);
        padop->op_targ = padoff;
        return padop;
    }
}

/** RPN keyword parser **/

#define sv_is_glob(sv) (SvTYPE(sv) == SVt_PVGV)
#define sv_is_regexp(sv) (SvTYPE(sv) == SVt_REGEXP)
#define sv_is_string(sv) \
    (!sv_is_glob(sv) && !sv_is_regexp(sv) && \
     (SvFLAGS(sv) & (SVf_IOK|SVf_NOK|SVf_POK|SVp_IOK|SVp_NOK|SVp_POK)))

static SV *hintkey_rpn_sv, *hintkey_calcrpn_sv, *hintkey_stufftest_sv;
static SV *hintkey_swaptwostmts_sv, *hintkey_looprest_sv;
static SV *hintkey_scopelessblock_sv;
static SV *hintkey_stmtasexpr_sv, *hintkey_stmtsasexpr_sv;
static SV *hintkey_loopblock_sv, *hintkey_blockasexpr_sv;
static SV *hintkey_swaplabel_sv, *hintkey_labelconst_sv;
static SV *hintkey_arrayfullexpr_sv, *hintkey_arraylistexpr_sv;
static SV *hintkey_arraytermexpr_sv, *hintkey_arrayarithexpr_sv;
static SV *hintkey_arrayexprflags_sv;
static SV *hintkey_subsignature_sv;
static SV *hintkey_DEFSV_sv;
static SV *hintkey_with_vars_sv;
static SV *hintkey_join_with_space_sv;
static int (*next_keyword_plugin)(pTHX_ char *, STRLEN, OP **);

/* low-level parser helpers */

#define PL_bufptr (PL_parser->bufptr)
#define PL_bufend (PL_parser->bufend)

/* RPN parser */

#define parse_var() THX_parse_var(aTHX)
static OP *THX_parse_var(pTHX)
{
    char *s = PL_bufptr;
    char *start = s;
    PADOFFSET varpos;
    OP *padop;
    if(*s != '$') croak("RPN syntax error");
    while(1) {
        char c = *++s;
        if(!isALNUM(c)) break;
    }
    if(s-start < 2) croak("RPN syntax error");
    lex_read_to(s);
    varpos = pad_findmy_pvn(start, s-start, 0);
    if(varpos == NOT_IN_PAD || PAD_COMPNAME_FLAGS_isOUR(varpos))
        croak("RPN only supports \"my\" variables");
    padop = newOP(OP_PADSV, 0);
    padop->op_targ = varpos;
    return padop;
}

#define push_rpn_item(o) \
    op_sibling_splice(parent, NULL, 0, o);
#define pop_rpn_item() ( \
    (tmpop = op_sibling_splice(parent, NULL, 1, NULL)) \
        ? tmpop : (croak("RPN stack underflow"), (OP*)NULL))

#define parse_rpn_expr() THX_parse_rpn_expr(aTHX)
static OP *THX_parse_rpn_expr(pTHX)
{
    OP *tmpop;
    /* fake parent for splice to mess with */
    OP *parent = mkBINOP(OP_NULL, NULL, NULL);

    while(1) {
        I32 c;
        lex_read_space(0);
        c = lex_peek_unichar(0);
        switch(c) {
            case /*(*/')': case /*{*/'}': {
                OP *result = pop_rpn_item();
                if(cLISTOPx(parent)->op_first)
                    croak("RPN expression must return a single value");
                op_free(parent);
                return result;
            } break;
            case '0': case '1': case '2': case '3': case '4':
            case '5': case '6': case '7': case '8': case '9': {
                UV val = 0;
                do {
                    lex_read_unichar(0);
                    val = 10*val + (c - '0');
                    c = lex_peek_unichar(0);
                } while(c >= '0' && c <= '9');
                push_rpn_item(newSVOP(OP_CONST, 0, newSVuv(val)));
            } break;
            case '$': {
                push_rpn_item(parse_var());
            } break;
            case '+': {
                OP *b = pop_rpn_item();
                OP *a = pop_rpn_item();
                lex_read_unichar(0);
                push_rpn_item(newBINOP(OP_I_ADD, 0, a, b));
            } break;
            case '-': {
                OP *b = pop_rpn_item();
                OP *a = pop_rpn_item();
                lex_read_unichar(0);
                push_rpn_item(newBINOP(OP_I_SUBTRACT, 0, a, b));
            } break;
            case '*': {
                OP *b = pop_rpn_item();
                OP *a = pop_rpn_item();
                lex_read_unichar(0);
                push_rpn_item(newBINOP(OP_I_MULTIPLY, 0, a, b));
            } break;
            case '/': {
                OP *b = pop_rpn_item();
                OP *a = pop_rpn_item();
                lex_read_unichar(0);
                push_rpn_item(newBINOP(OP_I_DIVIDE, 0, a, b));
            } break;
            case '%': {
                OP *b = pop_rpn_item();
                OP *a = pop_rpn_item();
                lex_read_unichar(0);
                push_rpn_item(newBINOP(OP_I_MODULO, 0, a, b));
            } break;
            default: {
                croak("RPN syntax error");
            } break;
        }
    }
}

#define parse_keyword_rpn() THX_parse_keyword_rpn(aTHX)
static OP *THX_parse_keyword_rpn(pTHX)
{
    OP *op;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '('/*)*/)
        croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    op = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*(*/')')
        croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    return op;
}

#define parse_keyword_calcrpn() THX_parse_keyword_calcrpn(aTHX)
static OP *THX_parse_keyword_calcrpn(pTHX)
{
    OP *varop, *exprop;
    lex_read_space(0);
    varop = parse_var();
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/)
        croak("RPN expression must be braced");
    lex_read_unichar(0);
    exprop = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*{*/'}')
        croak("RPN expression must be braced");
    lex_read_unichar(0);
    return newASSIGNOP(OPf_STACKED, varop, 0, exprop);
}

#define parse_keyword_stufftest() THX_parse_keyword_stufftest(aTHX)
static OP *THX_parse_keyword_stufftest(pTHX)
{
    I32 c;
    bool do_stuff;
    lex_read_space(0);
    do_stuff = lex_peek_unichar(0) == '+';
    if(do_stuff) {
        lex_read_unichar(0);
        lex_read_space(0);
    }
    c = lex_peek_unichar(0);
    if(c == ';') {
        lex_read_unichar(0);
    } else if(c != /*{*/'}') {
        croak("syntax error");
    }
    if(do_stuff) lex_stuff_pvs(" ", 0);
    return newOP(OP_NULL, 0);
}

#define parse_keyword_swaptwostmts() THX_parse_keyword_swaptwostmts(aTHX)
static OP *THX_parse_keyword_swaptwostmts(pTHX)
{
    OP *a, *b;
    a = parse_fullstmt(0);
    b = parse_fullstmt(0);
    if(a && b)
        PL_hints |= HINT_BLOCK_SCOPE;
    return op_append_list(OP_LINESEQ, b, a);
}

#define parse_keyword_looprest() THX_parse_keyword_looprest(aTHX)
static OP *THX_parse_keyword_looprest(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
                        parse_stmtseq(0), NULL, 1);
}

#define parse_keyword_scopelessblock() THX_parse_keyword_scopelessblock(aTHX)
static OP *THX_parse_keyword_scopelessblock(pTHX)
{
    I32 c;
    OP *body;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    body = parse_stmtseq(0);
    c = lex_peek_unichar(0);
    if(c != /*{*/'}' && c != /*[*/']' && c != /*(*/')') croak("syntax error");
    lex_read_unichar(0);
    return body;
}

#define parse_keyword_stmtasexpr() THX_parse_keyword_stmtasexpr(aTHX)
static OP *THX_parse_keyword_stmtasexpr(pTHX)
{
    OP *o = parse_barestmt(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_stmtsasexpr() THX_parse_keyword_stmtsasexpr(aTHX)
static OP *THX_parse_keyword_stmtsasexpr(pTHX)
{
    OP *o;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    o = parse_stmtseq(0);
    lex_read_space(0);
    if(lex_peek_unichar(0) != /*{*/'}') croak("syntax error");
    lex_read_unichar(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_loopblock() THX_parse_keyword_loopblock(aTHX)
static OP *THX_parse_keyword_loopblock(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
                        parse_block(0), NULL, 1);
}

#define parse_keyword_blockasexpr() THX_parse_keyword_blockasexpr(aTHX)
static OP *THX_parse_keyword_blockasexpr(pTHX)
{
    OP *o = parse_block(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_swaplabel() THX_parse_keyword_swaplabel(aTHX)
static OP *THX_parse_keyword_swaplabel(pTHX)
{
    OP *sop = parse_barestmt(0);
    SV *label = parse_label(PARSE_OPTIONAL);
    if (label) sv_2mortal(label);
    return newSTATEOP(label ? SvUTF8(label) : 0,
                      label ? savepv(SvPVX(label)) : NULL,
                      sop);
}

#define parse_keyword_labelconst() THX_parse_keyword_labelconst(aTHX)
static OP *THX_parse_keyword_labelconst(pTHX)
{
    return newSVOP(OP_CONST, 0, parse_label(0));
}

#define parse_keyword_arrayfullexpr() THX_parse_keyword_arrayfullexpr(aTHX)
static OP *THX_parse_keyword_arrayfullexpr(pTHX)
{
    return newANONLIST(parse_fullexpr(0));
}

#define parse_keyword_arraylistexpr() THX_parse_keyword_arraylistexpr(aTHX)
static OP *THX_parse_keyword_arraylistexpr(pTHX)
{
    return newANONLIST(parse_listexpr(0));
}

#define parse_keyword_arraytermexpr() THX_parse_keyword_arraytermexpr(aTHX)
static OP *THX_parse_keyword_arraytermexpr(pTHX)
{
    return newANONLIST(parse_termexpr(0));
}

#define parse_keyword_arrayarithexpr() THX_parse_keyword_arrayarithexpr(aTHX)
static OP *THX_parse_keyword_arrayarithexpr(pTHX)
{
    return newANONLIST(parse_arithexpr(0));
}

#define parse_keyword_arrayexprflags() THX_parse_keyword_arrayexprflags(aTHX)
static OP *THX_parse_keyword_arrayexprflags(pTHX)
{
    U32 flags = 0;
    I32 c;
    OP *o;
    lex_read_space(0);
    c = lex_peek_unichar(0);
    if (c != '!' && c != '?') croak("syntax error");
    lex_read_unichar(0);
    if (c == '?') flags |= PARSE_OPTIONAL;
    o = parse_listexpr(flags);
    return o ? newANONLIST(o) : newANONHASH(newOP(OP_STUB, 0));
}

#define parse_keyword_subsignature() THX_parse_keyword_subsignature(aTHX)
static OP *THX_parse_keyword_subsignature(pTHX)
{
    OP *retop = NULL, *listop, *sigop = parse_subsignature(0);
    OP *kid;
    int seen_nextstate = 0;

    /* We can't yield the optree as is to the caller because it won't be
     * executable outside of a called sub. We'll have to convert it into
     * something safe for them to invoke.
     * sigop should be an OP_NULL above a OP_LINESEQ containing
     * OP_NEXTSTATE-separated OP_ARGCHECK and OP_ARGELEMs
     */
    if(sigop->op_type != OP_NULL)
        croak("Expected parse_subsignature() to yield an OP_NULL");

    if(!(sigop->op_flags & OPf_KIDS))
        croak("Expected parse_subsignature() to yield an OP_NULL with kids");
    listop = cUNOPx(sigop)->op_first;

    if(listop->op_type != OP_LINESEQ)
        croak("Expected parse_subsignature() to yield an OP_LINESEQ");

    for(kid = cLISTOPx(listop)->op_first; kid; kid = OpSIBLING(kid)) {
        switch(kid->op_type) {
            case OP_NEXTSTATE:
                /* Only emit the first one otherwise they get boring */
                if(seen_nextstate)
                    break;
                seen_nextstate++;
                retop = op_append_list(OP_LIST, retop, newSVOP(OP_CONST, 0,
                    /* newSVpvf("nextstate:%s:%d", CopFILE(cCOPx(kid)), cCOPx(kid)->cop_line))); */
                    newSVpvf("nextstate:%u", (unsigned int)cCOPx(kid)->cop_line)));
                break;
            case OP_ARGCHECK: {
                struct op_argcheck_aux *p =
                    (struct op_argcheck_aux*)(cUNOP_AUXx(kid)->op_aux);
                retop = op_append_list(OP_LIST, retop, newSVOP(OP_CONST, 0,
                    newSVpvf("argcheck:%" UVuf ":%" UVuf ":%c",
                            p->params, p->opt_params,
                            p->slurpy ? p->slurpy : '-')));
                break;
            }
            case OP_ARGELEM: {
                PADOFFSET padix = kid->op_targ;
                PADNAMELIST *names = PadlistNAMES(CvPADLIST(find_runcv(0)));
                char *namepv = PadnamePV(padnamelist_fetch(names, padix));
                retop = op_append_list(OP_LIST, retop, newSVOP(OP_CONST, 0,
                    newSVpvf(kid->op_flags & OPf_KIDS ? "argelem:%s:d" : "argelem:%s", namepv)));
                break;
            }
            default:
                fprintf(stderr, "TODO: examine kid %p (optype=%s)\n", kid, PL_op_name[kid->op_type]);
                break;
        }
    }

    op_free(sigop);
    return newANONLIST(retop);
}

#define parse_keyword_DEFSV() THX_parse_keyword_DEFSV(aTHX)
static OP *THX_parse_keyword_DEFSV(pTHX)
{
    return newDEFSVOP();
}

#define sv_cat_c(a,b) THX_sv_cat_c(aTHX_ a, b)
static void THX_sv_cat_c(pTHX_ SV *sv, U32 c) {
    char ds[UTF8_MAXBYTES + 1], *d;
    d = (char *)uvchr_to_utf8((U8 *)ds, c);
    if (d - ds > 1) {
        sv_utf8_upgrade(sv);
    }
    sv_catpvn(sv, ds, d - ds);
}

#define parse_keyword_with_vars() THX_parse_keyword_with_vars(aTHX)
static OP *THX_parse_keyword_with_vars(pTHX)
{
    I32 c;
    IV count;
    int save_ix;
    OP *vardeclseq, *body;

    save_ix = block_start(TRUE);
    vardeclseq = NULL;

    count = 0;

    lex_read_space(0);
    c = lex_peek_unichar(0);
    while (c != '{') {
        SV *varname;
        PADOFFSET padoff;

        if (c == -1) {
            croak("unexpected EOF; expecting '{'");
        }

        if (!isIDFIRST_uni(c)) {
            croak("unexpected '%c'; expecting an identifier", (int)c);
        }

        varname = newSVpvs("$");
        if (lex_bufutf8()) {
            SvUTF8_on(varname);
        }

        sv_cat_c(varname, c);
        lex_read_unichar(0);

        while (c = lex_peek_unichar(0), c != -1 && isIDCONT_uni(c)) {
            sv_cat_c(varname, c);
            lex_read_unichar(0);
        }

        padoff = pad_add_name_sv(varname, padadd_NO_DUP_CHECK, NULL, NULL);

        {
            OP *my_var = newOP(OP_PADSV, OPf_MOD | (OPpLVAL_INTRO << 8));
            my_var->op_targ = padoff;

            vardeclseq = op_append_list(
                OP_LINESEQ,
                vardeclseq,
                newSTATEOP(
                    0, NULL,
                    newASSIGNOP(
                        OPf_STACKED,
                        my_var, 0,
                        newSVOP(
                            OP_CONST, 0,
                            newSViv(++count)
                        )
                    )
                )
            );
        }

        lex_read_space(0);
        c = lex_peek_unichar(0);
    }

    intro_my();

    body = parse_block(0);

    return block_end(save_ix, op_append_list(OP_LINESEQ, vardeclseq, body));
}

#define parse_join_with_space() THX_parse_join_with_space(aTHX)
static OP *THX_parse_join_with_space(pTHX)
{
    OP *delim, *args;

    args = parse_listexpr(0);
    delim = newSVOP(OP_CONST, 0, newSVpvs(" "));
    return op_convert_list(OP_JOIN, 0, op_prepend_elem(OP_LIST, delim, args));
}

/* plugin glue */

#define keyword_active(hintkey_sv) THX_keyword_active(aTHX_ hintkey_sv)
static int THX_keyword_active(pTHX_ SV *hintkey_sv)
{
    HE *he;
    if(!GvHV(PL_hintgv)) return 0;
    he = hv_fetch_ent(GvHV(PL_hintgv), hintkey_sv, 0,
                SvSHARED_HASH(hintkey_sv));
    return he && SvTRUE(HeVAL(he));
}

static int my_keyword_plugin(pTHX_
    char *keyword_ptr, STRLEN keyword_len, OP **op_ptr)
{
    if (memEQs(keyword_ptr, keyword_len, "rpn") &&
                    keyword_active(hintkey_rpn_sv)) {
        *op_ptr = parse_keyword_rpn();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "calcrpn") &&
                    keyword_active(hintkey_calcrpn_sv)) {
        *op_ptr = parse_keyword_calcrpn();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "stufftest") &&
                    keyword_active(hintkey_stufftest_sv)) {
        *op_ptr = parse_keyword_stufftest();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "swaptwostmts") &&
                    keyword_active(hintkey_swaptwostmts_sv)) {
        *op_ptr = parse_keyword_swaptwostmts();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "looprest") &&
                    keyword_active(hintkey_looprest_sv)) {
        *op_ptr = parse_keyword_looprest();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "scopelessblock") &&
                    keyword_active(hintkey_scopelessblock_sv)) {
        *op_ptr = parse_keyword_scopelessblock();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "stmtasexpr") &&
                    keyword_active(hintkey_stmtasexpr_sv)) {
        *op_ptr = parse_keyword_stmtasexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "stmtsasexpr") &&
                    keyword_active(hintkey_stmtsasexpr_sv)) {
        *op_ptr = parse_keyword_stmtsasexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "loopblock") &&
                    keyword_active(hintkey_loopblock_sv)) {
        *op_ptr = parse_keyword_loopblock();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "blockasexpr") &&
                    keyword_active(hintkey_blockasexpr_sv)) {
        *op_ptr = parse_keyword_blockasexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "swaplabel") &&
                    keyword_active(hintkey_swaplabel_sv)) {
        *op_ptr = parse_keyword_swaplabel();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "labelconst") &&
                    keyword_active(hintkey_labelconst_sv)) {
        *op_ptr = parse_keyword_labelconst();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayfullexpr") &&
                    keyword_active(hintkey_arrayfullexpr_sv)) {
        *op_ptr = parse_keyword_arrayfullexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arraylistexpr") &&
                    keyword_active(hintkey_arraylistexpr_sv)) {
        *op_ptr = parse_keyword_arraylistexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arraytermexpr") &&
                    keyword_active(hintkey_arraytermexpr_sv)) {
        *op_ptr = parse_keyword_arraytermexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayarithexpr") &&
                    keyword_active(hintkey_arrayarithexpr_sv)) {
        *op_ptr = parse_keyword_arrayarithexpr();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayexprflags") &&
                    keyword_active(hintkey_arrayexprflags_sv)) {
        *op_ptr = parse_keyword_arrayexprflags();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "DEFSV") &&
                    keyword_active(hintkey_DEFSV_sv)) {
        *op_ptr = parse_keyword_DEFSV();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "with_vars") &&
                    keyword_active(hintkey_with_vars_sv)) {
        *op_ptr = parse_keyword_with_vars();
        return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "join_with_space") &&
                    keyword_active(hintkey_join_with_space_sv)) {
        *op_ptr = parse_join_with_space();
        return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "subsignature") &&
                    keyword_active(hintkey_subsignature_sv)) {
        *op_ptr = parse_keyword_subsignature();
        return KEYWORD_PLUGIN_EXPR;
    } else {
        assert(next_keyword_plugin != my_keyword_plugin);
        return next_keyword_plugin(aTHX_ keyword_ptr, keyword_len, op_ptr);
    }
}

static XOP my_xop;

static OP *
pp_xop(pTHX)
{
    return PL_op->op_next;
}

static void
peep_xop(pTHX_ OP *o, OP *oldop)
{
    dMY_CXT;
    av_push(MY_CXT.xop_record, newSVpvf("peep:%" UVxf, PTR2UV(o)));
    av_push(MY_CXT.xop_record, newSVpvf("oldop:%" UVxf, PTR2UV(oldop)));
}

static I32
filter_call(pTHX_ int idx, SV *buf_sv, int maxlen)
{
    char *p;
    char *end;
    int n = FILTER_READ(idx + 1, buf_sv, maxlen);

    if (n<=0) return n;

    p = SvPV_force_nolen(buf_sv);
    end = p + SvCUR(buf_sv);
    while (p < end) {
        if (*p == 'o') *p = 'e';
        p++;
    }
    return SvCUR(buf_sv);
}

static AV *
myget_linear_isa(pTHX_ HV *stash, U32 level) {
    GV **gvp = (GV **)hv_fetchs(stash, "ISA", 0);
    PERL_UNUSED_ARG(level);
    return gvp && *gvp && GvAV(*gvp)
         ? GvAV(*gvp)
         : (AV *)sv_2mortal((SV *)newAV());
}


XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_undef);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_empty);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_APIVERSION_invalid);

static struct mro_alg mymro;

static Perl_check_t addissub_nxck_add;

static OP *
addissub_myck_add(pTHX_ OP *op)
{
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addissub", 0);
    OP *aop, *bop;
    U8 flags;
    if (!(flag_svp && SvTRUE(*flag_svp) && (op->op_flags & OPf_KIDS) &&
            (aop = cBINOPx(op)->op_first) && (bop = OpSIBLING(aop)) &&
            !OpHAS_SIBLING(bop)))
        return addissub_nxck_add(aTHX_ op);
    flags = op->op_flags;
    op_sibling_splice(op, NULL, 1, NULL); /* excise aop */
    op_sibling_splice(op, NULL, 1, NULL); /* excise bop */
    op_free(op); /* free the empty husk */
    flags &= ~OPf_KIDS;
    return newBINOP(OP_SUBTRACT, flags, aop, bop);
}

static Perl_check_t old_ck_rv2cv;

static OP *
my_ck_rv2cv(pTHX_ OP *o)
{
    SV *ref;
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addunder", 0);
    OP *aop;

    if (flag_svp && SvTRUE(*flag_svp) && (o->op_flags & OPf_KIDS)
     && (aop = cUNOPx(o)->op_first) && aop->op_type == OP_CONST
     && aop->op_private & (OPpCONST_ENTERED|OPpCONST_BARE)
     && (ref = cSVOPx(aop)->op_sv) && SvPOK(ref) && SvCUR(ref)
     && *(SvEND(ref)-1) == 'o')
    {
        SvGROW(ref, SvCUR(ref)+2);
        *SvEND(ref) = '_';
        SvCUR(ref)++; /* Not _set, so we don't accidentally break non-PERL_CORE */
        *SvEND(ref) = '\0';
    }
    return old_ck_rv2cv(aTHX_ o);
}

#include "const-c.inc"

#line 1458 "APItest.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1602 "APItest.c"

/* INCLUDE:  Including 'const-xs.inc' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 253 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined XS::APItest macro %" SVf
			  ", used", sv);
	} else
#endif
	{
	    sv = newSVpvf("%" SVf " is not a valid XS::APItest macro",
			  sv);
	}
	PUSHs(sv_2mortal(sv));
#line 1637 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'const-xs.inc' */


/* INCLUDE:  Including 'numeric.xs' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest__numeric_grok_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "number");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
#line 7 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1666 "APItest.c"
#line 12 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number(pv, len, &value);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1673 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	U32	flags = (unsigned long)SvUV(ST(1))
;
#line 23 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1698 "APItest.c"
#line 28 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number_flags(pv, len, &value, flags);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1705 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, endsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	SV *	endsv = ST(1)
;
#line 39 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value = 0xdeadbeef;
	bool result;
	const char* endptr = pv + len;
#line 1731 "APItest.c"
#line 45 "./numeric.xs"
	EXTEND(SP,2);
	if (endsv == &PL_sv_undef) {
          result = grok_atoUV(pv, &value, NULL);
        } else {
          result = grok_atoUV(pv, &value, &endptr);
        }
	PUSHs(result ? &PL_sv_yes : &PL_sv_no);
	PUSHs(sv_2mortal(newSVuv(value)));
	if (endsv == &PL_sv_undef) {
          PUSHs(sv_2mortal(newSVpvn(NULL, 0)));
	} else {
	  if (endptr) {
	    PUSHs(sv_2mortal(newSViv(endptr - pv)));
	  } else {
	    PUSHs(sv_2mortal(newSViv(0)));
	  }
	}
#line 1750 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_my_strtod); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_my_strtod)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	s = ST(0)
;
#line 67 "./numeric.xs"
        SV *sv = newSVsv(s);
        char *endptr = NULL;
        NV nv;
#line 1772 "APItest.c"
#line 71 "./numeric.xs"
        nv = my_strtod(SvPV_force_nolen(sv), &endptr);
        PUSHs(sv_2mortal(newSVnv(nv)));
        if (endptr) {
            sv_chop(sv, endptr);
            PUSHs(sv_2mortal(sv));
        }
#line 1780 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'numeric.xs' */


XS_EUPXS(XS_XS__APItest__numeric_assertx); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_assertx)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	x = (int)SvIV(ST(0))
;
#line 1457 "APItest.xs"
        /* this only needs to compile and checks that assert() can be
           used this way syntactically */
        (void)(assert(x), 1);
        (void)(x);
#line 1804 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "bytes, utf8");
    {
	SV *	bytes = ST(0)
;
	SV *	utf8 = ST(1)
;
#line 1469 "APItest.xs"
        const U8 *b;
        STRLEN blen;
        const U8 *u;
        STRLEN ulen;
#line 1826 "APItest.c"
	int	RETVAL;
	dXSTARG;
#line 1474 "APItest.xs"
        b = (const U8 *)SvPVbyte(bytes, blen);
        u = (const U8 *)SvPVbyte(utf8, ulen);
        RETVAL = bytes_cmp_utf8(b, blen, u, ulen);
#line 1833 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8_to_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8_to_bytes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "bytes, len");
    {
	U8 *	bytes = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 1485 "APItest.xs"
        char * ret;
#line 1854 "APItest.c"
	AV *	RETVAL;
#line 1487 "APItest.xs"
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = (char *) utf8_to_bytes(bytes, &len);
        av_push(RETVAL, newSVpv(ret, 0));

        /* utf8_to_bytes uses (STRLEN)-1 to signal errors, and we want to
         * return that as -1 to perl, so cast to SSize_t in case
         * sizeof(IV) > sizeof(STRLEN) */
        av_push(RETVAL, newSViv((SSize_t)len));
        av_push(RETVAL, newSVpv((const char *) bytes, 0));

#line 1869 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 1508 "APItest.xs"
        STRLEN retlen;
        UV ret;
        U32 errors;
        AV *msgs = NULL;

#line 1900 "APItest.c"
	AV *	RETVAL;
#line 1514 "APItest.xs"
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = utf8n_to_uvchr_msgs((U8*)  s,
                                         len,
                                         &retlen,
                                         flags,
                                         &errors,
                                         &msgs);

        /* Returns the return value in [0]; <retlen> in [1], <errors> in [2] */
        av_push(RETVAL, newSVuv(ret));
        if (retlen == (STRLEN) -1) {
            av_push(RETVAL, newSViv(-1));
        }
        else {
            av_push(RETVAL, newSVuv(retlen));
        }
        av_push(RETVAL, newSVuv(errors));

        /* And any messages in [3] */
        if (msgs) {
            av_push(RETVAL, newRV_noinc((SV*)msgs));
        }

#line 1928 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_error)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 1549 "APItest.xs"
        STRLEN retlen;
        UV ret;
        U32 errors;

#line 1958 "APItest.c"
	AV *	RETVAL;
#line 1554 "APItest.xs"
        /* Now that utf8n_to_uvchr() is a trivial wrapper for
         * utf8n_to_uvchr_error(), call the latter with the inputs.  It always
         * asks for the actual length to be returned and errors to be returned
         *
         * Length to assume <s> is; not checked, so could have buffer overflow
         */
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = utf8n_to_uvchr_error((U8*) s,
                                         len,
                                         &retlen,
                                         flags,
                                         &errors);

        /* Returns the return value in [0]; <retlen> in [1], <errors> in [2] */
        av_push(RETVAL, newSVuv(ret));
        if (retlen == (STRLEN) -1) {
            av_push(RETVAL, newSViv(-1));
        }
        else {
            av_push(RETVAL, newSVuv(retlen));
        }
        av_push(RETVAL, newSVuv(errors));

#line 1986 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_valid_utf8_to_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_valid_utf8_to_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SV *	s = ST(0)
;
#line 1587 "APItest.xs"
        STRLEN retlen;
        UV ret;

#line 2011 "APItest.c"
	AV *	RETVAL;
#line 1591 "APItest.xs"
        /* Call utf8n_to_uvchr() with the inputs.  It always asks for the
         * actual length to be returned
         *
         * Length to assume <s> is; not checked, so could have buffer overflow
         */
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = valid_utf8_to_uvchr((U8*) SvPV_nolen(s), &retlen);

        /* Returns the return value in [0]; <retlen> in [1] */
        av_push(RETVAL, newSVuv(ret));
        av_push(RETVAL, newSVuv(retlen));

#line 2028 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "uv, flags");
    {
	SV *	uv = ST(0)
;
	SV *	flags = ST(1)
;
#line 1614 "APItest.xs"
        U8 dest[UTF8_MAXBYTES + 1];
        U8 *ret;

#line 2055 "APItest.c"
	SV *	RETVAL;
#line 1618 "APItest.xs"
        /* Call uvchr_to_utf8_flags() with the inputs.  */
        ret = uvchr_to_utf8_flags(dest, SvUV(uv), SvUV(flags));
        if (! ret) {
            XSRETURN_UNDEF;
        }
        RETVAL = newSVpvn((char *) dest, ret - dest);

#line 2065 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "uv, flags");
    {
	SV *	uv = ST(0)
;
	SV *	flags = ST(1)
;
#line 1634 "APItest.xs"
        U8 dest[UTF8_MAXBYTES + 1];
        U8 *ret;

#line 2088 "APItest.c"
	AV *	RETVAL;
#line 1638 "APItest.xs"
        HV *msgs = NULL;
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = uvchr_to_utf8_flags_msgs(dest, SvUV(uv), SvUV(flags), &msgs);

        if (ret) {
            av_push(RETVAL, newSVpvn((char *) dest, ret - dest));
        }
        else {
            av_push(RETVAL,  &PL_sv_undef);
        }

        if (msgs) {
            av_push(RETVAL, newRV_noinc((SV*)msgs));
        }

#line 2108 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1665 "APItest.xs"
        /* The reference is owned by something else.  */
        PUSHs(amagic_deref_call(sv, what));
#line 2136 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1676 "APItest.xs"
        {
            SV **sp = &sv;
            switch(what) {
            case to_av_amg:
                tryAMAGICunDEREF(to_av);
                break;
            case to_cv_amg:
                tryAMAGICunDEREF(to_cv);
                break;
            case to_gv_amg:
                tryAMAGICunDEREF(to_gv);
                break;
            case to_hv_amg:
                tryAMAGICunDEREF(to_hv);
                break;
            case to_sv_amg:
                tryAMAGICunDEREF(to_sv);
                break;
            default:
                croak("Invalid value %d passed to tryAMAGICunDEREF_var", what);
            }
        }
        /* The reference is owned by something else.  */
        PUSHs(sv);
#line 2181 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1711 "APItest.xs"
        XS_VERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 2200 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1717 "APItest.xs"
        XS_APIVERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 2219 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "len");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	len = (int)SvIV(ST(0))
;
#line 1723 "APItest.xs"
        int i = 0;
        EXTEND( SP, len );
        for ( ; i < len; i++ ) {
            ST(i) = sv_2mortal( newSViv(i) );
        }
        XSRETURN( len );
#line 2244 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_iv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_iv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1733 "APItest.xs"
        XSRETURN_IV(I32_MIN + 1);
#line 2262 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_uv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_uv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1738 "APItest.xs"
        XSRETURN_UV( (U32)((1U<<31) + 1) );
#line 2280 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_nv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_nv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1743 "APItest.xs"
        XSRETURN_NV(0.25);
#line 2298 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1748 "APItest.xs"
        XSRETURN_PV("returned");
#line 2316 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pvn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1753 "APItest.xs"
        XSRETURN_PVN("returned too much",8);
#line 2334 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_no); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_no)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1758 "APItest.xs"
        XSRETURN_NO;
#line 2352 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_yes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_yes)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1763 "APItest.xs"
        XSRETURN_YES;
#line 2370 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_undef); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_undef)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1768 "APItest.xs"
        XSRETURN_UNDEF;
#line 2388 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_empty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_empty)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1773 "APItest.xs"
        XSRETURN_EMPTY;
#line 2406 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_rot13_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_rot13_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::rot13_hash",
				"hash");
		}
	} STMT_END
;
#line 1781 "APItest.xs"
        {
            struct ufuncs uf;
            uf.uf_val = rot13_key;
            uf.uf_set = 0;
            uf.uf_index = 0;

            sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
        }
#line 2444 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::bitflip_hash",
				"hash");
		}
	} STMT_END
;
#line 1794 "APItest.xs"
        {
            struct ufuncs uf;
            uf.uf_val = bitflip_key;
            uf.uf_set = 0;
            uf.uf_index = 0;

            sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
        }
#line 2481 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#define UTF8KLEN(sv, len)   (SvUTF8(sv) ? -(I32)len : (I32)len)

XS_EUPXS(XS_XS__APItest__Hash_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1808 "APItest.xs"
        STRLEN len;
        const char *key;
#line 2498 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists",
				"hash");
		}
	} STMT_END
;
#line 1814 "APItest.xs"
        key = SvPV(key_sv, len);
        RETVAL = hv_exists(hash, key, UTF8KLEN(key_sv, len));
#line 2520 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_exists_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1822 "APItest.xs"
#line 2535 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists_ent",
				"hash");
		}
	} STMT_END
;
#line 1826 "APItest.xs"
        RETVAL = hv_exists_ent(hash, key_sv, 0);
#line 2556 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
#line 1833 "APItest.xs"
        STRLEN len;
        const char *key;
#line 2573 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1840 "APItest.xs"
        key = SvPV(key_sv, len);
        /* It's already mortal, so need to increase reference count.  */
        RETVAL
            = SvREFCNT_inc(hv_delete(hash, key, UTF8KLEN(key_sv, len), flags));
#line 2605 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete_ent)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete_ent",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1854 "APItest.xs"
        /* It's already mortal, so need to increase reference count.  */
        RETVAL = SvREFCNT_inc(hv_delete_ent(hash, key_sv, flags, 0));
#line 2649 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store_ent)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key, value");
    {
#line 1862 "APItest.xs"
        SV *copy;
        HE *result;
#line 2667 "APItest.c"
	HV *	hash;
	SV *	key = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store_ent",
				"hash");
		}
	} STMT_END
;
#line 1869 "APItest.xs"
        copy = newSV(0);
        result = hv_store_ent(hash, key, copy, 0);
        SvSetMagicSV(copy, value);
        if (!result) {
            SvREFCNT_dec(copy);
            XSRETURN_EMPTY;
        }
        /* It's about to become mortal, so need to increase reference count.
         */
        RETVAL = SvREFCNT_inc(HeVAL(result));
#line 2699 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key_sv, value");
    {
#line 1885 "APItest.xs"
        STRLEN len;
        const char *key;
        SV *copy;
        SV **result;
#line 2719 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store",
				"hash");
		}
	} STMT_END
;
#line 1894 "APItest.xs"
        key = SvPV(key_sv, len);
        copy = newSV(0);
        result = hv_store(hash, key, UTF8KLEN(key_sv, len), copy, 0);
        SvSetMagicSV(copy, value);
        if (!result) {
            SvREFCNT_dec(copy);
            XSRETURN_EMPTY;
        }
        /* It's about to become mortal, so need to increase reference count.
         */
        RETVAL = SvREFCNT_inc(*result);
#line 2752 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1911 "APItest.xs"
        HE *result;
#line 2769 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch_ent",
				"hash");
		}
	} STMT_END
;
#line 1916 "APItest.xs"
        result = hv_fetch_ent(hash, key_sv, 0, 0);
        if (!result) {
            XSRETURN_EMPTY;
        }
        /* Force mg_get  */
        RETVAL = newSVsv(HeVAL(result));
#line 2795 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1928 "APItest.xs"
        STRLEN len;
        const char *key;
        SV **result;
#line 2814 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch",
				"hash");
		}
	} STMT_END
;
#line 1935 "APItest.xs"
        key = SvPV(key_sv, len);
        result = hv_fetch(hash, key, UTF8KLEN(key_sv, len), 0);
        if (!result) {
            XSRETURN_EMPTY;
        }
        /* Force mg_get  */
        RETVAL = newSVsv(*result);
#line 2841 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_common); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_common)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "params");
    {
	HV *	params;
#line 1950 "APItest.xs"
        HE *result;
        HV *hv = NULL;
        SV *keysv = NULL;
        const char *key = NULL;
        STRLEN klen = 0;
        int flags = 0;
        int action = 0;
        SV *val = NULL;
        U32 hash = 0;
        SV **svp;
#line 2868 "APItest.c"
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    params = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::common",
				"params");
		}
	} STMT_END
;
#line 1961 "APItest.xs"
        if ((svp = hv_fetchs(params, "hv", 0))) {
            SV *const rv = *svp;
            if (!SvROK(rv))
                croak("common passed a non-reference for parameter hv");
            hv = (HV *)SvRV(rv);
        }
        if ((svp = hv_fetchs(params, "keysv", 0)))
            keysv = *svp;
        if ((svp = hv_fetchs(params, "keypv", 0))) {
            key = SvPV_const(*svp, klen);
            if (SvUTF8(*svp))
                flags = HVhek_UTF8;
        }
        if ((svp = hv_fetchs(params, "action", 0)))
            action = SvIV(*svp);
        if ((svp = hv_fetchs(params, "val", 0)))
            val = newSVsv(*svp);
        if ((svp = hv_fetchs(params, "hash", 0)))
            hash = SvUV(*svp);

        if (hv_fetchs(params, "hash_pv", 0)) {
            assert(key);
            PERL_HASH(hash, key, klen);
        }
        if (hv_fetchs(params, "hash_sv", 0)) {
            assert(keysv);
            {
              STRLEN len;
              const char *const p = SvPV(keysv, len);
              PERL_HASH(hash, p, len);
            }
        }

        result = (HE *)hv_common(hv, keysv, key, klen, flags, action, val, hash);
        if (!result) {
            XSRETURN_EMPTY;
        }
        /* Force mg_get  */
        RETVAL = newSVsv(HeVAL(result));
#line 2924 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2006 "APItest.xs"
        test_freeent(&Perl_hv_free_ent);
        XSRETURN(4);
#line 2944 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2012 "APItest.xs"
        test_freeent(&Perl_hv_delayfree_ent);
        XSRETURN(4);
#line 2963 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "input");
    {
#line 2018 "APItest.xs"
        STRLEN len;
        U32 hash;
        char *pvx;
        char *p;
#line 2982 "APItest.c"
	SV *	input = ST(0)
;
	SV *	RETVAL;
#line 2025 "APItest.xs"
        pvx = SvPV(input, len);
        PERL_HASH(hash, pvx, len);
        p = sharepvn(pvx, len, hash);
        RETVAL = newSVpvn(p, len);
        unsharepvn(p, len, hash);
#line 2992 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	bool	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 2038 "APItest.xs"
        if (level) {
            croak("level must be zero, not %" IVdf, level);
        }
        RETVAL = (cop_hints_fetch_sv(PL_curcop, key, 0, 0) != &PL_sv_placeholder);
#line 3023 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	SV *	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 2050 "APItest.xs"
        if (level) {
            croak("level must be zero, not %" IVdf, level);
        }
        RETVAL = cop_hints_fetch_sv(PL_curcop, key, 0, 0);
        SvREFCNT_inc(RETVAL);
#line 3054 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_test_force_keys); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_force_keys)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2061 "APItest.xs"
        HE *he;
        SSize_t count = 0;
#line 3074 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::test_force_keys",
				"hv");
		}
	} STMT_END
;
#line 2064 "APItest.xs"
        hv_iterinit(hv);
        he = hv_iternext(hv);
        while (he) {
            SV *sv = HeSVKEY_force(he);
            ++count;
            EXTEND(SP, count);
            PUSHs(sv_mortalcopy(sv));
            he = hv_iternext(hv);
        }
#line 3100 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
#line 2093 "APItest.xs"
        SV * const lv = newSV_type(SVt_PVLV);
        STRLEN len;
#line 3121 "APItest.c"
#line 2096 "APItest.xs"
        SvPV(sv, len);

        sv_magic(lv, NULL, PERL_MAGIC_substr, NULL, 0);
        LvTYPE(lv) = 'x';
        LvTARG(lv) = SvREFCNT_inc_simple(sv);
        LvTARGOFF(lv) = len == 0 ? 0 : 1;
        LvTARGLEN(lv) = len < 2 ? 0 : len-2;

        EXTEND(SP, 1);
        ST(0) = sv_2mortal(lv);
        XSRETURN(1);
#line 3134 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "classname");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	classname = (const char *)SvPV_nolen(ST(0))
;
#line 2115 "APItest.xs"
    PUSHs(sv_setref_pv(sv_newmortal(), classname, (void*)ptr_table_new()));
#line 3154 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"XS::APItest::PtrTable::DESTROY",
			"table")
;
#line 2121 "APItest.xs"
    ptr_table_free(table);
#line 3181 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "table, from, to");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	SVREF	to;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"XS::APItest::PtrTable::store",
			"table", "XS::APItest::PtrTable",
			refstr, ST(0)
		);
	}
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"from");
		}
	} STMT_END
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(2);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    to = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"to");
		}
	} STMT_END
;
#line 2129 "APItest.xs"
   ptr_table_store(table, from, to);
#line 3241 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "table, from");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	UV	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"XS::APItest::PtrTable::fetch",
			"table", "XS::APItest::PtrTable",
			refstr, ST(0)
		);
	}
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::fetch",
				"from");
		}
	} STMT_END
;
#line 2136 "APItest.xs"
   RETVAL = PTR2UV(ptr_table_fetch(table, from));
#line 3288 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__PtrTable_split); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_split)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"XS::APItest::PtrTable::split",
			"table", "XS::APItest::PtrTable",
			refstr, ST(0)
		);
	}
;

	ptr_table_split(table);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 2149 "APItest.xs"
        RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 3335 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	RETVAL;
#line 2157 "APItest.xs"
        PERL_UNUSED_ARG(items);
        RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 3354 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_ops); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_ops)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2178 "APItest.xs"
        RETVAL = PL_custom_ops;
#line 3372 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2185 "APItest.xs"
        PL_custom_op_names = newHV();
        RETVAL = PL_custom_op_names;
#line 3395 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_descs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_descs)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2193 "APItest.xs"
        PL_custom_op_descs = newHV();
        RETVAL = PL_custom_op_descs;
#line 3418 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_register)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2201 "APItest.xs"
        XopENTRY_set(&my_xop, xop_name, "my_xop");
        XopENTRY_set(&my_xop, xop_desc, "XOP for testing");
        XopENTRY_set(&my_xop, xop_class, OA_UNOP);
        XopENTRY_set(&my_xop, xop_peep, peep_xop);
        Perl_custom_op_register(aTHX_ pp_xop, &my_xop);
#line 3443 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_clear)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2210 "APItest.xs"
        XopDISABLE(&my_xop, xop_name);
        XopDISABLE(&my_xop, xop_desc);
        XopDISABLE(&my_xop, xop_class);
        XopDISABLE(&my_xop, xop_peep);
#line 3461 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_my_xop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_my_xop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2218 "APItest.xs"
        RETVAL = PTR2IV(&my_xop);
#line 3478 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_ppaddr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_ppaddr)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2225 "APItest.xs"
        RETVAL = PTR2IV(pp_xop);
#line 3497 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_OA_UNOP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_OA_UNOP)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2232 "APItest.xs"
        RETVAL = OA_UNOP;
#line 3516 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_build_optree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_build_optree)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 2239 "APItest.xs"
        dMY_CXT;
        UNOP *unop;
        OP *kid;

        MY_CXT.xop_record = newAV();

        kid = newSVOP(OP_CONST, 0, newSViv(42));

        unop = (UNOP*)mkUNOP(OP_CUSTOM, kid);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;
        kid->op_next        = (OP*)unop;

        av_push(MY_CXT.xop_record, newSVpvf("unop:%" UVxf, PTR2UV(unop)));
        av_push(MY_CXT.xop_record, newSVpvf("kid:%" UVxf, PTR2UV(kid)));

        av_push(MY_CXT.xop_record, newSVpvf("NAME:%s", OP_NAME((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("DESC:%s", OP_DESC((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("CLASS:%d", (int)OP_CLASS((OP*)unop)));

        PL_rpeepp(aTHX_ kid);

        FreeOp(kid);
        FreeOp(unop);

        RETVAL = MY_CXT.xop_record;
        MY_CXT.xop_record = NULL;
#line 3561 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_from_custom_op); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_from_custom_op)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2273 "APItest.xs"
/* author note: this test doesn't imply Perl_custom_op_xop is or isn't public
   API or that Perl_custom_op_xop is known to be used outside the core */
        UNOP *unop;
        XOP *xop;

        unop = (UNOP*)mkUNOP(OP_CUSTOM, NULL);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;

        xop = Perl_custom_op_xop(aTHX_ (OP *)unop);
        FreeOp(unop);
        RETVAL = PTR2IV(xop);
#line 3596 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 2325 "APItest.xs"
    MY_CXT_CLONE;
    PERL_UNUSED_VAR(items);
    MY_CXT.sv = newSVpv("initial_clone",0);
    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = NULL;
    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;
    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();
#line 3622 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_double)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	double	val = (double)SvNV(ST(0))
;
#line 2340 "APItest.xs"
        printf("%5.3f\n",val);
#line 3639 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_have_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_have_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2345 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 3660 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_print_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2356 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
#   if defined(PERL_PRIfldbl) && (LONG_DOUBLESIZE > DOUBLESIZE)
        long double val = 7.0;
        printf("%5.3" PERL_PRIfldbl "\n",val);
#   else
        double val = 7.0;
        printf("%5.3f\n",val);
#   endif
#endif
#line 3685 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_long_doubleL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long_doubleL)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2369 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
        /* used to test we allow the length modifier required by the standard */
        long double val = 7.0;
        printf("%5.3Lf\n",val);
#else
        double val = 7.0;
        printf("%5.3f\n",val);
#endif
#line 3707 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_int)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	int	val = (int)SvIV(ST(0))
;
#line 2382 "APItest.xs"
        printf("%d\n",val);
#line 3724 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	long	val = (long)SvIV(ST(0))
;
#line 2388 "APItest.xs"
        printf("%ld\n",val);
#line 3741 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_float); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_float)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	float	val = (float)SvNV(ST(0))
;
#line 2394 "APItest.xs"
        printf("%5.3f\n",val);
#line 3758 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_flush)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2399 "APItest.xs"
        fflush(stdout);
#line 3773 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_mpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2404 "APItest.xs"
        EXTEND(SP, 3);
        mPUSHp("one", 3);
        mPUSHp("two", 3);
        mPUSHp("three", 5);
        XSRETURN(3);
#line 3794 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2413 "APItest.xs"
        EXTEND(SP, 3);
        mPUSHn(0.5);
        mPUSHn(-0.25);
        mPUSHn(0.125);
        XSRETURN(3);
#line 3816 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2422 "APItest.xs"
        EXTEND(SP, 3);
        mPUSHi(-1);
        mPUSHi(2);
        mPUSHi(-3);
        XSRETURN(3);
#line 3838 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2431 "APItest.xs"
        EXTEND(SP, 3);
        mPUSHu(1);
        mPUSHu(2);
        mPUSHu(3);
        XSRETURN(3);
#line 3860 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2440 "APItest.xs"
        mXPUSHp("one", 3);
        mXPUSHp("two", 3);
        mXPUSHp("three", 5);
        XSRETURN(3);
#line 3881 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2448 "APItest.xs"
        mXPUSHn(0.5);
        mXPUSHn(-0.25);
        mXPUSHn(0.125);
        XSRETURN(3);
#line 3902 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2456 "APItest.xs"
        mXPUSHi(-1);
        mXPUSHi(2);
        mXPUSHi(-3);
        XSRETURN(3);
#line 3923 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2464 "APItest.xs"
        mXPUSHu(1);
        mXPUSHu(2);
        mXPUSHu(3);
        XSRETURN(3);
#line 3944 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_test_EXTEND); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_EXTEND)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "max_offset, nsv, use_ss");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	max_offset = (IV)SvIV(ST(0))
;
	SV *	nsv = ST(1)
;
	bool	use_ss = (bool)SvTRUE(ST(2))
;
#line 2487 "APItest.xs"
    SV **sp = PL_stack_max + max_offset;
#line 3968 "APItest.c"
#line 2489 "APItest.xs"
    if (use_ss) {
        SSize_t n = (SSize_t)SvIV(nsv);
        EXTEND(sp, n);
        *(sp + n) = NULL;
    }
    else {
        IV n = SvIV(nsv);
        EXTEND(sp, n);
        *(sp + n) = NULL;
    }
    *PL_stack_max = NULL;
#line 3981 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_sv_C); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv_C)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2505 "APItest.xs"
    CV * i_sub;
    GV * i_gv;
    I32 retcnt;
    SV * errsv;
    char * errstr;
    STRLEN errlen;
    SV * miscsv = sv_newmortal();
    HV * hv = (HV*)sv_2mortal((SV*)newHV());
#line 4004 "APItest.c"
#line 2514 "APItest.xs"
    i_sub = get_cv("i", 0);
    PUSHMARK(SP);
    /* PUTBACK not needed since this sub was called with 0 args, and is calling
      0 args, so global SP doesn't need to be moved before a call_* */
    retcnt = call_sv((SV*)i_sub, 0); /* try a CV* */
    SPAGAIN;
    SP -= retcnt; /* dont care about return count, wipe everything off */
    sv_setpvs(miscsv, "i");
    PUSHMARK(SP);
    retcnt = call_sv(miscsv, 0); /* try a PV */
    SPAGAIN;
    SP -= retcnt;
    /* no add and SVt_NULL are intentional, sub i should be defined already */
    i_gv = gv_fetchpvn_flags("i", sizeof("i")-1, 0, SVt_NULL);
    PUSHMARK(SP);
    retcnt = call_sv((SV*)i_gv, 0); /* try a GV* */
    SPAGAIN;
    SP -= retcnt;
    /* the tests below are not declaring this being public API behavior,
       only current internal behavior, these tests can be changed in the
       future if necessery */
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_yes, G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Undefined subroutine &main::1 called at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_no, G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Undefined subroutine &main:: called at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_undef,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Can't use an undefined value as a subroutine reference at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv((SV*)hv,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Not a CODE reference at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
#line 4075 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_call_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "sv, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2589 "APItest.xs"
        I32 i;
#line 4096 "APItest.c"
#line 2591 "APItest.xs"
        for (i=0; i<items-2; i++)
            ST(i) = ST(i+2); /* pop first two args */
        PUSHMARK(SP);
        SP += items - 2;
        PUTBACK;
        i = call_sv(sv, flags);
        SPAGAIN;
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSViv(i)));
#line 4107 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_pv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "subname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	subname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2606 "APItest.xs"
        I32 i;
#line 4129 "APItest.c"
#line 2608 "APItest.xs"
        for (i=0; i<items-2; i++)
            ST(i) = ST(i+2); /* pop first two args */
        PUSHMARK(SP);
        SP += items - 2;
        PUTBACK;
        i = call_pv(subname, flags);
        SPAGAIN;
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSViv(i)));
#line 4140 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_argv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_argv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "subname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	subname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2623 "APItest.xs"
        I32 i;
        char *tmpary[4];
#line 4163 "APItest.c"
#line 2626 "APItest.xs"
        for (i=0; i<items-2; i++)
            tmpary[i] = SvPV_nolen(ST(i+2)); /* ignore first two args */
        tmpary[i] = NULL;
        PUTBACK;
        i = call_argv(subname, flags, tmpary);
        SPAGAIN;
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSViv(i)));
#line 4173 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_method)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "methname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	methname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2640 "APItest.xs"
        I32 i;
#line 4195 "APItest.c"
#line 2642 "APItest.xs"
        for (i=0; i<items-2; i++)
            ST(i) = ST(i+2); /* pop first two args */
        PUSHMARK(SP);
        SP += items - 2;
        PUTBACK;
        i = call_method(methname, flags);
        SPAGAIN;
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSViv(i)));
#line 4206 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_newCONSTSUB); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newCONSTSUB)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 4)
       croak_xs_usage(cv,  "stash, name, flags, sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	name = ST(1)
;
	I32	flags = (I32)SvIV(ST(2))
;
	SV*	sv = ST(3)
;
#line 2661 "APItest.xs"
        CV* mycv = NULL;
        STRLEN len;
        const char *pv = SvPV(name, len);
#line 4234 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				GvNAME(CvGV(cv)),
				"stash");
		}
	} STMT_END
;
#line 2665 "APItest.xs"
        switch (ix) {
           case 0:
               mycv = newCONSTSUB(stash, pv, SvOK(sv) ? SvREFCNT_inc(sv) : NULL);
               break;
           case 1:
               mycv = newCONSTSUB_flags(
                 stash, pv, len, flags | SvUTF8(name), SvOK(sv) ? SvREFCNT_inc(sv) : NULL
               );
               break;
        }
        EXTEND(SP, 2);
        assert(mycv);
        PUSHs( CvCONST(mycv) ? &PL_sv_yes : &PL_sv_no );
        PUSHs((SV*)CvGV(mycv));
#line 4264 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_init_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_init_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "namesv, multi, flags, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	multi = (int)SvIV(ST(1))
;
	I32	flags = (I32)SvIV(ST(2))
;
	int	type = (int)SvIV(ST(3))
;
#line 2687 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        GV *gv = *(GV**)hv_fetch(PL_defstash, name, len, TRUE);
#line 4292 "APItest.c"
#line 2691 "APItest.xs"
        if (SvTYPE(gv) == SVt_PVGV)
            Perl_croak(aTHX_ "GV is already a PVGV");
        if (multi) flags |= GV_ADDMULTI;
        switch (type) {
           case 0:
               gv_init(gv, PL_defstash, name, len, multi);
               break;
           case 1:
               gv_init_sv(gv, PL_defstash, namesv, flags);
               break;
           case 2:
               gv_init_pv(gv, PL_defstash, name, flags | SvUTF8(namesv));
               break;
           case 3:
               gv_init_pvn(gv, PL_defstash, name, len, flags | SvUTF8(namesv));
               break;
        }
        XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4312 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2718 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
        GV* gv = NULL;
#line 4341 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_type",
				"stash");
		}
	} STMT_END
;
#line 2722 "APItest.xs"
        switch (type) {
           case 0:
               gv = gv_fetchmeth(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
        XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 4372 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2746 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
        GV* gv = NULL;
#line 4401 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2750 "APItest.xs"
        switch (type) {
           case 0:
               gv = gv_fetchmeth_autoload(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv_autoload(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv_autoload(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn_autoload(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
        XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 4432 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	flags = (I32)SvIV(ST(3))
;
#line 2773 "APItest.xs"
        GV* gv = NULL;
#line 4457 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmethod_flags_type",
				"stash");
		}
	} STMT_END
;
#line 2775 "APItest.xs"
        switch (type) {
           case 0:
               gv = gv_fetchmethod_flags(stash, SvPVX_const(methname), flags);
               break;
           case 1:
               gv = gv_fetchmethod_sv_flags(stash, methname, flags);
               break;
           case 2:
               gv = gv_fetchmethod_pv_flags(stash, SvPV_nolen(methname), flags | SvUTF8(methname));
               break;
           case 3: {
               STRLEN len;
               const char * const name = SvPV_const(methname, len);
               gv = gv_fetchmethod_pvn_flags(stash, name, len, flags | SvUTF8(methname));
               break;
            }
           case 4:
               gv = gv_fetchmethod_pvn_flags(stash, SvPV_nolen(methname),
                                             flags, SvUTF8(methname));
        }
        XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4494 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, method");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	method = (I32)SvIV(ST(3))
;
#line 2804 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
        GV* gv = NULL;
        I32 flags = method ? GV_AUTOLOAD_ISMETHOD : 0;
#line 4522 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2809 "APItest.xs"
        switch (type) {
           case 0:
               gv = gv_autoload4(stash, name, len, method);
               break;
           case 1:
               gv = gv_autoload_sv(stash, methname, flags);
               break;
           case 2:
               gv = gv_autoload_pv(stash, name, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_autoload_pvn(stash, name, len, flags | SvUTF8(methname));
               break;
        }
        XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4553 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_const_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_const_sv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
#line 2828 "APItest.xs"
        GV *gv;
#line 4569 "APItest.c"
	SV *	RETVAL;
	SV *	name = ST(0)
;
#line 2830 "APItest.xs"
        if (SvPOK(name)) {
            HV *stash = gv_stashpv("main",0);
            HE *he = hv_fetch_ent(stash, name, 0, 0);
            gv = (GV *)HeVAL(he);
        }
        else {
            gv = (GV *)name;
        }
        RETVAL = gv_const_sv(gv);
        if (!RETVAL)
            XSRETURN_EMPTY;
        RETVAL = newSVsv(RETVAL);
#line 4586 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_whichsig_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_whichsig_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "namesv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 2850 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        I32 i = 0;
#line 4611 "APItest.c"
#line 2854 "APItest.xs"
        switch (type) {
           case 0:
              i = whichsig(name);
               break;
           case 1:
               i = whichsig_sv(namesv);
               break;
           case 2:
               i = whichsig_pv(name);
               break;
           case 3:
               i = whichsig_pvn(name, len);
               break;
        }
        XPUSHs(sv_2mortal(newSViv(i)));
#line 4628 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_sv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2875 "APItest.xs"
        I32 i;
#line 4650 "APItest.c"
#line 2877 "APItest.xs"
        PUTBACK;
        i = eval_sv(sv, flags);
        SPAGAIN;
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSViv(i)));
#line 4657 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_pv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, croak_on_error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	p = (const char *)SvPV_nolen(ST(0))
;
	I32	croak_on_error = (I32)SvIV(ST(1))
;
#line 2888 "APItest.xs"
        PUTBACK;
        EXTEND(SP, 1);
        PUSHs(eval_pv(p, croak_on_error));
#line 4681 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_require_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_require_pv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	pv = (const char *)SvPV_nolen(ST(0))
;
#line 2896 "APItest.xs"
        PUTBACK;
        require_pv(pv);
#line 4702 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_apitest_exception); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_apitest_exception)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "throw_e");
    {
	int	throw_e = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = apitest_exception(throw_e);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_mycroak); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mycroak)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV*	sv = ST(0)
;
#line 2909 "APItest.xs"
    if (SvOK(sv)) {
        Perl_croak(aTHX_ "%s", SvPV_nolen(sv));
    }
    else {
        Perl_croak(aTHX_ NULL);
    }
#line 4745 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_strtab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_strtab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 2919 "APItest.xs"
   RETVAL = newRV_inc((SV*)PL_strtab);
#line 4761 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_getint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getint)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2926 "APItest.xs"
        dMY_CXT;
        RETVAL = my_cxt_getint_p(aMY_CXT);
#line 4781 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_setint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setint)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	int	i = (int)SvIV(ST(0))
;
#line 2935 "APItest.xs"
        dMY_CXT;
        my_cxt_setint_p(aMY_CXT_ i);
#line 4801 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_my_cxt_getsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "how");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	bool	how = (bool)SvTRUE(ST(0))
;
#line 2942 "APItest.xs"
        EXTEND(SP, 1);
        ST(0) = how ? my_cxt_getsv_interp_context() : my_cxt_getsv_interp();
        XSRETURN(1);
#line 4822 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_cxt_setsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 2950 "APItest.xs"
        dMY_CXT;
        SvREFCNT_dec(MY_CXT.sv);
        my_cxt_setsv_p(sv _aMY_CXT);
        SvREFCNT_inc(sv);
#line 4843 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_core();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_notcore();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_set_deref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_set_deref)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sv, sv2, which");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
	int	which = (int)SvIV(ST(2))
;
#line 2964 "APItest.xs"
    {
        STRLEN len;
        const char *pv = SvPV(sv2,len);
        if (!SvROK(sv)) croak("Not a ref");
        sv = SvRV(sv);
        switch (which) {
            case 0: sv_setsv(sv,sv2); break;
            case 1: sv_setpv(sv,pv); break;
            case 2: sv_setpvn(sv,pv,len); break;
        }
    }
#line 4906 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_rmagical_cast); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_cast)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	SV *	type = ST(1)
;
#line 2981 "APItest.xs"
        struct ufuncs uf;
#line 4927 "APItest.c"
#line 2983 "APItest.xs"
        if (!SvOK(sv) || !SvROK(sv) || !SvOK(type)) { XSRETURN_UNDEF; }
        sv = SvRV(sv);
        if (SvTYPE(sv) != SVt_PVHV) { XSRETURN_UNDEF; }
        uf.uf_val = rmagical_a_dummy;
        uf.uf_set = NULL;
        uf.uf_index = 0;
        if (SvTRUE(type)) { /* b */
            sv_magicext(sv, NULL, PERL_MAGIC_ext, &rmagical_b, NULL, 0);
        } else { /* a */
            sv_magic(sv, NULL, PERL_MAGIC_uvar, (char *) &uf, sizeof(uf));
        }
        XSRETURN_YES;
#line 4941 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_rmagical_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_flags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 3000 "APItest.xs"
        if (!SvOK(sv) || !SvROK(sv)) { XSRETURN_UNDEF; }
        sv = SvRV(sv);
        EXTEND(SP, 3);
        mXPUSHu(SvFLAGS(sv) & SVs_GMG);
        mXPUSHu(SvFLAGS(sv) & SVs_SMG);
        mXPUSHu(SvFLAGS(sv) & SVs_RMG);
        XSRETURN(3);
#line 4967 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_caller); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_caller)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "level");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	I32	level = (I32)SvIV(ST(0))
;
#line 3012 "APItest.xs"
        const PERL_CONTEXT *cx, *dbcx;
        const char *pv;
        const GV *gv;
        HV *hv;
#line 4990 "APItest.c"
#line 3017 "APItest.xs"
        cx = caller_cx(level, &dbcx);
        EXTEND(SP, 8);

        pv = CopSTASHPV(cx->blk_oldcop);
        ST(0) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(cx->blk_sub.cv);
        ST(1) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        pv = CopSTASHPV(dbcx->blk_oldcop);
        ST(2) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(dbcx->blk_sub.cv);
        ST(3) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        ST(4) = cop_hints_fetch_pvs(cx->blk_oldcop, "foo", 0);
        ST(5) = cop_hints_fetch_pvn(cx->blk_oldcop, "foo", 3, 0, 0);
        ST(6) = cop_hints_fetch_sv(cx->blk_oldcop,
                sv_2mortal(newSVpvs("foo")), 0, 0);

        hv = cop_hints_2hv(cx->blk_oldcop, 0);
        ST(7) = hv ? sv_2mortal(newRV_noinc((SV *)hv)) : &PL_sv_undef;

        XSRETURN(8);
#line 5014 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_DPeek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_DPeek)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 3045 "APItest.xs"
    ST (0) = newSVpv (Perl_sv_peek (aTHX_ sv), 0);
    XSRETURN (1);
#line 5035 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_BEGIN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_BEGIN)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3051 "APItest.xs"
        sv_inc(get_sv("XS::APItest::BEGIN_called", GV_ADD|GV_ADDMULTI));
#line 5051 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_CHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3056 "APItest.xs"
        sv_inc(get_sv("XS::APItest::CHECK_called", GV_ADD|GV_ADDMULTI));
#line 5066 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_UNITCHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_UNITCHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3061 "APItest.xs"
        sv_inc(get_sv("XS::APItest::UNITCHECK_called", GV_ADD|GV_ADDMULTI));
#line 5081 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_INIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_INIT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3066 "APItest.xs"
        sv_inc(get_sv("XS::APItest::INIT_called", GV_ADD|GV_ADDMULTI));
#line 5096 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_END); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_END)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3071 "APItest.xs"
        sv_inc(get_sv("XS::APItest::END_called", GV_ADD|GV_ADDMULTI));
#line 5111 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_utf16_to_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_utf16_to_utf8)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV*	sv = ST(0)
;
#line 3079 "APItest.xs"
        STRLEN len;
        U8 *source;
        SV *dest;
        Size_t got;
#line 5132 "APItest.c"
#line 3084 "APItest.xs"
        source = (U8 *)SvPVbyte(sv, len);
        /* Optionally only convert part of the buffer.  */
        if (items > 1) {
            len = SvUV(ST(1));
        }
        /* Mortalise this right now, as we'll be testing croak()s  */
        dest = sv_2mortal(newSV(len * 2 + 1));
        if (ix) {
            utf16_to_utf8_reversed(source, (U8 *)SvPVX(dest), len, &got);
        } else {
            utf16_to_utf8(source, (U8 *)SvPVX(dest), len, &got);
        }
        SvCUR_set(dest, got);
        SvPVX(dest)[got] = '\0';
        SvPOK_on(dest);
        ST(0) = dest;
        XSRETURN(1);
#line 5151 "APItest.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_utf8_to_utf16); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_utf8_to_utf16)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV*	sv = ST(0)
;
#line 3108 "APItest.xs"
        STRLEN len;
        U8 *source;
        SV *dest;
        Size_t got;
#line 5172 "APItest.c"
#line 3113 "APItest.xs"
        source = (U8 *)SvPV(sv, len);
        /* Optionally only convert part of the buffer.  */
        if (items > 1) {
            len = SvUV(ST(1));
        }
        /* Mortalise this right now, as we'll be testing croak()s  */
        dest = sv_2mortal(newSV(len * 2 + 1));
        if (ix) {
            utf8_to_utf16_reversed(source, (U8 *)SvPVX(dest), len, &got);
        } else {
            utf8_to_utf16(source, (U8 *)SvPVX(dest), len, &got);
        }
        SvCUR_set(dest, got);
        SvPVX(dest)[got] = '\0';
        SvPOK_on(dest);
        ST(0) = dest;
        XSRETURN(1);
#line 5191 "APItest.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_exit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "exitcode");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	exitcode = (int)SvIV(ST(0))
;
#line 3134 "APItest.xs"
        my_exit(exitcode);
#line 5210 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_first_byte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_first_byte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
	U8	RETVAL;
	dXSTARG;
#line 3140 "APItest.xs"
    char *s;
    STRLEN len;
        s = SvPVbyte(sv, len);
        RETVAL = s[0];
#line 5233 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_count)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	I32	RETVAL;
	dXSTARG;
#line 3150 "APItest.xs"
            RETVAL = PL_sv_count;
#line 5252 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_bhk_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_bhk_record)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "on");
    {
	bool	on = (bool)SvTRUE(ST(0))
;
#line 3157 "APItest.xs"
        dMY_CXT;
        MY_CXT.bhk_record = on;
        if (on)
            av_clear(MY_CXT.bhkav);
#line 5274 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_magic_chain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_magic_chain)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3165 "APItest.xs"
        SV *sv;
        MAGIC *callmg, *uvarmg;
#line 5290 "APItest.c"
#line 3168 "APItest.xs"
        sv = sv_2mortal(newSV(0));
        if (SvTYPE(sv) >= SVt_PVMG) croak_fail();
        if (SvMAGICAL(sv)) croak_fail();
        sv_magic(sv, &PL_sv_yes, PERL_MAGIC_checkcall, (char*)&callmg, 0);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
        callmg = mg_find(sv, PERL_MAGIC_checkcall);
        if (!callmg) croak_fail();
        if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
            croak_fail();
        sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
        uvarmg = mg_find(sv, PERL_MAGIC_uvar);
        if (!uvarmg) croak_fail();
        if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
            croak_fail();
        if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
            croak_fail();
        mg_free_type(sv, PERL_MAGIC_vec);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
        if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
        if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
            croak_fail();
        if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
            croak_fail();
        mg_free_type(sv, PERL_MAGIC_uvar);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
        if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
        if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
            croak_fail();
        sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
        uvarmg = mg_find(sv, PERL_MAGIC_uvar);
        if (!uvarmg) croak_fail();
        if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
            croak_fail();
        if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
            croak_fail();
        mg_free_type(sv, PERL_MAGIC_checkcall);
        if (SvTYPE(sv) < SVt_PVMG) croak_fail();
        if (!SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
        if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
            croak_fail();
        mg_free_type(sv, PERL_MAGIC_uvar);
        if (SvMAGICAL(sv)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
        if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
#line 5350 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_contextualize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_contextualize)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3230 "APItest.xs"
        OP *o;
#line 5365 "APItest.c"
#line 3232 "APItest.xs"
        o = newSVOP(OP_CONST, 0, newSViv(0));
        o->op_flags &= ~OPf_WANT;
        o = op_contextualize(o, G_SCALAR);
        if (o->op_type != OP_CONST ||
                (o->op_flags & OPf_WANT) != OPf_WANT_SCALAR)
            croak_fail();
        op_free(o);
        o = newSVOP(OP_CONST, 0, newSViv(0));
        o->op_flags &= ~OPf_WANT;
        o = op_contextualize(o, G_LIST);
        if (o->op_type != OP_CONST ||
                (o->op_flags & OPf_WANT) != OPf_WANT_LIST)
            croak_fail();
        op_free(o);
        o = newSVOP(OP_CONST, 0, newSViv(0));
        o->op_flags &= ~OPf_WANT;
        o = op_contextualize(o, G_VOID);
        if (o->op_type != OP_NULL) croak_fail();
        op_free(o);
#line 5386 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3256 "APItest.xs"
        GV *troc_gv;
        CV *troc_cv;
        OP *o;
#line 5403 "APItest.c"
#line 3260 "APItest.xs"
        troc_gv = gv_fetchpv("XS::APItest::test_rv2cv_op_cv", 0, SVt_PVGV);
        troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
        o = newCVREF(0, newGVOP(OP_GV, 0, troc_gv));
        if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
            croak_fail();
        o->op_private |= OPpENTERSUB_AMPER;
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        o->op_private &= ~OPpENTERSUB_AMPER;
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        op_free(o);
        o = newSVOP(OP_CONST, 0, newSVpv("XS::APItest::test_rv2cv_op_cv", 0));
        o->op_private = OPpCONST_BARE;
        o = newCVREF(0, o);
        if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
            croak_fail();
        o->op_private |= OPpENTERSUB_AMPER;
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        op_free(o);
        o = newCVREF(0, newSVOP(OP_CONST, 0, newRV_inc((SV*)troc_cv)));
        if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
            croak_fail();
        o->op_private |= OPpENTERSUB_AMPER;
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        o->op_private &= ~OPpENTERSUB_AMPER;
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        op_free(o);
        o = newCVREF(0, newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0))));
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        o->op_private |= OPpENTERSUB_AMPER;
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        o->op_private &= ~OPpENTERSUB_AMPER;
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY)) croak_fail();
        if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
        op_free(o);
        o = newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0)));
        if (rv2cv_op_cv(o, 0)) croak_fail();
        if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
        op_free(o);
#line 5456 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3315 "APItest.xs"
        CV *troc_cv, *tsh_cv;
        Perl_call_checker ckfun;
        SV *ckobj;
        U32 ckflags;
#line 5474 "APItest.c"
#line 3320 "APItest.xs"
#define check_cc(cv, xckfun, xckobj, xckflags) \
    do { \
        cv_get_call_checker((cv), &ckfun, &ckobj); \
        if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
        if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
        cv_get_call_checker_flags((cv), CALL_CHECKER_REQUIRE_GV, &ckfun, &ckobj, &ckflags); \
        if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
        if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
        if (ckflags != CALL_CHECKER_REQUIRE_GV) croak_fail_nei(ckflags, CALL_CHECKER_REQUIRE_GV); \
        cv_get_call_checker_flags((cv), 0, &ckfun, &ckobj, &ckflags); \
        if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
        if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
        if (ckflags != (xckflags)) croak_fail_nei(ckflags, (xckflags)); \
    } while(0)
        troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
        tsh_cv = get_cv("XS::APItest::test_savehints", 0);
        check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
        cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    &PL_sv_yes);
        check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        cv_set_call_checker(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no);
        check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no, CALL_CHECKER_REQUIRE_GV);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    (SV*)tsh_cv);
        check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no, CALL_CHECKER_REQUIRE_GV);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
        cv_set_call_checker(troc_cv, Perl_ck_entersub_args_proto_or_list,
                                    (SV*)troc_cv);
        check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
        if (SvMAGICAL((SV*)troc_cv) || SvMAGIC((SV*)troc_cv)) croak_fail();
        if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
        cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    &PL_sv_yes, 0);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, 0);
        cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    (SV*)tsh_cv, 0);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
        if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
        cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
        cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
                                    (SV*)tsh_cv, CALL_CHECKER_REQUIRE_GV);
        check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
        if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
#undef check_cc
#line 5529 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_lists",
				"cv");
		}
	} STMT_END
;
#line 3377 "APItest.xs"
        cv_set_call_checker(cv, THX_ck_entersub_args_lists, &PL_sv_undef);
#line 5559 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_scalars",
				"cv");
		}
	} STMT_END
;
#line 3382 "APItest.xs"
        cv_set_call_checker(cv, THX_ck_entersub_args_scalars, &PL_sv_undef);
#line 5589 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto",
				"cv");
		}
	} STMT_END
;
#line 3387 "APItest.xs"
        if (SvROK(proto))
            proto = SvRV(proto);
        cv_set_call_checker(cv, Perl_ck_entersub_args_proto, proto);
#line 5623 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto_or_list",
				"cv");
		}
	} STMT_END
;
#line 3394 "APItest.xs"
        if (SvROK(proto))
            proto = SvRV(proto);
        cv_set_call_checker(cv, Perl_ck_entersub_args_proto_or_list, proto);
#line 5657 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_multi_sum",
				"cv");
		}
	} STMT_END
;
#line 3401 "APItest.xs"
        cv_set_call_checker(cv, THX_ck_entersub_multi_sum, &PL_sv_undef);
#line 5687 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cophh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cophh)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3406 "APItest.xs"
        COPHH *a, *b;
#ifdef EBCDIC
        SV* key_sv;
        char * key_name;
        STRLEN key_len;
#endif
#line 5707 "APItest.c"
#line 3413 "APItest.xs"
#define check_ph(EXPR) \
            do { if((EXPR) != &PL_sv_placeholder) croak("fail"); } while(0)
#define check_iv(EXPR, EXPECT) \
            do { if(SvIV(EXPR) != (EXPECT)) croak("fail"); } while(0)
#define msvpvs(STR) sv_2mortal(newSVpvs(STR))
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
        a = cophh_new_empty();
        check_ph(cophh_fetch_pvn(a, "foo_1", 5, 0, 0));
        check_ph(cophh_fetch_pvs(a, "foo_1", 0));
        check_ph(cophh_fetch_pv(a, "foo_1", 0, 0));
        check_ph(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0));
        a = cophh_store_pvn(a, "foo_1abc", 5, 0, msviv(111), 0);
        a = cophh_store_pvs(a, "foo_2", msviv(222), 0);
        a = cophh_store_pv(a, "foo_3", 0, msviv(333), 0);
        a = cophh_store_sv(a, msvpvs("foo_4"), 0, msviv(444), 0);
        check_iv(cophh_fetch_pvn(a, "foo_1xyz", 5, 0, 0), 111);
        check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
        check_iv(cophh_fetch_pv(a, "foo_1", 0, 0), 111);
        check_iv(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0), 111);
        check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
        check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
        check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
        check_ph(cophh_fetch_pvs(a, "foo_5", 0));
        b = cophh_copy(a);
        b = cophh_store_pvs(b, "foo_1", msviv(1111), 0);
        check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
        check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
        check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
        check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
        check_ph(cophh_fetch_pvs(a, "foo_5", 0));
        check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
        check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
        check_iv(cophh_fetch_pvs(b, "foo_3", 0), 333);
        check_iv(cophh_fetch_pvs(b, "foo_4", 0), 444);
        check_ph(cophh_fetch_pvs(b, "foo_5", 0));
        a = cophh_delete_pvn(a, "foo_1abc", 5, 0, 0);
        a = cophh_delete_pvs(a, "foo_2", 0);
        b = cophh_delete_pv(b, "foo_3", 0, 0);
        b = cophh_delete_sv(b, msvpvs("foo_4"), 0, 0);
        check_ph(cophh_fetch_pvs(a, "foo_1", 0));
        check_ph(cophh_fetch_pvs(a, "foo_2", 0));
        check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
        check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
        check_ph(cophh_fetch_pvs(a, "foo_5", 0));
        check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
        check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
        check_ph(cophh_fetch_pvs(b, "foo_3", 0));
        check_ph(cophh_fetch_pvs(b, "foo_4", 0));
        check_ph(cophh_fetch_pvs(b, "foo_5", 0));
        b = cophh_delete_pvs(b, "foo_3", 0);
        b = cophh_delete_pvs(b, "foo_5", 0);
        check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
        check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
        check_ph(cophh_fetch_pvs(b, "foo_3", 0));
        check_ph(cophh_fetch_pvs(b, "foo_4", 0));
        check_ph(cophh_fetch_pvs(b, "foo_5", 0));
        cophh_free(b);
        check_ph(cophh_fetch_pvs(a, "foo_1", 0));
        check_ph(cophh_fetch_pvs(a, "foo_2", 0));
        check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
        check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
        check_ph(cophh_fetch_pvs(a, "foo_5", 0));
        a = cophh_store_pvs(a, "foo_1", msviv(11111), COPHH_KEY_UTF8);
        a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
#else
        /* On EBCDIC, we need to translate the UTF-8 in the ASCII test to the
         * equivalent UTF-EBCDIC for the code page.  This is done at runtime
         * (with the helper function in this file).  Therefore we can't use
         * cophhh_store_pvs(), as we don't have literal string */
        key_sv = sv_2mortal(newSVpvs("foo_"));
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(456), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(789), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(666), COPHH_KEY_UTF8);
#endif
        check_iv(cophh_fetch_pvs(a, "foo_1", 0), 11111);
        check_iv(cophh_fetch_pvs(a, "foo_1", COPHH_KEY_UTF8), 11111);
        check_iv(cophh_fetch_pvs(a, "foo_\xaa", 0), 123);
#ifndef EBCDIC
        check_iv(cophh_fetch_pvs(a, "foo_\xc2\xaa", COPHH_KEY_UTF8), 123);
        check_ph(cophh_fetch_pvs(a, "foo_\xc2\xaa", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xaa"));
        key_name = SvPV(key_sv, key_len);
        check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 123);
        check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
        check_iv(cophh_fetch_pvs(a, "foo_\xbb", 0), 456);
#ifndef EBCDIC
        check_iv(cophh_fetch_pvs(a, "foo_\xc2\xbb", COPHH_KEY_UTF8), 456);
        check_ph(cophh_fetch_pvs(a, "foo_\xc2\xbb", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
        key_name = SvPV(key_sv, key_len);
        check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 456);
        check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
        check_iv(cophh_fetch_pvs(a, "foo_\xcc", 0), 789);
#ifndef EBCDIC
        check_iv(cophh_fetch_pvs(a, "foo_\xc3\x8c", COPHH_KEY_UTF8), 789);
        check_ph(cophh_fetch_pvs(a, "foo_\xc2\x8c", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
        key_name = SvPV(key_sv, key_len);
        check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 789);
        check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
#ifndef EBCDIC
        check_iv(cophh_fetch_pvs(a, "foo_\xd9\xa6", COPHH_KEY_UTF8), 666);
        check_ph(cophh_fetch_pvs(a, "foo_\xd9\xa6", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
        key_name = SvPV(key_sv, key_len);
        check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 666);
        check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
        ENTER;
        SAVEFREECOPHH(a);
        LEAVE;
#undef check_ph
#undef check_iv
#undef msvpvs
#undef msviv
#line 5853 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_coplabel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_coplabel)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3561 "APItest.xs"
        COP *cop;
        const char *label;
        STRLEN len;
        U32 utf8;
#line 5871 "APItest.c"
#line 3566 "APItest.xs"
        cop = &PL_compiling;
        Perl_cop_store_label(aTHX_ cop, "foo", 3, 0);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strNE(label,"foo")) croak("fail # cop_fetch_label label");
        if (len != 3) croak("fail # cop_fetch_label len");
        if (utf8) croak("fail # cop_fetch_label utf8");
        /* SMALL GERMAN UMLAUT A */
        Perl_cop_store_label(aTHX_ cop, "fo\xc3\xa4", 4, SVf_UTF8);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strNE(label,"fo\xc3\xa4")) croak("fail # cop_fetch_label label");
        if (len != 4) croak("fail # cop_fetch_label len");
        if (!utf8) croak("fail # cop_fetch_label utf8");
#line 5885 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_example_cophh_2hv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_example_cophh_2hv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3583 "APItest.xs"
        COPHH *a;
#ifdef EBCDIC
        SV* key_sv;
        char * key_name;
        STRLEN key_len;
#endif
#line 5905 "APItest.c"
	HV *	RETVAL;
#line 3590 "APItest.xs"
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
        a = cophh_new_empty();
        a = cophh_store_pvs(a, "foo_0", msviv(999), 0);
        a = cophh_store_pvs(a, "foo_1", msviv(111), 0);
        a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
#else
        key_sv = sv_2mortal(newSVpvs("foo_"));
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(456), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(789), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
        a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
        key_name = SvPV(key_sv, key_len);
        a = cophh_store_pvn(a, key_name, key_len, 0, msviv(666), COPHH_KEY_UTF8);
#endif
        a = cophh_delete_pvs(a, "foo_0", 0);
        a = cophh_delete_pvs(a, "foo_2", 0);
        RETVAL = cophh_2hv(a, 0);
        cophh_free(a);
#undef msviv
#line 5942 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_savehints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_savehints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3630 "APItest.xs"
        SV **svp, *sv;
#line 5963 "APItest.c"
#line 3632 "APItest.xs"
#define store_hint(KEY, VALUE) \
                sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), KEY, 1), (VALUE))
#define hint_ok(KEY, EXPECT) \
                ((svp = hv_fetchs(GvHV(PL_hintgv), KEY, 0)) && \
                    (sv = *svp) && SvIV(sv) == (EXPECT) && \
                    (sv = cop_hints_fetch_pvs(&PL_compiling, KEY, 0)) && \
                    SvIV(sv) == (EXPECT))
#define check_hint(KEY, EXPECT) \
                do { if (!hint_ok(KEY, EXPECT)) croak_fail(); } while(0)
        PL_hints |= HINT_LOCALIZE_HH;
        ENTER;
        SAVEHINTS();
        PL_hints &= HINT_INTEGER;
        store_hint("t0", 123);
        store_hint("t1", 456);
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 456);
        ENTER;
        SAVEHINTS();
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 456);
        PL_hints |= HINT_INTEGER;
        store_hint("t0", 321);
        if (!(PL_hints & HINT_INTEGER)) croak_fail();
        check_hint("t0", 321); check_hint("t1", 456);
        LEAVE;
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 456);
        ENTER;
        SAVEHINTS();
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 456);
        store_hint("t1", 654);
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 654);
        LEAVE;
        if (PL_hints & HINT_INTEGER) croak_fail();
        check_hint("t0", 123); check_hint("t1", 456);
        LEAVE;
#undef store_hint
#undef hint_ok
#undef check_hint
#line 6007 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_copyhints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_copyhints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3678 "APItest.xs"
        HV *a, *b;
#line 6022 "APItest.c"
#line 3680 "APItest.xs"
        PL_hints |= HINT_LOCALIZE_HH;
        ENTER;
        SAVEHINTS();
        sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), "t0", 1), 123);
        if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
            croak_fail();
        a = newHVhv(GvHV(PL_hintgv));
        sv_2mortal((SV*)a);
        sv_setiv_mg(*hv_fetchs(a, "t0", 1), 456);
        if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
            croak_fail();
        b = hv_copy_hints_hv(a);
        sv_2mortal((SV*)b);
        sv_setiv_mg(*hv_fetchs(b, "t0", 1), 789);
        if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 789)
            croak_fail();
        LEAVE;
#line 6041 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_list)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3701 "APItest.xs"
        OP *a;
#line 6056 "APItest.c"
#line 3703 "APItest.xs"
#define iv_op(iv) newSVOP(OP_CONST, 0, newSViv(iv))
#define check_op(o, expect) \
    do { \
        if (strNE(test_op_list_describe(o), (expect))) \
            croak("fail %s %s", test_op_list_describe(o), (expect)); \
    } while(0)
        a = op_append_elem(OP_LIST, NULL, NULL);
        check_op(a, "");
        a = op_append_elem(OP_LIST, iv_op(1), a);
        check_op(a, "const(1).");
        a = op_append_elem(OP_LIST, NULL, a);
        check_op(a, "const(1).");
        a = op_append_elem(OP_LIST, a, iv_op(2));
        check_op(a, "list[pushmark.const(1).const(2).]");
        a = op_append_elem(OP_LIST, a, iv_op(3));
        check_op(a, "list[pushmark.const(1).const(2).const(3).]");
        a = op_append_elem(OP_LIST, a, NULL);
        check_op(a, "list[pushmark.const(1).const(2).const(3).]");
        a = op_append_elem(OP_LIST, NULL, a);
        check_op(a, "list[pushmark.const(1).const(2).const(3).]");
        a = op_append_elem(OP_LIST, iv_op(4), a);
        check_op(a, "list[pushmark.const(4)."
                "list[pushmark.const(1).const(2).const(3).]]");
        a = op_append_elem(OP_LIST, a, iv_op(5));
        check_op(a, "list[pushmark.const(4)."
                "list[pushmark.const(1).const(2).const(3).]const(5).]");
        a = op_append_elem(OP_LIST, a,
                op_append_elem(OP_LIST, iv_op(7), iv_op(6)));
        check_op(a, "list[pushmark.const(4)."
                "list[pushmark.const(1).const(2).const(3).]const(5)."
                "list[pushmark.const(7).const(6).]]");
        op_free(a);
        a = op_append_elem(OP_LINESEQ, iv_op(1), iv_op(2));
        check_op(a, "lineseq[const(1).const(2).]");
        a = op_append_elem(OP_LINESEQ, a, iv_op(3));
        check_op(a, "lineseq[const(1).const(2).const(3).]");
        op_free(a);
        a = op_append_elem(OP_LINESEQ,
                op_append_elem(OP_LIST, iv_op(1), iv_op(2)),
                iv_op(3));
        check_op(a, "lineseq[list[pushmark.const(1).const(2).]const(3).]");
        op_free(a);
        a = op_prepend_elem(OP_LIST, NULL, NULL);
        check_op(a, "");
        a = op_prepend_elem(OP_LIST, a, iv_op(1));
        check_op(a, "const(1).");
        a = op_prepend_elem(OP_LIST, a, NULL);
        check_op(a, "const(1).");
        a = op_prepend_elem(OP_LIST, iv_op(2), a);
        check_op(a, "list[pushmark.const(2).const(1).]");
        a = op_prepend_elem(OP_LIST, iv_op(3), a);
        check_op(a, "list[pushmark.const(3).const(2).const(1).]");
        a = op_prepend_elem(OP_LIST, NULL, a);
        check_op(a, "list[pushmark.const(3).const(2).const(1).]");
        a = op_prepend_elem(OP_LIST, a, NULL);
        check_op(a, "list[pushmark.const(3).const(2).const(1).]");
        a = op_prepend_elem(OP_LIST, a, iv_op(4));
        check_op(a, "list[pushmark."
                "list[pushmark.const(3).const(2).const(1).]const(4).]");
        a = op_prepend_elem(OP_LIST, iv_op(5), a);
        check_op(a, "list[pushmark.const(5)."
                "list[pushmark.const(3).const(2).const(1).]const(4).]");
        a = op_prepend_elem(OP_LIST,
                op_prepend_elem(OP_LIST, iv_op(6), iv_op(7)), a);
        check_op(a, "list[pushmark.list[pushmark.const(6).const(7).]const(5)."
                "list[pushmark.const(3).const(2).const(1).]const(4).]");
        op_free(a);
        a = op_prepend_elem(OP_LINESEQ, iv_op(2), iv_op(1));
        check_op(a, "lineseq[const(2).const(1).]");
        a = op_prepend_elem(OP_LINESEQ, iv_op(3), a);
        check_op(a, "lineseq[const(3).const(2).const(1).]");
        op_free(a);
        a = op_prepend_elem(OP_LINESEQ, iv_op(3),
                op_prepend_elem(OP_LIST, iv_op(2), iv_op(1)));
        check_op(a, "lineseq[const(3).list[pushmark.const(2).const(1).]]");
        op_free(a);
        a = op_append_list(OP_LINESEQ, NULL, NULL);
        check_op(a, "");
        a = op_append_list(OP_LINESEQ, iv_op(1), a);
        check_op(a, "const(1).");
        a = op_append_list(OP_LINESEQ, NULL, a);
        check_op(a, "const(1).");
        a = op_append_list(OP_LINESEQ, a, iv_op(2));
        check_op(a, "lineseq[const(1).const(2).]");
        a = op_append_list(OP_LINESEQ, a, iv_op(3));
        check_op(a, "lineseq[const(1).const(2).const(3).]");
        a = op_append_list(OP_LINESEQ, iv_op(4), a);
        check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
        a = op_append_list(OP_LINESEQ, a, NULL);
        check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
        a = op_append_list(OP_LINESEQ, NULL, a);
        check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
        a = op_append_list(OP_LINESEQ, a,
                op_append_list(OP_LINESEQ, iv_op(5), iv_op(6)));
        check_op(a, "lineseq[const(4).const(1).const(2).const(3)."
                "const(5).const(6).]");
        op_free(a);
        a = op_append_list(OP_LINESEQ,
                op_append_list(OP_LINESEQ, iv_op(1), iv_op(2)),
                op_append_list(OP_LIST, iv_op(3), iv_op(4)));
        check_op(a, "lineseq[const(1).const(2)."
                "list[pushmark.const(3).const(4).]]");
        op_free(a);
        a = op_append_list(OP_LINESEQ,
                op_append_list(OP_LIST, iv_op(1), iv_op(2)),
                op_append_list(OP_LINESEQ, iv_op(3), iv_op(4)));
        check_op(a, "lineseq[list[pushmark.const(1).const(2).]"
                "const(3).const(4).]");
        op_free(a);
#undef check_op
#line 6168 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_linklist); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_linklist)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3817 "APItest.xs"
        OP *o;
#line 6183 "APItest.c"
#line 3819 "APItest.xs"
#define check_ll(o, expect) \
    STMT_START { \
        if (strNE(test_op_linklist_describe(o), (expect))) \
            croak("fail %s %s", test_op_linklist_describe(o), (expect)); \
    } STMT_END
        o = iv_op(1);
        check_ll(o, ".const1");
        op_free(o);

        o = mkUNOP(OP_NOT, iv_op(1));
        check_ll(o, ".const1.not");
        op_free(o);

        o = mkUNOP(OP_NOT, mkUNOP(OP_NEGATE, iv_op(1)));
        check_ll(o, ".const1.negate.not");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        check_ll(o, ".const1.const2.add");
        op_free(o);

        o = mkBINOP(OP_ADD, mkUNOP(OP_NOT, iv_op(1)), iv_op(2));
        check_ll(o, ".const1.not.const2.add");
        op_free(o);

        o = mkUNOP(OP_NOT, mkBINOP(OP_ADD, iv_op(1), iv_op(2)));
        check_ll(o, ".const1.const2.add.not");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ, iv_op(1), iv_op(2), iv_op(3));
        check_ll(o, ".const1.const2.const3.lineseq");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ,
                mkBINOP(OP_ADD, iv_op(1), iv_op(2)),
                mkUNOP(OP_NOT, iv_op(3)),
                mkLISTOP(OP_SUBSTR, iv_op(4), iv_op(5), iv_op(6)));
        check_ll(o, ".const1.const2.add.const3.not"
                    ".const4.const5.const6.substr.lineseq");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        LINKLIST(o);
        o = mkBINOP(OP_SUBTRACT, o, iv_op(3));
        check_ll(o, ".const1.const2.add.const3.subtract");
        op_free(o);
#undef check_ll
#undef iv_op
#line 6233 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_enable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_enable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3871 "APItest.xs"
        dMY_CXT;
#line 6248 "APItest.c"
#line 3873 "APItest.xs"
        av_clear(MY_CXT.peep_recorder);
        av_clear(MY_CXT.rpeep_recorder);
        MY_CXT.peep_recording = 1;
#line 6253 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_disable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_disable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3880 "APItest.xs"
        dMY_CXT;
#line 6268 "APItest.c"
#line 3882 "APItest.xs"
        MY_CXT.peep_recording = 0;
#line 6271 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3887 "APItest.xs"
        dMY_CXT;
#line 6286 "APItest.c"
	SV *	RETVAL;
#line 3889 "APItest.xs"
        RETVAL = newRV_inc((SV *)MY_CXT.peep_recorder);
#line 6290 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_rpeep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rpeep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3896 "APItest.xs"
        dMY_CXT;
#line 6307 "APItest.c"
	SV *	RETVAL;
#line 3898 "APItest.xs"
        RETVAL = newRV_inc((SV *)MY_CXT.rpeep_recorder);
#line 6311 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_multicall_each); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_multicall_each)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "block, ...");
    {
	SV *	block = ST(0)
;
#line 3913 "APItest.xs"
{
    dMULTICALL;
    int index;
    GV *gv;
    HV *stash;
    I32 gimme = G_SCALAR;
    SV **args = &PL_stack_base[ax];
    CV *cv;

    if(items <= 1) {
        XSRETURN_UNDEF;
    }
    cv = sv_2cv(block, &stash, &gv, 0);
    if (cv == Nullcv) {
       croak("multicall_each: not a subroutine reference");
    }
    PUSH_MULTICALL(cv);
    SAVESPTR(GvSV(PL_defgv));

    for(index = 1 ; index < items ; index++) {
        GvSV(PL_defgv) = args[index];
        MULTICALL;
    }
    POP_MULTICALL;
    XSRETURN_UNDEF;
}
#line 6355 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_multicall_return); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_multicall_return)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "block, context");
    {
	SV *	block = ST(0)
;
	I32	context = (I32)SvIV(ST(1))
;
#line 3953 "APItest.xs"
{
    dSP;
    dMULTICALL;
    GV *gv;
    HV *stash;
    I32 gimme = context;
    CV *cv;
    AV *av;
    SV **p;
    SSize_t i, size;

    cv = sv_2cv(block, &stash, &gv, 0);
    if (cv == Nullcv) {
       croak("multicall_return not a subroutine reference");
    }
    PUSH_MULTICALL(cv);

    MULTICALL;

    /* copy returned values into an array so they're not freed during
     * POP_MULTICALL */

    av = newAV();
    SPAGAIN;

    switch (context) {
    case G_VOID:
        break;

    case G_SCALAR:
        av_push(av, SvREFCNT_inc(TOPs));
        break;

    case G_LIST:
        for (p = PL_stack_base + 1; p <= SP; p++)
            av_push(av, SvREFCNT_inc(*p));
        break;
    }

    POP_MULTICALL;

    size = AvFILLp(av) + 1;
    EXTEND(SP, size);
    for (i = 0; i < size; i++)
        ST(i) = *av_fetch(av, i, FALSE);
    sv_2mortal((SV*)av);
    XSRETURN(size);
}
#line 6421 "APItest.c"
    }
    XSRETURN(1);
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_XS__APItest_clone_with_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_clone_with_stack)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4008 "APItest.xs"
{
    PerlInterpreter *interp = aTHX; /* The original interpreter */
    PerlInterpreter *interp_dup;    /* The duplicate interpreter */
    int oldscope = 1; /* We are responsible for all scopes */

    interp_dup = perl_clone(interp, CLONEf_COPY_STACKS | CLONEf_CLONE_HOST );

    /* destroy old perl */
    PERL_SET_CONTEXT(interp);

    POPSTACK_TO(PL_mainstack);
    if (cxstack_ix >= 0) {
        dounwind(-1);
        cx_popblock(cxstack);
    }
    LEAVE_SCOPE(0);
    PL_scopestack_ix = oldscope;
    FREETMPS;

    perl_destruct(interp);
    perl_free(interp);

    /* switch to new perl */
    PERL_SET_CONTEXT(interp_dup);

    /* continue after 'clone_with_stack' */
    if (interp_dup->Iop)
        interp_dup->Iop = interp_dup->Iop->op_next;

    /* run with new perl */
    Perl_runops_standard(interp_dup);

    /* We may have additional unclosed scopes if fork() was called
     * from within a BEGIN block.  See perlfork.pod for more details.
     * We cannot clean up these other scopes because they belong to a
     * different interpreter, but we also cannot leave PL_scopestack_ix
     * dangling because that can trigger an assertion in perl_destruct().
     */
    if (PL_scopestack_ix > oldscope) {
        PL_scopestack[oldscope-1] = PL_scopestack[PL_scopestack_ix-1];
        PL_scopestack_ix = oldscope;
    }

    perl_destruct(interp_dup);
    perl_free(interp_dup);

    /* call the real 'exit' not PerlProc_exit */
#undef exit
    exit(0);
}
#line 6488 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#endif /* USE_ITHREADS */

XS_EUPXS(XS_XS__APItest_take_svref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_svref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SVREF	sv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    sv = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::take_svref",
				"sv");
		}
	} STMT_END
;
#line 4064 "APItest.xs"
    RETVAL = newRV_inc(sv);
#line 6520 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_avref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_avref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "av");
    {
	SV *	RETVAL;
	AV*	av;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::take_avref",
				"av");
		}
	} STMT_END
;
#line 4071 "APItest.xs"
    RETVAL = newRV_inc((SV*)av);
#line 6553 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_hvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_hvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV*	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::take_hvref",
				"hv");
		}
	} STMT_END
;
#line 4078 "APItest.xs"
    RETVAL = newRV_inc((SV*)hv);
#line 6586 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_cvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_cvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	SV *	RETVAL;
	CV*	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::take_cvref",
				"cv");
		}
	} STMT_END
;
#line 4086 "APItest.xs"
    RETVAL = newRV_inc((SV*)cv);
#line 6619 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_establish_cleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_establish_cleanup)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4135 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("establish_cleanup called as a function");
#line 6637 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_postinc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_postinc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4148 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("postinc called as a function");
#line 6653 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_filter)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4154 "APItest.xs"
    filter_add(filter_call, NULL);
#line 6668 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_lv_temp_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lv_temp_object)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 4165 "APItest.xs"
    RETVAL =
          sv_bless(
            newRV_noinc(newSV(0)),
            gv_stashpvs("XS::APItest::TempObj",GV_ADD)
          );             /* Package defined in test script */
#line 6688 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
#line 4176 "APItest.xs"
    UV i = 0;
#line 6705 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::fill_hash_with_nulls",
				"hv");
		}
	} STMT_END
;
#line 4178 "APItest.xs"
    for(; i < 1000; ++i) {
        HE *entry = hv_fetch_ent(hv, sv_2mortal(newSVuv(i)), 1, 0);
        SvREFCNT_dec(HeVAL(entry));
        HeVAL(entry) = NULL;
    }
#line 6727 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_newHVhv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newHVhv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	HV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::newHVhv",
				"hv");
		}
	} STMT_END
;
#line 4187 "APItest.xs"
    RETVAL = newHVhv(hv);
#line 6758 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvIsCOW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvIsCOW)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	U32	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4194 "APItest.xs"
    RETVAL = SvIsCOW(sv);
#line 6783 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_pad_scalar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_pad_scalar)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4202 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("pad_scalar called as a function");
#line 6801 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_fetch_pad_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fetch_pad_names)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV*	cv;
#line 4215 "APItest.xs"
  I32 i;
  PADNAMELIST *pad_namelist;
  AV *retav = newAV();
#line 6819 "APItest.c"
	SV *	RETVAL;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::fetch_pad_names",
				"cv");
		}
	} STMT_END
;
#line 4219 "APItest.xs"
  pad_namelist = PadlistNAMES(CvPADLIST(cv));

  for ( i = PadnamelistMAX(pad_namelist); i >= 0; i-- ) {
    PADNAME* name = PadnamelistARRAY(pad_namelist)[i];

    if (PadnameLEN(name)) {
        av_push(retav, newSVpadname(name));
    }
  }
  RETVAL = newRV_noinc((SV*)retav);
#line 6846 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_underscore_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_underscore_length)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4236 "APItest.xs"
    SV *u;
    U8 *pv;
    STRLEN bytelen;
#line 6865 "APItest.c"
	STRLEN	RETVAL;
	dXSTARG;
#line 4240 "APItest.xs"
    u = find_rundefsv();
    pv = (U8*)SvPV(u, bytelen);
    RETVAL = SvUTF8(u) ? utf8_length(pv, pv+bytelen) : bytelen;
#line 6872 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_stringify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_stringify)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 4249 "APItest.xs"
    (void)SvPV_nolen(sv);
#line 6891 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_HvENAME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_HvENAME)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::HvENAME",
				"hv");
		}
	} STMT_END
;
#line 4254 "APItest.xs"
    RETVAL = hv && HvENAME(hv)
              ? newSVpvn_flags(
                  HvENAME(hv),HvENAMELEN(hv),
                  (HvENAMEUTF8(hv) ? SVf_UTF8 : 0)
                )
              : NULL;
#line 6927 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	int	RETVAL;
	dXSTARG;
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
#line 4266 "APItest.xs"
    /* Odd sorting (odd numbers first), to make sure we are actually
       being called */
    RETVAL = a % 2 != b % 2
               ? a % 2 ? -1 : 1
               : a < b ? -1 : a == b ? 0 : 1;
#line 6954 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp_undef); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp_undef)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	SV *	RETVAL;
	SV *	a = ST(0)
;
	SV *	b = ST(1)
;
#line 4277 "APItest.xs"
    PERL_UNUSED_ARG(a);
    PERL_UNUSED_ARG(b);
    RETVAL = &PL_sv_undef;
#line 6978 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVbyte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVbyte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4286 "APItest.xs"
    RETVAL = SvPVbyte_nolen(sv);
#line 6999 "APItest.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVbyte_nomg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVbyte_nomg)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4293 "APItest.xs"
    RETVAL = SvPVbyte_nomg(sv, PL_na);
#line 7021 "APItest.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVutf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVutf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4300 "APItest.xs"
    RETVAL = SvPVutf8_nolen(sv);
#line 7043 "APItest.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVutf8_nomg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVutf8_nomg)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4307 "APItest.xs"
    RETVAL = SvPVutf8_nomg(sv, PL_na);
#line 7065 "APItest.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvIsBOOL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvIsBOOL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	bool	RETVAL;
	SV *	sv = ST(0)
;
#line 4314 "APItest.xs"
    RETVAL = SvIsBOOL(sv);
#line 7086 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_setup_addissub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_addissub)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4321 "APItest.xs"
    wrap_op_checker(OP_ADD, addissub_myck_add, &addissub_nxck_add);
#line 7102 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4326 "APItest.xs"
    wrap_op_checker(OP_RV2CV, my_ck_rv2cv, &old_ck_rv2cv);
#line 7117 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_XS__APItest_test_alloccopstash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_alloccopstash)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4333 "APItest.xs"
    RETVAL = PL_stashpad[alloccopstash(PL_defstash)] == PL_defstash;
#line 7136 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4342 "APItest.xs"
    {
        const I32 floor = start_subparse(0,0);
        OP *o;
        /* The slab allocator does not like CvROOT being set. */
        CvROOT(PL_compcv) = (OP *)1;
        o = newFOROP(0, 0, newOP(OP_PUSHMARK, 0), 0, 0);
        if (cLOOPx(cUNOPo->op_first)->op_last->op_sibparent
                != cUNOPo->op_first)
        {
            Perl_warn(aTHX_ "Op parent pointer is stale");
            RETVAL = FALSE;
        }
        else
            /* If we do not crash before returning, the test passes. */
            RETVAL = TRUE;
        op_free(o);
        CvROOT(PL_compcv) = NULL;
        SvREFCNT_dec(PL_compcv);
        LEAVE_SCOPE(floor);
    }
#line 7173 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_callregexec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_callregexec)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "prog, stringarg, strend, minend, sv, nosave");
    {
	I32	RETVAL;
	dXSTARG;
	SV *	prog = ST(0)
;
	STRLEN	stringarg = (STRLEN)SvUV(ST(1))
;
	STRLEN	strend = (STRLEN)SvUV(ST(2))
;
	I32	minend = (I32)SvIV(ST(3))
;
	SV *	sv = ST(4)
;
	U32	nosave = (unsigned long)SvUV(ST(5))
;
#line 4371 "APItest.xs"
    {
        STRLEN len;
        char *strbeg;
        if (SvROK(prog))
            prog = SvRV(prog);
        strbeg = SvPV_force(sv, len);
        RETVAL = CALLREGEXEC((REGEXP *)prog,
                            strbeg + stringarg,
                            strbeg + strend,
                            strbeg,
                            minend,
                            sv,
                            NULL, /* data */
                            nosave);
    }
#line 7217 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_lexical_import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lexical_import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, cv");
    {
	SV *	name = ST(0)
;
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::lexical_import",
				"cv");
		}
	} STMT_END
;
#line 4392 "APItest.xs"
    {
        PADLIST *pl;
        PADOFFSET off;
        if (!PL_compcv)
            Perl_croak(aTHX_
                      "lexical_import can only be called at compile time");
        pl = CvPADLIST(PL_compcv);
        ENTER;
        SAVESPTR(PL_comppad_name); PL_comppad_name = PadlistNAMES(pl);
        SAVESPTR(PL_comppad);      PL_comppad      = PadlistARRAY(pl)[1];
        SAVESPTR(PL_curpad);       PL_curpad       = PadARRAY(PL_comppad);
        off = pad_add_name_sv(sv_2mortal(newSVpvf("&%" SVf,name)),
                              padadd_STATE, 0, 0);
        SvREFCNT_dec(PL_curpad[off]);
        PL_curpad[off] = SvREFCNT_inc(cv);
        intro_my();
        LEAVE;
    }
#line 7268 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_mortalcopy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_mortalcopy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4414 "APItest.xs"
        RETVAL = SvREFCNT_inc(sv_mortalcopy(sv));
#line 7286 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_newRV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newRV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;

	RETVAL = newRV(sv);
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_alias_av); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_alias_av)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "av, ix, sv");
    {
	AV *	av;
	IV	ix = (IV)SvIV(ST(1))
;
	SV *	sv = ST(2)
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::alias_av",
				"av");
		}
	} STMT_END
;
#line 4424 "APItest.xs"
        av_store(av, ix, SvREFCNT_inc(sv));
#line 7341 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_name)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "ref, ...");
    {
	SV *	RETVAL;
	SVREF	ref;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    ref = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::cv_name",
				"ref");
		}
	} STMT_END
;
#line 4429 "APItest.xs"
        RETVAL = SvREFCNT_inc(cv_name((CV *)ref,
                                      items>1 && ST(1) != &PL_sv_undef
                                        ? ST(1)
                                        : NULL,
                                      items>2 ? SvUV(ST(2)) : 0));
#line 7376 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_catpvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_catpvn)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, sv2");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
#line 4440 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv2,len);
        sv_catpvn_flags(sv,s,len, SvUTF8(sv2) ? SV_CATUTF8 : SV_CATBYTES);
    }
#line 7401 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4449 "APItest.xs"
    {
        OP *o = newLISTOP(OP_CUSTOM, 0, NULL, NULL);
        op_free(o);
        o = newOP(OP_CUSTOM, 0);
        op_free(o);
        o = newUNOP(OP_CUSTOM, 0, NULL);
        op_free(o);
        o = newUNOP_AUX(OP_CUSTOM, 0, NULL, NULL);
        op_free(o);
        o = newMETHOP(OP_CUSTOM, 0, newOP(OP_NULL,0));
        op_free(o);
        o = newMETHOP_named(OP_CUSTOM, 0, newSV(0));
        op_free(o);
        o = newBINOP(OP_CUSTOM, 0, NULL, NULL);
        op_free(o);
        o = newPMOP(OP_CUSTOM, 0);
        op_free(o);
        o = newSVOP(OP_CUSTOM, 0, newSV(0));
        op_free(o);
#ifdef USE_ITHREADS
        ENTER;
        lex_start(NULL, NULL, 0);
        {
            I32 ix = start_subparse(FALSE,0);
            o = newPADOP(OP_CUSTOM, 0, newSV(0));
            op_free(o);
            LEAVE_SCOPE(ix);
        }
        LEAVE;
#endif
        o = newPVOP(OP_CUSTOM, 0, NULL);
        op_free(o);
        o = newLOGOP(OP_CUSTOM, 0, newOP(OP_NULL,0), newOP(OP_NULL,0));
        op_free(o);
        o = newLOOPEX(OP_CUSTOM, newOP(OP_NULL,0));
        op_free(o);
        RETVAL = TRUE;
    }
#line 7454 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_sv_catpvf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_sv_catpvf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "fmtsv");
    {
#line 4493 "APItest.xs"
        SV *sv;
        char *fmt;
#line 7471 "APItest.c"
	SV *	fmtsv = ST(0)
;
#line 4496 "APItest.xs"
        fmt = SvPV_nolen(fmtsv);
        sv = sv_2mortal(newSVpvn("", 0));
        sv_catpvf(sv, fmt, 5, 6, 7, 8);
#line 7478 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_load_module); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_load_module)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "flags, name, ...");
    {
	U32	flags = (unsigned long)SvUV(ST(0))
;
	SV *	name = ST(1)
;
#line 4505 "APItest.xs"
    if (items == 2) {
        Perl_load_module(aTHX_ flags, SvREFCNT_inc(name), NULL);
    } else if (items == 3) {
        Perl_load_module(aTHX_ flags, SvREFCNT_inc(name), SvREFCNT_inc(ST(2)));
    } else
        Perl_croak(aTHX_ "load_module can't yet support %" IVdf " items",
                          (IV)items);
#line 7503 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_string_without_null); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_string_without_null)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4516 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = newSVpvn_flags(s, len, SvUTF8(sv));
        *SvEND(RETVAL) = 0xff;
    }
#line 7526 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_get_cv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_get_cv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	CV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4528 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = get_cvn_flags(s, len, 0);
    }
#line 7550 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_get_cv_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_get_cv_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, flags");
    {
	CV *	RETVAL;
	SV *	sv = ST(0)
;
	UV	flags = (UV)SvUV(ST(1))
;
#line 4539 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = get_cvn_flags(s, len, flags);
    }
#line 7580 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_unshift_and_set_defav); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_unshift_and_set_defav)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV *	sv = ST(0)
;
#line 4550 "APItest.xs"
        av_unshift(GvAVn(PL_defgv), 1);
        av_store(GvAV(PL_defgv), 0, newSVuv(42));
        sv_setuv(sv, 43);
#line 7605 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_PerlIO_stderr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stderr)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	PerlIO *	RETVAL;

	RETVAL = PerlIO_stderr();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+<&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_PerlIO_stdout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stdout)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	OutputStream	RETVAL;

	RETVAL = PerlIO_stdout();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+>&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_PerlIO_stdin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stdin)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	InputStream	RETVAL;

	RETVAL = PerlIO_stdin();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "<&", 2, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef FILE
#define FILE NativeFile

XS_EUPXS(XS_XS__APItest_PerlIO_exportFILE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_exportFILE)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "f, mode");
    {
	FILE *	RETVAL;
	PerlIO *	f = IoIFP(sv_2io(ST(0)))
;
	const char *	mode = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = PerlIO_exportFILE(f, mode);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		PerlIO *fp = PerlIO_importFILE(RETVAL,0);
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( fp && do_open(gv, "+<&", 3, FALSE, 0, 0, fp) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_MAX_types); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_MAX_types)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 4572 "APItest.xs"
        /* tests that IV_MAX and UV_MAX have types suitable
           for the IVdf and UVdf formats.
           If this warns then don't add casts here.
        */
        RETVAL = newSVpvf("iv %" IVdf " uv %" UVuf, IV_MAX, UV_MAX);
#line 7748 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_numeq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_numeq)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv1, sv2");
    {
	bool	RETVAL;
	SV *	sv1 = ST(0)
;
	SV *	sv2 = ST(1)
;
#line 4583 "APItest.xs"
        RETVAL = sv_numeq(sv1, sv2);
#line 7770 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_numeq_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_numeq_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sv1, sv2, flags");
    {
	bool	RETVAL;
	SV *	sv1 = ST(0)
;
	SV *	sv2 = ST(1)
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 4590 "APItest.xs"
        RETVAL = sv_numeq_flags(sv1, sv2, flags);
#line 7793 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_streq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_streq)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv1, sv2");
    {
	bool	RETVAL;
	SV *	sv1 = ST(0)
;
	SV *	sv2 = ST(1)
;
#line 4597 "APItest.xs"
        RETVAL = sv_streq(sv1, sv2);
#line 7814 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_streq_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_streq_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sv1, sv2, flags");
    {
	bool	RETVAL;
	SV *	sv1 = ST(0)
;
	SV *	sv2 = ST(1)
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 4604 "APItest.xs"
        RETVAL = sv_streq_flags(sv1, sv2, flags);
#line 7837 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	int	RETVAL;
	dXSTARG;
#line 4613 "APItest.xs"
    SV* comms;
    SV* class_and_method;
#line 7856 "APItest.c"
#line 4616 "APItest.xs"
    PERL_UNUSED_ARG(items);
    class_and_method = GvSV(CvGV(cv));
    comms = get_sv("main::the_method", 1);
    if (class_and_method == NULL) {
      RETVAL = 1;
    } else if (!SvOK(class_and_method)) {
      RETVAL = 2;
    } else if (!SvPOK(class_and_method)) {
      RETVAL = 3;
    } else {
      sv_setsv(comms, class_and_method);
      RETVAL = 0;
    }
#line 7871 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4641 "APItest.xs"
    sv_magicext(SvRV(sv), NULL, PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo, (const char *)thingy, 0);
#line 7893 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4648 "APItest.xs"
    MAGIC *mg = mg_findext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
    RETVAL = mg ? SvREFCNT_inc((SV *)mg->mg_ptr) : &PL_sv_undef;
#line 7913 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 4658 "APItest.xs"
    sv_unmagicext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
#line 7933 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4663 "APItest.xs"
    sv_magic(SvRV(sv), NULL, PERL_MAGIC_ext, (const char *)thingy, 0);
#line 7952 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4668 "APItest.xs"
        MGVTBL *have;
        MGVTBL *want;
#line 7968 "APItest.c"
	UV	RETVAL;
	dXSTARG;
#line 4671 "APItest.xs"
#define test_get_this_vtable(name) \
        want = (MGVTBL*)CAT2(&PL_vtbl_, name); \
        have = get_vtbl(CAT2(want_vtbl_, name)); \
        if (have != want) \
            croak("fail %p!=%p for get_vtbl(want_vtbl_" STRINGIFY(name) ") at " __FILE__ " line %d", have, want, __LINE__)

        test_get_this_vtable(sv);
        test_get_this_vtable(env);
        test_get_this_vtable(envelem);
        test_get_this_vtable(sigelem);
        test_get_this_vtable(pack);
        test_get_this_vtable(packelem);
        test_get_this_vtable(dbline);
        test_get_this_vtable(isa);
        test_get_this_vtable(isaelem);
        test_get_this_vtable(arylen);
        test_get_this_vtable(mglob);
        test_get_this_vtable(nkeys);
        test_get_this_vtable(taint);
        test_get_this_vtable(substr);
        test_get_this_vtable(vec);
        test_get_this_vtable(pos);
        test_get_this_vtable(bm);
        test_get_this_vtable(fm);
        test_get_this_vtable(uvar);
        test_get_this_vtable(defelem);
        test_get_this_vtable(regexp);
        test_get_this_vtable(regdata);
        test_get_this_vtable(regdatum);
#ifdef USE_LOCALE_COLLATE
        test_get_this_vtable(collxfrm);
#endif
        test_get_this_vtable(backref);
        test_get_this_vtable(utf8);

        RETVAL = PTR2UV(get_vtbl(-1));
#line 8008 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_myset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_myset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rsv, thingy");
    {
	SV *	rsv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4717 "APItest.xs"
    sv_magicext(SvRV(rsv), NULL, PERL_MAGIC_ext, &vtbl_myset,
        (const char *)thingy, 0);
#line 8030 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_mycopy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_mycopy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "rsv");
    {
#line 4723 "APItest.xs"
        MAGIC *mg;
#line 8045 "APItest.c"
	SV *	rsv = ST(0)
;
#line 4725 "APItest.xs"
        /* It's only actually useful to attach this to arrays and hashes. */
        mg = sv_magicext(SvRV(rsv), NULL, PERL_MAGIC_ext, &vtbl_mycopy, NULL, 0);
        mg->mg_flags = MGf_COPY;
#line 8052 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_mycopy_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_mycopy_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "rsv");
    {
#line 4732 "APItest.xs"
        MAGIC *mg;
#line 8067 "APItest.c"
	SV *	RETVAL;
	SV *	rsv = ST(0)
;
#line 4734 "APItest.xs"
        mg = mg_findext(SvRV(rsv), PERL_MAGIC_ext, &vtbl_mycopy);
        RETVAL = mg ? newSViv(mg->mg_private) : &PL_sv_undef;
#line 8074 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4745 "APItest.xs"
        RETVAL = isBLANK_uni(ord);
#line 8094 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4752 "APItest.xs"
        RETVAL = isBLANK_uvchr(ord);
#line 8113 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4759 "APItest.xs"
        RETVAL = isBLANK_LC_uvchr(ord);
#line 8132 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4766 "APItest.xs"
        RETVAL = isBLANK(ord);
#line 8151 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4773 "APItest.xs"
        RETVAL = isBLANK_A(ord);
#line 8170 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4780 "APItest.xs"
        RETVAL = isBLANK_L1(ord);
#line 8189 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4787 "APItest.xs"
        RETVAL = isBLANK_LC(ord);
#line 8208 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4794 "APItest.xs"
        const U8 * e;
#line 8224 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4797 "APItest.xs"
        /* In this function and those that follow, the boolean 'type'
         * indicates if to pass a malformed UTF-8 string to the tested macro
         * (malformed by making it too short) */
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isBLANK_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8241 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isBLANK_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isBLANK_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4813 "APItest.xs"
        const U8 * e;
#line 8257 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4815 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isBLANK_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8271 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isVERTWS_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isVERTWS_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4828 "APItest.xs"
        RETVAL = isVERTWS_uni(ord);
#line 8290 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isVERTWS_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isVERTWS_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4835 "APItest.xs"
        RETVAL = isVERTWS_uvchr(ord);
#line 8309 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isVERTWS_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isVERTWS_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4842 "APItest.xs"
        const U8 * e;
#line 8325 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4844 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isVERTWS_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8339 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4857 "APItest.xs"
        RETVAL = isUPPER_uni(ord);
#line 8358 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4864 "APItest.xs"
        RETVAL = isUPPER_uvchr(ord);
#line 8377 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4871 "APItest.xs"
        RETVAL = isUPPER_LC_uvchr(ord);
#line 8396 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4878 "APItest.xs"
        RETVAL = isUPPER(ord);
#line 8415 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4885 "APItest.xs"
        RETVAL = isUPPER_A(ord);
#line 8434 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4892 "APItest.xs"
        RETVAL = isUPPER_L1(ord);
#line 8453 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4899 "APItest.xs"
        RETVAL = isUPPER_LC(ord);
#line 8472 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4906 "APItest.xs"
        const U8 * e;
#line 8488 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4908 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isUPPER_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8502 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUPPER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUPPER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4921 "APItest.xs"
        const U8 * e;
#line 8518 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4923 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isUPPER_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8532 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4936 "APItest.xs"
        RETVAL = isLOWER_uni(ord);
#line 8551 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4943 "APItest.xs"
        RETVAL = isLOWER_uvchr(ord);
#line 8570 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4950 "APItest.xs"
        RETVAL = isLOWER_LC_uvchr(ord);
#line 8589 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4957 "APItest.xs"
        RETVAL = isLOWER(ord);
#line 8608 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4964 "APItest.xs"
        RETVAL = isLOWER_A(ord);
#line 8627 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4971 "APItest.xs"
        RETVAL = isLOWER_L1(ord);
#line 8646 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4978 "APItest.xs"
        RETVAL = isLOWER_LC(ord);
#line 8665 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4985 "APItest.xs"
        const U8 * e;
#line 8681 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4987 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isLOWER_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8695 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isLOWER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isLOWER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5000 "APItest.xs"
        const U8 * e;
#line 8711 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5002 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isLOWER_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8725 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5015 "APItest.xs"
        RETVAL = isALPHA_uni(ord);
#line 8744 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5022 "APItest.xs"
        RETVAL = isALPHA_uvchr(ord);
#line 8763 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5029 "APItest.xs"
        RETVAL = isALPHA_LC_uvchr(ord);
#line 8782 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5036 "APItest.xs"
        RETVAL = isALPHA(ord);
#line 8801 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5043 "APItest.xs"
        RETVAL = isALPHA_A(ord);
#line 8820 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5050 "APItest.xs"
        RETVAL = isALPHA_L1(ord);
#line 8839 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5057 "APItest.xs"
        RETVAL = isALPHA_LC(ord);
#line 8858 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5064 "APItest.xs"
        const U8 * e;
#line 8874 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5066 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHA_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8888 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHA_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHA_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5079 "APItest.xs"
        const U8 * e;
#line 8904 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5081 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHA_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 8918 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5094 "APItest.xs"
        RETVAL = isWORDCHAR_uni(ord);
#line 8937 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5101 "APItest.xs"
        RETVAL = isWORDCHAR_uvchr(ord);
#line 8956 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5108 "APItest.xs"
        RETVAL = isWORDCHAR_LC_uvchr(ord);
#line 8975 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5115 "APItest.xs"
        RETVAL = isWORDCHAR(ord);
#line 8994 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5122 "APItest.xs"
        RETVAL = isWORDCHAR_A(ord);
#line 9013 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5129 "APItest.xs"
        RETVAL = isWORDCHAR_L1(ord);
#line 9032 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5136 "APItest.xs"
        RETVAL = isWORDCHAR_LC(ord);
#line 9051 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5143 "APItest.xs"
        const U8 * e;
#line 9067 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5145 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9081 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isWORDCHAR_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5158 "APItest.xs"
        const U8 * e;
#line 9097 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5160 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9111 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5173 "APItest.xs"
        RETVAL = isALPHANUMERIC_uni(ord);
#line 9130 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5180 "APItest.xs"
        RETVAL = isALPHANUMERIC_uvchr(ord);
#line 9149 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5187 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC_uvchr(ord);
#line 9168 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5194 "APItest.xs"
        RETVAL = isALPHANUMERIC(ord);
#line 9187 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5201 "APItest.xs"
        RETVAL = isALPHANUMERIC_A(ord);
#line 9206 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5208 "APItest.xs"
        RETVAL = isALPHANUMERIC_L1(ord);
#line 9225 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5215 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC(ord);
#line 9244 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5222 "APItest.xs"
        const U8 * e;
#line 9260 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5224 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHANUMERIC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9274 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALPHANUMERIC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5237 "APItest.xs"
        const U8 * e;
#line 9290 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5239 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHANUMERIC_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9304 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5252 "APItest.xs"
        RETVAL = isALNUM(ord);
#line 9323 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5259 "APItest.xs"
        RETVAL = isALNUM_uni(ord);
#line 9342 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5266 "APItest.xs"
        RETVAL = isALNUM_LC_uvchr(ord);
#line 9361 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5273 "APItest.xs"
        RETVAL = isALNUM_LC(ord);
#line 9380 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5280 "APItest.xs"
        const U8 * e;
#line 9396 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5282 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9410 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isALNUM_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isALNUM_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5295 "APItest.xs"
        const U8 * e;
#line 9426 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5297 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9440 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5310 "APItest.xs"
        RETVAL = isDIGIT_uni(ord);
#line 9459 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5317 "APItest.xs"
        RETVAL = isDIGIT_uvchr(ord);
#line 9478 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5324 "APItest.xs"
        RETVAL = isDIGIT_LC_uvchr(ord);
#line 9497 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5331 "APItest.xs"
        const U8 * e;
#line 9513 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5333 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isDIGIT_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9527 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5346 "APItest.xs"
        const U8 * e;
#line 9543 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5348 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isDIGIT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9557 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5361 "APItest.xs"
        RETVAL = isDIGIT(ord);
#line 9576 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5368 "APItest.xs"
        RETVAL = isDIGIT_A(ord);
#line 9595 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5375 "APItest.xs"
        RETVAL = isDIGIT_L1(ord);
#line 9614 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5382 "APItest.xs"
        RETVAL = isDIGIT_LC(ord);
#line 9633 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isOCTAL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isOCTAL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5389 "APItest.xs"
        RETVAL = isOCTAL(ord);
#line 9652 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isOCTAL_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isOCTAL_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5396 "APItest.xs"
        RETVAL = isOCTAL_A(ord);
#line 9671 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isOCTAL_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isOCTAL_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5403 "APItest.xs"
        RETVAL = isOCTAL_L1(ord);
#line 9690 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5410 "APItest.xs"
        RETVAL = isIDFIRST_uni(ord);
#line 9709 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5417 "APItest.xs"
        RETVAL = isIDFIRST_uvchr(ord);
#line 9728 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5424 "APItest.xs"
        RETVAL = isIDFIRST_LC_uvchr(ord);
#line 9747 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5431 "APItest.xs"
        RETVAL = isIDFIRST(ord);
#line 9766 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5438 "APItest.xs"
        RETVAL = isIDFIRST_A(ord);
#line 9785 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5445 "APItest.xs"
        RETVAL = isIDFIRST_L1(ord);
#line 9804 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5452 "APItest.xs"
        RETVAL = isIDFIRST_LC(ord);
#line 9823 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5459 "APItest.xs"
        const U8 * e;
#line 9839 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5461 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDFIRST_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9853 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDFIRST_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5474 "APItest.xs"
        const U8 * e;
#line 9869 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5476 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDFIRST_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 9883 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5489 "APItest.xs"
        RETVAL = isIDCONT_uni(ord);
#line 9902 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5496 "APItest.xs"
        RETVAL = isIDCONT_uvchr(ord);
#line 9921 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5503 "APItest.xs"
        RETVAL = isIDCONT_LC_uvchr(ord);
#line 9940 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5510 "APItest.xs"
        RETVAL = isIDCONT(ord);
#line 9959 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5517 "APItest.xs"
        RETVAL = isIDCONT_A(ord);
#line 9978 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5524 "APItest.xs"
        RETVAL = isIDCONT_L1(ord);
#line 9997 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5531 "APItest.xs"
        RETVAL = isIDCONT_LC(ord);
#line 10016 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5538 "APItest.xs"
        const U8 * e;
#line 10032 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5540 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDCONT_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10046 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isIDCONT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5553 "APItest.xs"
        const U8 * e;
#line 10062 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5555 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDCONT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10076 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5568 "APItest.xs"
        RETVAL = isSPACE_uni(ord);
#line 10095 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5575 "APItest.xs"
        RETVAL = isSPACE_uvchr(ord);
#line 10114 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5582 "APItest.xs"
        RETVAL = isSPACE_LC_uvchr(ord);
#line 10133 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5589 "APItest.xs"
        RETVAL = isSPACE(ord);
#line 10152 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5596 "APItest.xs"
        RETVAL = isSPACE_A(ord);
#line 10171 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5603 "APItest.xs"
        RETVAL = isSPACE_L1(ord);
#line 10190 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5610 "APItest.xs"
        RETVAL = isSPACE_LC(ord);
#line 10209 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5617 "APItest.xs"
        const U8 * e;
#line 10225 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5619 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isSPACE_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10239 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSPACE_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSPACE_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5632 "APItest.xs"
        const U8 * e;
#line 10255 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5634 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isSPACE_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10269 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5647 "APItest.xs"
        RETVAL = isASCII_uni(ord);
#line 10288 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5654 "APItest.xs"
        RETVAL = isASCII_uvchr(ord);
#line 10307 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5661 "APItest.xs"
        RETVAL = isASCII_LC_uvchr(ord);
#line 10326 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5668 "APItest.xs"
        RETVAL = isASCII(ord);
#line 10345 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5675 "APItest.xs"
        RETVAL = isASCII_A(ord);
#line 10364 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5682 "APItest.xs"
        RETVAL = isASCII_L1(ord);
#line 10383 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5689 "APItest.xs"
        RETVAL = isASCII_LC(ord);
#line 10402 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5696 "APItest.xs"
        const U8 * e;
#line 10418 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5698 "APItest.xs"
#ifndef DEBUGGING
        PERL_UNUSED_VAR(e);
#endif
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isASCII_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10435 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isASCII_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isASCII_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5714 "APItest.xs"
        const U8 * e;
#line 10451 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5716 "APItest.xs"
#ifndef DEBUGGING
        PERL_UNUSED_VAR(e);
#endif
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isASCII_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10468 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5732 "APItest.xs"
        RETVAL = isCNTRL_uni(ord);
#line 10487 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5739 "APItest.xs"
        RETVAL = isCNTRL_uvchr(ord);
#line 10506 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5746 "APItest.xs"
        RETVAL = isCNTRL_LC_uvchr(ord);
#line 10525 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5753 "APItest.xs"
        RETVAL = isCNTRL(ord);
#line 10544 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5760 "APItest.xs"
        RETVAL = isCNTRL_A(ord);
#line 10563 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5767 "APItest.xs"
        RETVAL = isCNTRL_L1(ord);
#line 10582 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5774 "APItest.xs"
        RETVAL = isCNTRL_LC(ord);
#line 10601 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5781 "APItest.xs"
        const U8 * e;
#line 10617 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5783 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isCNTRL_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10631 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isCNTRL_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5796 "APItest.xs"
        const U8 * e;
#line 10647 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5798 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isCNTRL_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10661 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5811 "APItest.xs"
        RETVAL = isPRINT_uni(ord);
#line 10680 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5818 "APItest.xs"
        RETVAL = isPRINT_uvchr(ord);
#line 10699 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5825 "APItest.xs"
        RETVAL = isPRINT_LC_uvchr(ord);
#line 10718 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5832 "APItest.xs"
        RETVAL = isPRINT(ord);
#line 10737 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5839 "APItest.xs"
        RETVAL = isPRINT_A(ord);
#line 10756 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5846 "APItest.xs"
        RETVAL = isPRINT_L1(ord);
#line 10775 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5853 "APItest.xs"
        RETVAL = isPRINT_LC(ord);
#line 10794 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5860 "APItest.xs"
        const U8 * e;
#line 10810 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5862 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPRINT_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10824 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPRINT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPRINT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5875 "APItest.xs"
        const U8 * e;
#line 10840 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5877 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPRINT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 10854 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5890 "APItest.xs"
        RETVAL = isGRAPH_uni(ord);
#line 10873 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5897 "APItest.xs"
        RETVAL = isGRAPH_uvchr(ord);
#line 10892 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5904 "APItest.xs"
        RETVAL = isGRAPH_LC_uvchr(ord);
#line 10911 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5911 "APItest.xs"
        RETVAL = isGRAPH(ord);
#line 10930 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5918 "APItest.xs"
        RETVAL = isGRAPH_A(ord);
#line 10949 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5925 "APItest.xs"
        RETVAL = isGRAPH_L1(ord);
#line 10968 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5932 "APItest.xs"
        RETVAL = isGRAPH_LC(ord);
#line 10987 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5939 "APItest.xs"
        const U8 * e;
#line 11003 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5941 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isGRAPH_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11017 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isGRAPH_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5954 "APItest.xs"
        const U8 * e;
#line 11033 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5956 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isGRAPH_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11047 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5969 "APItest.xs"
        RETVAL = isPUNCT_uni(ord);
#line 11066 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5976 "APItest.xs"
        RETVAL = isPUNCT_uvchr(ord);
#line 11085 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5983 "APItest.xs"
        RETVAL = isPUNCT_LC_uvchr(ord);
#line 11104 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5990 "APItest.xs"
        RETVAL = isPUNCT(ord);
#line 11123 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5997 "APItest.xs"
        RETVAL = isPUNCT_A(ord);
#line 11142 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6004 "APItest.xs"
        RETVAL = isPUNCT_L1(ord);
#line 11161 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6011 "APItest.xs"
        RETVAL = isPUNCT_LC(ord);
#line 11180 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6018 "APItest.xs"
        const U8 * e;
#line 11196 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6020 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPUNCT_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11210 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPUNCT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6033 "APItest.xs"
        const U8 * e;
#line 11226 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6035 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPUNCT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11240 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6048 "APItest.xs"
        RETVAL = isXDIGIT_uni(ord);
#line 11259 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6055 "APItest.xs"
        RETVAL = isXDIGIT_uvchr(ord);
#line 11278 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6062 "APItest.xs"
        RETVAL = isXDIGIT_LC_uvchr(ord);
#line 11297 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6069 "APItest.xs"
        RETVAL = isXDIGIT(ord);
#line 11316 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6076 "APItest.xs"
        RETVAL = isXDIGIT_A(ord);
#line 11335 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6083 "APItest.xs"
        RETVAL = isXDIGIT_L1(ord);
#line 11354 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6090 "APItest.xs"
        RETVAL = isXDIGIT_LC(ord);
#line 11373 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6097 "APItest.xs"
        const U8 * e;
#line 11389 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6099 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isXDIGIT_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11403 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isXDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6112 "APItest.xs"
        const U8 * e;
#line 11419 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6114 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isXDIGIT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11433 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6127 "APItest.xs"
        RETVAL = isPSXSPC_uni(ord);
#line 11452 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6134 "APItest.xs"
        RETVAL = isPSXSPC_uvchr(ord);
#line 11471 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6141 "APItest.xs"
        RETVAL = isPSXSPC_LC_uvchr(ord);
#line 11490 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6148 "APItest.xs"
        RETVAL = isPSXSPC(ord);
#line 11509 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6155 "APItest.xs"
        RETVAL = isPSXSPC_A(ord);
#line 11528 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6162 "APItest.xs"
        RETVAL = isPSXSPC_L1(ord);
#line 11547 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6169 "APItest.xs"
        RETVAL = isPSXSPC_LC(ord);
#line 11566 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6176 "APItest.xs"
        const U8 * e;
#line 11582 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6178 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPSXSPC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11596 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isPSXSPC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6191 "APItest.xs"
        const U8 * e;
#line 11612 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 6193 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPSXSPC_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = 0;
        }
#line 11626 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_REPLACEMENT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_REPLACEMENT)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6206 "APItest.xs"
        RETVAL = UTF8_IS_REPLACEMENT(s, s + len);
#line 11648 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isQUOTEMETA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isQUOTEMETA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6213 "APItest.xs"
        RETVAL = _isQUOTEMETA(ord);
#line 11668 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_OFFUNISKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_OFFUNISKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6220 "APItest.xs"
        RETVAL = OFFUNISKIP(ord);
#line 11688 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_OFFUNI_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_OFFUNI_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6227 "APItest.xs"
        RETVAL = OFFUNI_IS_INVARIANT(ord);
#line 11708 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UVCHR_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UVCHR_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6234 "APItest.xs"
        RETVAL = UVCHR_IS_INVARIANT(ord);
#line 11727 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6241 "APItest.xs"
        RETVAL = UTF8_IS_INVARIANT(ch);
#line 11746 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UVCHR_SKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UVCHR_SKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6248 "APItest.xs"
        RETVAL = UVCHR_SKIP(ord);
#line 11766 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_SKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_SKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	UV	RETVAL;
	dXSTARG;
	char *	ch = (char *)SvPV_nolen(ST(0))
;
#line 6255 "APItest.xs"
        RETVAL = UTF8_SKIP(ch);
#line 11787 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_START); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_START)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6262 "APItest.xs"
        RETVAL = UTF8_IS_START(ch);
#line 11807 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_CONTINUATION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_CONTINUATION)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6269 "APItest.xs"
        RETVAL = UTF8_IS_CONTINUATION(ch);
#line 11826 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_CONTINUED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_CONTINUED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6276 "APItest.xs"
        RETVAL = UTF8_IS_CONTINUED(ch);
#line 11845 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_DOWNGRADEABLE_START); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_DOWNGRADEABLE_START)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6283 "APItest.xs"
        RETVAL = UTF8_IS_DOWNGRADEABLE_START(ch);
#line 11864 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_UTF8_IS_ABOVE_LATIN1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_UTF8_IS_ABOVE_LATIN1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6290 "APItest.xs"
        RETVAL = UTF8_IS_ABOVE_LATIN1(ch);
#line 11883 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUTF8_POSSIBLY_PROBLEMATIC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUTF8_POSSIBLY_PROBLEMATIC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6297 "APItest.xs"
        RETVAL = isUTF8_POSSIBLY_PROBLEMATIC(ch);
#line 11902 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6304 "APItest.xs"
        RETVAL = isUTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11924 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isUTF8_CHAR_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isUTF8_CHAR_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6311 "APItest.xs"
        RETVAL = isUTF8_CHAR_flags((U8 *) s, (U8 *) s + len, flags);
#line 11949 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isSTRICT_UTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isSTRICT_UTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6318 "APItest.xs"
        RETVAL = isSTRICT_UTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11972 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_isC9_STRICT_UTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_isC9_STRICT_UTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6325 "APItest.xs"
        RETVAL = isC9_STRICT_UTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11995 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_valid_partial_char_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_valid_partial_char_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6332 "APItest.xs"
        /* RETVAL should be bool (here and in tests below), but making it IV
         * allows us to test it returning 0 or 1 */
        RETVAL = is_utf8_valid_partial_char_flags((U8 *) s, (U8 *) s + len, flags);
#line 12022 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6341 "APItest.xs"
        RETVAL = is_utf8_string((U8 *) s, len);
#line 12045 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define WORDSIZE            sizeof(PERL_UINTMAX_T)

XS_EUPXS(XS_XS__APItest_test_is_utf8_invariant_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_invariant_string_loc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
#line 6350 "APItest.xs"
        AV *av;
        const U8 * ep = NULL;
        PERL_UINTMAX_T* copy;
#line 12065 "APItest.c"
	AV *	RETVAL;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6354 "APItest.xs"
        /* 'offset' is number of bytes past a word boundary the testing of 's'
         * is to start at.  Allocate space that does start at the word
         * boundary, and copy 's' to the correct offset past it.  Then call the
         * tested function with that position */
        Newx(copy, 1 + ((len + WORDSIZE - 1) / WORDSIZE), PERL_UINTMAX_T);
        Copy(s, (U8 *) copy + offset, len, U8);
        av = newAV();
        av_push(av, newSViv(is_utf8_invariant_string_loc((U8 *) copy + offset, len, &ep)));
        av_push(av, newSViv(ep - ((U8 *) copy + offset)));
        RETVAL = av;
        Safefree(copy);
#line 12085 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_variant_under_utf8_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_variant_under_utf8_count)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
#line 6371 "APItest.xs"
        PERL_UINTMAX_T * copy;
#line 12106 "APItest.c"
	STRLEN	RETVAL;
	dXSTARG;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6373 "APItest.xs"
        Newx(copy, 1 + ((len + WORDSIZE - 1) / WORDSIZE), PERL_UINTMAX_T);
        Copy(s, (U8 *) copy + offset, len, U8);
        RETVAL = variant_under_utf8_count((U8 *) copy + offset, (U8 *) copy + offset + len);
        Safefree(copy);
#line 12120 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_utf8_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_utf8_length)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6383 "APItest.xs"
    RETVAL = utf8_length(s + offset, s + len);
#line 12145 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6390 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12163 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6393 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12174 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6403 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12197 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6407 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12209 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6418 "APItest.xs"
        RETVAL = is_utf8_string_flags((U8 *) s, len, flags);
#line 12238 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loc_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loc_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6425 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12256 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6428 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loc_flags((U8 *) s, len, &ep, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12269 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loclen_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_string_loclen_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6438 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12292 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6442 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loclen_flags((U8 *) s, len, &ep, &ret_len, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12306 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6453 "APItest.xs"
        RETVAL = is_strict_utf8_string((U8 *) s, len);
#line 12333 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6460 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12351 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6463 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_strict_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12362 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_strict_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6473 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12385 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6477 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_strict_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12397 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6488 "APItest.xs"
        RETVAL = is_c9strict_utf8_string((U8 *) s, len);
#line 12424 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6495 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12442 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6498 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_c9strict_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12453 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_c9strict_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6508 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12476 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6512 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_c9strict_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12488 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6523 "APItest.xs"
        RETVAL = is_utf8_fixed_width_buf_flags((U8 *) s, len, flags);
#line 12517 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_loc_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_loc_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6530 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12535 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6533 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_fixed_width_buf_loc_flags((U8 *) s, len, &ep, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12548 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_loclen_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_is_utf8_fixed_width_buf_loclen_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6543 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12571 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6547 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_fixed_width_buf_loclen_flags((U8 *) s, len, &ep, &ret_len, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12585 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_utf8_hop_safe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_utf8_hop_safe)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s_sv, s_off, off");
    {
#line 6558 "APItest.xs"
        STRLEN len;
        U8 *p;
        U8 *r;
#line 12608 "APItest.c"
	IV	RETVAL;
	dXSTARG;
	SV *	s_sv = ST(0)
;
	STRLEN	s_off = (STRLEN)SvUV(ST(1))
;
	IV	off = (IV)SvIV(ST(2))
;
#line 6562 "APItest.xs"
        p = (U8 *)SvPV(s_sv, len);
        r = utf8_hop_safe(p + s_off, off, p, p + len);
        RETVAL = r - p;
#line 12621 "APItest.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6571 "APItest.xs"
        RETVAL = toLOWER(ord);
#line 12642 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6578 "APItest.xs"
        RETVAL = toLOWER_L1(ord);
#line 12663 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6585 "APItest.xs"
        RETVAL = toLOWER_LC(ord);
#line 12684 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6592 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12704 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6597 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toLOWER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12718 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6612 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12742 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6617 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toLOWER_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12756 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6632 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
        const U8 * e;
        UV resultant_cp = UV_MAX;   /* Initialized because of dumb compilers */
#line 12783 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6640 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toLOWER_utf8_safe(input, e, s, &len);
            av_push(av, newSVuv(resultant_cp));

            utf8 = newSVpvn((char *) s, len);
            SvUTF8_on(utf8);
            av_push(av, utf8);

            av_push(av, newSVuv(len));
            RETVAL = av;
        }
        else {
            RETVAL = 0;
        }
#line 12807 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toFOLD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toFOLD)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6663 "APItest.xs"
        RETVAL = toFOLD(ord);
#line 12832 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toFOLD_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toFOLD_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6670 "APItest.xs"
        RETVAL = toFOLD_LC(ord);
#line 12853 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toFOLD_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toFOLD_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6677 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12873 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6682 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toFOLD_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12887 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toFOLD_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toFOLD_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6697 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12911 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6702 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toFOLD_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12925 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toFOLD_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toFOLD_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6717 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
        const U8 * e;
        UV resultant_cp = UV_MAX;
#line 12952 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6725 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toFOLD_utf8_safe(input, e, s, &len);
            av_push(av, newSVuv(resultant_cp));

            utf8 = newSVpvn((char *) s, len);
            SvUTF8_on(utf8);
            av_push(av, utf8);

            av_push(av, newSVuv(len));
            RETVAL = av;
        }
        else {
            RETVAL = 0;
        }
#line 12976 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toUPPER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toUPPER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6748 "APItest.xs"
        RETVAL = toUPPER(ord);
#line 13001 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6755 "APItest.xs"
        RETVAL = toUPPER_LC(ord);
#line 13022 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6762 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 13042 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6767 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toUPPER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 13056 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toUPPER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toUPPER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6782 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 13080 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6787 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toUPPER_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 13094 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6802 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
        const U8 * e;
        UV resultant_cp = UV_MAX;
#line 13121 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6810 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toUPPER_utf8_safe(input, e, s, &len);
            av_push(av, newSVuv(resultant_cp));

            utf8 = newSVpvn((char *) s, len);
            SvUTF8_on(utf8);
            av_push(av, utf8);

            av_push(av, newSVuv(len));
            RETVAL = av;
        }
        else {
            RETVAL = 0;
        }
#line 13145 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toTITLE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toTITLE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6833 "APItest.xs"
        RETVAL = toTITLE(ord);
#line 13170 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toTITLE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toTITLE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6840 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 13190 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6845 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toTITLE_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 13204 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toTITLE_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toTITLE_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6860 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 13228 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6865 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toTITLE_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 13242 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_toTITLE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_toTITLE_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6880 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
        const U8 * e;
        UV resultant_cp = UV_MAX;
#line 13269 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6888 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toTITLE_utf8_safe(input, e, s, &len);
            av_push(av, newSVuv(resultant_cp));

            utf8 = newSVpvn((char *) s, len);
            SvUTF8_on(utf8);
            av_push(av, utf8);

            av_push(av, newSVuv(len));
            RETVAL = av;
        }
        else {
            RETVAL = 0;
        }
#line 13293 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_delimcpy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_delimcpy)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 6)
       croak_xs_usage(cv,  "from_sv, trunc_from, delim, to_len, trunc_to, poison= '?'");
    {
#line 6911 "APItest.xs"
        char * from;
        I32 retlen;
        char * from_pos_after_copy;
        char * to;
#line 13317 "APItest.c"
	AV *	RETVAL;
	SV *	from_sv = ST(0)
;
	STRLEN	trunc_from = (STRLEN)SvUV(ST(1))
;
	char	delim = (char)*SvPV_nolen(ST(2))
;
	STRLEN	to_len = (STRLEN)SvUV(ST(3))
;
	STRLEN	trunc_to = (STRLEN)SvUV(ST(4))
;
	char	poison;

	if (items < 6)
	    poison = '?';
	else {
	    poison = (char)*SvPV_nolen(ST(5))
;
	}
#line 6916 "APItest.xs"
        from = SvPV_nolen(from_sv);
        Newx(to, to_len, char);
        PoisonWith(to, to_len, char, poison);
        assert(trunc_from <= SvCUR(from_sv));
        /* trunc_to allows us to throttle the output size available */
        assert(trunc_to <= to_len);
        from_pos_after_copy = delimcpy(to, to + trunc_to,
                                       from, from + trunc_from,
                                       delim, &retlen);
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);
        av_push(RETVAL, newSVpvn(to, to_len));
        av_push(RETVAL, newSVuv(retlen));
        av_push(RETVAL, newSVuv(from_pos_after_copy - from));
        Safefree(to);
#line 13353 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_delimcpy_no_escape); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_delimcpy_no_escape)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 6)
       croak_xs_usage(cv,  "from_sv, trunc_from, delim, to_len, trunc_to, poison= '?'");
    {
#line 6937 "APItest.xs"
        char * from;
        AV *av;
        I32 retlen;
        char * from_pos_after_copy;
        char * to;
#line 13378 "APItest.c"
	AV *	RETVAL;
	SV *	from_sv = ST(0)
;
	STRLEN	trunc_from = (STRLEN)SvUV(ST(1))
;
	char	delim = (char)*SvPV_nolen(ST(2))
;
	STRLEN	to_len = (STRLEN)SvUV(ST(3))
;
	STRLEN	trunc_to = (STRLEN)SvUV(ST(4))
;
	char	poison;

	if (items < 6)
	    poison = '?';
	else {
	    poison = (char)*SvPV_nolen(ST(5))
;
	}
#line 6943 "APItest.xs"
        from = SvPV_nolen(from_sv);
        Newx(to, to_len, char);
        PoisonWith(to, to_len, char, poison);
        assert(trunc_from <= SvCUR(from_sv));
        /* trunc_to allows us to throttle the output size available */
        assert(trunc_to <= to_len);
        from_pos_after_copy = delimcpy_no_escape(to, to + trunc_to,
                                       from, from + trunc_from,
                                       delim, &retlen);
        av = newAV();
        av_push(av, newSVpvn(to, to_len));
        av_push(av, newSVuv(retlen));
        av_push(av, newSVuv(from_pos_after_copy - from));
        Safefree(to);
        RETVAL = av;
#line 13414 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_Gconvert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_Gconvert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, num_digits");
    {
#line 6964 "APItest.xs"
        char buffer[100];
        int len;
        int extras;
#line 13437 "APItest.c"
	SV *	RETVAL;
	SV *	number = ST(0)
;
	SV *	num_digits = ST(1)
;
#line 6968 "APItest.xs"
        len = (int) SvIV(num_digits);
        /* To silence a -Wformat-overflow compiler warning we     *
         * make allowance for the following characters that may   *
         * appear, in addition to the digits of the significand:  *
         * a leading "-", a single byte radix point, "e-", the    *
         * terminating NULL, and a 3 or 4 digit exponent.         *
         * Ie, allow 8 bytes if nvtype is "double", otherwise 9   *
         * bytes (as the exponent could then contain 4 digits ).  */
        extras = sizeof(NV) == 8 ? 8 : 9;
        if(len > 100 - extras)
            croak("Too long a number for test_Gconvert");
        if (len < 0)
            croak("Too short a number for test_Gconvert");
        PERL_UNUSED_RESULT(Gconvert(SvNV(number), len,
                 0,    /* No trailing zeroes */
                 buffer));
        RETVAL = newSVpv(buffer, 0);
#line 13461 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_Perl_langinfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_Perl_langinfo)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "item");
    {
	SV *	RETVAL;
	SV *	item = ST(0)
;
#line 6991 "APItest.xs"
        RETVAL = newSVpv(Perl_langinfo(SvIV(item)), 0);
#line 13481 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 7001 "APItest.xs"
        sv_rvweaken(sv);
#line 13500 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 7006 "APItest.xs"
        if (SvROK(sv) && sv_get_backrefs(SvRV(sv)))
            RETVAL = &PL_sv_yes;
        else
            RETVAL = &PL_sv_no;
#line 13521 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef WIN32
#ifdef PERL_IMPLICIT_SYS
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "path");
    {
	const char *	RETVAL;
	dXSTARG;
	const char *	path = (const char *)SvPV_nolen(ST(0))
;

	RETVAL = PerlDir_mapA(path);
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapW)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "wpath");
    {
	const WCHAR *	RETVAL;
	dXSTARG;
	const WCHAR *        wpath = (const WCHAR *)SvPV_nolen(ST(0))
;

	RETVAL = PerlDir_mapW(wpath);
	XSprePUSH;
	PUSHp((const char *)(RETVAL), sizeof(WCHAR) * (1+wcslen(RETVAL)));
    }
    XSRETURN(1);
}

#endif
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_XS__APItest__Backrefs_Comctl32Version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_Comctl32Version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 7027 "APItest.xs"
        HMODULE dll;
        VS_FIXEDFILEINFO *info;
        UINT len;
        HRSRC hrsc;
        HGLOBAL ver;
        void * vercopy;
#line 13593 "APItest.c"
#line 7034 "APItest.xs"
        dll = GetModuleHandle("comctl32.dll"); /* must already be in proc */
        if(!dll)
            croak("Comctl32Version: comctl32.dll not in process???");
        hrsc = FindResource(dll,    MAKEINTRESOURCE(VS_VERSION_INFO),
                                    MAKEINTRESOURCE((Size_t)VS_FILE_INFO));
        if(!hrsc)
            croak("Comctl32Version: comctl32.dll no version???");
        ver = LoadResource(dll, hrsc);
        len = SizeofResource(dll, hrsc);
        vercopy = (void *)sv_grow(sv_newmortal(),len);
        memcpy(vercopy, ver, len);
        if (VerQueryValue(vercopy, "\\", (void**)&info, &len)) {
            int dwValueMS1 = (info->dwFileVersionMS>>16);
            int dwValueMS2 = (info->dwFileVersionMS&0xffff);
            int dwValueLS1 = (info->dwFileVersionLS>>16);
            int dwValueLS2 = (info->dwFileVersionLS&0xffff);
            EXTEND(SP, 4);
            mPUSHi(dwValueMS1);
            mPUSHi(dwValueMS2);
            mPUSHi(dwValueLS1);
            mPUSHi(dwValueLS2);
        }
#line 13617 "APItest.c"
	PUTBACK;
	return;
    }
}

#endif
#if defined(USE_ITHREADS)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_XS__APItest__RWMacro_compile_macros); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__RWMacro_compile_macros)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 7067 "APItest.xs"
        perl_RnW1_mutex_t m;
        perl_RnW1_mutex_t *pm = &m;
#line 13638 "APItest.c"
#line 7070 "APItest.xs"
        PERL_RW_MUTEX_INIT(&m);
        PERL_WRITE_LOCK(&m);
        PERL_WRITE_UNLOCK(&m);
        PERL_READ_LOCK(&m);
        PERL_READ_UNLOCK(&m);
        PERL_RW_MUTEX_DESTROY(&m);
        PERL_RW_MUTEX_INIT(pm);
        PERL_WRITE_LOCK(pm);
        PERL_WRITE_UNLOCK(pm);
        PERL_READ_LOCK(pm);
        PERL_READ_UNLOCK(pm);
        PERL_RW_MUTEX_DESTROY(pm);
#line 13652 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_XS__APItest__HvMacro_u8_to_u16_le); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_u8_to_u16_le)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "sv, ofs");
    {
	UV	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
	STRLEN	ofs = (STRLEN)SvUV(ST(1))
;
#line 7094 "APItest.xs"
    {
        STRLEN len;
        char *pv= SvPV(sv,len);
        STRLEN minlen= 2<<ix;
        U16 u16;
        U32 u32;
        U64 u64;
        RETVAL= 0; /* silence warnings about uninitialized RETVAL */
        switch (ix) {
            case 0:
                if (ofs+minlen>len) croak("cowardly refusing to read past end of string in u8_to_u16_le");
                u16= U8TO16_LE(pv+ofs);
                RETVAL= (UV)u16;
                break;
            case 1:
                if (ofs+minlen>len) croak("cowardly refusing to read past end of string in u8_to_u32_le");
                u32= U8TO32_LE(pv+ofs);
                RETVAL= (UV)u32;
                break;
            case 2:
#if TEST_64BIT
                if (ofs+minlen>len) croak("cowardly refusing to read past end of string in u8_to_u64_le");
                u64= U8TO64_LE(pv+ofs);
                RETVAL= (UV)u64;
#else
                PERL_UNUSED_VAR(u64);
                croak("not a 64 bit perl IVSIZE=%d",IVSIZE);
#endif
                break;
        }
    }
#line 13705 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_rotl32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_rotl32)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "n, r");
    {
	U32	RETVAL;
	dXSTARG;
	U32	n = (unsigned long)SvUV(ST(0))
;
	U8	r = (U8)SvUV(ST(1))
;
#line 7131 "APItest.xs"
    {
        RETVAL= ROTL32(n,r);
    }
#line 13730 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_rotr32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_rotr32)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "n, r");
    {
	U32	RETVAL;
	dXSTARG;
	U32	n = (unsigned long)SvUV(ST(0))
;
	U8	r = (U8)SvUV(ST(1))
;
#line 7140 "APItest.xs"
    {
        RETVAL= ROTR32(n,r);
    }
#line 13755 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#if TEST_64BIT
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_XS__APItest__HvMacro_rotl64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_rotl64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "n, r");
    {
	UV	RETVAL;
	dXSTARG;
	UV	n = (UV)SvUV(ST(0))
;
	U8	r = (U8)SvUV(ST(1))
;
#line 7151 "APItest.xs"
    {
        RETVAL= ROTL64(n,r);
    }
#line 13783 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_rotr64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_rotr64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "n, r");
    {
	UV	RETVAL;
	dXSTARG;
	UV	n = (UV)SvUV(ST(0))
;
	U8	r = (U8)SvUV(ST(1))
;
#line 7160 "APItest.xs"
    {
        RETVAL= ROTR64(n,r);
    }
#line 13808 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_siphash_seed_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_siphash_seed_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "seed_sv");
    {
	SV *	RETVAL;
	SV *	seed_sv = ST(0)
;
#line 7169 "APItest.xs"
    {
        U8 state_buf[sizeof(U64)*4];
        STRLEN seed_len;
        U8 *seed_pv= (U8*)SvPV(seed_sv,seed_len);
        if (seed_len<16)  croak("seed should be 16 bytes long");
        else if (seed_len>16) warn("only using the first 16 bytes of seed");
        RETVAL= newSV(sizeof(U64)*4+3);
        S_perl_siphash_seed_state(seed_pv,state_buf);
        sv_setpvn(RETVAL,(char*)state_buf,sizeof(U64)*4);
    }
#line 13837 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_siphash24); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_siphash24)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "state_sv, str_sv");
    {
	UV	RETVAL;
	dXSTARG;
	SV *	state_sv = ST(0)
;
	SV *	str_sv = ST(1)
;
#line 7188 "APItest.xs"
    {
        STRLEN state_len;
        STRLEN str_len;
        U8 *str_pv= (U8*)SvPV(str_sv,str_len);
        /* (U8*)SvPV(state_sv, state_len) return differs between little-endian *
         * and big-endian. It's the same values, but in a different order.     *
         * On big-endian architecture, we transpose the values into the same   *
         * order as for little-endian, so that we can test against the same    *
         * test vectors.                                                       *
         * We could alternatively alter the code that produced state_sv to     *
         * output identical arrangements for big-endian and little-endian.     */
#if BYTEORDER == 0x1234 || BYTEORDER == 0x12345678
        U8 *state_pv= (U8*)SvPV(state_sv,state_len);
        if (state_len!=32) croak("siphash state should be exactly 32 bytes");
#else
        U8 *temp_pv = (U8*)SvPV(state_sv, state_len);
        U8 state_pv[32];
        int i;
        if (state_len!=32) croak("siphash state should be exactly 32 bytes");
        for( i = 0; i < 32; i++ ) {
            if     (i <  8) state_pv[ 7 - i] = temp_pv[i];
            else if(i < 16) state_pv[23 - i] = temp_pv[i];
            else if(i < 24) state_pv[39 - i] = temp_pv[i];
            else            state_pv[55 - i] = temp_pv[i];
        }
#endif
        if (ix) {
            RETVAL= S_perl_hash_siphash_1_3_with_state_64(state_pv,str_pv,str_len);
        } else {
            RETVAL= S_perl_hash_siphash_2_4_with_state_64(state_pv,str_pv,str_len);
        }
    }
#line 13892 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_test_siphash24); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_test_siphash24)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	UV	RETVAL;
	dXSTARG;
#line 7227 "APItest.xs"
    {
        U8 vectors[64][8] = {
              { 0x31, 0x0e, 0x0e, 0xdd, 0x47, 0xdb, 0x6f, 0x72, },
              { 0xfd, 0x67, 0xdc, 0x93, 0xc5, 0x39, 0xf8, 0x74, },
              { 0x5a, 0x4f, 0xa9, 0xd9, 0x09, 0x80, 0x6c, 0x0d, },
              { 0x2d, 0x7e, 0xfb, 0xd7, 0x96, 0x66, 0x67, 0x85, },
              { 0xb7, 0x87, 0x71, 0x27, 0xe0, 0x94, 0x27, 0xcf, },
              { 0x8d, 0xa6, 0x99, 0xcd, 0x64, 0x55, 0x76, 0x18, },
              { 0xce, 0xe3, 0xfe, 0x58, 0x6e, 0x46, 0xc9, 0xcb, },
              { 0x37, 0xd1, 0x01, 0x8b, 0xf5, 0x00, 0x02, 0xab, },
              { 0x62, 0x24, 0x93, 0x9a, 0x79, 0xf5, 0xf5, 0x93, },
              { 0xb0, 0xe4, 0xa9, 0x0b, 0xdf, 0x82, 0x00, 0x9e, },
              { 0xf3, 0xb9, 0xdd, 0x94, 0xc5, 0xbb, 0x5d, 0x7a, },
              { 0xa7, 0xad, 0x6b, 0x22, 0x46, 0x2f, 0xb3, 0xf4, },
              { 0xfb, 0xe5, 0x0e, 0x86, 0xbc, 0x8f, 0x1e, 0x75, },
              { 0x90, 0x3d, 0x84, 0xc0, 0x27, 0x56, 0xea, 0x14, },
              { 0xee, 0xf2, 0x7a, 0x8e, 0x90, 0xca, 0x23, 0xf7, },
              { 0xe5, 0x45, 0xbe, 0x49, 0x61, 0xca, 0x29, 0xa1, },
              { 0xdb, 0x9b, 0xc2, 0x57, 0x7f, 0xcc, 0x2a, 0x3f, },
              { 0x94, 0x47, 0xbe, 0x2c, 0xf5, 0xe9, 0x9a, 0x69, },
              { 0x9c, 0xd3, 0x8d, 0x96, 0xf0, 0xb3, 0xc1, 0x4b, },
              { 0xbd, 0x61, 0x79, 0xa7, 0x1d, 0xc9, 0x6d, 0xbb, },
              { 0x98, 0xee, 0xa2, 0x1a, 0xf2, 0x5c, 0xd6, 0xbe, },
              { 0xc7, 0x67, 0x3b, 0x2e, 0xb0, 0xcb, 0xf2, 0xd0, },
              { 0x88, 0x3e, 0xa3, 0xe3, 0x95, 0x67, 0x53, 0x93, },
              { 0xc8, 0xce, 0x5c, 0xcd, 0x8c, 0x03, 0x0c, 0xa8, },
              { 0x94, 0xaf, 0x49, 0xf6, 0xc6, 0x50, 0xad, 0xb8, },
              { 0xea, 0xb8, 0x85, 0x8a, 0xde, 0x92, 0xe1, 0xbc, },
              { 0xf3, 0x15, 0xbb, 0x5b, 0xb8, 0x35, 0xd8, 0x17, },
              { 0xad, 0xcf, 0x6b, 0x07, 0x63, 0x61, 0x2e, 0x2f, },
              { 0xa5, 0xc9, 0x1d, 0xa7, 0xac, 0xaa, 0x4d, 0xde, },
              { 0x71, 0x65, 0x95, 0x87, 0x66, 0x50, 0xa2, 0xa6, },
              { 0x28, 0xef, 0x49, 0x5c, 0x53, 0xa3, 0x87, 0xad, },
              { 0x42, 0xc3, 0x41, 0xd8, 0xfa, 0x92, 0xd8, 0x32, },
              { 0xce, 0x7c, 0xf2, 0x72, 0x2f, 0x51, 0x27, 0x71, },
              { 0xe3, 0x78, 0x59, 0xf9, 0x46, 0x23, 0xf3, 0xa7, },
              { 0x38, 0x12, 0x05, 0xbb, 0x1a, 0xb0, 0xe0, 0x12, },
              { 0xae, 0x97, 0xa1, 0x0f, 0xd4, 0x34, 0xe0, 0x15, },
              { 0xb4, 0xa3, 0x15, 0x08, 0xbe, 0xff, 0x4d, 0x31, },
              { 0x81, 0x39, 0x62, 0x29, 0xf0, 0x90, 0x79, 0x02, },
              { 0x4d, 0x0c, 0xf4, 0x9e, 0xe5, 0xd4, 0xdc, 0xca, },
              { 0x5c, 0x73, 0x33, 0x6a, 0x76, 0xd8, 0xbf, 0x9a, },
              { 0xd0, 0xa7, 0x04, 0x53, 0x6b, 0xa9, 0x3e, 0x0e, },
              { 0x92, 0x59, 0x58, 0xfc, 0xd6, 0x42, 0x0c, 0xad, },
              { 0xa9, 0x15, 0xc2, 0x9b, 0xc8, 0x06, 0x73, 0x18, },
              { 0x95, 0x2b, 0x79, 0xf3, 0xbc, 0x0a, 0xa6, 0xd4, },
              { 0xf2, 0x1d, 0xf2, 0xe4, 0x1d, 0x45, 0x35, 0xf9, },
              { 0x87, 0x57, 0x75, 0x19, 0x04, 0x8f, 0x53, 0xa9, },
              { 0x10, 0xa5, 0x6c, 0xf5, 0xdf, 0xcd, 0x9a, 0xdb, },
              { 0xeb, 0x75, 0x09, 0x5c, 0xcd, 0x98, 0x6c, 0xd0, },
              { 0x51, 0xa9, 0xcb, 0x9e, 0xcb, 0xa3, 0x12, 0xe6, },
              { 0x96, 0xaf, 0xad, 0xfc, 0x2c, 0xe6, 0x66, 0xc7, },
              { 0x72, 0xfe, 0x52, 0x97, 0x5a, 0x43, 0x64, 0xee, },
              { 0x5a, 0x16, 0x45, 0xb2, 0x76, 0xd5, 0x92, 0xa1, },
              { 0xb2, 0x74, 0xcb, 0x8e, 0xbf, 0x87, 0x87, 0x0a, },
              { 0x6f, 0x9b, 0xb4, 0x20, 0x3d, 0xe7, 0xb3, 0x81, },
              { 0xea, 0xec, 0xb2, 0xa3, 0x0b, 0x22, 0xa8, 0x7f, },
              { 0x99, 0x24, 0xa4, 0x3c, 0xc1, 0x31, 0x57, 0x24, },
              { 0xbd, 0x83, 0x8d, 0x3a, 0xaf, 0xbf, 0x8d, 0xb7, },
              { 0x0b, 0x1a, 0x2a, 0x32, 0x65, 0xd5, 0x1a, 0xea, },
              { 0x13, 0x50, 0x79, 0xa3, 0x23, 0x1c, 0xe6, 0x60, },
              { 0x93, 0x2b, 0x28, 0x46, 0xe4, 0xd7, 0x06, 0x66, },
              { 0xe1, 0x91, 0x5f, 0x5c, 0xb1, 0xec, 0xa4, 0x6c, },
              { 0xf3, 0x25, 0x96, 0x5c, 0xa1, 0x6d, 0x62, 0x9f, },
              { 0x57, 0x5f, 0xf2, 0x8e, 0x60, 0x38, 0x1b, 0xe5, },
              { 0x72, 0x45, 0x06, 0xeb, 0x4c, 0x32, 0x8a, 0x95, }
            };
        U32 vectors_32[64] = {
            0xaf61d576,
            0xe7245e38,
            0xd4c5cf53,
            0x529c18bb,
            0xe8561357,
            0xd5eff3e9,
            0x9337a5a0,
            0x2003d1c2,
            0x0966d11b,
            0x95a9666f,
            0xee800236,
            0xd6d882e1,
            0xf3106a47,
            0xd46e6bb7,
            0x7959387e,
            0xe8978f84,
            0x68e857a4,
            0x4524ae61,
            0xdd4c606c,
            0x1c14a8a0,
            0xa474b26a,
            0xfec9ac77,
            0x70f0591d,
            0x6550cd44,
            0x4ee4ff52,
            0x36642a34,
            0x4c63204b,
            0x2845aece,
            0x79506309,
            0x21373517,
            0xf1ce4c7b,
            0xea9951b8,
            0x03d52de1,
            0x5eaa5ba5,
            0xa9e5a222,
            0x1a41a37a,
            0x39585c0a,
            0x2b1ba971,
            0x5428d8a8,
            0xf08cab2a,
            0x5d3a0ebb,
            0x51541b44,
            0x83b11361,
            0x27df2129,
            0x1dc758ef,
            0xb026d883,
            0x2ef668cf,
            0x8c65ed26,
            0x78d90a9a,
            0x3bcb49ba,
            0x7936bd28,
            0x13d7c32c,
            0x844cf30d,
            0xa1077c52,
            0xdc1acee1,
            0x18f31558,
            0x8d003c12,
            0xd830cf6e,
            0xc39f4c30,
            0x202efc77,
            0x30fb7d50,
            0xc3f44852,
            0x6be96737,
            0x7e8c773e
        };

        const U8 MAXLEN= 64;
        U8 in[64], seed_pv[16], state_pv[32];
        union {
            U64 hash;
            U32 h32[2];
            U8 bytes[8];
        } out;
        int i,j;
        int failed = 0;
        U32 hash32;
        /* S_perl_siphash_seed_state(seed_pv, state_pv) sets state_pv          *
         * differently between little-endian and big-endian. It's the same     *
         * values, but in a different order.                                   *
         * On big-endian architecture, we transpose the values into the same   *
         * order as for little-endian, so that we can test against the same    *
         * test vectors.                                                       *
         * We could alternatively alter the code that produces state_pv to     *
         * output identical arrangements for big-endian and little-endian.     */
#if BYTEORDER == 0x1234 || BYTEORDER == 0x12345678
        for( i = 0; i < 16; ++i ) seed_pv[i] = i;
        S_perl_siphash_seed_state(seed_pv, state_pv);
#else
        U8 temp_pv[32];
        for( i = 0; i < 16; ++i ) seed_pv[i] = i;
        S_perl_siphash_seed_state(seed_pv, temp_pv);
        for( i = 0; i < 32; ++i ) {
            if     (i <  8) state_pv[ 7 - i] = temp_pv[i];
            else if(i < 16) state_pv[23 - i] = temp_pv[i];
            else if(i < 24) state_pv[39 - i] = temp_pv[i];
            else            state_pv[55 - i] = temp_pv[i];
        }
#endif
        for( i = 0; i < MAXLEN; ++i )
        {
            in[i] = i;

            out.hash= S_perl_hash_siphash_2_4_with_state_64( state_pv, in, i );

            hash32= S_perl_hash_siphash_2_4_with_state( state_pv, in, i);
            /* The test vectors need to reversed here for big-endian architecture   *
             * Alternatively we could rewrite S_perl_hash_siphash_2_4_with_state_64 *
             * to produce reversed vectors when run on big-endian architecture      */
#if BYTEORDER == 0x4321 || BYTEORDER == 0x87654321 /* reverse order of vectors[i] */
            temp_pv   [0] = vectors[i][0]; /* temp_pv is temporary holder of vectors[i][0] */
            vectors[i][0] = vectors[i][7];
            vectors[i][7] = temp_pv[0];

            temp_pv   [0] = vectors[i][1]; /* temp_pv is temporary holder of vectors[i][1] */
            vectors[i][1] = vectors[i][6];
            vectors[i][6] = temp_pv[0];

            temp_pv   [0] = vectors[i][2]; /* temp_pv is temporary holder of vectors[i][2] */
            vectors[i][2] = vectors[i][5];
            vectors[i][5] = temp_pv[0];

            temp_pv   [0] = vectors[i][3]; /* temp_pv is temporary holder of vectors[i][3] */
            vectors[i][3] = vectors[i][4];
            vectors[i][4] = temp_pv[0];
#endif
            if ( memcmp( out.bytes, vectors[i], 8 ) )
            {
                failed++;
                printf( "Error in 64 bit result on test vector of length %d for siphash24\n    have: {", i );
                for (j=0;j<7;j++)
                    printf( "0x%02x, ", out.bytes[j]);
                printf( "0x%02x },\n", out.bytes[7]);
                printf( "    want: {" );
                for (j=0;j<7;j++)
                    printf( "0x%02x, ", vectors[i][j]);
                printf( "0x%02x },\n", vectors[i][7]);
            }
            if (hash32 != vectors_32[i]) {
                failed++;
                printf( "Error in 32 bit result on test vector of length %d for siphash24\n"
                        "    have: 0x%08x\n"
                        "    want: 0x%08x\n",
                    i, hash32, vectors_32[i]);
            }
        }
        RETVAL= failed;
    }
#line 14125 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__HvMacro_test_siphash13); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__HvMacro_test_siphash13)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	UV	RETVAL;
	dXSTARG;
#line 7448 "APItest.xs"
    {
        U8 vectors[64][8] = {
            {0xdc, 0xc4, 0x0f, 0x05, 0x58, 0x01, 0xac, 0xab },
            {0x93, 0xca, 0x57, 0x7d, 0xf3, 0x9b, 0xf4, 0xc9 },
            {0x4d, 0xd4, 0xc7, 0x4d, 0x02, 0x9b, 0xcb, 0x82 },
            {0xfb, 0xf7, 0xdd, 0xe7, 0xb8, 0x0a, 0xf8, 0x8b },
            {0x28, 0x83, 0xd3, 0x88, 0x60, 0x57, 0x75, 0xcf },
            {0x67, 0x3b, 0x53, 0x49, 0x2f, 0xd5, 0xf9, 0xde },
            {0xa7, 0x22, 0x9f, 0xc5, 0x50, 0x2b, 0x0d, 0xc5 },
            {0x40, 0x11, 0xb1, 0x9b, 0x98, 0x7d, 0x92, 0xd3 },
            {0x8e, 0x9a, 0x29, 0x8d, 0x11, 0x95, 0x90, 0x36 },
            {0xe4, 0x3d, 0x06, 0x6c, 0xb3, 0x8e, 0xa4, 0x25 },
            {0x7f, 0x09, 0xff, 0x92, 0xee, 0x85, 0xde, 0x79 },
            {0x52, 0xc3, 0x4d, 0xf9, 0xc1, 0x18, 0xc1, 0x70 },
            {0xa2, 0xd9, 0xb4, 0x57, 0xb1, 0x84, 0xa3, 0x78 },
            {0xa7, 0xff, 0x29, 0x12, 0x0c, 0x76, 0x6f, 0x30 },
            {0x34, 0x5d, 0xf9, 0xc0, 0x11, 0xa1, 0x5a, 0x60 },
            {0x56, 0x99, 0x51, 0x2a, 0x6d, 0xd8, 0x20, 0xd3 },
            {0x66, 0x8b, 0x90, 0x7d, 0x1a, 0xdd, 0x4f, 0xcc },
            {0x0c, 0xd8, 0xdb, 0x63, 0x90, 0x68, 0xf2, 0x9c },
            {0x3e, 0xe6, 0x73, 0xb4, 0x9c, 0x38, 0xfc, 0x8f },
            {0x1c, 0x7d, 0x29, 0x8d, 0xe5, 0x9d, 0x1f, 0xf2 },
            {0x40, 0xe0, 0xcc, 0xa6, 0x46, 0x2f, 0xdc, 0xc0 },
            {0x44, 0xf8, 0x45, 0x2b, 0xfe, 0xab, 0x92, 0xb9 },
            {0x2e, 0x87, 0x20, 0xa3, 0x9b, 0x7b, 0xfe, 0x7f },
            {0x23, 0xc1, 0xe6, 0xda, 0x7f, 0x0e, 0x5a, 0x52 },
            {0x8c, 0x9c, 0x34, 0x67, 0xb2, 0xae, 0x64, 0xf4 },
            {0x79, 0x09, 0x5b, 0x70, 0x28, 0x59, 0xcd, 0x45 },
            {0xa5, 0x13, 0x99, 0xca, 0xe3, 0x35, 0x3e, 0x3a },
            {0x35, 0x3b, 0xde, 0x4a, 0x4e, 0xc7, 0x1d, 0xa9 },
            {0x0d, 0xd0, 0x6c, 0xef, 0x02, 0xed, 0x0b, 0xfb },
            {0xf4, 0xe1, 0xb1, 0x4a, 0xb4, 0x3c, 0xd9, 0x88 },
            {0x63, 0xe6, 0xc5, 0x43, 0xd6, 0x11, 0x0f, 0x54 },
            {0xbc, 0xd1, 0x21, 0x8c, 0x1f, 0xdd, 0x70, 0x23 },
            {0x0d, 0xb6, 0xa7, 0x16, 0x6c, 0x7b, 0x15, 0x81 },
            {0xbf, 0xf9, 0x8f, 0x7a, 0xe5, 0xb9, 0x54, 0x4d },
            {0x3e, 0x75, 0x2a, 0x1f, 0x78, 0x12, 0x9f, 0x75 },
            {0x91, 0x6b, 0x18, 0xbf, 0xbe, 0xa3, 0xa1, 0xce },
            {0x06, 0x62, 0xa2, 0xad, 0xd3, 0x08, 0xf5, 0x2c },
            {0x57, 0x30, 0xc3, 0xa3, 0x2d, 0x1c, 0x10, 0xb6 },
            {0xa1, 0x36, 0x3a, 0xae, 0x96, 0x74, 0xf4, 0xb3 },
            {0x92, 0x83, 0x10, 0x7b, 0x54, 0x57, 0x6b, 0x62 },
            {0x31, 0x15, 0xe4, 0x99, 0x32, 0x36, 0xd2, 0xc1 },
            {0x44, 0xd9, 0x1a, 0x3f, 0x92, 0xc1, 0x7c, 0x66 },
            {0x25, 0x88, 0x13, 0xc8, 0xfe, 0x4f, 0x70, 0x65 },
            {0xa6, 0x49, 0x89, 0xc2, 0xd1, 0x80, 0xf2, 0x24 },
            {0x6b, 0x87, 0xf8, 0xfa, 0xed, 0x1c, 0xca, 0xc2 },
            {0x96, 0x21, 0x04, 0x9f, 0xfc, 0x4b, 0x16, 0xc2 },
            {0x23, 0xd6, 0xb1, 0x68, 0x93, 0x9c, 0x6e, 0xa1 },
            {0xfd, 0x14, 0x51, 0x8b, 0x9c, 0x16, 0xfb, 0x49 },
            {0x46, 0x4c, 0x07, 0xdf, 0xf8, 0x43, 0x31, 0x9f },
            {0xb3, 0x86, 0xcc, 0x12, 0x24, 0xaf, 0xfd, 0xc6 },
            {0x8f, 0x09, 0x52, 0x0a, 0xd1, 0x49, 0xaf, 0x7e },
            {0x9a, 0x2f, 0x29, 0x9d, 0x55, 0x13, 0xf3, 0x1c },
            {0x12, 0x1f, 0xf4, 0xa2, 0xdd, 0x30, 0x4a, 0xc4 },
            {0xd0, 0x1e, 0xa7, 0x43, 0x89, 0xe9, 0xfa, 0x36 },
            {0xe6, 0xbc, 0xf0, 0x73, 0x4c, 0xb3, 0x8f, 0x31 },
            {0x80, 0xe9, 0xa7, 0x70, 0x36, 0xbf, 0x7a, 0xa2 },
            {0x75, 0x6d, 0x3c, 0x24, 0xdb, 0xc0, 0xbc, 0xb4 },
            {0x13, 0x15, 0xb7, 0xfd, 0x52, 0xd8, 0xf8, 0x23 },
            {0x08, 0x8a, 0x7d, 0xa6, 0x4d, 0x5f, 0x03, 0x8f },
            {0x48, 0xf1, 0xe8, 0xb7, 0xe5, 0xd0, 0x9c, 0xd8 },
            {0xee, 0x44, 0xa6, 0xf7, 0xbc, 0xe6, 0xf4, 0xf6 },
            {0xf2, 0x37, 0x18, 0x0f, 0xd8, 0x9a, 0xc5, 0xae },
            {0xe0, 0x94, 0x66, 0x4b, 0x15, 0xf6, 0xb2, 0xc3 },
            {0xa8, 0xb3, 0xbb, 0xb7, 0x62, 0x90, 0x19, 0x9d }
        };
        U32 vectors_32[64] = {
            0xaea3c584,
            0xb4a35160,
            0xcf0c4f4f,
            0x6c25fd43,
            0x47a6d448,
            0x97aaee48,
            0x009209f7,
            0x48236cd8,
            0xbbb90f9f,
            0x49a2b357,
            0xeb218c91,
            0x898cdb93,
            0x2f175d13,
            0x224689ab,
            0xa0a3fc25,
            0xf971413b,
            0xb1df567c,
            0xff29b09c,
            0x3b8fdea2,
            0x7f36e0f9,
            0x6610cf06,
            0x92d753ba,
            0xdcdefcb5,
            0x88bccf5c,
            0x9350323e,
            0x35965051,
            0xf0a72646,
            0xe3c3fc7b,
            0x14673d0f,
            0xc268dd40,
            0x17caf7b5,
            0xaf510ca3,
            0x97b2cd61,
            0x37db405a,
            0x6ab56746,
            0x71b9c82f,
            0x81576ad5,
            0x15d32c7a,
            0x1dce4237,
            0x197bd4c6,
            0x58362303,
            0x596618d6,
            0xad63c7db,
            0xe67bc977,
            0x38329b86,
            0x5d126a6a,
            0xc9df4ab0,
            0xc2aa0261,
            0x40360fbe,
            0xd4312997,
            0x74fd405e,
            0x81da3ccf,
            0x66be2fcf,
            0x755df759,
            0x427f0faa,
            0xd2dd56b6,
            0x9080adae,
            0xde4fcd41,
            0x297ed545,
            0x6f7421ad,
            0x0152a252,
            0xa1ddad2a,
            0x88d462f5,
            0x2aa223ca,
        };

        const U8 MAXLEN= 64;
        U8 in[64], seed_pv[16], state_pv[32];
        union {
            U64 hash;
            U32 h32[2];
            U8 bytes[8];
        } out;
        int i,j;
        int failed = 0;
        U32 hash32;
        /* S_perl_siphash_seed_state(seed_pv, state_pv) sets state_pv          *
         * differently between little-endian and big-endian. It's the same     *
         * values, but in a different order.                                   *
         * On big-endian architecture, we transpose the values into the same   *
         * order as for little-endian, so that we can test against the same    *
         * test vectors.                                                       *
         * We could alternatively alter the code that produces state_pv to     *
         * output identical arrangements for big-endian and little-endian.     */
#if BYTEORDER == 0x1234 || BYTEORDER == 0x12345678
        for( i = 0; i < 16; ++i ) seed_pv[i] = i;
        S_perl_siphash_seed_state(seed_pv, state_pv);
#else
        U8 temp_pv[32];
        for( i = 0; i < 16; ++i ) seed_pv[i] = i;
        S_perl_siphash_seed_state(seed_pv, temp_pv);
        for( i = 0; i < 32; ++i ) {
            if     (i <  8) state_pv[ 7 - i] = temp_pv[i];
            else if(i < 16) state_pv[23 - i] = temp_pv[i];
            else if(i < 24) state_pv[39 - i] = temp_pv[i];
            else            state_pv[55 - i] = temp_pv[i];
        }
#endif
        for( i = 0; i < MAXLEN;  ++i )
        {
            in[i] = i;

            out.hash= S_perl_hash_siphash_1_3_with_state_64( state_pv, in, i );

            hash32= S_perl_hash_siphash_1_3_with_state( state_pv, in, i);
            /* The test vectors need to reversed here for big-endian architecture   *
             * Alternatively we could rewrite S_perl_hash_siphash_1_3_with_state_64 *
             * to produce reversed vectors when run on big-endian architecture      */
#if BYTEORDER == 0x4321 || BYTEORDER == 0x87654321
            temp_pv   [0] = vectors[i][0]; /* temp_pv is temporary holder of vectors[i][0] */
            vectors[i][0] = vectors[i][7];
            vectors[i][7] = temp_pv[0];

            temp_pv   [0] = vectors[i][1]; /* temp_pv is temporary holder of vectors[i][1] */
            vectors[i][1] = vectors[i][6];
            vectors[i][6] = temp_pv[0];

            temp_pv   [0] = vectors[i][2]; /* temp_pv is temporary holder of vectors[i][2] */
            vectors[i][2] = vectors[i][5];
            vectors[i][5] = temp_pv[0];

            temp_pv   [0] = vectors[i][3]; /* temp_pv is temporary holder of vectors[i][3] */
            vectors[i][3] = vectors[i][4];
            vectors[i][4] = temp_pv[0];
#endif
            if ( memcmp( out.bytes, vectors[i], 8 ) )
            {
                failed++;
                printf( "Error in 64 bit result on test vector of length %d for siphash13\n    have: {", i );
                for (j=0;j<7;j++)
                    printf( "0x%02x, ", out.bytes[j]);
                printf( "0x%02x },\n", out.bytes[7]);
                printf( "    want: {" );
                for (j=0;j<7;j++)
                    printf( "0x%02x, ", vectors[i][j]);
                printf( "0x%02x },\n", vectors[i][7]);
            }
            if (hash32 != vectors_32[i]) {
                failed++;
                printf( "Error in 32 bit result on test vector of length %d for siphash13\n"
                        "    have: 0x%08x\n"
                        "    want: 0x%08x\n",
                    i, hash32, vectors_32[i]);
            }
        }
        RETVAL= failed;
    }
#line 14358 "APItest.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_XS__APItest); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_XS__APItest)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("XS::APItest::constant", XS_XS__APItest_constant);
        newXS_deffile("XS::APItest::numeric::grok_number", XS_XS__APItest__numeric_grok_number);
        newXS_deffile("XS::APItest::numeric::grok_number_flags", XS_XS__APItest__numeric_grok_number_flags);
        newXS_deffile("XS::APItest::numeric::grok_atoUV", XS_XS__APItest__numeric_grok_atoUV);
        newXS_deffile("XS::APItest::numeric::my_strtod", XS_XS__APItest__numeric_my_strtod);
        newXS_deffile("XS::APItest::numeric::assertx", XS_XS__APItest__numeric_assertx);
        newXS_deffile("XS::APItest::utf8::bytes_cmp_utf8", XS_XS__APItest__utf8_bytes_cmp_utf8);
        newXS_deffile("XS::APItest::utf8::test_utf8_to_bytes", XS_XS__APItest__utf8_test_utf8_to_bytes);
        newXS_deffile("XS::APItest::utf8::test_utf8n_to_uvchr_msgs", XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs);
        newXS_deffile("XS::APItest::utf8::test_utf8n_to_uvchr_error", XS_XS__APItest__utf8_test_utf8n_to_uvchr_error);
        newXS_deffile("XS::APItest::utf8::test_valid_utf8_to_uvchr", XS_XS__APItest__utf8_test_valid_utf8_to_uvchr);
        newXS_deffile("XS::APItest::utf8::test_uvchr_to_utf8_flags", XS_XS__APItest__utf8_test_uvchr_to_utf8_flags);
        newXS_deffile("XS::APItest::utf8::test_uvchr_to_utf8_flags_msgs", XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs);
        newXS_deffile("XS::APItest::Overload::amagic_deref_call", XS_XS__APItest__Overload_amagic_deref_call);
        newXS_deffile("XS::APItest::Overload::tryAMAGICunDEREF_var", XS_XS__APItest__Overload_tryAMAGICunDEREF_var);
        newXS_deffile("XS::APItest::XSUB::XS_VERSION_defined", XS_XS__APItest__XSUB_XS_VERSION_defined);
        newXS_deffile("XS::APItest::XSUB::XS_APIVERSION_valid", XS_XS__APItest__XSUB_XS_APIVERSION_valid);
        newXS_deffile("XS::APItest::XSUB::xsreturn", XS_XS__APItest__XSUB_xsreturn);
        newXS_deffile("XS::APItest::XSUB::xsreturn_iv", XS_XS__APItest__XSUB_xsreturn_iv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_uv", XS_XS__APItest__XSUB_xsreturn_uv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_nv", XS_XS__APItest__XSUB_xsreturn_nv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_pv", XS_XS__APItest__XSUB_xsreturn_pv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_pvn", XS_XS__APItest__XSUB_xsreturn_pvn);
        newXS_deffile("XS::APItest::XSUB::xsreturn_no", XS_XS__APItest__XSUB_xsreturn_no);
        newXS_deffile("XS::APItest::XSUB::xsreturn_yes", XS_XS__APItest__XSUB_xsreturn_yes);
        newXS_deffile("XS::APItest::XSUB::xsreturn_undef", XS_XS__APItest__XSUB_xsreturn_undef);
        newXS_deffile("XS::APItest::XSUB::xsreturn_empty", XS_XS__APItest__XSUB_xsreturn_empty);
        newXS_deffile("XS::APItest::Hash::rot13_hash", XS_XS__APItest__Hash_rot13_hash);
        newXS_deffile("XS::APItest::Hash::bitflip_hash", XS_XS__APItest__Hash_bitflip_hash);
        newXS_deffile("XS::APItest::Hash::exists", XS_XS__APItest__Hash_exists);
        newXS_deffile("XS::APItest::Hash::exists_ent", XS_XS__APItest__Hash_exists_ent);
        newXS_deffile("XS::APItest::Hash::delete", XS_XS__APItest__Hash_delete);
        newXS_deffile("XS::APItest::Hash::delete_ent", XS_XS__APItest__Hash_delete_ent);
        newXS_deffile("XS::APItest::Hash::store_ent", XS_XS__APItest__Hash_store_ent);
        newXS_deffile("XS::APItest::Hash::store", XS_XS__APItest__Hash_store);
        newXS_deffile("XS::APItest::Hash::fetch_ent", XS_XS__APItest__Hash_fetch_ent);
        newXS_deffile("XS::APItest::Hash::fetch", XS_XS__APItest__Hash_fetch);
        newXS_deffile("XS::APItest::Hash::common", XS_XS__APItest__Hash_common);
        newXS_deffile("XS::APItest::Hash::test_hv_free_ent", XS_XS__APItest__Hash_test_hv_free_ent);
        newXS_deffile("XS::APItest::Hash::test_hv_delayfree_ent", XS_XS__APItest__Hash_test_hv_delayfree_ent);
        newXS_deffile("XS::APItest::Hash::test_share_unshare_pvn", XS_XS__APItest__Hash_test_share_unshare_pvn);
        newXS_deffile("XS::APItest::Hash::refcounted_he_exists", XS_XS__APItest__Hash_refcounted_he_exists);
        newXS_deffile("XS::APItest::Hash::refcounted_he_fetch", XS_XS__APItest__Hash_refcounted_he_fetch);
        newXS_deffile("XS::APItest::Hash::test_force_keys", XS_XS__APItest__Hash_test_force_keys);
        newXS_deffile("XS::APItest::TempLv::make_temp_mg_lv", XS_XS__APItest__TempLv_make_temp_mg_lv);
        newXS_deffile("XS::APItest::PtrTable::new", XS_XS__APItest__PtrTable_new);
        newXS_deffile("XS::APItest::PtrTable::DESTROY", XS_XS__APItest__PtrTable_DESTROY);
        newXS_deffile("XS::APItest::PtrTable::store", XS_XS__APItest__PtrTable_store);
        newXS_deffile("XS::APItest::PtrTable::fetch", XS_XS__APItest__PtrTable_fetch);
        newXS_deffile("XS::APItest::PtrTable::split", XS_XS__APItest__PtrTable_split);
        newXS_deffile("XS::APItest::AutoLoader::AUTOLOAD", XS_XS__APItest__AutoLoader_AUTOLOAD);
        (void)newXSproto_portable("XS::APItest::AutoLoader::AUTOLOADp", XS_XS__APItest__AutoLoader_AUTOLOADp, file, "*$");
        newXS_deffile("XS::APItest::xop_custom_ops", XS_XS__APItest_xop_custom_ops);
        newXS_deffile("XS::APItest::xop_custom_op_names", XS_XS__APItest_xop_custom_op_names);
        newXS_deffile("XS::APItest::xop_custom_op_descs", XS_XS__APItest_xop_custom_op_descs);
        newXS_deffile("XS::APItest::xop_register", XS_XS__APItest_xop_register);
        newXS_deffile("XS::APItest::xop_clear", XS_XS__APItest_xop_clear);
        newXS_deffile("XS::APItest::xop_my_xop", XS_XS__APItest_xop_my_xop);
        newXS_deffile("XS::APItest::xop_ppaddr", XS_XS__APItest_xop_ppaddr);
        newXS_deffile("XS::APItest::xop_OA_UNOP", XS_XS__APItest_xop_OA_UNOP);
        newXS_deffile("XS::APItest::xop_build_optree", XS_XS__APItest_xop_build_optree);
        newXS_deffile("XS::APItest::xop_from_custom_op", XS_XS__APItest_xop_from_custom_op);
        newXS_deffile("XS::APItest::CLONE", XS_XS__APItest_CLONE);
        newXS_deffile("XS::APItest::print_double", XS_XS__APItest_print_double);
        newXS_deffile("XS::APItest::have_long_double", XS_XS__APItest_have_long_double);
        newXS_deffile("XS::APItest::print_long_double", XS_XS__APItest_print_long_double);
        newXS_deffile("XS::APItest::print_long_doubleL", XS_XS__APItest_print_long_doubleL);
        newXS_deffile("XS::APItest::print_int", XS_XS__APItest_print_int);
        newXS_deffile("XS::APItest::print_long", XS_XS__APItest_print_long);
        newXS_deffile("XS::APItest::print_float", XS_XS__APItest_print_float);
        newXS_deffile("XS::APItest::print_flush", XS_XS__APItest_print_flush);
        newXS_deffile("XS::APItest::mpushp", XS_XS__APItest_mpushp);
        newXS_deffile("XS::APItest::mpushn", XS_XS__APItest_mpushn);
        newXS_deffile("XS::APItest::mpushi", XS_XS__APItest_mpushi);
        newXS_deffile("XS::APItest::mpushu", XS_XS__APItest_mpushu);
        newXS_deffile("XS::APItest::mxpushp", XS_XS__APItest_mxpushp);
        newXS_deffile("XS::APItest::mxpushn", XS_XS__APItest_mxpushn);
        newXS_deffile("XS::APItest::mxpushi", XS_XS__APItest_mxpushi);
        newXS_deffile("XS::APItest::mxpushu", XS_XS__APItest_mxpushu);
        newXS_deffile("XS::APItest::test_EXTEND", XS_XS__APItest_test_EXTEND);
        newXS_deffile("XS::APItest::call_sv_C", XS_XS__APItest_call_sv_C);
        newXS_deffile("XS::APItest::call_sv", XS_XS__APItest_call_sv);
        newXS_deffile("XS::APItest::call_pv", XS_XS__APItest_call_pv);
        newXS_deffile("XS::APItest::call_argv", XS_XS__APItest_call_argv);
        newXS_deffile("XS::APItest::call_method", XS_XS__APItest_call_method);
        cv = newXS_deffile("XS::APItest::newCONSTSUB", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::newCONSTSUB_flags", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::gv_init_type", XS_XS__APItest_gv_init_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_type", XS_XS__APItest_gv_fetchmeth_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_autoload_type", XS_XS__APItest_gv_fetchmeth_autoload_type);
        newXS_deffile("XS::APItest::gv_fetchmethod_flags_type", XS_XS__APItest_gv_fetchmethod_flags_type);
        newXS_deffile("XS::APItest::gv_autoload_type", XS_XS__APItest_gv_autoload_type);
        newXS_deffile("XS::APItest::gv_const_sv", XS_XS__APItest_gv_const_sv);
        newXS_deffile("XS::APItest::whichsig_type", XS_XS__APItest_whichsig_type);
        newXS_deffile("XS::APItest::eval_sv", XS_XS__APItest_eval_sv);
        newXS_deffile("XS::APItest::eval_pv", XS_XS__APItest_eval_pv);
        newXS_deffile("XS::APItest::require_pv", XS_XS__APItest_require_pv);
        newXS_deffile("XS::APItest::apitest_exception", XS_XS__APItest_apitest_exception);
        newXS_deffile("XS::APItest::mycroak", XS_XS__APItest_mycroak);
        newXS_deffile("XS::APItest::strtab", XS_XS__APItest_strtab);
        newXS_deffile("XS::APItest::my_cxt_getint", XS_XS__APItest_my_cxt_getint);
        newXS_deffile("XS::APItest::my_cxt_setint", XS_XS__APItest_my_cxt_setint);
        newXS_deffile("XS::APItest::my_cxt_getsv", XS_XS__APItest_my_cxt_getsv);
        newXS_deffile("XS::APItest::my_cxt_setsv", XS_XS__APItest_my_cxt_setsv);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_core", XS_XS__APItest_sv_setsv_cow_hashkey_core);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_notcore", XS_XS__APItest_sv_setsv_cow_hashkey_notcore);
        newXS_deffile("XS::APItest::sv_set_deref", XS_XS__APItest_sv_set_deref);
        newXS_deffile("XS::APItest::rmagical_cast", XS_XS__APItest_rmagical_cast);
        newXS_deffile("XS::APItest::rmagical_flags", XS_XS__APItest_rmagical_flags);
        newXS_deffile("XS::APItest::my_caller", XS_XS__APItest_my_caller);
        newXS_deffile("XS::APItest::DPeek", XS_XS__APItest_DPeek);
        newXS_deffile("XS::APItest::BEGIN", XS_XS__APItest_BEGIN);
        newXS_deffile("XS::APItest::CHECK", XS_XS__APItest_CHECK);
        newXS_deffile("XS::APItest::UNITCHECK", XS_XS__APItest_UNITCHECK);
        newXS_deffile("XS::APItest::INIT", XS_XS__APItest_INIT);
        newXS_deffile("XS::APItest::END", XS_XS__APItest_END);
        cv = newXS_deffile("XS::APItest::utf16_to_utf8", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::utf16_to_utf8_reversed", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::utf8_to_utf16", XS_XS__APItest_utf8_to_utf16);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::utf8_to_utf16_reversed", XS_XS__APItest_utf8_to_utf16);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::my_exit", XS_XS__APItest_my_exit);
        newXS_deffile("XS::APItest::first_byte", XS_XS__APItest_first_byte);
        newXS_deffile("XS::APItest::sv_count", XS_XS__APItest_sv_count);
        newXS_deffile("XS::APItest::bhk_record", XS_XS__APItest_bhk_record);
        newXS_deffile("XS::APItest::test_magic_chain", XS_XS__APItest_test_magic_chain);
        newXS_deffile("XS::APItest::test_op_contextualize", XS_XS__APItest_test_op_contextualize);
        (void)newXSproto_portable("XS::APItest::test_rv2cv_op_cv", XS_XS__APItest_test_rv2cv_op_cv, file, "");
        newXS_deffile("XS::APItest::test_cv_getset_call_checker", XS_XS__APItest_test_cv_getset_call_checker);
        newXS_deffile("XS::APItest::cv_set_call_checker_lists", XS_XS__APItest_cv_set_call_checker_lists);
        newXS_deffile("XS::APItest::cv_set_call_checker_scalars", XS_XS__APItest_cv_set_call_checker_scalars);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto", XS_XS__APItest_cv_set_call_checker_proto);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto_or_list", XS_XS__APItest_cv_set_call_checker_proto_or_list);
        newXS_deffile("XS::APItest::cv_set_call_checker_multi_sum", XS_XS__APItest_cv_set_call_checker_multi_sum);
        newXS_deffile("XS::APItest::test_cophh", XS_XS__APItest_test_cophh);
        newXS_deffile("XS::APItest::test_coplabel", XS_XS__APItest_test_coplabel);
        newXS_deffile("XS::APItest::example_cophh_2hv", XS_XS__APItest_example_cophh_2hv);
        newXS_deffile("XS::APItest::test_savehints", XS_XS__APItest_test_savehints);
        newXS_deffile("XS::APItest::test_copyhints", XS_XS__APItest_test_copyhints);
        newXS_deffile("XS::APItest::test_op_list", XS_XS__APItest_test_op_list);
        newXS_deffile("XS::APItest::test_op_linklist", XS_XS__APItest_test_op_linklist);
        newXS_deffile("XS::APItest::peep_enable", XS_XS__APItest_peep_enable);
        newXS_deffile("XS::APItest::peep_disable", XS_XS__APItest_peep_disable);
        newXS_deffile("XS::APItest::peep_record", XS_XS__APItest_peep_record);
        newXS_deffile("XS::APItest::rpeep_record", XS_XS__APItest_rpeep_record);
        (void)newXSproto_portable("XS::APItest::multicall_each", XS_XS__APItest_multicall_each, file, "&@");
        (void)newXSproto_portable("XS::APItest::multicall_return", XS_XS__APItest_multicall_return, file, "&$");
#if XSubPPtmpAAAA
        newXS_deffile("XS::APItest::clone_with_stack", XS_XS__APItest_clone_with_stack);
#endif
        newXS_deffile("XS::APItest::take_svref", XS_XS__APItest_take_svref);
        newXS_deffile("XS::APItest::take_avref", XS_XS__APItest_take_avref);
        newXS_deffile("XS::APItest::take_hvref", XS_XS__APItest_take_hvref);
        newXS_deffile("XS::APItest::take_cvref", XS_XS__APItest_take_cvref);
        (void)newXSproto_portable("XS::APItest::establish_cleanup", XS_XS__APItest_establish_cleanup, file, "$");
        (void)newXSproto_portable("XS::APItest::postinc", XS_XS__APItest_postinc, file, "$");
        newXS_deffile("XS::APItest::filter", XS_XS__APItest_filter);
        newXS_deffile("XS::APItest::lv_temp_object", XS_XS__APItest_lv_temp_object);
        newXS_deffile("XS::APItest::fill_hash_with_nulls", XS_XS__APItest_fill_hash_with_nulls);
        newXS_deffile("XS::APItest::newHVhv", XS_XS__APItest_newHVhv);
        newXS_deffile("XS::APItest::SvIsCOW", XS_XS__APItest_SvIsCOW);
        (void)newXSproto_portable("XS::APItest::pad_scalar", XS_XS__APItest_pad_scalar, file, "$$");
        newXS_deffile("XS::APItest::fetch_pad_names", XS_XS__APItest_fetch_pad_names);
        (void)newXSproto_portable("XS::APItest::underscore_length", XS_XS__APItest_underscore_length, file, "");
        newXS_deffile("XS::APItest::stringify", XS_XS__APItest_stringify);
        newXS_deffile("XS::APItest::HvENAME", XS_XS__APItest_HvENAME);
        newXS_deffile("XS::APItest::xs_cmp", XS_XS__APItest_xs_cmp);
        newXS_deffile("XS::APItest::xs_cmp_undef", XS_XS__APItest_xs_cmp_undef);
        newXS_deffile("XS::APItest::SvPVbyte", XS_XS__APItest_SvPVbyte);
        newXS_deffile("XS::APItest::SvPVbyte_nomg", XS_XS__APItest_SvPVbyte_nomg);
        newXS_deffile("XS::APItest::SvPVutf8", XS_XS__APItest_SvPVutf8);
        newXS_deffile("XS::APItest::SvPVutf8_nomg", XS_XS__APItest_SvPVutf8_nomg);
        newXS_deffile("XS::APItest::SvIsBOOL", XS_XS__APItest_SvIsBOOL);
        newXS_deffile("XS::APItest::setup_addissub", XS_XS__APItest_setup_addissub);
        newXS_deffile("XS::APItest::setup_rv2cv_addunderbar", XS_XS__APItest_setup_rv2cv_addunderbar);
#if XSubPPtmpAAAB
        newXS_deffile("XS::APItest::test_alloccopstash", XS_XS__APItest_test_alloccopstash);
#endif
        newXS_deffile("XS::APItest::test_newFOROP_without_slab", XS_XS__APItest_test_newFOROP_without_slab);
        newXS_deffile("XS::APItest::callregexec", XS_XS__APItest_callregexec);
        newXS_deffile("XS::APItest::lexical_import", XS_XS__APItest_lexical_import);
        newXS_deffile("XS::APItest::sv_mortalcopy", XS_XS__APItest_sv_mortalcopy);
        newXS_deffile("XS::APItest::newRV", XS_XS__APItest_newRV);
        newXS_deffile("XS::APItest::alias_av", XS_XS__APItest_alias_av);
        newXS_deffile("XS::APItest::cv_name", XS_XS__APItest_cv_name);
        newXS_deffile("XS::APItest::sv_catpvn", XS_XS__APItest_sv_catpvn);
        newXS_deffile("XS::APItest::test_newOP_CUSTOM", XS_XS__APItest_test_newOP_CUSTOM);
        newXS_deffile("XS::APItest::test_sv_catpvf", XS_XS__APItest_test_sv_catpvf);
        newXS_deffile("XS::APItest::load_module", XS_XS__APItest_load_module);
        newXS_deffile("XS::APItest::string_without_null", XS_XS__APItest_string_without_null);
        newXS_deffile("XS::APItest::get_cv", XS_XS__APItest_get_cv);
        newXS_deffile("XS::APItest::get_cv_flags", XS_XS__APItest_get_cv_flags);
        newXS_deffile("XS::APItest::unshift_and_set_defav", XS_XS__APItest_unshift_and_set_defav);
        newXS_deffile("XS::APItest::PerlIO_stderr", XS_XS__APItest_PerlIO_stderr);
        newXS_deffile("XS::APItest::PerlIO_stdout", XS_XS__APItest_PerlIO_stdout);
        newXS_deffile("XS::APItest::PerlIO_stdin", XS_XS__APItest_PerlIO_stdin);
        newXS_deffile("XS::APItest::PerlIO_exportFILE", XS_XS__APItest_PerlIO_exportFILE);
        newXS_deffile("XS::APItest::test_MAX_types", XS_XS__APItest_test_MAX_types);
        newXS_deffile("XS::APItest::sv_numeq", XS_XS__APItest_sv_numeq);
        newXS_deffile("XS::APItest::sv_numeq_flags", XS_XS__APItest_sv_numeq_flags);
        newXS_deffile("XS::APItest::sv_streq", XS_XS__APItest_sv_streq);
        newXS_deffile("XS::APItest::sv_streq_flags", XS_XS__APItest_sv_streq_flags);
        newXS_deffile("XS::APItest::AUTOLOADtest::AUTOLOAD", XS_XS__APItest__AUTOLOADtest_AUTOLOAD);
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_bar", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_foo", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_bar", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_foo", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_bar", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_foo", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 0;
        newXS_deffile("XS::APItest::Magic::sv_magic", XS_XS__APItest__Magic_sv_magic);
        newXS_deffile("XS::APItest::Magic::test_get_vtbl", XS_XS__APItest__Magic_test_get_vtbl);
        newXS_deffile("XS::APItest::Magic::sv_magic_myset", XS_XS__APItest__Magic_sv_magic_myset);
        newXS_deffile("XS::APItest::Magic::sv_magic_mycopy", XS_XS__APItest__Magic_sv_magic_mycopy);
        newXS_deffile("XS::APItest::Magic::sv_magic_mycopy_count", XS_XS__APItest__Magic_sv_magic_mycopy_count);
        newXS_deffile("XS::APItest::test_isBLANK_uni", XS_XS__APItest_test_isBLANK_uni);
        newXS_deffile("XS::APItest::test_isBLANK_uvchr", XS_XS__APItest_test_isBLANK_uvchr);
        newXS_deffile("XS::APItest::test_isBLANK_LC_uvchr", XS_XS__APItest_test_isBLANK_LC_uvchr);
        newXS_deffile("XS::APItest::test_isBLANK", XS_XS__APItest_test_isBLANK);
        newXS_deffile("XS::APItest::test_isBLANK_A", XS_XS__APItest_test_isBLANK_A);
        newXS_deffile("XS::APItest::test_isBLANK_L1", XS_XS__APItest_test_isBLANK_L1);
        newXS_deffile("XS::APItest::test_isBLANK_LC", XS_XS__APItest_test_isBLANK_LC);
        newXS_deffile("XS::APItest::test_isBLANK_utf8", XS_XS__APItest_test_isBLANK_utf8);
        newXS_deffile("XS::APItest::test_isBLANK_LC_utf8", XS_XS__APItest_test_isBLANK_LC_utf8);
        newXS_deffile("XS::APItest::test_isVERTWS_uni", XS_XS__APItest_test_isVERTWS_uni);
        newXS_deffile("XS::APItest::test_isVERTWS_uvchr", XS_XS__APItest_test_isVERTWS_uvchr);
        newXS_deffile("XS::APItest::test_isVERTWS_utf8", XS_XS__APItest_test_isVERTWS_utf8);
        newXS_deffile("XS::APItest::test_isUPPER_uni", XS_XS__APItest_test_isUPPER_uni);
        newXS_deffile("XS::APItest::test_isUPPER_uvchr", XS_XS__APItest_test_isUPPER_uvchr);
        newXS_deffile("XS::APItest::test_isUPPER_LC_uvchr", XS_XS__APItest_test_isUPPER_LC_uvchr);
        newXS_deffile("XS::APItest::test_isUPPER", XS_XS__APItest_test_isUPPER);
        newXS_deffile("XS::APItest::test_isUPPER_A", XS_XS__APItest_test_isUPPER_A);
        newXS_deffile("XS::APItest::test_isUPPER_L1", XS_XS__APItest_test_isUPPER_L1);
        newXS_deffile("XS::APItest::test_isUPPER_LC", XS_XS__APItest_test_isUPPER_LC);
        newXS_deffile("XS::APItest::test_isUPPER_utf8", XS_XS__APItest_test_isUPPER_utf8);
        newXS_deffile("XS::APItest::test_isUPPER_LC_utf8", XS_XS__APItest_test_isUPPER_LC_utf8);
        newXS_deffile("XS::APItest::test_isLOWER_uni", XS_XS__APItest_test_isLOWER_uni);
        newXS_deffile("XS::APItest::test_isLOWER_uvchr", XS_XS__APItest_test_isLOWER_uvchr);
        newXS_deffile("XS::APItest::test_isLOWER_LC_uvchr", XS_XS__APItest_test_isLOWER_LC_uvchr);
        newXS_deffile("XS::APItest::test_isLOWER", XS_XS__APItest_test_isLOWER);
        newXS_deffile("XS::APItest::test_isLOWER_A", XS_XS__APItest_test_isLOWER_A);
        newXS_deffile("XS::APItest::test_isLOWER_L1", XS_XS__APItest_test_isLOWER_L1);
        newXS_deffile("XS::APItest::test_isLOWER_LC", XS_XS__APItest_test_isLOWER_LC);
        newXS_deffile("XS::APItest::test_isLOWER_utf8", XS_XS__APItest_test_isLOWER_utf8);
        newXS_deffile("XS::APItest::test_isLOWER_LC_utf8", XS_XS__APItest_test_isLOWER_LC_utf8);
        newXS_deffile("XS::APItest::test_isALPHA_uni", XS_XS__APItest_test_isALPHA_uni);
        newXS_deffile("XS::APItest::test_isALPHA_uvchr", XS_XS__APItest_test_isALPHA_uvchr);
        newXS_deffile("XS::APItest::test_isALPHA_LC_uvchr", XS_XS__APItest_test_isALPHA_LC_uvchr);
        newXS_deffile("XS::APItest::test_isALPHA", XS_XS__APItest_test_isALPHA);
        newXS_deffile("XS::APItest::test_isALPHA_A", XS_XS__APItest_test_isALPHA_A);
        newXS_deffile("XS::APItest::test_isALPHA_L1", XS_XS__APItest_test_isALPHA_L1);
        newXS_deffile("XS::APItest::test_isALPHA_LC", XS_XS__APItest_test_isALPHA_LC);
        newXS_deffile("XS::APItest::test_isALPHA_utf8", XS_XS__APItest_test_isALPHA_utf8);
        newXS_deffile("XS::APItest::test_isALPHA_LC_utf8", XS_XS__APItest_test_isALPHA_LC_utf8);
        newXS_deffile("XS::APItest::test_isWORDCHAR_uni", XS_XS__APItest_test_isWORDCHAR_uni);
        newXS_deffile("XS::APItest::test_isWORDCHAR_uvchr", XS_XS__APItest_test_isWORDCHAR_uvchr);
        newXS_deffile("XS::APItest::test_isWORDCHAR_LC_uvchr", XS_XS__APItest_test_isWORDCHAR_LC_uvchr);
        newXS_deffile("XS::APItest::test_isWORDCHAR", XS_XS__APItest_test_isWORDCHAR);
        newXS_deffile("XS::APItest::test_isWORDCHAR_A", XS_XS__APItest_test_isWORDCHAR_A);
        newXS_deffile("XS::APItest::test_isWORDCHAR_L1", XS_XS__APItest_test_isWORDCHAR_L1);
        newXS_deffile("XS::APItest::test_isWORDCHAR_LC", XS_XS__APItest_test_isWORDCHAR_LC);
        newXS_deffile("XS::APItest::test_isWORDCHAR_utf8", XS_XS__APItest_test_isWORDCHAR_utf8);
        newXS_deffile("XS::APItest::test_isWORDCHAR_LC_utf8", XS_XS__APItest_test_isWORDCHAR_LC_utf8);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_uni", XS_XS__APItest_test_isALPHANUMERIC_uni);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_uvchr", XS_XS__APItest_test_isALPHANUMERIC_uvchr);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_LC_uvchr", XS_XS__APItest_test_isALPHANUMERIC_LC_uvchr);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC", XS_XS__APItest_test_isALPHANUMERIC);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_A", XS_XS__APItest_test_isALPHANUMERIC_A);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_L1", XS_XS__APItest_test_isALPHANUMERIC_L1);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_LC", XS_XS__APItest_test_isALPHANUMERIC_LC);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_utf8", XS_XS__APItest_test_isALPHANUMERIC_utf8);
        newXS_deffile("XS::APItest::test_isALPHANUMERIC_LC_utf8", XS_XS__APItest_test_isALPHANUMERIC_LC_utf8);
        newXS_deffile("XS::APItest::test_isALNUM", XS_XS__APItest_test_isALNUM);
        newXS_deffile("XS::APItest::test_isALNUM_uni", XS_XS__APItest_test_isALNUM_uni);
        newXS_deffile("XS::APItest::test_isALNUM_LC_uvchr", XS_XS__APItest_test_isALNUM_LC_uvchr);
        newXS_deffile("XS::APItest::test_isALNUM_LC", XS_XS__APItest_test_isALNUM_LC);
        newXS_deffile("XS::APItest::test_isALNUM_utf8", XS_XS__APItest_test_isALNUM_utf8);
        newXS_deffile("XS::APItest::test_isALNUM_LC_utf8", XS_XS__APItest_test_isALNUM_LC_utf8);
        newXS_deffile("XS::APItest::test_isDIGIT_uni", XS_XS__APItest_test_isDIGIT_uni);
        newXS_deffile("XS::APItest::test_isDIGIT_uvchr", XS_XS__APItest_test_isDIGIT_uvchr);
        newXS_deffile("XS::APItest::test_isDIGIT_LC_uvchr", XS_XS__APItest_test_isDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::test_isDIGIT_utf8", XS_XS__APItest_test_isDIGIT_utf8);
        newXS_deffile("XS::APItest::test_isDIGIT_LC_utf8", XS_XS__APItest_test_isDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::test_isDIGIT", XS_XS__APItest_test_isDIGIT);
        newXS_deffile("XS::APItest::test_isDIGIT_A", XS_XS__APItest_test_isDIGIT_A);
        newXS_deffile("XS::APItest::test_isDIGIT_L1", XS_XS__APItest_test_isDIGIT_L1);
        newXS_deffile("XS::APItest::test_isDIGIT_LC", XS_XS__APItest_test_isDIGIT_LC);
        newXS_deffile("XS::APItest::test_isOCTAL", XS_XS__APItest_test_isOCTAL);
        newXS_deffile("XS::APItest::test_isOCTAL_A", XS_XS__APItest_test_isOCTAL_A);
        newXS_deffile("XS::APItest::test_isOCTAL_L1", XS_XS__APItest_test_isOCTAL_L1);
        newXS_deffile("XS::APItest::test_isIDFIRST_uni", XS_XS__APItest_test_isIDFIRST_uni);
        newXS_deffile("XS::APItest::test_isIDFIRST_uvchr", XS_XS__APItest_test_isIDFIRST_uvchr);
        newXS_deffile("XS::APItest::test_isIDFIRST_LC_uvchr", XS_XS__APItest_test_isIDFIRST_LC_uvchr);
        newXS_deffile("XS::APItest::test_isIDFIRST", XS_XS__APItest_test_isIDFIRST);
        newXS_deffile("XS::APItest::test_isIDFIRST_A", XS_XS__APItest_test_isIDFIRST_A);
        newXS_deffile("XS::APItest::test_isIDFIRST_L1", XS_XS__APItest_test_isIDFIRST_L1);
        newXS_deffile("XS::APItest::test_isIDFIRST_LC", XS_XS__APItest_test_isIDFIRST_LC);
        newXS_deffile("XS::APItest::test_isIDFIRST_utf8", XS_XS__APItest_test_isIDFIRST_utf8);
        newXS_deffile("XS::APItest::test_isIDFIRST_LC_utf8", XS_XS__APItest_test_isIDFIRST_LC_utf8);
        newXS_deffile("XS::APItest::test_isIDCONT_uni", XS_XS__APItest_test_isIDCONT_uni);
        newXS_deffile("XS::APItest::test_isIDCONT_uvchr", XS_XS__APItest_test_isIDCONT_uvchr);
        newXS_deffile("XS::APItest::test_isIDCONT_LC_uvchr", XS_XS__APItest_test_isIDCONT_LC_uvchr);
        newXS_deffile("XS::APItest::test_isIDCONT", XS_XS__APItest_test_isIDCONT);
        newXS_deffile("XS::APItest::test_isIDCONT_A", XS_XS__APItest_test_isIDCONT_A);
        newXS_deffile("XS::APItest::test_isIDCONT_L1", XS_XS__APItest_test_isIDCONT_L1);
        newXS_deffile("XS::APItest::test_isIDCONT_LC", XS_XS__APItest_test_isIDCONT_LC);
        newXS_deffile("XS::APItest::test_isIDCONT_utf8", XS_XS__APItest_test_isIDCONT_utf8);
        newXS_deffile("XS::APItest::test_isIDCONT_LC_utf8", XS_XS__APItest_test_isIDCONT_LC_utf8);
        newXS_deffile("XS::APItest::test_isSPACE_uni", XS_XS__APItest_test_isSPACE_uni);
        newXS_deffile("XS::APItest::test_isSPACE_uvchr", XS_XS__APItest_test_isSPACE_uvchr);
        newXS_deffile("XS::APItest::test_isSPACE_LC_uvchr", XS_XS__APItest_test_isSPACE_LC_uvchr);
        newXS_deffile("XS::APItest::test_isSPACE", XS_XS__APItest_test_isSPACE);
        newXS_deffile("XS::APItest::test_isSPACE_A", XS_XS__APItest_test_isSPACE_A);
        newXS_deffile("XS::APItest::test_isSPACE_L1", XS_XS__APItest_test_isSPACE_L1);
        newXS_deffile("XS::APItest::test_isSPACE_LC", XS_XS__APItest_test_isSPACE_LC);
        newXS_deffile("XS::APItest::test_isSPACE_utf8", XS_XS__APItest_test_isSPACE_utf8);
        newXS_deffile("XS::APItest::test_isSPACE_LC_utf8", XS_XS__APItest_test_isSPACE_LC_utf8);
        newXS_deffile("XS::APItest::test_isASCII_uni", XS_XS__APItest_test_isASCII_uni);
        newXS_deffile("XS::APItest::test_isASCII_uvchr", XS_XS__APItest_test_isASCII_uvchr);
        newXS_deffile("XS::APItest::test_isASCII_LC_uvchr", XS_XS__APItest_test_isASCII_LC_uvchr);
        newXS_deffile("XS::APItest::test_isASCII", XS_XS__APItest_test_isASCII);
        newXS_deffile("XS::APItest::test_isASCII_A", XS_XS__APItest_test_isASCII_A);
        newXS_deffile("XS::APItest::test_isASCII_L1", XS_XS__APItest_test_isASCII_L1);
        newXS_deffile("XS::APItest::test_isASCII_LC", XS_XS__APItest_test_isASCII_LC);
        newXS_deffile("XS::APItest::test_isASCII_utf8", XS_XS__APItest_test_isASCII_utf8);
        newXS_deffile("XS::APItest::test_isASCII_LC_utf8", XS_XS__APItest_test_isASCII_LC_utf8);
        newXS_deffile("XS::APItest::test_isCNTRL_uni", XS_XS__APItest_test_isCNTRL_uni);
        newXS_deffile("XS::APItest::test_isCNTRL_uvchr", XS_XS__APItest_test_isCNTRL_uvchr);
        newXS_deffile("XS::APItest::test_isCNTRL_LC_uvchr", XS_XS__APItest_test_isCNTRL_LC_uvchr);
        newXS_deffile("XS::APItest::test_isCNTRL", XS_XS__APItest_test_isCNTRL);
        newXS_deffile("XS::APItest::test_isCNTRL_A", XS_XS__APItest_test_isCNTRL_A);
        newXS_deffile("XS::APItest::test_isCNTRL_L1", XS_XS__APItest_test_isCNTRL_L1);
        newXS_deffile("XS::APItest::test_isCNTRL_LC", XS_XS__APItest_test_isCNTRL_LC);
        newXS_deffile("XS::APItest::test_isCNTRL_utf8", XS_XS__APItest_test_isCNTRL_utf8);
        newXS_deffile("XS::APItest::test_isCNTRL_LC_utf8", XS_XS__APItest_test_isCNTRL_LC_utf8);
        newXS_deffile("XS::APItest::test_isPRINT_uni", XS_XS__APItest_test_isPRINT_uni);
        newXS_deffile("XS::APItest::test_isPRINT_uvchr", XS_XS__APItest_test_isPRINT_uvchr);
        newXS_deffile("XS::APItest::test_isPRINT_LC_uvchr", XS_XS__APItest_test_isPRINT_LC_uvchr);
        newXS_deffile("XS::APItest::test_isPRINT", XS_XS__APItest_test_isPRINT);
        newXS_deffile("XS::APItest::test_isPRINT_A", XS_XS__APItest_test_isPRINT_A);
        newXS_deffile("XS::APItest::test_isPRINT_L1", XS_XS__APItest_test_isPRINT_L1);
        newXS_deffile("XS::APItest::test_isPRINT_LC", XS_XS__APItest_test_isPRINT_LC);
        newXS_deffile("XS::APItest::test_isPRINT_utf8", XS_XS__APItest_test_isPRINT_utf8);
        newXS_deffile("XS::APItest::test_isPRINT_LC_utf8", XS_XS__APItest_test_isPRINT_LC_utf8);
        newXS_deffile("XS::APItest::test_isGRAPH_uni", XS_XS__APItest_test_isGRAPH_uni);
        newXS_deffile("XS::APItest::test_isGRAPH_uvchr", XS_XS__APItest_test_isGRAPH_uvchr);
        newXS_deffile("XS::APItest::test_isGRAPH_LC_uvchr", XS_XS__APItest_test_isGRAPH_LC_uvchr);
        newXS_deffile("XS::APItest::test_isGRAPH", XS_XS__APItest_test_isGRAPH);
        newXS_deffile("XS::APItest::test_isGRAPH_A", XS_XS__APItest_test_isGRAPH_A);
        newXS_deffile("XS::APItest::test_isGRAPH_L1", XS_XS__APItest_test_isGRAPH_L1);
        newXS_deffile("XS::APItest::test_isGRAPH_LC", XS_XS__APItest_test_isGRAPH_LC);
        newXS_deffile("XS::APItest::test_isGRAPH_utf8", XS_XS__APItest_test_isGRAPH_utf8);
        newXS_deffile("XS::APItest::test_isGRAPH_LC_utf8", XS_XS__APItest_test_isGRAPH_LC_utf8);
        newXS_deffile("XS::APItest::test_isPUNCT_uni", XS_XS__APItest_test_isPUNCT_uni);
        newXS_deffile("XS::APItest::test_isPUNCT_uvchr", XS_XS__APItest_test_isPUNCT_uvchr);
        newXS_deffile("XS::APItest::test_isPUNCT_LC_uvchr", XS_XS__APItest_test_isPUNCT_LC_uvchr);
        newXS_deffile("XS::APItest::test_isPUNCT", XS_XS__APItest_test_isPUNCT);
        newXS_deffile("XS::APItest::test_isPUNCT_A", XS_XS__APItest_test_isPUNCT_A);
        newXS_deffile("XS::APItest::test_isPUNCT_L1", XS_XS__APItest_test_isPUNCT_L1);
        newXS_deffile("XS::APItest::test_isPUNCT_LC", XS_XS__APItest_test_isPUNCT_LC);
        newXS_deffile("XS::APItest::test_isPUNCT_utf8", XS_XS__APItest_test_isPUNCT_utf8);
        newXS_deffile("XS::APItest::test_isPUNCT_LC_utf8", XS_XS__APItest_test_isPUNCT_LC_utf8);
        newXS_deffile("XS::APItest::test_isXDIGIT_uni", XS_XS__APItest_test_isXDIGIT_uni);
        newXS_deffile("XS::APItest::test_isXDIGIT_uvchr", XS_XS__APItest_test_isXDIGIT_uvchr);
        newXS_deffile("XS::APItest::test_isXDIGIT_LC_uvchr", XS_XS__APItest_test_isXDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::test_isXDIGIT", XS_XS__APItest_test_isXDIGIT);
        newXS_deffile("XS::APItest::test_isXDIGIT_A", XS_XS__APItest_test_isXDIGIT_A);
        newXS_deffile("XS::APItest::test_isXDIGIT_L1", XS_XS__APItest_test_isXDIGIT_L1);
        newXS_deffile("XS::APItest::test_isXDIGIT_LC", XS_XS__APItest_test_isXDIGIT_LC);
        newXS_deffile("XS::APItest::test_isXDIGIT_utf8", XS_XS__APItest_test_isXDIGIT_utf8);
        newXS_deffile("XS::APItest::test_isXDIGIT_LC_utf8", XS_XS__APItest_test_isXDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::test_isPSXSPC_uni", XS_XS__APItest_test_isPSXSPC_uni);
        newXS_deffile("XS::APItest::test_isPSXSPC_uvchr", XS_XS__APItest_test_isPSXSPC_uvchr);
        newXS_deffile("XS::APItest::test_isPSXSPC_LC_uvchr", XS_XS__APItest_test_isPSXSPC_LC_uvchr);
        newXS_deffile("XS::APItest::test_isPSXSPC", XS_XS__APItest_test_isPSXSPC);
        newXS_deffile("XS::APItest::test_isPSXSPC_A", XS_XS__APItest_test_isPSXSPC_A);
        newXS_deffile("XS::APItest::test_isPSXSPC_L1", XS_XS__APItest_test_isPSXSPC_L1);
        newXS_deffile("XS::APItest::test_isPSXSPC_LC", XS_XS__APItest_test_isPSXSPC_LC);
        newXS_deffile("XS::APItest::test_isPSXSPC_utf8", XS_XS__APItest_test_isPSXSPC_utf8);
        newXS_deffile("XS::APItest::test_isPSXSPC_LC_utf8", XS_XS__APItest_test_isPSXSPC_LC_utf8);
        newXS_deffile("XS::APItest::test_UTF8_IS_REPLACEMENT", XS_XS__APItest_test_UTF8_IS_REPLACEMENT);
        newXS_deffile("XS::APItest::test_isQUOTEMETA", XS_XS__APItest_test_isQUOTEMETA);
        newXS_deffile("XS::APItest::test_OFFUNISKIP", XS_XS__APItest_test_OFFUNISKIP);
        newXS_deffile("XS::APItest::test_OFFUNI_IS_INVARIANT", XS_XS__APItest_test_OFFUNI_IS_INVARIANT);
        newXS_deffile("XS::APItest::test_UVCHR_IS_INVARIANT", XS_XS__APItest_test_UVCHR_IS_INVARIANT);
        newXS_deffile("XS::APItest::test_UTF8_IS_INVARIANT", XS_XS__APItest_test_UTF8_IS_INVARIANT);
        newXS_deffile("XS::APItest::test_UVCHR_SKIP", XS_XS__APItest_test_UVCHR_SKIP);
        newXS_deffile("XS::APItest::test_UTF8_SKIP", XS_XS__APItest_test_UTF8_SKIP);
        newXS_deffile("XS::APItest::test_UTF8_IS_START", XS_XS__APItest_test_UTF8_IS_START);
        newXS_deffile("XS::APItest::test_UTF8_IS_CONTINUATION", XS_XS__APItest_test_UTF8_IS_CONTINUATION);
        newXS_deffile("XS::APItest::test_UTF8_IS_CONTINUED", XS_XS__APItest_test_UTF8_IS_CONTINUED);
        newXS_deffile("XS::APItest::test_UTF8_IS_DOWNGRADEABLE_START", XS_XS__APItest_test_UTF8_IS_DOWNGRADEABLE_START);
        newXS_deffile("XS::APItest::test_UTF8_IS_ABOVE_LATIN1", XS_XS__APItest_test_UTF8_IS_ABOVE_LATIN1);
        newXS_deffile("XS::APItest::test_isUTF8_POSSIBLY_PROBLEMATIC", XS_XS__APItest_test_isUTF8_POSSIBLY_PROBLEMATIC);
        newXS_deffile("XS::APItest::test_isUTF8_CHAR", XS_XS__APItest_test_isUTF8_CHAR);
        newXS_deffile("XS::APItest::test_isUTF8_CHAR_flags", XS_XS__APItest_test_isUTF8_CHAR_flags);
        newXS_deffile("XS::APItest::test_isSTRICT_UTF8_CHAR", XS_XS__APItest_test_isSTRICT_UTF8_CHAR);
        newXS_deffile("XS::APItest::test_isC9_STRICT_UTF8_CHAR", XS_XS__APItest_test_isC9_STRICT_UTF8_CHAR);
        newXS_deffile("XS::APItest::test_is_utf8_valid_partial_char_flags", XS_XS__APItest_test_is_utf8_valid_partial_char_flags);
        newXS_deffile("XS::APItest::test_is_utf8_string", XS_XS__APItest_test_is_utf8_string);
        newXS_deffile("XS::APItest::test_is_utf8_invariant_string_loc", XS_XS__APItest_test_is_utf8_invariant_string_loc);
        newXS_deffile("XS::APItest::test_variant_under_utf8_count", XS_XS__APItest_test_variant_under_utf8_count);
        newXS_deffile("XS::APItest::test_utf8_length", XS_XS__APItest_test_utf8_length);
        newXS_deffile("XS::APItest::test_is_utf8_string_loc", XS_XS__APItest_test_is_utf8_string_loc);
        newXS_deffile("XS::APItest::test_is_utf8_string_loclen", XS_XS__APItest_test_is_utf8_string_loclen);
        newXS_deffile("XS::APItest::test_is_utf8_string_flags", XS_XS__APItest_test_is_utf8_string_flags);
        newXS_deffile("XS::APItest::test_is_utf8_string_loc_flags", XS_XS__APItest_test_is_utf8_string_loc_flags);
        newXS_deffile("XS::APItest::test_is_utf8_string_loclen_flags", XS_XS__APItest_test_is_utf8_string_loclen_flags);
        newXS_deffile("XS::APItest::test_is_strict_utf8_string", XS_XS__APItest_test_is_strict_utf8_string);
        newXS_deffile("XS::APItest::test_is_strict_utf8_string_loc", XS_XS__APItest_test_is_strict_utf8_string_loc);
        newXS_deffile("XS::APItest::test_is_strict_utf8_string_loclen", XS_XS__APItest_test_is_strict_utf8_string_loclen);
        newXS_deffile("XS::APItest::test_is_c9strict_utf8_string", XS_XS__APItest_test_is_c9strict_utf8_string);
        newXS_deffile("XS::APItest::test_is_c9strict_utf8_string_loc", XS_XS__APItest_test_is_c9strict_utf8_string_loc);
        newXS_deffile("XS::APItest::test_is_c9strict_utf8_string_loclen", XS_XS__APItest_test_is_c9strict_utf8_string_loclen);
        newXS_deffile("XS::APItest::test_is_utf8_fixed_width_buf_flags", XS_XS__APItest_test_is_utf8_fixed_width_buf_flags);
        newXS_deffile("XS::APItest::test_is_utf8_fixed_width_buf_loc_flags", XS_XS__APItest_test_is_utf8_fixed_width_buf_loc_flags);
        newXS_deffile("XS::APItest::test_is_utf8_fixed_width_buf_loclen_flags", XS_XS__APItest_test_is_utf8_fixed_width_buf_loclen_flags);
        newXS_deffile("XS::APItest::test_utf8_hop_safe", XS_XS__APItest_test_utf8_hop_safe);
        newXS_deffile("XS::APItest::test_toLOWER", XS_XS__APItest_test_toLOWER);
        newXS_deffile("XS::APItest::test_toLOWER_L1", XS_XS__APItest_test_toLOWER_L1);
        newXS_deffile("XS::APItest::test_toLOWER_LC", XS_XS__APItest_test_toLOWER_LC);
        newXS_deffile("XS::APItest::test_toLOWER_uni", XS_XS__APItest_test_toLOWER_uni);
        newXS_deffile("XS::APItest::test_toLOWER_uvchr", XS_XS__APItest_test_toLOWER_uvchr);
        newXS_deffile("XS::APItest::test_toLOWER_utf8", XS_XS__APItest_test_toLOWER_utf8);
        newXS_deffile("XS::APItest::test_toFOLD", XS_XS__APItest_test_toFOLD);
        newXS_deffile("XS::APItest::test_toFOLD_LC", XS_XS__APItest_test_toFOLD_LC);
        newXS_deffile("XS::APItest::test_toFOLD_uni", XS_XS__APItest_test_toFOLD_uni);
        newXS_deffile("XS::APItest::test_toFOLD_uvchr", XS_XS__APItest_test_toFOLD_uvchr);
        newXS_deffile("XS::APItest::test_toFOLD_utf8", XS_XS__APItest_test_toFOLD_utf8);
        newXS_deffile("XS::APItest::test_toUPPER", XS_XS__APItest_test_toUPPER);
        newXS_deffile("XS::APItest::test_toUPPER_LC", XS_XS__APItest_test_toUPPER_LC);
        newXS_deffile("XS::APItest::test_toUPPER_uni", XS_XS__APItest_test_toUPPER_uni);
        newXS_deffile("XS::APItest::test_toUPPER_uvchr", XS_XS__APItest_test_toUPPER_uvchr);
        newXS_deffile("XS::APItest::test_toUPPER_utf8", XS_XS__APItest_test_toUPPER_utf8);
        newXS_deffile("XS::APItest::test_toTITLE", XS_XS__APItest_test_toTITLE);
        newXS_deffile("XS::APItest::test_toTITLE_uni", XS_XS__APItest_test_toTITLE_uni);
        newXS_deffile("XS::APItest::test_toTITLE_uvchr", XS_XS__APItest_test_toTITLE_uvchr);
        newXS_deffile("XS::APItest::test_toTITLE_utf8", XS_XS__APItest_test_toTITLE_utf8);
        newXS_deffile("XS::APItest::test_delimcpy", XS_XS__APItest_test_delimcpy);
        newXS_deffile("XS::APItest::test_delimcpy_no_escape", XS_XS__APItest_test_delimcpy_no_escape);
        newXS_deffile("XS::APItest::test_Gconvert", XS_XS__APItest_test_Gconvert);
        newXS_deffile("XS::APItest::test_Perl_langinfo", XS_XS__APItest_test_Perl_langinfo);
        (void)newXSproto_portable("XS::APItest::Backrefs::apitest_weaken", XS_XS__APItest__Backrefs_apitest_weaken, file, "$");
        newXS_deffile("XS::APItest::Backrefs::has_backrefs", XS_XS__APItest__Backrefs_has_backrefs);
#if XSubPPtmpAAAC
        newXS_deffile("XS::APItest::Backrefs::PerlDir_mapA", XS_XS__APItest__Backrefs_PerlDir_mapA);
        newXS_deffile("XS::APItest::Backrefs::PerlDir_mapW", XS_XS__APItest__Backrefs_PerlDir_mapW);
#endif
#if XSubPPtmpAAAD
        newXS_deffile("XS::APItest::Backrefs::Comctl32Version", XS_XS__APItest__Backrefs_Comctl32Version);
#endif
#if XSubPPtmpAAAE
        newXS_deffile("XS::APItest::RWMacro::compile_macros", XS_XS__APItest__RWMacro_compile_macros);
#endif
        cv = newXS_deffile("XS::APItest::HvMacro::u8_to_u16_le", XS_XS__APItest__HvMacro_u8_to_u16_le);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::HvMacro::u8_to_u32_le", XS_XS__APItest__HvMacro_u8_to_u16_le);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::HvMacro::u8_to_u64_le", XS_XS__APItest__HvMacro_u8_to_u16_le);
        XSANY.any_i32 = 2;
        newXS_deffile("XS::APItest::HvMacro::rotl32", XS_XS__APItest__HvMacro_rotl32);
        newXS_deffile("XS::APItest::HvMacro::rotr32", XS_XS__APItest__HvMacro_rotr32);
#if XSubPPtmpAAAF
        newXS_deffile("XS::APItest::HvMacro::rotl64", XS_XS__APItest__HvMacro_rotl64);
        newXS_deffile("XS::APItest::HvMacro::rotr64", XS_XS__APItest__HvMacro_rotr64);
        newXS_deffile("XS::APItest::HvMacro::siphash_seed_state", XS_XS__APItest__HvMacro_siphash_seed_state);
        cv = newXS_deffile("XS::APItest::HvMacro::siphash13", XS_XS__APItest__HvMacro_siphash24);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::HvMacro::siphash24", XS_XS__APItest__HvMacro_siphash24);
        XSANY.any_i32 = 0;
        newXS_deffile("XS::APItest::HvMacro::test_siphash24", XS_XS__APItest__HvMacro_test_siphash24);
        newXS_deffile("XS::APItest::HvMacro::test_siphash13", XS_XS__APItest__HvMacro_test_siphash13);
#endif

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#if defined(dTHX) && !defined(PERL_NO_GET_CONTEXT)
    dTHX;
#endif
    HV *symbol_table = get_hv("XS::APItest::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef HV_DELETE
        { "HV_DELETE", 9, HV_DELETE },
#endif
#ifdef HV_DISABLE_UVAR_XKEY
        { "HV_DISABLE_UVAR_XKEY", 20, HV_DISABLE_UVAR_XKEY },
#endif
#ifdef HV_FETCH_ISSTORE
        { "HV_FETCH_ISSTORE", 16, HV_FETCH_ISSTORE },
#endif
#ifdef HV_FETCH_ISEXISTS
        { "HV_FETCH_ISEXISTS", 17, HV_FETCH_ISEXISTS },
#endif
#ifdef HV_FETCH_LVALUE
        { "HV_FETCH_LVALUE", 15, HV_FETCH_LVALUE },
#endif
#ifdef HV_FETCH_JUST_SV
        { "HV_FETCH_JUST_SV", 16, HV_FETCH_JUST_SV },
#endif
#ifdef G_SCALAR
        { "G_SCALAR", 8, G_SCALAR },
#endif
#ifdef G_LIST
        { "G_LIST", 6, G_LIST },
#endif
#ifdef G_VOID
        { "G_VOID", 6, G_VOID },
#endif
#ifdef G_DISCARD
        { "G_DISCARD", 9, G_DISCARD },
#endif
#ifdef G_EVAL
        { "G_EVAL", 6, G_EVAL },
#endif
#ifdef G_NOARGS
        { "G_NOARGS", 8, G_NOARGS },
#endif
#ifdef G_KEEPERR
        { "G_KEEPERR", 9, G_KEEPERR },
#endif
#ifdef G_NODEBUG
        { "G_NODEBUG", 9, G_NODEBUG },
#endif
#ifdef G_METHOD
        { "G_METHOD", 8, G_METHOD },
#endif
#ifdef G_FAKINGEVAL
        { "G_FAKINGEVAL", 12, G_FAKINGEVAL },
#endif
#ifdef G_RETHROW
        { "G_RETHROW", 9, G_RETHROW },
#endif
#ifdef GV_NOADD_NOINIT
        { "GV_NOADD_NOINIT", 15, GV_NOADD_NOINIT },
#endif
#ifdef SV_GMAGIC
        { "SV_GMAGIC", 9, SV_GMAGIC },
#endif
#ifdef SV_SKIP_OVERLOAD
        { "SV_SKIP_OVERLOAD", 16, SV_SKIP_OVERLOAD },
#endif
#ifdef IS_NUMBER_IN_UV
        { "IS_NUMBER_IN_UV", 15, IS_NUMBER_IN_UV },
#endif
#ifdef IS_NUMBER_GREATER_THAN_UV_MAX
        { "IS_NUMBER_GREATER_THAN_UV_MAX", 29, IS_NUMBER_GREATER_THAN_UV_MAX },
#endif
#ifdef IS_NUMBER_NOT_INT
        { "IS_NUMBER_NOT_INT", 17, IS_NUMBER_NOT_INT },
#endif
#ifdef IS_NUMBER_NEG
        { "IS_NUMBER_NEG", 13, IS_NUMBER_NEG },
#endif
#ifdef IS_NUMBER_INFINITY
        { "IS_NUMBER_INFINITY", 18, IS_NUMBER_INFINITY },
#endif
#ifdef IS_NUMBER_NAN
        { "IS_NUMBER_NAN", 13, IS_NUMBER_NAN },
#endif
#ifdef IS_NUMBER_TRAILING
        { "IS_NUMBER_TRAILING", 18, IS_NUMBER_TRAILING },
#endif
#ifdef PERL_SCAN_TRAILING
        { "PERL_SCAN_TRAILING", 18, PERL_SCAN_TRAILING },
#endif
#ifdef PERL_LOADMOD_DENY
        { "PERL_LOADMOD_DENY", 17, PERL_LOADMOD_DENY },
#endif
#ifdef PERL_LOADMOD_NOIMPORT
        { "PERL_LOADMOD_NOIMPORT", 21, PERL_LOADMOD_NOIMPORT },
#endif
#ifdef PERL_LOADMOD_IMPORT_OPS
        { "PERL_LOADMOD_IMPORT_OPS", 23, PERL_LOADMOD_IMPORT_OPS },
#endif
#ifdef G_WANT
        { "G_WANT", 6, G_WANT },
#endif
        { "fallback_amg", 12, fallback_amg },
        { "to_sv_amg", 9, to_sv_amg },
        { "to_av_amg", 9, to_av_amg },
        { "to_hv_amg", 9, to_hv_amg },
        { "to_gv_amg", 9, to_gv_amg },
        { "to_cv_amg", 9, to_cv_amg },
        { "inc_amg", 7, inc_amg },
        { "dec_amg", 7, dec_amg },
        { "bool__amg", 9, bool__amg },
        { "numer_amg", 9, numer_amg },
        { "string_amg", 10, string_amg },
        { "not_amg", 7, not_amg },
        { "copy_amg", 8, copy_amg },
        { "abs_amg", 7, abs_amg },
        { "neg_amg", 7, neg_amg },
        { "iter_amg", 8, iter_amg },
        { "int_amg", 7, int_amg },
        { "lt_amg", 6, lt_amg },
        { "le_amg", 6, le_amg },
        { "gt_amg", 6, gt_amg },
        { "ge_amg", 6, ge_amg },
        { "eq_amg", 6, eq_amg },
        { "ne_amg", 6, ne_amg },
        { "slt_amg", 7, slt_amg },
        { "sle_amg", 7, sle_amg },
        { "sgt_amg", 7, sgt_amg },
        { "sge_amg", 7, sge_amg },
        { "seq_amg", 7, seq_amg },
        { "sne_amg", 7, sne_amg },
        { "nomethod_amg", 12, nomethod_amg },
        { "add_amg", 7, add_amg },
        { "add_ass_amg", 11, add_ass_amg },
        { "subtr_amg", 9, subtr_amg },
        { "subtr_ass_amg", 13, subtr_ass_amg },
        { "mult_amg", 8, mult_amg },
        { "mult_ass_amg", 12, mult_ass_amg },
        { "div_amg", 7, div_amg },
        { "div_ass_amg", 11, div_ass_amg },
        { "modulo_amg", 10, modulo_amg },
        { "modulo_ass_amg", 14, modulo_ass_amg },
        { "pow_amg", 7, pow_amg },
        { "pow_ass_amg", 11, pow_ass_amg },
        { "lshift_amg", 10, lshift_amg },
        { "lshift_ass_amg", 14, lshift_ass_amg },
        { "rshift_amg", 10, rshift_amg },
        { "rshift_ass_amg", 14, rshift_ass_amg },
        { "band_amg", 8, band_amg },
        { "band_ass_amg", 12, band_ass_amg },
        { "sband_amg", 9, sband_amg },
        { "sband_ass_amg", 13, sband_ass_amg },
        { "bor_amg", 7, bor_amg },
        { "bor_ass_amg", 11, bor_ass_amg },
        { "sbor_amg", 8, sbor_amg },
        { "sbor_ass_amg", 12, sbor_ass_amg },
        { "bxor_amg", 8, bxor_amg },
        { "bxor_ass_amg", 12, bxor_ass_amg },
        { "sbxor_amg", 9, sbxor_amg },
        { "sbxor_ass_amg", 13, sbxor_ass_amg },
        { "ncmp_amg", 8, ncmp_amg },
        { "scmp_amg", 8, scmp_amg },
        { "compl_amg", 9, compl_amg },
        { "scompl_amg", 10, scompl_amg },
        { "atan2_amg", 9, atan2_amg },
        { "cos_amg", 7, cos_amg },
        { "sin_amg", 7, sin_amg },
        { "exp_amg", 7, exp_amg },
        { "log_amg", 7, log_amg },
        { "sqrt_amg", 8, sqrt_amg },
        { "repeat_amg", 10, repeat_amg },
        { "repeat_ass_amg", 14, repeat_ass_amg },
        { "concat_amg", 10, concat_amg },
        { "concat_ass_amg", 14, concat_ass_amg },
        { "smart_amg", 9, smart_amg },
        { "ftest_amg", 9, ftest_amg },
        { "regexp_amg", 10, regexp_amg },
#ifndef G_WANT
        /* This is the default value: */
        { "G_WANT", 6, G_LIST|G_VOID },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    croak("Couldn't add key '%s' to %%XS::APItest::",
			  value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    croak("Couldn't add key '%s' to missing_hash",
			  value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 1704 "APItest.xs"
    newXS("XS::APItest::XSUB::XS_VERSION_undef", XS_XS__APItest__XSUB_XS_VERSION_undef, __FILE__);
    newXS("XS::APItest::XSUB::XS_VERSION_empty", XS_XS__APItest__XSUB_XS_VERSION_empty, __FILE__);
    newXS("XS::APItest::XSUB::XS_APIVERSION_invalid", XS_XS__APItest__XSUB_XS_APIVERSION_invalid, __FILE__);

#line 2168 "APItest.xs"
    mymro.resolve = myget_linear_isa;
    mymro.name    = "justisa";
    mymro.length  = 7;
    mymro.kflags  = 0;
    mymro.hash    = 0;
    Perl_mro_register(aTHX_ &mymro);

#line 2290 "APItest.xs"
{
    MY_CXT_INIT;

    MY_CXT.i  = 99;
    MY_CXT.sv = newSVpv("initial",0);

    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;

    BhkENTRY_set(&bhk_test, bhk_start, blockhook_test_start);
    BhkENTRY_set(&bhk_test, bhk_pre_end, blockhook_test_pre_end);
    BhkENTRY_set(&bhk_test, bhk_post_end, blockhook_test_post_end);
    BhkENTRY_set(&bhk_test, bhk_eval, blockhook_test_eval);
    Perl_blockhook_register(aTHX_ &bhk_test);

    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = GvAV(MY_CXT.cscgv);

    BhkENTRY_set(&bhk_csc, bhk_start, blockhook_csc_start);
    BhkENTRY_set(&bhk_csc, bhk_pre_end, blockhook_csc_pre_end);
    Perl_blockhook_register(aTHX_ &bhk_csc);

    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();

    MY_CXT.orig_peep = PL_peepp;
    MY_CXT.orig_rpeep = PL_rpeepp;
    PL_peepp = my_peep;
    PL_rpeepp = my_rpeep;
}

#if XSubPPtmpAAAA
#endif
#line 4092 "APItest.xs"
        {
        HV* stash;
        SV** meth = NULL;
        CV* cv;
        stash = gv_stashpv("XS::APItest::TempLv", 0);
        if (stash)
            meth = hv_fetchs(stash, "make_temp_mg_lv", 0);
        if (!meth)
            croak("lost method 'make_temp_mg_lv'");
        cv = GvCV(*meth);
        CvLVALUE_on(cv);
        }

#line 4106 "APItest.xs"
{
    hintkey_rpn_sv = newSVpvs_share("XS::APItest/rpn");
    hintkey_calcrpn_sv = newSVpvs_share("XS::APItest/calcrpn");
    hintkey_stufftest_sv = newSVpvs_share("XS::APItest/stufftest");
    hintkey_swaptwostmts_sv = newSVpvs_share("XS::APItest/swaptwostmts");
    hintkey_looprest_sv = newSVpvs_share("XS::APItest/looprest");
    hintkey_scopelessblock_sv = newSVpvs_share("XS::APItest/scopelessblock");
    hintkey_stmtasexpr_sv = newSVpvs_share("XS::APItest/stmtasexpr");
    hintkey_stmtsasexpr_sv = newSVpvs_share("XS::APItest/stmtsasexpr");
    hintkey_loopblock_sv = newSVpvs_share("XS::APItest/loopblock");
    hintkey_blockasexpr_sv = newSVpvs_share("XS::APItest/blockasexpr");
    hintkey_swaplabel_sv = newSVpvs_share("XS::APItest/swaplabel");
    hintkey_labelconst_sv = newSVpvs_share("XS::APItest/labelconst");
    hintkey_arrayfullexpr_sv = newSVpvs_share("XS::APItest/arrayfullexpr");
    hintkey_arraylistexpr_sv = newSVpvs_share("XS::APItest/arraylistexpr");
    hintkey_arraytermexpr_sv = newSVpvs_share("XS::APItest/arraytermexpr");
    hintkey_arrayarithexpr_sv = newSVpvs_share("XS::APItest/arrayarithexpr");
    hintkey_arrayexprflags_sv = newSVpvs_share("XS::APItest/arrayexprflags");
    hintkey_subsignature_sv = newSVpvs_share("XS::APItest/subsignature");
    hintkey_DEFSV_sv = newSVpvs_share("XS::APItest/DEFSV");
    hintkey_with_vars_sv = newSVpvs_share("XS::APItest/with_vars");
    hintkey_join_with_space_sv = newSVpvs_share("XS::APItest/join_with_space");
    wrap_keyword_plugin(my_keyword_plugin, &next_keyword_plugin);
}

#line 4139 "APItest.xs"
{
    CV *estcv = get_cv("XS::APItest::establish_cleanup", 0);
    cv_set_call_checker(estcv, THX_ck_entersub_establish_cleanup, (SV*)estcv);
}

#line 4157 "APItest.xs"
{
    CV *asscv = get_cv("XS::APItest::postinc", 0);
    cv_set_call_checker(asscv, THX_ck_entersub_postinc, (SV*)asscv);
}

#line 4206 "APItest.xs"
{
    CV *pscv = get_cv("XS::APItest::pad_scalar", 0);
    cv_set_call_checker(pscv, THX_ck_entersub_pad_scalar, (SV*)pscv);
}

#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#line 15243 "APItest.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

