/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSKeyframesRule.h"

#include "CSSKeyframeRule.h"
#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSKeyframeRule.h"
#include "JSCSSRuleList.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionInsertRule(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionAppendRule(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionDeleteRule(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionFindRule(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCSSKeyframesRuleName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSKeyframesRuleName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSKeyframesRuleCssRules(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSKeyframesRulePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSKeyframesRulePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSKeyframesRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSKeyframesRulePrototype>(vm.heap)) JSCSSKeyframesRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSKeyframesRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSKeyframesRule> JSCSSKeyframesRuleConstructor;

template<> JSValue JSCSSKeyframesRuleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSKeyframesRuleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSKeyframesRule::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSKeyframesRule"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCSSKeyframesRuleConstructor::s_info = { "CSSKeyframesRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframesRuleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSKeyframesRulePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframesRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSKeyframesRuleConstructor) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframesRuleName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSKeyframesRuleName) } },
    { "cssRules", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSKeyframesRuleCssRules), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSKeyframesRulePrototypeFunctionInsertRule), (intptr_t) (0) } },
    { "appendRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSKeyframesRulePrototypeFunctionAppendRule), (intptr_t) (0) } },
    { "deleteRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSKeyframesRulePrototypeFunctionDeleteRule), (intptr_t) (0) } },
    { "findRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSKeyframesRulePrototypeFunctionFindRule), (intptr_t) (0) } },
};

const ClassInfo JSCSSKeyframesRulePrototype::s_info = { "CSSKeyframesRulePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframesRulePrototype) };

void JSCSSKeyframesRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSKeyframesRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSKeyframesRule::s_info = { "CSSKeyframesRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSKeyframesRule) };

JSCSSKeyframesRule::JSCSSKeyframesRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSKeyframesRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSKeyframesRule::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSKeyframesRulePrototype::create(vm, globalObject, JSCSSKeyframesRulePrototype::createStructure(vm, globalObject, JSCSSRule::getPrototype(vm, globalObject)));
}

JSObject* JSCSSKeyframesRule::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSKeyframesRule>(vm, globalObject);
}

bool JSCSSKeyframesRule::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSKeyframesRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSCSSKeyframesRule::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSKeyframesRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsCSSKeyframesRuleName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSKeyframesRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSKeyframesRule", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSKeyframesRuleCssRules(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSKeyframesRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSKeyframesRule", "cssRules");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.cssRules()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSKeyframesRuleConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSKeyframesRulePrototype* domObject = jsDynamicCast<JSCSSKeyframesRulePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSKeyframesRule::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSKeyframesRuleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSKeyframesRulePrototype* domObject = jsDynamicCast<JSCSSKeyframesRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCSSKeyframesRuleName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSKeyframesRule* castedThis = jsDynamicCast<JSCSSKeyframesRule*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSKeyframesRule", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setName(nativeValue);
}


void JSCSSKeyframesRule::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSCSSKeyframesRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSCSSKeyframesRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSKeyframesRuleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionInsertRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSKeyframesRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSKeyframesRule", "insertRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSKeyframesRule::info());
    auto& impl = castedThis->wrapped();
    String rule = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.insertRule(rule);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionAppendRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSKeyframesRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSKeyframesRule", "appendRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSKeyframesRule::info());
    auto& impl = castedThis->wrapped();
    String rule = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.appendRule(rule);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionDeleteRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSKeyframesRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSKeyframesRule", "deleteRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSKeyframesRule::info());
    auto& impl = castedThis->wrapped();
    String key = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.deleteRule(key);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSKeyframesRulePrototypeFunctionFindRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSKeyframesRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSKeyframesRule", "findRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSKeyframesRule::info());
    auto& impl = castedThis->wrapped();
    String key = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.findRule(key)));
    return JSValue::encode(result);
}


}
