/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasGradient.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCanvasGradientPrototypeFunctionAddColorStop(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCanvasGradientConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasGradientConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCanvasGradientPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCanvasGradientPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasGradientPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasGradientPrototype>(vm.heap)) JSCanvasGradientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasGradientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCanvasGradient> JSCanvasGradientConstructor;

template<> JSValue JSCanvasGradientConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasGradientConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCanvasGradient::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CanvasGradient"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCanvasGradientConstructor::s_info = { "CanvasGradient", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasGradientConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCanvasGradientPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasGradientConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasGradientConstructor) } },
    { "addColorStop", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasGradientPrototypeFunctionAddColorStop), (intptr_t) (0) } },
};

const ClassInfo JSCanvasGradientPrototype::s_info = { "CanvasGradientPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasGradientPrototype) };

void JSCanvasGradientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasGradientPrototypeTableValues, *this);
}

const ClassInfo JSCanvasGradient::s_info = { "CanvasGradient", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasGradient) };

JSCanvasGradient::JSCanvasGradient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasGradient>&& impl)
    : JSDOMWrapper<CanvasGradient>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCanvasGradient::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCanvasGradientPrototype::create(vm, globalObject, JSCanvasGradientPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCanvasGradient::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasGradient>(vm, globalObject);
}

void JSCanvasGradient::destroy(JSC::JSCell* cell)
{
    JSCanvasGradient* thisObject = static_cast<JSCanvasGradient*>(cell);
    thisObject->JSCanvasGradient::~JSCanvasGradient();
}

EncodedJSValue jsCanvasGradientConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCanvasGradientPrototype* domObject = jsDynamicCast<JSCanvasGradientPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCanvasGradient::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCanvasGradientConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCanvasGradientPrototype* domObject = jsDynamicCast<JSCanvasGradientPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCanvasGradient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasGradientConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCanvasGradientPrototypeFunctionAddColorStop(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasGradient*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasGradient", "addColorStop");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasGradient::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    float offset = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(offset)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    String color = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.addColorStop(offset, color, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

bool JSCanvasGradientOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSCanvasGradientOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasGradient = jsCast<JSCanvasGradient*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasGradient->wrapped(), jsCanvasGradient);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CanvasGradient* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCanvasGradient>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CanvasGradient* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCanvasGradient>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to CanvasGradient.
    COMPILE_ASSERT(!__is_polymorphic(CanvasGradient), CanvasGradient_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSCanvasGradient>(globalObject, impl);
}

CanvasGradient* JSCanvasGradient::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasGradient*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
