/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRectList.h"

#include "ClientRect.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsClientRectListPrototypeFunctionItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsClientRectListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSClientRectListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSClientRectListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSClientRectListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClientRectListPrototype* ptr = new (NotNull, JSC::allocateCell<JSClientRectListPrototype>(vm.heap)) JSClientRectListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClientRectListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSClientRectList> JSClientRectListConstructor;

/* Hash table */

static const struct CompactHashIndex JSClientRectListTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSClientRectListTableValues[] =
{
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSClientRectListTable = { 1, 1, true, JSClientRectListTableValues, JSClientRectListTableIndex };
template<> JSValue JSClientRectListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSClientRectListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSClientRectList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ClientRectList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSClientRectListConstructor::s_info = { "ClientRectList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSClientRectListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSClientRectListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSClientRectListConstructor) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsClientRectListPrototypeFunctionItem), (intptr_t) (0) } },
};

const ClassInfo JSClientRectListPrototype::s_info = { "ClientRectListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSClientRectListPrototype) };

void JSClientRectListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClientRectListPrototypeTableValues, *this);
}

const ClassInfo JSClientRectList::s_info = { "ClientRectList", &Base::s_info, &JSClientRectListTable, CREATE_METHOD_TABLE(JSClientRectList) };

JSClientRectList::JSClientRectList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ClientRectList>&& impl)
    : JSDOMWrapper<ClientRectList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSClientRectList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSClientRectListPrototype::create(vm, globalObject, JSClientRectListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSClientRectList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRectList>(vm, globalObject);
}

void JSClientRectList::destroy(JSC::JSCell* cell)
{
    JSClientRectList* thisObject = static_cast<JSClientRectList*>(cell);
    thisObject->JSClientRectList::~JSClientRectList();
}

bool JSClientRectList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSClientRectList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (getStaticValueSlot<JSClientRectList, Base>(state, JSClientRectListTable, thisObject, propertyName, slot))
        return true;
    return false;
}

bool JSClientRectList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSClientRectList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsClientRectListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRectList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRectList*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRectList", "length");
        reportDeprecatedGetterError(*state, "ClientRectList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSClientRectListPrototype* domObject = jsDynamicCast<JSClientRectListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSClientRectList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSClientRectListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSClientRectListPrototype* domObject = jsDynamicCast<JSClientRectListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSClientRectList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSClientRectList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSClientRectList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsClientRectListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSClientRectList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "ClientRectList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSClientRectList::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

bool JSClientRectListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSClientRectListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClientRectList = jsCast<JSClientRectList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsClientRectList->wrapped(), jsClientRectList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ClientRectList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSClientRectList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ClientRectList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSClientRectList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ClientRectList.
    COMPILE_ASSERT(!__is_polymorphic(ClientRectList), ClientRectList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSClientRectList>(globalObject, impl);
}

ClientRectList* JSClientRectList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClientRectList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
