/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FETCH_API)

#include "JSFetchHeaders.h"

#include "ExceptionCode.h"
#include "FetchHeadersBuiltins.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSFetchHeaders.h"
#include "URL.h"
#include "WebCoreJSClientData.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionAppend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionDelete(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionGet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionHas(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionSet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionEntries(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionKeys(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionValues(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionAppendFromJS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionInitializeWith(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsFetchHeadersConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFetchHeadersConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFetchHeadersPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFetchHeadersPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchHeadersPrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchHeadersPrototype>(vm.heap)) JSFetchHeadersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchHeadersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSBuiltinConstructor<JSFetchHeaders> JSFetchHeadersConstructor;

template<> JSC::JSObject* JSFetchHeadersConstructor::createJSObject()
{
    return JSFetchHeaders::create(getDOMStructure<JSFetchHeaders>(globalObject()->vm(), *globalObject()), globalObject(), FetchHeaders::create());
}

template<> JSValue JSFetchHeadersConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchHeadersConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFetchHeaders::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Headers"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> FunctionExecutable* JSFetchHeadersConstructor::initializeExecutable(VM& vm)
{
    return fetchHeadersInitializeFetchHeadersCodeGenerator(vm);
}

template<> const ClassInfo JSFetchHeadersConstructor::s_info = { "Headers", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchHeadersConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFetchHeadersPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchHeadersConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFetchHeadersConstructor) } },
    { "append", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionAppend), (intptr_t) (2) } },
    { "delete", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionDelete), (intptr_t) (1) } },
    { "get", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionGet), (intptr_t) (1) } },
    { "has", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionHas), (intptr_t) (1) } },
    { "set", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionSet), (intptr_t) (2) } },
    { "entries", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionEntries), (intptr_t) (0) } },
    { "keys", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionKeys), (intptr_t) (0) } },
    { "values", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFetchHeadersPrototypeFunctionValues), (intptr_t) (0) } },
};

const ClassInfo JSFetchHeadersPrototype::s_info = { "HeadersPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchHeadersPrototype) };

void JSFetchHeadersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchHeadersPrototypeTableValues, *this);
    JSVMClientData& clientData = *static_cast<JSVMClientData*>(vm.clientData);
    putDirect(vm, clientData.builtinNames().appendFromJSPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsFetchHeadersPrototypeFunctionAppendFromJS), ReadOnly | DontEnum);
    putDirect(vm, clientData.builtinNames().initializeWithPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsFetchHeadersPrototypeFunctionInitializeWith), ReadOnly | DontEnum);
}

const ClassInfo JSFetchHeaders::s_info = { "Headers", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFetchHeaders) };

JSFetchHeaders::JSFetchHeaders(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchHeaders>&& impl)
    : JSDOMWrapper<FetchHeaders>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFetchHeaders::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFetchHeadersPrototype::create(vm, globalObject, JSFetchHeadersPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSFetchHeaders::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFetchHeaders>(vm, globalObject);
}

void JSFetchHeaders::destroy(JSC::JSCell* cell)
{
    JSFetchHeaders* thisObject = static_cast<JSFetchHeaders*>(cell);
    thisObject->JSFetchHeaders::~JSFetchHeaders();
}

EncodedJSValue jsFetchHeadersConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFetchHeadersPrototype* domObject = jsDynamicCast<JSFetchHeadersPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFetchHeaders::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFetchHeadersConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFetchHeadersPrototype* domObject = jsDynamicCast<JSFetchHeadersPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSFetchHeaders::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchHeadersConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionAppend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "append");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.append(name, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionDelete(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "delete");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.remove(name, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionGet(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "get");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.get(name, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionHas(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "has");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.has(name, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionSet(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "set");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.set(name, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionEntries(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "entries");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    return JSValue::encode(castedThis->entries(*state));
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionKeys(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "keys");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    return JSValue::encode(castedThis->keys(*state));
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionValues(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "values");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    return JSValue::encode(castedThis->values(*state));
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionAppendFromJS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "appendFromJS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.append(name, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchHeadersPrototypeFunctionInitializeWith(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFetchHeaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FetchHeaders", "initializeWith");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFetchHeaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    FetchHeaders* headers = JSFetchHeaders::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initializeWith(headers, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSFetchHeaders::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSFetchHeaders*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
}

bool JSFetchHeadersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSFetchHeadersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchHeaders = jsCast<JSFetchHeaders*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFetchHeaders->wrapped(), jsFetchHeaders);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, FetchHeaders* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFetchHeaders>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, FetchHeaders* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFetchHeaders>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to FetchHeaders.
    COMPILE_ASSERT(!__is_polymorphic(FetchHeaders), FetchHeaders_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSFetchHeaders>(globalObject, impl);
}

FetchHeaders* JSFetchHeaders::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchHeaders*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(FETCH_API)
