/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBKeyRange.h"

#include "ExceptionCode.h"
#include "IDBKeyRange.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSIDBKeyRange.h"
#include <bindings/ScriptValue.h>
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionOnly(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionLowerBound(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionUpperBound(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionBound(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsIDBKeyRangeLower(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeUpper(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeLowerOpen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeUpperOpen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBKeyRangePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSIDBKeyRangePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBKeyRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBKeyRangePrototype>(vm.heap)) JSIDBKeyRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBKeyRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSIDBKeyRange> JSIDBKeyRangeConstructor;

/* Hash table for constructor */

static const HashTableValue JSIDBKeyRangeConstructorTableValues[] =
{
    { "only", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionOnly), (intptr_t) (1) } },
    { "lowerBound", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionLowerBound), (intptr_t) (1) } },
    { "upperBound", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionUpperBound), (intptr_t) (1) } },
    { "bound", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBKeyRangeConstructorFunctionBound), (intptr_t) (2) } },
};

template<> JSValue JSIDBKeyRangeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBKeyRangeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBKeyRange::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("IDBKeyRange"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSIDBKeyRangeConstructorTableValues, *this);
}

template<> const ClassInfo JSIDBKeyRangeConstructor::s_info = { "IDBKeyRange", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBKeyRangeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBKeyRangePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBKeyRangeConstructor) } },
    { "lower", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLower), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "upper", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpper), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lowerOpen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLowerOpen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "upperOpen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpperOpen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSIDBKeyRangePrototype::s_info = { "IDBKeyRangePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBKeyRangePrototype) };

void JSIDBKeyRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBKeyRangePrototypeTableValues, *this);
}

const ClassInfo JSIDBKeyRange::s_info = { "IDBKeyRange", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBKeyRange) };

JSIDBKeyRange::JSIDBKeyRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBKeyRange>&& impl)
    : JSDOMWrapper<IDBKeyRange>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIDBKeyRange::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSIDBKeyRangePrototype::create(vm, globalObject, JSIDBKeyRangePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSIDBKeyRange::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBKeyRange>(vm, globalObject);
}

void JSIDBKeyRange::destroy(JSC::JSCell* cell)
{
    JSIDBKeyRange* thisObject = static_cast<JSIDBKeyRange*>(cell);
    thisObject->JSIDBKeyRange::~JSIDBKeyRange();
}

EncodedJSValue jsIDBKeyRangeLower(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBKeyRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBKeyRange", "lower");
    }
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    auto& impl = castedThis->wrapped();
    JSValue result = (impl.lowerValue(scriptContext).hasNoValue() ? jsNull() : impl.lowerValue(scriptContext).jsValue());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBKeyRangeUpper(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBKeyRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBKeyRange", "upper");
    }
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    auto& impl = castedThis->wrapped();
    JSValue result = (impl.upperValue(scriptContext).hasNoValue() ? jsNull() : impl.upperValue(scriptContext).jsValue());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBKeyRangeLowerOpen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBKeyRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBKeyRange", "lowerOpen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.lowerOpen());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBKeyRangeUpperOpen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBKeyRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBKeyRange", "upperOpen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.upperOpen());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSIDBKeyRangePrototype* domObject = jsDynamicCast<JSIDBKeyRangePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSIDBKeyRange::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSIDBKeyRangePrototype* domObject = jsDynamicCast<JSIDBKeyRangePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSIDBKeyRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyRangeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionOnly(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue value = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::only(scriptContext, value, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionLowerBound(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue lower = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::lowerBound(scriptContext, lower, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    bool open = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::lowerBound(scriptContext, lower, open, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionUpperBound(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue upper = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::upperBound(scriptContext, upper, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    bool open = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::upperBound(scriptContext, upper, open, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionBound(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue lower = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue upper = { state->vm(), state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 2) {
        JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    bool lowerOpen = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 3) {
        JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, lowerOpen, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    bool upperOpen = state->argument(3).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject()), WTF::getPtr(IDBKeyRange::bound(scriptContext, lower, upper, lowerOpen, upperOpen, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSIDBKeyRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBKeyRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBKeyRange = jsCast<JSIDBKeyRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBKeyRange->wrapped(), jsIDBKeyRange);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBKeyRange* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSIDBKeyRange>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBKeyRange* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBKeyRange>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IDBKeyRange.
    COMPILE_ASSERT(!__is_polymorphic(IDBKeyRange), IDBKeyRange_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSIDBKeyRange>(globalObject, impl);
}

IDBKeyRange* JSIDBKeyRange::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBKeyRange*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
