/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_CONTROLS_SCRIPT)

#include "JSMediaControlsHost.h"

#include "AudioTrack.h"
#include "ExceptionCode.h"
#include "HTMLElement.h"
#include "JSAudioTrack.h"
#include "JSAudioTrackList.h"
#include "JSDOMBinding.h"
#include "JSHTMLElement.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "TextTrack.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionEnteredFullscreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionExitedFullscreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionGenerateUUID(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMediaControlsHostCaptionMenuOffItem(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostCaptionMenuAutomaticItem(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostCaptionDisplayMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostTextTrackContainer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostAllowsInlineMediaPlayback(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostSupportsFullscreen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostUserGestureRequired(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostExternalDeviceDisplayName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostExternalDeviceType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostControlsDependOnPageScaleFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControlsHostControlsDependOnPageScaleFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
void setJSMediaControlsHostConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaControlsHostPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaControlsHostPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaControlsHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaControlsHostPrototype>(vm.heap)) JSMediaControlsHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaControlsHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSMediaControlsHostPrototypeTableValues[] =
{
    { "captionMenuOffItem", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionMenuOffItem), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "captionMenuAutomaticItem", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionMenuAutomaticItem), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "captionDisplayMode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionDisplayMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "textTrackContainer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostTextTrackContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "allowsInlineMediaPlayback", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostAllowsInlineMediaPlayback), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "supportsFullscreen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostSupportsFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "userGestureRequired", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostUserGestureRequired), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "externalDeviceDisplayName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostExternalDeviceDisplayName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "externalDeviceType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostExternalDeviceType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "controlsDependOnPageScaleFactor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostControlsDependOnPageScaleFactor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControlsHostControlsDependOnPageScaleFactor) } },
    { "sortedTrackListForMenu", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu), (intptr_t) (1) } },
    { "displayNameForTrack", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionDisplayNameForTrack), (intptr_t) (1) } },
    { "setSelectedTextTrack", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack), (intptr_t) (1) } },
    { "updateTextTrackContainer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer), (intptr_t) (0) } },
    { "enteredFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionEnteredFullscreen), (intptr_t) (0) } },
    { "exitedFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionExitedFullscreen), (intptr_t) (0) } },
    { "generateUUID", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControlsHostPrototypeFunctionGenerateUUID), (intptr_t) (0) } },
};

const ClassInfo JSMediaControlsHostPrototype::s_info = { "MediaControlsHostPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaControlsHostPrototype) };

void JSMediaControlsHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaControlsHostPrototypeTableValues, *this);
}

const ClassInfo JSMediaControlsHost::s_info = { "MediaControlsHost", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaControlsHost) };

JSMediaControlsHost::JSMediaControlsHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaControlsHost>&& impl)
    : JSDOMWrapper<MediaControlsHost>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaControlsHost::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaControlsHostPrototype::create(vm, globalObject, JSMediaControlsHostPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMediaControlsHost::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaControlsHost>(vm, globalObject);
}

void JSMediaControlsHost::destroy(JSC::JSCell* cell)
{
    JSMediaControlsHost* thisObject = static_cast<JSMediaControlsHost*>(cell);
    thisObject->JSMediaControlsHost::~JSMediaControlsHost();
}

EncodedJSValue jsMediaControlsHostCaptionMenuOffItem(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "captionMenuOffItem");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.captionMenuOffItem()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostCaptionMenuAutomaticItem(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "captionMenuAutomaticItem");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.captionMenuAutomaticItem()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostCaptionDisplayMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "captionDisplayMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.captionDisplayMode());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostTextTrackContainer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "textTrackContainer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.textTrackContainer()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostAllowsInlineMediaPlayback(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "allowsInlineMediaPlayback");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.allowsInlineMediaPlayback());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostSupportsFullscreen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "supportsFullscreen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.supportsFullscreen());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostUserGestureRequired(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "userGestureRequired");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.userGestureRequired());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostExternalDeviceDisplayName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "externalDeviceDisplayName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.externalDeviceDisplayName());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostExternalDeviceType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "externalDeviceType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.externalDeviceType());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControlsHostControlsDependOnPageScaleFactor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaControlsHost*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaControlsHost", "controlsDependOnPageScaleFactor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.controlsDependOnPageScaleFactor());
    return JSValue::encode(result);
}


void setJSMediaControlsHostConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaControlsHostPrototype* domObject = jsDynamicCast<JSMediaControlsHostPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSMediaControlsHostControlsDependOnPageScaleFactor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaControlsHost* castedThis = jsDynamicCast<JSMediaControlsHost*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaControlsHost", "controlsDependOnPageScaleFactor");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setControlsDependOnPageScaleFactor(nativeValue);
}


static EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "sortedTrackListForMenu");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    TextTrackList* trackList = JSTextTrackList::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsArray(state, castedThis->globalObject(), impl.sortedTrackListForMenu(trackList));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "sortedTrackListForMenu");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    AudioTrackList* trackList = JSAudioTrackList::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsArray(state, castedThis->globalObject(), impl.sortedTrackListForMenu(trackList));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSTextTrackList::info())))))
        return jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu1(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSAudioTrackList::info())))))
        return jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "displayNameForTrack");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    TextTrack* track = JSTextTrack::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.displayNameForTrack(track));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "displayNameForTrack");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    AudioTrack* track = JSAudioTrack::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.displayNameForTrack(track));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSTextTrack::info())))))
        return jsMediaControlsHostPrototypeFunctionDisplayNameForTrack1(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSAudioTrack::info())))))
        return jsMediaControlsHostPrototypeFunctionDisplayNameForTrack2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "setSelectedTextTrack");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    TextTrack* track = JSTextTrack::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setSelectedTextTrack(track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "updateTextTrackContainer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    impl.updateTextTrackContainer();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionEnteredFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "enteredFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    impl.enteredFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionExitedFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "exitedFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    impl.exitedFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionGenerateUUID(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaControlsHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaControlsHost", "generateUUID");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaControlsHost::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.generateUUID());
    return JSValue::encode(result);
}

bool JSMediaControlsHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaControlsHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaControlsHost = jsCast<JSMediaControlsHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaControlsHost->wrapped(), jsMediaControlsHost);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaControlsHost* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaControlsHost>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaControlsHost* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaControlsHost>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaControlsHost.
    COMPILE_ASSERT(!__is_polymorphic(MediaControlsHost), MediaControlsHost_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSMediaControlsHost>(globalObject, impl);
}

MediaControlsHost* JSMediaControlsHost::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaControlsHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_CONTROLS_SCRIPT)
