/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionDeleteMedium(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionAppendMedium(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMediaListMediaText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaListMediaText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaListPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaListPrototype>(vm.heap)) JSMediaListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMediaList> JSMediaListConstructor;

template<> JSValue JSMediaListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MediaList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMediaListConstructor::s_info = { "MediaList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaListConstructor) } },
    { "mediaText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaListMediaText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaListMediaText) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaListPrototypeFunctionItem), (intptr_t) (0) } },
    { "deleteMedium", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaListPrototypeFunctionDeleteMedium), (intptr_t) (0) } },
    { "appendMedium", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaListPrototypeFunctionAppendMedium), (intptr_t) (0) } },
};

const ClassInfo JSMediaListPrototype::s_info = { "MediaListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaListPrototype) };

void JSMediaListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaListPrototypeTableValues, *this);
}

const ClassInfo JSMediaList::s_info = { "MediaList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaList) };

JSMediaList::JSMediaList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaList>&& impl)
    : JSDOMWrapper<MediaList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaListPrototype::create(vm, globalObject, JSMediaListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMediaList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaList>(vm, globalObject);
}

void JSMediaList::destroy(JSC::JSCell* cell)
{
    JSMediaList* thisObject = static_cast<JSMediaList*>(cell);
    thisObject->JSMediaList::~JSMediaList();
}

bool JSMediaList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSMediaList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, jsStringOrUndefined(state, thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSMediaList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSMediaList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index <= MAX_ARRAY_INDEX) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, jsStringOrUndefined(state, thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsMediaListMediaText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaList", "mediaText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.mediaText());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMediaListPrototype* domObject = jsDynamicCast<JSMediaListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMediaList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMediaListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaListPrototype* domObject = jsDynamicCast<JSMediaListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSMediaListMediaText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaList* castedThis = jsDynamicCast<JSMediaList*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaList", "mediaText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMediaText(nativeValue, ec);
    setDOMException(state, ec);
}


void JSMediaList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSMediaList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSMediaList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaList::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionDeleteMedium(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaList", "deleteMedium");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaList::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String oldMedium = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.deleteMedium(oldMedium, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaListPrototypeFunctionAppendMedium(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaList", "appendMedium");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaList::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String newMedium = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.appendMedium(newMedium, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

bool JSMediaListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsMediaList = jsCast<JSMediaList*>(handle.slot()->asCell());
    void* root = WebCore::root(&jsMediaList->wrapped());
    return visitor.containsOpaqueRoot(root);
}

void JSMediaListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaList = jsCast<JSMediaList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaList->wrapped(), jsMediaList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaList.
    COMPILE_ASSERT(!__is_polymorphic(MediaList), MediaList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSMediaList>(globalObject, impl);
}

MediaList* JSMediaList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
