/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGFECompositeElement.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGFECompositeElementIn1(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementIn2(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementOperator(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementK1(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementK2(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementK3(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementK4(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementResult(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFECompositeElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGFECompositeElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGFECompositeElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGFECompositeElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGFECompositeElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGFECompositeElementPrototype>(vm.heap)) JSSVGFECompositeElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGFECompositeElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGFECompositeElement> JSSVGFECompositeElementConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGFECompositeElementConstructorTableValues[] =
{
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
};

template<> JSValue JSSVGFECompositeElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGFECompositeElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGFECompositeElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGFECompositeElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGFECompositeElementConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGFECompositeElementConstructor::s_info = { "SVGFECompositeElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFECompositeElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGFECompositeElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGFECompositeElementConstructor) } },
    { "in1", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementIn1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "in2", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementIn2), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "operator", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementOperator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "k1", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "k2", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK2), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "k3", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK3), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "k4", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK4), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "x", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "result", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementResult), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
};

const ClassInfo JSSVGFECompositeElementPrototype::s_info = { "SVGFECompositeElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFECompositeElementPrototype) };

void JSSVGFECompositeElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGFECompositeElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGFECompositeElement::s_info = { "SVGFECompositeElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGFECompositeElement) };

JSSVGFECompositeElement::JSSVGFECompositeElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGFECompositeElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGFECompositeElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGFECompositeElementPrototype::create(vm, globalObject, JSSVGFECompositeElementPrototype::createStructure(vm, globalObject, JSSVGElement::getPrototype(vm, globalObject)));
}

JSObject* JSSVGFECompositeElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFECompositeElement>(vm, globalObject);
}

EncodedJSValue jsSVGFECompositeElementIn1(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "in1");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedString> obj = impl.in1Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementIn2(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "in2");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedString> obj = impl.in2Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementOperator(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "operator");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedEnumeration> obj = impl.svgOperatorAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementK1(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "k1");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedNumber> obj = impl.k1Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementK2(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "k2");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedNumber> obj = impl.k2Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementK3(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "k3");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedNumber> obj = impl.k3Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementK4(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "k4");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedNumber> obj = impl.k4Animated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "x");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedLength> obj = impl.xAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "y");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedLength> obj = impl.yAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "width");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedLength> obj = impl.widthAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "height");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedLength> obj = impl.heightAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementResult(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGFECompositeElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGFECompositeElement", "result");
    }
    auto& impl = castedThis->wrapped();
    RefPtr<SVGAnimatedString> obj = impl.resultAnimated();
    JSValue result = toJS(state, castedThis->globalObject(), obj.get());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGFECompositeElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGFECompositeElementPrototype* domObject = jsDynamicCast<JSSVGFECompositeElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGFECompositeElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGFECompositeElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGFECompositeElementPrototype* domObject = jsDynamicCast<JSSVGFECompositeElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGFECompositeElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFECompositeElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGFECompositeElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGFECompositeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
