/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDrawBuffers.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL(JSC::ExecState*);

class JSWebGLDrawBuffersPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLDrawBuffersPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDrawBuffersPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDrawBuffersPrototype>(vm.heap)) JSWebGLDrawBuffersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDrawBuffersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLDrawBuffersPrototypeTableValues[] =
{
    { "drawBuffersWEBGL", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL), (intptr_t) (1) } },
    { "COLOR_ATTACHMENT0_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE0) } },
    { "COLOR_ATTACHMENT1_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE1) } },
    { "COLOR_ATTACHMENT2_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE2) } },
    { "COLOR_ATTACHMENT3_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE3) } },
    { "COLOR_ATTACHMENT4_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE4) } },
    { "COLOR_ATTACHMENT5_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE5) } },
    { "COLOR_ATTACHMENT6_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE6) } },
    { "COLOR_ATTACHMENT7_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE7) } },
    { "COLOR_ATTACHMENT8_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE8) } },
    { "COLOR_ATTACHMENT9_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CE9) } },
    { "COLOR_ATTACHMENT10_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CEA) } },
    { "COLOR_ATTACHMENT11_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CEB) } },
    { "COLOR_ATTACHMENT12_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CEC) } },
    { "COLOR_ATTACHMENT13_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CED) } },
    { "COLOR_ATTACHMENT14_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CEE) } },
    { "COLOR_ATTACHMENT15_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CEF) } },
    { "DRAW_BUFFER0_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8825) } },
    { "DRAW_BUFFER1_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8826) } },
    { "DRAW_BUFFER2_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8827) } },
    { "DRAW_BUFFER3_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8828) } },
    { "DRAW_BUFFER4_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8829) } },
    { "DRAW_BUFFER5_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882A) } },
    { "DRAW_BUFFER6_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882B) } },
    { "DRAW_BUFFER7_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882C) } },
    { "DRAW_BUFFER8_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882D) } },
    { "DRAW_BUFFER9_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882E) } },
    { "DRAW_BUFFER10_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x882F) } },
    { "DRAW_BUFFER11_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8830) } },
    { "DRAW_BUFFER12_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8831) } },
    { "DRAW_BUFFER13_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8832) } },
    { "DRAW_BUFFER14_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8833) } },
    { "DRAW_BUFFER15_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8834) } },
    { "MAX_COLOR_ATTACHMENTS_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8CDF) } },
    { "MAX_DRAW_BUFFERS_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8824) } },
};

const ClassInfo JSWebGLDrawBuffersPrototype::s_info = { "WebGLDrawBuffersPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDrawBuffersPrototype) };

void JSWebGLDrawBuffersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDrawBuffersPrototypeTableValues, *this);
}

const ClassInfo JSWebGLDrawBuffers::s_info = { "WebGLDrawBuffers", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDrawBuffers) };

JSWebGLDrawBuffers::JSWebGLDrawBuffers(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDrawBuffers>&& impl)
    : JSDOMWrapper<WebGLDrawBuffers>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLDrawBuffers::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLDrawBuffersPrototype::create(vm, globalObject, JSWebGLDrawBuffersPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLDrawBuffers::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDrawBuffers>(vm, globalObject);
}

void JSWebGLDrawBuffers::destroy(JSC::JSCell* cell)
{
    JSWebGLDrawBuffers* thisObject = static_cast<JSWebGLDrawBuffers*>(cell);
    thisObject->JSWebGLDrawBuffers::~JSWebGLDrawBuffers();
}

EncodedJSValue JSC_HOST_CALL jsWebGLDrawBuffersPrototypeFunctionDrawBuffersWEBGL(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebGLDrawBuffers*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebGLDrawBuffers", "drawBuffersWEBGL");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebGLDrawBuffers::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Vector<unsigned> buffers = toNativeArray<unsigned>(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawBuffersWEBGL(buffers);
    return JSValue::encode(jsUndefined());
}

bool JSWebGLDrawBuffersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLDrawBuffers = jsCast<JSWebGLDrawBuffers*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDrawBuffers->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDrawBuffersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDrawBuffers = jsCast<JSWebGLDrawBuffers*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDrawBuffers->wrapped(), jsWebGLDrawBuffers);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDrawBuffers@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLDrawBuffersE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDrawBuffers* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLDrawBuffers>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDrawBuffers* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLDrawBuffers>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLDrawBuffers@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLDrawBuffersE[2];
#if COMPILER(CLANG)
    // If this fails WebGLDrawBuffers does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLDrawBuffers), WebGLDrawBuffers_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLDrawBuffers has subclasses. If WebGLDrawBuffers has subclasses that get passed
    // to toJS() we currently require WebGLDrawBuffers you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLDrawBuffers>(globalObject, impl);
}

WebGLDrawBuffers* JSWebGLDrawBuffers::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDrawBuffers*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
