/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLLoseContext.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionLoseContext(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionRestoreContext(JSC::ExecState*);

class JSWebGLLoseContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLLoseContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLLoseContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLLoseContextPrototype>(vm.heap)) JSWebGLLoseContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLLoseContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLLoseContextPrototypeTableValues[] =
{
    { "loseContext", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebGLLoseContextPrototypeFunctionLoseContext), (intptr_t) (0) } },
    { "restoreContext", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebGLLoseContextPrototypeFunctionRestoreContext), (intptr_t) (0) } },
};

const ClassInfo JSWebGLLoseContextPrototype::s_info = { "WebGLLoseContextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLLoseContextPrototype) };

void JSWebGLLoseContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLLoseContextPrototypeTableValues, *this);
}

const ClassInfo JSWebGLLoseContext::s_info = { "WebGLLoseContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLLoseContext) };

JSWebGLLoseContext::JSWebGLLoseContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLLoseContext>&& impl)
    : JSDOMWrapper<WebGLLoseContext>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLLoseContext::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLLoseContextPrototype::create(vm, globalObject, JSWebGLLoseContextPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLLoseContext::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLLoseContext>(vm, globalObject);
}

void JSWebGLLoseContext::destroy(JSC::JSCell* cell)
{
    JSWebGLLoseContext* thisObject = static_cast<JSWebGLLoseContext*>(cell);
    thisObject->JSWebGLLoseContext::~JSWebGLLoseContext();
}

EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionLoseContext(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebGLLoseContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebGLLoseContext", "loseContext");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebGLLoseContext::info());
    auto& impl = castedThis->wrapped();
    impl.loseContext();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebGLLoseContextPrototypeFunctionRestoreContext(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebGLLoseContext*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebGLLoseContext", "restoreContext");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebGLLoseContext::info());
    auto& impl = castedThis->wrapped();
    impl.restoreContext();
    return JSValue::encode(jsUndefined());
}

bool JSWebGLLoseContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLLoseContext = jsCast<JSWebGLLoseContext*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLLoseContext->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLLoseContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLLoseContext = jsCast<JSWebGLLoseContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLLoseContext->wrapped(), jsWebGLLoseContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLLoseContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLLoseContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLLoseContext* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLLoseContext>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLLoseContext* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLLoseContext>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLLoseContext@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLLoseContextE[2];
#if COMPILER(CLANG)
    // If this fails WebGLLoseContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLLoseContext), WebGLLoseContext_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLLoseContext has subclasses. If WebGLLoseContext has subclasses that get passed
    // to toJS() we currently require WebGLLoseContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLLoseContext>(globalObject, impl);
}

WebGLLoseContext* JSWebGLLoseContext::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLLoseContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
