/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLQuery.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLQueryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLQueryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLQueryPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLQueryPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLQueryPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLQueryPrototype>(vm.heap)) JSWebGLQueryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLQueryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLQuery> JSWebGLQueryConstructor;

template<> JSValue JSWebGLQueryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLQueryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLQuery::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLQuery"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLQueryConstructor::s_info = { "WebGLQuery", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLQueryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLQueryPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLQueryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLQueryConstructor) } },
};

const ClassInfo JSWebGLQueryPrototype::s_info = { "WebGLQueryPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLQueryPrototype) };

void JSWebGLQueryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLQueryPrototypeTableValues, *this);
}

const ClassInfo JSWebGLQuery::s_info = { "WebGLQuery", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLQuery) };

JSWebGLQuery::JSWebGLQuery(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLQuery>&& impl)
    : JSDOMWrapper<WebGLQuery>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLQuery::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLQueryPrototype::create(vm, globalObject, JSWebGLQueryPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLQuery::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLQuery>(vm, globalObject);
}

void JSWebGLQuery::destroy(JSC::JSCell* cell)
{
    JSWebGLQuery* thisObject = static_cast<JSWebGLQuery*>(cell);
    thisObject->JSWebGLQuery::~JSWebGLQuery();
}

EncodedJSValue jsWebGLQueryConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLQueryPrototype* domObject = jsDynamicCast<JSWebGLQueryPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLQuery::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLQueryConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLQueryPrototype* domObject = jsDynamicCast<JSWebGLQueryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLQuery::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLQueryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLQueryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLQueryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLQuery = jsCast<JSWebGLQuery*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLQuery->wrapped(), jsWebGLQuery);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLQuery@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10WebGLQueryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLQuery* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLQuery>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLQuery* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLQuery>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLQuery@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10WebGLQueryE[2];
#if COMPILER(CLANG)
    // If this fails WebGLQuery does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLQuery), WebGLQuery_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLQuery has subclasses. If WebGLQuery has subclasses that get passed
    // to toJS() we currently require WebGLQuery you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLQuery>(globalObject, impl);
}

WebGLQuery* JSWebGLQuery::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLQuery*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
