/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWebGLRenderingContextBase_h
#define JSWebGLRenderingContextBase_h

#if ENABLE(WEBGL)

#include "JSCanvasRenderingContext.h"
#include "WebGLRenderingContextBase.h"

namespace WebCore {

class JSWebGLRenderingContextBase : public JSCanvasRenderingContext {
public:
    typedef JSCanvasRenderingContext Base;
    static JSWebGLRenderingContextBase* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<WebGLRenderingContextBase>&& impl)
    {
        JSWebGLRenderingContextBase* ptr = new (NotNull, JSC::allocateCell<JSWebGLRenderingContextBase>(globalObject->vm().heap)) JSWebGLRenderingContextBase(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static const bool hasStaticPropertyTable = false;

    static JSC::JSObject* createPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static JSC::JSObject* getPrototype(JSC::VM&, JSC::JSGlobalObject*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);


    // Custom functions
    JSC::JSValue getAttachedShaders(JSC::ExecState&);
    JSC::JSValue getBufferParameter(JSC::ExecState&);
    JSC::JSValue getExtension(JSC::ExecState&);
    JSC::JSValue getFramebufferAttachmentParameter(JSC::ExecState&);
    JSC::JSValue getParameter(JSC::ExecState&);
    JSC::JSValue getProgramParameter(JSC::ExecState&);
    JSC::JSValue getRenderbufferParameter(JSC::ExecState&);
    JSC::JSValue getShaderParameter(JSC::ExecState&);
    JSC::JSValue getSupportedExtensions(JSC::ExecState&);
    JSC::JSValue getTexParameter(JSC::ExecState&);
    JSC::JSValue getUniform(JSC::ExecState&);
    JSC::JSValue getVertexAttrib(JSC::ExecState&);
    JSC::JSValue uniform1fv(JSC::ExecState&);
    JSC::JSValue uniform1iv(JSC::ExecState&);
    JSC::JSValue uniform2fv(JSC::ExecState&);
    JSC::JSValue uniform2iv(JSC::ExecState&);
    JSC::JSValue uniform3fv(JSC::ExecState&);
    JSC::JSValue uniform3iv(JSC::ExecState&);
    JSC::JSValue uniform4fv(JSC::ExecState&);
    JSC::JSValue uniform4iv(JSC::ExecState&);
    JSC::JSValue uniformMatrix2fv(JSC::ExecState&);
    JSC::JSValue uniformMatrix3fv(JSC::ExecState&);
    JSC::JSValue uniformMatrix4fv(JSC::ExecState&);
    JSC::JSValue vertexAttrib1fv(JSC::ExecState&);
    JSC::JSValue vertexAttrib2fv(JSC::ExecState&);
    JSC::JSValue vertexAttrib3fv(JSC::ExecState&);
    JSC::JSValue vertexAttrib4fv(JSC::ExecState&);
    WebGLRenderingContextBase& wrapped() const
    {
        return static_cast<WebGLRenderingContextBase&>(Base::wrapped());
    }
protected:
    JSWebGLRenderingContextBase(JSC::Structure*, JSDOMGlobalObject&, Ref<WebGLRenderingContextBase>&&);

    void finishCreation(JSC::VM& vm)
    {
        Base::finishCreation(vm);
        ASSERT(inherits(info()));
    }

};



} // namespace WebCore

#endif // ENABLE(WEBGL)

#endif
