/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerLocation.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWorkerLocationPrototypeFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWorkerLocationHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWorkerLocationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWorkerLocationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWorkerLocationPrototype* ptr = new (NotNull, JSC::allocateCell<JSWorkerLocationPrototype>(vm.heap)) JSWorkerLocationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWorkerLocationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWorkerLocation> JSWorkerLocationConstructor;

template<> JSValue JSWorkerLocationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWorkerLocationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWorkerLocation::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WorkerLocation"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWorkerLocationConstructor::s_info = { "WorkerLocation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerLocationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWorkerLocationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerLocationConstructor) } },
    { "href", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "protocol", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "host", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hostname", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHostname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "port", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pathname", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationPathname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "search", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationSearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hash", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "origin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toString", DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerLocationPrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSWorkerLocationPrototype::s_info = { "WorkerLocationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerLocationPrototype) };

void JSWorkerLocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWorkerLocationPrototypeTableValues, *this);
}

const ClassInfo JSWorkerLocation::s_info = { "WorkerLocation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerLocation) };

JSWorkerLocation::JSWorkerLocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WorkerLocation>&& impl)
    : JSDOMWrapper<WorkerLocation>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWorkerLocation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWorkerLocationPrototype::create(vm, globalObject, JSWorkerLocationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWorkerLocation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorkerLocation>(vm, globalObject);
}

void JSWorkerLocation::destroy(JSC::JSCell* cell)
{
    JSWorkerLocation* thisObject = static_cast<JSWorkerLocation*>(cell);
    thisObject->JSWorkerLocation::~JSWorkerLocation();
}

EncodedJSValue jsWorkerLocationHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.href());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationProtocol(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "protocol");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.protocol());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationHost(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "host");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.host());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationHostname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "hostname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hostname());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationPort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "port");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.port());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationPathname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "pathname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pathname());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationSearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "search");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.search());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationHash(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "hash");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hash());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWorkerLocation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerLocation", "origin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.origin());
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerLocationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWorkerLocationPrototype* domObject = jsDynamicCast<JSWorkerLocationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWorkerLocation::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWorkerLocationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWorkerLocationPrototype* domObject = jsDynamicCast<JSWorkerLocationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWorkerLocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerLocationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWorkerLocationPrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWorkerLocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WorkerLocation", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerLocation::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

bool JSWorkerLocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWorkerLocation = jsCast<JSWorkerLocation*>(handle.slot()->asCell());
    WorkerLocation* root = &jsWorkerLocation->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSWorkerLocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWorkerLocation = jsCast<JSWorkerLocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWorkerLocation->wrapped(), jsWorkerLocation);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WorkerLocation* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWorkerLocation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WorkerLocation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWorkerLocation>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WorkerLocation.
    COMPILE_ASSERT(!__is_polymorphic(WorkerLocation), WorkerLocation_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSWorkerLocation>(globalObject, impl);
}

WorkerLocation* JSWorkerLocation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerLocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
