/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestUpload.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestUploadPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXMLHttpRequestUploadPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestUploadPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestUploadPrototype>(vm.heap)) JSXMLHttpRequestUploadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestUploadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSXMLHttpRequestUpload> JSXMLHttpRequestUploadConstructor;

template<> JSValue JSXMLHttpRequestUploadConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestUploadConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestUpload::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XMLHttpRequestUpload"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUpload", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUploadConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestUploadConstructor) } },
};

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestUploadPrototype) };

void JSXMLHttpRequestUploadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestUploadPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestUpload) };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestUpload>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXMLHttpRequestUpload::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXMLHttpRequestUploadPrototype::create(vm, globalObject, JSXMLHttpRequestUploadPrototype::createStructure(vm, globalObject, JSXMLHttpRequestEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequestUpload::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(vm, globalObject);
}

EncodedJSValue jsXMLHttpRequestUploadConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXMLHttpRequestUploadPrototype* domObject = jsDynamicCast<JSXMLHttpRequestUploadPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXMLHttpRequestUpload::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXMLHttpRequestUploadConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXMLHttpRequestUploadPrototype* domObject = jsDynamicCast<JSXMLHttpRequestUploadPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXMLHttpRequestUpload::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXMLHttpRequestUpload::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequestUpload*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSXMLHttpRequestUploadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    if (jsXMLHttpRequestUpload->wrapped().isFiringEventListeners())
        return true;
    XMLHttpRequestUpload* root = &jsXMLHttpRequestUpload->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSXMLHttpRequestUploadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequestUpload = jsCast<JSXMLHttpRequestUpload*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequestUpload->wrapped(), jsXMLHttpRequestUpload);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequestUpload@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20XMLHttpRequestUploadE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXMLHttpRequestUpload>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLHttpRequestUpload* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXMLHttpRequestUpload>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7XMLHttpRequestUpload@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20XMLHttpRequestUploadE[2];
#if COMPILER(CLANG)
    // If this fails XMLHttpRequestUpload does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(XMLHttpRequestUpload), XMLHttpRequestUpload_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // XMLHttpRequestUpload has subclasses. If XMLHttpRequestUpload has subclasses that get passed
    // to toJS() we currently require XMLHttpRequestUpload you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSXMLHttpRequestUpload>(globalObject, impl);
}


}
