/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(XSLT)

#include "JSXSLTProcessor.h"

#include "Document.h"
#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionImportStylesheet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToFragment(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToDocument(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionSetParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionGetParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionRemoveParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionClearParameters(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionReset(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXSLTProcessorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXSLTProcessorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXSLTProcessorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXSLTProcessorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXSLTProcessorPrototype* ptr = new (NotNull, JSC::allocateCell<JSXSLTProcessorPrototype>(vm.heap)) JSXSLTProcessorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXSLTProcessorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSXSLTProcessor> JSXSLTProcessorConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSXSLTProcessorConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSXSLTProcessorConstructor*>(state->callee());
    RefPtr<XSLTProcessor> object = XSLTProcessor::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSXSLTProcessorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXSLTProcessorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXSLTProcessor::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XSLTProcessor"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXSLTProcessorConstructor::s_info = { "XSLTProcessor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXSLTProcessorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXSLTProcessorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXSLTProcessorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXSLTProcessorConstructor) } },
    { "importStylesheet", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionImportStylesheet), (intptr_t) (0) } },
    { "transformToFragment", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToFragment), (intptr_t) (0) } },
    { "transformToDocument", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToDocument), (intptr_t) (0) } },
    { "setParameter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionSetParameter), (intptr_t) (3) } },
    { "getParameter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionGetParameter), (intptr_t) (2) } },
    { "removeParameter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionRemoveParameter), (intptr_t) (2) } },
    { "clearParameters", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionClearParameters), (intptr_t) (0) } },
    { "reset", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXSLTProcessorPrototypeFunctionReset), (intptr_t) (0) } },
};

const ClassInfo JSXSLTProcessorPrototype::s_info = { "XSLTProcessorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXSLTProcessorPrototype) };

void JSXSLTProcessorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXSLTProcessorPrototypeTableValues, *this);
}

const ClassInfo JSXSLTProcessor::s_info = { "XSLTProcessor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXSLTProcessor) };

JSXSLTProcessor::JSXSLTProcessor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XSLTProcessor>&& impl)
    : JSDOMWrapper<XSLTProcessor>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXSLTProcessor::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXSLTProcessorPrototype::create(vm, globalObject, JSXSLTProcessorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSXSLTProcessor::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXSLTProcessor>(vm, globalObject);
}

void JSXSLTProcessor::destroy(JSC::JSCell* cell)
{
    JSXSLTProcessor* thisObject = static_cast<JSXSLTProcessor*>(cell);
    thisObject->JSXSLTProcessor::~JSXSLTProcessor();
}

EncodedJSValue jsXSLTProcessorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXSLTProcessorPrototype* domObject = jsDynamicCast<JSXSLTProcessorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXSLTProcessor::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXSLTProcessorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXSLTProcessorPrototype* domObject = jsDynamicCast<JSXSLTProcessorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXSLTProcessor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXSLTProcessorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionImportStylesheet(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "importStylesheet");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    auto& impl = castedThis->wrapped();
    Node* stylesheet = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.importStylesheet(stylesheet);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToFragment(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "transformToFragment");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    auto& impl = castedThis->wrapped();
    Node* source = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Document* docVal = JSDocument::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.transformToFragment(source, docVal)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToDocument(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "transformToDocument");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    auto& impl = castedThis->wrapped();
    Node* source = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.transformToDocument(source)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionSetParameter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "setParameter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    return JSValue::encode(castedThis->setParameter(*state));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionGetParameter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "getParameter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    return JSValue::encode(castedThis->getParameter(*state));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionRemoveParameter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "removeParameter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    return JSValue::encode(castedThis->removeParameter(*state));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionClearParameters(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "clearParameters");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    auto& impl = castedThis->wrapped();
    impl.clearParameters();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionReset(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXSLTProcessor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XSLTProcessor", "reset");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXSLTProcessor::info());
    auto& impl = castedThis->wrapped();
    impl.reset();
    return JSValue::encode(jsUndefined());
}

bool JSXSLTProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXSLTProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXSLTProcessor = jsCast<JSXSLTProcessor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXSLTProcessor->wrapped(), jsXSLTProcessor);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XSLTProcessor* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXSLTProcessor>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XSLTProcessor* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXSLTProcessor>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XSLTProcessor.
    COMPILE_ASSERT(!__is_polymorphic(XSLTProcessor), XSLTProcessor_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSXSLTProcessor>(globalObject, impl);
}

XSLTProcessor* JSXSLTProcessor::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXSLTProcessor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(XSLT)
