/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013, 2014 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#ifndef InspectorBackendDispatchers_h
#define InspectorBackendDispatchers_h

#include "InspectorProtocolObjects.h"
#include <inspector/InspectorBackendDispatcher.h>
#include <wtf/text/WTFString.h>

namespace Inspector {

typedef String ErrorString;

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
class AlternateApplicationCacheBackendDispatcher;
class AlternateCSSBackendDispatcher;
class AlternateConsoleBackendDispatcher;
class AlternateDOMBackendDispatcher;
class AlternateDOMDebuggerBackendDispatcher;
class AlternateDOMStorageBackendDispatcher;
class AlternateDatabaseBackendDispatcher;
class AlternateDebuggerBackendDispatcher;
class AlternateHeapBackendDispatcher;
#if ENABLE(INDEXED_DATABASE)
class AlternateIndexedDBBackendDispatcher;
#endif // ENABLE(INDEXED_DATABASE)
class AlternateInspectorBackendDispatcher;
class AlternateLayerTreeBackendDispatcher;
class AlternateNetworkBackendDispatcher;
class AlternatePageBackendDispatcher;
class AlternateRuntimeBackendDispatcher;
class AlternateScriptProfilerBackendDispatcher;
class AlternateTimelineBackendDispatcher;
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcherHandler {
public:
    virtual void getFramesWithManifests(ErrorString&, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::ApplicationCache::FrameWithManifest>>& out_frameIds) = 0;
    virtual void enable(ErrorString&) = 0;
    virtual void getManifestForFrame(ErrorString&, const String& in_frameId, String* out_manifestURL) = 0;
    virtual void getApplicationCacheForFrame(ErrorString&, const String& in_frameId, RefPtr<Inspector::Protocol::ApplicationCache::ApplicationCache>& out_applicationCache) = 0;
protected:
    virtual ~ApplicationCacheBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE CSSBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getMatchedStylesForNode(ErrorString&, int in_nodeId, const bool* opt_in_includePseudo, const bool* opt_in_includeInherited, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::RuleMatch>>& opt_out_matchedCSSRules, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::PseudoIdMatches>>& opt_out_pseudoElements, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::InheritedStyleEntry>>& opt_out_inherited) = 0;
    virtual void getInlineStylesForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::CSS::CSSStyle>& opt_out_inlineStyle, RefPtr<Inspector::Protocol::CSS::CSSStyle>& opt_out_attributesStyle) = 0;
    virtual void getComputedStyleForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSComputedStyleProperty>>& out_computedStyle) = 0;
    virtual void getAllStyleSheets(ErrorString&, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSStyleSheetHeader>>& out_headers) = 0;
    virtual void getStyleSheet(ErrorString&, const String& in_styleSheetId, RefPtr<Inspector::Protocol::CSS::CSSStyleSheetBody>& out_styleSheet) = 0;
    virtual void getStyleSheetText(ErrorString&, const String& in_styleSheetId, String* out_text) = 0;
    virtual void setStyleSheetText(ErrorString&, const String& in_styleSheetId, const String& in_text) = 0;
    virtual void setStyleText(ErrorString&, const Inspector::InspectorObject& in_styleId, const String& in_text, RefPtr<Inspector::Protocol::CSS::CSSStyle>& out_style) = 0;
    virtual void setRuleSelector(ErrorString&, const Inspector::InspectorObject& in_ruleId, const String& in_selector, RefPtr<Inspector::Protocol::CSS::CSSRule>& out_rule) = 0;
    virtual void createStyleSheet(ErrorString&, const String& in_frameId, String* out_styleSheetId) = 0;
    virtual void addRule(ErrorString&, const String& in_styleSheetId, const String& in_selector, RefPtr<Inspector::Protocol::CSS::CSSRule>& out_rule) = 0;
    virtual void getSupportedCSSProperties(ErrorString&, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSPropertyInfo>>& out_cssProperties) = 0;
    virtual void getSupportedSystemFontFamilyNames(ErrorString&, RefPtr<Inspector::Protocol::Array<String>>& out_fontFamilyNames) = 0;
    virtual void forcePseudoState(ErrorString&, int in_nodeId, const Inspector::InspectorArray& in_forcedPseudoClasses) = 0;
    virtual void getNamedFlowCollection(ErrorString&, int in_documentNodeId, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::NamedFlow>>& out_namedFlows) = 0;
protected:
    virtual ~CSSBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void clearMessages(ErrorString&) = 0;
    virtual void setMonitoringXHREnabled(ErrorString&, bool in_enabled) = 0;
    virtual void addInspectedNode(ErrorString&, int in_nodeId) = 0;
protected:
    virtual ~ConsoleBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMBackendDispatcherHandler {
public:
    virtual void getDocument(ErrorString&, RefPtr<Inspector::Protocol::DOM::Node>& out_root) = 0;
    virtual void requestChildNodes(ErrorString&, int in_nodeId, const int* opt_in_depth) = 0;
    virtual void querySelector(ErrorString&, int in_nodeId, const String& in_selector, int* out_nodeId) = 0;
    virtual void querySelectorAll(ErrorString&, int in_nodeId, const String& in_selector, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>>& out_nodeIds) = 0;
    virtual void setNodeName(ErrorString&, int in_nodeId, const String& in_name, int* out_nodeId) = 0;
    virtual void setNodeValue(ErrorString&, int in_nodeId, const String& in_value) = 0;
    virtual void removeNode(ErrorString&, int in_nodeId) = 0;
    virtual void setAttributeValue(ErrorString&, int in_nodeId, const String& in_name, const String& in_value) = 0;
    virtual void setAttributesAsText(ErrorString&, int in_nodeId, const String& in_text, const String* opt_in_name) = 0;
    virtual void removeAttribute(ErrorString&, int in_nodeId, const String& in_name) = 0;
    virtual void getEventListenersForNode(ErrorString&, int in_nodeId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::EventListener>>& out_listeners) = 0;
    virtual void getAccessibilityPropertiesForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::DOM::AccessibilityProperties>& out_properties) = 0;
    virtual void getOuterHTML(ErrorString&, int in_nodeId, String* out_outerHTML) = 0;
    virtual void setOuterHTML(ErrorString&, int in_nodeId, const String& in_outerHTML) = 0;
    virtual void performSearch(ErrorString&, const String& in_query, const Inspector::InspectorArray* opt_in_nodeIds, String* out_searchId, int* out_resultCount) = 0;
    virtual void getSearchResults(ErrorString&, const String& in_searchId, int in_fromIndex, int in_toIndex, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>>& out_nodeIds) = 0;
    virtual void discardSearchResults(ErrorString&, const String& in_searchId) = 0;
    virtual void requestNode(ErrorString&, const String& in_objectId, int* out_nodeId) = 0;
    virtual void setInspectModeEnabled(ErrorString&, bool in_enabled, const Inspector::InspectorObject* opt_in_highlightConfig) = 0;
    virtual void highlightRect(ErrorString&, int in_x, int in_y, int in_width, int in_height, const Inspector::InspectorObject* opt_in_color, const Inspector::InspectorObject* opt_in_outlineColor, const bool* opt_in_usePageCoordinates) = 0;
    virtual void highlightQuad(ErrorString&, const Inspector::InspectorArray& in_quad, const Inspector::InspectorObject* opt_in_color, const Inspector::InspectorObject* opt_in_outlineColor, const bool* opt_in_usePageCoordinates) = 0;
    virtual void highlightSelector(ErrorString&, const Inspector::InspectorObject& in_highlightConfig, const String& in_selectorString, const String* opt_in_frameId) = 0;
    virtual void highlightNode(ErrorString&, const Inspector::InspectorObject& in_highlightConfig, const int* opt_in_nodeId, const String* opt_in_objectId) = 0;
    virtual void hideHighlight(ErrorString&) = 0;
    virtual void highlightFrame(ErrorString&, const String& in_frameId, const Inspector::InspectorObject* opt_in_contentColor, const Inspector::InspectorObject* opt_in_contentOutlineColor) = 0;
    virtual void pushNodeByPathToFrontend(ErrorString&, const String& in_path, int* out_nodeId) = 0;
    virtual void pushNodeByBackendIdToFrontend(ErrorString&, int in_backendNodeId, int* out_nodeId) = 0;
    virtual void releaseBackendNodeIds(ErrorString&, const String& in_nodeGroup) = 0;
    virtual void resolveNode(ErrorString&, int in_nodeId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_object) = 0;
    virtual void getAttributes(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::Array<String>>& out_attributes) = 0;
    virtual void moveTo(ErrorString&, int in_nodeId, int in_targetNodeId, const int* opt_in_insertBeforeNodeId, int* out_nodeId) = 0;
    virtual void undo(ErrorString&) = 0;
    virtual void redo(ErrorString&) = 0;
    virtual void markUndoableState(ErrorString&) = 0;
    virtual void focus(ErrorString&, int in_nodeId) = 0;
protected:
    virtual ~DOMBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcherHandler {
public:
    // Named after parameter 'type' while generating command/event setDOMBreakpoint.
    enum class Type {
        SubtreeModified = 61,
        AttributeModified = 62,
        NodeRemoved = 63,
    }; // enum class Type
    virtual void setDOMBreakpoint(ErrorString&, int in_nodeId, const String& in_type) = 0;
    virtual void removeDOMBreakpoint(ErrorString&, int in_nodeId, const String& in_type) = 0;
    virtual void setEventListenerBreakpoint(ErrorString&, const String& in_eventName) = 0;
    virtual void removeEventListenerBreakpoint(ErrorString&, const String& in_eventName) = 0;
    virtual void setInstrumentationBreakpoint(ErrorString&, const String& in_eventName) = 0;
    virtual void removeInstrumentationBreakpoint(ErrorString&, const String& in_eventName) = 0;
    virtual void setXHRBreakpoint(ErrorString&, const String& in_url) = 0;
    virtual void removeXHRBreakpoint(ErrorString&, const String& in_url) = 0;
protected:
    virtual ~DOMDebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getDOMStorageItems(ErrorString&, const Inspector::InspectorObject& in_storageId, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOMStorage::Item>>& out_entries) = 0;
    virtual void setDOMStorageItem(ErrorString&, const Inspector::InspectorObject& in_storageId, const String& in_key, const String& in_value) = 0;
    virtual void removeDOMStorageItem(ErrorString&, const Inspector::InspectorObject& in_storageId, const String& in_key) = 0;
protected:
    virtual ~DOMStorageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getDatabaseTableNames(ErrorString&, const String& in_databaseId, RefPtr<Inspector::Protocol::Array<String>>& out_tableNames) = 0;
    class JS_EXPORT_PRIVATE ExecuteSQLCallback : public BackendDispatcher::CallbackBase {
    public:
        ExecuteSQLCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::Array<String>>&& columnNames, RefPtr<Inspector::Protocol::Array<Inspector::InspectorValue>>&& values, RefPtr<Inspector::Protocol::Database::Error>&& sqlError);
    };
    virtual void executeSQL(ErrorString&, const String& in_databaseId, const String& in_query, Ref<ExecuteSQLCallback>&& callback) = 0;
protected:
    virtual ~DatabaseBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void setBreakpointsActive(ErrorString&, bool in_active) = 0;
    virtual void setBreakpointByUrl(ErrorString&, int in_lineNumber, const String* opt_in_url, const String* opt_in_urlRegex, const int* opt_in_columnNumber, const Inspector::InspectorObject* opt_in_options, String* out_breakpointId, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Debugger::Location>>& out_locations) = 0;
    virtual void setBreakpoint(ErrorString&, const Inspector::InspectorObject& in_location, const Inspector::InspectorObject* opt_in_options, String* out_breakpointId, RefPtr<Inspector::Protocol::Debugger::Location>& out_actualLocation) = 0;
    virtual void removeBreakpoint(ErrorString&, const String& in_breakpointId) = 0;
    virtual void continueToLocation(ErrorString&, const Inspector::InspectorObject& in_location) = 0;
    virtual void stepOver(ErrorString&) = 0;
    virtual void stepInto(ErrorString&) = 0;
    virtual void stepOut(ErrorString&) = 0;
    virtual void pause(ErrorString&) = 0;
    virtual void resume(ErrorString&) = 0;
    virtual void searchInContent(ErrorString&, const String& in_scriptId, const String& in_query, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::GenericTypes::SearchMatch>>& out_result) = 0;
    virtual void getScriptSource(ErrorString&, const String& in_scriptId, String* out_scriptSource) = 0;
    virtual void getFunctionDetails(ErrorString&, const String& in_functionId, RefPtr<Inspector::Protocol::Debugger::FunctionDetails>& out_details) = 0;
    // Named after parameter 'state' while generating command/event setPauseOnExceptions.
    enum class State {
        None = 106,
        Uncaught = 140,
        All = 141,
    }; // enum class State
    virtual void setPauseOnExceptions(ErrorString&, const String& in_state) = 0;
    virtual void evaluateOnCallFrame(ErrorString&, const String& in_callFrameId, const String& in_expression, const String* opt_in_objectGroup, const bool* opt_in_includeCommandLineAPI, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_saveResult, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Inspector::Protocol::OptOutput<bool>* opt_out_wasThrown, Inspector::Protocol::OptOutput<int>* opt_out_savedResultIndex) = 0;
    virtual void setOverlayMessage(ErrorString&, const String* opt_in_message) = 0;
protected:
    virtual ~DebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE HeapBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void gc(ErrorString&) = 0;
protected:
    virtual ~HeapBackendDispatcherHandler();
};

#if ENABLE(INDEXED_DATABASE)
class JS_EXPORT_PRIVATE IndexedDBBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseNamesCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseNamesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::Array<String>>&& databaseNames);
    };
    virtual void requestDatabaseNames(ErrorString&, const String& in_securityOrigin, Ref<RequestDatabaseNamesCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::IndexedDB::DatabaseWithObjectStores>&& databaseWithObjectStores);
    };
    virtual void requestDatabase(ErrorString&, const String& in_securityOrigin, const String& in_databaseName, Ref<RequestDatabaseCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE RequestDataCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDataCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::IndexedDB::DataEntry>>&& objectStoreDataEntries, bool hasMore);
    };
    virtual void requestData(ErrorString&, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, const String& in_indexName, int in_skipCount, int in_pageSize, const Inspector::InspectorObject* opt_in_keyRange, Ref<RequestDataCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE ClearObjectStoreCallback : public BackendDispatcher::CallbackBase {
    public:
        ClearObjectStoreCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void clearObjectStore(ErrorString&, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, Ref<ClearObjectStoreCallback>&& callback) = 0;
protected:
    virtual ~IndexedDBBackendDispatcherHandler();
};
#endif // ENABLE(INDEXED_DATABASE)

class JS_EXPORT_PRIVATE InspectorBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void initialized(ErrorString&) = 0;
protected:
    virtual ~InspectorBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void layersForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::LayerTree::Layer>>& out_layers) = 0;
    virtual void reasonsForCompositingLayer(ErrorString&, const String& in_layerId, RefPtr<Inspector::Protocol::LayerTree::CompositingReasons>& out_compositingReasons) = 0;
protected:
    virtual ~LayerTreeBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE NetworkBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void setExtraHTTPHeaders(ErrorString&, const Inspector::InspectorObject& in_headers) = 0;
    virtual void getResponseBody(ErrorString&, const String& in_requestId, String* out_body, bool* out_base64Encoded) = 0;
    virtual void setCacheDisabled(ErrorString&, bool in_cacheDisabled) = 0;
    class JS_EXPORT_PRIVATE LoadResourceCallback : public BackendDispatcher::CallbackBase {
    public:
        LoadResourceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& content, const String& mimeType, double status);
    };
    virtual void loadResource(ErrorString&, const String& in_frameId, const String& in_url, Ref<LoadResourceCallback>&& callback) = 0;
protected:
    virtual ~NetworkBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE PageBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void addScriptToEvaluateOnLoad(ErrorString&, const String& in_scriptSource, String* out_identifier) = 0;
    virtual void removeScriptToEvaluateOnLoad(ErrorString&, const String& in_identifier) = 0;
    virtual void reload(ErrorString&, const bool* opt_in_ignoreCache, const String* opt_in_scriptToEvaluateOnLoad) = 0;
    virtual void navigate(ErrorString&, const String& in_url) = 0;
    virtual void getCookies(ErrorString&, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Page::Cookie>>& out_cookies) = 0;
    virtual void deleteCookie(ErrorString&, const String& in_cookieName, const String& in_url) = 0;
    virtual void getResourceTree(ErrorString&, RefPtr<Inspector::Protocol::Page::FrameResourceTree>& out_frameTree) = 0;
    virtual void getResourceContent(ErrorString&, const String& in_frameId, const String& in_url, String* out_content, bool* out_base64Encoded) = 0;
    virtual void searchInResource(ErrorString&, const String& in_frameId, const String& in_url, const String& in_query, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::GenericTypes::SearchMatch>>& out_result) = 0;
    virtual void searchInResources(ErrorString&, const String& in_text, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Page::SearchResult>>& out_result) = 0;
    virtual void setDocumentContent(ErrorString&, const String& in_frameId, const String& in_html) = 0;
    virtual void setShowPaintRects(ErrorString&, bool in_result) = 0;
    // Named after parameter 'result' while generating command/event getScriptExecutionStatus.
    enum class Result {
        Allowed = 142,
        Disabled = 6,
        Forbidden = 143,
    }; // enum class Result
    virtual void getScriptExecutionStatus(ErrorString&, PageBackendDispatcherHandler::Result* out_result) = 0;
    virtual void setScriptExecutionDisabled(ErrorString&, bool in_value) = 0;
    virtual void setTouchEmulationEnabled(ErrorString&, bool in_enabled) = 0;
    virtual void setEmulatedMedia(ErrorString&, const String& in_media) = 0;
    virtual void getCompositingBordersVisible(ErrorString&, bool* out_result) = 0;
    virtual void setCompositingBordersVisible(ErrorString&, bool in_visible) = 0;
    virtual void snapshotNode(ErrorString&, int in_nodeId, String* out_dataURL) = 0;
    // Named after parameter 'coordinateSystem' while generating command/event snapshotRect.
    enum class CoordinateSystem {
        Viewport = 90,
        Page = 91,
    }; // enum class CoordinateSystem
    virtual void snapshotRect(ErrorString&, int in_x, int in_y, int in_width, int in_height, const String& in_coordinateSystem, String* out_dataURL) = 0;
    virtual void handleJavaScriptDialog(ErrorString&, bool in_accept, const String* opt_in_promptText) = 0;
    virtual void archive(ErrorString&, String* out_data) = 0;
protected:
    virtual ~PageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcherHandler {
public:
    // Named after parameter 'result' while generating command/event parse.
    enum class Result {
        None = 106,
        Irrecoverable = 107,
        UnterminatedLiteral = 108,
        Recoverable = 109,
    }; // enum class Result
    virtual void parse(ErrorString&, const String& in_source, Inspector::Protocol::Runtime::SyntaxErrorType* out_result, Inspector::Protocol::OptOutput<String>* opt_out_message, RefPtr<Inspector::Protocol::Runtime::ErrorRange>& opt_out_range) = 0;
    virtual void evaluate(ErrorString&, const String& in_expression, const String* opt_in_objectGroup, const bool* opt_in_includeCommandLineAPI, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const int* opt_in_contextId, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_saveResult, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Inspector::Protocol::OptOutput<bool>* opt_out_wasThrown, Inspector::Protocol::OptOutput<int>* opt_out_savedResultIndex) = 0;
    virtual void callFunctionOn(ErrorString&, const String& in_objectId, const String& in_functionDeclaration, const Inspector::InspectorArray* opt_in_arguments, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Inspector::Protocol::OptOutput<bool>* opt_out_wasThrown) = 0;
    virtual void getProperties(ErrorString&, const String& in_objectId, const bool* opt_in_ownProperties, const bool* opt_in_generatePreview, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::PropertyDescriptor>>& out_result, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::InternalPropertyDescriptor>>& opt_out_internalProperties) = 0;
    virtual void getDisplayableProperties(ErrorString&, const String& in_objectId, const bool* opt_in_generatePreview, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::PropertyDescriptor>>& out_properties, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::InternalPropertyDescriptor>>& opt_out_internalProperties) = 0;
    virtual void getCollectionEntries(ErrorString&, const String& in_objectId, const String* opt_in_objectGroup, const int* opt_in_startIndex, const int* opt_in_numberToFetch, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::CollectionEntry>>& out_entries) = 0;
    virtual void saveResult(ErrorString&, const Inspector::InspectorObject& in_value, const int* opt_in_contextId, Inspector::Protocol::OptOutput<int>* opt_out_savedResultIndex) = 0;
    virtual void releaseObject(ErrorString&, const String& in_objectId) = 0;
    virtual void releaseObjectGroup(ErrorString&, const String& in_objectGroup) = 0;
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getRuntimeTypesForVariablesAtOffsets(ErrorString&, const Inspector::InspectorArray& in_locations, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::TypeDescription>>& out_types) = 0;
    virtual void enableTypeProfiler(ErrorString&) = 0;
    virtual void disableTypeProfiler(ErrorString&) = 0;
    virtual void getBasicBlocks(ErrorString&, const String& in_sourceID, RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::BasicBlock>>& out_basicBlocks) = 0;
protected:
    virtual ~RuntimeBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcherHandler {
public:
    virtual void startTracking(ErrorString&, const bool* opt_in_includeSamples) = 0;
    virtual void stopTracking(ErrorString&) = 0;
protected:
    virtual ~ScriptProfilerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcherHandler {
public:
    virtual void start(ErrorString&, const int* opt_in_maxCallStackDepth) = 0;
    virtual void stop(ErrorString&) = 0;
protected:
    virtual ~TimelineBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ApplicationCacheBackendDispatcher> create(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void getFramesWithManifests(long requestId, RefPtr<InspectorObject>&& parameters);
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void getManifestForFrame(long requestId, RefPtr<InspectorObject>&& parameters);
    void getApplicationCacheForFrame(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    ApplicationCacheBackendDispatcher(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    ApplicationCacheBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateApplicationCacheBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateApplicationCacheBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE CSSBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CSSBackendDispatcher> create(BackendDispatcher&, CSSBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void getMatchedStylesForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getInlineStylesForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getComputedStyleForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getAllStyleSheets(long requestId, RefPtr<InspectorObject>&& parameters);
    void getStyleSheet(long requestId, RefPtr<InspectorObject>&& parameters);
    void getStyleSheetText(long requestId, RefPtr<InspectorObject>&& parameters);
    void setStyleSheetText(long requestId, RefPtr<InspectorObject>&& parameters);
    void setStyleText(long requestId, RefPtr<InspectorObject>&& parameters);
    void setRuleSelector(long requestId, RefPtr<InspectorObject>&& parameters);
    void createStyleSheet(long requestId, RefPtr<InspectorObject>&& parameters);
    void addRule(long requestId, RefPtr<InspectorObject>&& parameters);
    void getSupportedCSSProperties(long requestId, RefPtr<InspectorObject>&& parameters);
    void getSupportedSystemFontFamilyNames(long requestId, RefPtr<InspectorObject>&& parameters);
    void forcePseudoState(long requestId, RefPtr<InspectorObject>&& parameters);
    void getNamedFlowCollection(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    CSSBackendDispatcher(BackendDispatcher&, CSSBackendDispatcherHandler*);
    CSSBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCSSBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCSSBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ConsoleBackendDispatcher> create(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void clearMessages(long requestId, RefPtr<InspectorObject>&& parameters);
    void setMonitoringXHREnabled(long requestId, RefPtr<InspectorObject>&& parameters);
    void addInspectedNode(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    ConsoleBackendDispatcher(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    ConsoleBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateConsoleBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateConsoleBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE DOMBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMBackendDispatcher> create(BackendDispatcher&, DOMBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void getDocument(long requestId, RefPtr<InspectorObject>&& parameters);
    void requestChildNodes(long requestId, RefPtr<InspectorObject>&& parameters);
    void querySelector(long requestId, RefPtr<InspectorObject>&& parameters);
    void querySelectorAll(long requestId, RefPtr<InspectorObject>&& parameters);
    void setNodeName(long requestId, RefPtr<InspectorObject>&& parameters);
    void setNodeValue(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void setAttributeValue(long requestId, RefPtr<InspectorObject>&& parameters);
    void setAttributesAsText(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeAttribute(long requestId, RefPtr<InspectorObject>&& parameters);
    void getEventListenersForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getAccessibilityPropertiesForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getOuterHTML(long requestId, RefPtr<InspectorObject>&& parameters);
    void setOuterHTML(long requestId, RefPtr<InspectorObject>&& parameters);
    void performSearch(long requestId, RefPtr<InspectorObject>&& parameters);
    void getSearchResults(long requestId, RefPtr<InspectorObject>&& parameters);
    void discardSearchResults(long requestId, RefPtr<InspectorObject>&& parameters);
    void requestNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void setInspectModeEnabled(long requestId, RefPtr<InspectorObject>&& parameters);
    void highlightRect(long requestId, RefPtr<InspectorObject>&& parameters);
    void highlightQuad(long requestId, RefPtr<InspectorObject>&& parameters);
    void highlightSelector(long requestId, RefPtr<InspectorObject>&& parameters);
    void highlightNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void hideHighlight(long requestId, RefPtr<InspectorObject>&& parameters);
    void highlightFrame(long requestId, RefPtr<InspectorObject>&& parameters);
    void pushNodeByPathToFrontend(long requestId, RefPtr<InspectorObject>&& parameters);
    void pushNodeByBackendIdToFrontend(long requestId, RefPtr<InspectorObject>&& parameters);
    void releaseBackendNodeIds(long requestId, RefPtr<InspectorObject>&& parameters);
    void resolveNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void getAttributes(long requestId, RefPtr<InspectorObject>&& parameters);
    void moveTo(long requestId, RefPtr<InspectorObject>&& parameters);
    void undo(long requestId, RefPtr<InspectorObject>&& parameters);
    void redo(long requestId, RefPtr<InspectorObject>&& parameters);
    void markUndoableState(long requestId, RefPtr<InspectorObject>&& parameters);
    void focus(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    DOMBackendDispatcher(BackendDispatcher&, DOMBackendDispatcherHandler*);
    DOMBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMDebuggerBackendDispatcher> create(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void setDOMBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeDOMBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void setEventListenerBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeEventListenerBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void setInstrumentationBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeInstrumentationBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void setXHRBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeXHRBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    DOMDebuggerBackendDispatcher(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    DOMDebuggerBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMDebuggerBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMStorageBackendDispatcher> create(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void getDOMStorageItems(long requestId, RefPtr<InspectorObject>&& parameters);
    void setDOMStorageItem(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeDOMStorageItem(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    DOMStorageBackendDispatcher(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    DOMStorageBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMStorageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMStorageBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DatabaseBackendDispatcher> create(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void getDatabaseTableNames(long requestId, RefPtr<InspectorObject>&& parameters);
    void executeSQL(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    DatabaseBackendDispatcher(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    DatabaseBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDatabaseBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDatabaseBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DebuggerBackendDispatcher> create(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void setBreakpointsActive(long requestId, RefPtr<InspectorObject>&& parameters);
    void setBreakpointByUrl(long requestId, RefPtr<InspectorObject>&& parameters);
    void setBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeBreakpoint(long requestId, RefPtr<InspectorObject>&& parameters);
    void continueToLocation(long requestId, RefPtr<InspectorObject>&& parameters);
    void stepOver(long requestId, RefPtr<InspectorObject>&& parameters);
    void stepInto(long requestId, RefPtr<InspectorObject>&& parameters);
    void stepOut(long requestId, RefPtr<InspectorObject>&& parameters);
    void pause(long requestId, RefPtr<InspectorObject>&& parameters);
    void resume(long requestId, RefPtr<InspectorObject>&& parameters);
    void searchInContent(long requestId, RefPtr<InspectorObject>&& parameters);
    void getScriptSource(long requestId, RefPtr<InspectorObject>&& parameters);
    void getFunctionDetails(long requestId, RefPtr<InspectorObject>&& parameters);
    void setPauseOnExceptions(long requestId, RefPtr<InspectorObject>&& parameters);
    void evaluateOnCallFrame(long requestId, RefPtr<InspectorObject>&& parameters);
    void setOverlayMessage(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    DebuggerBackendDispatcher(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    DebuggerBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDebuggerBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE HeapBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<HeapBackendDispatcher> create(BackendDispatcher&, HeapBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void gc(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    HeapBackendDispatcher(BackendDispatcher&, HeapBackendDispatcherHandler*);
    HeapBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateHeapBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateHeapBackendDispatcher* m_alternateDispatcher;
#endif
};

#if ENABLE(INDEXED_DATABASE)
class JS_EXPORT_PRIVATE IndexedDBBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<IndexedDBBackendDispatcher> create(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void requestDatabaseNames(long requestId, RefPtr<InspectorObject>&& parameters);
    void requestDatabase(long requestId, RefPtr<InspectorObject>&& parameters);
    void requestData(long requestId, RefPtr<InspectorObject>&& parameters);
    void clearObjectStore(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    IndexedDBBackendDispatcher(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    IndexedDBBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateIndexedDBBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateIndexedDBBackendDispatcher* m_alternateDispatcher;
#endif
};
#endif // ENABLE(INDEXED_DATABASE)

class JS_EXPORT_PRIVATE InspectorBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<InspectorBackendDispatcher> create(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void initialized(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    InspectorBackendDispatcher(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    InspectorBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateInspectorBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateInspectorBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<LayerTreeBackendDispatcher> create(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void layersForNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void reasonsForCompositingLayer(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    LayerTreeBackendDispatcher(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    LayerTreeBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateLayerTreeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateLayerTreeBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE NetworkBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<NetworkBackendDispatcher> create(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void setExtraHTTPHeaders(long requestId, RefPtr<InspectorObject>&& parameters);
    void getResponseBody(long requestId, RefPtr<InspectorObject>&& parameters);
    void setCacheDisabled(long requestId, RefPtr<InspectorObject>&& parameters);
    void loadResource(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    NetworkBackendDispatcher(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    NetworkBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateNetworkBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateNetworkBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE PageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<PageBackendDispatcher> create(BackendDispatcher&, PageBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void addScriptToEvaluateOnLoad(long requestId, RefPtr<InspectorObject>&& parameters);
    void removeScriptToEvaluateOnLoad(long requestId, RefPtr<InspectorObject>&& parameters);
    void reload(long requestId, RefPtr<InspectorObject>&& parameters);
    void navigate(long requestId, RefPtr<InspectorObject>&& parameters);
    void getCookies(long requestId, RefPtr<InspectorObject>&& parameters);
    void deleteCookie(long requestId, RefPtr<InspectorObject>&& parameters);
    void getResourceTree(long requestId, RefPtr<InspectorObject>&& parameters);
    void getResourceContent(long requestId, RefPtr<InspectorObject>&& parameters);
    void searchInResource(long requestId, RefPtr<InspectorObject>&& parameters);
    void searchInResources(long requestId, RefPtr<InspectorObject>&& parameters);
    void setDocumentContent(long requestId, RefPtr<InspectorObject>&& parameters);
    void setShowPaintRects(long requestId, RefPtr<InspectorObject>&& parameters);
    void getScriptExecutionStatus(long requestId, RefPtr<InspectorObject>&& parameters);
    void setScriptExecutionDisabled(long requestId, RefPtr<InspectorObject>&& parameters);
    void setTouchEmulationEnabled(long requestId, RefPtr<InspectorObject>&& parameters);
    void setEmulatedMedia(long requestId, RefPtr<InspectorObject>&& parameters);
    void getCompositingBordersVisible(long requestId, RefPtr<InspectorObject>&& parameters);
    void setCompositingBordersVisible(long requestId, RefPtr<InspectorObject>&& parameters);
    void snapshotNode(long requestId, RefPtr<InspectorObject>&& parameters);
    void snapshotRect(long requestId, RefPtr<InspectorObject>&& parameters);
    void handleJavaScriptDialog(long requestId, RefPtr<InspectorObject>&& parameters);
    void archive(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    PageBackendDispatcher(BackendDispatcher&, PageBackendDispatcherHandler*);
    PageBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternatePageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternatePageBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<RuntimeBackendDispatcher> create(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void parse(long requestId, RefPtr<InspectorObject>&& parameters);
    void evaluate(long requestId, RefPtr<InspectorObject>&& parameters);
    void callFunctionOn(long requestId, RefPtr<InspectorObject>&& parameters);
    void getProperties(long requestId, RefPtr<InspectorObject>&& parameters);
    void getDisplayableProperties(long requestId, RefPtr<InspectorObject>&& parameters);
    void getCollectionEntries(long requestId, RefPtr<InspectorObject>&& parameters);
    void saveResult(long requestId, RefPtr<InspectorObject>&& parameters);
    void releaseObject(long requestId, RefPtr<InspectorObject>&& parameters);
    void releaseObjectGroup(long requestId, RefPtr<InspectorObject>&& parameters);
    void enable(long requestId, RefPtr<InspectorObject>&& parameters);
    void disable(long requestId, RefPtr<InspectorObject>&& parameters);
    void getRuntimeTypesForVariablesAtOffsets(long requestId, RefPtr<InspectorObject>&& parameters);
    void enableTypeProfiler(long requestId, RefPtr<InspectorObject>&& parameters);
    void disableTypeProfiler(long requestId, RefPtr<InspectorObject>&& parameters);
    void getBasicBlocks(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    RuntimeBackendDispatcher(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    RuntimeBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateRuntimeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateRuntimeBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ScriptProfilerBackendDispatcher> create(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void startTracking(long requestId, RefPtr<InspectorObject>&& parameters);
    void stopTracking(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    ScriptProfilerBackendDispatcher(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    ScriptProfilerBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateScriptProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateScriptProfilerBackendDispatcher* m_alternateDispatcher;
#endif
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TimelineBackendDispatcher> create(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    virtual void dispatch(long requestId, const String& method, Ref<InspectorObject>&& message) override;
private:
    void start(long requestId, RefPtr<InspectorObject>&& parameters);
    void stop(long requestId, RefPtr<InspectorObject>&& parameters);
private:
    TimelineBackendDispatcher(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    TimelineBackendDispatcherHandler* m_agent;
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTimelineBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTimelineBackendDispatcher* m_alternateDispatcher;
#endif
};

} // namespace Inspector

#endif // !defined(InspectorBackendDispatchers_h)
