/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAttr.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSElement.h"
#include "URL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsAttrName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAttrSpecified(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAttrValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAttrValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAttrOwnerElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAttrIsId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAttrConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAttrConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAttrPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAttrPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAttrPrototype* ptr = new (NotNull, JSC::allocateCell<JSAttrPrototype>(vm.heap)) JSAttrPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAttrPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAttr> JSAttrConstructor;

template<> JSValue JSAttrConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSAttrConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAttr::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Attr"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAttrConstructor::s_info = { "Attr", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAttrConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAttrPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAttrConstructor) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "specified", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrSpecified), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAttrValue) } },
    { "ownerElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrOwnerElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isId", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAttrIsId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAttrPrototype::s_info = { "AttrPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAttrPrototype) };

void JSAttrPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAttrPrototypeTableValues, *this);
}

const ClassInfo JSAttr::s_info = { "Attr", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAttr) };

JSAttr::JSAttr(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Attr>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAttr::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAttrPrototype::create(vm, globalObject, JSAttrPrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSAttr::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAttr>(vm, globalObject);
}

EncodedJSValue jsAttrName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAttr*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Attr", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsAttrSpecified(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAttr*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Attr", "specified");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.specified());
    return JSValue::encode(result);
}


EncodedJSValue jsAttrValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAttr*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Attr", "value");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.value());
    return JSValue::encode(result);
}


EncodedJSValue jsAttrOwnerElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAttr*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Attr", "ownerElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.ownerElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsAttrIsId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAttr*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Attr", "isId");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.isId());
    return JSValue::encode(result);
}


EncodedJSValue jsAttrConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAttrPrototype* domObject = jsDynamicCast<JSAttrPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAttr::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAttrConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAttrPrototype* domObject = jsDynamicCast<JSAttrPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAttrValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAttr* castedThis = jsDynamicCast<JSAttr*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Attr", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSAttr::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAttrConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAttr::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAttr*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Attr@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore4AttrE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Attr* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAttr>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Attr* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAttr>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Attr@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore4AttrE[2];
#if COMPILER(CLANG)
    // If this fails Attr does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Attr), Attr_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Attr has subclasses. If Attr has subclasses that get passed
    // to toJS() we currently require Attr you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAttr>(globalObject, impl);
}

Attr* JSAttr::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAttr*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
