/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSSupportsRule.h"

#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSRuleList.h"
#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSSupportsRulePrototypeFunctionInsertRule(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSSupportsRulePrototypeFunctionDeleteRule(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCSSSupportsRuleCssRules(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSSupportsRuleConditionText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSSupportsRuleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSSupportsRulePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSSupportsRulePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSSupportsRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSSupportsRulePrototype>(vm.heap)) JSCSSSupportsRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSSupportsRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSCSSSupportsRulePrototypeTableValues[] =
{
    { "cssRules", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSSupportsRuleCssRules), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "conditionText", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSSupportsRuleConditionText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSSupportsRulePrototypeFunctionInsertRule), (intptr_t) (0) } },
    { "deleteRule", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSSupportsRulePrototypeFunctionDeleteRule), (intptr_t) (0) } },
};

const ClassInfo JSCSSSupportsRulePrototype::s_info = { "CSSSupportsRulePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSSupportsRulePrototype) };

void JSCSSSupportsRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSSupportsRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSSupportsRule::s_info = { "CSSSupportsRule", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSSupportsRule) };

JSCSSSupportsRule::JSCSSSupportsRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSSupportsRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSSupportsRule::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSSupportsRulePrototype::create(vm, globalObject, JSCSSSupportsRulePrototype::createStructure(vm, globalObject, JSCSSRule::getPrototype(vm, globalObject)));
}

JSObject* JSCSSSupportsRule::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSSupportsRule>(vm, globalObject);
}

EncodedJSValue jsCSSSupportsRuleCssRules(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSSupportsRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSSupportsRule", "cssRules");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.cssRules()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSSupportsRuleConditionText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSSupportsRule*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSSupportsRule", "conditionText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.conditionText());
    return JSValue::encode(result);
}


void setJSCSSSupportsRuleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSSupportsRulePrototype* domObject = jsDynamicCast<JSCSSSupportsRulePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

EncodedJSValue JSC_HOST_CALL jsCSSSupportsRulePrototypeFunctionInsertRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSSupportsRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSSupportsRule", "insertRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSSupportsRule::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String rule = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned index = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.insertRule(rule, index, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSSupportsRulePrototypeFunctionDeleteRule(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSSupportsRule*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSSupportsRule", "deleteRule");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSSupportsRule::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.deleteRule(index, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}


}
