/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2D.h"

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "ExceptionCode.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSCanvasPattern.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPath.h"
#include "JSElement.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageData.h"
#include "JSTextMetrics.h"
#include "TextMetrics.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCommit(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineDash(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetLineDash(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionEllipse(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitGetImageDataHD(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCanvasRenderingContext2DGlobalAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DGlobalAlpha(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DGlobalCompositeOperation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DGlobalCompositeOperation(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DLineWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineCap(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DLineCap(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineJoin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DLineJoin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DMiterLimit(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DMiterLimit(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowOffsetX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DShadowOffsetX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowOffsetY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DShadowOffsetY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowBlur(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DShadowBlur(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DShadowColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineDashOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DLineDashOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitLineDash(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DWebkitLineDash(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitLineDashOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DWebkitLineDashOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DFont(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DFont(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DTextAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DTextAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DTextBaseline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DTextBaseline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DDirection(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DDirection(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DStrokeStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DStrokeStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DFillStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DFillStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatio(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCanvasRenderingContext2DImageSmoothingEnabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DImageSmoothingEnabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DImageSmoothingQuality(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DImageSmoothingQuality(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCanvasRenderingContext2DPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCanvasRenderingContext2DPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasRenderingContext2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasRenderingContext2DPrototype>(vm.heap)) JSCanvasRenderingContext2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasRenderingContext2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCanvasRenderingContext2D> JSCanvasRenderingContext2DConstructor;

template<> JSValue JSCanvasRenderingContext2DConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasRenderingContext2DConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCanvasRenderingContext2D::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CanvasRenderingContext2D"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2D", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DConstructor) } },
    { "globalAlpha", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DGlobalAlpha) } },
    { "globalCompositeOperation", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DGlobalCompositeOperation) } },
    { "lineWidth", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineWidth) } },
    { "lineCap", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineCap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineCap) } },
    { "lineJoin", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineJoin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineJoin) } },
    { "miterLimit", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DMiterLimit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DMiterLimit) } },
    { "shadowOffsetX", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowOffsetX) } },
    { "shadowOffsetY", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowOffsetY) } },
    { "shadowBlur", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowBlur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowBlur) } },
    { "shadowColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowColor) } },
    { "lineDashOffset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineDashOffset) } },
    { "webkitLineDash", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitLineDash) } },
    { "webkitLineDashOffset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitLineDashOffset) } },
    { "font", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFont), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DFont) } },
    { "textAlign", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DTextAlign) } },
    { "textBaseline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextBaseline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DTextBaseline) } },
    { "direction", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DDirection) } },
    { "strokeStyle", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DStrokeStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DStrokeStyle) } },
    { "fillStyle", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFillStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DFillStyle) } },
    { "webkitBackingStorePixelRatio", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitBackingStorePixelRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "imageSmoothingEnabled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DImageSmoothingEnabled) } },
    { "webkitImageSmoothingEnabled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled) } },
    { "imageSmoothingQuality", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DImageSmoothingQuality), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DImageSmoothingQuality) } },
    { "save", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t) (0) } },
    { "restore", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t) (0) } },
    { "commit", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCommit), (intptr_t) (0) } },
    { "scale", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t) (2) } },
    { "rotate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t) (1) } },
    { "translate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t) (2) } },
    { "transform", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t) (6) } },
    { "setTransform", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t) (6) } },
    { "createLinearGradient", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t) (4) } },
    { "createRadialGradient", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t) (6) } },
    { "setLineDash", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineDash), (intptr_t) (1) } },
    { "getLineDash", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetLineDash), (intptr_t) (0) } },
    { "clearRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t) (4) } },
    { "fillRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t) (4) } },
    { "beginPath", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t) (0) } },
    { "closePath", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t) (0) } },
    { "moveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t) (2) } },
    { "lineTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t) (2) } },
    { "quadraticCurveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t) (4) } },
    { "bezierCurveTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t) (6) } },
    { "arcTo", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t) (5) } },
    { "rect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t) (4) } },
    { "arc", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t) (5) } },
    { "ellipse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionEllipse), (intptr_t) (7) } },
    { "fill", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t) (1) } },
    { "stroke", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t) (1) } },
    { "clip", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t) (1) } },
    { "isPointInPath", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t) (3) } },
    { "isPointInStroke", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke), (intptr_t) (3) } },
    { "measureText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMeasureText), (intptr_t) (1) } },
    { "setAlpha", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetAlpha), (intptr_t) (0) } },
    { "setCompositeOperation", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation), (intptr_t) (0) } },
    { "setLineWidth", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth), (intptr_t) (0) } },
    { "setLineCap", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineCap), (intptr_t) (0) } },
    { "setLineJoin", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin), (intptr_t) (0) } },
    { "setMiterLimit", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit), (intptr_t) (0) } },
    { "clearShadow", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearShadow), (intptr_t) (0) } },
    { "fillText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillText), (intptr_t) (3) } },
    { "strokeText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeText), (intptr_t) (3) } },
    { "setStrokeColor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor), (intptr_t) (1) } },
    { "setFillColor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetFillColor), (intptr_t) (1) } },
    { "strokeRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t) (4) } },
    { "drawImage", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t) (3) } },
    { "drawImageFromRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect), (intptr_t) (1) } },
    { "setShadow", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetShadow), (intptr_t) (3) } },
    { "putImageData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t) (3) } },
    { "webkitPutImageDataHD", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD), (intptr_t) (3) } },
    { "createPattern", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t) (2) } },
    { "createImageData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t) (1) } },
    { "getImageData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t) (4) } },
    { "webkitGetImageDataHD", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionWebkitGetImageDataHD), (intptr_t) (4) } },
    { "drawFocusIfNeeded", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded), (intptr_t) (1) } },
};

const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DPrototype) };

void JSCanvasRenderingContext2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasRenderingContext2DPrototypeTableValues, *this);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext2D) };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasRenderingContext2D>&& impl)
    : JSCanvasRenderingContext(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCanvasRenderingContext2D::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCanvasRenderingContext2DPrototype::create(vm, globalObject, JSCanvasRenderingContext2DPrototype::createStructure(vm, globalObject, JSCanvasRenderingContext::getPrototype(vm, globalObject)));
}

JSObject* JSCanvasRenderingContext2D::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(vm, globalObject);
}

EncodedJSValue jsCanvasRenderingContext2DGlobalAlpha(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "globalAlpha");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.globalAlpha());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DGlobalCompositeOperation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "globalCompositeOperation");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.globalCompositeOperation());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DLineWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "lineWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.lineWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DLineCap(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "lineCap");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.lineCap());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DLineJoin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "lineJoin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.lineJoin());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DMiterLimit(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "miterLimit");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.miterLimit());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DShadowOffsetX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "shadowOffsetX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.shadowOffsetX());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DShadowOffsetY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "shadowOffsetY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.shadowOffsetY());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DShadowBlur(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "shadowBlur");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.shadowBlur());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DShadowColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "shadowColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.shadowColor());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DLineDashOffset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "lineDashOffset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.lineDashOffset());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DWebkitLineDash(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "webkitLineDash");
    }
    return JSValue::encode(castedThis->webkitLineDash(*state));
}


EncodedJSValue jsCanvasRenderingContext2DWebkitLineDashOffset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "webkitLineDashOffset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitLineDashOffset());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DFont(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "font");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.font());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DTextAlign(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "textAlign");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.textAlign());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DTextBaseline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "textBaseline");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.textBaseline());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DDirection(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "direction");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.direction());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DStrokeStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "strokeStyle");
    }
    return JSValue::encode(castedThis->strokeStyle(*state));
}


EncodedJSValue jsCanvasRenderingContext2DFillStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "fillStyle");
    }
    return JSValue::encode(castedThis->fillStyle(*state));
}


EncodedJSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatio(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "webkitBackingStorePixelRatio");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitBackingStorePixelRatio());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DImageSmoothingEnabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "imageSmoothingEnabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.imageSmoothingEnabled());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "webkitImageSmoothingEnabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.imageSmoothingEnabled());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DImageSmoothingQuality(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext2D", "imageSmoothingQuality");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.imageSmoothingQuality());
    return JSValue::encode(result);
}


EncodedJSValue jsCanvasRenderingContext2DConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCanvasRenderingContext2DPrototype* domObject = jsDynamicCast<JSCanvasRenderingContext2DPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCanvasRenderingContext2D::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCanvasRenderingContext2DConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCanvasRenderingContext2DPrototype* domObject = jsDynamicCast<JSCanvasRenderingContext2DPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCanvasRenderingContext2DGlobalAlpha(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "globalAlpha");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setGlobalAlpha(nativeValue);
}


void setJSCanvasRenderingContext2DGlobalCompositeOperation(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "globalCompositeOperation");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setGlobalCompositeOperation(nativeValue);
}


void setJSCanvasRenderingContext2DLineWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "lineWidth");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLineWidth(nativeValue);
}


void setJSCanvasRenderingContext2DLineCap(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "lineCap");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLineCap(nativeValue);
}


void setJSCanvasRenderingContext2DLineJoin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "lineJoin");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLineJoin(nativeValue);
}


void setJSCanvasRenderingContext2DMiterLimit(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "miterLimit");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMiterLimit(nativeValue);
}


void setJSCanvasRenderingContext2DShadowOffsetX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "shadowOffsetX");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setShadowOffsetX(nativeValue);
}


void setJSCanvasRenderingContext2DShadowOffsetY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "shadowOffsetY");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setShadowOffsetY(nativeValue);
}


void setJSCanvasRenderingContext2DShadowBlur(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "shadowBlur");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setShadowBlur(nativeValue);
}


void setJSCanvasRenderingContext2DShadowColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "shadowColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setShadowColor(nativeValue);
}


void setJSCanvasRenderingContext2DLineDashOffset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "lineDashOffset");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLineDashOffset(nativeValue);
}


void setJSCanvasRenderingContext2DWebkitLineDash(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "webkitLineDash");
        return;
    }
    castedThis->setWebkitLineDash(*state, value);
}


void setJSCanvasRenderingContext2DWebkitLineDashOffset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "webkitLineDashOffset");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWebkitLineDashOffset(nativeValue);
}


void setJSCanvasRenderingContext2DFont(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "font");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setFont(nativeValue);
}


void setJSCanvasRenderingContext2DTextAlign(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "textAlign");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTextAlign(nativeValue);
}


void setJSCanvasRenderingContext2DTextBaseline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "textBaseline");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTextBaseline(nativeValue);
}


void setJSCanvasRenderingContext2DDirection(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "direction");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDirection(nativeValue);
}


void setJSCanvasRenderingContext2DStrokeStyle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "strokeStyle");
        return;
    }
    castedThis->setStrokeStyle(*state, value);
}


void setJSCanvasRenderingContext2DFillStyle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "fillStyle");
        return;
    }
    castedThis->setFillStyle(*state, value);
}


void setJSCanvasRenderingContext2DImageSmoothingEnabled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "imageSmoothingEnabled");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setImageSmoothingEnabled(nativeValue);
}


void setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "webkitImageSmoothingEnabled");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setImageSmoothingEnabled(nativeValue);
}


void setJSCanvasRenderingContext2DImageSmoothingQuality(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCanvasRenderingContext2D* castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CanvasRenderingContext2D", "imageSmoothingQuality");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (nativeValue != "low" && nativeValue != "medium" && nativeValue != "high")
        return;
    impl.setImageSmoothingQuality(nativeValue);
}


JSValue JSCanvasRenderingContext2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "save");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "restore");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCommit(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "commit");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    return JSValue::encode(castedThis->commit(*state));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "scale");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float sx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.scale(sx, sy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "rotate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.rotate(angle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "translate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float tx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float ty = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.translate(tx, ty);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "transform");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 6))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float m11 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m12 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m21 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m22 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dy = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.transform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setTransform");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 6))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float m11 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m12 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m21 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m22 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dy = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setTransform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createLinearGradient");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x0 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x0)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y0 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y0)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float x1 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y1 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createLinearGradient(x0, y0, x1, y1, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createRadialGradient");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 6))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x0 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x0)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y0 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y0)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float r0 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(r0)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float x1 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(x1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float y1 = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(y1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float r1 = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(r1)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createRadialGradient(x0, y0, r0, x1, y1, r1, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineDash(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setLineDash");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Vector<float> dash = toNativeArray<float>(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setLineDash(dash);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetLineDash(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "getLineDash");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.getLineDash());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "clearRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.clearRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "fillRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.fillRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "beginPath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "closePath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "moveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.moveTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "lineTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.lineTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "quadraticCurveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float cpx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cpy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.quadraticCurveTo(cpx, cpy, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "bezierCurveTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 6))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float cp1x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cp1y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cp2x = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cp2y = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "arcTo");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x1 = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y1 = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x2 = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y2 = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radius = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "rect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.rect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "arc");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radius = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float startAngle = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float endAngle = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool anticlockwise = state->argument(5).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionEllipse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "ellipse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 7))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radiusX = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float radiusY = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float rotation = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float startAngle = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float endAngle = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool anticlockwise = state->argument(7).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "fill");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.fill(path);
        return JSValue::encode(jsUndefined());
    }

    String winding;
    if (state->argument(1).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(1).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 1, "winding", "CanvasRenderingContext2D", "fill", "\"nonzero\", \"evenodd\"");
    }
    impl.fill(path, winding);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "stroke");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.stroke(path);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "clip");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.clip(path);
        return JSValue::encode(jsUndefined());
    }

    String winding;
    if (state->argument(1).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(1).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 1, "winding", "CanvasRenderingContext2D", "clip", "\"nonzero\", \"evenodd\"");
    }
    impl.clip(path, winding);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "fill");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.fill();
        return JSValue::encode(jsUndefined());
    }

    String winding;
    if (state->argument(0).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(0).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 0, "winding", "CanvasRenderingContext2D", "fill", "\"nonzero\", \"evenodd\"");
    }
    impl.fill(winding);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))) || (argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionFill1(state);
    if (argsCount == 0 || argsCount == 1)
        return jsCanvasRenderingContext2DPrototypeFunctionFill2(state);
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "stroke");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.stroke();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* state)
{
    size_t argsCount = std::min<size_t>(1, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionStroke1(state);
    if (argsCount == 0)
        return jsCanvasRenderingContext2DPrototypeFunctionStroke2(state);
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "clip");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.clip();
        return JSValue::encode(jsUndefined());
    }

    String winding;
    if (state->argument(0).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(0).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 0, "winding", "CanvasRenderingContext2D", "clip", "\"nonzero\", \"evenodd\"");
    }
    impl.clip(winding);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))) || (argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionClip1(state);
    if (argsCount == 0 || argsCount == 1)
        return jsCanvasRenderingContext2DPrototypeFunctionClip2(state);
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "isPointInPath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 3) {
        JSValue result = jsBoolean(impl.isPointInPath(path, x, y));
        return JSValue::encode(result);
    }

    String winding;
    if (state->argument(3).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(3).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 3, "winding", "CanvasRenderingContext2D", "isPointInPath", "\"nonzero\", \"evenodd\"");
    }
    JSValue result = jsBoolean(impl.isPointInPath(path, x, y, winding));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "isPointInStroke");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isPointInStroke(path, x, y));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "isPointInPath");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 2) {
        JSValue result = jsBoolean(impl.isPointInPath(x, y));
        return JSValue::encode(result);
    }

    String winding;
    if (state->argument(2).isUndefined())
        winding = ASCIILiteral("nonzero");
    else {
        winding = state->uncheckedArgument(2).toString(state)->value(state);
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        if (winding != "nonzero" && winding != "evenodd")
            return throwArgumentMustBeEnumError(*state, 2, "winding", "CanvasRenderingContext2D", "isPointInPath", "\"nonzero\", \"evenodd\"");
    }
    JSValue result = jsBoolean(impl.isPointInPath(x, y, winding));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* state)
{
    size_t argsCount = std::min<size_t>(4, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 3 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))) || (argsCount == 4 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1(state);
    if (argsCount == 2 || argsCount == 3)
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath2(state);
    if (argsCount < 2)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "isPointInStroke");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isPointInStroke(x, y));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(ExecState* state)
{
    size_t argsCount = std::min<size_t>(3, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 3 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1(state);
    if (argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2(state);
    if (argsCount < 2)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "measureText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String text = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.measureText(text)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setAlpha");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    float alpha = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setAlpha(alpha);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setCompositeOperation");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    String compositeOperation = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setCompositeOperation(compositeOperation);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setLineWidth");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    float width = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setLineWidth(width);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setLineCap");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    String cap = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setLineCap(cap);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setLineJoin");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    String join = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setLineJoin(join);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setMiterLimit");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    float limit = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setMiterLimit(limit);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "clearShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    impl.clearShadow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "fillText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String text = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 3) {
        impl.fillText(text, x, y);
        return JSValue::encode(jsUndefined());
    }

    float maxWidth = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.fillText(text, x, y, maxWidth);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "strokeText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String text = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 3) {
        impl.strokeText(text, x, y);
        return JSValue::encode(jsUndefined());
    }

    float maxWidth = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.strokeText(text, x, y, maxWidth);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setStrokeColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String color = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.setStrokeColor(color);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStrokeColor(color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setStrokeColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float grayLevel = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.setStrokeColor(grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(alpha)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.setStrokeColor(grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setStrokeColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float r = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float g = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float b = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStrokeColor(r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setStrokeColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float c = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float k = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStrokeColor(c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* state)
{
    size_t argsCount = std::min<size_t>(5, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())) || (argsCount == 2 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1(state);
    if (argsCount == 1 || argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2(state);
    if (argsCount == 4)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3(state);
    if (argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setFillColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String color = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.setFillColor(color);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setFillColor(color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setFillColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float grayLevel = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.setFillColor(grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setFillColor(grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setFillColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float r = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float g = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float b = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setFillColor(r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setFillColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float c = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float k = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setFillColor(c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* state)
{
    size_t argsCount = std::min<size_t>(5, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())) || (argsCount == 2 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1(state);
    if (argsCount == 1 || argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2(state);
    if (argsCount == 4)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3(state);
    if (argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "strokeRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.strokeRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLImageElement* image = JSHTMLImageElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(image, x, y, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLImageElement* image = JSHTMLImageElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(image, x, y, width, height, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage3(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 9))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLImageElement* image = JSHTMLImageElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sw = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sh = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dy = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dw = state->argument(7).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dh = state->argument(8).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage4(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas = JSHTMLCanvasElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(canvas, x, y, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage5(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas = JSHTMLCanvasElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(canvas, x, y, width, height, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage6(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 9))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas = JSHTMLCanvasElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sw = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sh = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dy = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dw = state->argument(7).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dh = state->argument(8).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(canvas, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage7(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLVideoElement* video = JSHTMLVideoElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(video, x, y, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage8(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 5))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLVideoElement* video = JSHTMLVideoElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float x = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float width = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(video, x, y, width, height, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage9(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 9))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLVideoElement* video = JSHTMLVideoElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sw = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sh = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dy = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dw = state->argument(7).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dh = state->argument(8).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImage(video, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* state)
{
    size_t argsCount = std::min<size_t>(9, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLImageElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage1(state);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLImageElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage2(state);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLImageElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage3(state);
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLCanvasElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage4(state);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLCanvasElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage5(state);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLCanvasElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage6(state);
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLVideoElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage7(state);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLVideoElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage8(state);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLVideoElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage9(state);
    if (argsCount < 3)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawImageFromRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    HTMLImageElement* image = JSHTMLImageElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.drawImageFromRect(image);
        return JSValue::encode(jsUndefined());
    }

    float sx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        impl.drawImageFromRect(image, sx);
        return JSValue::encode(jsUndefined());
    }

    float sy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 3) {
        impl.drawImageFromRect(image, sx, sy);
        return JSValue::encode(jsUndefined());
    }

    float sw = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 4) {
        impl.drawImageFromRect(image, sx, sy, sw);
        return JSValue::encode(jsUndefined());
    }

    float sh = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 5) {
        impl.drawImageFromRect(image, sx, sy, sw, sh);
        return JSValue::encode(jsUndefined());
    }

    float dx = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 6) {
        impl.drawImageFromRect(image, sx, sy, sw, sh, dx);
        return JSValue::encode(jsUndefined());
    }

    float dy = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 7) {
        impl.drawImageFromRect(image, sx, sy, sw, sh, dx, dy);
        return JSValue::encode(jsUndefined());
    }

    float dw = state->argument(7).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 8) {
        impl.drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw);
        return JSValue::encode(jsUndefined());
    }

    float dh = state->argument(8).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 9) {
        impl.drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw, dh);
        return JSValue::encode(jsUndefined());
    }

    String compositeOperation = state->argument(9).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw, dh, compositeOperation);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float width = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float blur = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 3) {
        impl.setShadow(width, height, blur);
        return JSValue::encode(jsUndefined());
    }

    String color = state->argument(3).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 4) {
        impl.setShadow(width, height, blur, color);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setShadow(width, height, blur, color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float width = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float blur = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float grayLevel = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 4) {
        impl.setShadow(width, height, blur, grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setShadow(width, height, blur, grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow3(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 7))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float width = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float height = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float blur = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float r = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float g = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float b = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setShadow(width, height, blur, r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow4(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "setShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 8))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float width = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(width)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float height = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float blur = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float c = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float m = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float k = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float a = state->argument(7).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setShadow(width, height, blur, c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* state)
{
    size_t argsCount = std::min<size_t>(8, state->argumentCount());
    JSValue arg3(state->argument(3));
    if (argsCount == 3 || (argsCount == 4 && (arg3.isUndefinedOrNull() || arg3.isString() || arg3.isObject())) || (argsCount == 5 && (arg3.isUndefinedOrNull() || arg3.isString() || arg3.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1(state);
    if (argsCount == 4 || argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow2(state);
    if (argsCount == 7)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow3(state);
    if (argsCount == 8)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow4(state);
    if (argsCount < 3)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "putImageData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ImageData* imagedata = JSImageData::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.putImageData(imagedata, dx, dy, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "putImageData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 7))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ImageData* imagedata = JSImageData::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyX = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyX)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyY = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyY)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyWidth = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyWidth)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyHeight = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyHeight)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.putImageData(imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* state)
{
    size_t argsCount = std::min<size_t>(7, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSImageData::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData1(state);
    if ((argsCount == 7 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSImageData::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData2(state);
    if (argsCount < 3)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "webkitPutImageDataHD");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ImageData* imagedata = JSImageData::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.webkitPutImageDataHD(imagedata, dx, dy, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "webkitPutImageDataHD");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 7))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ImageData* imagedata = JSImageData::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float dx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyX = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyX)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyY = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyY)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyWidth = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyWidth)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float dirtyHeight = state->argument(6).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(dirtyHeight)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    impl.webkitPutImageDataHD(imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD(ExecState* state)
{
    size_t argsCount = std::min<size_t>(7, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSImageData::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD1(state);
    if ((argsCount == 7 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSImageData::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD2(state);
    if (argsCount < 3)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createPattern");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas = JSHTMLCanvasElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String repetitionType = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createPattern(canvas, repetitionType, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createPattern");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLImageElement* image = JSHTMLImageElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String repetitionType = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createPattern(image, repetitionType, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLCanvasElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreatePattern1(state);
    if ((argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSHTMLImageElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreatePattern2(state);
    if (argsCount < 2)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createImageData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    ImageData* imagedata = JSImageData::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createImageData(imagedata, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "createImageData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float sw = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sw)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sh = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sh)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createImageData(sw, sh, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(JSImageData::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1(state);
    if (argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "getImageData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float sx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sw = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sw)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sh = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sh)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getImageData(sx, sy, sw, sh, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitGetImageDataHD(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "webkitGetImageDataHD");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float sx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sx)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sy)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sw = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sw)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    float sh = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!std::isfinite(sh)) {
        setDOMException(state, TypeError);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.webkitGetImageDataHD(sx, sy, sw, sh, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawFocusIfNeeded");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Element* element = JSElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawFocusIfNeeded(element);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCanvasRenderingContext2D*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CanvasRenderingContext2D", "drawFocusIfNeeded");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCanvasRenderingContext2D::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    DOMPath* path = JSDOMPath::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Element* element = JSElement::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.drawFocusIfNeeded(path, element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded1(state);
    JSValue arg1(state->argument(1));
    if ((argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSDOMPath::info()))) && ((arg1.isObject() && asObject(arg1)->inherits(JSElement::info())))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}


}
