/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCharacterData.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSElement.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(SHADOW_DOM)
#include "HTMLSlotElement.h"
#include "JSHTMLSlotElement.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionSubstringData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionAppendData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionInsertData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionDeleteData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionReplaceData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionAfter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionReplaceWith(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionRemove(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCharacterDataData(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCharacterDataData(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCharacterDataLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCharacterDataPreviousElementSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCharacterDataNextElementSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue jsCharacterDataAssignedSlot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsCharacterDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCharacterDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCharacterDataPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCharacterDataPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCharacterDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSCharacterDataPrototype>(vm.heap)) JSCharacterDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCharacterDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCharacterData> JSCharacterDataConstructor;

template<> JSValue JSCharacterDataConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSCharacterDataConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCharacterData::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CharacterData"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCharacterDataConstructor::s_info = { "CharacterData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCharacterDataConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCharacterDataPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCharacterDataConstructor) } },
    { "data", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCharacterDataData) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousElementSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataPreviousElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextElementSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataNextElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(SHADOW_DOM)
    { "assignedSlot", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCharacterDataAssignedSlot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "substringData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionSubstringData), (intptr_t) (2) } },
    { "appendData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionAppendData), (intptr_t) (1) } },
    { "insertData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionInsertData), (intptr_t) (2) } },
    { "deleteData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionDeleteData), (intptr_t) (2) } },
    { "replaceData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionReplaceData), (intptr_t) (3) } },
    { "before", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionBefore), (intptr_t) (0) } },
    { "after", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionAfter), (intptr_t) (0) } },
    { "replaceWith", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionReplaceWith), (intptr_t) (0) } },
    { "remove", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCharacterDataPrototypeFunctionRemove), (intptr_t) (0) } },
};

const ClassInfo JSCharacterDataPrototype::s_info = { "CharacterDataPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCharacterDataPrototype) };

void JSCharacterDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCharacterDataPrototypeTableValues, *this);
}

const ClassInfo JSCharacterData::s_info = { "CharacterData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCharacterData) };

JSCharacterData::JSCharacterData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CharacterData>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCharacterData::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCharacterDataPrototype::create(vm, globalObject, JSCharacterDataPrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSCharacterData::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCharacterData>(vm, globalObject);
}

EncodedJSValue jsCharacterDataData(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCharacterData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CharacterData", "data");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.data());
    return JSValue::encode(result);
}


EncodedJSValue jsCharacterDataLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCharacterData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CharacterData", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsCharacterDataPreviousElementSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCharacterData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CharacterData", "previousElementSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousElementSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsCharacterDataNextElementSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCharacterData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CharacterData", "nextElementSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextElementSibling()));
    return JSValue::encode(result);
}


#if ENABLE(SHADOW_DOM)
EncodedJSValue jsCharacterDataAssignedSlot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCharacterData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CharacterData", "assignedSlot");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.assignedSlot()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsCharacterDataConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCharacterDataPrototype* domObject = jsDynamicCast<JSCharacterDataPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCharacterData::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCharacterDataConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCharacterDataPrototype* domObject = jsDynamicCast<JSCharacterDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCharacterDataData(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCharacterData* castedThis = jsDynamicCast<JSCharacterData*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CharacterData", "data");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setData(nativeValue);
}


JSValue JSCharacterData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCharacterDataConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionSubstringData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "substringData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned offset = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned length = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.substringData(offset, length, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionAppendData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "appendData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String data = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.appendData(data);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionInsertData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "insertData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned offset = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String data = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.insertData(offset, data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionDeleteData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "deleteData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned offset = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned length = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.deleteData(offset, length, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionReplaceData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "replaceData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned offset = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned length = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String data = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.replaceData(offset, length, data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "before");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    return JSValue::encode(castedThis->before(*state));
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionAfter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "after");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    return JSValue::encode(castedThis->after(*state));
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionReplaceWith(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "replaceWith");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    return JSValue::encode(castedThis->replaceWith(*state));
}

EncodedJSValue JSC_HOST_CALL jsCharacterDataPrototypeFunctionRemove(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCharacterData*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CharacterData", "remove");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCharacterData::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.remove(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSCharacterData::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCharacterData*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
