/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCounter.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCounterIdentifier(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCounterListStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCounterSeparator(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCounterConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCounterConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCounterPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCounterPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCounterPrototype* ptr = new (NotNull, JSC::allocateCell<JSCounterPrototype>(vm.heap)) JSCounterPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCounterPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCounter> JSCounterConstructor;

template<> JSValue JSCounterConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCounterConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCounter::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Counter"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCounterConstructor::s_info = { "Counter", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCounterConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCounterPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCounterConstructor) } },
    { "identifier", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "listStyle", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterListStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "separator", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCounterSeparator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSCounterPrototype::s_info = { "CounterPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCounterPrototype) };

void JSCounterPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCounterPrototypeTableValues, *this);
}

const ClassInfo JSCounter::s_info = { "Counter", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCounter) };

JSCounter::JSCounter(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Counter>&& impl)
    : JSDOMWrapper<Counter>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCounter::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCounterPrototype::create(vm, globalObject, JSCounterPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCounter::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCounter>(vm, globalObject);
}

void JSCounter::destroy(JSC::JSCell* cell)
{
    JSCounter* thisObject = static_cast<JSCounter*>(cell);
    thisObject->JSCounter::~JSCounter();
}

EncodedJSValue jsCounterIdentifier(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCounter*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Counter", "identifier");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.identifier());
    return JSValue::encode(result);
}


EncodedJSValue jsCounterListStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCounter*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Counter", "listStyle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.listStyle());
    return JSValue::encode(result);
}


EncodedJSValue jsCounterSeparator(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCounter*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Counter", "separator");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.separator());
    return JSValue::encode(result);
}


EncodedJSValue jsCounterConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCounterPrototype* domObject = jsDynamicCast<JSCounterPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCounter::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCounterConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCounterPrototype* domObject = jsDynamicCast<JSCounterPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCounter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCounterConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSCounterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSCounterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCounter = jsCast<JSCounter*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCounter->wrapped(), jsCounter);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Counter* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCounter>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Counter* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCounter>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Counter.
    COMPILE_ASSERT(!__is_polymorphic(Counter), Counter_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSCounter>(globalObject, impl);
}

Counter* JSCounter::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCounter*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
