/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileReaderSync.h"

#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsArrayBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsBinaryString(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsDataURL(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsFileReaderSyncConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFileReaderSyncConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFileReaderSyncPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFileReaderSyncPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileReaderSyncPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileReaderSyncPrototype>(vm.heap)) JSFileReaderSyncPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileReaderSyncPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSFileReaderSync> JSFileReaderSyncConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSFileReaderSyncConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSFileReaderSyncConstructor*>(state->callee());
    RefPtr<FileReaderSync> object = FileReaderSync::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSFileReaderSyncConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileReaderSyncConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFileReaderSync::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("FileReaderSync"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSFileReaderSyncConstructor::s_info = { "FileReaderSync", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFileReaderSyncConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFileReaderSyncPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderSyncConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileReaderSyncConstructor) } },
    { "readAsArrayBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsArrayBuffer), (intptr_t) (1) } },
    { "readAsBinaryString", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsBinaryString), (intptr_t) (1) } },
    { "readAsText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsText), (intptr_t) (1) } },
    { "readAsDataURL", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFileReaderSyncPrototypeFunctionReadAsDataURL), (intptr_t) (1) } },
};

const ClassInfo JSFileReaderSyncPrototype::s_info = { "FileReaderSyncPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFileReaderSyncPrototype) };

void JSFileReaderSyncPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileReaderSyncPrototypeTableValues, *this);
}

const ClassInfo JSFileReaderSync::s_info = { "FileReaderSync", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFileReaderSync) };

JSFileReaderSync::JSFileReaderSync(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileReaderSync>&& impl)
    : JSDOMWrapper<FileReaderSync>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFileReaderSync::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFileReaderSyncPrototype::create(vm, globalObject, JSFileReaderSyncPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSFileReaderSync::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileReaderSync>(vm, globalObject);
}

void JSFileReaderSync::destroy(JSC::JSCell* cell)
{
    JSFileReaderSync* thisObject = static_cast<JSFileReaderSync*>(cell);
    thisObject->JSFileReaderSync::~JSFileReaderSync();
}

EncodedJSValue jsFileReaderSyncConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFileReaderSyncPrototype* domObject = jsDynamicCast<JSFileReaderSyncPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFileReaderSync::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFileReaderSyncConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFileReaderSyncPrototype* domObject = jsDynamicCast<JSFileReaderSyncPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSFileReaderSync::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileReaderSyncConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsArrayBuffer(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFileReaderSync*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FileReaderSync", "readAsArrayBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFileReaderSync::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.readAsArrayBuffer(scriptContext, blob, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsBinaryString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFileReaderSync*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FileReaderSync", "readAsBinaryString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFileReaderSync::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.readAsBinaryString(scriptContext, blob, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFileReaderSync*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FileReaderSync", "readAsText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFileReaderSync::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = jsStringWithCache(state, impl.readAsText(scriptContext, blob, ec));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String encoding = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.readAsText(scriptContext, blob, encoding, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileReaderSyncPrototypeFunctionReadAsDataURL(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFileReaderSync*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FileReaderSync", "readAsDataURL");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFileReaderSync::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob = JSBlob::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.readAsDataURL(scriptContext, blob, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSFileReaderSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileReaderSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileReaderSync = jsCast<JSFileReaderSync*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileReaderSync->wrapped(), jsFileReaderSync);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileReaderSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14FileReaderSyncE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, FileReaderSync* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFileReaderSync>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, FileReaderSync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFileReaderSync>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FileReaderSync@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14FileReaderSyncE[2];
#if COMPILER(CLANG)
    // If this fails FileReaderSync does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FileReaderSync), FileReaderSync_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FileReaderSync has subclasses. If FileReaderSync has subclasses that get passed
    // to toJS() we currently require FileReaderSync you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSFileReaderSync>(globalObject, impl);
}

FileReaderSync* JSFileReaderSync::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileReaderSync*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
