/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFaceSet.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "FontFaceSet.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPromise.h"
#include "JSEventListener.h"
#include "JSFontFace.h"
#include "JSFontFaceSet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionEntries(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionHas(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionKeys(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionValues(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionAdd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionDelete(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionLoad(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionCheck(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsFontFaceSetSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceSetOnloading(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceSetOnloading(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetOnloadingdone(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceSetOnloadingdone(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetOnloadingerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceSetOnloadingerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetReady(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceSetStatus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceSetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceSetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFontFaceSetPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFontFaceSetPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFaceSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFaceSetPrototype>(vm.heap)) JSFontFaceSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFaceSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSFontFaceSet> JSFontFaceSetConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSFontFaceSetConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSFontFaceSetConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Vector<RefPtr<FontFace>> initialFaces = (toRefPtrNativeArray<FontFace, JSFontFace>(state, state->argument(0), &JSFontFace::toWrapped));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "FontFaceSet");
    auto& document = downcast<Document>(*context);
    RefPtr<FontFaceSet> object = FontFaceSet::create(*state, document, initialFaces);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSFontFaceSetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSFontFaceSetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFontFaceSet::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("FontFaceSet"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSFontFaceSetConstructor::s_info = { "FontFaceSet", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFaceSetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFontFaceSetPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetConstructor) } },
    { "size", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onloading", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloading) } },
    { "onloadingdone", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloadingdone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloadingdone) } },
    { "onloadingerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloadingerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloadingerror) } },
    { "ready", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetReady), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "status", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "entries", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionEntries), (intptr_t) (0) } },
    { "has", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionHas), (intptr_t) (1) } },
    { "keys", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionKeys), (intptr_t) (0) } },
    { "values", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionValues), (intptr_t) (0) } },
    { "add", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionAdd), (intptr_t) (1) } },
    { "delete", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionDelete), (intptr_t) (1) } },
    { "clear", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionClear), (intptr_t) (0) } },
    { "load", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionLoad), (intptr_t) (1) } },
    { "check", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFaceSetPrototypeFunctionCheck), (intptr_t) (1) } },
};

const ClassInfo JSFontFaceSetPrototype::s_info = { "FontFaceSetPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFaceSetPrototype) };

void JSFontFaceSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFaceSetPrototypeTableValues, *this);
}

const ClassInfo JSFontFaceSet::s_info = { "FontFaceSet", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFaceSet) };

JSFontFaceSet::JSFontFaceSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFaceSet>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFontFaceSet::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFontFaceSetPrototype::create(vm, globalObject, JSFontFaceSetPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSFontFaceSet::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFontFaceSet>(vm, globalObject);
}

EncodedJSValue jsFontFaceSetSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "size");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.size());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceSetOnloading(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "onloading");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadingEvent));
}


EncodedJSValue jsFontFaceSetOnloadingdone(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "onloadingdone");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadingdoneEvent));
}


EncodedJSValue jsFontFaceSetOnloadingerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "onloadingerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadingerrorEvent));
}


EncodedJSValue jsFontFaceSetReady(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "ready");
    }
    return JSValue::encode(castedThis->ready(*state));
}


EncodedJSValue jsFontFaceSetStatus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFaceSet*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFaceSet", "status");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.status());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceSetConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFontFaceSetPrototype* domObject = jsDynamicCast<JSFontFaceSetPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFontFaceSet::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFontFaceSetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFontFaceSetPrototype* domObject = jsDynamicCast<JSFontFaceSetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSFontFaceSetOnloading(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFaceSet* castedThis = jsDynamicCast<JSFontFaceSet*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFaceSet", "onloading");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadingEvent, value);
}


void setJSFontFaceSetOnloadingdone(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFaceSet* castedThis = jsDynamicCast<JSFontFaceSet*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFaceSet", "onloadingdone");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadingdoneEvent, value);
}


void setJSFontFaceSetOnloadingerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFaceSet* castedThis = jsDynamicCast<JSFontFaceSet*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFaceSet", "onloadingerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadingerrorEvent, value);
}


JSValue JSFontFaceSet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceSetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionEntries(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "entries");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    return JSValue::encode(castedThis->entries(*state));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionHas(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "has");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    FontFace* font = JSFontFace::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.has(font));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionKeys(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "keys");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    return JSValue::encode(castedThis->keys(*state));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionValues(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "values");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    return JSValue::encode(castedThis->values(*state));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionAdd(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "add");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    FontFace* font = JSFontFace::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.add(font)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionDelete(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "delete");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    FontFace* font = JSFontFace::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.remove(font));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionClear(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "clear");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    impl.clear();
    return JSValue::encode(jsUndefined());
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionLoadPromise(ExecState*, JSPromiseDeferred*);
EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionLoad(ExecState* state)
{
    return JSValue::encode(callPromiseFunction(*state, jsFontFaceSetPrototypeFunctionLoadPromise));
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionLoadPromise(ExecState* state, JSPromiseDeferred* promiseDeferred)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "load");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String font = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.load(font, DeferredWrapper(state, castedThis->globalObject(), promiseDeferred), ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    String text = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.load(font, text, DeferredWrapper(state, castedThis->globalObject(), promiseDeferred), ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionCheck(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFaceSet*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFaceSet", "check");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFaceSet::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String font = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = jsBoolean(impl.check(font, ec));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String text = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.check(font, text, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSFontFaceSet::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSFontFaceSet*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFaceSet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11FontFaceSetE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, FontFaceSet* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFontFaceSet>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, FontFaceSet* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFontFaceSet>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FontFaceSet@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11FontFaceSetE[2];
#if COMPILER(CLANG)
    // If this fails FontFaceSet does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FontFaceSet), FontFaceSet_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FontFaceSet has subclasses. If FontFaceSet has subclasses that get passed
    // to toJS() we currently require FontFaceSet you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSFontFaceSet>(globalObject, impl);
}

FontFaceSet* JSFontFaceSet::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFaceSet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
