/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameSetElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "URL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLFrameSetElementCols(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementCols(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementRows(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementRows(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLFrameSetElementOnbeforeunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnbeforeunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnhashchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnhashchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpagehide(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnpagehide(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpageshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnpageshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpopstate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnpopstate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnstorage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnstorage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnorientationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementOnorientationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLFrameSetElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLFrameSetElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLFrameSetElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLFrameSetElementPrototype>(vm.heap)) JSHTMLFrameSetElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLFrameSetElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLFrameSetElement> JSHTMLFrameSetElementConstructor;

template<> JSValue JSHTMLFrameSetElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLFrameSetElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLFrameSetElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLFrameSetElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLFrameSetElementConstructor::s_info = { "HTMLFrameSetElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLFrameSetElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLFrameSetElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementConstructor) } },
    { "cols", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementCols), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementCols) } },
    { "rows", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementRows), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementRows) } },
    { "onblur", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnblur) } },
    { "onerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnerror) } },
    { "onfocus", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocus) } },
    { "onfocusin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocusin) } },
    { "onfocusout", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocusout) } },
    { "onload", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnload) } },
    { "onresize", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnresize) } },
    { "onscroll", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnscroll) } },
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealbottom", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnwebkitwillrevealbottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnwebkitwillrevealbottom) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealleft", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnwebkitwillrevealleft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnwebkitwillrevealleft) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealright", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnwebkitwillrevealright), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnwebkitwillrevealright) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealtop", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnwebkitwillrevealtop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnwebkitwillrevealtop) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onbeforeunload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnbeforeunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnbeforeunload) } },
    { "onhashchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnhashchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnhashchange) } },
    { "onmessage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnmessage) } },
    { "onoffline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnoffline) } },
    { "ononline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnonline) } },
    { "onpagehide", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpagehide), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpagehide) } },
    { "onpageshow", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpageshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpageshow) } },
    { "onpopstate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpopstate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpopstate) } },
    { "onstorage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnstorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnstorage) } },
    { "onunload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnunload) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnorientationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnorientationchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLFrameSetElementPrototype::s_info = { "HTMLFrameSetElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLFrameSetElementPrototype) };

void JSHTMLFrameSetElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLFrameSetElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLFrameSetElement::s_info = { "HTMLFrameSetElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLFrameSetElement) };

JSHTMLFrameSetElement::JSHTMLFrameSetElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLFrameSetElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLFrameSetElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLFrameSetElementPrototype::create(vm, globalObject, JSHTMLFrameSetElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLFrameSetElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFrameSetElement>(vm, globalObject);
}

bool JSHTMLFrameSetElement::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(proto)->hasProperty(state, propertyName))
        return false;

    if (thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return false;
}

bool JSHTMLFrameSetElement::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsHTMLFrameSetElementCols(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "cols");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::colsAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLFrameSetElementRows(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "rows");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::rowsAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLFrameSetElementOnblur(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onblur");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().blurEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnfocus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onfocus");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnfocusin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onfocusin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusinEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnfocusout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onfocusout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusoutEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().loadEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnresize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onresize");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().resizeEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnscroll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onscroll");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().scrollEvent));
}


#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealbottom");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealleft");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealleftEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealright");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealrightEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLFrameSetElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealtop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealtopEvent));
}

#endif

EncodedJSValue jsHTMLFrameSetElementOnbeforeunload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onbeforeunload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().beforeunloadEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnhashchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onhashchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().hashchangeEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnmessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onmessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().messageEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnoffline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onoffline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().offlineEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnonline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "ononline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().onlineEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnpagehide(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onpagehide");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().pagehideEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnpageshow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onpageshow");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().pageshowEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnpopstate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onpopstate");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().popstateEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnstorage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onstorage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().storageEvent));
}


EncodedJSValue jsHTMLFrameSetElementOnunload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onunload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().unloadEvent));
}


#if ENABLE(ORIENTATION_EVENTS)
EncodedJSValue jsHTMLFrameSetElementOnorientationchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLFrameSetElement", "onorientationchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().orientationchangeEvent));
}

#endif

EncodedJSValue jsHTMLFrameSetElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLFrameSetElementPrototype* domObject = jsDynamicCast<JSHTMLFrameSetElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLFrameSetElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLFrameSetElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLFrameSetElementPrototype* domObject = jsDynamicCast<JSHTMLFrameSetElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLFrameSetElementCols(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "cols");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::colsAttr, nativeValue);
}


void setJSHTMLFrameSetElementRows(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "rows");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::rowsAttr, nativeValue);
}


void setJSHTMLFrameSetElementOnblur(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onblur");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().blurEvent, value);
}


void setJSHTMLFrameSetElementOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onerror");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSHTMLFrameSetElementOnfocus(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onfocus");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusEvent, value);
}


void setJSHTMLFrameSetElementOnfocusin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onfocusin");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusinEvent, value);
}


void setJSHTMLFrameSetElementOnfocusout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onfocusout");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusoutEvent, value);
}


void setJSHTMLFrameSetElementOnload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadEvent, value);
}


void setJSHTMLFrameSetElementOnresize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onresize");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resizeEvent, value);
}


void setJSHTMLFrameSetElementOnscroll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onscroll");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().scrollEvent, value);
}


#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLFrameSetElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealbottom");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLFrameSetElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealleft");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealleftEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLFrameSetElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealright");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealrightEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLFrameSetElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onwebkitwillrevealtop");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealtopEvent, value);
}

#endif

void setJSHTMLFrameSetElementOnbeforeunload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onbeforeunload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforeunloadEvent, value);
}


void setJSHTMLFrameSetElementOnhashchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onhashchange");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().hashchangeEvent, value);
}


void setJSHTMLFrameSetElementOnmessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onmessage");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().messageEvent, value);
}


void setJSHTMLFrameSetElementOnoffline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onoffline");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().offlineEvent, value);
}


void setJSHTMLFrameSetElementOnonline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "ononline");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().onlineEvent, value);
}


void setJSHTMLFrameSetElementOnpagehide(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onpagehide");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pagehideEvent, value);
}


void setJSHTMLFrameSetElementOnpageshow(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onpageshow");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pageshowEvent, value);
}


void setJSHTMLFrameSetElementOnpopstate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onpopstate");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().popstateEvent, value);
}


void setJSHTMLFrameSetElementOnstorage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onstorage");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().storageEvent, value);
}


void setJSHTMLFrameSetElementOnunload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onunload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().unloadEvent, value);
}


#if ENABLE(ORIENTATION_EVENTS)
void setJSHTMLFrameSetElementOnorientationchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLFrameSetElement* castedThis = jsDynamicCast<JSHTMLFrameSetElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLFrameSetElement", "onorientationchange");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().orientationchangeEvent, value);
}

#endif

JSValue JSHTMLFrameSetElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameSetElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLFrameSetElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
