/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableDataCellElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLTableDataCellElementAbbr(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableDataCellElementAbbr(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTableDataCellElementScope(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableDataCellElementScope(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTableDataCellElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableDataCellElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLTableDataCellElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLTableDataCellElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLTableDataCellElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLTableDataCellElementPrototype>(vm.heap)) JSHTMLTableDataCellElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLTableDataCellElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLTableDataCellElement> JSHTMLTableDataCellElementConstructor;

template<> JSValue JSHTMLTableDataCellElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLTableCellElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLTableDataCellElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLTableDataCellElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLTableDataCellElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLTableDataCellElementConstructor::s_info = { "HTMLTableDataCellElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableDataCellElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLTableDataCellElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableDataCellElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableDataCellElementConstructor) } },
    { "abbr", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableDataCellElementAbbr), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableDataCellElementAbbr) } },
    { "scope", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableDataCellElementScope), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableDataCellElementScope) } },
};

const ClassInfo JSHTMLTableDataCellElementPrototype::s_info = { "HTMLTableDataCellElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableDataCellElementPrototype) };

void JSHTMLTableDataCellElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLTableDataCellElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLTableDataCellElement::s_info = { "HTMLTableDataCellElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableDataCellElement) };

JSHTMLTableDataCellElement::JSHTMLTableDataCellElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLTableDataCellElement>&& impl)
    : JSHTMLTableCellElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLTableDataCellElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLTableDataCellElementPrototype::create(vm, globalObject, JSHTMLTableDataCellElementPrototype::createStructure(vm, globalObject, JSHTMLTableCellElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLTableDataCellElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableDataCellElement>(vm, globalObject);
}

EncodedJSValue jsHTMLTableDataCellElementAbbr(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLTableDataCellElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLTableDataCellElement", "abbr");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::abbrAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLTableDataCellElementScope(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLTableDataCellElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLTableDataCellElement", "scope");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::scopeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLTableDataCellElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLTableDataCellElementPrototype* domObject = jsDynamicCast<JSHTMLTableDataCellElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLTableDataCellElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLTableDataCellElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLTableDataCellElementPrototype* domObject = jsDynamicCast<JSHTMLTableDataCellElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLTableDataCellElementAbbr(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLTableDataCellElement* castedThis = jsDynamicCast<JSHTMLTableDataCellElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLTableDataCellElement", "abbr");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::abbrAttr, nativeValue);
}


void setJSHTMLTableDataCellElementScope(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLTableDataCellElement* castedThis = jsDynamicCast<JSHTMLTableDataCellElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLTableDataCellElement", "scope");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::scopeAttr, nativeValue);
}


JSValue JSHTMLTableDataCellElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableDataCellElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLTableDataCellElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLTableDataCellElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
